/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.validation;

import net.pterodactylus.util.validation.Validator;

public class IntegerRangeValidator
implements Validator<Integer> {
    private final int lowerBound;
    private final int upperBound;

    public IntegerRangeValidator(int lowerBound, int upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Override
    public boolean validate(Integer value) {
        return this.lowerBound <= value && this.upperBound >= value;
    }

    public String toString() {
        return "((x >= " + this.lowerBound + ") && (x <= " + this.upperBound + "))";
    }
}

