/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class NamedThreadFactory
implements ThreadFactory {
    private static final AtomicInteger threadFactoryCounter = new AtomicInteger();
    private final int threadFactoryNumber;
    private final AtomicLong threadCounter = new AtomicLong();
    private final String nameFormat;

    public NamedThreadFactory(String nameFormat) {
        this.threadFactoryNumber = threadFactoryCounter.getAndIncrement();
        this.nameFormat = nameFormat;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        return new Thread(runnable, String.format(this.nameFormat, this.threadFactoryNumber, this.threadCounter.getAndIncrement()));
    }
}

