/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.text;

public class SimpleStringEscaper {
    public static String escapeString(String string) {
        return string.replace("\\", "\\\\").replace("\r", "\\r").replace("\n", "\\n").replace("\u0000", "\\0");
    }

    public static String unescapeString(String string) {
        StringBuilder unescapedString = new StringBuilder();
        boolean backslash = false;
        for (char c : string.toCharArray()) {
            if (backslash) {
                if (c == 'r') {
                    unescapedString.append('\r');
                } else if (c == 'n') {
                    unescapedString.append('\n');
                } else if (c == '0') {
                    unescapedString.append('\u0000');
                } else {
                    unescapedString.append(c);
                }
                backslash = false;
                continue;
            }
            if (c == '\\') {
                backslash = true;
                continue;
            }
            unescapedString.append(c);
        }
        return unescapedString.toString();
    }
}

