/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.pterodactylus.util.template.Accessor;
import net.pterodactylus.util.template.Filter;
import net.pterodactylus.util.template.Plugin;
import net.pterodactylus.util.template.Template;
import net.pterodactylus.util.template.TemplateException;
import net.pterodactylus.util.template.TemplateProvider;

public class TemplateContext {
    private final Map<Class<?>, Accessor> accessors = Collections.synchronizedMap(new HashMap());
    private final Map<String, Filter> filters = Collections.synchronizedMap(new HashMap());
    private final Map<String, Plugin> plugins = Collections.synchronizedMap(new HashMap());
    private final List<TemplateProvider> templateProviders = Collections.synchronizedList(new ArrayList());
    private final Map<String, Object> objects = Collections.synchronizedMap(new HashMap());
    private final TemplateContext parentContext;
    private final boolean temporary;
    private final List<TemplateContext> mergedContexts = new ArrayList<TemplateContext>();

    public TemplateContext() {
        this(null);
    }

    public TemplateContext(TemplateContext parentContext) {
        this(parentContext, false);
    }

    public TemplateContext(TemplateContext parentContext, boolean temporary) {
        this.parentContext = parentContext;
        this.temporary = temporary;
        this.accessors.put(Map.class, Accessor.MAP_ACCESSOR);
    }

    public TemplateContext addAccessor(Class<?> clazz, Accessor accessor) {
        this.accessors.put(clazz, accessor);
        return this;
    }

    public TemplateContext addFilter(String name, Filter filter) {
        this.filters.put(name, filter);
        return this;
    }

    public TemplateContext addPlugin(String name, Plugin plugin) {
        this.plugins.put(name, plugin);
        return this;
    }

    @Deprecated
    public TemplateContext addProvider(TemplateProvider templateProvider) {
        return this.addTemplateProvider(templateProvider);
    }

    public TemplateContext addTemplateProvider(TemplateProvider templateProvider) {
        this.templateProviders.add(templateProvider);
        return this;
    }

    public Accessor getAccessor(Class<?> clazz) {
        Accessor accessor = null;
        for (TemplateContext context : this.getAllTemplateContexts()) {
            block1: for (Class<?> classToCheck = clazz; classToCheck != null && accessor == null; classToCheck = classToCheck.getSuperclass()) {
                if (context.accessors.containsKey(classToCheck)) {
                    accessor = context.accessors.get(classToCheck);
                    break;
                }
                ArrayList interfaceClasses = new ArrayList();
                interfaceClasses.addAll(Arrays.asList(classToCheck.getInterfaces()));
                for (int interfaceIndex = 0; interfaceIndex < interfaceClasses.size(); ++interfaceIndex) {
                    if (context.accessors.containsKey(interfaceClasses.get(interfaceIndex))) {
                        accessor = context.accessors.get(interfaceClasses.get(interfaceIndex));
                        continue block1;
                    }
                    interfaceClasses.addAll(Arrays.asList(((Class)interfaceClasses.get(interfaceIndex)).getInterfaces()));
                }
            }
            if (accessor == null) continue;
            break;
        }
        return accessor;
    }

    public Filter getFilter(String name) {
        Filter filter = null;
        for (TemplateContext context : this.getAllTemplateContexts()) {
            filter = context.filters.get(name);
            if (filter == null) continue;
            break;
        }
        return filter;
    }

    public Plugin getPlugin(String name) {
        Plugin plugin = null;
        for (TemplateContext context : this.getAllTemplateContexts()) {
            plugin = context.plugins.get(name);
            if (plugin == null) continue;
            break;
        }
        return plugin;
    }

    public Object get(String name) {
        if (name == null) {
            return null;
        }
        StringTokenizer nameTokens = new StringTokenizer(name, ".");
        Object object = null;
        while (nameTokens.hasMoreTokens()) {
            String nameToken = nameTokens.nextToken();
            if (object == null) {
                for (TemplateContext context : this.getAllTemplateContexts()) {
                    object = context.objects.get(nameToken);
                    if (object == null) continue;
                    break;
                }
            } else {
                Accessor accessor = this.getAccessor(object.getClass());
                if (accessor != null) {
                    object = accessor.get(this, object, nameToken);
                } else {
                    throw new TemplateException(0, 0, "no accessor found for " + object.getClass());
                }
            }
            if (object != null) continue;
            return null;
        }
        return object;
    }

    public <T> T get(String name, Class<?> requestedClass) {
        Object value = this.get(name);
        if (value == null) {
            return null;
        }
        if (requestedClass.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        return null;
    }

    public void set(String name, Object value) {
        this.objects.put(name, value);
        if (this.temporary && this.parentContext != null) {
            this.parentContext.set(name, value);
        }
    }

    public void set(String name, Object value, boolean setInParent) {
        this.objects.put(name, value);
        if (this.temporary && this.parentContext != null) {
            this.parentContext.set(name, value, setInParent);
        } else if (setInParent && this.parentContext != null) {
            this.parentContext.set(name, value);
        }
    }

    public Template getTemplate(String name) {
        Template template = null;
        for (TemplateContext context : this.getAllTemplateContexts()) {
            TemplateProvider templateProvider;
            Iterator<TemplateProvider> iterator = context.templateProviders.iterator();
            while (iterator.hasNext() && (template = (templateProvider = iterator.next()).getTemplate(this, name)) == null) {
            }
            if (template == null) continue;
            break;
        }
        return template;
    }

    public TemplateContext mergeContext(TemplateContext templateContext) {
        this.mergedContexts.add(0, templateContext);
        return this;
    }

    private List<TemplateContext> getAllTemplateContexts() {
        ArrayList<TemplateContext> allTemplateContexts = new ArrayList<TemplateContext>();
        for (TemplateContext mergedContext : this.mergedContexts) {
            allTemplateContexts.addAll(mergedContext.getAllTemplateContexts());
        }
        allTemplateContexts.add(this);
        TemplateContext currentTemplateContext = this.parentContext;
        while (currentTemplateContext != null) {
            allTemplateContexts.addAll(currentTemplateContext.getAllTemplateContexts());
            currentTemplateContext = currentTemplateContext.parentContext;
        }
        return allTemplateContexts;
    }
}

