/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.template;

import java.io.Writer;
import java.util.Map;
import net.pterodactylus.util.template.AbstractPart;
import net.pterodactylus.util.template.Plugin;
import net.pterodactylus.util.template.TemplateContext;
import net.pterodactylus.util.template.TemplateException;

class PluginPart
extends AbstractPart {
    private final String pluginName;
    private final Map<String, String> pluginParameters;

    public PluginPart(int line, int column, String pluginName, Map<String, String> pluginParameters) {
        super(line, column);
        this.pluginName = pluginName;
        this.pluginParameters = pluginParameters;
    }

    @Override
    public void render(TemplateContext templateContext, Writer writer) throws TemplateException {
        Plugin plugin = templateContext.getPlugin(this.pluginName);
        if (plugin == null) {
            throw new TemplateException(this.getLine(), this.getColumn(), "Plugin \u201c" + this.pluginName + "\u201d not found.");
        }
        plugin.execute(templateContext, this.pluginParameters);
    }
}

