/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.template;

import java.util.HashMap;
import java.util.Map;
import net.pterodactylus.util.template.Filter;
import net.pterodactylus.util.template.TemplateContext;

public class HtmlFilter
implements Filter {
    private static final Map<Character, String> htmlEntities = new HashMap<Character, String>();

    @Override
    public String format(TemplateContext templateContext, Object data, Map<String, Object> parameters) {
        StringBuilder htmlOutput = new StringBuilder();
        for (char c : data != null ? String.valueOf(data).toCharArray() : new char[]{}) {
            if (htmlEntities.containsKey(Character.valueOf(c))) {
                htmlOutput.append('&').append(htmlEntities.get(Character.valueOf(c))).append(';');
                continue;
            }
            htmlOutput.append(c);
        }
        return htmlOutput.toString();
    }

    static {
        htmlEntities.put(Character.valueOf('\u00c2'), "Acirc");
        htmlEntities.put(Character.valueOf('\u00e2'), "acirc");
        htmlEntities.put(Character.valueOf('\u00b4'), "acute");
        htmlEntities.put(Character.valueOf('\u00c6'), "AElig");
        htmlEntities.put(Character.valueOf('\u00e6'), "aelig");
        htmlEntities.put(Character.valueOf('\u00c0'), "Agrave");
        htmlEntities.put(Character.valueOf('\u00e0'), "agrave");
        htmlEntities.put(Character.valueOf('\u2135'), "alefsym");
        htmlEntities.put(Character.valueOf('\u0391'), "alpha");
        htmlEntities.put(Character.valueOf('\u03b1'), "alpha");
        htmlEntities.put(Character.valueOf('&'), "amp");
        htmlEntities.put(Character.valueOf('\u2227'), "and");
        htmlEntities.put(Character.valueOf('\u2220'), "ang");
        htmlEntities.put(Character.valueOf('\''), "apos");
        htmlEntities.put(Character.valueOf('\u00c5'), "Aring");
        htmlEntities.put(Character.valueOf('\u00e5'), "aring");
        htmlEntities.put(Character.valueOf('\u2248'), "asymp");
        htmlEntities.put(Character.valueOf('\u00c3'), "Atilde");
        htmlEntities.put(Character.valueOf('\u00e3'), "atilde");
        htmlEntities.put(Character.valueOf('\u00c4'), "Auml");
        htmlEntities.put(Character.valueOf('\u00e4'), "auml");
        htmlEntities.put(Character.valueOf('\u201e'), "bdquo");
        htmlEntities.put(Character.valueOf('\u0392'), "Beta");
        htmlEntities.put(Character.valueOf('\u03b2'), "beta");
        htmlEntities.put(Character.valueOf('\u00a6'), "brvbar");
        htmlEntities.put(Character.valueOf('\u2022'), "bull");
        htmlEntities.put(Character.valueOf('\u2229'), "cap");
        htmlEntities.put(Character.valueOf('\u00c7'), "Ccedil");
        htmlEntities.put(Character.valueOf('\u00e7'), "ccedil");
        htmlEntities.put(Character.valueOf('\u00b8'), "cedil");
        htmlEntities.put(Character.valueOf('\u00a2'), "cent");
        htmlEntities.put(Character.valueOf('\u03a7'), "Chi");
        htmlEntities.put(Character.valueOf('\u03c7'), "chi");
        htmlEntities.put(Character.valueOf('\u02c6'), "circ");
        htmlEntities.put(Character.valueOf('\u2663'), "clubs");
        htmlEntities.put(Character.valueOf('\u2245'), "cong");
        htmlEntities.put(Character.valueOf('\u00a9'), "copy");
        htmlEntities.put(Character.valueOf('\u21b5'), "crarr");
        htmlEntities.put(Character.valueOf('\u222a'), "cup");
        htmlEntities.put(Character.valueOf('\u00a4'), "curren");
        htmlEntities.put(Character.valueOf('\u2021'), "Dagger");
        htmlEntities.put(Character.valueOf('\u2020'), "dagger");
        htmlEntities.put(Character.valueOf('\u21d3'), "dArr");
        htmlEntities.put(Character.valueOf('\u2193'), "darr");
        htmlEntities.put(Character.valueOf('\u00b0'), "deg");
        htmlEntities.put(Character.valueOf('\u0394'), "Delta");
        htmlEntities.put(Character.valueOf('\u03b4'), "delta");
        htmlEntities.put(Character.valueOf('\u2666'), "diams");
        htmlEntities.put(Character.valueOf('\u00f7'), "divide");
        htmlEntities.put(Character.valueOf('\u00c9'), "Eacute");
        htmlEntities.put(Character.valueOf('\u00e9'), "eacute");
        htmlEntities.put(Character.valueOf('\u00ca'), "Ecirc");
        htmlEntities.put(Character.valueOf('\u00ea'), "ecirc");
        htmlEntities.put(Character.valueOf('\u00c8'), "Egrave");
        htmlEntities.put(Character.valueOf('\u00e8'), "egrave");
        htmlEntities.put(Character.valueOf('\u2205'), "empty");
        htmlEntities.put(Character.valueOf('\u2003'), "emsp");
        htmlEntities.put(Character.valueOf('\u2002'), "ensp");
        htmlEntities.put(Character.valueOf('\u0395'), "Epsilon");
        htmlEntities.put(Character.valueOf('\u03b5'), "epsilon");
        htmlEntities.put(Character.valueOf('\u2261'), "equiv");
        htmlEntities.put(Character.valueOf('\u0397'), "Eta");
        htmlEntities.put(Character.valueOf('\u03b7'), "eta");
        htmlEntities.put(Character.valueOf('\u00d0'), "ETH");
        htmlEntities.put(Character.valueOf('\u00f0'), "eth");
        htmlEntities.put(Character.valueOf('\u00cb'), "Euml");
        htmlEntities.put(Character.valueOf('\u00eb'), "euml");
        htmlEntities.put(Character.valueOf('\u20ac'), "euro");
        htmlEntities.put(Character.valueOf('\u2203'), "exist");
        htmlEntities.put(Character.valueOf('\u0192'), "fnof");
        htmlEntities.put(Character.valueOf('\u2200'), "forall");
        htmlEntities.put(Character.valueOf('\u00bd'), "frac12");
        htmlEntities.put(Character.valueOf('\u00bc'), "frac14");
        htmlEntities.put(Character.valueOf('\u00be'), "frac34");
        htmlEntities.put(Character.valueOf('\u2044'), "frasl");
        htmlEntities.put(Character.valueOf('\u0393'), "Gamma");
        htmlEntities.put(Character.valueOf('\u03b3'), "gamma");
        htmlEntities.put(Character.valueOf('\u2265'), "ge");
        htmlEntities.put(Character.valueOf('>'), "gt");
        htmlEntities.put(Character.valueOf('\u21d4'), "hArr");
        htmlEntities.put(Character.valueOf('\u2194'), "harr");
        htmlEntities.put(Character.valueOf('\u2665'), "hearts");
        htmlEntities.put(Character.valueOf('\u2026'), "hellip");
        htmlEntities.put(Character.valueOf('\u00cd'), "Iacute");
        htmlEntities.put(Character.valueOf('\u00ed'), "iacute");
        htmlEntities.put(Character.valueOf('\u00ce'), "Icirc");
        htmlEntities.put(Character.valueOf('\u00ee'), "icirc");
        htmlEntities.put(Character.valueOf('\u00a1'), "iexcl");
        htmlEntities.put(Character.valueOf('\u00cc'), "Igrave");
        htmlEntities.put(Character.valueOf('\u00ec'), "igrave");
        htmlEntities.put(Character.valueOf('\u2111'), "image");
        htmlEntities.put(Character.valueOf('\u221e'), "infin");
        htmlEntities.put(Character.valueOf('\u222b'), "int");
        htmlEntities.put(Character.valueOf('\u0399'), "Iota");
        htmlEntities.put(Character.valueOf('\u03b9'), "iota");
        htmlEntities.put(Character.valueOf('\u00bf'), "iquest");
        htmlEntities.put(Character.valueOf('\u2208'), "isin");
        htmlEntities.put(Character.valueOf('\u00cf'), "Iuml");
        htmlEntities.put(Character.valueOf('\u00ef'), "iuml");
        htmlEntities.put(Character.valueOf('\u039a'), "Kappa");
        htmlEntities.put(Character.valueOf('\u03ba'), "kappa");
        htmlEntities.put(Character.valueOf('\u039b'), "Lambda");
        htmlEntities.put(Character.valueOf('\u03bb'), "lambda");
        htmlEntities.put(Character.valueOf('\u2329'), "lang");
        htmlEntities.put(Character.valueOf('\u00ab'), "laquo");
        htmlEntities.put(Character.valueOf('\u21d0'), "lArr");
        htmlEntities.put(Character.valueOf('\u2190'), "larr");
        htmlEntities.put(Character.valueOf('\u2308'), "lceil");
        htmlEntities.put(Character.valueOf('\u201c'), "ldquo");
        htmlEntities.put(Character.valueOf('\u2264'), "le");
        htmlEntities.put(Character.valueOf('\u230a'), "lfloor");
        htmlEntities.put(Character.valueOf('\u2217'), "lowast");
        htmlEntities.put(Character.valueOf('\u25ca'), "loz");
        htmlEntities.put(Character.valueOf('\u200e'), "lrm");
        htmlEntities.put(Character.valueOf('\u2039'), "lsaquo");
        htmlEntities.put(Character.valueOf('\u2018'), "lsquo");
        htmlEntities.put(Character.valueOf('<'), "lt");
        htmlEntities.put(Character.valueOf('\u00af'), "macr");
        htmlEntities.put(Character.valueOf('\u2014'), "mdash");
        htmlEntities.put(Character.valueOf('\u00b5'), "micro");
        htmlEntities.put(Character.valueOf('\u00b7'), "middot");
        htmlEntities.put(Character.valueOf('\u2212'), "minus");
        htmlEntities.put(Character.valueOf('\u039c'), "Mu");
        htmlEntities.put(Character.valueOf('\u03bc'), "mu");
        htmlEntities.put(Character.valueOf('\u2207'), "nabla");
        htmlEntities.put(Character.valueOf('\u00a0'), "nbsp");
        htmlEntities.put(Character.valueOf('\u2013'), "ndash");
        htmlEntities.put(Character.valueOf('\u2260'), "ne");
        htmlEntities.put(Character.valueOf('\u220b'), "ni");
        htmlEntities.put(Character.valueOf('\u00ac'), "not");
        htmlEntities.put(Character.valueOf('\u2209'), "notin");
        htmlEntities.put(Character.valueOf('\u2284'), "nsub");
        htmlEntities.put(Character.valueOf('\u00d1'), "Ntilde");
        htmlEntities.put(Character.valueOf('\u00f1'), "ntilde");
        htmlEntities.put(Character.valueOf('\u039d'), "Nu");
        htmlEntities.put(Character.valueOf('\u03bd'), "nu");
        htmlEntities.put(Character.valueOf('\u00d3'), "Oacute");
        htmlEntities.put(Character.valueOf('\u00f3'), "oacute");
        htmlEntities.put(Character.valueOf('\u00d4'), "Ocirc");
        htmlEntities.put(Character.valueOf('\u00f4'), "ocirc");
        htmlEntities.put(Character.valueOf('\u0152'), "OElig");
        htmlEntities.put(Character.valueOf('\u0153'), "oelig");
        htmlEntities.put(Character.valueOf('\u00d2'), "Ograve");
        htmlEntities.put(Character.valueOf('\u00f2'), "ograve");
        htmlEntities.put(Character.valueOf('\u203e'), "oline");
        htmlEntities.put(Character.valueOf('\u03a9'), "Omega");
        htmlEntities.put(Character.valueOf('\u03c9'), "omega");
        htmlEntities.put(Character.valueOf('\u039f'), "Omicron");
        htmlEntities.put(Character.valueOf('\u03bf'), "omicron");
        htmlEntities.put(Character.valueOf('\u2295'), "oplus");
        htmlEntities.put(Character.valueOf('\u2228'), "or");
        htmlEntities.put(Character.valueOf('\u00aa'), "ordf");
        htmlEntities.put(Character.valueOf('\u00ba'), "ordm");
        htmlEntities.put(Character.valueOf('\u00d8'), "Oslash");
        htmlEntities.put(Character.valueOf('\u00f8'), "oslash");
        htmlEntities.put(Character.valueOf('\u00d5'), "Otilde");
        htmlEntities.put(Character.valueOf('\u00f5'), "otilde");
        htmlEntities.put(Character.valueOf('\u2297'), "otimes");
        htmlEntities.put(Character.valueOf('\u00d6'), "Ouml");
        htmlEntities.put(Character.valueOf('\u00f6'), "ouml");
        htmlEntities.put(Character.valueOf('\u00b6'), "para");
        htmlEntities.put(Character.valueOf('\u2202'), "part");
        htmlEntities.put(Character.valueOf('\u2030'), "permil");
        htmlEntities.put(Character.valueOf('\u22a5'), "perp");
        htmlEntities.put(Character.valueOf('\u03a6'), "Phi");
        htmlEntities.put(Character.valueOf('\u03c6'), "phi");
        htmlEntities.put(Character.valueOf('\u03a0'), "pi");
        htmlEntities.put(Character.valueOf('\u03c0'), "pi");
        htmlEntities.put(Character.valueOf('\u03d6'), "piv");
        htmlEntities.put(Character.valueOf('\u00b1'), "plusmn");
        htmlEntities.put(Character.valueOf('\u00a3'), "pound");
        htmlEntities.put(Character.valueOf('\u2033'), "Prime");
        htmlEntities.put(Character.valueOf('\u2032'), "prime");
        htmlEntities.put(Character.valueOf('\u220f'), "prod");
        htmlEntities.put(Character.valueOf('\u221d'), "prop");
        htmlEntities.put(Character.valueOf('\u03a8'), "Psi");
        htmlEntities.put(Character.valueOf('\u03c8'), "psi");
        htmlEntities.put(Character.valueOf('\"'), "quot");
        htmlEntities.put(Character.valueOf('\u221a'), "radic");
        htmlEntities.put(Character.valueOf('\u232a'), "rang");
        htmlEntities.put(Character.valueOf('\u00bb'), "raquo");
        htmlEntities.put(Character.valueOf('\u21d2'), "rArr");
        htmlEntities.put(Character.valueOf('\u2192'), "rarr");
        htmlEntities.put(Character.valueOf('\u2309'), "rceil");
        htmlEntities.put(Character.valueOf('\u201d'), "rdquo");
        htmlEntities.put(Character.valueOf('\u211c'), "real");
        htmlEntities.put(Character.valueOf('\u00ae'), "reg");
        htmlEntities.put(Character.valueOf('\u230b'), "rfloor");
        htmlEntities.put(Character.valueOf('\u03a1'), "Rho");
        htmlEntities.put(Character.valueOf('\u03c1'), "rho");
        htmlEntities.put(Character.valueOf('\u200f'), "rlm");
        htmlEntities.put(Character.valueOf('\u203a'), "rsaquo");
        htmlEntities.put(Character.valueOf('\u2019'), "rsquo");
        htmlEntities.put(Character.valueOf('\u201a'), "sbquo");
        htmlEntities.put(Character.valueOf('\u0160'), "Scaron");
        htmlEntities.put(Character.valueOf('\u0161'), "scaron");
        htmlEntities.put(Character.valueOf('\u22c5'), "sdot");
        htmlEntities.put(Character.valueOf('\u00a7'), "sect");
        htmlEntities.put(Character.valueOf('\u00ad'), "shy");
        htmlEntities.put(Character.valueOf('\u03a3'), "Sigma");
        htmlEntities.put(Character.valueOf('\u03c3'), "sigma");
        htmlEntities.put(Character.valueOf('\u03c2'), "sigmaf");
        htmlEntities.put(Character.valueOf('\u223c'), "sim");
        htmlEntities.put(Character.valueOf('\u2660'), "spades");
        htmlEntities.put(Character.valueOf('\u2282'), "sub");
        htmlEntities.put(Character.valueOf('\u2286'), "sube");
        htmlEntities.put(Character.valueOf('\u2211'), "sum");
        htmlEntities.put(Character.valueOf('\u2283'), "sup");
        htmlEntities.put(Character.valueOf('\u00b9'), "sup1");
        htmlEntities.put(Character.valueOf('\u00b2'), "sup2");
        htmlEntities.put(Character.valueOf('\u00b3'), "sup3");
        htmlEntities.put(Character.valueOf('\u2287'), "supe");
        htmlEntities.put(Character.valueOf('\u00df'), "szlig");
        htmlEntities.put(Character.valueOf('\u03a4'), "Tau");
        htmlEntities.put(Character.valueOf('\u03c4'), "tau");
        htmlEntities.put(Character.valueOf('\u2234'), "there4");
        htmlEntities.put(Character.valueOf('\u0398'), "Theta");
        htmlEntities.put(Character.valueOf('\u03b8'), "theta");
        htmlEntities.put(Character.valueOf('\u03d1'), "thetasym");
        htmlEntities.put(Character.valueOf('\u2009'), "thinsp");
        htmlEntities.put(Character.valueOf('\u00de'), "THORN");
        htmlEntities.put(Character.valueOf('\u00fe'), "thorn");
        htmlEntities.put(Character.valueOf('\u02dc'), "tilde");
        htmlEntities.put(Character.valueOf('\u00d7'), "times");
        htmlEntities.put(Character.valueOf('\u2122'), "trade");
        htmlEntities.put(Character.valueOf('\u00da'), "Uacute");
        htmlEntities.put(Character.valueOf('\u00fa'), "uacute");
        htmlEntities.put(Character.valueOf('\u21d1'), "uArr");
        htmlEntities.put(Character.valueOf('\u2191'), "uarr");
        htmlEntities.put(Character.valueOf('\u00db'), "Ucirc");
        htmlEntities.put(Character.valueOf('\u00fb'), "ucirc");
        htmlEntities.put(Character.valueOf('\u00d9'), "Ugrave");
        htmlEntities.put(Character.valueOf('\u00f9'), "ugrave");
        htmlEntities.put(Character.valueOf('\u00a8'), "uml");
        htmlEntities.put(Character.valueOf('\u03d2'), "upsih");
        htmlEntities.put(Character.valueOf('\u03a5'), "Upsilon");
        htmlEntities.put(Character.valueOf('\u03c5'), "upsilon");
        htmlEntities.put(Character.valueOf('\u00dc'), "Uuml");
        htmlEntities.put(Character.valueOf('\u00fc'), "uuml");
        htmlEntities.put(Character.valueOf('\u2118'), "weierp");
        htmlEntities.put(Character.valueOf('\u039e'), "Xi");
        htmlEntities.put(Character.valueOf('\u03be'), "xi");
        htmlEntities.put(Character.valueOf('\u00dd'), "Yacute");
        htmlEntities.put(Character.valueOf('\u00fd'), "yacute");
        htmlEntities.put(Character.valueOf('\u00a5'), "yen");
        htmlEntities.put(Character.valueOf('\u0178'), "Yuml");
        htmlEntities.put(Character.valueOf('\u00ff'), "yuml");
        htmlEntities.put(Character.valueOf('\u0396'), "Zeta");
        htmlEntities.put(Character.valueOf('\u03b6'), "zeta");
        htmlEntities.put(Character.valueOf('\u200d'), "zwj");
        htmlEntities.put(Character.valueOf('\u200c'), "zwnj");
    }
}

