/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.template;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import net.pterodactylus.util.template.Filter;
import net.pterodactylus.util.template.TemplateContext;

public class DateFilter
implements Filter {
    private static final Map<String, DateFormat> dateFormats = new HashMap<String, DateFormat>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object format(TemplateContext templateContext, Object data, Map<String, Object> parameters) {
        DateFormat dateFormat;
        String timezoneName;
        String format = String.valueOf(parameters.get("format"));
        TimeZone timezone = TimeZone.getDefault();
        String string = timezoneName = parameters.get("timezone") == null ? null : String.valueOf(parameters.get("timezone"));
        if (timezoneName != null) {
            Object timezoneObject = templateContext.get(timezoneName);
            if (timezoneObject == null) {
                timezone = TimeZone.getTimeZone(timezoneName);
            } else if (timezoneObject instanceof TimeZone) {
                timezone = (TimeZone)timezoneObject;
            } else if (timezoneObject instanceof String) {
                timezone = TimeZone.getTimeZone((String)timezoneObject);
            }
        }
        DateFormat dateFormat2 = dateFormat = this.getDateFormat(format);
        synchronized (dateFormat2) {
            dateFormat.setTimeZone(timezone);
            if (data instanceof Date) {
                return dateFormat.format((Date)data);
            }
            if (data instanceof Long) {
                return dateFormat.format(new Date((Long)data));
            }
            return data;
        }
    }

    private DateFormat getDateFormat(String format) {
        if (format == null || format.trim().length() == 0) {
            return DateFormat.getInstance();
        }
        DateFormat dateFormat = dateFormats.get(format);
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat(format);
            dateFormats.put(format, dateFormat);
        }
        return dateFormat;
    }
}

