/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.telnet;

import java.util.ArrayList;
import java.util.List;
import net.pterodactylus.util.number.Digits;
import net.pterodactylus.util.number.SI;
import net.pterodactylus.util.telnet.AbstractCommand;
import net.pterodactylus.util.telnet.Command;

public class MemoryCommand
extends AbstractCommand {
    public MemoryCommand() {
        super("MEMORY", "Shows memory statistics.");
    }

    @Override
    public Command.Reply execute(List<String> parameters) {
        long freeMemory = Runtime.getRuntime().freeMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long maxMemory = Runtime.getRuntime().maxMemory();
        long usedMemory = totalMemory - freeMemory;
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Used Memory: " + SI.format(usedMemory, 1, true, true) + "B");
        lines.add("Reversed Memory: " + SI.format(totalMemory, 1, true, true) + "B, " + Digits.formatFractions((double)usedMemory * 100.0 / (double)totalMemory, 1, false) + "% used");
        lines.add("Maximum Memory: " + SI.format(maxMemory, 1, true, true) + "B, " + Digits.formatFractions((double)usedMemory * 100.0 / (double)maxMemory, 1, false) + "% used");
        return new Command.Reply(200, lines);
    }
}

