/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.storage;

import net.pterodactylus.util.storage.Factory;
import net.pterodactylus.util.storage.Storable;

public class Allocation
implements Storable {
    public static final Factory<Allocation> FACTORY = new AllocationFactory();
    private final long id;
    private final int position;
    private final int size;

    public Allocation(long id, int position, int size) {
        this.id = id;
        this.position = position;
        this.size = size;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public int getPosition() {
        return this.position;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public byte[] getBuffer() {
        byte[] buffer = new byte[16];
        Storable.Utils.putLong(this.id, buffer, 0);
        Storable.Utils.putInt(this.position, buffer, 8);
        Storable.Utils.putInt(this.size, buffer, 12);
        return buffer;
    }

    public String toString() {
        return String.format("%s[id=%d,position=%d,size=%d]", this.getClass().getName(), this.id, this.position, this.size);
    }

    public static class AllocationFactory
    implements Factory<Allocation> {
        @Override
        public Allocation restore(byte[] buffer) {
            return new Allocation(Storable.Utils.getLong(buffer, 0), Storable.Utils.getInt(buffer, 8), Storable.Utils.getInt(buffer, 12));
        }
    }
}

