/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.number;

import net.pterodactylus.util.number.Digits;

public class SI {
    private static final String[] units = new String[]{"", "K", "M", "G", "T", "P", "E", "Z", "Y"};

    public static String format(long number) {
        return SI.format(number, false, false);
    }

    public static String formatBinary(long number) {
        return SI.format(number, true, false);
    }

    public static String format(long number, boolean useBinaryUnits) {
        return SI.format(number, 0, useBinaryUnits, false);
    }

    public static String format(long number, boolean useBinaryUnits, boolean addSpace) {
        return SI.format(number, 0, useBinaryUnits, addSpace);
    }

    public static String format(long number, int digits, boolean useBinaryUnits, boolean addSpace) {
        int unit;
        double realNumber = number;
        for (unit = 0; unit < units.length; ++unit) {
            int n = useBinaryUnits ? 1024 : 1000;
            if (!(realNumber >= (double)n)) break;
            realNumber /= (double)(useBinaryUnits ? 1024 : 1000);
        }
        return Digits.formatFractions(realNumber, digits, false) + (addSpace ? " " : "") + units[unit] + (useBinaryUnits && unit > 0 ? "i" : "");
    }
}

