/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.notify;

import java.io.IOException;
import java.io.Writer;
import net.pterodactylus.util.notify.AbstractNotification;
import net.pterodactylus.util.template.Part;
import net.pterodactylus.util.template.Template;
import net.pterodactylus.util.template.TemplateContext;
import net.pterodactylus.util.template.TemplateException;

public class TemplateNotification
extends AbstractNotification
implements Part {
    private final Template template;
    private final TemplateContext mergeContext;

    public TemplateNotification(Template template) {
        this.template = template;
        this.mergeContext = new TemplateContext(template.getInitialContext());
    }

    public TemplateNotification(String id, Template template) {
        super(id);
        this.template = template;
        this.mergeContext = new TemplateContext(template.getInitialContext());
    }

    public TemplateNotification(String id, long creationTime, long lastUpdatedTime, boolean dismissable, Template template) {
        super(id, creationTime, lastUpdatedTime, dismissable);
        this.template = template;
        this.mergeContext = new TemplateContext(template.getInitialContext());
    }

    public TemplateContext getTemplateContext() {
        return new TemplateContext(this.template.getInitialContext());
    }

    protected Template getTemplate() {
        return this.template;
    }

    public TemplateNotification set(String name, Object value) {
        this.mergeContext.set(name, value);
        this.touch();
        return this;
    }

    public Object get(String name) {
        return this.mergeContext.get(name);
    }

    @Override
    public void render(Writer writer) throws IOException {
        this.template.render(this.mergeContext, writer);
    }

    @Override
    public void render(TemplateContext templateContext, Writer writer) throws TemplateException {
        this.template.render(new TemplateContext().mergeContext(templateContext).mergeContext(this.template.getInitialContext()).mergeContext(this.mergeContext), writer);
    }
}

