/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.notify;

import java.util.UUID;
import net.pterodactylus.util.notify.Notification;
import net.pterodactylus.util.notify.NotificationListener;
import net.pterodactylus.util.notify.NotificationListenerManager;

public abstract class AbstractNotification
implements Notification {
    private final NotificationListenerManager notificationListenerManager = new NotificationListenerManager(this);
    private final String id;
    private final long createdTime;
    private volatile long lastUpdatedTime;
    private volatile boolean dismissable;

    public AbstractNotification() {
        this(UUID.randomUUID().toString());
    }

    public AbstractNotification(String id) {
        this(id, System.currentTimeMillis());
    }

    public AbstractNotification(String id, long createdTime) {
        this(id, createdTime, createdTime);
    }

    public AbstractNotification(String id, long createdTime, long lastUpdatedTime) {
        this(id, createdTime, lastUpdatedTime, true);
    }

    public AbstractNotification(String id, long createdTime, long lastUpdatedTime, boolean dismissable) {
        this.id = id;
        this.createdTime = createdTime;
        this.lastUpdatedTime = lastUpdatedTime;
        this.dismissable = dismissable;
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener) {
        this.notificationListenerManager.addListener(notificationListener);
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) {
        this.notificationListenerManager.removeListener(notificationListener);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public long getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdatedTime = lastUpdateTime;
    }

    @Override
    public boolean isDismissable() {
        return this.dismissable;
    }

    public void setDismissable(boolean dismissable) {
        this.dismissable = dismissable;
    }

    @Override
    public void dismiss() {
        this.notificationListenerManager.fireNotificationDismissed();
    }

    protected void touch() {
        this.setLastUpdateTime(System.currentTimeMillis());
    }

    public int hashCode() {
        return this.id.hashCode() ^ (int)(this.getCreatedTime() ^ this.getCreatedTime() >>> 32) ^ (int)(this.getLastUpdatedTime() ^ this.getLastUpdatedTime() >>> 32) ^ (this.dismissable ? 1 : 0);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Notification)) {
            return false;
        }
        Notification notification = (Notification)object;
        if (!this.id.equals(notification.getId())) {
            return false;
        }
        if (this.createdTime != notification.getCreatedTime()) {
            return false;
        }
        if (this.lastUpdatedTime != notification.getLastUpdatedTime()) {
            return false;
        }
        return this.dismissable == notification.isDismissable();
    }
}

