/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends FilterInputStream {
    private long remaining;

    public LimitedInputStream(InputStream inputStream, long length) {
        super(inputStream);
        this.remaining = length;
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.remaining == 0L) {
            return 0;
        }
        return (int)Math.min((long)super.available(), Math.min(Integer.MAX_VALUE, this.remaining));
    }

    @Override
    public synchronized int read() throws IOException {
        int read = -1;
        if (this.remaining > 0L) {
            read = super.read();
            --this.remaining;
        }
        return read;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.remaining == 0L) {
            return -1;
        }
        int toCopy = (int)Math.min((long)len, Math.min(this.remaining, Integer.MAX_VALUE));
        int read = super.read(b, off, toCopy);
        this.remaining -= (long)read;
        return read;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (n < 0L || this.remaining == 0L) {
            return 0L;
        }
        long skipped = super.skip(Math.min(n, this.remaining));
        this.remaining -= skipped;
        return skipped;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset() throws IOException {
    }

    public void consume() throws IOException {
        while (this.remaining > 0L) {
            this.skip(this.remaining);
        }
    }
}

