/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.event;

import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import net.pterodactylus.util.thread.CurrentThreadExecutor;

public abstract class AbstractListenerManager<S, L extends EventListener> {
    private final S source;
    private final List<L> listeners = new CopyOnWriteArrayList<L>();
    private final Executor executor;

    public AbstractListenerManager(S source) {
        this(source, new CurrentThreadExecutor());
    }

    public AbstractListenerManager(S source, Executor executor) {
        this.source = source;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(L listener) {
        List<L> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(L listener) {
        List<L> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    protected S getSource() {
        return this.source;
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    protected List<L> getListeners() {
        return this.listeners;
    }
}

