/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.database;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class URLDataSource
implements DataSource {
    private final String connectionUrl;
    private PrintWriter logWriter;
    private int loginTimeout;
    private final Properties loginProperties = new Properties();

    public URLDataSource(String connectionUrl) {
        this.connectionUrl = connectionUrl;
        this.loginProperties.setProperty("connectTimeout", "0");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this.logWriter = logWriter;
    }

    @Override
    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.loginTimeout = loginTimeout;
        this.loginProperties.setProperty("connectTimeout", String.valueOf((long)loginTimeout * 1000L));
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("No wrapped object found for " + iface.getClass().getName() + ".");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.connectionUrl, this.loginProperties);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties userProperties = new Properties(this.loginProperties);
        userProperties.setProperty("user", username);
        userProperties.setProperty("password", password);
        return DriverManager.getConnection(this.connectionUrl, username, password);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger(this.getClass().getName());
    }
}

