/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.database;

import java.io.PrintWriter;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.sql.DataSource;
import net.pterodactylus.util.collection.Pair;

public class PooledDataSource
implements DataSource {
    private DataSource originalDataSource;
    private Set<Connection> currentConnections = new HashSet<Connection>();
    private Map<Pair<String, String>, Set<Connection>> usernamePasswordConnections = new HashMap<Pair<String, String>, Set<Connection>>();

    public PooledDataSource(DataSource originalDataSource) {
        this.originalDataSource = originalDataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        Set<Connection> set = this.currentConnections;
        synchronized (set) {
            if (this.currentConnections.isEmpty()) {
                PooledConnection newConnection = new PooledConnection(this.originalDataSource.getConnection());
                this.currentConnections.add(newConnection);
            }
            Connection connection = this.currentConnections.iterator().next();
            this.currentConnections.remove(connection);
            return connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Pair<String, String> usernamePasswordPair = new Pair<String, String>(username, password);
        Map<Pair<String, String>, Set<Connection>> map = this.usernamePasswordConnections;
        synchronized (map) {
            Set<Object> connections;
            if (!this.usernamePasswordConnections.containsKey(usernamePasswordPair)) {
                connections = new HashSet();
                this.usernamePasswordConnections.put(usernamePasswordPair, connections);
            }
            connections = this.usernamePasswordConnections.get(usernamePasswordPair);
            if (this.usernamePasswordConnections.isEmpty()) {
                PooledUsernamePasswordConnection newConnection = new PooledUsernamePasswordConnection(this.originalDataSource.getConnection(username, password), username, password);
                connections.add(newConnection);
            }
            Connection connection = (Connection)connections.iterator().next();
            connections.remove(connection);
            return connection;
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.originalDataSource.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.originalDataSource.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.originalDataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.originalDataSource.setLoginTimeout(seconds);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.originalDataSource.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.originalDataSource.unwrap(iface);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.originalDataSource.getParentLogger();
    }

    private class PooledUsernamePasswordConnection
    extends PooledConnection {
        private final String username;
        private final String password;

        public PooledUsernamePasswordConnection(Connection originalConnection, String username, String password) {
            super(originalConnection);
            this.username = username;
            this.password = password;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws SQLException {
            if (!this.isValid(1)) {
                this.getOriginalConnection().close();
                return;
            }
            Map map = PooledDataSource.this.usernamePasswordConnections;
            synchronized (map) {
                ((Set)PooledDataSource.this.usernamePasswordConnections.get(new Pair<String, String>(this.username, this.password))).add(this);
            }
        }
    }

    private class PooledConnection
    implements Connection {
        private final Connection originalConnection;

        public PooledConnection(Connection originalConnection) {
            this.originalConnection = originalConnection;
        }

        protected Connection getOriginalConnection() {
            return this.originalConnection;
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.originalConnection.clearWarnings();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws SQLException {
            if (!this.isValid(1)) {
                this.originalConnection.close();
                return;
            }
            Set set = PooledDataSource.this.currentConnections;
            synchronized (set) {
                PooledDataSource.this.currentConnections.add(this);
            }
        }

        @Override
        public void commit() throws SQLException {
            this.originalConnection.commit();
        }

        @Override
        public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
            return this.originalConnection.createArrayOf(typeName, elements);
        }

        @Override
        public Blob createBlob() throws SQLException {
            return this.originalConnection.createBlob();
        }

        @Override
        public Clob createClob() throws SQLException {
            return this.originalConnection.createClob();
        }

        @Override
        public NClob createNClob() throws SQLException {
            return this.originalConnection.createNClob();
        }

        @Override
        public SQLXML createSQLXML() throws SQLException {
            return this.originalConnection.createSQLXML();
        }

        @Override
        public Statement createStatement() throws SQLException {
            return this.originalConnection.createStatement();
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.originalConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.originalConnection.createStatement(resultSetType, resultSetConcurrency);
        }

        @Override
        public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
            return this.originalConnection.createStruct(typeName, attributes);
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            return this.originalConnection.getAutoCommit();
        }

        @Override
        public String getCatalog() throws SQLException {
            return this.originalConnection.getCatalog();
        }

        @Override
        public Properties getClientInfo() throws SQLException {
            return this.originalConnection.getClientInfo();
        }

        @Override
        public String getClientInfo(String name) throws SQLException {
            return this.originalConnection.getClientInfo(name);
        }

        @Override
        public int getHoldability() throws SQLException {
            return this.originalConnection.getHoldability();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return this.originalConnection.getMetaData();
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            return this.originalConnection.getTransactionIsolation();
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            return this.originalConnection.getTypeMap();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.originalConnection.getWarnings();
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.originalConnection.isClosed();
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return this.originalConnection.isReadOnly();
        }

        @Override
        public boolean isValid(int timeout) throws SQLException {
            return this.originalConnection.isValid(timeout);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.originalConnection.isWrapperFor(iface);
        }

        @Override
        public String nativeSQL(String sql) throws SQLException {
            return this.originalConnection.nativeSQL(sql);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.originalConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.originalConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public CallableStatement prepareCall(String sql) throws SQLException {
            return this.originalConnection.prepareCall(sql);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.originalConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.originalConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            return this.originalConnection.prepareStatement(sql, autoGeneratedKeys);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            return this.originalConnection.prepareStatement(sql, columnIndexes);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            return this.originalConnection.prepareStatement(sql, columnNames);
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return this.originalConnection.prepareStatement(sql);
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.originalConnection.releaseSavepoint(savepoint);
        }

        @Override
        public void rollback() throws SQLException {
            this.originalConnection.rollback();
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            this.originalConnection.rollback(savepoint);
        }

        @Override
        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.originalConnection.setAutoCommit(autoCommit);
        }

        @Override
        public void setCatalog(String catalog) throws SQLException {
            this.originalConnection.setCatalog(catalog);
        }

        @Override
        public void setClientInfo(Properties properties) throws SQLClientInfoException {
            this.originalConnection.setClientInfo(properties);
        }

        @Override
        public void setClientInfo(String name, String value) throws SQLClientInfoException {
            this.originalConnection.setClientInfo(name, value);
        }

        @Override
        public void setHoldability(int holdability) throws SQLException {
            this.originalConnection.setHoldability(holdability);
        }

        @Override
        public void setReadOnly(boolean readOnly) throws SQLException {
            this.originalConnection.setReadOnly(readOnly);
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            return this.originalConnection.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String name) throws SQLException {
            return this.originalConnection.setSavepoint(name);
        }

        @Override
        public void setTransactionIsolation(int level) throws SQLException {
            this.originalConnection.setTransactionIsolation(level);
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            this.originalConnection.setTypeMap(map);
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.originalConnection.unwrap(iface);
        }

        @Override
        public void setSchema(String schema) throws SQLException {
            this.originalConnection.setSchema(schema);
        }

        @Override
        public String getSchema() throws SQLException {
            return this.originalConnection.getSchema();
        }

        @Override
        public void abort(Executor executor) throws SQLException {
            this.originalConnection.abort(executor);
        }

        @Override
        public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
            this.originalConnection.setNetworkTimeout(executor, milliseconds);
        }

        @Override
        public int getNetworkTimeout() throws SQLException {
            return this.originalConnection.getNetworkTimeout();
        }
    }
}

