/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.pterodactylus.util.crypto.Hasher;

public class MessageDigestHasher
implements Hasher {
    private final MessageDigest messageDigest;

    public MessageDigestHasher(MessageDigest messageDigest) {
        this.messageDigest = messageDigest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] hash(byte[] data) {
        MessageDigest messageDigest = this.messageDigest;
        synchronized (messageDigest) {
            this.messageDigest.reset();
            return this.messageDigest.digest(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] hash(InputStream inputStream) throws IOException {
        MessageDigest messageDigest = this.messageDigest;
        synchronized (messageDigest) {
            int read;
            this.messageDigest.reset();
            byte[] buffer = new byte[65536];
            while ((read = inputStream.read(buffer)) != -1) {
                this.messageDigest.update(buffer, 0, read);
            }
            return this.messageDigest.digest();
        }
    }

    public static Hasher getSHA1Hasher() {
        try {
            return new MessageDigestHasher(MessageDigest.getInstance("SHA-1"));
        }
        catch (NoSuchAlgorithmException nsae1) {
            throw new RuntimeException(nsae1);
        }
    }

    public static Hasher getSHA256Hasher() {
        try {
            return new MessageDigestHasher(MessageDigest.getInstance("SHA-256"));
        }
        catch (NoSuchAlgorithmException nsae1) {
            throw new RuntimeException(nsae1);
        }
    }

    public static Hasher getSHA512Hasher() {
        try {
            return new MessageDigestHasher(MessageDigest.getInstance("SHA-512"));
        }
        catch (NoSuchAlgorithmException nsae1) {
            throw new RuntimeException(nsae1);
        }
    }
}

