/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.config;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.pterodactylus.util.collection.Pair;
import net.pterodactylus.util.config.ConfigurationBackend;
import net.pterodactylus.util.config.ConfigurationException;
import net.pterodactylus.util.io.Closer;
import net.pterodactylus.util.logging.Logging;
import net.pterodactylus.util.text.SimpleStringEscaper;
import net.pterodactylus.util.text.StringEscaper;
import net.pterodactylus.util.text.TextException;

public class MapConfigurationBackend
implements ConfigurationBackend {
    private static final Logger logger = Logging.getLogger(MapConfigurationBackend.class);
    private final File configurationFile;
    private final Map<String, String> values = new HashMap<String, String>();

    public MapConfigurationBackend() {
        this(Collections.emptyMap());
    }

    public MapConfigurationBackend(Map<String, String> values) {
        this.configurationFile = null;
        this.values.putAll(values);
    }

    public MapConfigurationBackend(File configurationFile) throws ConfigurationException {
        this(configurationFile, false);
    }

    public MapConfigurationBackend(File configurationFile, Map<String, String> values) throws ConfigurationException {
        this(configurationFile, false, values);
    }

    public MapConfigurationBackend(File configurationFile, boolean ignoreMissing) throws ConfigurationException {
        this(configurationFile, ignoreMissing, null);
    }

    public MapConfigurationBackend(File configurationFile, boolean ignoreMissing, Map<String, String> values) throws ConfigurationException {
        this.configurationFile = configurationFile;
        if (configurationFile != null) {
            this.loadValues(ignoreMissing);
        }
        if (values != null) {
            this.values.putAll(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getValue(String attribute) throws ConfigurationException {
        Map<String, String> map = this.values;
        synchronized (map) {
            if (!this.values.containsKey(attribute)) {
                throw new ConfigurationException("Attribute \u201c" + attribute + "\u201d missing.");
            }
            return this.values.get(attribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putValue(String attribute, String value) throws ConfigurationException {
        Map<String, String> map = this.values;
        synchronized (map) {
            this.values.put(attribute, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws ConfigurationException {
        Map<String, String> map = this.values;
        synchronized (map) {
            this.saveValues();
        }
    }

    /*
     * Exception decompiling
     */
    private void loadValues(boolean ignoreMissing) throws ConfigurationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveValues() throws ConfigurationException {
        File tempFile;
        block11: {
            if (this.configurationFile == null) {
                return;
            }
            FileOutputStream configurationOutputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            BufferedWriter bufferedWriter = null;
            tempFile = new File(this.configurationFile.getPath() + ".tmp");
            try {
                configurationOutputStream = new FileOutputStream(tempFile);
                outputStreamWriter = new OutputStreamWriter((OutputStream)configurationOutputStream, "UTF-8");
                bufferedWriter = new BufferedWriter(outputStreamWriter);
                bufferedWriter.write("# MapConfigurationBackend.Version=1");
                bufferedWriter.newLine();
                for (Map.Entry<String, String> value : this.values.entrySet()) {
                    bufferedWriter.write(StringEscaper.escapeWord(value.getKey()));
                    bufferedWriter.write(":");
                    if (value.getValue() != null) {
                        bufferedWriter.write(32);
                        bufferedWriter.write(SimpleStringEscaper.escapeString(value.getValue()));
                    }
                    bufferedWriter.newLine();
                }
                Closer.close(bufferedWriter);
            }
            catch (FileNotFoundException fnfe1) {
                throw new ConfigurationException("Could not create configuration file \u201c" + this.configurationFile.getName() + "\u201d!", fnfe1);
                catch (UnsupportedEncodingException uee1) {
                    logger.log(Level.SEVERE, "JVM does not support UTF-8!");
                    break block11;
                }
                catch (IOException ioe1) {
                    throw new ConfigurationException("Could not write to configuration file!", ioe1);
                }
            }
            finally {
                Closer.close(bufferedWriter);
                Closer.close(outputStreamWriter);
                Closer.close(configurationOutputStream);
            }
            Closer.close(outputStreamWriter);
            Closer.close(configurationOutputStream);
        }
        this.configurationFile.delete();
        tempFile.renameTo(this.configurationFile);
    }

    private Pair<String, String> parseKeyValuePair(String line, int mapConfigurationBackendVersion) throws ConfigurationException, TextException {
        int colon = line.indexOf(58);
        int equals = line.indexOf(61);
        if (colon == -1 && equals == -1) {
            throw new ConfigurationException("Line without \u201c:\u201d or \u201c=\u201d found: " + line);
        }
        String key = colon != -1 ? (equals != -1 ? line.substring(0, Math.min(colon, equals)) : line.substring(0, colon)) : line.substring(0, equals);
        if (mapConfigurationBackendVersion == 0) {
            if (line.substring(key.length() + 1).trim().length() == 0) {
                return new Pair<String, Object>(key, null);
            }
            key = StringEscaper.parseLine(key).get(0);
            StringBuilder value = new StringBuilder();
            List<String> words = StringEscaper.parseLine(line.substring(key.length() + 1).trim());
            for (String word : words) {
                if (value.length() > 0) {
                    value.append(' ');
                }
                value.append(word);
            }
            this.values.put(key, value.toString());
            return new Pair<String, String>(key, value.toString());
        }
        if (mapConfigurationBackendVersion == 1) {
            String value = line.substring(key.length() + 1);
            if (value.length() == 0) {
                return new Pair<String, Object>(key, null);
            }
            value = SimpleStringEscaper.unescapeString(value.substring(1));
            return new Pair<String, String>(key, value);
        }
        throw new ConfigurationException("Invalid MapConfigurationBackendVersion: " + mapConfigurationBackendVersion);
    }
}

