/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.config;

import java.util.HashMap;
import java.util.Map;
import net.pterodactylus.util.config.ConfigurationBackend;
import net.pterodactylus.util.config.ConfigurationException;

public class CachingConfigurationBackend
implements ConfigurationBackend {
    private final ConfigurationBackend realConfigurationBackend;
    private final Map<String, String> attributeCache = new HashMap<String, String>();

    public CachingConfigurationBackend(ConfigurationBackend realConfigurationBackend) {
        this.realConfigurationBackend = realConfigurationBackend;
    }

    @Override
    public synchronized String getValue(String attribute) throws ConfigurationException {
        if (this.attributeCache.containsKey(attribute)) {
            return this.attributeCache.get(attribute);
        }
        String value = this.realConfigurationBackend.getValue(attribute);
        this.attributeCache.put(attribute, value);
        return value;
    }

    @Override
    public synchronized void putValue(String attribute, String value) throws ConfigurationException {
        this.attributeCache.put(attribute, value);
        this.realConfigurationBackend.putValue(attribute, value);
    }

    @Override
    public void save() throws ConfigurationException {
        this.realConfigurationBackend.save();
    }

    public synchronized void clear() {
        this.attributeCache.clear();
    }
}

