/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.util.freenet.fcp2.wot;

import de.todesbaum.util.freenet.fcp2.wot.Identity;
import de.todesbaum.util.freenet.fcp2.wot.OwnIdentity;
import de.todesbaum.util.freenet.fcp2.wot.Trust;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultIdentity
implements Identity {
    private final String id;
    private final String nickname;
    private final String requestUri;
    private final Set<String> contexts = Collections.synchronizedSet(new HashSet());
    private final Map<String, String> properties = Collections.synchronizedMap(new HashMap());
    private final Map<OwnIdentity, Trust> trustCache = Collections.synchronizedMap(new HashMap());

    public DefaultIdentity(String id, String nickname, String requestUri) {
        this.id = id;
        this.nickname = nickname;
        this.requestUri = requestUri;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public String getRequestUri() {
        return this.requestUri;
    }

    @Override
    public Set<String> getContexts() {
        return Collections.unmodifiableSet(this.contexts);
    }

    @Override
    public boolean hasContext(String context) {
        return this.contexts.contains(context);
    }

    @Override
    public void setContexts(Collection<String> contexts) {
        this.contexts.clear();
        this.contexts.addAll(contexts);
    }

    @Override
    public void addContext(String context) {
        this.contexts.add(context);
    }

    @Override
    public void removeContext(String context) {
        this.contexts.remove(context);
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    @Override
    public String getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    @Override
    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    @Override
    public Trust getTrust(OwnIdentity ownIdentity) {
        return this.trustCache.get(ownIdentity);
    }

    @Override
    public void setTrust(OwnIdentity ownIdentity, Trust trust) {
        this.trustCache.put(ownIdentity, trust);
    }

    @Override
    public void removeTrust(OwnIdentity ownIdentity) {
        this.trustCache.remove(ownIdentity);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DefaultIdentity)) {
            return false;
        }
        DefaultIdentity identity = (DefaultIdentity)object;
        return identity.id.equals(this.id);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ",nickname=" + this.nickname + ",contexts=" + this.contexts + ",properties=" + this.properties + "]";
    }
}

