/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.util.freenet.fcp2;

import de.todesbaum.util.freenet.fcp2.ClientHello;
import de.todesbaum.util.freenet.fcp2.Command;
import de.todesbaum.util.freenet.fcp2.ConnectionListener;
import de.todesbaum.util.freenet.fcp2.Message;
import de.todesbaum.util.freenet.fcp2.Node;
import de.todesbaum.util.io.LineInputStream;
import de.todesbaum.util.io.TempFileInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.pterodactylus.util.io.Closer;
import net.pterodactylus.util.io.StreamCopier;

public class Connection {
    private List<ConnectionListener> connectionListeners = new ArrayList<ConnectionListener>();
    private final Node node;
    private final String name;
    private Socket nodeSocket;
    private InputStream nodeInputStream;
    private OutputStream nodeOutputStream;
    private NodeReader nodeReader;
    private Writer nodeWriter;
    protected Message nodeHello;
    private String tempDirectory;

    public Connection(Node node, String name) {
        this.node = node;
        this.name = name;
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.add(connectionListener);
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.remove(connectionListener);
    }

    protected void fireMessageReceived(Message message) {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.messageReceived(this, message);
        }
    }

    protected void fireConnectionTerminated() {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.connectionTerminated(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setTempDirectory(String tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean connect() throws IOException {
        this.nodeSocket = null;
        this.nodeInputStream = null;
        this.nodeOutputStream = null;
        this.nodeWriter = null;
        this.nodeReader = null;
        try {
            this.nodeSocket = new Socket(this.node.getHostname(), this.node.getPort());
            this.nodeSocket.setReceiveBufferSize(65535);
            this.nodeInputStream = this.nodeSocket.getInputStream();
            this.nodeOutputStream = this.nodeSocket.getOutputStream();
            this.nodeWriter = new OutputStreamWriter(this.nodeOutputStream, Charset.forName("UTF-8"));
            this.nodeReader = new NodeReader(this.nodeInputStream);
            Thread nodeReaderThread = new Thread(this.nodeReader);
            nodeReaderThread.setDaemon(true);
            nodeReaderThread.start();
            ClientHello clientHello = new ClientHello();
            clientHello.setName(this.name);
            clientHello.setExpectedVersion("2.0");
            this.execute(clientHello);
            Connection connection = this;
            synchronized (connection) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.nodeHello != null;
        }
        catch (IOException ioe1) {
            this.disconnect();
            throw ioe1;
        }
    }

    public boolean isConnected() {
        return this.nodeHello != null && this.nodeSocket != null && this.nodeSocket.isConnected();
    }

    public Message getNodeHello() {
        return this.nodeHello;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Closer.close(this.nodeWriter);
        this.nodeWriter = null;
        Closer.close(this.nodeOutputStream);
        this.nodeOutputStream = null;
        Closer.close(this.nodeInputStream);
        this.nodeInputStream = null;
        this.nodeInputStream = null;
        Closer.close(this.nodeSocket);
        this.nodeSocket = null;
        Connection connection = this;
        synchronized (connection) {
            this.notify();
        }
        this.fireConnectionTerminated();
    }

    public synchronized void execute(Command command) throws IllegalStateException, IOException {
        this.execute(command, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute(Command command, StreamCopier.ProgressListener progressListener) throws IllegalStateException, IOException {
        if (this.nodeSocket == null) {
            throw new IllegalStateException("connection is not connected");
        }
        this.nodeWriter.write(command.getCommandName() + "\r\n");
        command.write(this.nodeWriter);
        this.nodeWriter.write("EndMessage\r\n");
        this.nodeWriter.flush();
        if (command.hasPayload()) {
            InputStream payloadInputStream = null;
            try {
                payloadInputStream = command.getPayload();
                StreamCopier.copy(payloadInputStream, this.nodeOutputStream, progressListener, command.getPayloadLength());
            }
            finally {
                Closer.close(payloadInputStream);
            }
            this.nodeOutputStream.flush();
        }
    }

    private class NodeReader
    implements Runnable {
        private InputStream nodeInputStream;

        public NodeReader(InputStream nodeInputStream) {
            this.nodeInputStream = nodeInputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LineInputStream nodeReader = null;
            try {
                nodeReader = new LineInputStream(this.nodeInputStream);
                String line = "";
                Message message = null;
                while (line != null) {
                    Object tempFile;
                    line = nodeReader.readLine();
                    if (line == null) {
                        break;
                    }
                    if (message == null) {
                        message = new Message(line);
                        continue;
                    }
                    if ("Data".equals(line)) {
                        tempFile = null;
                        try {
                            tempFile = File.createTempFile("fcpv2", "data", Connection.this.tempDirectory != null ? new File(Connection.this.tempDirectory) : null);
                            ((File)tempFile).deleteOnExit();
                            FileOutputStream tempFileOutputStream = new FileOutputStream((File)tempFile);
                            long dataLength = Long.parseLong(message.get("DataLength"));
                            StreamCopier.copy(this.nodeInputStream, (OutputStream)tempFileOutputStream, dataLength);
                            tempFileOutputStream.close();
                            message.setPayloadInputStream(new TempFileInputStream((File)tempFile));
                        }
                        catch (IOException ioe1) {
                            ioe1.printStackTrace();
                        }
                    }
                    if ("Data".equals(line) || "EndMessage".equals(line)) {
                        if (message.getName().equals("NodeHello")) {
                            Connection.this.nodeHello = message;
                            tempFile = Connection.this;
                            synchronized (tempFile) {
                                Connection.this.notify();
                            }
                        } else {
                            Connection.this.fireMessageReceived(message);
                        }
                        message = null;
                        continue;
                    }
                    int equalsPosition = line.indexOf(61);
                    if (equalsPosition > -1) {
                        String key = line.substring(0, equalsPosition).trim();
                        String value = line.substring(equalsPosition + 1).trim();
                        if (key.equals("Identifier")) {
                            message.setIdentifier(value);
                            continue;
                        }
                        message.put(key, value);
                        continue;
                    }
                    if (line.trim().length() == 0) continue;
                    throw new IOException("Unexpected line: " + line);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (nodeReader != null) {
                    try {
                        nodeReader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (this.nodeInputStream != null) {
                    try {
                        this.nodeInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            Connection.this.disconnect();
        }
    }
}

