/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.main;

public class Version
implements Comparable<Version> {
    private final int[] components;

    public Version(int ... components) {
        this.components = new int[components.length];
        System.arraycopy(components, 0, this.components, 0, components.length);
    }

    public int size() {
        return this.components.length;
    }

    public int getComponent(int index) {
        return this.components[index];
    }

    public static Version parse(String versionString) {
        String[] componentStrings = versionString.split("\\.");
        int[] components = new int[componentStrings.length];
        int index = -1;
        for (String componentString : componentStrings) {
            try {
                components[++index] = Integer.parseInt(componentString);
            }
            catch (NumberFormatException nfe1) {
                return null;
            }
        }
        return new Version(components);
    }

    public String toString() {
        StringBuilder versionString = new StringBuilder();
        for (int component : this.components) {
            if (versionString.length() != 0) {
                versionString.append('.');
            }
            versionString.append(component);
        }
        return versionString.toString();
    }

    @Override
    public int compareTo(Version version) {
        int lessComponents = Math.min(this.components.length, version.components.length);
        for (int index = 0; index < lessComponents; ++index) {
            if (version.components[index] == this.components[index]) continue;
            return this.components[index] - version.components[index];
        }
        return this.components.length - version.components.length;
    }
}

