/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.gui;

import de.todesbaum.jsite.application.AbortedException;
import de.todesbaum.jsite.application.Freenet7Interface;
import de.todesbaum.jsite.application.InsertListener;
import de.todesbaum.jsite.application.Project;
import de.todesbaum.jsite.application.ProjectInserter;
import de.todesbaum.jsite.i18n.I18n;
import de.todesbaum.jsite.i18n.I18nContainer;
import de.todesbaum.util.freenet.fcp2.PriorityClass;
import de.todesbaum.util.swing.TWizard;
import de.todesbaum.util.swing.TWizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.pterodactylus.util.io.StreamCopier;

public class ProjectInsertPage
extends TWizardPage
implements InsertListener,
ClipboardOwner {
    private static final Logger logger = Logger.getLogger(ProjectInsertPage.class.getName());
    private ProjectInserter projectInserter;
    private Action copyURIAction;
    private JTextField requestURITextField;
    private JLabel startTimeLabel;
    private JProgressBar progressBar;
    private long startTime = 0L;
    private volatile int insertedBlocks;
    private boolean uriCopied;
    private volatile boolean running = false;

    public ProjectInsertPage(TWizard wizard) {
        super(wizard);
        this.createActions();
        this.pageInit();
        this.setHeading(I18n.getMessage("jsite.insert.heading"));
        this.setDescription(I18n.getMessage("jsite.insert.description"));
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                ProjectInsertPage.this.setHeading(I18n.getMessage("jsite.insert.heading"));
                ProjectInsertPage.this.setDescription(I18n.getMessage("jsite.insert.description"));
            }
        });
        this.projectInserter = new ProjectInserter();
        this.projectInserter.addInsertListener(this);
    }

    private void createActions() {
        this.copyURIAction = new AbstractAction(I18n.getMessage("jsite.project.action.copy-uri")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectInsertPage.this.actionCopyURI();
            }
        };
        this.copyURIAction.putValue("ShortDescription", I18n.getMessage("jsite.project.action.copy-uri.tooltip"));
        this.copyURIAction.putValue("MnemonicKey", 85);
        this.copyURIAction.setEnabled(false);
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                ProjectInsertPage.this.copyURIAction.putValue("Name", I18n.getMessage("jsite.project.action.copy-uri"));
                ProjectInsertPage.this.copyURIAction.putValue("ShortDescription", I18n.getMessage("jsite.project.action.copy-uri.tooltip"));
            }
        });
    }

    private void pageInit() {
        this.setLayout(new BorderLayout(12, 12));
        this.add((Component)this.createProjectInsertPanel(), "Center");
    }

    private JComponent createProjectInsertPanel() {
        JPanel projectInsertPanel = new JPanel(new GridBagLayout());
        this.requestURITextField = new JTextField();
        this.requestURITextField.setEditable(false);
        this.startTimeLabel = new JLabel();
        this.progressBar = new JProgressBar(0, 1);
        this.progressBar.setStringPainted(true);
        this.progressBar.setValue(0);
        final JLabel projectInformationLabel = new JLabel("<html><b>" + I18n.getMessage("jsite.insert.project-information") + "</b></html>");
        projectInsertPanel.add((Component)projectInformationLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        final JLabel requestURILabel = new JLabel(I18n.getMessage("jsite.insert.request-uri") + ":");
        projectInsertPanel.add((Component)requestURILabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 2, new Insets(6, 18, 0, 0), 0, 0));
        projectInsertPanel.add((Component)this.requestURITextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 0, 0), 0, 0));
        final JLabel startTimeLeftLabel = new JLabel(I18n.getMessage("jsite.insert.start-time") + ":");
        projectInsertPanel.add((Component)startTimeLeftLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 2, new Insets(6, 18, 0, 0), 0, 0));
        projectInsertPanel.add((Component)this.startTimeLabel, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 0, 0), 0, 0));
        final JLabel progressLabel = new JLabel(I18n.getMessage("jsite.insert.progress") + ":");
        projectInsertPanel.add((Component)progressLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 2, new Insets(6, 18, 0, 0), 0, 0));
        projectInsertPanel.add((Component)this.progressBar, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 0, 0), 0, 0));
        projectInsertPanel.add((Component)new JButton(this.copyURIAction), new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 22, 0, new Insets(12, 18, 0, 0), 0, 0));
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                projectInformationLabel.setText("<html><b>" + I18n.getMessage("jsite.insert.project-information") + "</b></html>");
                requestURILabel.setText(I18n.getMessage("jsite.insert.request-uri") + ":");
                startTimeLeftLabel.setText(I18n.getMessage("jsite.insert.start-time") + ":");
                if (ProjectInsertPage.this.startTime != 0L) {
                    ProjectInsertPage.this.startTimeLabel.setText(DateFormat.getDateTimeInstance().format(new Date(ProjectInsertPage.this.startTime)));
                } else {
                    ProjectInsertPage.this.startTimeLabel.setText("");
                }
                progressLabel.setText(I18n.getMessage("jsite.insert.progress") + ":");
            }
        });
        return projectInsertPanel;
    }

    @Override
    public void pageAdded(TWizard wizard) {
        this.wizard.setPreviousName(I18n.getMessage("jsite.wizard.previous"));
        this.wizard.setPreviousEnabled(false);
        this.wizard.setNextName(I18n.getMessage("jsite.general.cancel"));
        this.wizard.setQuitName(I18n.getMessage("jsite.wizard.quit"));
    }

    public void startInsert() {
        this.running = true;
        this.copyURIAction.setEnabled(false);
        this.progressBar.setValue(0);
        this.progressBar.setString(I18n.getMessage("jsite.insert.starting"));
        this.progressBar.setFont(this.progressBar.getFont().deriveFont(0));
        this.projectInserter.start(new StreamCopier.ProgressListener(){

            @Override
            public void onProgress(final long copied, final long length) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int divisor = 1;
                        while (copied / (long)divisor > Integer.MAX_VALUE || length / (long)divisor > Integer.MAX_VALUE) {
                            divisor *= 10;
                        }
                        ProjectInsertPage.this.progressBar.setMaximum((int)(length / (long)divisor));
                        ProjectInsertPage.this.progressBar.setValue((int)(copied / (long)divisor));
                        ProjectInsertPage.this.progressBar.setString("Uploaded: " + copied + " / " + length);
                    }
                });
            }
        });
    }

    public void stopInsert() {
        if (this.running) {
            this.wizard.setNextEnabled(false);
            this.projectInserter.stop();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setProject(final Project project) {
        this.projectInserter.setProject(project);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectInsertPage.this.requestURITextField.setText(project.getFinalRequestURI(1));
            }
        });
    }

    public void setFreenetInterface(Freenet7Interface freenetInterface) {
        this.projectInserter.setFreenetInterface(freenetInterface);
    }

    public void setTempDirectory(String tempDirectory) {
        this.projectInserter.setTempDirectory(tempDirectory);
    }

    public boolean wasUriCopied() {
        return this.uriCopied;
    }

    public void setUseEarlyEncode(boolean useEarlyEncode) {
        this.projectInserter.setUseEarlyEncode(useEarlyEncode);
    }

    public void setPriority(PriorityClass priority) {
        this.projectInserter.setPriority(priority);
    }

    @Override
    public void projectInsertStarted(Project project) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectInsertPage.this.startTimeLabel.setText(DateFormat.getDateTimeInstance().format(new Date()));
            }
        });
    }

    @Override
    public void projectUploadFinished(Project project) {
        this.startTime = System.currentTimeMillis();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectInsertPage.this.progressBar.setString(I18n.getMessage("jsite.insert.starting"));
                ProjectInsertPage.this.progressBar.setValue(0);
            }
        });
    }

    @Override
    public void projectURIGenerated(Project project, final String uri) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectInsertPage.this.copyURIAction.setEnabled(true);
                ProjectInsertPage.this.requestURITextField.setText(uri);
            }
        });
        logger.log(Level.FINEST, "Insert generated URI: " + uri);
        int slash = uri.indexOf(47);
        slash = uri.indexOf(47, slash + 1);
        int secondSlash = uri.indexOf(47, slash + 1);
        if (secondSlash == -1) {
            secondSlash = uri.length();
        }
        String editionNumber = uri.substring(slash + 1, secondSlash);
        logger.log(Level.FINEST, "Extracted edition number: " + editionNumber);
        int edition = -1;
        try {
            edition = Integer.valueOf(editionNumber);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        logger.log(Level.FINEST, "Insert edition: " + edition + ", Project edition: " + project.getEdition());
        if (edition != -1 && edition == project.getEdition()) {
            JOptionPane.showMessageDialog(this, I18n.getMessage("jsite.insert.reinserted-edition"), I18n.getMessage("jsite.insert.reinserted-edition.title"), 1);
        }
    }

    @Override
    public void projectInsertProgress(Project project, final int succeeded, final int failed, final int fatal, final int total, final boolean finalized) {
        this.insertedBlocks = succeeded;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (total == 0) {
                    return;
                }
                ProjectInsertPage.this.progressBar.setMaximum(total);
                ProjectInsertPage.this.progressBar.setValue(succeeded + failed + fatal);
                int progress = (succeeded + failed + fatal) * 100 / total;
                StringBuilder progressString = new StringBuilder();
                progressString.append(progress).append("% (");
                progressString.append(succeeded + failed + fatal).append('/').append(total);
                progressString.append(") (");
                progressString.append(ProjectInsertPage.this.getTransferRate());
                progressString.append(' ').append(I18n.getMessage("jsite.insert.k-per-s")).append(')');
                ProjectInsertPage.this.progressBar.setString(progressString.toString());
                if (finalized) {
                    ProjectInsertPage.this.progressBar.setFont(ProjectInsertPage.this.progressBar.getFont().deriveFont(1));
                }
            }
        });
    }

    @Override
    public void projectInsertFinished(Project project, boolean success, Throwable cause) {
        this.running = false;
        if (success) {
            String copyURILabel = I18n.getMessage("jsite.insert.okay-copy-uri");
            int selectedValue = JOptionPane.showOptionDialog(this, I18n.getMessage("jsite.insert.inserted"), I18n.getMessage("jsite.insert.done.title"), 0, 1, null, new Object[]{I18n.getMessage("jsite.general.ok"), copyURILabel}, copyURILabel);
            if (selectedValue == 1) {
                this.actionCopyURI();
            }
        } else if (cause == null) {
            JOptionPane.showMessageDialog(this, I18n.getMessage("jsite.insert.insert-failed"), I18n.getMessage("jsite.insert.insert-failed.title"), 0);
        } else if (cause instanceof AbortedException) {
            JOptionPane.showMessageDialog(this, I18n.getMessage("jsite.insert.insert-aborted"), I18n.getMessage("jsite.insert.insert-aborted.title"), 1);
        } else {
            JOptionPane.showMessageDialog(this, MessageFormat.format(I18n.getMessage("jsite.insert.insert-failed-with-cause"), cause.getMessage()), I18n.getMessage("jsite.insert.insert-failed.title"), 0);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectInsertPage.this.progressBar.setValue(ProjectInsertPage.this.progressBar.getMaximum());
                ProjectInsertPage.this.progressBar.setString(I18n.getMessage("jsite.insert.done") + " (" + ProjectInsertPage.this.getTransferRate() + " " + I18n.getMessage("jsite.insert.k-per-s") + ")");
                ProjectInsertPage.this.wizard.setNextName(I18n.getMessage("jsite.wizard.next"));
                ProjectInsertPage.this.wizard.setNextEnabled(true);
                ProjectInsertPage.this.wizard.setQuitEnabled(true);
            }
        });
    }

    private void actionCopyURI() {
        this.uriCopied = true;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(this.requestURITextField.getText()), this);
    }

    private static String formatNumber(double number, int digits) {
        int multiplier = (int)Math.pow(10.0, digits);
        String formattedNumber = String.valueOf((double)((int)(number * (double)multiplier)) / (double)multiplier);
        if (formattedNumber.indexOf(46) == -1) {
            formattedNumber = formattedNumber + '.';
            for (int digit = 0; digit < digits; ++digit) {
                formattedNumber = formattedNumber + "0";
            }
        }
        return formattedNumber;
    }

    private String getTransferRate() {
        return ProjectInsertPage.formatNumber((double)this.insertedBlocks * 32.0 / (double)((System.currentTimeMillis() - this.startTime) / 1000L), 1);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

