/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.gui;

import de.todesbaum.jsite.application.FileOption;
import de.todesbaum.jsite.application.Project;
import de.todesbaum.jsite.gui.FileScanner;
import de.todesbaum.jsite.gui.FileScannerListener;
import de.todesbaum.jsite.gui.ScannedFile;
import de.todesbaum.jsite.i18n.I18n;
import de.todesbaum.jsite.i18n.I18nContainer;
import de.todesbaum.util.swing.TLabel;
import de.todesbaum.util.swing.TWizard;
import de.todesbaum.util.swing.TWizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import net.pterodactylus.util.io.MimeTypes;
import net.pterodactylus.util.swing.SwingUtils;
import net.pterodactylus.util.thread.StoppableDelay;

public class ProjectFilesPage
extends TWizardPage
implements ActionListener,
ListSelectionListener,
DocumentListener,
FileScannerListener {
    private Project project;
    private Action scanAction;
    private JCheckBox alwaysForceInsertCheckBox;
    private JCheckBox ignoreHiddenFilesCheckBox;
    private JList projectFileList;
    private JCheckBox defaultFileCheckBox;
    private JCheckBox fileOptionsInsertCheckBox;
    private JCheckBox fileOptionsForceInsertCheckBox;
    private JCheckBox fileOptionsInsertRedirectCheckBox;
    private JTextField fileOptionsCustomKeyTextField;
    private JCheckBox fileOptionsRenameCheckBox;
    private JTextField fileOptionsRenameTextField;
    private JComboBox fileOptionsMIMETypeComboBox;
    private StoppableDelay delayedNotification;
    private JDialog scanningFilesDialog;
    private FileScanner fileScanner;
    private JProgressBar progressBar;

    public ProjectFilesPage(TWizard wizard) {
        super(wizard);
        this.pageInit();
    }

    private void pageInit() {
        this.createActions();
        this.setLayout(new BorderLayout(12, 12));
        this.add((Component)this.createProjectFilesPanel(), "Center");
    }

    private void createActions() {
        this.scanAction = new AbstractAction(I18n.getMessage("jsite.project-files.action.rescan")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectFilesPage.this.actionScan();
            }
        };
        this.scanAction.putValue("MnemonicKey", 83);
        this.scanAction.putValue("ShortDescription", I18n.getMessage("jsite.project-files.action.rescan.tooltip"));
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                ProjectFilesPage.this.scanAction.putValue("Name", I18n.getMessage("jsite.project-files.action.rescan"));
                ProjectFilesPage.this.scanAction.putValue("ShortDescription", I18n.getMessage("jsite.project-files.action.rescan.tooltip"));
            }
        });
    }

    @Override
    public void pageAdded(TWizard wizard) {
        this.fileScanner = new FileScanner(this.project, this);
        this.actionScan();
        this.wizard.setPreviousName(I18n.getMessage("jsite.wizard.previous"));
        this.wizard.setNextName(I18n.getMessage("jsite.project-files.insert-now"));
        this.wizard.setQuitName(I18n.getMessage("jsite.wizard.quit"));
    }

    private JComponent createProjectFilesPanel() {
        JPanel projectFilesPanel = new JPanel(new BorderLayout(12, 12));
        this.projectFileList = new JList();
        this.projectFileList.setSelectionMode(0);
        this.projectFileList.setMinimumSize(new Dimension(250, this.projectFileList.getPreferredSize().height));
        this.projectFileList.addListSelectionListener(this);
        projectFilesPanel.add((Component)new JScrollPane(this.projectFileList), "Center");
        JPanel fileOptionsAlignmentPanel = new JPanel(new BorderLayout(12, 12));
        projectFilesPanel.add((Component)fileOptionsAlignmentPanel, "Last");
        JPanel fileOptionsPanel = new JPanel(new GridBagLayout());
        fileOptionsAlignmentPanel.add((Component)fileOptionsPanel, "First");
        this.alwaysForceInsertCheckBox = new JCheckBox(I18n.getMessage("jsite.project-files.always-force-insert"));
        this.alwaysForceInsertCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.always-force-insert.tooltip"));
        this.alwaysForceInsertCheckBox.setName("always-force-insert");
        this.alwaysForceInsertCheckBox.addActionListener(this);
        fileOptionsPanel.add((Component)this.alwaysForceInsertCheckBox, new GridBagConstraints(0, 0, 5, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.ignoreHiddenFilesCheckBox = new JCheckBox(I18n.getMessage("jsite.project-files.ignore-hidden-files"));
        this.ignoreHiddenFilesCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.ignore-hidden-files.tooltip"));
        this.ignoreHiddenFilesCheckBox.setName("ignore-hidden-files");
        this.ignoreHiddenFilesCheckBox.addActionListener(this);
        fileOptionsPanel.add((Component)this.ignoreHiddenFilesCheckBox, new GridBagConstraints(0, 1, 5, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        fileOptionsPanel.add((Component)new JButton(this.scanAction), new GridBagConstraints(0, 2, 5, 1, 1.0, 0.0, 21, 0, new Insets(6, 0, 0, 0), 0, 0));
        final JLabel fileOptionsLabel = new JLabel("<html><b>" + I18n.getMessage("jsite.project-files.file-options") + "</b></html>");
        fileOptionsPanel.add((Component)fileOptionsLabel, new GridBagConstraints(0, 3, 5, 1, 1.0, 0.0, 21, 0, new Insets(6, 0, 0, 0), 0, 0));
        this.defaultFileCheckBox = new JCheckBox(I18n.getMessage("jsite.project-files.default"));
        this.defaultFileCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.default.tooltip"));
        this.defaultFileCheckBox.setName("default-file");
        this.defaultFileCheckBox.addActionListener(this);
        this.defaultFileCheckBox.setEnabled(false);
        fileOptionsPanel.add((Component)this.defaultFileCheckBox, new GridBagConstraints(0, 4, 5, 1, 0.0, 0.0, 21, 2, new Insets(6, 18, 0, 0), 0, 0));
        this.fileOptionsInsertCheckBox = new JCheckBox(I18n.getMessage("jsite.project-files.insert"), true);
        this.fileOptionsInsertCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.insert.tooltip"));
        this.fileOptionsInsertCheckBox.setName("insert");
        this.fileOptionsInsertCheckBox.setMnemonic(73);
        this.fileOptionsInsertCheckBox.addActionListener(this);
        this.fileOptionsInsertCheckBox.setEnabled(false);
        fileOptionsPanel.add((Component)this.fileOptionsInsertCheckBox, new GridBagConstraints(0, 5, 5, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.fileOptionsForceInsertCheckBox = new JCheckBox(I18n.getMessage("jsite.project-files.force-insert"));
        this.fileOptionsForceInsertCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.force-insert.tooltip"));
        this.fileOptionsForceInsertCheckBox.setName("force-insert");
        this.fileOptionsForceInsertCheckBox.setMnemonic(70);
        this.fileOptionsForceInsertCheckBox.addActionListener(this);
        this.fileOptionsForceInsertCheckBox.setEnabled(false);
        fileOptionsPanel.add((Component)this.fileOptionsForceInsertCheckBox, new GridBagConstraints(0, 6, 5, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.fileOptionsCustomKeyTextField = new JTextField(45);
        this.fileOptionsCustomKeyTextField.setToolTipText(I18n.getMessage("jsite.project-files.custom-key.tooltip"));
        this.fileOptionsCustomKeyTextField.setEnabled(false);
        this.fileOptionsCustomKeyTextField.getDocument().addDocumentListener(this);
        this.fileOptionsInsertRedirectCheckBox = new JCheckBox(I18n.getMessage("jsite.project-files.insert-redirect"), false);
        this.fileOptionsInsertRedirectCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.insert-redirect.tooltip"));
        this.fileOptionsInsertRedirectCheckBox.setName("insert-redirect");
        this.fileOptionsInsertRedirectCheckBox.setMnemonic(82);
        this.fileOptionsInsertRedirectCheckBox.addActionListener(this);
        this.fileOptionsInsertRedirectCheckBox.setEnabled(false);
        final TLabel customKeyLabel = new TLabel(I18n.getMessage("jsite.project-files.custom-key") + ":", 75, this.fileOptionsCustomKeyTextField);
        fileOptionsPanel.add((Component)this.fileOptionsInsertRedirectCheckBox, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        fileOptionsPanel.add((Component)customKeyLabel, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 6, 0, 0), 0, 0));
        fileOptionsPanel.add((Component)this.fileOptionsCustomKeyTextField, new GridBagConstraints(2, 7, 3, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.fileOptionsRenameCheckBox = new JCheckBox(I18n.getMessage("jsite.project-files.rename"), false);
        this.fileOptionsRenameCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.rename.tooltip"));
        this.fileOptionsRenameCheckBox.setName("rename");
        this.fileOptionsRenameCheckBox.setMnemonic(78);
        this.fileOptionsRenameCheckBox.addActionListener(this);
        this.fileOptionsRenameCheckBox.setEnabled(false);
        this.fileOptionsRenameTextField = new JTextField();
        this.fileOptionsRenameTextField.setEnabled(false);
        this.fileOptionsRenameTextField.getDocument().addDocumentListener(new StoreDocument(this::updateChangedName));
        fileOptionsPanel.add((Component)this.fileOptionsRenameCheckBox, new GridBagConstraints(0, 8, 2, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        fileOptionsPanel.add((Component)this.fileOptionsRenameTextField, new GridBagConstraints(2, 8, 3, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.fileOptionsMIMETypeComboBox = new JComboBox<Object>(MimeTypes.getAllMimeTypes().toArray());
        this.fileOptionsMIMETypeComboBox.setToolTipText(I18n.getMessage("jsite.project-files.mime-type.tooltip"));
        this.fileOptionsMIMETypeComboBox.setName("project-files.mime-type");
        this.fileOptionsMIMETypeComboBox.addActionListener(this);
        this.fileOptionsMIMETypeComboBox.setEditable(true);
        this.fileOptionsMIMETypeComboBox.setEnabled(false);
        ((JTextComponent)this.fileOptionsMIMETypeComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new StoreDocument(this::updateMimeType));
        final TLabel mimeTypeLabel = new TLabel(I18n.getMessage("jsite.project-files.mime-type") + ":", 77, this.fileOptionsMIMETypeComboBox);
        fileOptionsPanel.add((Component)mimeTypeLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        fileOptionsPanel.add((Component)this.fileOptionsMIMETypeComboBox, new GridBagConstraints(1, 9, 4, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.scanningFilesDialog = new JDialog(this.wizard);
        this.scanningFilesDialog.setModal(true);
        this.scanningFilesDialog.setDefaultCloseOperation(0);
        JPanel progressPanel = new JPanel(new BorderLayout(12, 12));
        this.scanningFilesDialog.getContentPane().add((Component)progressPanel, "Center");
        progressPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        final JLabel scanningLabel = new JLabel(I18n.getMessage("jsite.project-files.scanning"), 0);
        progressPanel.add((Component)scanningLabel, "North");
        this.progressBar = new JProgressBar(0);
        progressPanel.add((Component)this.progressBar, "South");
        this.progressBar.setIndeterminate(true);
        this.progressBar.setStringPainted(true);
        this.progressBar.setPreferredSize(new Dimension(this.progressBar.getPreferredSize().width * 2, this.progressBar.getPreferredSize().height));
        this.scanningFilesDialog.pack();
        this.scanningFilesDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                SwingUtils.center(ProjectFilesPage.this.scanningFilesDialog, ProjectFilesPage.this.wizard);
            }
        });
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                ProjectFilesPage.this.alwaysForceInsertCheckBox.setText(I18n.getMessage("jsite.project-files.always-force-insert"));
                ProjectFilesPage.this.alwaysForceInsertCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.always-force-insert.tooltip"));
                ProjectFilesPage.this.ignoreHiddenFilesCheckBox.setText(I18n.getMessage("jsite.project-files.ignore-hidden-files"));
                ProjectFilesPage.this.ignoreHiddenFilesCheckBox.setToolTipText(I18n.getMessage("jsite.projet-files.ignore-hidden-files.tooltip"));
                fileOptionsLabel.setText("<html><b>" + I18n.getMessage("jsite.project-files.file-options") + "</b></html>");
                ProjectFilesPage.this.defaultFileCheckBox.setText(I18n.getMessage("jsite.project-files.default"));
                ProjectFilesPage.this.defaultFileCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.default.tooltip"));
                ProjectFilesPage.this.fileOptionsInsertCheckBox.setText(I18n.getMessage("jsite.project-files.insert"));
                ProjectFilesPage.this.fileOptionsInsertCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.insert.tooltip"));
                ProjectFilesPage.this.fileOptionsForceInsertCheckBox.setText(I18n.getMessage("jsite.project-files.force-insert"));
                ProjectFilesPage.this.fileOptionsForceInsertCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.force-insert.tooltip"));
                ProjectFilesPage.this.fileOptionsInsertRedirectCheckBox.setText(I18n.getMessage("jsite.project-files.insert-redirect"));
                ProjectFilesPage.this.fileOptionsInsertRedirectCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.insert-redirect.tooltip"));
                ProjectFilesPage.this.fileOptionsCustomKeyTextField.setToolTipText(I18n.getMessage("jsite.project-files.custom-key.tooltip"));
                customKeyLabel.setText(I18n.getMessage("jsite.project-files.custom-key") + ":");
                ProjectFilesPage.this.fileOptionsRenameCheckBox.setText("jsite.project-files.rename");
                ProjectFilesPage.this.fileOptionsRenameCheckBox.setToolTipText("jsite.project-files.rename.tooltip");
                ProjectFilesPage.this.fileOptionsMIMETypeComboBox.setToolTipText(I18n.getMessage("jsite.project-files.mime-type.tooltip"));
                mimeTypeLabel.setText(I18n.getMessage("jsite.project-files.mime-type") + ":");
                scanningLabel.setText(I18n.getMessage("jsite.project-files.scanning"));
            }
        });
        return projectFilesPanel;
    }

    public void setProject(final Project project) {
        this.project = project;
        this.setHeading(MessageFormat.format(I18n.getMessage("jsite.project-files.heading"), project.getName()));
        this.setDescription(I18n.getMessage("jsite.project-files.description"));
        this.ignoreHiddenFilesCheckBox.setSelected(project.isIgnoreHiddenFiles());
        this.alwaysForceInsertCheckBox.setSelected(project.isAlwaysForceInsert());
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                ProjectFilesPage.this.setHeading(MessageFormat.format(I18n.getMessage("jsite.project-files.heading"), project.getName()));
                ProjectFilesPage.this.setDescription(I18n.getMessage("jsite.project-files.description"));
            }
        });
    }

    private void actionScan() {
        this.projectFileList.clearSelection();
        this.projectFileList.setListData(new Object[0]);
        this.wizard.setNextEnabled(false);
        this.wizard.setPreviousEnabled(false);
        this.wizard.setQuitEnabled(false);
        this.ignoreHiddenFilesCheckBox.setEnabled(false);
        this.scanAction.setEnabled(false);
        this.delayedNotification = new StoppableDelay(new Runnable(){

            @Override
            public void run() {
                ProjectFilesPage.this.scanningFilesDialog.setVisible(true);
            }
        }, new Runnable(){

            @Override
            public void run() {
                ProjectFilesPage.this.scanningFilesDialog.setVisible(false);
            }
        }, 2000L);
        this.fileScanner.startInBackground();
        new Thread(this.delayedNotification).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!ProjectFilesPage.this.delayedNotification.isFinished()) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ProjectFilesPage.this.progressBar.setString(ProjectFilesPage.this.fileScanner.getLastFilename());
                }
            }
        }).start();
    }

    @Override
    public void fileScannerFinished(final boolean error, final Collection<ScannedFile> files) {
        this.delayedNotification.finish();
        if (!error) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProjectFilesPage.this.projectFileList.setListData(files.toArray());
                    ProjectFilesPage.this.projectFileList.clearSelection();
                }
            });
            HashSet<String> entriesToRemove = new HashSet<String>();
            for (String filename : new HashSet<String>(this.project.getFileOptions().keySet())) {
                boolean found = false;
                for (ScannedFile scannedFile : files) {
                    if (!scannedFile.getFilename().equals(filename)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                entriesToRemove.add(filename);
            }
            for (String filename : entriesToRemove) {
                this.project.setFileOption(filename, null);
            }
        } else {
            JOptionPane.showMessageDialog(this.wizard, I18n.getMessage("jsite.project-files.scan-error"), null, 0);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectFilesPage.this.wizard.setPreviousEnabled(true);
                ProjectFilesPage.this.wizard.setNextEnabled(!error);
                ProjectFilesPage.this.wizard.setQuitEnabled(true);
                ProjectFilesPage.this.ignoreHiddenFilesCheckBox.setEnabled(true);
                ProjectFilesPage.this.scanAction.setEnabled(true);
            }
        });
    }

    private Optional<FileOption> getSelectedFile() {
        return Optional.ofNullable((ScannedFile)this.projectFileList.getSelectedValue()).map(scannedFile -> this.project.getFileOption(scannedFile.getFilename()));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComboBox comboBox;
        ScannedFile scannedFile;
        Object source = actionEvent.getSource();
        if (source instanceof JCheckBox) {
            String checkboxName = ((JCheckBox)source).getName();
            if ("ignore-hidden-files".equals(checkboxName)) {
                this.project.setIgnoreHiddenFiles(((JCheckBox)source).isSelected());
                this.actionScan();
                return;
            }
            if ("always-force-insert".equals(checkboxName)) {
                this.project.setAlwaysForceInsert(((JCheckBox)source).isSelected());
                this.valueChanged(null);
                return;
            }
        }
        if ((scannedFile = (ScannedFile)this.projectFileList.getSelectedValue()) == null) {
            return;
        }
        String filename = scannedFile.getFilename();
        FileOption fileOption = this.project.getFileOption(filename);
        if (source instanceof JCheckBox) {
            JCheckBox checkBox = (JCheckBox)source;
            if ("default-file".equals(checkBox.getName())) {
                if (checkBox.isSelected()) {
                    if (filename.indexOf(47) > -1) {
                        JOptionPane.showMessageDialog(this.wizard, I18n.getMessage("jsite.project-files.invalid-default-file"), null, 0);
                        checkBox.setSelected(false);
                    } else {
                        this.project.setIndexFile(filename);
                    }
                } else if (filename.equals(this.project.getIndexFile())) {
                    this.project.setIndexFile(null);
                }
            } else if ("insert".equals(checkBox.getName())) {
                boolean isInsert = checkBox.isSelected();
                fileOption.setInsert(isInsert);
                this.fileOptionsInsertRedirectCheckBox.setEnabled(!isInsert);
            } else if ("force-insert".equals(checkBox.getName())) {
                boolean isForceInsert = checkBox.isSelected();
                fileOption.setForceInsert(isForceInsert);
            } else if ("insert-redirect".equals(checkBox.getName())) {
                boolean isInsertRedirect = checkBox.isSelected();
                fileOption.setInsertRedirect(isInsertRedirect);
                this.fileOptionsCustomKeyTextField.setEnabled(isInsertRedirect);
            } else if ("rename".equals(checkBox.getName())) {
                boolean isRenamed = checkBox.isSelected();
                this.fileOptionsRenameTextField.setEnabled(isRenamed);
                fileOption.setChangedName(isRenamed ? this.fileOptionsRenameTextField.getText() : "");
            }
        } else if (source instanceof JComboBox && "project-files.mime-type".equals((comboBox = (JComboBox)source).getName())) {
            this.updateMimeType((String)comboBox.getSelectedItem());
        }
    }

    private void updateMimeType(String mimeType) {
        this.getSelectedFile().ifPresent(fileOption -> fileOption.setMimeType(mimeType));
    }

    private void updateChangedName(String changedName) {
        this.getSelectedFile().ifPresent(fileOption -> fileOption.setChangedName(changedName));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ScannedFile scannedFile = (ScannedFile)this.projectFileList.getSelectedValue();
        boolean enabled = scannedFile != null;
        String filename = scannedFile == null ? null : scannedFile.getFilename();
        this.defaultFileCheckBox.setEnabled(enabled);
        this.fileOptionsInsertCheckBox.setEnabled(enabled);
        this.fileOptionsRenameCheckBox.setEnabled(enabled);
        this.fileOptionsMIMETypeComboBox.setEnabled(enabled);
        if (filename != null) {
            FileOption fileOption = this.project.getFileOption(filename);
            this.defaultFileCheckBox.setSelected(filename.equals(this.project.getIndexFile()));
            this.fileOptionsInsertCheckBox.setSelected(fileOption.isInsert());
            this.fileOptionsForceInsertCheckBox.setEnabled(!this.project.isAlwaysForceInsert() && scannedFile.getHash().equals(fileOption.getLastInsertHash()));
            this.fileOptionsForceInsertCheckBox.setSelected(fileOption.isForceInsert());
            this.fileOptionsInsertRedirectCheckBox.setEnabled(!fileOption.isInsert());
            this.fileOptionsInsertRedirectCheckBox.setSelected(fileOption.isInsertRedirect());
            this.fileOptionsCustomKeyTextField.setEnabled(fileOption.isInsertRedirect());
            this.fileOptionsCustomKeyTextField.setText(fileOption.getCustomKey());
            this.fileOptionsRenameCheckBox.setSelected(fileOption.getChangedName().isPresent());
            this.fileOptionsRenameTextField.setEnabled(fileOption.getChangedName().isPresent());
            this.fileOptionsRenameTextField.setText(fileOption.getChangedName().orElse(""));
            this.fileOptionsMIMETypeComboBox.getModel().setSelectedItem(fileOption.getMimeType());
        } else {
            this.defaultFileCheckBox.setSelected(false);
            this.fileOptionsInsertCheckBox.setSelected(true);
            this.fileOptionsForceInsertCheckBox.setEnabled(false);
            this.fileOptionsForceInsertCheckBox.setSelected(false);
            this.fileOptionsInsertRedirectCheckBox.setEnabled(false);
            this.fileOptionsInsertRedirectCheckBox.setSelected(false);
            this.fileOptionsCustomKeyTextField.setEnabled(false);
            this.fileOptionsCustomKeyTextField.setText("CHK@");
            this.fileOptionsRenameCheckBox.setEnabled(false);
            this.fileOptionsRenameCheckBox.setSelected(false);
            this.fileOptionsRenameTextField.setEnabled(false);
            this.fileOptionsRenameTextField.setText("");
            this.fileOptionsMIMETypeComboBox.getModel().setSelectedItem("application/octet-stream");
        }
    }

    private void processDocumentUpdate(DocumentEvent documentEvent) {
        ScannedFile scannedFile = (ScannedFile)this.projectFileList.getSelectedValue();
        if (scannedFile == null) {
            return;
        }
        FileOption fileOption = this.project.getFileOption(scannedFile.getFilename());
        Document document = documentEvent.getDocument();
        try {
            String text = document.getText(0, document.getLength());
            fileOption.setCustomKey(text);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.processDocumentUpdate(documentEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.processDocumentUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.processDocumentUpdate(documentEvent);
    }

    private static class StoreDocument
    implements DocumentListener {
        private final Consumer<String> consumer;

        public StoreDocument(Consumer<String> consumer) {
            this.consumer = consumer;
        }

        private void storeDocument(DocumentEvent e) {
            try {
                this.consumer.accept(e.getDocument().getText(0, e.getDocument().getLength()));
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.storeDocument(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.storeDocument(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.storeDocument(e);
        }
    }
}

