/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.gui;

import de.todesbaum.jsite.application.Project;
import de.todesbaum.jsite.gui.FileScannerListener;
import de.todesbaum.jsite.gui.ScannedFile;
import de.todesbaum.jsite.i18n.I18n;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.pterodactylus.util.io.Closer;
import net.pterodactylus.util.io.NullOutputStream;
import net.pterodactylus.util.io.StreamCopier;

public class FileScanner
implements Runnable {
    private static final Logger logger = Logger.getLogger(FileScanner.class.getName());
    private final FileScannerListener fileScannerListener;
    private final Project project;
    private List<ScannedFile> files;
    private boolean error = false;
    private String lastFilename;

    public FileScanner(Project project, FileScannerListener fileScannerListener) {
        this.project = project;
        this.fileScannerListener = Objects.requireNonNull(fileScannerListener);
    }

    public String getLastFilename() {
        return this.lastFilename;
    }

    public void startInBackground() {
        new Thread(this).start();
    }

    @Override
    public void run() {
        this.files = new ArrayList<ScannedFile>();
        this.error = false;
        this.lastFilename = null;
        try {
            this.scanFiles(new File(this.project.getLocalPath()), this.files);
            Collections.sort(this.files);
        }
        catch (IOException ioe1) {
            this.error = true;
        }
        this.fileScannerListener.fileScannerFinished(this.error, this.files);
    }

    public boolean isError() {
        return this.error;
    }

    public List<ScannedFile> getFiles() {
        return this.files;
    }

    private void scanFiles(File rootDir, List<ScannedFile> fileList) throws IOException {
        File[] files = rootDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !FileScanner.this.project.isIgnoreHiddenFiles() || !file.isHidden();
            }
        });
        if (files == null) {
            throw new IOException(I18n.getMessage("jsite.file-scanner.can-not-read-directory"));
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.scanFiles(file, fileList);
                continue;
            }
            String filename = this.project.shortenFilename(file).replace('\\', '/');
            String hash = FileScanner.hashFile(this.project.getLocalPath(), filename);
            fileList.add(new ScannedFile(filename, hash));
            this.lastFilename = filename;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String hashFile(String path, String filename) {
        block7: {
            String string;
            FileInputStream fileInputStream = null;
            DigestOutputStream digestOutputStream = null;
            File file = new File(path, filename);
            try {
                fileInputStream = new FileInputStream(file);
                digestOutputStream = new DigestOutputStream(new NullOutputStream(), MessageDigest.getInstance("SHA-256"));
                StreamCopier.copy((InputStream)fileInputStream, (OutputStream)digestOutputStream, file.length());
                string = FileScanner.toHex(digestOutputStream.getMessageDigest().digest());
                Closer.close(digestOutputStream);
            }
            catch (NoSuchAlgorithmException nsae1) {
                logger.log(Level.WARNING, "Could not get SHA-256 digest!", nsae1);
                break block7;
            }
            catch (IOException ioe1) {
                logger.log(Level.WARNING, "Could not read file!", ioe1);
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Closer.close(digestOutputStream);
                Closer.close(fileInputStream);
            }
            Closer.close(fileInputStream);
            return string;
        }
        return FileScanner.toHex(new byte[32]);
    }

    private static String toHex(byte[] array) {
        StringBuilder hexString = new StringBuilder(array.length * 2);
        for (byte b : array) {
            hexString.append("0123456789abcdef".charAt(b >>> 4 & 0xF)).append("0123456789abcdef".charAt(b & 0xF));
        }
        return hexString.toString();
    }
}

