/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.application.validation;

import de.todesbaum.jsite.application.FileOption;
import de.todesbaum.jsite.application.Project;
import de.todesbaum.jsite.application.validation.CheckReport;
import de.todesbaum.jsite.gui.FileScanner;
import de.todesbaum.jsite.gui.ScannedFile;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class ProjectValidator {
    private static final Logger logger = Logger.getLogger(ProjectValidator.class.getName());

    public static CheckReport validateProject(Project project) {
        FileOption fileOption;
        boolean hasIndexFile;
        Object indexFile;
        CheckReport checkReport = new CheckReport();
        if (project.getLocalPath() == null || project.getLocalPath().trim().length() == 0) {
            checkReport.addIssue("error.no-local-path", true, new String[0]);
            return checkReport;
        }
        if (project.getPath() == null || project.getPath().trim().length() == 0) {
            checkReport.addIssue("error.no-path", true, new String[0]);
        }
        if (project.getIndexFile() == null || project.getIndexFile().length() == 0) {
            checkReport.addIssue("warning.empty-index", false, new String[0]);
        } else {
            indexFile = new File(project.getLocalPath(), project.getIndexFile());
            if (!((File)indexFile).exists()) {
                checkReport.addIssue("error.index-missing", true, new String[0]);
            }
        }
        indexFile = project.getIndexFile();
        boolean bl = hasIndexFile = indexFile != null && ((String)indexFile).length() > 0;
        if (hasIndexFile && ProjectValidator.indexFileIsNotHtml(project, (String)indexFile)) {
            checkReport.addIssue("warning.index-not-html", false, new String[0]);
        }
        Map<String, FileOption> fileOptions = project.getFileOptions();
        Set<Map.Entry<String, FileOption>> fileOptionEntries = fileOptions.entrySet();
        boolean insert = fileOptionEntries.isEmpty();
        for (Map.Entry<String, FileOption> entry : fileOptionEntries) {
            String string = entry.getKey();
            fileOption = entry.getValue();
            insert |= fileOption.isInsert() || fileOption.isInsertRedirect();
            if (string.equals(project.getIndexFile()) && !fileOption.isInsert() && !fileOption.isInsertRedirect()) {
                checkReport.addIssue("error.index-not-inserted", true, new String[0]);
            }
            if (fileOption.isInsert() || !fileOption.isInsertRedirect() || fileOption.getCustomKey().length() != 0 && !"CHK@".equals(fileOption.getCustomKey())) continue;
            checkReport.addIssue("error.no-custom-key", true, string);
        }
        if (!insert) {
            checkReport.addIssue("error.no-files-to-insert", true, new String[0]);
        }
        HashSet<String> fileNames = new HashSet<String>();
        for (Map.Entry<String, FileOption> entry : fileOptionEntries) {
            fileOption = entry.getValue();
            if (!fileOption.isInsert() && !fileOption.isInsertRedirect()) {
                logger.log(Level.FINEST, "Ignoring {0}.", entry.getKey());
                continue;
            }
            String fileName = fileOption.getChangedName().orElse(entry.getKey());
            logger.log(Level.FINEST, "Adding \u201c{0}\u201d for {1}.", new Object[]{fileName, entry.getKey()});
            if (fileNames.add(fileName)) continue;
            checkReport.addIssue("error.duplicate-file", true, fileName);
        }
        long l = 0L;
        CountDownLatch completionLatch = new CountDownLatch(1);
        FileScanner fileScanner = new FileScanner(project, (error, files) -> completionLatch.countDown());
        fileScanner.startInBackground();
        while (completionLatch.getCount() > 0L) {
            try {
                completionLatch.await();
            }
            catch (InterruptedException interruptedException) {}
        }
        for (ScannedFile scannedFile : fileScanner.getFiles()) {
            String fileName = scannedFile.getFilename();
            FileOption fileOption2 = project.getFileOption(fileName);
            if (fileOption2 != null && !fileOption2.isInsert()) continue;
            l += new File(project.getLocalPath(), fileName).length();
        }
        if (l > 0x200000L) {
            checkReport.addIssue("warning.site-larger-than-2-mib", false, new String[0]);
        }
        return checkReport;
    }

    private static boolean indexFileIsNotHtml(Project project, String indexFile) {
        return Stream.of("text/html", "application/xhtml+xml").noneMatch(mimeType -> project.getFileOption(indexFile).getMimeType().startsWith((String)mimeType));
    }
}

