/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.application;

import de.todesbaum.jsite.application.Freenet7Interface;
import de.todesbaum.util.freenet.fcp2.Client;
import de.todesbaum.util.freenet.fcp2.Connection;
import de.todesbaum.util.freenet.fcp2.FcpPluginMessage;
import de.todesbaum.util.freenet.fcp2.Message;
import de.todesbaum.util.freenet.fcp2.wot.DefaultOwnIdentity;
import de.todesbaum.util.freenet.fcp2.wot.OwnIdentity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.pterodactylus.util.logging.Logging;

public class WebOfTrustInterface {
    private static final Logger logger = Logging.getLogger(WebOfTrustInterface.class);
    private static final AtomicLong commandCounter = new AtomicLong(System.nanoTime());
    private final Freenet7Interface freenetInterface;

    public WebOfTrustInterface(Freenet7Interface freenetInterface) {
        this.freenetInterface = freenetInterface;
    }

    public List<OwnIdentity> getOwnIdentities() {
        try {
            Connection connection = this.freenetInterface.getConnection("jSite-WoT-Connector");
            logger.log(Level.INFO, String.format("Trying to connect to node at %s...", this.freenetInterface.getNode()));
            if (!connection.connect()) {
                logger.log(Level.WARNING, "Connection failed.");
                return Collections.emptyList();
            }
            Client client = new Client(connection);
            this.sendFcpCommandToWotPlugin(client);
            Message message = null;
            while (!client.isDisconnected() && message == null) {
                message = client.readMessage(1000L);
            }
            if (message == null) {
                return Collections.emptyList();
            }
            List<OwnIdentity> ownIdentities = this.parseOwnIdentitiesFromMessage(message);
            logger.log(Level.INFO, "Disconnecting from Node.");
            connection.disconnect();
            return ownIdentities;
        }
        catch (IOException ioe1) {
            logger.log(Level.WARNING, String.format("Communication with node at %s failed.", this.freenetInterface.getNode()), ioe1);
            return Collections.emptyList();
        }
    }

    private void sendFcpCommandToWotPlugin(Client client) throws IOException {
        String messageIdentifier = "jSite-WoT-Command-" + commandCounter.getAndIncrement();
        FcpPluginMessage pluginMessage = new FcpPluginMessage(messageIdentifier);
        pluginMessage.setPluginName("plugins.WebOfTrust.WebOfTrust");
        pluginMessage.setParameter("Message", "GetOwnIdentities");
        client.execute(pluginMessage);
    }

    private List<OwnIdentity> parseOwnIdentitiesFromMessage(Message message) {
        ArrayList<OwnIdentity> ownIdentities = new ArrayList<OwnIdentity>();
        if (message.getName().equals("FCPPluginReply")) {
            logger.log(Level.FINE, "Got matching Reply from WebOfTrust.");
            int identityCounter = -1;
            while (message.get("Replies.Identity" + ++identityCounter) != null) {
                String id = message.get("Replies.Identity" + identityCounter);
                String nickname = message.get("Replies.Nickname" + identityCounter);
                String requestUri = WebOfTrustInterface.shortenUri(message.get("Replies.RequestURI" + identityCounter));
                String insertUri = WebOfTrustInterface.shortenUri(message.get("Replies.InsertURI" + identityCounter));
                DefaultOwnIdentity ownIdentity = new DefaultOwnIdentity(id, nickname, requestUri, insertUri);
                logger.log(Level.FINE, String.format("Parsed Own Identity %s.", ownIdentity));
                ownIdentities.add(ownIdentity);
            }
            logger.log(Level.INFO, String.format("Parsed %d Own Identities.", ownIdentities.size()));
        } else if ("ProtocolError".equals(message.getName())) {
            logger.log(Level.WARNING, "WebOfTrust Plugin not found!");
        } else if ("Error".equals(message.getName())) {
            logger.log(Level.WARNING, "WebOfTrust Plugin returned an error!");
        }
        return ownIdentities;
    }

    private static String shortenUri(String uri) {
        String shortenedUri = uri;
        if (shortenedUri.charAt(3) == '@') {
            shortenedUri = shortenedUri.substring(4);
        }
        if (shortenedUri.indexOf(47) > -1) {
            shortenedUri = shortenedUri.substring(0, shortenedUri.indexOf(47));
        }
        return shortenedUri;
    }
}

