/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.application;

import de.todesbaum.jsite.application.AbortedException;
import de.todesbaum.jsite.application.FileOption;
import de.todesbaum.jsite.application.Freenet7Interface;
import de.todesbaum.jsite.application.InsertListener;
import de.todesbaum.jsite.application.Project;
import de.todesbaum.jsite.application.ProjectInsertListeners;
import de.todesbaum.jsite.gui.FileScanner;
import de.todesbaum.jsite.gui.FileScannerListener;
import de.todesbaum.jsite.gui.ScannedFile;
import de.todesbaum.util.freenet.fcp2.Client;
import de.todesbaum.util.freenet.fcp2.ClientPutComplexDir;
import de.todesbaum.util.freenet.fcp2.Command;
import de.todesbaum.util.freenet.fcp2.Connection;
import de.todesbaum.util.freenet.fcp2.DirectFileEntry;
import de.todesbaum.util.freenet.fcp2.FileEntry;
import de.todesbaum.util.freenet.fcp2.Message;
import de.todesbaum.util.freenet.fcp2.PriorityClass;
import de.todesbaum.util.freenet.fcp2.RedirectFileEntry;
import de.todesbaum.util.freenet.fcp2.Verbosity;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.pterodactylus.util.io.StreamCopier;

public class ProjectInserter
implements FileScannerListener,
Runnable {
    private static final Logger logger = Logger.getLogger(ProjectInserter.class.getName());
    private static final int random = (int)(Math.random() * 2.147483647E9);
    private static final AtomicInteger counter = new AtomicInteger();
    private final ProjectInsertListeners projectInsertListeners = new ProjectInsertListeners();
    private Freenet7Interface freenetInterface;
    private Project project;
    private FileScanner fileScanner;
    private final Object lockObject = new Object();
    private String tempDirectory;
    private Connection connection;
    private volatile boolean cancelled = false;
    private StreamCopier.ProgressListener progressListener;
    private boolean useEarlyEncode;
    private PriorityClass priority;

    public void addInsertListener(InsertListener insertListener) {
        this.projectInsertListeners.addInsertListener(insertListener);
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setFreenetInterface(Freenet7Interface freenetInterface) {
        this.freenetInterface = freenetInterface;
    }

    public void setTempDirectory(String tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public void setUseEarlyEncode(boolean useEarlyEncode) {
        this.useEarlyEncode = useEarlyEncode;
    }

    public void setPriority(PriorityClass priority) {
        this.priority = priority;
    }

    public void start(StreamCopier.ProgressListener progressListener) {
        this.cancelled = false;
        this.progressListener = progressListener;
        this.fileScanner = new FileScanner(this.project, this);
        this.fileScanner.startInBackground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.cancelled = true;
        Object object = this.lockObject;
        synchronized (object) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    private Optional<FileEntry> createFileEntry(ScannedFile file) {
        String filename = file.getFilename();
        FileOption fileOption = this.project.getFileOption(filename);
        if (fileOption.isInsert()) {
            fileOption.setCurrentHash(file.getHash());
            if (!this.project.isAlwaysForceInsert() && !fileOption.isForceInsert() && file.getHash().equals(fileOption.getLastInsertHash())) {
                logger.log(Level.FINE, String.format("Inserting redirect to edition %d for %s.", fileOption.getLastInsertEdition(), filename));
                return Optional.of(new RedirectFileEntry(fileOption.getChangedName().orElse(filename), fileOption.getMimeType(), "SSK@" + this.project.getRequestURI() + "/" + this.project.getPath() + "-" + fileOption.getLastInsertEdition() + "/" + fileOption.getLastInsertFilename()));
            }
            try {
                return Optional.of(this.createFileEntry(filename, fileOption.getChangedName(), fileOption.getMimeType()));
            }
            catch (IOException iOException) {
            }
        } else if (fileOption.isInsertRedirect()) {
            return Optional.of(new RedirectFileEntry(fileOption.getChangedName().orElse(filename), fileOption.getMimeType(), fileOption.getCustomKey()));
        }
        return Optional.empty();
    }

    private FileEntry createFileEntry(String filename, Optional<String> changedName, String mimeType) throws FileNotFoundException {
        File physicalFile = new File(this.project.getLocalPath(), filename);
        FileInputStream fileEntryInputStream = new FileInputStream(physicalFile);
        return new DirectFileEntry(changedName.orElse(filename), mimeType, fileEntryInputStream, physicalFile.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.projectInsertListeners.fireProjectInsertStarted(this.project);
        List<ScannedFile> files = this.fileScanner.getFiles();
        Object object = this.lockObject;
        synchronized (object) {
            this.connection = this.freenetInterface.getConnection("project-insert-" + random + counter.getAndIncrement());
        }
        this.connection.setTempDirectory(this.tempDirectory);
        boolean connected = false;
        IOException cause = null;
        try {
            connected = this.connection.connect();
        }
        catch (IOException e1) {
            cause = e1;
        }
        if (!connected || this.cancelled) {
            this.projectInsertListeners.fireProjectInsertFinished(this.project, false, this.cancelled ? new AbortedException() : cause);
            return;
        }
        Client client = new Client(this.connection);
        int edition = this.project.getEdition();
        String dirURI = "USK@" + this.project.getInsertURI() + "/" + this.project.getPath() + "/" + edition + "/";
        ClientPutComplexDir putDir = new ClientPutComplexDir("dir-" + counter.getAndIncrement(), dirURI, this.tempDirectory);
        if (this.project.getIndexFile() != null && this.project.getIndexFile().length() > 0) {
            FileOption indexFileOption = this.project.getFileOption(this.project.getIndexFile());
            Optional<String> changedName = indexFileOption.getChangedName();
            if (changedName.isPresent()) {
                putDir.setDefaultName(changedName.get());
            } else {
                putDir.setDefaultName(this.project.getIndexFile());
            }
        }
        putDir.setVerbosity(Verbosity.ALL);
        putDir.setMaxRetries(-1);
        putDir.setEarlyEncode(this.useEarlyEncode);
        putDir.setPriorityClass(this.priority);
        for (ScannedFile file : files) {
            Optional<FileEntry> fileEntry = this.createFileEntry(file);
            if (!fileEntry.isPresent()) continue;
            try {
                putDir.addFileEntry(fileEntry.get());
            }
            catch (IOException ioe1) {
                this.projectInsertListeners.fireProjectInsertFinished(this.project, false, ioe1);
                return;
            }
        }
        try {
            client.execute((Command)putDir, this.progressListener);
            this.projectInsertListeners.fireProjectUploadFinished(this.project);
        }
        catch (IOException ioe1) {
            this.projectInsertListeners.fireProjectInsertFinished(this.project, false, ioe1);
            return;
        }
        String finalURI = null;
        boolean success = false;
        boolean finished = false;
        boolean disconnected = false;
        while (!finished && !this.cancelled) {
            Message message = client.readMessage();
            finished = message == null || (disconnected = client.isDisconnected());
            logger.log(Level.FINE, "Received message: " + message);
            if (finished) continue;
            String messageName = message.getName();
            if ("URIGenerated".equals(messageName)) {
                finalURI = message.get("URI");
                this.projectInsertListeners.fireProjectURIGenerated(this.project, finalURI);
            }
            if ("SimpleProgress".equals(messageName)) {
                int total = Integer.parseInt(message.get("Total"));
                int succeeded = Integer.parseInt(message.get("Succeeded"));
                int fatal = Integer.parseInt(message.get("FatallyFailed"));
                int failed = Integer.parseInt(message.get("Failed"));
                boolean finalized = Boolean.parseBoolean(message.get("FinalizedTotal"));
                this.projectInsertListeners.fireProjectInsertProgress(this.project, succeeded, failed, fatal, total, finalized);
            }
            finished = (success |= "PutSuccessful".equals(messageName)) && finalURI != null || "PutFailed".equals(messageName) || messageName.endsWith("Error");
        }
        if (success) {
            String editionPart = finalURI.substring(finalURI.lastIndexOf(47) + 1);
            int newEdition = Integer.parseInt(editionPart);
            this.project.setEdition(newEdition);
            this.project.setLastInsertionTime(System.currentTimeMillis());
            this.project.onSuccessfulInsert();
        }
        this.projectInsertListeners.fireProjectInsertFinished(this.project, success, this.cancelled ? new AbortedException() : (disconnected ? new IOException("Connection terminated") : null));
    }

    @Override
    public void fileScannerFinished(boolean error, Collection<ScannedFile> files) {
        if (!error) {
            new Thread(this).start();
        } else {
            this.projectInsertListeners.fireProjectInsertFinished(this.project, false, null);
        }
    }
}

