/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.application;

import de.todesbaum.jsite.application.Node;
import de.todesbaum.util.freenet.fcp2.Client;
import de.todesbaum.util.freenet.fcp2.Command;
import de.todesbaum.util.freenet.fcp2.Connection;
import de.todesbaum.util.freenet.fcp2.GenerateSSK;
import de.todesbaum.util.freenet.fcp2.Message;
import java.io.IOException;

public class Freenet7Interface {
    private static final int number = (int)(Math.random() * 2.147483647E9);
    private static int counter = 0;
    private final NodeSupplier nodeSupplier;
    private final ConnectionSupplier connectionSupplier;
    private final ClientSupplier clientSupplier;
    private de.todesbaum.util.freenet.fcp2.Node node;
    private Connection connection;

    public Freenet7Interface() {
        this(new DefaultNodeSupplier(), new DefaultConnectionSupplier(), new DefaultClientSupplier());
    }

    Freenet7Interface(NodeSupplier nodeSupplier, ConnectionSupplier connectionSupplier, ClientSupplier clientSupplier) {
        this.nodeSupplier = nodeSupplier;
        this.connectionSupplier = connectionSupplier;
        this.clientSupplier = clientSupplier;
    }

    public void setNode(Node node) {
        if (node != null) {
            this.node = this.nodeSupplier.supply(node.getHostname(), node.getPort());
            this.connection = this.connectionSupplier.supply(node, "jSite-" + number + "-connection-" + counter++);
        } else {
            this.node = null;
            this.connection = null;
        }
    }

    public de.todesbaum.util.freenet.fcp2.Node getNode() {
        return this.node;
    }

    public Connection getConnection(String identifier) {
        return this.connectionSupplier.supply(this.node, identifier);
    }

    public boolean isNodePresent() throws IOException {
        if (!this.connection.isConnected()) {
            return this.connection.connect();
        }
        return true;
    }

    public String[] generateKeyPair() throws IOException {
        if (!this.isNodePresent()) {
            throw new IOException("Node is offline.");
        }
        GenerateSSK generateSSK = new GenerateSSK();
        Client client = this.clientSupplier.supply(this.connection, generateSSK);
        Message keypairMessage = client.readMessage();
        return new String[]{keypairMessage.get("InsertURI"), keypairMessage.get("RequestURI")};
    }

    public boolean hasNode() {
        return this.node != null && this.connection != null;
    }

    public static class DefaultClientSupplier
    implements ClientSupplier {
        @Override
        public Client supply(Connection connection, Command command) throws IOException {
            return new Client(connection, command);
        }
    }

    public static interface ClientSupplier {
        public Client supply(Connection var1, Command var2) throws IOException;
    }

    public static class DefaultConnectionSupplier
    implements ConnectionSupplier {
        @Override
        public Connection supply(de.todesbaum.util.freenet.fcp2.Node node, String identifier) {
            return new Connection(node, identifier);
        }
    }

    public static interface ConnectionSupplier {
        public Connection supply(de.todesbaum.util.freenet.fcp2.Node var1, String var2);
    }

    public static class DefaultNodeSupplier
    implements NodeSupplier {
        @Override
        public de.todesbaum.util.freenet.fcp2.Node supply(String hostname, int port) {
            return new de.todesbaum.util.freenet.fcp2.Node(hostname, port);
        }
    }

    public static interface NodeSupplier {
        public de.todesbaum.util.freenet.fcp2.Node supply(String var1, int var2);
    }
}

