# Simple Screen Recorder 🎥

A lightweight terminal-based screen recording tool built in C++ using `ffmpeg` for video capture.  
Supports capturing the screen at fixed 60 FPS with selectable resolution and optional audio input (system sound or external microphone).  
No GUI dependencies required except for the file save dialog (`tinyfiledialogs`).

---

## Features

- Capture screen at 60 FPS (fixed)
- Choose resolution: 480p, 720p, or 1080p
- Toggle audio input: No audio, system sound, or external microphone
- Cross-platform support for Windows and Linux (X11)
- Simple terminal interface with easy-to-understand prompts and emoji-enhanced UX
- Saves recording as MP4 file with user-selected save location

---

## Prerequisites

- [FFmpeg](https://ffmpeg.org/download.html) installed and accessible from your system PATH
- C++ compiler (e.g. `g++`, MSVC)
- [tinyfiledialogs](https://sourceforge.net/projects/tinyfiledialogs/) library for the save file dialog
- On Windows, for capturing system audio you may need to install a virtual audio capture device such as [Virtual Audio Cable](https://vac.muzychenko.net/en/) or [VB-Audio Virtual Cable](https://vb-audio.com/Cable/)
- On Linux, PulseAudio must be installed and running

---

## Building the Project

1. Clone or download this repository.
2. Make sure `tinyfiledialogs` headers and library files are available on your system.
3. Compile the source code:

```bash
g++ -o screen-recorder main.cpp -ltinyfiledialogs

./screen-recorder
