// This file is part of the FidelityFX SDK.
//
// Copyright (C) 2025 Advanced Micro Devices, Inc.
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files(the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and /or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions :
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#if __cplusplus
    #pragma once
    #include "../../../framework/misc/math.h"
#endif // __cplusplus

#if __cplusplus
struct SkydomeCBData
{
    Mat4 ClipToWorld;
};
#else 
// procedural CS version of Skydome uses UpscalerInformation from upscaler.h which binds to b0. So, this needs to bind to b1.
cbuffer SkydomeCBData : register(b1)
{
    matrix ClipToWorld;
}
#endif // __cplusplus

#if __cplusplus

struct ProceduralCBData
{
    Vec3 SunDirection;

    float Rayleigh;
    float Turbidity;
    float MieCoefficient;
    float Luminance;

    float MieDirectionalG;
    float Padding[3];
};

#else

// This need to bind to b2.
cbuffer ProceduralCBData : register(b2)
{
    float4 SunDirection;    // Vector3 are really Vector4s

    float Rayleigh;
    float Turbidity;
    float MieCoefficient;
    float Luminance;

    float MieDirectionalG;
    float3 Padding;
};
#endif // __cplusplus

