// This file is part of the FidelityFX SDK.
//
// Copyright (C) 2025 Advanced Micro Devices, Inc.
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files(the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and /or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions :
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#pragma once

#include "../texture.h"

#include <directx/d3dx12.h>

namespace cauldron
{
    struct TextureCopyDescInternal final
    {
        CD3DX12_TEXTURE_COPY_LOCATION Src;
        CD3DX12_TEXTURE_COPY_LOCATION Dst;
        D3D12_BOX*                    pCopyBox = nullptr;
        D3D12_BOX                     CopyBox;
    };
    static_assert(sizeof(TextureCopyDesc::textureCopyDescMem) >= sizeof(TextureCopyDescInternal), "TextureCopyDesc is not large enough to hold all implementation details. Please grow.");

} // namespace cauldron
