# ComfyUI-Easy-Sam3

[English](README.md) | [中文](README_CN.md)

一个用于 [SAM3 (Segment Anything Model 3)](https://github.com/facebookresearch/sam3) 的 ComfyUI 自定义节点包，提供强大的图像和视频分割功能，支持文本提示。

## 概述

本节点包将 Meta 的 SAM3 模型引入 ComfyUI，实现以下功能：
- **图像分割**：使用文本描述分割图像中的对象
- **视频跟踪**：跨视频帧追踪和分割对象
- **高级配置**：微调视频跟踪参数以获得最佳效果
- **交互式帧编辑器**：用于创建点和边界框提示的可视化编辑器,可用于单帧图像和多视频帧

### 图像分割
![图像分割示例](assets/image.png)
*图像语义分割示例*

### 视频分割
![视频分割示例](assets/video.png)
*视频帧点坐标分割示例*


## 功能特性

- 🖼️ **图像分割**：使用自然语言提示分割对象
- �️ **多类别分割**：支持使用逗号分隔的提示词在单个图像中分隔不同类别的物体（例如："猫, 狗, 人"）
- �🎬 **视频分割**：使用一致的 ID 跨视频帧跟踪对象
- 🎨 **背景选项**：为分割的图像添加自定义背景（黑色、白色、灰色）
- ⚙️ **灵活配置**：支持不同设备（CUDA、CPU、MPS）和精度（fp32、fp16、bf16）
- 🔧 **高级控制**：全面的视频跟踪参数可供微调

## 节点说明

### 1. 加载 SAM3 模型
加载用于图像或视频分割的 SAM3 模型。

**输入：**
- `model`：来自 models/sam3 文件夹的 SAM3 模型文件
- `segmentor`：选择 "image"（图像）或 "video"（视频）模式
- `device`：加载模型的设备（cuda、cpu、mps）
- `precision`：模型精度（fp32、fp16、bf16）

**输出：**
- `sam3_model`：已加载的 SAM3 模型，供下游节点使用

### 2. SAM3 图像分割
使用文本提示和可选的几何提示分割图像中的对象。

**输入：**
- `sam3_model`：来自"加载 SAM3 模型"节点的 SAM3 模型（必须是 'image' 模式）
- `images`：要分割的输入图像
- `prompt`：要分割的对象的文本描述（例如："一只猫"、"人"）。支持使用逗号分隔的提示词来分隔多个类别的物体（例如："猫, 狗, 人"）。同时支持空字符串以仅使用点/框进行分割
- `threshold`：检测的置信度阈值（0.0-1.0，步长：0.05，默认：0.40)
- `keep_model_loaded`：推理后将模型保留在显存中（默认：False）
- `add_background`：为分割后的图像添加背景颜色（选项：none、black、white、grey，默认：none）
- `coordinates_positive`（可选）：正向点坐标以细化分割。格式：JSON 字符串，如 `"[{\"x\": 50, \"y\": 120}]"`
- `coordinates_negative`（可选）：负向点坐标以排除区域。格式：JSON 字符串，如 `"[{\"x\": 150, \"y\": 300}]"`
- `bboxes`（可选）：边界框来引导分割。格式：(x_min, y_min, x_max, y_max) 或 (x, y, width, height)
- `mask`（可选）：用于细化的输入遮罩

**输出：**
- `masks`：合并的分割遮罩（每张图像一个遮罩，所有检测到的对象合并在一起）
- `images`：带 RGBA 透明通道的分割图像（可选背景）
- `obj_masks`：合并前的单个对象遮罩（用于可视化，单独保留所有检测到的对象）
- `boxes`：每个检测对象的边界框坐标 [N, 4] 格式
- `scores`：每个检测对象的置信度分数

### 3. SAM3 视频分割
跨视频帧跟踪和分割对象，支持高级提示选项。

**输入：**
- `sam3_model`：来自"加载 SAM3 模型"节点的 SAM3 模型（必须是 'video' 模式）
- `session_id`（可选）：会话 ID，用于从之前的会话恢复跟踪。如果未提供，将创建新会话
- `video_frames`：作为图像序列的视频帧（张量格式）
- `prompt`：要跟踪的对象的文本描述（例如："人"、"汽车"）。支持空字符串以仅使用点/框进行跟踪
- `frame_index`：应用初始提示的帧索引（最小值：0，最大值：100000，步长：1）。将被限制在有效帧范围内
- `object_id`：多对象跟踪的唯一 ID（最小值：1，最大值：1000，步长：1，默认：1）
- `score_threshold_detection`：检测置信度阈值（0.0-1.0，步长：0.05，默认：0.5）
- `new_det_thresh`：将检测添加为新对象的阈值（0.0-1.0，步长：0.05，默认：0.7）
- `propagation_direction`：传播遮罩的方向（选项：both、forward、backward，默认：both）
- `start_frame_index`：开始传播的帧索引（最小值：0，最大值：100000，步长：1，默认：0）
- `max_frames_to_track`：要处理的最大帧数（最小值：-1，默认：-1 表示所有帧）
- `close_after_propagation`：传播完成后关闭会话（默认：True）
- `keep_model_loaded`：推理后将模型保留在显存中（默认：False）
- `extra_config`（可选）：来自 SAM3 视频模型额外配置节点的附加配置
- `positive_coords`（可选）：正向点击坐标，JSON 字符串格式。格式：`"[{\"x\": 50, \"y\": 120}]"`
- `negative_coords`（可选）：负向点击坐标，JSON 字符串格式。格式：`"[{\"x\": 150, \"y\": 300}]"`
- `bbox`（可选）：用于初始化跟踪的边界框。格式：(x_min, y_min, x_max, y_max) 或 (x, y, width, height)。兼容 KJNodes Points Editor bbox 输出

**输出：**
- `masks`：所有帧的跟踪分割遮罩，[B, H, W] 格式，每帧的对象遮罩已合并
- `session_id`：会话 ID 字符串，用于后续调用中恢复跟踪
- `objects`：对象跟踪信息字典，包含 `obj_ids` 和 `obj_masks` 数组
- `obj_masks`：每帧的单个对象遮罩，[B, N, H, W] 格式，其中 N 是跟踪的最大对象数量

### 4. SAM3 获取对象ID列表
从 SAM3 视频分割输出中获取所有对象 ID 和数量。

**输入：**
- `objects`：来自 SAM3 视频分割节点的对象输出（包含 `obj_ids` 和 `obj_masks`）

**输出：**
- `object_ids`：视频中跟踪到的所有对象 ID 列表
- `count`：跟踪到的对象总数

**使用场景：**
此节点对于了解视频中检测和跟踪到的对象至关重要。它可以帮助您：
- 发现可用于提取的所有对象 ID
- 确定成功跟踪的对象数量
- 根据跟踪对象的数量规划下游处理
- 通过验证检测到的对象来调试跟踪问题

**示例：**
如果您的视频跟踪了 3 个对象，此节点将输出：
- `obj_ids`: [0, 1, 2]
- `count`: 3

然后您可以使用这些 ID 配合 SAM3 获取对象遮罩节点来提取单个对象的遮罩。

### 6. SAM3 获取对象遮罩
从 SAM3 视频分割输出中提取特定对象 ID 的遮罩。

**输入：**
- `objects`：来自 SAM3 视频分割节点的对象输出（包含 `obj_ids` 和 `obj_masks`）
- `obj_id`：要提取遮罩的对象索引ID（最小值：0，最大值：1000，默认：0）

**输出：**
- `mask`：指定对象 ID 的提取遮罩张量，[B, H, W] 格式。如果未找到对象 ID，则返回空遮罩

**使用场景：**
当视频中有多个跟踪对象时，此节点可用于隔离特定对象的遮罩以进行进一步处理。例如：
- 从包含多人的视频中提取一个人的遮罩（object_id=1）
- 在工作流中单独处理不同的对象
- 对特定跟踪对象应用不同的效果或变换

### 7. SAM3 视频模型额外配置
配置视频分割的高级参数，以微调跟踪行为。

**参数：**
- `assoc_iou_thresh`：检测到跟踪匹配的 IoU 阈值（0.0-1.0，默认：0.1）
- `det_nms_thresh`：检测 NMS 的 IoU 阈值（0.0-1.0，默认：0.1）
- `new_det_thresh`：添加新对象的阈值（0.0-1.0，默认：0.7）
- `hotstart_delay`：延迟 N 帧输出以移除不匹配/重复的轨迹（0-100，默认：15）
- `hotstart_unmatch_thresh`：在热启动期间移除未匹配此帧数的轨迹（0-100，默认：8）
- `hotstart_dup_thresh`：在热启动期间移除重叠的轨迹（0-100，默认：8）
- `suppress_unmatched_within_hotstart`：仅在热启动期间抑制未匹配的遮罩（默认：True）
- `min_trk_keep_alive`：最小保持活动值（-100-0，默认：-1，负值表示立即移除）
- `max_trk_keep_alive`：没有检测时保持跟踪活动的最大帧数（0-100，默认：30）
- `init_trk_keep_alive`：创建新跟踪时的初始保持活动值（-10-100，默认：30）
- `suppress_overlap_occlusion_thresh`：基于近期遮挡抑制重叠对象的阈值（0.0-1.0，默认：0.7，0.0 表示禁用）
- `suppress_det_at_boundary`：抑制接近图像边界的检测（默认：False）
- `fill_hole_area`：填充遮罩中小于此面积（像素）的孔洞（0-1000，默认：16）
- `recondition_every_nth_frame`：每 N 帧重新调整跟踪（-1-1000，默认：16，-1 表示禁用）
- `enable_masklet_confirmation`：启用掩码确认以抑制未确认的轨迹（默认：False）
- `decrease_alive_for_empty_masks`：减少空掩码的保持活动计数器（默认：False）
- `image_size`：模型的输入图像大小（256-2048，步长：8，默认：1008）

**输出：**
- `extra_config`：视频分割节点的配置字典

### 8. Sam3 可视化生成
在图像上可视化分割遮罩，并叠加边界框和置信度分数。

**输入：**
- `image`：用于显示遮罩的输入图像（张量格式）
- `obj_masks`：来自 Sam3 图像分割节点的单个对象遮罩。格式：[B, N, H, W]，其中 N 是对象数量
- `scores`（可选）：来自 Sam3 图像分割节点的置信度分数（最小值：0，最大值：1，步长：0.0001）
- `alpha`：遮罩叠加的透明度（0.0-1.0，步长：0.05，默认：0.5）。0=完全透明，1=完全不透明
- `stroke_width`：遮罩边框的宽度（像素）（最小值：1，最大值：100，步长：1，默认：5）

**输出：**
- `visualization`：叠加了彩色遮罩、边框和置信度分数的可视化图像

### 9. 帧编辑器
用于在图像/视频帧上创建点和边界框提示的交互式可视化编辑器。

**输入：**
- `images`：要标注的输入图像或视频帧（张量格式）
- `info`：包含标注数据的 JSON 字符串（由小部件自动管理）
- `preview_rescale`：预览图像的缩放系数（0.05-1.0，步长：0.05，默认：1.0）。当小于 1.0 时，预览图像会被调整大小以提高性能，坐标和边界框会自动转换回原始比例

**输出：**
- `positive_coords`：正向点坐标的 JSON 字符串，格式为 `"[{\"x\": 50, \"y\": 120}]"`
- `negative_coords`：负向点坐标的 JSON 字符串，格式为 `"[{\"x\": 150, \"y\": 300}]"`
- `bboxes`：边界框列表，格式为 `[[x1, y1, x2, y2], ...]`
- `frame_index`：当前正在编辑的帧索引（用于视频序列）

**功能特性：**
- **交互式画布**：显示图像/帧的可视化画布
- **点模式**：点击添加正向点（绿色）或负向点（红色）
- **框选模式**：拖动绘制边界框以选择对象
- **帧导航**：对于视频序列，使用滑块/控件在帧之间导航
- **撤销/重做**：支持所有标注的完整历史记录
- **全部清除**：重置按钮以移除所有标注
- **实时预览**：查看叠加在图像上的标注

**使用方法：**
1. 将图像或视频帧连接到 `images` 输入
2. 小部件显示带有图像的交互式画布
3. 使用工具栏在点模式和框选模式之间切换
4. 点击（用于点）或拖动（用于框）创建标注
5. 对于视频，使用帧滑块导航并标注不同的帧
6. 将输出直接连接到 SAM3 图像/视频分割节点

**工具栏控件：**
- **撤销/重做**：在标注历史中导航
- **全部清除**：从当前帧移除所有标注
- **点模式**：添加正向点（左键单击）或负向点（右键单击）
- **框选模式**：拖动绘制边界框

**使用场景：**
- 为 SAM3 图像分割创建精确的点提示
- 绘制边界框以引导对象检测
- 标注视频帧用于 SAM3 视频分割
- 通过添加正向和负向点来细化分割
- 快速原型制作和测试不同的提示策略

**提示：**
- 使用正向点（绿色）表示"包含此区域"
- 使用负向点（红色）表示"排除此区域"
- 边界框提供模型关注的大致区域
- 对于视频，可以在任何帧索引上进行标注
- 编辑器缓存图像预览以提高大型数据集的性能

## 使用示例

### 基础图像分割
1. 加载 SAM3 模型（模式：image）
2. 连接到 SAM3 图像分割节点
3. 提供输入图像和文本提示
4. 获取分割遮罩和图像

### 使用帧编辑器进行交互式图像分割
1. 加载 SAM3 模型（模式：image）
2. 将图像连接到帧编辑器
3. 使用交互式画布添加点或绘制框
4. 将帧编辑器输出连接到 SAM3 图像分割
5. 根据您的标注查看实时分割结果

### 视频对象跟踪
1. 加载 SAM3 模型（模式：video）
2. （可选）创建额外配置节点进行高级设置
3. 连接到 SAM3 视频分割节点
4. 提供视频帧和跟踪参数
5. 获取所有帧的跟踪遮罩

### 使用帧编辑器进行交互式视频分割
1. 加载 SAM3 模型（模式：video）
2. 将视频帧连接到帧编辑器
3. 导航到要开始跟踪的帧
4. 添加点或框以选择对象
5. 将帧编辑器输出（包括 frame_index）连接到 SAM3 视频分割
6. 模型将在所有帧中跟踪您选择的对象

## 模型下载

从仓库下载 SAM3 模型权重：
- [SAM3 模型](https://huggingface.co/facebook/sam3)
- [SAM3 FP16 模型](https://huggingface.co/yolain/sam3-safetensors/blob/main/sam3-fp16.safetensors)

将下载的模型放置在：`ComfyUI/models/sam3/`

## 系统要求

- Python 3.8+
- PyTorch 2.0+
- ComfyUI
- CUDA 兼容的 GPU（推荐）

## 本地化支持

本节点包支持多种语言：
- 英语（`locales/en/nodeDefs.json`）
- 中文（`locales/zh/nodeDefs.json`）

## 致谢

- **SAM3**：[Facebook Research](https://github.com/facebookresearch/sam3)
- **ComfyUI**：[comfyanonymous](https://github.com/comfyanonymous/ComfyUI)
- **ComfyUI-segment-anything-2** ：[ComfyUI-segment-anything-2](https://github.com/kijai/ComfyUI-segment-anything-2)
- **ComfyUI-KJNodes** ：[ComfyUI-KJNodes](https://github.com/kijai/ComfyUI-KJNodes)
- **ComfyUI-Sam3**: [ComfyUI-SAM3](https://github.com/PozzettiAndrea/ComfyUI-SAM3)

## 许可证

本项目遵循原始 SAM3 仓库的许可证。

## 贡献

欢迎贡献！请随时提交问题或拉取请求。

## 更新日志

### v1.0.4

- 修复和 `wanvideowrapper` 节点同时使用时存在 `Unexpected floating ScalarType` 报错的情况

### v1.0.3

- 将 `sam3GetObjectMask` 节点的 `obj_id` 重新定义为对象索引ID，方便与可视化中的对象索引ID对应

### v1.0.2

- 增加 `easy framesEditor` 节点以进行交互式图像/视频帧标注
- 修复 `sam3GetObjectMask` 节点输出多对象时存在bug情况

### v1.0.1

- 增加 `easy sam3GetObjectIds` 节点以获取对象ID列表
- 增加 `easy sam3GetObjectMask` 节点以提取特定对象ID的遮罩
- 修复 `start_frame_index` 不为0时，对象遮罩未对齐帧

### v1.0.0

- 首次发布
- 支持文本提示的图像分割
- 视频跟踪和分割
- 图像分割包含背景颜色选项
- 高级视频跟踪配置
- 多语言支持（英文/中文）
