-- ==============================================================
-- RTL generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
-- Version: 2018.2
-- Copyright (C) 1986-2018 Xilinx, Inc. All Rights Reserved.
-- 
-- ===========================================================

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity video_scaler is
generic (
    C_S_AXI_CTRL_ADDR_WIDTH : INTEGER := 6;
    C_S_AXI_CTRL_DATA_WIDTH : INTEGER := 32 );
port (
    s_axi_ctrl_AWVALID : IN STD_LOGIC;
    s_axi_ctrl_AWREADY : OUT STD_LOGIC;
    s_axi_ctrl_AWADDR : IN STD_LOGIC_VECTOR (C_S_AXI_CTRL_ADDR_WIDTH-1 downto 0);
    s_axi_ctrl_WVALID : IN STD_LOGIC;
    s_axi_ctrl_WREADY : OUT STD_LOGIC;
    s_axi_ctrl_WDATA : IN STD_LOGIC_VECTOR (C_S_AXI_CTRL_DATA_WIDTH-1 downto 0);
    s_axi_ctrl_WSTRB : IN STD_LOGIC_VECTOR (C_S_AXI_CTRL_DATA_WIDTH/8-1 downto 0);
    s_axi_ctrl_ARVALID : IN STD_LOGIC;
    s_axi_ctrl_ARREADY : OUT STD_LOGIC;
    s_axi_ctrl_ARADDR : IN STD_LOGIC_VECTOR (C_S_AXI_CTRL_ADDR_WIDTH-1 downto 0);
    s_axi_ctrl_RVALID : OUT STD_LOGIC;
    s_axi_ctrl_RREADY : IN STD_LOGIC;
    s_axi_ctrl_RDATA : OUT STD_LOGIC_VECTOR (C_S_AXI_CTRL_DATA_WIDTH-1 downto 0);
    s_axi_ctrl_RRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
    s_axi_ctrl_BVALID : OUT STD_LOGIC;
    s_axi_ctrl_BREADY : IN STD_LOGIC;
    s_axi_ctrl_BRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
    ap_clk : IN STD_LOGIC;
    ap_rst_n : IN STD_LOGIC;
    interrupt : OUT STD_LOGIC;
    stream_in_TDATA : IN STD_LOGIC_VECTOR (23 downto 0);
    stream_in_TKEEP : IN STD_LOGIC_VECTOR (2 downto 0);
    stream_in_TSTRB : IN STD_LOGIC_VECTOR (2 downto 0);
    stream_in_TUSER : IN STD_LOGIC_VECTOR (0 downto 0);
    stream_in_TLAST : IN STD_LOGIC_VECTOR (0 downto 0);
    stream_in_TID : IN STD_LOGIC_VECTOR (0 downto 0);
    stream_in_TDEST : IN STD_LOGIC_VECTOR (0 downto 0);
    stream_out_TDATA : OUT STD_LOGIC_VECTOR (23 downto 0);
    stream_out_TKEEP : OUT STD_LOGIC_VECTOR (2 downto 0);
    stream_out_TSTRB : OUT STD_LOGIC_VECTOR (2 downto 0);
    stream_out_TUSER : OUT STD_LOGIC_VECTOR (0 downto 0);
    stream_out_TLAST : OUT STD_LOGIC_VECTOR (0 downto 0);
    stream_out_TID : OUT STD_LOGIC_VECTOR (0 downto 0);
    stream_out_TDEST : OUT STD_LOGIC_VECTOR (0 downto 0);
    stream_in_TVALID : IN STD_LOGIC;
    stream_in_TREADY : OUT STD_LOGIC;
    stream_out_TVALID : OUT STD_LOGIC;
    stream_out_TREADY : IN STD_LOGIC );
end;


architecture behav of video_scaler is 
    attribute CORE_GENERATION_INFO : STRING;
    attribute CORE_GENERATION_INFO of behav : architecture is
    "video_scaler,hls_ip_2018_2,{HLS_INPUT_TYPE=cxx,HLS_INPUT_FLOAT=0,HLS_INPUT_FIXED=0,HLS_INPUT_PART=xc7z020clg484-1,HLS_INPUT_CLOCK=6.670000,HLS_INPUT_ARCH=dataflow,HLS_SYN_CLOCK=6.380000,HLS_SYN_LAT=-1,HLS_SYN_TPT=-1,HLS_SYN_MEM=24,HLS_SYN_DSP=68,HLS_SYN_FF=14153,HLS_SYN_LUT=10721,HLS_VERSION=2018_2}";
    constant C_S_AXI_DATA_WIDTH : INTEGER range 63 downto 0 := 20;
    constant C_S_AXI_WSTRB_WIDTH : INTEGER range 63 downto 0 := 4;
    constant C_S_AXI_ADDR_WIDTH : INTEGER range 63 downto 0 := 20;
    constant ap_const_logic_1 : STD_LOGIC := '1';
    constant ap_const_lv24_0 : STD_LOGIC_VECTOR (23 downto 0) := "000000000000000000000000";
    constant ap_const_lv3_0 : STD_LOGIC_VECTOR (2 downto 0) := "000";
    constant ap_const_lv1_0 : STD_LOGIC_VECTOR (0 downto 0) := "0";
    constant ap_const_logic_0 : STD_LOGIC := '0';
    constant ap_const_lv2_0 : STD_LOGIC_VECTOR (1 downto 0) := "00";
    constant ap_const_lv2_1 : STD_LOGIC_VECTOR (1 downto 0) := "01";
    constant ap_const_boolean_1 : BOOLEAN := true;

    signal ap_rst_n_inv : STD_LOGIC;
    signal ap_start : STD_LOGIC;
    signal ap_ready : STD_LOGIC;
    signal ap_done : STD_LOGIC;
    signal ap_idle : STD_LOGIC;
    signal in_width : STD_LOGIC_VECTOR (31 downto 0);
    signal in_height : STD_LOGIC_VECTOR (31 downto 0);
    signal out_width : STD_LOGIC_VECTOR (31 downto 0);
    signal out_height : STD_LOGIC_VECTOR (31 downto 0);
    signal Block_Mat_exit45_pro_U0_ap_start : STD_LOGIC;
    signal Block_Mat_exit45_pro_U0_ap_done : STD_LOGIC;
    signal Block_Mat_exit45_pro_U0_ap_continue : STD_LOGIC;
    signal Block_Mat_exit45_pro_U0_ap_idle : STD_LOGIC;
    signal Block_Mat_exit45_pro_U0_ap_ready : STD_LOGIC;
    signal Block_Mat_exit45_pro_U0_start_out : STD_LOGIC;
    signal Block_Mat_exit45_pro_U0_start_write : STD_LOGIC;
    signal Block_Mat_exit45_pro_U0_img_in_rows_V_out_din : STD_LOGIC_VECTOR (31 downto 0);
    signal Block_Mat_exit45_pro_U0_img_in_rows_V_out_write : STD_LOGIC;
    signal Block_Mat_exit45_pro_U0_img_in_cols_V_out_din : STD_LOGIC_VECTOR (31 downto 0);
    signal Block_Mat_exit45_pro_U0_img_in_cols_V_out_write : STD_LOGIC;
    signal Block_Mat_exit45_pro_U0_img_out_rows_V_out_din : STD_LOGIC_VECTOR (31 downto 0);
    signal Block_Mat_exit45_pro_U0_img_out_rows_V_out_write : STD_LOGIC;
    signal Block_Mat_exit45_pro_U0_img_out_cols_V_out_din : STD_LOGIC_VECTOR (31 downto 0);
    signal Block_Mat_exit45_pro_U0_img_out_cols_V_out_write : STD_LOGIC;
    signal AXIvideo2Mat_U0_ap_start : STD_LOGIC;
    signal AXIvideo2Mat_U0_ap_done : STD_LOGIC;
    signal AXIvideo2Mat_U0_ap_continue : STD_LOGIC;
    signal AXIvideo2Mat_U0_ap_idle : STD_LOGIC;
    signal AXIvideo2Mat_U0_ap_ready : STD_LOGIC;
    signal AXIvideo2Mat_U0_stream_in_TREADY : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_rows_V_read : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_cols_V_read : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_data_stream_0_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal AXIvideo2Mat_U0_img_data_stream_0_V_write : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_data_stream_1_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal AXIvideo2Mat_U0_img_data_stream_1_V_write : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_data_stream_2_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal AXIvideo2Mat_U0_img_data_stream_2_V_write : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_rows_V_out_din : STD_LOGIC_VECTOR (31 downto 0);
    signal AXIvideo2Mat_U0_img_rows_V_out_write : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_cols_V_out_din : STD_LOGIC_VECTOR (31 downto 0);
    signal AXIvideo2Mat_U0_img_cols_V_out_write : STD_LOGIC;
    signal Resize_U0_ap_start : STD_LOGIC;
    signal Resize_U0_ap_done : STD_LOGIC;
    signal Resize_U0_ap_continue : STD_LOGIC;
    signal Resize_U0_ap_idle : STD_LOGIC;
    signal Resize_U0_ap_ready : STD_LOGIC;
    signal Resize_U0_start_out : STD_LOGIC;
    signal Resize_U0_start_write : STD_LOGIC;
    signal Resize_U0_p_src_rows_V_read : STD_LOGIC;
    signal Resize_U0_p_src_cols_V_read : STD_LOGIC;
    signal Resize_U0_p_src_data_stream_0_V_read : STD_LOGIC;
    signal Resize_U0_p_src_data_stream_1_V_read : STD_LOGIC;
    signal Resize_U0_p_src_data_stream_2_V_read : STD_LOGIC;
    signal Resize_U0_p_dst_rows_V_read : STD_LOGIC;
    signal Resize_U0_p_dst_cols_V_read : STD_LOGIC;
    signal Resize_U0_p_dst_data_stream_0_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal Resize_U0_p_dst_data_stream_0_V_write : STD_LOGIC;
    signal Resize_U0_p_dst_data_stream_1_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal Resize_U0_p_dst_data_stream_1_V_write : STD_LOGIC;
    signal Resize_U0_p_dst_data_stream_2_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal Resize_U0_p_dst_data_stream_2_V_write : STD_LOGIC;
    signal Resize_U0_p_dst_rows_V_out_din : STD_LOGIC_VECTOR (31 downto 0);
    signal Resize_U0_p_dst_rows_V_out_write : STD_LOGIC;
    signal Resize_U0_p_dst_cols_V_out_din : STD_LOGIC_VECTOR (31 downto 0);
    signal Resize_U0_p_dst_cols_V_out_write : STD_LOGIC;
    signal Mat2AXIvideo_U0_ap_start : STD_LOGIC;
    signal Mat2AXIvideo_U0_ap_done : STD_LOGIC;
    signal Mat2AXIvideo_U0_ap_continue : STD_LOGIC;
    signal Mat2AXIvideo_U0_ap_idle : STD_LOGIC;
    signal Mat2AXIvideo_U0_ap_ready : STD_LOGIC;
    signal Mat2AXIvideo_U0_img_rows_V_read : STD_LOGIC;
    signal Mat2AXIvideo_U0_img_cols_V_read : STD_LOGIC;
    signal Mat2AXIvideo_U0_img_data_stream_0_V_read : STD_LOGIC;
    signal Mat2AXIvideo_U0_img_data_stream_1_V_read : STD_LOGIC;
    signal Mat2AXIvideo_U0_img_data_stream_2_V_read : STD_LOGIC;
    signal Mat2AXIvideo_U0_stream_out_TDATA : STD_LOGIC_VECTOR (23 downto 0);
    signal Mat2AXIvideo_U0_stream_out_TVALID : STD_LOGIC;
    signal Mat2AXIvideo_U0_stream_out_TKEEP : STD_LOGIC_VECTOR (2 downto 0);
    signal Mat2AXIvideo_U0_stream_out_TSTRB : STD_LOGIC_VECTOR (2 downto 0);
    signal Mat2AXIvideo_U0_stream_out_TUSER : STD_LOGIC_VECTOR (0 downto 0);
    signal Mat2AXIvideo_U0_stream_out_TLAST : STD_LOGIC_VECTOR (0 downto 0);
    signal Mat2AXIvideo_U0_stream_out_TID : STD_LOGIC_VECTOR (0 downto 0);
    signal Mat2AXIvideo_U0_stream_out_TDEST : STD_LOGIC_VECTOR (0 downto 0);
    signal ap_sync_continue : STD_LOGIC;
    signal img_in_rows_V_c_full_n : STD_LOGIC;
    signal img_in_rows_V_c_dout : STD_LOGIC_VECTOR (31 downto 0);
    signal img_in_rows_V_c_empty_n : STD_LOGIC;
    signal img_in_cols_V_c_full_n : STD_LOGIC;
    signal img_in_cols_V_c_dout : STD_LOGIC_VECTOR (31 downto 0);
    signal img_in_cols_V_c_empty_n : STD_LOGIC;
    signal img_out_rows_V_c_full_n : STD_LOGIC;
    signal img_out_rows_V_c_dout : STD_LOGIC_VECTOR (31 downto 0);
    signal img_out_rows_V_c_empty_n : STD_LOGIC;
    signal img_out_cols_V_c_full_n : STD_LOGIC;
    signal img_out_cols_V_c_dout : STD_LOGIC_VECTOR (31 downto 0);
    signal img_out_cols_V_c_empty_n : STD_LOGIC;
    signal img_in_data_stream_0_full_n : STD_LOGIC;
    signal img_in_data_stream_0_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img_in_data_stream_0_empty_n : STD_LOGIC;
    signal img_in_data_stream_1_full_n : STD_LOGIC;
    signal img_in_data_stream_1_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img_in_data_stream_1_empty_n : STD_LOGIC;
    signal img_in_data_stream_2_full_n : STD_LOGIC;
    signal img_in_data_stream_2_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img_in_data_stream_2_empty_n : STD_LOGIC;
    signal img_in_rows_V_c13_full_n : STD_LOGIC;
    signal img_in_rows_V_c13_dout : STD_LOGIC_VECTOR (31 downto 0);
    signal img_in_rows_V_c13_empty_n : STD_LOGIC;
    signal img_in_cols_V_c14_full_n : STD_LOGIC;
    signal img_in_cols_V_c14_dout : STD_LOGIC_VECTOR (31 downto 0);
    signal img_in_cols_V_c14_empty_n : STD_LOGIC;
    signal img_out_data_stream_s_full_n : STD_LOGIC;
    signal img_out_data_stream_s_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img_out_data_stream_s_empty_n : STD_LOGIC;
    signal img_out_data_stream_1_full_n : STD_LOGIC;
    signal img_out_data_stream_1_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img_out_data_stream_1_empty_n : STD_LOGIC;
    signal img_out_data_stream_2_full_n : STD_LOGIC;
    signal img_out_data_stream_2_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img_out_data_stream_2_empty_n : STD_LOGIC;
    signal img_out_rows_V_c15_full_n : STD_LOGIC;
    signal img_out_rows_V_c15_dout : STD_LOGIC_VECTOR (31 downto 0);
    signal img_out_rows_V_c15_empty_n : STD_LOGIC;
    signal img_out_cols_V_c16_full_n : STD_LOGIC;
    signal img_out_cols_V_c16_dout : STD_LOGIC_VECTOR (31 downto 0);
    signal img_out_cols_V_c16_empty_n : STD_LOGIC;
    signal ap_sync_done : STD_LOGIC;
    signal ap_sync_ready : STD_LOGIC;
    signal ap_sync_reg_AXIvideo2Mat_U0_ap_ready : STD_LOGIC := '0';
    signal ap_sync_AXIvideo2Mat_U0_ap_ready : STD_LOGIC;
    signal AXIvideo2Mat_U0_ap_ready_count : STD_LOGIC_VECTOR (1 downto 0) := "00";
    signal ap_sync_reg_Block_Mat_exit45_pro_U0_ap_ready : STD_LOGIC := '0';
    signal ap_sync_Block_Mat_exit45_pro_U0_ap_ready : STD_LOGIC;
    signal Block_Mat_exit45_pro_U0_ap_ready_count : STD_LOGIC_VECTOR (1 downto 0) := "00";
    signal start_for_Resize_U0_din : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_Resize_U0_full_n : STD_LOGIC;
    signal start_for_Resize_U0_dout : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_Resize_U0_empty_n : STD_LOGIC;
    signal AXIvideo2Mat_U0_start_full_n : STD_LOGIC;
    signal AXIvideo2Mat_U0_start_write : STD_LOGIC;
    signal start_for_Mat2AXIvideo_U0_din : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_Mat2AXIvideo_U0_full_n : STD_LOGIC;
    signal start_for_Mat2AXIvideo_U0_dout : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_Mat2AXIvideo_U0_empty_n : STD_LOGIC;
    signal Mat2AXIvideo_U0_start_full_n : STD_LOGIC;
    signal Mat2AXIvideo_U0_start_write : STD_LOGIC;

    component Block_Mat_exit45_pro IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        start_full_n : IN STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        start_out : OUT STD_LOGIC;
        start_write : OUT STD_LOGIC;
        in_width : IN STD_LOGIC_VECTOR (31 downto 0);
        in_height : IN STD_LOGIC_VECTOR (31 downto 0);
        out_width : IN STD_LOGIC_VECTOR (31 downto 0);
        out_height : IN STD_LOGIC_VECTOR (31 downto 0);
        img_in_rows_V_out_din : OUT STD_LOGIC_VECTOR (31 downto 0);
        img_in_rows_V_out_full_n : IN STD_LOGIC;
        img_in_rows_V_out_write : OUT STD_LOGIC;
        img_in_cols_V_out_din : OUT STD_LOGIC_VECTOR (31 downto 0);
        img_in_cols_V_out_full_n : IN STD_LOGIC;
        img_in_cols_V_out_write : OUT STD_LOGIC;
        img_out_rows_V_out_din : OUT STD_LOGIC_VECTOR (31 downto 0);
        img_out_rows_V_out_full_n : IN STD_LOGIC;
        img_out_rows_V_out_write : OUT STD_LOGIC;
        img_out_cols_V_out_din : OUT STD_LOGIC_VECTOR (31 downto 0);
        img_out_cols_V_out_full_n : IN STD_LOGIC;
        img_out_cols_V_out_write : OUT STD_LOGIC );
    end component;


    component AXIvideo2Mat IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        stream_in_TDATA : IN STD_LOGIC_VECTOR (23 downto 0);
        stream_in_TVALID : IN STD_LOGIC;
        stream_in_TREADY : OUT STD_LOGIC;
        stream_in_TKEEP : IN STD_LOGIC_VECTOR (2 downto 0);
        stream_in_TSTRB : IN STD_LOGIC_VECTOR (2 downto 0);
        stream_in_TUSER : IN STD_LOGIC_VECTOR (0 downto 0);
        stream_in_TLAST : IN STD_LOGIC_VECTOR (0 downto 0);
        stream_in_TID : IN STD_LOGIC_VECTOR (0 downto 0);
        stream_in_TDEST : IN STD_LOGIC_VECTOR (0 downto 0);
        img_rows_V_dout : IN STD_LOGIC_VECTOR (31 downto 0);
        img_rows_V_empty_n : IN STD_LOGIC;
        img_rows_V_read : OUT STD_LOGIC;
        img_cols_V_dout : IN STD_LOGIC_VECTOR (31 downto 0);
        img_cols_V_empty_n : IN STD_LOGIC;
        img_cols_V_read : OUT STD_LOGIC;
        img_data_stream_0_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_0_V_full_n : IN STD_LOGIC;
        img_data_stream_0_V_write : OUT STD_LOGIC;
        img_data_stream_1_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_1_V_full_n : IN STD_LOGIC;
        img_data_stream_1_V_write : OUT STD_LOGIC;
        img_data_stream_2_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_2_V_full_n : IN STD_LOGIC;
        img_data_stream_2_V_write : OUT STD_LOGIC;
        img_rows_V_out_din : OUT STD_LOGIC_VECTOR (31 downto 0);
        img_rows_V_out_full_n : IN STD_LOGIC;
        img_rows_V_out_write : OUT STD_LOGIC;
        img_cols_V_out_din : OUT STD_LOGIC_VECTOR (31 downto 0);
        img_cols_V_out_full_n : IN STD_LOGIC;
        img_cols_V_out_write : OUT STD_LOGIC );
    end component;


    component Resize IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        start_full_n : IN STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        start_out : OUT STD_LOGIC;
        start_write : OUT STD_LOGIC;
        p_src_rows_V_dout : IN STD_LOGIC_VECTOR (31 downto 0);
        p_src_rows_V_empty_n : IN STD_LOGIC;
        p_src_rows_V_read : OUT STD_LOGIC;
        p_src_cols_V_dout : IN STD_LOGIC_VECTOR (31 downto 0);
        p_src_cols_V_empty_n : IN STD_LOGIC;
        p_src_cols_V_read : OUT STD_LOGIC;
        p_src_data_stream_0_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        p_src_data_stream_0_V_empty_n : IN STD_LOGIC;
        p_src_data_stream_0_V_read : OUT STD_LOGIC;
        p_src_data_stream_1_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        p_src_data_stream_1_V_empty_n : IN STD_LOGIC;
        p_src_data_stream_1_V_read : OUT STD_LOGIC;
        p_src_data_stream_2_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        p_src_data_stream_2_V_empty_n : IN STD_LOGIC;
        p_src_data_stream_2_V_read : OUT STD_LOGIC;
        p_dst_rows_V_dout : IN STD_LOGIC_VECTOR (31 downto 0);
        p_dst_rows_V_empty_n : IN STD_LOGIC;
        p_dst_rows_V_read : OUT STD_LOGIC;
        p_dst_cols_V_dout : IN STD_LOGIC_VECTOR (31 downto 0);
        p_dst_cols_V_empty_n : IN STD_LOGIC;
        p_dst_cols_V_read : OUT STD_LOGIC;
        p_dst_data_stream_0_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        p_dst_data_stream_0_V_full_n : IN STD_LOGIC;
        p_dst_data_stream_0_V_write : OUT STD_LOGIC;
        p_dst_data_stream_1_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        p_dst_data_stream_1_V_full_n : IN STD_LOGIC;
        p_dst_data_stream_1_V_write : OUT STD_LOGIC;
        p_dst_data_stream_2_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        p_dst_data_stream_2_V_full_n : IN STD_LOGIC;
        p_dst_data_stream_2_V_write : OUT STD_LOGIC;
        p_dst_rows_V_out_din : OUT STD_LOGIC_VECTOR (31 downto 0);
        p_dst_rows_V_out_full_n : IN STD_LOGIC;
        p_dst_rows_V_out_write : OUT STD_LOGIC;
        p_dst_cols_V_out_din : OUT STD_LOGIC_VECTOR (31 downto 0);
        p_dst_cols_V_out_full_n : IN STD_LOGIC;
        p_dst_cols_V_out_write : OUT STD_LOGIC );
    end component;


    component Mat2AXIvideo IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        img_rows_V_dout : IN STD_LOGIC_VECTOR (31 downto 0);
        img_rows_V_empty_n : IN STD_LOGIC;
        img_rows_V_read : OUT STD_LOGIC;
        img_cols_V_dout : IN STD_LOGIC_VECTOR (31 downto 0);
        img_cols_V_empty_n : IN STD_LOGIC;
        img_cols_V_read : OUT STD_LOGIC;
        img_data_stream_0_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_0_V_empty_n : IN STD_LOGIC;
        img_data_stream_0_V_read : OUT STD_LOGIC;
        img_data_stream_1_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_1_V_empty_n : IN STD_LOGIC;
        img_data_stream_1_V_read : OUT STD_LOGIC;
        img_data_stream_2_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_2_V_empty_n : IN STD_LOGIC;
        img_data_stream_2_V_read : OUT STD_LOGIC;
        stream_out_TDATA : OUT STD_LOGIC_VECTOR (23 downto 0);
        stream_out_TVALID : OUT STD_LOGIC;
        stream_out_TREADY : IN STD_LOGIC;
        stream_out_TKEEP : OUT STD_LOGIC_VECTOR (2 downto 0);
        stream_out_TSTRB : OUT STD_LOGIC_VECTOR (2 downto 0);
        stream_out_TUSER : OUT STD_LOGIC_VECTOR (0 downto 0);
        stream_out_TLAST : OUT STD_LOGIC_VECTOR (0 downto 0);
        stream_out_TID : OUT STD_LOGIC_VECTOR (0 downto 0);
        stream_out_TDEST : OUT STD_LOGIC_VECTOR (0 downto 0) );
    end component;


    component fifo_w32_d2_A IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (31 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (31 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component fifo_w32_d3_A IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (31 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (31 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component fifo_w8_d2_A IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (7 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (7 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component start_for_Resize_U0 IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (0 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (0 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component start_for_Mat2AXImb6 IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (0 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (0 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component video_scaler_ctrl_s_axi IS
    generic (
        C_S_AXI_ADDR_WIDTH : INTEGER;
        C_S_AXI_DATA_WIDTH : INTEGER );
    port (
        AWVALID : IN STD_LOGIC;
        AWREADY : OUT STD_LOGIC;
        AWADDR : IN STD_LOGIC_VECTOR (C_S_AXI_ADDR_WIDTH-1 downto 0);
        WVALID : IN STD_LOGIC;
        WREADY : OUT STD_LOGIC;
        WDATA : IN STD_LOGIC_VECTOR (C_S_AXI_DATA_WIDTH-1 downto 0);
        WSTRB : IN STD_LOGIC_VECTOR (C_S_AXI_DATA_WIDTH/8-1 downto 0);
        ARVALID : IN STD_LOGIC;
        ARREADY : OUT STD_LOGIC;
        ARADDR : IN STD_LOGIC_VECTOR (C_S_AXI_ADDR_WIDTH-1 downto 0);
        RVALID : OUT STD_LOGIC;
        RREADY : IN STD_LOGIC;
        RDATA : OUT STD_LOGIC_VECTOR (C_S_AXI_DATA_WIDTH-1 downto 0);
        RRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
        BVALID : OUT STD_LOGIC;
        BREADY : IN STD_LOGIC;
        BRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
        ACLK : IN STD_LOGIC;
        ARESET : IN STD_LOGIC;
        ACLK_EN : IN STD_LOGIC;
        ap_start : OUT STD_LOGIC;
        interrupt : OUT STD_LOGIC;
        ap_ready : IN STD_LOGIC;
        ap_done : IN STD_LOGIC;
        ap_idle : IN STD_LOGIC;
        in_width : OUT STD_LOGIC_VECTOR (31 downto 0);
        in_height : OUT STD_LOGIC_VECTOR (31 downto 0);
        out_width : OUT STD_LOGIC_VECTOR (31 downto 0);
        out_height : OUT STD_LOGIC_VECTOR (31 downto 0) );
    end component;



begin
    video_scaler_ctrl_s_axi_U : component video_scaler_ctrl_s_axi
    generic map (
        C_S_AXI_ADDR_WIDTH => C_S_AXI_CTRL_ADDR_WIDTH,
        C_S_AXI_DATA_WIDTH => C_S_AXI_CTRL_DATA_WIDTH)
    port map (
        AWVALID => s_axi_ctrl_AWVALID,
        AWREADY => s_axi_ctrl_AWREADY,
        AWADDR => s_axi_ctrl_AWADDR,
        WVALID => s_axi_ctrl_WVALID,
        WREADY => s_axi_ctrl_WREADY,
        WDATA => s_axi_ctrl_WDATA,
        WSTRB => s_axi_ctrl_WSTRB,
        ARVALID => s_axi_ctrl_ARVALID,
        ARREADY => s_axi_ctrl_ARREADY,
        ARADDR => s_axi_ctrl_ARADDR,
        RVALID => s_axi_ctrl_RVALID,
        RREADY => s_axi_ctrl_RREADY,
        RDATA => s_axi_ctrl_RDATA,
        RRESP => s_axi_ctrl_RRESP,
        BVALID => s_axi_ctrl_BVALID,
        BREADY => s_axi_ctrl_BREADY,
        BRESP => s_axi_ctrl_BRESP,
        ACLK => ap_clk,
        ARESET => ap_rst_n_inv,
        ACLK_EN => ap_const_logic_1,
        ap_start => ap_start,
        interrupt => interrupt,
        ap_ready => ap_ready,
        ap_done => ap_done,
        ap_idle => ap_idle,
        in_width => in_width,
        in_height => in_height,
        out_width => out_width,
        out_height => out_height);

    Block_Mat_exit45_pro_U0 : component Block_Mat_exit45_pro
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => Block_Mat_exit45_pro_U0_ap_start,
        start_full_n => start_for_Resize_U0_full_n,
        ap_done => Block_Mat_exit45_pro_U0_ap_done,
        ap_continue => Block_Mat_exit45_pro_U0_ap_continue,
        ap_idle => Block_Mat_exit45_pro_U0_ap_idle,
        ap_ready => Block_Mat_exit45_pro_U0_ap_ready,
        start_out => Block_Mat_exit45_pro_U0_start_out,
        start_write => Block_Mat_exit45_pro_U0_start_write,
        in_width => in_width,
        in_height => in_height,
        out_width => out_width,
        out_height => out_height,
        img_in_rows_V_out_din => Block_Mat_exit45_pro_U0_img_in_rows_V_out_din,
        img_in_rows_V_out_full_n => img_in_rows_V_c_full_n,
        img_in_rows_V_out_write => Block_Mat_exit45_pro_U0_img_in_rows_V_out_write,
        img_in_cols_V_out_din => Block_Mat_exit45_pro_U0_img_in_cols_V_out_din,
        img_in_cols_V_out_full_n => img_in_cols_V_c_full_n,
        img_in_cols_V_out_write => Block_Mat_exit45_pro_U0_img_in_cols_V_out_write,
        img_out_rows_V_out_din => Block_Mat_exit45_pro_U0_img_out_rows_V_out_din,
        img_out_rows_V_out_full_n => img_out_rows_V_c_full_n,
        img_out_rows_V_out_write => Block_Mat_exit45_pro_U0_img_out_rows_V_out_write,
        img_out_cols_V_out_din => Block_Mat_exit45_pro_U0_img_out_cols_V_out_din,
        img_out_cols_V_out_full_n => img_out_cols_V_c_full_n,
        img_out_cols_V_out_write => Block_Mat_exit45_pro_U0_img_out_cols_V_out_write);

    AXIvideo2Mat_U0 : component AXIvideo2Mat
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => AXIvideo2Mat_U0_ap_start,
        ap_done => AXIvideo2Mat_U0_ap_done,
        ap_continue => AXIvideo2Mat_U0_ap_continue,
        ap_idle => AXIvideo2Mat_U0_ap_idle,
        ap_ready => AXIvideo2Mat_U0_ap_ready,
        stream_in_TDATA => stream_in_TDATA,
        stream_in_TVALID => stream_in_TVALID,
        stream_in_TREADY => AXIvideo2Mat_U0_stream_in_TREADY,
        stream_in_TKEEP => stream_in_TKEEP,
        stream_in_TSTRB => stream_in_TSTRB,
        stream_in_TUSER => stream_in_TUSER,
        stream_in_TLAST => stream_in_TLAST,
        stream_in_TID => stream_in_TID,
        stream_in_TDEST => stream_in_TDEST,
        img_rows_V_dout => img_in_rows_V_c_dout,
        img_rows_V_empty_n => img_in_rows_V_c_empty_n,
        img_rows_V_read => AXIvideo2Mat_U0_img_rows_V_read,
        img_cols_V_dout => img_in_cols_V_c_dout,
        img_cols_V_empty_n => img_in_cols_V_c_empty_n,
        img_cols_V_read => AXIvideo2Mat_U0_img_cols_V_read,
        img_data_stream_0_V_din => AXIvideo2Mat_U0_img_data_stream_0_V_din,
        img_data_stream_0_V_full_n => img_in_data_stream_0_full_n,
        img_data_stream_0_V_write => AXIvideo2Mat_U0_img_data_stream_0_V_write,
        img_data_stream_1_V_din => AXIvideo2Mat_U0_img_data_stream_1_V_din,
        img_data_stream_1_V_full_n => img_in_data_stream_1_full_n,
        img_data_stream_1_V_write => AXIvideo2Mat_U0_img_data_stream_1_V_write,
        img_data_stream_2_V_din => AXIvideo2Mat_U0_img_data_stream_2_V_din,
        img_data_stream_2_V_full_n => img_in_data_stream_2_full_n,
        img_data_stream_2_V_write => AXIvideo2Mat_U0_img_data_stream_2_V_write,
        img_rows_V_out_din => AXIvideo2Mat_U0_img_rows_V_out_din,
        img_rows_V_out_full_n => img_in_rows_V_c13_full_n,
        img_rows_V_out_write => AXIvideo2Mat_U0_img_rows_V_out_write,
        img_cols_V_out_din => AXIvideo2Mat_U0_img_cols_V_out_din,
        img_cols_V_out_full_n => img_in_cols_V_c14_full_n,
        img_cols_V_out_write => AXIvideo2Mat_U0_img_cols_V_out_write);

    Resize_U0 : component Resize
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => Resize_U0_ap_start,
        start_full_n => start_for_Mat2AXIvideo_U0_full_n,
        ap_done => Resize_U0_ap_done,
        ap_continue => Resize_U0_ap_continue,
        ap_idle => Resize_U0_ap_idle,
        ap_ready => Resize_U0_ap_ready,
        start_out => Resize_U0_start_out,
        start_write => Resize_U0_start_write,
        p_src_rows_V_dout => img_in_rows_V_c13_dout,
        p_src_rows_V_empty_n => img_in_rows_V_c13_empty_n,
        p_src_rows_V_read => Resize_U0_p_src_rows_V_read,
        p_src_cols_V_dout => img_in_cols_V_c14_dout,
        p_src_cols_V_empty_n => img_in_cols_V_c14_empty_n,
        p_src_cols_V_read => Resize_U0_p_src_cols_V_read,
        p_src_data_stream_0_V_dout => img_in_data_stream_0_dout,
        p_src_data_stream_0_V_empty_n => img_in_data_stream_0_empty_n,
        p_src_data_stream_0_V_read => Resize_U0_p_src_data_stream_0_V_read,
        p_src_data_stream_1_V_dout => img_in_data_stream_1_dout,
        p_src_data_stream_1_V_empty_n => img_in_data_stream_1_empty_n,
        p_src_data_stream_1_V_read => Resize_U0_p_src_data_stream_1_V_read,
        p_src_data_stream_2_V_dout => img_in_data_stream_2_dout,
        p_src_data_stream_2_V_empty_n => img_in_data_stream_2_empty_n,
        p_src_data_stream_2_V_read => Resize_U0_p_src_data_stream_2_V_read,
        p_dst_rows_V_dout => img_out_rows_V_c_dout,
        p_dst_rows_V_empty_n => img_out_rows_V_c_empty_n,
        p_dst_rows_V_read => Resize_U0_p_dst_rows_V_read,
        p_dst_cols_V_dout => img_out_cols_V_c_dout,
        p_dst_cols_V_empty_n => img_out_cols_V_c_empty_n,
        p_dst_cols_V_read => Resize_U0_p_dst_cols_V_read,
        p_dst_data_stream_0_V_din => Resize_U0_p_dst_data_stream_0_V_din,
        p_dst_data_stream_0_V_full_n => img_out_data_stream_s_full_n,
        p_dst_data_stream_0_V_write => Resize_U0_p_dst_data_stream_0_V_write,
        p_dst_data_stream_1_V_din => Resize_U0_p_dst_data_stream_1_V_din,
        p_dst_data_stream_1_V_full_n => img_out_data_stream_1_full_n,
        p_dst_data_stream_1_V_write => Resize_U0_p_dst_data_stream_1_V_write,
        p_dst_data_stream_2_V_din => Resize_U0_p_dst_data_stream_2_V_din,
        p_dst_data_stream_2_V_full_n => img_out_data_stream_2_full_n,
        p_dst_data_stream_2_V_write => Resize_U0_p_dst_data_stream_2_V_write,
        p_dst_rows_V_out_din => Resize_U0_p_dst_rows_V_out_din,
        p_dst_rows_V_out_full_n => img_out_rows_V_c15_full_n,
        p_dst_rows_V_out_write => Resize_U0_p_dst_rows_V_out_write,
        p_dst_cols_V_out_din => Resize_U0_p_dst_cols_V_out_din,
        p_dst_cols_V_out_full_n => img_out_cols_V_c16_full_n,
        p_dst_cols_V_out_write => Resize_U0_p_dst_cols_V_out_write);

    Mat2AXIvideo_U0 : component Mat2AXIvideo
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => Mat2AXIvideo_U0_ap_start,
        ap_done => Mat2AXIvideo_U0_ap_done,
        ap_continue => Mat2AXIvideo_U0_ap_continue,
        ap_idle => Mat2AXIvideo_U0_ap_idle,
        ap_ready => Mat2AXIvideo_U0_ap_ready,
        img_rows_V_dout => img_out_rows_V_c15_dout,
        img_rows_V_empty_n => img_out_rows_V_c15_empty_n,
        img_rows_V_read => Mat2AXIvideo_U0_img_rows_V_read,
        img_cols_V_dout => img_out_cols_V_c16_dout,
        img_cols_V_empty_n => img_out_cols_V_c16_empty_n,
        img_cols_V_read => Mat2AXIvideo_U0_img_cols_V_read,
        img_data_stream_0_V_dout => img_out_data_stream_s_dout,
        img_data_stream_0_V_empty_n => img_out_data_stream_s_empty_n,
        img_data_stream_0_V_read => Mat2AXIvideo_U0_img_data_stream_0_V_read,
        img_data_stream_1_V_dout => img_out_data_stream_1_dout,
        img_data_stream_1_V_empty_n => img_out_data_stream_1_empty_n,
        img_data_stream_1_V_read => Mat2AXIvideo_U0_img_data_stream_1_V_read,
        img_data_stream_2_V_dout => img_out_data_stream_2_dout,
        img_data_stream_2_V_empty_n => img_out_data_stream_2_empty_n,
        img_data_stream_2_V_read => Mat2AXIvideo_U0_img_data_stream_2_V_read,
        stream_out_TDATA => Mat2AXIvideo_U0_stream_out_TDATA,
        stream_out_TVALID => Mat2AXIvideo_U0_stream_out_TVALID,
        stream_out_TREADY => stream_out_TREADY,
        stream_out_TKEEP => Mat2AXIvideo_U0_stream_out_TKEEP,
        stream_out_TSTRB => Mat2AXIvideo_U0_stream_out_TSTRB,
        stream_out_TUSER => Mat2AXIvideo_U0_stream_out_TUSER,
        stream_out_TLAST => Mat2AXIvideo_U0_stream_out_TLAST,
        stream_out_TID => Mat2AXIvideo_U0_stream_out_TID,
        stream_out_TDEST => Mat2AXIvideo_U0_stream_out_TDEST);

    img_in_rows_V_c_U : component fifo_w32_d2_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_Mat_exit45_pro_U0_img_in_rows_V_out_din,
        if_full_n => img_in_rows_V_c_full_n,
        if_write => Block_Mat_exit45_pro_U0_img_in_rows_V_out_write,
        if_dout => img_in_rows_V_c_dout,
        if_empty_n => img_in_rows_V_c_empty_n,
        if_read => AXIvideo2Mat_U0_img_rows_V_read);

    img_in_cols_V_c_U : component fifo_w32_d2_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_Mat_exit45_pro_U0_img_in_cols_V_out_din,
        if_full_n => img_in_cols_V_c_full_n,
        if_write => Block_Mat_exit45_pro_U0_img_in_cols_V_out_write,
        if_dout => img_in_cols_V_c_dout,
        if_empty_n => img_in_cols_V_c_empty_n,
        if_read => AXIvideo2Mat_U0_img_cols_V_read);

    img_out_rows_V_c_U : component fifo_w32_d3_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_Mat_exit45_pro_U0_img_out_rows_V_out_din,
        if_full_n => img_out_rows_V_c_full_n,
        if_write => Block_Mat_exit45_pro_U0_img_out_rows_V_out_write,
        if_dout => img_out_rows_V_c_dout,
        if_empty_n => img_out_rows_V_c_empty_n,
        if_read => Resize_U0_p_dst_rows_V_read);

    img_out_cols_V_c_U : component fifo_w32_d3_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_Mat_exit45_pro_U0_img_out_cols_V_out_din,
        if_full_n => img_out_cols_V_c_full_n,
        if_write => Block_Mat_exit45_pro_U0_img_out_cols_V_out_write,
        if_dout => img_out_cols_V_c_dout,
        if_empty_n => img_out_cols_V_c_empty_n,
        if_read => Resize_U0_p_dst_cols_V_read);

    img_in_data_stream_0_U : component fifo_w8_d2_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => AXIvideo2Mat_U0_img_data_stream_0_V_din,
        if_full_n => img_in_data_stream_0_full_n,
        if_write => AXIvideo2Mat_U0_img_data_stream_0_V_write,
        if_dout => img_in_data_stream_0_dout,
        if_empty_n => img_in_data_stream_0_empty_n,
        if_read => Resize_U0_p_src_data_stream_0_V_read);

    img_in_data_stream_1_U : component fifo_w8_d2_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => AXIvideo2Mat_U0_img_data_stream_1_V_din,
        if_full_n => img_in_data_stream_1_full_n,
        if_write => AXIvideo2Mat_U0_img_data_stream_1_V_write,
        if_dout => img_in_data_stream_1_dout,
        if_empty_n => img_in_data_stream_1_empty_n,
        if_read => Resize_U0_p_src_data_stream_1_V_read);

    img_in_data_stream_2_U : component fifo_w8_d2_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => AXIvideo2Mat_U0_img_data_stream_2_V_din,
        if_full_n => img_in_data_stream_2_full_n,
        if_write => AXIvideo2Mat_U0_img_data_stream_2_V_write,
        if_dout => img_in_data_stream_2_dout,
        if_empty_n => img_in_data_stream_2_empty_n,
        if_read => Resize_U0_p_src_data_stream_2_V_read);

    img_in_rows_V_c13_U : component fifo_w32_d2_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => AXIvideo2Mat_U0_img_rows_V_out_din,
        if_full_n => img_in_rows_V_c13_full_n,
        if_write => AXIvideo2Mat_U0_img_rows_V_out_write,
        if_dout => img_in_rows_V_c13_dout,
        if_empty_n => img_in_rows_V_c13_empty_n,
        if_read => Resize_U0_p_src_rows_V_read);

    img_in_cols_V_c14_U : component fifo_w32_d2_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => AXIvideo2Mat_U0_img_cols_V_out_din,
        if_full_n => img_in_cols_V_c14_full_n,
        if_write => AXIvideo2Mat_U0_img_cols_V_out_write,
        if_dout => img_in_cols_V_c14_dout,
        if_empty_n => img_in_cols_V_c14_empty_n,
        if_read => Resize_U0_p_src_cols_V_read);

    img_out_data_stream_s_U : component fifo_w8_d2_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Resize_U0_p_dst_data_stream_0_V_din,
        if_full_n => img_out_data_stream_s_full_n,
        if_write => Resize_U0_p_dst_data_stream_0_V_write,
        if_dout => img_out_data_stream_s_dout,
        if_empty_n => img_out_data_stream_s_empty_n,
        if_read => Mat2AXIvideo_U0_img_data_stream_0_V_read);

    img_out_data_stream_1_U : component fifo_w8_d2_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Resize_U0_p_dst_data_stream_1_V_din,
        if_full_n => img_out_data_stream_1_full_n,
        if_write => Resize_U0_p_dst_data_stream_1_V_write,
        if_dout => img_out_data_stream_1_dout,
        if_empty_n => img_out_data_stream_1_empty_n,
        if_read => Mat2AXIvideo_U0_img_data_stream_1_V_read);

    img_out_data_stream_2_U : component fifo_w8_d2_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Resize_U0_p_dst_data_stream_2_V_din,
        if_full_n => img_out_data_stream_2_full_n,
        if_write => Resize_U0_p_dst_data_stream_2_V_write,
        if_dout => img_out_data_stream_2_dout,
        if_empty_n => img_out_data_stream_2_empty_n,
        if_read => Mat2AXIvideo_U0_img_data_stream_2_V_read);

    img_out_rows_V_c15_U : component fifo_w32_d2_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Resize_U0_p_dst_rows_V_out_din,
        if_full_n => img_out_rows_V_c15_full_n,
        if_write => Resize_U0_p_dst_rows_V_out_write,
        if_dout => img_out_rows_V_c15_dout,
        if_empty_n => img_out_rows_V_c15_empty_n,
        if_read => Mat2AXIvideo_U0_img_rows_V_read);

    img_out_cols_V_c16_U : component fifo_w32_d2_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Resize_U0_p_dst_cols_V_out_din,
        if_full_n => img_out_cols_V_c16_full_n,
        if_write => Resize_U0_p_dst_cols_V_out_write,
        if_dout => img_out_cols_V_c16_dout,
        if_empty_n => img_out_cols_V_c16_empty_n,
        if_read => Mat2AXIvideo_U0_img_cols_V_read);

    start_for_Resize_U0_U : component start_for_Resize_U0
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => start_for_Resize_U0_din,
        if_full_n => start_for_Resize_U0_full_n,
        if_write => Block_Mat_exit45_pro_U0_start_write,
        if_dout => start_for_Resize_U0_dout,
        if_empty_n => start_for_Resize_U0_empty_n,
        if_read => Resize_U0_ap_ready);

    start_for_Mat2AXImb6_U : component start_for_Mat2AXImb6
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => start_for_Mat2AXIvideo_U0_din,
        if_full_n => start_for_Mat2AXIvideo_U0_full_n,
        if_write => Resize_U0_start_write,
        if_dout => start_for_Mat2AXIvideo_U0_dout,
        if_empty_n => start_for_Mat2AXIvideo_U0_empty_n,
        if_read => Mat2AXIvideo_U0_ap_ready);





    ap_sync_reg_AXIvideo2Mat_U0_ap_ready_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_sync_reg_AXIvideo2Mat_U0_ap_ready <= ap_const_logic_0;
            else
                if (((ap_sync_ready and ap_start) = ap_const_logic_1)) then 
                    ap_sync_reg_AXIvideo2Mat_U0_ap_ready <= ap_const_logic_0;
                else 
                    ap_sync_reg_AXIvideo2Mat_U0_ap_ready <= ap_sync_AXIvideo2Mat_U0_ap_ready;
                end if; 
            end if;
        end if;
    end process;


    ap_sync_reg_Block_Mat_exit45_pro_U0_ap_ready_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_sync_reg_Block_Mat_exit45_pro_U0_ap_ready <= ap_const_logic_0;
            else
                if (((ap_sync_ready and ap_start) = ap_const_logic_1)) then 
                    ap_sync_reg_Block_Mat_exit45_pro_U0_ap_ready <= ap_const_logic_0;
                else 
                    ap_sync_reg_Block_Mat_exit45_pro_U0_ap_ready <= ap_sync_Block_Mat_exit45_pro_U0_ap_ready;
                end if; 
            end if;
        end if;
    end process;


    AXIvideo2Mat_U0_ap_ready_count_assign_proc : process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if (((ap_const_logic_0 = AXIvideo2Mat_U0_ap_ready) and (ap_sync_ready = ap_const_logic_1))) then 
                AXIvideo2Mat_U0_ap_ready_count <= std_logic_vector(unsigned(AXIvideo2Mat_U0_ap_ready_count) - unsigned(ap_const_lv2_1));
            elsif (((ap_const_logic_1 = AXIvideo2Mat_U0_ap_ready) and (ap_sync_ready = ap_const_logic_0))) then 
                AXIvideo2Mat_U0_ap_ready_count <= std_logic_vector(unsigned(AXIvideo2Mat_U0_ap_ready_count) + unsigned(ap_const_lv2_1));
            end if; 
        end if;
    end process;

    Block_Mat_exit45_pro_U0_ap_ready_count_assign_proc : process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if (((ap_const_logic_0 = Block_Mat_exit45_pro_U0_ap_ready) and (ap_sync_ready = ap_const_logic_1))) then 
                Block_Mat_exit45_pro_U0_ap_ready_count <= std_logic_vector(unsigned(Block_Mat_exit45_pro_U0_ap_ready_count) - unsigned(ap_const_lv2_1));
            elsif (((ap_const_logic_1 = Block_Mat_exit45_pro_U0_ap_ready) and (ap_sync_ready = ap_const_logic_0))) then 
                Block_Mat_exit45_pro_U0_ap_ready_count <= std_logic_vector(unsigned(Block_Mat_exit45_pro_U0_ap_ready_count) + unsigned(ap_const_lv2_1));
            end if; 
        end if;
    end process;
    AXIvideo2Mat_U0_ap_continue <= ap_const_logic_1;
    AXIvideo2Mat_U0_ap_start <= ((ap_sync_reg_AXIvideo2Mat_U0_ap_ready xor ap_const_logic_1) and ap_start);
    AXIvideo2Mat_U0_start_full_n <= ap_const_logic_1;
    AXIvideo2Mat_U0_start_write <= ap_const_logic_0;
    Block_Mat_exit45_pro_U0_ap_continue <= ap_const_logic_1;
    Block_Mat_exit45_pro_U0_ap_start <= ((ap_sync_reg_Block_Mat_exit45_pro_U0_ap_ready xor ap_const_logic_1) and ap_start);
    Mat2AXIvideo_U0_ap_continue <= ap_const_logic_1;
    Mat2AXIvideo_U0_ap_start <= start_for_Mat2AXIvideo_U0_empty_n;
    Mat2AXIvideo_U0_start_full_n <= ap_const_logic_1;
    Mat2AXIvideo_U0_start_write <= ap_const_logic_0;
    Resize_U0_ap_continue <= ap_const_logic_1;
    Resize_U0_ap_start <= start_for_Resize_U0_empty_n;
    ap_done <= Mat2AXIvideo_U0_ap_done;
    ap_idle <= (Resize_U0_ap_idle and Mat2AXIvideo_U0_ap_idle and Block_Mat_exit45_pro_U0_ap_idle and AXIvideo2Mat_U0_ap_idle);
    ap_ready <= ap_sync_ready;

    ap_rst_n_inv_assign_proc : process(ap_rst_n)
    begin
                ap_rst_n_inv <= not(ap_rst_n);
    end process;

    ap_sync_AXIvideo2Mat_U0_ap_ready <= (ap_sync_reg_AXIvideo2Mat_U0_ap_ready or AXIvideo2Mat_U0_ap_ready);
    ap_sync_Block_Mat_exit45_pro_U0_ap_ready <= (ap_sync_reg_Block_Mat_exit45_pro_U0_ap_ready or Block_Mat_exit45_pro_U0_ap_ready);
    ap_sync_continue <= ap_const_logic_1;
    ap_sync_done <= Mat2AXIvideo_U0_ap_done;
    ap_sync_ready <= (ap_sync_Block_Mat_exit45_pro_U0_ap_ready and ap_sync_AXIvideo2Mat_U0_ap_ready);
    start_for_Mat2AXIvideo_U0_din <= (0=>ap_const_logic_1, others=>'-');
    start_for_Resize_U0_din <= (0=>ap_const_logic_1, others=>'-');
    stream_in_TREADY <= AXIvideo2Mat_U0_stream_in_TREADY;
    stream_out_TDATA <= Mat2AXIvideo_U0_stream_out_TDATA;
    stream_out_TDEST <= Mat2AXIvideo_U0_stream_out_TDEST;
    stream_out_TID <= Mat2AXIvideo_U0_stream_out_TID;
    stream_out_TKEEP <= Mat2AXIvideo_U0_stream_out_TKEEP;
    stream_out_TLAST <= Mat2AXIvideo_U0_stream_out_TLAST;
    stream_out_TSTRB <= Mat2AXIvideo_U0_stream_out_TSTRB;
    stream_out_TUSER <= Mat2AXIvideo_U0_stream_out_TUSER;
    stream_out_TVALID <= Mat2AXIvideo_U0_stream_out_TVALID;
end behav;
