// ==============================================================
// RTL generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
// Version: 2018.2
// Copyright (C) 1986-2018 Xilinx, Inc. All Rights Reserved.
// 
// ===========================================================

`timescale 1 ns / 1 ps 

(* CORE_GENERATION_INFO="video_scaler,hls_ip_2018_2,{HLS_INPUT_TYPE=cxx,HLS_INPUT_FLOAT=0,HLS_INPUT_FIXED=0,HLS_INPUT_PART=xc7z020clg484-1,HLS_INPUT_CLOCK=6.670000,HLS_INPUT_ARCH=dataflow,HLS_SYN_CLOCK=6.380000,HLS_SYN_LAT=-1,HLS_SYN_TPT=-1,HLS_SYN_MEM=24,HLS_SYN_DSP=68,HLS_SYN_FF=14153,HLS_SYN_LUT=10721,HLS_VERSION=2018_2}" *)

module video_scaler (
        s_axi_ctrl_AWVALID,
        s_axi_ctrl_AWREADY,
        s_axi_ctrl_AWADDR,
        s_axi_ctrl_WVALID,
        s_axi_ctrl_WREADY,
        s_axi_ctrl_WDATA,
        s_axi_ctrl_WSTRB,
        s_axi_ctrl_ARVALID,
        s_axi_ctrl_ARREADY,
        s_axi_ctrl_ARADDR,
        s_axi_ctrl_RVALID,
        s_axi_ctrl_RREADY,
        s_axi_ctrl_RDATA,
        s_axi_ctrl_RRESP,
        s_axi_ctrl_BVALID,
        s_axi_ctrl_BREADY,
        s_axi_ctrl_BRESP,
        ap_clk,
        ap_rst_n,
        interrupt,
        stream_in_TDATA,
        stream_in_TKEEP,
        stream_in_TSTRB,
        stream_in_TUSER,
        stream_in_TLAST,
        stream_in_TID,
        stream_in_TDEST,
        stream_out_TDATA,
        stream_out_TKEEP,
        stream_out_TSTRB,
        stream_out_TUSER,
        stream_out_TLAST,
        stream_out_TID,
        stream_out_TDEST,
        stream_in_TVALID,
        stream_in_TREADY,
        stream_out_TVALID,
        stream_out_TREADY
);

parameter    C_S_AXI_CTRL_DATA_WIDTH = 32;
parameter    C_S_AXI_CTRL_ADDR_WIDTH = 6;
parameter    C_S_AXI_DATA_WIDTH = 32;
parameter    C_S_AXI_ADDR_WIDTH = 32;

parameter C_S_AXI_CTRL_WSTRB_WIDTH = (32 / 8);
parameter C_S_AXI_WSTRB_WIDTH = (32 / 8);

input   s_axi_ctrl_AWVALID;
output   s_axi_ctrl_AWREADY;
input  [C_S_AXI_CTRL_ADDR_WIDTH - 1:0] s_axi_ctrl_AWADDR;
input   s_axi_ctrl_WVALID;
output   s_axi_ctrl_WREADY;
input  [C_S_AXI_CTRL_DATA_WIDTH - 1:0] s_axi_ctrl_WDATA;
input  [C_S_AXI_CTRL_WSTRB_WIDTH - 1:0] s_axi_ctrl_WSTRB;
input   s_axi_ctrl_ARVALID;
output   s_axi_ctrl_ARREADY;
input  [C_S_AXI_CTRL_ADDR_WIDTH - 1:0] s_axi_ctrl_ARADDR;
output   s_axi_ctrl_RVALID;
input   s_axi_ctrl_RREADY;
output  [C_S_AXI_CTRL_DATA_WIDTH - 1:0] s_axi_ctrl_RDATA;
output  [1:0] s_axi_ctrl_RRESP;
output   s_axi_ctrl_BVALID;
input   s_axi_ctrl_BREADY;
output  [1:0] s_axi_ctrl_BRESP;
input   ap_clk;
input   ap_rst_n;
output   interrupt;
input  [23:0] stream_in_TDATA;
input  [2:0] stream_in_TKEEP;
input  [2:0] stream_in_TSTRB;
input  [0:0] stream_in_TUSER;
input  [0:0] stream_in_TLAST;
input  [0:0] stream_in_TID;
input  [0:0] stream_in_TDEST;
output  [23:0] stream_out_TDATA;
output  [2:0] stream_out_TKEEP;
output  [2:0] stream_out_TSTRB;
output  [0:0] stream_out_TUSER;
output  [0:0] stream_out_TLAST;
output  [0:0] stream_out_TID;
output  [0:0] stream_out_TDEST;
input   stream_in_TVALID;
output   stream_in_TREADY;
output   stream_out_TVALID;
input   stream_out_TREADY;

 reg    ap_rst_n_inv;
wire    ap_start;
wire    ap_ready;
wire    ap_done;
wire    ap_idle;
wire   [31:0] in_width;
wire   [31:0] in_height;
wire   [31:0] out_width;
wire   [31:0] out_height;
wire    Block_Mat_exit45_pro_U0_ap_start;
wire    Block_Mat_exit45_pro_U0_ap_done;
wire    Block_Mat_exit45_pro_U0_ap_continue;
wire    Block_Mat_exit45_pro_U0_ap_idle;
wire    Block_Mat_exit45_pro_U0_ap_ready;
wire    Block_Mat_exit45_pro_U0_start_out;
wire    Block_Mat_exit45_pro_U0_start_write;
wire   [31:0] Block_Mat_exit45_pro_U0_img_in_rows_V_out_din;
wire    Block_Mat_exit45_pro_U0_img_in_rows_V_out_write;
wire   [31:0] Block_Mat_exit45_pro_U0_img_in_cols_V_out_din;
wire    Block_Mat_exit45_pro_U0_img_in_cols_V_out_write;
wire   [31:0] Block_Mat_exit45_pro_U0_img_out_rows_V_out_din;
wire    Block_Mat_exit45_pro_U0_img_out_rows_V_out_write;
wire   [31:0] Block_Mat_exit45_pro_U0_img_out_cols_V_out_din;
wire    Block_Mat_exit45_pro_U0_img_out_cols_V_out_write;
wire    AXIvideo2Mat_U0_ap_start;
wire    AXIvideo2Mat_U0_ap_done;
wire    AXIvideo2Mat_U0_ap_continue;
wire    AXIvideo2Mat_U0_ap_idle;
wire    AXIvideo2Mat_U0_ap_ready;
wire    AXIvideo2Mat_U0_stream_in_TREADY;
wire    AXIvideo2Mat_U0_img_rows_V_read;
wire    AXIvideo2Mat_U0_img_cols_V_read;
wire   [7:0] AXIvideo2Mat_U0_img_data_stream_0_V_din;
wire    AXIvideo2Mat_U0_img_data_stream_0_V_write;
wire   [7:0] AXIvideo2Mat_U0_img_data_stream_1_V_din;
wire    AXIvideo2Mat_U0_img_data_stream_1_V_write;
wire   [7:0] AXIvideo2Mat_U0_img_data_stream_2_V_din;
wire    AXIvideo2Mat_U0_img_data_stream_2_V_write;
wire   [31:0] AXIvideo2Mat_U0_img_rows_V_out_din;
wire    AXIvideo2Mat_U0_img_rows_V_out_write;
wire   [31:0] AXIvideo2Mat_U0_img_cols_V_out_din;
wire    AXIvideo2Mat_U0_img_cols_V_out_write;
wire    Resize_U0_ap_start;
wire    Resize_U0_ap_done;
wire    Resize_U0_ap_continue;
wire    Resize_U0_ap_idle;
wire    Resize_U0_ap_ready;
wire    Resize_U0_start_out;
wire    Resize_U0_start_write;
wire    Resize_U0_p_src_rows_V_read;
wire    Resize_U0_p_src_cols_V_read;
wire    Resize_U0_p_src_data_stream_0_V_read;
wire    Resize_U0_p_src_data_stream_1_V_read;
wire    Resize_U0_p_src_data_stream_2_V_read;
wire    Resize_U0_p_dst_rows_V_read;
wire    Resize_U0_p_dst_cols_V_read;
wire   [7:0] Resize_U0_p_dst_data_stream_0_V_din;
wire    Resize_U0_p_dst_data_stream_0_V_write;
wire   [7:0] Resize_U0_p_dst_data_stream_1_V_din;
wire    Resize_U0_p_dst_data_stream_1_V_write;
wire   [7:0] Resize_U0_p_dst_data_stream_2_V_din;
wire    Resize_U0_p_dst_data_stream_2_V_write;
wire   [31:0] Resize_U0_p_dst_rows_V_out_din;
wire    Resize_U0_p_dst_rows_V_out_write;
wire   [31:0] Resize_U0_p_dst_cols_V_out_din;
wire    Resize_U0_p_dst_cols_V_out_write;
wire    Mat2AXIvideo_U0_ap_start;
wire    Mat2AXIvideo_U0_ap_done;
wire    Mat2AXIvideo_U0_ap_continue;
wire    Mat2AXIvideo_U0_ap_idle;
wire    Mat2AXIvideo_U0_ap_ready;
wire    Mat2AXIvideo_U0_img_rows_V_read;
wire    Mat2AXIvideo_U0_img_cols_V_read;
wire    Mat2AXIvideo_U0_img_data_stream_0_V_read;
wire    Mat2AXIvideo_U0_img_data_stream_1_V_read;
wire    Mat2AXIvideo_U0_img_data_stream_2_V_read;
wire   [23:0] Mat2AXIvideo_U0_stream_out_TDATA;
wire    Mat2AXIvideo_U0_stream_out_TVALID;
wire   [2:0] Mat2AXIvideo_U0_stream_out_TKEEP;
wire   [2:0] Mat2AXIvideo_U0_stream_out_TSTRB;
wire   [0:0] Mat2AXIvideo_U0_stream_out_TUSER;
wire   [0:0] Mat2AXIvideo_U0_stream_out_TLAST;
wire   [0:0] Mat2AXIvideo_U0_stream_out_TID;
wire   [0:0] Mat2AXIvideo_U0_stream_out_TDEST;
wire    ap_sync_continue;
wire    img_in_rows_V_c_full_n;
wire   [31:0] img_in_rows_V_c_dout;
wire    img_in_rows_V_c_empty_n;
wire    img_in_cols_V_c_full_n;
wire   [31:0] img_in_cols_V_c_dout;
wire    img_in_cols_V_c_empty_n;
wire    img_out_rows_V_c_full_n;
wire   [31:0] img_out_rows_V_c_dout;
wire    img_out_rows_V_c_empty_n;
wire    img_out_cols_V_c_full_n;
wire   [31:0] img_out_cols_V_c_dout;
wire    img_out_cols_V_c_empty_n;
wire    img_in_data_stream_0_full_n;
wire   [7:0] img_in_data_stream_0_dout;
wire    img_in_data_stream_0_empty_n;
wire    img_in_data_stream_1_full_n;
wire   [7:0] img_in_data_stream_1_dout;
wire    img_in_data_stream_1_empty_n;
wire    img_in_data_stream_2_full_n;
wire   [7:0] img_in_data_stream_2_dout;
wire    img_in_data_stream_2_empty_n;
wire    img_in_rows_V_c13_full_n;
wire   [31:0] img_in_rows_V_c13_dout;
wire    img_in_rows_V_c13_empty_n;
wire    img_in_cols_V_c14_full_n;
wire   [31:0] img_in_cols_V_c14_dout;
wire    img_in_cols_V_c14_empty_n;
wire    img_out_data_stream_s_full_n;
wire   [7:0] img_out_data_stream_s_dout;
wire    img_out_data_stream_s_empty_n;
wire    img_out_data_stream_1_full_n;
wire   [7:0] img_out_data_stream_1_dout;
wire    img_out_data_stream_1_empty_n;
wire    img_out_data_stream_2_full_n;
wire   [7:0] img_out_data_stream_2_dout;
wire    img_out_data_stream_2_empty_n;
wire    img_out_rows_V_c15_full_n;
wire   [31:0] img_out_rows_V_c15_dout;
wire    img_out_rows_V_c15_empty_n;
wire    img_out_cols_V_c16_full_n;
wire   [31:0] img_out_cols_V_c16_dout;
wire    img_out_cols_V_c16_empty_n;
wire    ap_sync_done;
wire    ap_sync_ready;
reg    ap_sync_reg_AXIvideo2Mat_U0_ap_ready;
wire    ap_sync_AXIvideo2Mat_U0_ap_ready;
reg   [1:0] AXIvideo2Mat_U0_ap_ready_count;
reg    ap_sync_reg_Block_Mat_exit45_pro_U0_ap_ready;
wire    ap_sync_Block_Mat_exit45_pro_U0_ap_ready;
reg   [1:0] Block_Mat_exit45_pro_U0_ap_ready_count;
wire   [0:0] start_for_Resize_U0_din;
wire    start_for_Resize_U0_full_n;
wire   [0:0] start_for_Resize_U0_dout;
wire    start_for_Resize_U0_empty_n;
wire    AXIvideo2Mat_U0_start_full_n;
wire    AXIvideo2Mat_U0_start_write;
wire   [0:0] start_for_Mat2AXIvideo_U0_din;
wire    start_for_Mat2AXIvideo_U0_full_n;
wire   [0:0] start_for_Mat2AXIvideo_U0_dout;
wire    start_for_Mat2AXIvideo_U0_empty_n;
wire    Mat2AXIvideo_U0_start_full_n;
wire    Mat2AXIvideo_U0_start_write;

// power-on initialization
initial begin
#0 ap_sync_reg_AXIvideo2Mat_U0_ap_ready = 1'b0;
#0 AXIvideo2Mat_U0_ap_ready_count = 2'd0;
#0 ap_sync_reg_Block_Mat_exit45_pro_U0_ap_ready = 1'b0;
#0 Block_Mat_exit45_pro_U0_ap_ready_count = 2'd0;
end

video_scaler_ctrl_s_axi #(
    .C_S_AXI_ADDR_WIDTH( C_S_AXI_CTRL_ADDR_WIDTH ),
    .C_S_AXI_DATA_WIDTH( C_S_AXI_CTRL_DATA_WIDTH ))
video_scaler_ctrl_s_axi_U(
    .AWVALID(s_axi_ctrl_AWVALID),
    .AWREADY(s_axi_ctrl_AWREADY),
    .AWADDR(s_axi_ctrl_AWADDR),
    .WVALID(s_axi_ctrl_WVALID),
    .WREADY(s_axi_ctrl_WREADY),
    .WDATA(s_axi_ctrl_WDATA),
    .WSTRB(s_axi_ctrl_WSTRB),
    .ARVALID(s_axi_ctrl_ARVALID),
    .ARREADY(s_axi_ctrl_ARREADY),
    .ARADDR(s_axi_ctrl_ARADDR),
    .RVALID(s_axi_ctrl_RVALID),
    .RREADY(s_axi_ctrl_RREADY),
    .RDATA(s_axi_ctrl_RDATA),
    .RRESP(s_axi_ctrl_RRESP),
    .BVALID(s_axi_ctrl_BVALID),
    .BREADY(s_axi_ctrl_BREADY),
    .BRESP(s_axi_ctrl_BRESP),
    .ACLK(ap_clk),
    .ARESET(ap_rst_n_inv),
    .ACLK_EN(1'b1),
    .ap_start(ap_start),
    .interrupt(interrupt),
    .ap_ready(ap_ready),
    .ap_done(ap_done),
    .ap_idle(ap_idle),
    .in_width(in_width),
    .in_height(in_height),
    .out_width(out_width),
    .out_height(out_height)
);

Block_Mat_exit45_pro Block_Mat_exit45_pro_U0(
    .ap_clk(ap_clk),
    .ap_rst(ap_rst_n_inv),
    .ap_start(Block_Mat_exit45_pro_U0_ap_start),
    .start_full_n(start_for_Resize_U0_full_n),
    .ap_done(Block_Mat_exit45_pro_U0_ap_done),
    .ap_continue(Block_Mat_exit45_pro_U0_ap_continue),
    .ap_idle(Block_Mat_exit45_pro_U0_ap_idle),
    .ap_ready(Block_Mat_exit45_pro_U0_ap_ready),
    .start_out(Block_Mat_exit45_pro_U0_start_out),
    .start_write(Block_Mat_exit45_pro_U0_start_write),
    .in_width(in_width),
    .in_height(in_height),
    .out_width(out_width),
    .out_height(out_height),
    .img_in_rows_V_out_din(Block_Mat_exit45_pro_U0_img_in_rows_V_out_din),
    .img_in_rows_V_out_full_n(img_in_rows_V_c_full_n),
    .img_in_rows_V_out_write(Block_Mat_exit45_pro_U0_img_in_rows_V_out_write),
    .img_in_cols_V_out_din(Block_Mat_exit45_pro_U0_img_in_cols_V_out_din),
    .img_in_cols_V_out_full_n(img_in_cols_V_c_full_n),
    .img_in_cols_V_out_write(Block_Mat_exit45_pro_U0_img_in_cols_V_out_write),
    .img_out_rows_V_out_din(Block_Mat_exit45_pro_U0_img_out_rows_V_out_din),
    .img_out_rows_V_out_full_n(img_out_rows_V_c_full_n),
    .img_out_rows_V_out_write(Block_Mat_exit45_pro_U0_img_out_rows_V_out_write),
    .img_out_cols_V_out_din(Block_Mat_exit45_pro_U0_img_out_cols_V_out_din),
    .img_out_cols_V_out_full_n(img_out_cols_V_c_full_n),
    .img_out_cols_V_out_write(Block_Mat_exit45_pro_U0_img_out_cols_V_out_write)
);

AXIvideo2Mat AXIvideo2Mat_U0(
    .ap_clk(ap_clk),
    .ap_rst(ap_rst_n_inv),
    .ap_start(AXIvideo2Mat_U0_ap_start),
    .ap_done(AXIvideo2Mat_U0_ap_done),
    .ap_continue(AXIvideo2Mat_U0_ap_continue),
    .ap_idle(AXIvideo2Mat_U0_ap_idle),
    .ap_ready(AXIvideo2Mat_U0_ap_ready),
    .stream_in_TDATA(stream_in_TDATA),
    .stream_in_TVALID(stream_in_TVALID),
    .stream_in_TREADY(AXIvideo2Mat_U0_stream_in_TREADY),
    .stream_in_TKEEP(stream_in_TKEEP),
    .stream_in_TSTRB(stream_in_TSTRB),
    .stream_in_TUSER(stream_in_TUSER),
    .stream_in_TLAST(stream_in_TLAST),
    .stream_in_TID(stream_in_TID),
    .stream_in_TDEST(stream_in_TDEST),
    .img_rows_V_dout(img_in_rows_V_c_dout),
    .img_rows_V_empty_n(img_in_rows_V_c_empty_n),
    .img_rows_V_read(AXIvideo2Mat_U0_img_rows_V_read),
    .img_cols_V_dout(img_in_cols_V_c_dout),
    .img_cols_V_empty_n(img_in_cols_V_c_empty_n),
    .img_cols_V_read(AXIvideo2Mat_U0_img_cols_V_read),
    .img_data_stream_0_V_din(AXIvideo2Mat_U0_img_data_stream_0_V_din),
    .img_data_stream_0_V_full_n(img_in_data_stream_0_full_n),
    .img_data_stream_0_V_write(AXIvideo2Mat_U0_img_data_stream_0_V_write),
    .img_data_stream_1_V_din(AXIvideo2Mat_U0_img_data_stream_1_V_din),
    .img_data_stream_1_V_full_n(img_in_data_stream_1_full_n),
    .img_data_stream_1_V_write(AXIvideo2Mat_U0_img_data_stream_1_V_write),
    .img_data_stream_2_V_din(AXIvideo2Mat_U0_img_data_stream_2_V_din),
    .img_data_stream_2_V_full_n(img_in_data_stream_2_full_n),
    .img_data_stream_2_V_write(AXIvideo2Mat_U0_img_data_stream_2_V_write),
    .img_rows_V_out_din(AXIvideo2Mat_U0_img_rows_V_out_din),
    .img_rows_V_out_full_n(img_in_rows_V_c13_full_n),
    .img_rows_V_out_write(AXIvideo2Mat_U0_img_rows_V_out_write),
    .img_cols_V_out_din(AXIvideo2Mat_U0_img_cols_V_out_din),
    .img_cols_V_out_full_n(img_in_cols_V_c14_full_n),
    .img_cols_V_out_write(AXIvideo2Mat_U0_img_cols_V_out_write)
);

Resize Resize_U0(
    .ap_clk(ap_clk),
    .ap_rst(ap_rst_n_inv),
    .ap_start(Resize_U0_ap_start),
    .start_full_n(start_for_Mat2AXIvideo_U0_full_n),
    .ap_done(Resize_U0_ap_done),
    .ap_continue(Resize_U0_ap_continue),
    .ap_idle(Resize_U0_ap_idle),
    .ap_ready(Resize_U0_ap_ready),
    .start_out(Resize_U0_start_out),
    .start_write(Resize_U0_start_write),
    .p_src_rows_V_dout(img_in_rows_V_c13_dout),
    .p_src_rows_V_empty_n(img_in_rows_V_c13_empty_n),
    .p_src_rows_V_read(Resize_U0_p_src_rows_V_read),
    .p_src_cols_V_dout(img_in_cols_V_c14_dout),
    .p_src_cols_V_empty_n(img_in_cols_V_c14_empty_n),
    .p_src_cols_V_read(Resize_U0_p_src_cols_V_read),
    .p_src_data_stream_0_V_dout(img_in_data_stream_0_dout),
    .p_src_data_stream_0_V_empty_n(img_in_data_stream_0_empty_n),
    .p_src_data_stream_0_V_read(Resize_U0_p_src_data_stream_0_V_read),
    .p_src_data_stream_1_V_dout(img_in_data_stream_1_dout),
    .p_src_data_stream_1_V_empty_n(img_in_data_stream_1_empty_n),
    .p_src_data_stream_1_V_read(Resize_U0_p_src_data_stream_1_V_read),
    .p_src_data_stream_2_V_dout(img_in_data_stream_2_dout),
    .p_src_data_stream_2_V_empty_n(img_in_data_stream_2_empty_n),
    .p_src_data_stream_2_V_read(Resize_U0_p_src_data_stream_2_V_read),
    .p_dst_rows_V_dout(img_out_rows_V_c_dout),
    .p_dst_rows_V_empty_n(img_out_rows_V_c_empty_n),
    .p_dst_rows_V_read(Resize_U0_p_dst_rows_V_read),
    .p_dst_cols_V_dout(img_out_cols_V_c_dout),
    .p_dst_cols_V_empty_n(img_out_cols_V_c_empty_n),
    .p_dst_cols_V_read(Resize_U0_p_dst_cols_V_read),
    .p_dst_data_stream_0_V_din(Resize_U0_p_dst_data_stream_0_V_din),
    .p_dst_data_stream_0_V_full_n(img_out_data_stream_s_full_n),
    .p_dst_data_stream_0_V_write(Resize_U0_p_dst_data_stream_0_V_write),
    .p_dst_data_stream_1_V_din(Resize_U0_p_dst_data_stream_1_V_din),
    .p_dst_data_stream_1_V_full_n(img_out_data_stream_1_full_n),
    .p_dst_data_stream_1_V_write(Resize_U0_p_dst_data_stream_1_V_write),
    .p_dst_data_stream_2_V_din(Resize_U0_p_dst_data_stream_2_V_din),
    .p_dst_data_stream_2_V_full_n(img_out_data_stream_2_full_n),
    .p_dst_data_stream_2_V_write(Resize_U0_p_dst_data_stream_2_V_write),
    .p_dst_rows_V_out_din(Resize_U0_p_dst_rows_V_out_din),
    .p_dst_rows_V_out_full_n(img_out_rows_V_c15_full_n),
    .p_dst_rows_V_out_write(Resize_U0_p_dst_rows_V_out_write),
    .p_dst_cols_V_out_din(Resize_U0_p_dst_cols_V_out_din),
    .p_dst_cols_V_out_full_n(img_out_cols_V_c16_full_n),
    .p_dst_cols_V_out_write(Resize_U0_p_dst_cols_V_out_write)
);

Mat2AXIvideo Mat2AXIvideo_U0(
    .ap_clk(ap_clk),
    .ap_rst(ap_rst_n_inv),
    .ap_start(Mat2AXIvideo_U0_ap_start),
    .ap_done(Mat2AXIvideo_U0_ap_done),
    .ap_continue(Mat2AXIvideo_U0_ap_continue),
    .ap_idle(Mat2AXIvideo_U0_ap_idle),
    .ap_ready(Mat2AXIvideo_U0_ap_ready),
    .img_rows_V_dout(img_out_rows_V_c15_dout),
    .img_rows_V_empty_n(img_out_rows_V_c15_empty_n),
    .img_rows_V_read(Mat2AXIvideo_U0_img_rows_V_read),
    .img_cols_V_dout(img_out_cols_V_c16_dout),
    .img_cols_V_empty_n(img_out_cols_V_c16_empty_n),
    .img_cols_V_read(Mat2AXIvideo_U0_img_cols_V_read),
    .img_data_stream_0_V_dout(img_out_data_stream_s_dout),
    .img_data_stream_0_V_empty_n(img_out_data_stream_s_empty_n),
    .img_data_stream_0_V_read(Mat2AXIvideo_U0_img_data_stream_0_V_read),
    .img_data_stream_1_V_dout(img_out_data_stream_1_dout),
    .img_data_stream_1_V_empty_n(img_out_data_stream_1_empty_n),
    .img_data_stream_1_V_read(Mat2AXIvideo_U0_img_data_stream_1_V_read),
    .img_data_stream_2_V_dout(img_out_data_stream_2_dout),
    .img_data_stream_2_V_empty_n(img_out_data_stream_2_empty_n),
    .img_data_stream_2_V_read(Mat2AXIvideo_U0_img_data_stream_2_V_read),
    .stream_out_TDATA(Mat2AXIvideo_U0_stream_out_TDATA),
    .stream_out_TVALID(Mat2AXIvideo_U0_stream_out_TVALID),
    .stream_out_TREADY(stream_out_TREADY),
    .stream_out_TKEEP(Mat2AXIvideo_U0_stream_out_TKEEP),
    .stream_out_TSTRB(Mat2AXIvideo_U0_stream_out_TSTRB),
    .stream_out_TUSER(Mat2AXIvideo_U0_stream_out_TUSER),
    .stream_out_TLAST(Mat2AXIvideo_U0_stream_out_TLAST),
    .stream_out_TID(Mat2AXIvideo_U0_stream_out_TID),
    .stream_out_TDEST(Mat2AXIvideo_U0_stream_out_TDEST)
);

fifo_w32_d2_A img_in_rows_V_c_U(
    .clk(ap_clk),
    .reset(ap_rst_n_inv),
    .if_read_ce(1'b1),
    .if_write_ce(1'b1),
    .if_din(Block_Mat_exit45_pro_U0_img_in_rows_V_out_din),
    .if_full_n(img_in_rows_V_c_full_n),
    .if_write(Block_Mat_exit45_pro_U0_img_in_rows_V_out_write),
    .if_dout(img_in_rows_V_c_dout),
    .if_empty_n(img_in_rows_V_c_empty_n),
    .if_read(AXIvideo2Mat_U0_img_rows_V_read)
);

fifo_w32_d2_A img_in_cols_V_c_U(
    .clk(ap_clk),
    .reset(ap_rst_n_inv),
    .if_read_ce(1'b1),
    .if_write_ce(1'b1),
    .if_din(Block_Mat_exit45_pro_U0_img_in_cols_V_out_din),
    .if_full_n(img_in_cols_V_c_full_n),
    .if_write(Block_Mat_exit45_pro_U0_img_in_cols_V_out_write),
    .if_dout(img_in_cols_V_c_dout),
    .if_empty_n(img_in_cols_V_c_empty_n),
    .if_read(AXIvideo2Mat_U0_img_cols_V_read)
);

fifo_w32_d3_A img_out_rows_V_c_U(
    .clk(ap_clk),
    .reset(ap_rst_n_inv),
    .if_read_ce(1'b1),
    .if_write_ce(1'b1),
    .if_din(Block_Mat_exit45_pro_U0_img_out_rows_V_out_din),
    .if_full_n(img_out_rows_V_c_full_n),
    .if_write(Block_Mat_exit45_pro_U0_img_out_rows_V_out_write),
    .if_dout(img_out_rows_V_c_dout),
    .if_empty_n(img_out_rows_V_c_empty_n),
    .if_read(Resize_U0_p_dst_rows_V_read)
);

fifo_w32_d3_A img_out_cols_V_c_U(
    .clk(ap_clk),
    .reset(ap_rst_n_inv),
    .if_read_ce(1'b1),
    .if_write_ce(1'b1),
    .if_din(Block_Mat_exit45_pro_U0_img_out_cols_V_out_din),
    .if_full_n(img_out_cols_V_c_full_n),
    .if_write(Block_Mat_exit45_pro_U0_img_out_cols_V_out_write),
    .if_dout(img_out_cols_V_c_dout),
    .if_empty_n(img_out_cols_V_c_empty_n),
    .if_read(Resize_U0_p_dst_cols_V_read)
);

fifo_w8_d2_A img_in_data_stream_0_U(
    .clk(ap_clk),
    .reset(ap_rst_n_inv),
    .if_read_ce(1'b1),
    .if_write_ce(1'b1),
    .if_din(AXIvideo2Mat_U0_img_data_stream_0_V_din),
    .if_full_n(img_in_data_stream_0_full_n),
    .if_write(AXIvideo2Mat_U0_img_data_stream_0_V_write),
    .if_dout(img_in_data_stream_0_dout),
    .if_empty_n(img_in_data_stream_0_empty_n),
    .if_read(Resize_U0_p_src_data_stream_0_V_read)
);

fifo_w8_d2_A img_in_data_stream_1_U(
    .clk(ap_clk),
    .reset(ap_rst_n_inv),
    .if_read_ce(1'b1),
    .if_write_ce(1'b1),
    .if_din(AXIvideo2Mat_U0_img_data_stream_1_V_din),
    .if_full_n(img_in_data_stream_1_full_n),
    .if_write(AXIvideo2Mat_U0_img_data_stream_1_V_write),
    .if_dout(img_in_data_stream_1_dout),
    .if_empty_n(img_in_data_stream_1_empty_n),
    .if_read(Resize_U0_p_src_data_stream_1_V_read)
);

fifo_w8_d2_A img_in_data_stream_2_U(
    .clk(ap_clk),
    .reset(ap_rst_n_inv),
    .if_read_ce(1'b1),
    .if_write_ce(1'b1),
    .if_din(AXIvideo2Mat_U0_img_data_stream_2_V_din),
    .if_full_n(img_in_data_stream_2_full_n),
    .if_write(AXIvideo2Mat_U0_img_data_stream_2_V_write),
    .if_dout(img_in_data_stream_2_dout),
    .if_empty_n(img_in_data_stream_2_empty_n),
    .if_read(Resize_U0_p_src_data_stream_2_V_read)
);

fifo_w32_d2_A img_in_rows_V_c13_U(
    .clk(ap_clk),
    .reset(ap_rst_n_inv),
    .if_read_ce(1'b1),
    .if_write_ce(1'b1),
    .if_din(AXIvideo2Mat_U0_img_rows_V_out_din),
    .if_full_n(img_in_rows_V_c13_full_n),
    .if_write(AXIvideo2Mat_U0_img_rows_V_out_write),
    .if_dout(img_in_rows_V_c13_dout),
    .if_empty_n(img_in_rows_V_c13_empty_n),
    .if_read(Resize_U0_p_src_rows_V_read)
);

fifo_w32_d2_A img_in_cols_V_c14_U(
    .clk(ap_clk),
    .reset(ap_rst_n_inv),
    .if_read_ce(1'b1),
    .if_write_ce(1'b1),
    .if_din(AXIvideo2Mat_U0_img_cols_V_out_din),
    .if_full_n(img_in_cols_V_c14_full_n),
    .if_write(AXIvideo2Mat_U0_img_cols_V_out_write),
    .if_dout(img_in_cols_V_c14_dout),
    .if_empty_n(img_in_cols_V_c14_empty_n),
    .if_read(Resize_U0_p_src_cols_V_read)
);

fifo_w8_d2_A img_out_data_stream_s_U(
    .clk(ap_clk),
    .reset(ap_rst_n_inv),
    .if_read_ce(1'b1),
    .if_write_ce(1'b1),
    .if_din(Resize_U0_p_dst_data_stream_0_V_din),
    .if_full_n(img_out_data_stream_s_full_n),
    .if_write(Resize_U0_p_dst_data_stream_0_V_write),
    .if_dout(img_out_data_stream_s_dout),
    .if_empty_n(img_out_data_stream_s_empty_n),
    .if_read(Mat2AXIvideo_U0_img_data_stream_0_V_read)
);

fifo_w8_d2_A img_out_data_stream_1_U(
    .clk(ap_clk),
    .reset(ap_rst_n_inv),
    .if_read_ce(1'b1),
    .if_write_ce(1'b1),
    .if_din(Resize_U0_p_dst_data_stream_1_V_din),
    .if_full_n(img_out_data_stream_1_full_n),
    .if_write(Resize_U0_p_dst_data_stream_1_V_write),
    .if_dout(img_out_data_stream_1_dout),
    .if_empty_n(img_out_data_stream_1_empty_n),
    .if_read(Mat2AXIvideo_U0_img_data_stream_1_V_read)
);

fifo_w8_d2_A img_out_data_stream_2_U(
    .clk(ap_clk),
    .reset(ap_rst_n_inv),
    .if_read_ce(1'b1),
    .if_write_ce(1'b1),
    .if_din(Resize_U0_p_dst_data_stream_2_V_din),
    .if_full_n(img_out_data_stream_2_full_n),
    .if_write(Resize_U0_p_dst_data_stream_2_V_write),
    .if_dout(img_out_data_stream_2_dout),
    .if_empty_n(img_out_data_stream_2_empty_n),
    .if_read(Mat2AXIvideo_U0_img_data_stream_2_V_read)
);

fifo_w32_d2_A img_out_rows_V_c15_U(
    .clk(ap_clk),
    .reset(ap_rst_n_inv),
    .if_read_ce(1'b1),
    .if_write_ce(1'b1),
    .if_din(Resize_U0_p_dst_rows_V_out_din),
    .if_full_n(img_out_rows_V_c15_full_n),
    .if_write(Resize_U0_p_dst_rows_V_out_write),
    .if_dout(img_out_rows_V_c15_dout),
    .if_empty_n(img_out_rows_V_c15_empty_n),
    .if_read(Mat2AXIvideo_U0_img_rows_V_read)
);

fifo_w32_d2_A img_out_cols_V_c16_U(
    .clk(ap_clk),
    .reset(ap_rst_n_inv),
    .if_read_ce(1'b1),
    .if_write_ce(1'b1),
    .if_din(Resize_U0_p_dst_cols_V_out_din),
    .if_full_n(img_out_cols_V_c16_full_n),
    .if_write(Resize_U0_p_dst_cols_V_out_write),
    .if_dout(img_out_cols_V_c16_dout),
    .if_empty_n(img_out_cols_V_c16_empty_n),
    .if_read(Mat2AXIvideo_U0_img_cols_V_read)
);

start_for_Resize_U0 start_for_Resize_U0_U(
    .clk(ap_clk),
    .reset(ap_rst_n_inv),
    .if_read_ce(1'b1),
    .if_write_ce(1'b1),
    .if_din(start_for_Resize_U0_din),
    .if_full_n(start_for_Resize_U0_full_n),
    .if_write(Block_Mat_exit45_pro_U0_start_write),
    .if_dout(start_for_Resize_U0_dout),
    .if_empty_n(start_for_Resize_U0_empty_n),
    .if_read(Resize_U0_ap_ready)
);

start_for_Mat2AXImb6 start_for_Mat2AXImb6_U(
    .clk(ap_clk),
    .reset(ap_rst_n_inv),
    .if_read_ce(1'b1),
    .if_write_ce(1'b1),
    .if_din(start_for_Mat2AXIvideo_U0_din),
    .if_full_n(start_for_Mat2AXIvideo_U0_full_n),
    .if_write(Resize_U0_start_write),
    .if_dout(start_for_Mat2AXIvideo_U0_dout),
    .if_empty_n(start_for_Mat2AXIvideo_U0_empty_n),
    .if_read(Mat2AXIvideo_U0_ap_ready)
);

always @ (posedge ap_clk) begin
    if (ap_rst_n_inv == 1'b1) begin
        ap_sync_reg_AXIvideo2Mat_U0_ap_ready <= 1'b0;
    end else begin
        if (((ap_sync_ready & ap_start) == 1'b1)) begin
            ap_sync_reg_AXIvideo2Mat_U0_ap_ready <= 1'b0;
        end else begin
            ap_sync_reg_AXIvideo2Mat_U0_ap_ready <= ap_sync_AXIvideo2Mat_U0_ap_ready;
        end
    end
end

always @ (posedge ap_clk) begin
    if (ap_rst_n_inv == 1'b1) begin
        ap_sync_reg_Block_Mat_exit45_pro_U0_ap_ready <= 1'b0;
    end else begin
        if (((ap_sync_ready & ap_start) == 1'b1)) begin
            ap_sync_reg_Block_Mat_exit45_pro_U0_ap_ready <= 1'b0;
        end else begin
            ap_sync_reg_Block_Mat_exit45_pro_U0_ap_ready <= ap_sync_Block_Mat_exit45_pro_U0_ap_ready;
        end
    end
end

always @ (posedge ap_clk) begin
    if (((1'b0 == AXIvideo2Mat_U0_ap_ready) & (ap_sync_ready == 1'b1))) begin
        AXIvideo2Mat_U0_ap_ready_count <= (AXIvideo2Mat_U0_ap_ready_count - 2'd1);
    end else if (((1'b1 == AXIvideo2Mat_U0_ap_ready) & (ap_sync_ready == 1'b0))) begin
        AXIvideo2Mat_U0_ap_ready_count <= (AXIvideo2Mat_U0_ap_ready_count + 2'd1);
    end
end

always @ (posedge ap_clk) begin
    if (((1'b0 == Block_Mat_exit45_pro_U0_ap_ready) & (ap_sync_ready == 1'b1))) begin
        Block_Mat_exit45_pro_U0_ap_ready_count <= (Block_Mat_exit45_pro_U0_ap_ready_count - 2'd1);
    end else if (((1'b1 == Block_Mat_exit45_pro_U0_ap_ready) & (ap_sync_ready == 1'b0))) begin
        Block_Mat_exit45_pro_U0_ap_ready_count <= (Block_Mat_exit45_pro_U0_ap_ready_count + 2'd1);
    end
end

assign AXIvideo2Mat_U0_ap_continue = 1'b1;

assign AXIvideo2Mat_U0_ap_start = ((ap_sync_reg_AXIvideo2Mat_U0_ap_ready ^ 1'b1) & ap_start);

assign AXIvideo2Mat_U0_start_full_n = 1'b1;

assign AXIvideo2Mat_U0_start_write = 1'b0;

assign Block_Mat_exit45_pro_U0_ap_continue = 1'b1;

assign Block_Mat_exit45_pro_U0_ap_start = ((ap_sync_reg_Block_Mat_exit45_pro_U0_ap_ready ^ 1'b1) & ap_start);

assign Mat2AXIvideo_U0_ap_continue = 1'b1;

assign Mat2AXIvideo_U0_ap_start = start_for_Mat2AXIvideo_U0_empty_n;

assign Mat2AXIvideo_U0_start_full_n = 1'b1;

assign Mat2AXIvideo_U0_start_write = 1'b0;

assign Resize_U0_ap_continue = 1'b1;

assign Resize_U0_ap_start = start_for_Resize_U0_empty_n;

assign ap_done = Mat2AXIvideo_U0_ap_done;

assign ap_idle = (Resize_U0_ap_idle & Mat2AXIvideo_U0_ap_idle & Block_Mat_exit45_pro_U0_ap_idle & AXIvideo2Mat_U0_ap_idle);

assign ap_ready = ap_sync_ready;

always @ (*) begin
    ap_rst_n_inv = ~ap_rst_n;
end

assign ap_sync_AXIvideo2Mat_U0_ap_ready = (ap_sync_reg_AXIvideo2Mat_U0_ap_ready | AXIvideo2Mat_U0_ap_ready);

assign ap_sync_Block_Mat_exit45_pro_U0_ap_ready = (ap_sync_reg_Block_Mat_exit45_pro_U0_ap_ready | Block_Mat_exit45_pro_U0_ap_ready);

assign ap_sync_continue = 1'b1;

assign ap_sync_done = Mat2AXIvideo_U0_ap_done;

assign ap_sync_ready = (ap_sync_Block_Mat_exit45_pro_U0_ap_ready & ap_sync_AXIvideo2Mat_U0_ap_ready);

assign start_for_Mat2AXIvideo_U0_din = 1'b1;

assign start_for_Resize_U0_din = 1'b1;

assign stream_in_TREADY = AXIvideo2Mat_U0_stream_in_TREADY;

assign stream_out_TDATA = Mat2AXIvideo_U0_stream_out_TDATA;

assign stream_out_TDEST = Mat2AXIvideo_U0_stream_out_TDEST;

assign stream_out_TID = Mat2AXIvideo_U0_stream_out_TID;

assign stream_out_TKEEP = Mat2AXIvideo_U0_stream_out_TKEEP;

assign stream_out_TLAST = Mat2AXIvideo_U0_stream_out_TLAST;

assign stream_out_TSTRB = Mat2AXIvideo_U0_stream_out_TSTRB;

assign stream_out_TUSER = Mat2AXIvideo_U0_stream_out_TUSER;

assign stream_out_TVALID = Mat2AXIvideo_U0_stream_out_TVALID;

endmodule //video_scaler
