// ==============================================================
// File generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
// Version: 2018.2
// Copyright (C) 1986-2018 Xilinx, Inc. All Rights Reserved.
// 
// ==============================================================

/***************************** Include Files *********************************/
#include "xvideo_scaler.h"

/************************** Function Implementation *************************/
#ifndef __linux__
int XVideo_scaler_CfgInitialize(XVideo_scaler *InstancePtr, XVideo_scaler_Config *ConfigPtr) {
    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(ConfigPtr != NULL);

    InstancePtr->Ctrl_BaseAddress = ConfigPtr->Ctrl_BaseAddress;
    InstancePtr->IsReady = XIL_COMPONENT_IS_READY;

    return XST_SUCCESS;
}
#endif

void XVideo_scaler_Start(XVideo_scaler *InstancePtr) {
    u32 Data;

    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Data = XVideo_scaler_ReadReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_AP_CTRL) & 0x80;
    XVideo_scaler_WriteReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_AP_CTRL, Data | 0x01);
}

u32 XVideo_scaler_IsDone(XVideo_scaler *InstancePtr) {
    u32 Data;

    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Data = XVideo_scaler_ReadReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_AP_CTRL);
    return (Data >> 1) & 0x1;
}

u32 XVideo_scaler_IsIdle(XVideo_scaler *InstancePtr) {
    u32 Data;

    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Data = XVideo_scaler_ReadReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_AP_CTRL);
    return (Data >> 2) & 0x1;
}

u32 XVideo_scaler_IsReady(XVideo_scaler *InstancePtr) {
    u32 Data;

    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Data = XVideo_scaler_ReadReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_AP_CTRL);
    // check ap_start to see if the pcore is ready for next input
    return !(Data & 0x1);
}

void XVideo_scaler_EnableAutoRestart(XVideo_scaler *InstancePtr) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XVideo_scaler_WriteReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_AP_CTRL, 0x80);
}

void XVideo_scaler_DisableAutoRestart(XVideo_scaler *InstancePtr) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XVideo_scaler_WriteReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_AP_CTRL, 0);
}

void XVideo_scaler_Set_in_width(XVideo_scaler *InstancePtr, u32 Data) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XVideo_scaler_WriteReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_IN_WIDTH_DATA, Data);
}

u32 XVideo_scaler_Get_in_width(XVideo_scaler *InstancePtr) {
    u32 Data;

    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Data = XVideo_scaler_ReadReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_IN_WIDTH_DATA);
    return Data;
}

void XVideo_scaler_Set_in_height(XVideo_scaler *InstancePtr, u32 Data) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XVideo_scaler_WriteReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_IN_HEIGHT_DATA, Data);
}

u32 XVideo_scaler_Get_in_height(XVideo_scaler *InstancePtr) {
    u32 Data;

    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Data = XVideo_scaler_ReadReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_IN_HEIGHT_DATA);
    return Data;
}

void XVideo_scaler_Set_out_width(XVideo_scaler *InstancePtr, u32 Data) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XVideo_scaler_WriteReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_OUT_WIDTH_DATA, Data);
}

u32 XVideo_scaler_Get_out_width(XVideo_scaler *InstancePtr) {
    u32 Data;

    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Data = XVideo_scaler_ReadReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_OUT_WIDTH_DATA);
    return Data;
}

void XVideo_scaler_Set_out_height(XVideo_scaler *InstancePtr, u32 Data) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XVideo_scaler_WriteReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_OUT_HEIGHT_DATA, Data);
}

u32 XVideo_scaler_Get_out_height(XVideo_scaler *InstancePtr) {
    u32 Data;

    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Data = XVideo_scaler_ReadReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_OUT_HEIGHT_DATA);
    return Data;
}

void XVideo_scaler_InterruptGlobalEnable(XVideo_scaler *InstancePtr) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XVideo_scaler_WriteReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_GIE, 1);
}

void XVideo_scaler_InterruptGlobalDisable(XVideo_scaler *InstancePtr) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XVideo_scaler_WriteReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_GIE, 0);
}

void XVideo_scaler_InterruptEnable(XVideo_scaler *InstancePtr, u32 Mask) {
    u32 Register;

    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Register =  XVideo_scaler_ReadReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_IER);
    XVideo_scaler_WriteReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_IER, Register | Mask);
}

void XVideo_scaler_InterruptDisable(XVideo_scaler *InstancePtr, u32 Mask) {
    u32 Register;

    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Register =  XVideo_scaler_ReadReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_IER);
    XVideo_scaler_WriteReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_IER, Register & (~Mask));
}

void XVideo_scaler_InterruptClear(XVideo_scaler *InstancePtr, u32 Mask) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XVideo_scaler_WriteReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_ISR, Mask);
}

u32 XVideo_scaler_InterruptGetEnabled(XVideo_scaler *InstancePtr) {
    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    return XVideo_scaler_ReadReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_IER);
}

u32 XVideo_scaler_InterruptGetStatus(XVideo_scaler *InstancePtr) {
    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    return XVideo_scaler_ReadReg(InstancePtr->Ctrl_BaseAddress, XVIDEO_SCALER_CTRL_ADDR_ISR);
}

