-- ==============================================================
-- File generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
-- Version: 2017.4
-- Copyright (C) 1986-2017 Xilinx, Inc. All Rights Reserved.
-- 
-- ==============================================================

library ieee; 
use ieee.std_logic_1164.all; 
use ieee.std_logic_unsigned.all;

entity Loop_loop_height_kbM_rom is 
    generic(
             dwidth     : integer := 8; 
             awidth     : integer := 8; 
             mem_size    : integer := 256
    ); 
    port (
          addr0      : in std_logic_vector(awidth-1 downto 0); 
          ce0       : in std_logic; 
          q0         : out std_logic_vector(dwidth-1 downto 0);
          clk       : in std_logic
    ); 
end entity; 


architecture rtl of Loop_loop_height_kbM_rom is 

signal addr0_tmp : std_logic_vector(awidth-1 downto 0); 
type mem_array is array (0 to mem_size-1) of std_logic_vector (dwidth-1 downto 0); 
signal mem : mem_array := (
    0 => "00000000", 1 => "00000010", 2 => "00000100", 3 => "00000101", 
    4 => "00000111", 5 => "00001001", 6 => "00001011", 7 => "00001100", 
    8 => "00001110", 9 => "00010000", 10 => "00010010", 11 => "00010011", 
    12 => "00010101", 13 => "00010111", 14 => "00011001", 15 => "00011010", 
    16 => "00011100", 17 => "00011110", 18 => "00011111", 19 => "00100001", 
    20 => "00100011", 21 => "00100100", 22 => "00100110", 23 => "00101000", 
    24 => "00101001", 25 => "00101011", 26 => "00101101", 27 => "00101110", 
    28 => "00110000", 29 => "00110010", 30 => "00110011", 31 => "00110101", 
    32 => "00110110", 33 => "00111000", 34 => "00111010", 35 => "00111011", 
    36 => "00111101", 37 => "00111110", 38 => "01000000", 39 => "01000001", 
    40 => "01000011", 41 => "01000101", 42 => "01000110", 43 => "01001000", 
    44 => "01001001", 45 => "01001011", 46 => "01001100", 47 => "01001110", 
    48 => "01001111", 49 => "01010001", 50 => "01010010", 51 => "01010100", 
    52 => "01010101", 53 => "01010111", 54 => "01011000", 55 => "01011010", 
    56 => "01011011", 57 => "01011100", 58 => "01011110", 59 => "01011111", 
    60 => "01100001", 61 => "01100010", 62 => "01100100", 63 => "01100101", 
    64 => "01100110", 65 => "01101000", 66 => "01101001", 67 => "01101011", 
    68 => "01101100", 69 => "01101101", 70 => "01101111", 71 => "01110000", 
    72 => "01110001", 73 => "01110011", 74 => "01110100", 75 => "01110101", 
    76 => "01110111", 77 => "01111000", 78 => "01111001", 79 => "01111011", 
    80 => "01111100", 81 => "01111101", 82 => "01111111", 83 => "10000000", 
    84 => "10000001", 85 => "10000010", 86 => "10000100", 87 => "10000101", 
    88 => "10000110", 89 => "10000111", 90 => "10001001", 91 => "10001010", 
    92 => "10001011", 93 => "10001100", 94 => "10001101", 95 => "10001111", 
    96 => "10010000", 97 => "10010001", 98 => "10010010", 99 => "10010011", 
    100 => "10010101", 101 => "10010110", 102 => "10010111", 103 => "10011000", 
    104 => "10011001", 105 => "10011010", 106 => "10011100", 107 => "10011101", 
    108 => "10011110", 109 => "10011111", 110 => "10100000", 111 => "10100001", 
    112 => "10100010", 113 => "10100011", 114 => "10100100", 115 => "10100110", 
    116 => "10100111", 117 => "10101000", 118 => "10101001", 119 => "10101010", 
    120 => "10101011", 121 => "10101100", 122 => "10101101", 123 => "10101110", 
    124 => "10101111", 125 => "10110000", 126 => "10110001", 127 => "10110010", 
    128 => "10110011", 129 => "10110100", 130 => "10110101", 131 => "10110110", 
    132 => "10110111", 133 => "10111000", 134 => "10111001", 135 => "10111010", 
    136 => "10111011", 137 => "10111100", 138 => "10111101", 139 => "10111110", 
    140 to 141=> "10111111", 142 => "11000000", 143 => "11000001", 144 => "11000010", 
    145 => "11000011", 146 => "11000100", 147 => "11000101", 148 => "11000110", 
    149 to 150=> "11000111", 151 => "11001000", 152 => "11001001", 153 => "11001010", 
    154 => "11001011", 155 to 156=> "11001100", 157 => "11001101", 158 => "11001110", 
    159 => "11001111", 160 to 161=> "11010000", 162 => "11010001", 163 => "11010010", 
    164 => "11010011", 165 to 166=> "11010100", 167 => "11010101", 168 => "11010110", 
    169 to 170=> "11010111", 171 => "11011000", 172 => "11011001", 173 to 174=> "11011010", 
    175 => "11011011", 176 to 177=> "11011100", 178 => "11011101", 179 to 180=> "11011110", 
    181 => "11011111", 182 to 183=> "11100000", 184 => "11100001", 185 to 186=> "11100010", 
    187 => "11100011", 188 to 189=> "11100100", 190 to 191=> "11100101", 192 => "11100110", 
    193 to 194=> "11100111", 195 to 196=> "11101000", 197 to 198=> "11101001", 199 => "11101010", 
    200 to 201=> "11101011", 202 to 203=> "11101100", 204 to 205=> "11101101", 206 to 207=> "11101110", 
    208 to 209=> "11101111", 210 to 211=> "11110000", 212 to 213=> "11110001", 214 to 216=> "11110010", 
    217 to 218=> "11110011", 219 to 220=> "11110100", 221 to 223=> "11110101", 224 to 225=> "11110110", 
    226 to 228=> "11110111", 229 to 231=> "11111000", 232 to 234=> "11111001", 235 to 237=> "11111010", 
    238 to 240=> "11111011", 241 to 244=> "11111100", 245 to 248=> "11111101", 249 to 252=> "11111110", 
    253 to 255=> "11111111" );


begin 


memory_access_guard_0: process (addr0) 
begin
      addr0_tmp <= addr0;
--synthesis translate_off
      if (CONV_INTEGER(addr0) > mem_size-1) then
           addr0_tmp <= (others => '0');
      else 
           addr0_tmp <= addr0;
      end if;
--synthesis translate_on
end process;

p_rom_access: process (clk)  
begin 
    if (clk'event and clk = '1') then
        if (ce0 = '1') then 
            q0 <= mem(CONV_INTEGER(addr0_tmp)); 
        end if;
    end if;
end process;

end rtl;


Library IEEE;
use IEEE.std_logic_1164.all;

entity Loop_loop_height_kbM is
    generic (
        DataWidth : INTEGER := 8;
        AddressRange : INTEGER := 256;
        AddressWidth : INTEGER := 8);
    port (
        reset : IN STD_LOGIC;
        clk : IN STD_LOGIC;
        address0 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce0 : IN STD_LOGIC;
        q0 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0));
end entity;

architecture arch of Loop_loop_height_kbM is
    component Loop_loop_height_kbM_rom is
        port (
            clk : IN STD_LOGIC;
            addr0 : IN STD_LOGIC_VECTOR;
            ce0 : IN STD_LOGIC;
            q0 : OUT STD_LOGIC_VECTOR);
    end component;



begin
    Loop_loop_height_kbM_rom_U :  component Loop_loop_height_kbM_rom
    port map (
        clk => clk,
        addr0 => address0,
        ce0 => ce0,
        q0 => q0);

end architecture;


