-- ==============================================================
-- File generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
-- Version: 2017.4
-- Copyright (C) 1986-2017 Xilinx, Inc. All Rights Reserved.
-- 
-- ==============================================================

library ieee; 
use ieee.std_logic_1164.all; 
use ieee.std_logic_unsigned.all;

entity Loop_loop_height_g8j_rom is 
    generic(
             dwidth     : integer := 8; 
             awidth     : integer := 8; 
             mem_size    : integer := 256
    ); 
    port (
          addr0      : in std_logic_vector(awidth-1 downto 0); 
          ce0       : in std_logic; 
          q0         : out std_logic_vector(dwidth-1 downto 0);
          clk       : in std_logic
    ); 
end entity; 


architecture rtl of Loop_loop_height_g8j_rom is 

signal addr0_tmp : std_logic_vector(awidth-1 downto 0); 
type mem_array is array (0 to mem_size-1) of std_logic_vector (dwidth-1 downto 0); 
signal mem : mem_array := (
    0 => "00000000", 1 => "00000001", 2 to 3=> "00000010", 4 => "00000011", 
    5 => "00000100", 6 => "00000101", 7 to 8=> "00000110", 9 => "00000111", 
    10 => "00001000", 11 => "00001001", 12 to 13=> "00001010", 14 => "00001011", 
    15 => "00001100", 16 => "00001101", 17 to 18=> "00001110", 19 => "00001111", 
    20 => "00010000", 21 => "00010001", 22 to 23=> "00010010", 24 => "00010011", 
    25 => "00010100", 26 => "00010101", 27 to 28=> "00010110", 29 => "00010111", 
    30 => "00011000", 31 => "00011001", 32 to 33=> "00011010", 34 => "00011011", 
    35 => "00011100", 36 => "00011101", 37 to 38=> "00011110", 39 => "00011111", 
    40 => "00100000", 41 => "00100001", 42 to 43=> "00100010", 44 => "00100011", 
    45 => "00100100", 46 => "00100101", 47 to 48=> "00100110", 49 => "00100111", 
    50 => "00101000", 51 => "00101001", 52 to 53=> "00101010", 54 => "00101011", 
    55 => "00101100", 56 => "00101101", 57 to 58=> "00101110", 59 => "00101111", 
    60 => "00110000", 61 => "00110001", 62 to 63=> "00110010", 64 => "00110011", 
    65 => "00110100", 66 => "00110101", 67 to 68=> "00110110", 69 => "00110111", 
    70 => "00111000", 71 => "00111001", 72 to 73=> "00111010", 74 => "00111011", 
    75 => "00111100", 76 => "00111101", 77 to 78=> "00111110", 79 => "00111111", 
    80 => "01000000", 81 => "01000001", 82 to 83=> "01000010", 84 => "01000011", 
    85 => "01000100", 86 => "01000101", 87 to 88=> "01000110", 89 => "01000111", 
    90 => "01001000", 91 => "01001001", 92 to 93=> "01001010", 94 => "01001011", 
    95 => "01001100", 96 => "01001101", 97 to 98=> "01001110", 99 => "01001111", 
    100 => "01010000", 101 => "01010001", 102 to 103=> "01010010", 104 => "01010011", 
    105 => "01010100", 106 => "01010101", 107 to 108=> "01010110", 109 => "01010111", 
    110 => "01011000", 111 => "01011001", 112 to 113=> "01011010", 114 => "01011011", 
    115 => "01011100", 116 => "01011101", 117 to 118=> "01011110", 119 => "01011111", 
    120 => "01100000", 121 => "01100001", 122 to 123=> "01100010", 124 => "01100011", 
    125 => "01100100", 126 => "01100101", 127 to 128=> "01100110", 129 => "01100111", 
    130 => "01101000", 131 => "01101001", 132 to 133=> "01101010", 134 => "01101011", 
    135 => "01101100", 136 => "01101101", 137 to 138=> "01101110", 139 => "01101111", 
    140 => "01110000", 141 => "01110001", 142 to 143=> "01110010", 144 => "01110011", 
    145 => "01110100", 146 => "01110101", 147 to 148=> "01110110", 149 => "01110111", 
    150 => "01111000", 151 => "01111001", 152 to 153=> "01111010", 154 => "01111011", 
    155 => "01111100", 156 => "01111101", 157 to 158=> "01111110", 159 => "01111111", 
    160 => "10000000", 161 => "10000001", 162 to 163=> "10000010", 164 => "10000011", 
    165 => "10000100", 166 => "10000101", 167 to 168=> "10000110", 169 => "10000111", 
    170 => "10001000", 171 => "10001001", 172 to 173=> "10001010", 174 => "10001011", 
    175 => "10001100", 176 => "10001101", 177 to 178=> "10001110", 179 => "10001111", 
    180 => "10010000", 181 => "10010001", 182 to 183=> "10010010", 184 => "10010011", 
    185 => "10010100", 186 => "10010101", 187 to 188=> "10010110", 189 => "10010111", 
    190 => "10011000", 191 => "10011001", 192 to 193=> "10011010", 194 => "10011011", 
    195 => "10011100", 196 => "10011101", 197 to 198=> "10011110", 199 => "10011111", 
    200 => "10100000", 201 => "10100001", 202 to 203=> "10100010", 204 => "10100011", 
    205 => "10100100", 206 => "10100101", 207 to 208=> "10100110", 209 => "10100111", 
    210 => "10101000", 211 => "10101001", 212 to 213=> "10101010", 214 => "10101011", 
    215 => "10101100", 216 => "10101101", 217 to 218=> "10101110", 219 => "10101111", 
    220 => "10110000", 221 => "10110001", 222 to 223=> "10110010", 224 => "10110011", 
    225 => "10110100", 226 => "10110101", 227 to 228=> "10110110", 229 => "10110111", 
    230 => "10111000", 231 => "10111001", 232 to 233=> "10111010", 234 => "10111011", 
    235 => "10111100", 236 => "10111101", 237 to 238=> "10111110", 239 => "10111111", 
    240 => "11000000", 241 => "11000001", 242 to 243=> "11000010", 244 => "11000011", 
    245 => "11000100", 246 => "11000101", 247 to 248=> "11000110", 249 => "11000111", 
    250 => "11001000", 251 => "11001001", 252 to 253=> "11001010", 254 => "11001011", 
    255 => "11001100" );


begin 


memory_access_guard_0: process (addr0) 
begin
      addr0_tmp <= addr0;
--synthesis translate_off
      if (CONV_INTEGER(addr0) > mem_size-1) then
           addr0_tmp <= (others => '0');
      else 
           addr0_tmp <= addr0;
      end if;
--synthesis translate_on
end process;

p_rom_access: process (clk)  
begin 
    if (clk'event and clk = '1') then
        if (ce0 = '1') then 
            q0 <= mem(CONV_INTEGER(addr0_tmp)); 
        end if;
    end if;
end process;

end rtl;


Library IEEE;
use IEEE.std_logic_1164.all;

entity Loop_loop_height_g8j is
    generic (
        DataWidth : INTEGER := 8;
        AddressRange : INTEGER := 256;
        AddressWidth : INTEGER := 8);
    port (
        reset : IN STD_LOGIC;
        clk : IN STD_LOGIC;
        address0 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce0 : IN STD_LOGIC;
        q0 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0));
end entity;

architecture arch of Loop_loop_height_g8j is
    component Loop_loop_height_g8j_rom is
        port (
            clk : IN STD_LOGIC;
            addr0 : IN STD_LOGIC_VECTOR;
            ce0 : IN STD_LOGIC;
            q0 : OUT STD_LOGIC_VECTOR);
    end component;



begin
    Loop_loop_height_g8j_rom_U :  component Loop_loop_height_g8j_rom
    port map (
        clk => clk,
        addr0 => address0,
        ce0 => ce0,
        q0 => q0);

end architecture;


