-- ==============================================================
-- File generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
-- Version: 2017.4
-- Copyright (C) 1986-2017 Xilinx, Inc. All Rights Reserved.
-- 
-- ==============================================================

library ieee; 
use ieee.std_logic_1164.all; 
use ieee.std_logic_unsigned.all;

entity Loop_loop_height_g8j_rom is 
    generic(
             dwidth     : integer := 8; 
             awidth     : integer := 8; 
             mem_size    : integer := 256
    ); 
    port (
          addr0      : in std_logic_vector(awidth-1 downto 0); 
          ce0       : in std_logic; 
          q0         : out std_logic_vector(dwidth-1 downto 0);
          addr1      : in std_logic_vector(awidth-1 downto 0); 
          ce1       : in std_logic; 
          q1         : out std_logic_vector(dwidth-1 downto 0);
          addr2      : in std_logic_vector(awidth-1 downto 0); 
          ce2       : in std_logic; 
          q2         : out std_logic_vector(dwidth-1 downto 0);
          clk       : in std_logic
    ); 
end entity; 


architecture rtl of Loop_loop_height_g8j_rom is 

signal addr0_tmp : std_logic_vector(awidth-1 downto 0); 
signal addr1_tmp : std_logic_vector(awidth-1 downto 0); 
signal addr2_tmp : std_logic_vector(awidth-1 downto 0); 
type mem_array is array (0 to mem_size-1) of std_logic_vector (dwidth-1 downto 0); 
signal mem0 : mem_array := (
    0 => "00000000", 1 => "00001000", 2 => "00001100", 3 => "00010000", 
    4 => "00010011", 5 => "00010110", 6 => "00011000", 7 => "00011011", 
    8 => "00011101", 9 => "00100000", 10 => "00100010", 11 => "00100100", 
    12 => "00100110", 13 => "00101000", 14 => "00101010", 15 => "00101011", 
    16 => "00101101", 17 => "00101111", 18 => "00110001", 19 => "00110010", 
    20 => "00110100", 21 => "00110110", 22 => "00110111", 23 => "00111001", 
    24 => "00111010", 25 => "00111100", 26 => "00111101", 27 => "00111111", 
    28 => "01000000", 29 => "01000010", 30 => "01000011", 31 => "01000100", 
    32 => "01000110", 33 => "01000111", 34 => "01001000", 35 => "01001010", 
    36 => "01001011", 37 => "01001100", 38 => "01001110", 39 => "01001111", 
    40 => "01010000", 41 => "01010001", 42 => "01010011", 43 => "01010100", 
    44 => "01010101", 45 => "01010110", 46 => "01010111", 47 => "01011001", 
    48 => "01011010", 49 => "01011011", 50 => "01011100", 51 => "01011101", 
    52 => "01011110", 53 => "01100000", 54 => "01100001", 55 => "01100010", 
    56 => "01100011", 57 => "01100100", 58 => "01100101", 59 => "01100110", 
    60 => "01100111", 61 => "01101000", 62 => "01101001", 63 => "01101010", 
    64 => "01101011", 65 => "01101101", 66 => "01101110", 67 => "01101111", 
    68 => "01110000", 69 => "01110001", 70 => "01110010", 71 => "01110011", 
    72 => "01110100", 73 => "01110101", 74 => "01110110", 75 => "01110111", 
    76 => "01111000", 77 => "01111001", 78 => "01111010", 79 => "01111011", 
    80 => "01111100", 81 to 82=> "01111101", 83 => "01111110", 84 => "01111111", 
    85 => "10000000", 86 => "10000001", 87 => "10000010", 88 => "10000011", 
    89 => "10000100", 90 => "10000101", 91 => "10000110", 92 => "10000111", 
    93 => "10001000", 94 => "10001001", 95 to 96=> "10001010", 97 => "10001011", 
    98 => "10001100", 99 => "10001101", 100 => "10001110", 101 => "10001111", 
    102 => "10010000", 103 => "10010001", 104 to 105=> "10010010", 106 => "10010011", 
    107 => "10010100", 108 => "10010101", 109 => "10010110", 110 => "10010111", 
    111 to 112=> "10011000", 113 => "10011001", 114 => "10011010", 115 => "10011011", 
    116 => "10011100", 117 => "10011101", 118 to 119=> "10011110", 120 => "10011111", 
    121 => "10100000", 122 => "10100001", 123 to 124=> "10100010", 125 => "10100011", 
    126 => "10100100", 127 => "10100101", 128 => "10100110", 129 to 130=> "10100111", 
    131 => "10101000", 132 => "10101001", 133 => "10101010", 134 to 135=> "10101011", 
    136 => "10101100", 137 => "10101101", 138 => "10101110", 139 to 140=> "10101111", 
    141 => "10110000", 142 => "10110001", 143 to 144=> "10110010", 145 => "10110011", 
    146 => "10110100", 147 to 148=> "10110101", 149 => "10110110", 150 => "10110111", 
    151 => "10111000", 152 to 153=> "10111001", 154 => "10111010", 155 => "10111011", 
    156 to 157=> "10111100", 158 => "10111101", 159 => "10111110", 160 to 161=> "10111111", 
    162 => "11000000", 163 => "11000001", 164 to 165=> "11000010", 166 => "11000011", 
    167 to 168=> "11000100", 169 => "11000101", 170 => "11000110", 171 to 172=> "11000111", 
    173 => "11001000", 174 => "11001001", 175 to 176=> "11001010", 177 => "11001011", 
    178 to 179=> "11001100", 180 => "11001101", 181 => "11001110", 182 to 183=> "11001111", 
    184 => "11010000", 185 to 186=> "11010001", 187 => "11010010", 188 to 189=> "11010011", 
    190 => "11010100", 191 => "11010101", 192 to 193=> "11010110", 194 => "11010111", 
    195 to 196=> "11011000", 197 => "11011001", 198 to 199=> "11011010", 200 => "11011011", 
    201 to 202=> "11011100", 203 => "11011101", 204 to 205=> "11011110", 206 => "11011111", 
    207 => "11100000", 208 to 209=> "11100001", 210 => "11100010", 211 to 212=> "11100011", 
    213 => "11100100", 214 to 215=> "11100101", 216 => "11100110", 217 to 218=> "11100111", 
    219 => "11101000", 220 to 221=> "11101001", 222 => "11101010", 223 to 224=> "11101011", 
    225 to 226=> "11101100", 227 => "11101101", 228 to 229=> "11101110", 230 => "11101111", 
    231 to 232=> "11110000", 233 => "11110001", 234 to 235=> "11110010", 236 => "11110011", 
    237 to 238=> "11110100", 239 => "11110101", 240 to 241=> "11110110", 242 to 243=> "11110111", 
    244 => "11111000", 245 to 246=> "11111001", 247 => "11111010", 248 to 249=> "11111011", 
    250 to 251=> "11111100", 252 => "11111101", 253 to 254=> "11111110", 255 => "11111111" );
signal mem1 : mem_array := (
    0 => "00000000", 1 => "00001000", 2 => "00001100", 3 => "00010000", 
    4 => "00010011", 5 => "00010110", 6 => "00011000", 7 => "00011011", 
    8 => "00011101", 9 => "00100000", 10 => "00100010", 11 => "00100100", 
    12 => "00100110", 13 => "00101000", 14 => "00101010", 15 => "00101011", 
    16 => "00101101", 17 => "00101111", 18 => "00110001", 19 => "00110010", 
    20 => "00110100", 21 => "00110110", 22 => "00110111", 23 => "00111001", 
    24 => "00111010", 25 => "00111100", 26 => "00111101", 27 => "00111111", 
    28 => "01000000", 29 => "01000010", 30 => "01000011", 31 => "01000100", 
    32 => "01000110", 33 => "01000111", 34 => "01001000", 35 => "01001010", 
    36 => "01001011", 37 => "01001100", 38 => "01001110", 39 => "01001111", 
    40 => "01010000", 41 => "01010001", 42 => "01010011", 43 => "01010100", 
    44 => "01010101", 45 => "01010110", 46 => "01010111", 47 => "01011001", 
    48 => "01011010", 49 => "01011011", 50 => "01011100", 51 => "01011101", 
    52 => "01011110", 53 => "01100000", 54 => "01100001", 55 => "01100010", 
    56 => "01100011", 57 => "01100100", 58 => "01100101", 59 => "01100110", 
    60 => "01100111", 61 => "01101000", 62 => "01101001", 63 => "01101010", 
    64 => "01101011", 65 => "01101101", 66 => "01101110", 67 => "01101111", 
    68 => "01110000", 69 => "01110001", 70 => "01110010", 71 => "01110011", 
    72 => "01110100", 73 => "01110101", 74 => "01110110", 75 => "01110111", 
    76 => "01111000", 77 => "01111001", 78 => "01111010", 79 => "01111011", 
    80 => "01111100", 81 to 82=> "01111101", 83 => "01111110", 84 => "01111111", 
    85 => "10000000", 86 => "10000001", 87 => "10000010", 88 => "10000011", 
    89 => "10000100", 90 => "10000101", 91 => "10000110", 92 => "10000111", 
    93 => "10001000", 94 => "10001001", 95 to 96=> "10001010", 97 => "10001011", 
    98 => "10001100", 99 => "10001101", 100 => "10001110", 101 => "10001111", 
    102 => "10010000", 103 => "10010001", 104 to 105=> "10010010", 106 => "10010011", 
    107 => "10010100", 108 => "10010101", 109 => "10010110", 110 => "10010111", 
    111 to 112=> "10011000", 113 => "10011001", 114 => "10011010", 115 => "10011011", 
    116 => "10011100", 117 => "10011101", 118 to 119=> "10011110", 120 => "10011111", 
    121 => "10100000", 122 => "10100001", 123 to 124=> "10100010", 125 => "10100011", 
    126 => "10100100", 127 => "10100101", 128 => "10100110", 129 to 130=> "10100111", 
    131 => "10101000", 132 => "10101001", 133 => "10101010", 134 to 135=> "10101011", 
    136 => "10101100", 137 => "10101101", 138 => "10101110", 139 to 140=> "10101111", 
    141 => "10110000", 142 => "10110001", 143 to 144=> "10110010", 145 => "10110011", 
    146 => "10110100", 147 to 148=> "10110101", 149 => "10110110", 150 => "10110111", 
    151 => "10111000", 152 to 153=> "10111001", 154 => "10111010", 155 => "10111011", 
    156 to 157=> "10111100", 158 => "10111101", 159 => "10111110", 160 to 161=> "10111111", 
    162 => "11000000", 163 => "11000001", 164 to 165=> "11000010", 166 => "11000011", 
    167 to 168=> "11000100", 169 => "11000101", 170 => "11000110", 171 to 172=> "11000111", 
    173 => "11001000", 174 => "11001001", 175 to 176=> "11001010", 177 => "11001011", 
    178 to 179=> "11001100", 180 => "11001101", 181 => "11001110", 182 to 183=> "11001111", 
    184 => "11010000", 185 to 186=> "11010001", 187 => "11010010", 188 to 189=> "11010011", 
    190 => "11010100", 191 => "11010101", 192 to 193=> "11010110", 194 => "11010111", 
    195 to 196=> "11011000", 197 => "11011001", 198 to 199=> "11011010", 200 => "11011011", 
    201 to 202=> "11011100", 203 => "11011101", 204 to 205=> "11011110", 206 => "11011111", 
    207 => "11100000", 208 to 209=> "11100001", 210 => "11100010", 211 to 212=> "11100011", 
    213 => "11100100", 214 to 215=> "11100101", 216 => "11100110", 217 to 218=> "11100111", 
    219 => "11101000", 220 to 221=> "11101001", 222 => "11101010", 223 to 224=> "11101011", 
    225 to 226=> "11101100", 227 => "11101101", 228 to 229=> "11101110", 230 => "11101111", 
    231 to 232=> "11110000", 233 => "11110001", 234 to 235=> "11110010", 236 => "11110011", 
    237 to 238=> "11110100", 239 => "11110101", 240 to 241=> "11110110", 242 to 243=> "11110111", 
    244 => "11111000", 245 to 246=> "11111001", 247 => "11111010", 248 to 249=> "11111011", 
    250 to 251=> "11111100", 252 => "11111101", 253 to 254=> "11111110", 255 => "11111111" );

attribute syn_rom_style : string;
attribute syn_rom_style of mem0 : signal is "block_rom";
attribute syn_rom_style of mem1 : signal is "block_rom";
attribute ROM_STYLE : string;
attribute ROM_STYLE of mem0 : signal is "block";
attribute ROM_STYLE of mem1 : signal is "block";

begin 


memory_access_guard_0: process (addr0) 
begin
      addr0_tmp <= addr0;
--synthesis translate_off
      if (CONV_INTEGER(addr0) > mem_size-1) then
           addr0_tmp <= (others => '0');
      else 
           addr0_tmp <= addr0;
      end if;
--synthesis translate_on
end process;

memory_access_guard_1: process (addr1) 
begin
      addr1_tmp <= addr1;
--synthesis translate_off
      if (CONV_INTEGER(addr1) > mem_size-1) then
           addr1_tmp <= (others => '0');
      else 
           addr1_tmp <= addr1;
      end if;
--synthesis translate_on
end process;

memory_access_guard_2: process (addr2) 
begin
      addr2_tmp <= addr2;
--synthesis translate_off
      if (CONV_INTEGER(addr2) > mem_size-1) then
           addr2_tmp <= (others => '0');
      else 
           addr2_tmp <= addr2;
      end if;
--synthesis translate_on
end process;

p_rom_access: process (clk)  
begin 
    if (clk'event and clk = '1') then
        if (ce0 = '1') then 
            q0 <= mem0(CONV_INTEGER(addr0_tmp)); 
        end if;
        if (ce1 = '1') then 
            q1 <= mem0(CONV_INTEGER(addr1_tmp)); 
        end if;
        if (ce2 = '1') then 
            q2 <= mem1(CONV_INTEGER(addr2_tmp)); 
        end if;
    end if;
end process;

end rtl;


Library IEEE;
use IEEE.std_logic_1164.all;

entity Loop_loop_height_g8j is
    generic (
        DataWidth : INTEGER := 8;
        AddressRange : INTEGER := 256;
        AddressWidth : INTEGER := 8);
    port (
        reset : IN STD_LOGIC;
        clk : IN STD_LOGIC;
        address0 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce0 : IN STD_LOGIC;
        q0 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0);
        address1 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce1 : IN STD_LOGIC;
        q1 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0);
        address2 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce2 : IN STD_LOGIC;
        q2 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0));
end entity;

architecture arch of Loop_loop_height_g8j is
    component Loop_loop_height_g8j_rom is
        port (
            clk : IN STD_LOGIC;
            addr0 : IN STD_LOGIC_VECTOR;
            ce0 : IN STD_LOGIC;
            q0 : OUT STD_LOGIC_VECTOR;
            addr1 : IN STD_LOGIC_VECTOR;
            ce1 : IN STD_LOGIC;
            q1 : OUT STD_LOGIC_VECTOR;
            addr2 : IN STD_LOGIC_VECTOR;
            ce2 : IN STD_LOGIC;
            q2 : OUT STD_LOGIC_VECTOR);
    end component;



begin
    Loop_loop_height_g8j_rom_U :  component Loop_loop_height_g8j_rom
    port map (
        clk => clk,
        addr0 => address0,
        ce0 => ce0,
        q0 => q0,
        addr1 => address1,
        ce1 => ce1,
        q1 => q1,
        addr2 => address2,
        ce2 => ce2,
        q2 => q2);

end architecture;


