-- ==============================================================
-- File generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
-- Version: 2017.4
-- Copyright (C) 1986-2017 Xilinx, Inc. All Rights Reserved.
-- 
-- ==============================================================

library ieee; 
use ieee.std_logic_1164.all; 
use ieee.std_logic_unsigned.all;

entity Loop_loop_height_eOg_rom is 
    generic(
             dwidth     : integer := 8; 
             awidth     : integer := 8; 
             mem_size    : integer := 256
    ); 
    port (
          addr0      : in std_logic_vector(awidth-1 downto 0); 
          ce0       : in std_logic; 
          q0         : out std_logic_vector(dwidth-1 downto 0);
          addr1      : in std_logic_vector(awidth-1 downto 0); 
          ce1       : in std_logic; 
          q1         : out std_logic_vector(dwidth-1 downto 0);
          addr2      : in std_logic_vector(awidth-1 downto 0); 
          ce2       : in std_logic; 
          q2         : out std_logic_vector(dwidth-1 downto 0);
          clk       : in std_logic
    ); 
end entity; 


architecture rtl of Loop_loop_height_eOg_rom is 

signal addr0_tmp : std_logic_vector(awidth-1 downto 0); 
signal addr1_tmp : std_logic_vector(awidth-1 downto 0); 
signal addr2_tmp : std_logic_vector(awidth-1 downto 0); 
type mem_array is array (0 to mem_size-1) of std_logic_vector (dwidth-1 downto 0); 
signal mem0 : mem_array := (
    0 => "00000000", 1 => "00000011", 2 => "00000100", 3 => "00000110", 
    4 => "00001000", 5 => "00001010", 6 => "00001011", 7 => "00001101", 
    8 => "00001110", 9 => "00010000", 10 => "00010001", 11 => "00010011", 
    12 => "00010100", 13 => "00010101", 14 => "00010111", 15 => "00011000", 
    16 => "00011001", 17 => "00011011", 18 => "00011100", 19 => "00011101", 
    20 => "00011111", 21 => "00100000", 22 => "00100001", 23 => "00100010", 
    24 => "00100100", 25 => "00100101", 26 => "00100110", 27 => "00100111", 
    28 => "00101000", 29 => "00101010", 30 => "00101011", 31 => "00101100", 
    32 => "00101101", 33 => "00101110", 34 => "00110000", 35 => "00110001", 
    36 => "00110010", 37 => "00110011", 38 => "00110100", 39 => "00110101", 
    40 => "00110110", 41 => "00111000", 42 => "00111001", 43 => "00111010", 
    44 => "00111011", 45 => "00111100", 46 => "00111101", 47 => "00111110", 
    48 => "00111111", 49 => "01000001", 50 => "01000010", 51 => "01000011", 
    52 => "01000100", 53 => "01000101", 54 => "01000110", 55 => "01000111", 
    56 => "01001000", 57 => "01001001", 58 => "01001010", 59 => "01001011", 
    60 => "01001100", 61 => "01001101", 62 => "01001110", 63 => "01010000", 
    64 => "01010001", 65 => "01010010", 66 => "01010011", 67 => "01010100", 
    68 => "01010101", 69 => "01010110", 70 => "01010111", 71 => "01011000", 
    72 => "01011001", 73 => "01011010", 74 => "01011011", 75 => "01011100", 
    76 => "01011101", 77 => "01011110", 78 => "01011111", 79 => "01100000", 
    80 => "01100001", 81 => "01100010", 82 => "01100011", 83 => "01100100", 
    84 => "01100101", 85 => "01100110", 86 => "01100111", 87 => "01101000", 
    88 => "01101001", 89 => "01101010", 90 => "01101011", 91 => "01101100", 
    92 => "01101101", 93 => "01101110", 94 => "01101111", 95 => "01110000", 
    96 => "01110001", 97 => "01110010", 98 => "01110011", 99 => "01110100", 
    100 => "01110101", 101 => "01110110", 102 => "01110111", 103 => "01111000", 
    104 => "01111001", 105 => "01111010", 106 => "01111011", 107 => "01111100", 
    108 => "01111101", 109 => "01111110", 110 => "01111111", 111 to 112=> "10000000", 
    113 => "10000001", 114 => "10000010", 115 => "10000011", 116 => "10000100", 
    117 => "10000101", 118 => "10000110", 119 => "10000111", 120 => "10001000", 
    121 => "10001001", 122 => "10001010", 123 => "10001011", 124 => "10001100", 
    125 => "10001101", 126 => "10001110", 127 => "10001111", 128 => "10010000", 
    129 to 130=> "10010001", 131 => "10010010", 132 => "10010011", 133 => "10010100", 
    134 => "10010101", 135 => "10010110", 136 => "10010111", 137 => "10011000", 
    138 => "10011001", 139 => "10011010", 140 => "10011011", 141 => "10011100", 
    142 to 143=> "10011101", 144 => "10011110", 145 => "10011111", 146 => "10100000", 
    147 => "10100001", 148 => "10100010", 149 => "10100011", 150 => "10100100", 
    151 => "10100101", 152 => "10100110", 153 => "10100111", 154 to 155=> "10101000", 
    156 => "10101001", 157 => "10101010", 158 => "10101011", 159 => "10101100", 
    160 => "10101101", 161 => "10101110", 162 => "10101111", 163 => "10110000", 
    164 to 165=> "10110001", 166 => "10110010", 167 => "10110011", 168 => "10110100", 
    169 => "10110101", 170 => "10110110", 171 => "10110111", 172 => "10111000", 
    173 to 174=> "10111001", 175 => "10111010", 176 => "10111011", 177 => "10111100", 
    178 => "10111101", 179 => "10111110", 180 => "10111111", 181 => "11000000", 
    182 to 183=> "11000001", 184 => "11000010", 185 => "11000011", 186 => "11000100", 
    187 => "11000101", 188 => "11000110", 189 => "11000111", 190 to 191=> "11001000", 
    192 => "11001001", 193 => "11001010", 194 => "11001011", 195 => "11001100", 
    196 => "11001101", 197 => "11001110", 198 to 199=> "11001111", 200 => "11010000", 
    201 => "11010001", 202 => "11010010", 203 => "11010011", 204 => "11010100", 
    205 to 206=> "11010101", 207 => "11010110", 208 => "11010111", 209 => "11011000", 
    210 => "11011001", 211 => "11011010", 212 to 213=> "11011011", 214 => "11011100", 
    215 => "11011101", 216 => "11011110", 217 => "11011111", 218 => "11100000", 
    219 to 220=> "11100001", 221 => "11100010", 222 => "11100011", 223 => "11100100", 
    224 => "11100101", 225 => "11100110", 226 to 227=> "11100111", 228 => "11101000", 
    229 => "11101001", 230 => "11101010", 231 => "11101011", 232 => "11101100", 
    233 to 234=> "11101101", 235 => "11101110", 236 => "11101111", 237 => "11110000", 
    238 => "11110001", 239 to 240=> "11110010", 241 => "11110011", 242 => "11110100", 
    243 => "11110101", 244 => "11110110", 245 to 246=> "11110111", 247 => "11111000", 
    248 => "11111001", 249 => "11111010", 250 => "11111011", 251 to 252=> "11111100", 
    253 => "11111101", 254 => "11111110", 255 => "11111111" );
signal mem1 : mem_array := (
    0 => "00000000", 1 => "00000011", 2 => "00000100", 3 => "00000110", 
    4 => "00001000", 5 => "00001010", 6 => "00001011", 7 => "00001101", 
    8 => "00001110", 9 => "00010000", 10 => "00010001", 11 => "00010011", 
    12 => "00010100", 13 => "00010101", 14 => "00010111", 15 => "00011000", 
    16 => "00011001", 17 => "00011011", 18 => "00011100", 19 => "00011101", 
    20 => "00011111", 21 => "00100000", 22 => "00100001", 23 => "00100010", 
    24 => "00100100", 25 => "00100101", 26 => "00100110", 27 => "00100111", 
    28 => "00101000", 29 => "00101010", 30 => "00101011", 31 => "00101100", 
    32 => "00101101", 33 => "00101110", 34 => "00110000", 35 => "00110001", 
    36 => "00110010", 37 => "00110011", 38 => "00110100", 39 => "00110101", 
    40 => "00110110", 41 => "00111000", 42 => "00111001", 43 => "00111010", 
    44 => "00111011", 45 => "00111100", 46 => "00111101", 47 => "00111110", 
    48 => "00111111", 49 => "01000001", 50 => "01000010", 51 => "01000011", 
    52 => "01000100", 53 => "01000101", 54 => "01000110", 55 => "01000111", 
    56 => "01001000", 57 => "01001001", 58 => "01001010", 59 => "01001011", 
    60 => "01001100", 61 => "01001101", 62 => "01001110", 63 => "01010000", 
    64 => "01010001", 65 => "01010010", 66 => "01010011", 67 => "01010100", 
    68 => "01010101", 69 => "01010110", 70 => "01010111", 71 => "01011000", 
    72 => "01011001", 73 => "01011010", 74 => "01011011", 75 => "01011100", 
    76 => "01011101", 77 => "01011110", 78 => "01011111", 79 => "01100000", 
    80 => "01100001", 81 => "01100010", 82 => "01100011", 83 => "01100100", 
    84 => "01100101", 85 => "01100110", 86 => "01100111", 87 => "01101000", 
    88 => "01101001", 89 => "01101010", 90 => "01101011", 91 => "01101100", 
    92 => "01101101", 93 => "01101110", 94 => "01101111", 95 => "01110000", 
    96 => "01110001", 97 => "01110010", 98 => "01110011", 99 => "01110100", 
    100 => "01110101", 101 => "01110110", 102 => "01110111", 103 => "01111000", 
    104 => "01111001", 105 => "01111010", 106 => "01111011", 107 => "01111100", 
    108 => "01111101", 109 => "01111110", 110 => "01111111", 111 to 112=> "10000000", 
    113 => "10000001", 114 => "10000010", 115 => "10000011", 116 => "10000100", 
    117 => "10000101", 118 => "10000110", 119 => "10000111", 120 => "10001000", 
    121 => "10001001", 122 => "10001010", 123 => "10001011", 124 => "10001100", 
    125 => "10001101", 126 => "10001110", 127 => "10001111", 128 => "10010000", 
    129 to 130=> "10010001", 131 => "10010010", 132 => "10010011", 133 => "10010100", 
    134 => "10010101", 135 => "10010110", 136 => "10010111", 137 => "10011000", 
    138 => "10011001", 139 => "10011010", 140 => "10011011", 141 => "10011100", 
    142 to 143=> "10011101", 144 => "10011110", 145 => "10011111", 146 => "10100000", 
    147 => "10100001", 148 => "10100010", 149 => "10100011", 150 => "10100100", 
    151 => "10100101", 152 => "10100110", 153 => "10100111", 154 to 155=> "10101000", 
    156 => "10101001", 157 => "10101010", 158 => "10101011", 159 => "10101100", 
    160 => "10101101", 161 => "10101110", 162 => "10101111", 163 => "10110000", 
    164 to 165=> "10110001", 166 => "10110010", 167 => "10110011", 168 => "10110100", 
    169 => "10110101", 170 => "10110110", 171 => "10110111", 172 => "10111000", 
    173 to 174=> "10111001", 175 => "10111010", 176 => "10111011", 177 => "10111100", 
    178 => "10111101", 179 => "10111110", 180 => "10111111", 181 => "11000000", 
    182 to 183=> "11000001", 184 => "11000010", 185 => "11000011", 186 => "11000100", 
    187 => "11000101", 188 => "11000110", 189 => "11000111", 190 to 191=> "11001000", 
    192 => "11001001", 193 => "11001010", 194 => "11001011", 195 => "11001100", 
    196 => "11001101", 197 => "11001110", 198 to 199=> "11001111", 200 => "11010000", 
    201 => "11010001", 202 => "11010010", 203 => "11010011", 204 => "11010100", 
    205 to 206=> "11010101", 207 => "11010110", 208 => "11010111", 209 => "11011000", 
    210 => "11011001", 211 => "11011010", 212 to 213=> "11011011", 214 => "11011100", 
    215 => "11011101", 216 => "11011110", 217 => "11011111", 218 => "11100000", 
    219 to 220=> "11100001", 221 => "11100010", 222 => "11100011", 223 => "11100100", 
    224 => "11100101", 225 => "11100110", 226 to 227=> "11100111", 228 => "11101000", 
    229 => "11101001", 230 => "11101010", 231 => "11101011", 232 => "11101100", 
    233 to 234=> "11101101", 235 => "11101110", 236 => "11101111", 237 => "11110000", 
    238 => "11110001", 239 to 240=> "11110010", 241 => "11110011", 242 => "11110100", 
    243 => "11110101", 244 => "11110110", 245 to 246=> "11110111", 247 => "11111000", 
    248 => "11111001", 249 => "11111010", 250 => "11111011", 251 to 252=> "11111100", 
    253 => "11111101", 254 => "11111110", 255 => "11111111" );

attribute syn_rom_style : string;
attribute syn_rom_style of mem0 : signal is "block_rom";
attribute syn_rom_style of mem1 : signal is "block_rom";
attribute ROM_STYLE : string;
attribute ROM_STYLE of mem0 : signal is "block";
attribute ROM_STYLE of mem1 : signal is "block";

begin 


memory_access_guard_0: process (addr0) 
begin
      addr0_tmp <= addr0;
--synthesis translate_off
      if (CONV_INTEGER(addr0) > mem_size-1) then
           addr0_tmp <= (others => '0');
      else 
           addr0_tmp <= addr0;
      end if;
--synthesis translate_on
end process;

memory_access_guard_1: process (addr1) 
begin
      addr1_tmp <= addr1;
--synthesis translate_off
      if (CONV_INTEGER(addr1) > mem_size-1) then
           addr1_tmp <= (others => '0');
      else 
           addr1_tmp <= addr1;
      end if;
--synthesis translate_on
end process;

memory_access_guard_2: process (addr2) 
begin
      addr2_tmp <= addr2;
--synthesis translate_off
      if (CONV_INTEGER(addr2) > mem_size-1) then
           addr2_tmp <= (others => '0');
      else 
           addr2_tmp <= addr2;
      end if;
--synthesis translate_on
end process;

p_rom_access: process (clk)  
begin 
    if (clk'event and clk = '1') then
        if (ce0 = '1') then 
            q0 <= mem0(CONV_INTEGER(addr0_tmp)); 
        end if;
        if (ce1 = '1') then 
            q1 <= mem0(CONV_INTEGER(addr1_tmp)); 
        end if;
        if (ce2 = '1') then 
            q2 <= mem1(CONV_INTEGER(addr2_tmp)); 
        end if;
    end if;
end process;

end rtl;


Library IEEE;
use IEEE.std_logic_1164.all;

entity Loop_loop_height_eOg is
    generic (
        DataWidth : INTEGER := 8;
        AddressRange : INTEGER := 256;
        AddressWidth : INTEGER := 8);
    port (
        reset : IN STD_LOGIC;
        clk : IN STD_LOGIC;
        address0 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce0 : IN STD_LOGIC;
        q0 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0);
        address1 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce1 : IN STD_LOGIC;
        q1 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0);
        address2 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce2 : IN STD_LOGIC;
        q2 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0));
end entity;

architecture arch of Loop_loop_height_eOg is
    component Loop_loop_height_eOg_rom is
        port (
            clk : IN STD_LOGIC;
            addr0 : IN STD_LOGIC_VECTOR;
            ce0 : IN STD_LOGIC;
            q0 : OUT STD_LOGIC_VECTOR;
            addr1 : IN STD_LOGIC_VECTOR;
            ce1 : IN STD_LOGIC;
            q1 : OUT STD_LOGIC_VECTOR;
            addr2 : IN STD_LOGIC_VECTOR;
            ce2 : IN STD_LOGIC;
            q2 : OUT STD_LOGIC_VECTOR);
    end component;



begin
    Loop_loop_height_eOg_rom_U :  component Loop_loop_height_eOg_rom
    port map (
        clk => clk,
        addr0 => address0,
        ce0 => ce0,
        q0 => q0,
        addr1 => address1,
        ce1 => ce1,
        q1 => q1,
        addr2 => address2,
        ce2 => ce2,
        q2 => q2);

end architecture;


