import * as path from 'path';
import path__default, { join, dirname } from 'path';
import * as fs from 'fs';
import fs__default, { existsSync as existsSync$1, readFileSync as readFileSync$1, mkdirSync, statSync as statSync$1, writeFileSync, promises } from 'fs';
import fsProm, { stat as stat$1, readdir, unlink as unlink$1 } from 'fs/promises';
import { ReadableStream as ReadableStream$1 } from 'node:stream/web';
import * as stream$3 from 'node:stream';
import stream__default, { Readable, PassThrough, pipeline } from 'node:stream';
import fs$1, { open, stat, writeFile, constants as constants$1, unlink, readdir as readdir$1 } from 'node:fs/promises';
import { createRequire } from 'module';
import https$1 from 'node:https';
import http from 'node:http';
import * as crypto$2 from 'crypto';
import crypto__default, { randomUUID, createHmac, createHash as createHash$1 } from 'crypto';
import path$1, { basename, resolve as resolve$1, dirname as dirname$1, join as join$1 } from 'node:path';
import os$1, { platform, arch, constants } from 'node:os';
import fs$2, { readFileSync, statSync, createReadStream, existsSync, unlink as unlink$2 } from 'node:fs';
import * as crypto$1 from 'node:crypto';
import crypto__default$1, { createHash, randomBytes, randomUUID as randomUUID$1 } from 'node:crypto';
import * as os from 'os';
import os__default from 'os';
import * as net from 'node:net';
import net__default, { isIP } from 'node:net';
import assert$1 from 'node:assert';
import * as zlib from 'node:zlib';
import zlib__default from 'node:zlib';
import { dlopen } from 'node:process';
import { execFile, fork } from 'child_process';
import require$$0$6, { promisify } from 'util';
import * as https from 'https';
import https__default, { createServer } from 'https';
import require$$1$1, { PassThrough as PassThrough$1, Writable } from 'stream';
import require$$1$2, { gunzipSync as gunzipSync$1 } from 'zlib';
import require$$0$5, { EventEmitter as EventEmitter$2 } from 'events';
import require$$0$4 from 'buffer';
import require$$0$7 from 'constants';
import require$$1$3 from 'string_decoder';
import require$$2$2 from 'assert';
import { pipeline as pipeline$1 } from 'stream/promises';
import { fileURLToPath, URL as URL$2 } from 'url';
import require$$0$8, { createServer as createServer$1 } from 'http';
import EventEmitter, { EventEmitter as EventEmitter$1 } from 'node:events';
import express, { Router } from 'express';
import { WebSocketServer, WebSocket } from 'ws';
import * as net$1 from 'net';
import { Socket } from 'net';
import { Worker as Worker$1 } from 'worker_threads';
import { C as ConoutWorkerMessage, g as getWorkerPipeName } from './conout-D9oph_Le.js';
import { fileURLToPath as fileURLToPath$1 } from 'node:url';
import * as tty from 'tty';
import { Buffer as Buffer$1 } from 'node:buffer';
import { decode, isSilk, isWav, getDuration, getWavFileInfo } from 'silk-wasm';
import * as process$1 from 'process';

/**
 * Get the type of a JSON value.
 * Distinguishes between array, null and object.
 */
function typeofJsonValue(value) {
    let t = typeof value;
    if (t == "object") {
        if (Array.isArray(value))
            return "array";
        if (value === null)
            return "null";
    }
    return t;
}
/**
 * Is this a JSON object (instead of an array or null)?
 */
function isJsonObject(value) {
    return value !== null && typeof value == "object" && !Array.isArray(value);
}

// lookup table from base64 character to byte
let encTable = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'.split('');
// lookup table from base64 character *code* to byte because lookup by number is fast
let decTable = [];
for (let i = 0; i < encTable.length; i++)
    decTable[encTable[i].charCodeAt(0)] = i;
// support base64url variants
decTable["-".charCodeAt(0)] = encTable.indexOf("+");
decTable["_".charCodeAt(0)] = encTable.indexOf("/");
/**
 * Decodes a base64 string to a byte array.
 *
 * - ignores white-space, including line breaks and tabs
 * - allows inner padding (can decode concatenated base64 strings)
 * - does not require padding
 * - understands base64url encoding:
 *   "-" instead of "+",
 *   "_" instead of "/",
 *   no padding
 */
function base64decode(base64Str) {
    // estimate byte size, not accounting for inner padding and whitespace
    let es = base64Str.length * 3 / 4;
    // if (es % 3 !== 0)
    // throw new Error('invalid base64 string');
    if (base64Str[base64Str.length - 2] == '=')
        es -= 2;
    else if (base64Str[base64Str.length - 1] == '=')
        es -= 1;
    let bytes = new Uint8Array(es), bytePos = 0, // position in byte array
    groupPos = 0, // position in base64 group
    b, // current byte
    p = 0 // previous byte
    ;
    for (let i = 0; i < base64Str.length; i++) {
        b = decTable[base64Str.charCodeAt(i)];
        if (b === undefined) {
            // noinspection FallThroughInSwitchStatementJS
            switch (base64Str[i]) {
                case '=':
                    groupPos = 0; // reset state when padding found
                case '\n':
                case '\r':
                case '\t':
                case ' ':
                    continue; // skip white-space, and padding
                default:
                    throw Error(`invalid base64 string.`);
            }
        }
        switch (groupPos) {
            case 0:
                p = b;
                groupPos = 1;
                break;
            case 1:
                bytes[bytePos++] = p << 2 | (b & 48) >> 4;
                p = b;
                groupPos = 2;
                break;
            case 2:
                bytes[bytePos++] = (p & 15) << 4 | (b & 60) >> 2;
                p = b;
                groupPos = 3;
                break;
            case 3:
                bytes[bytePos++] = (p & 3) << 6 | b;
                groupPos = 0;
                break;
        }
    }
    if (groupPos == 1)
        throw Error(`invalid base64 string.`);
    return bytes.subarray(0, bytePos);
}
/**
 * Encodes a byte array to a base64 string.
 * Adds padding at the end.
 * Does not insert newlines.
 */
function base64encode(bytes) {
    let base64 = '', groupPos = 0, // position in base64 group
    b, // current byte
    p = 0; // carry over from previous byte
    for (let i = 0; i < bytes.length; i++) {
        b = bytes[i];
        switch (groupPos) {
            case 0:
                base64 += encTable[b >> 2];
                p = (b & 3) << 4;
                groupPos = 1;
                break;
            case 1:
                base64 += encTable[p | b >> 4];
                p = (b & 15) << 2;
                groupPos = 2;
                break;
            case 2:
                base64 += encTable[p | b >> 6];
                base64 += encTable[b & 63];
                groupPos = 0;
                break;
        }
    }
    // padding required?
    if (groupPos) {
        base64 += encTable[p];
        base64 += '=';
        if (groupPos == 1)
            base64 += '=';
    }
    return base64;
}

/**
 * This handler implements the default behaviour for unknown fields.
 * When reading data, unknown fields are stored on the message, in a
 * symbol property.
 * When writing data, the symbol property is queried and unknown fields
 * are serialized into the output again.
 */
var UnknownFieldHandler;
(function (UnknownFieldHandler) {
    /**
     * The symbol used to store unknown fields for a message.
     * The property must conform to `UnknownFieldContainer`.
     */
    UnknownFieldHandler.symbol = Symbol.for("protobuf-ts/unknown");
    /**
     * Store an unknown field during binary read directly on the message.
     * This method is compatible with `BinaryReadOptions.readUnknownField`.
     */
    UnknownFieldHandler.onRead = (typeName, message, fieldNo, wireType, data) => {
        let container = is(message) ? message[UnknownFieldHandler.symbol] : message[UnknownFieldHandler.symbol] = [];
        container.push({ no: fieldNo, wireType, data });
    };
    /**
     * Write unknown fields stored for the message to the writer.
     * This method is compatible with `BinaryWriteOptions.writeUnknownFields`.
     */
    UnknownFieldHandler.onWrite = (typeName, message, writer) => {
        for (let { no, wireType, data } of UnknownFieldHandler.list(message))
            writer.tag(no, wireType).raw(data);
    };
    /**
     * List unknown fields stored for the message.
     * Note that there may be multiples fields with the same number.
     */
    UnknownFieldHandler.list = (message, fieldNo) => {
        if (is(message)) {
            let all = message[UnknownFieldHandler.symbol];
            return fieldNo ? all.filter(uf => uf.no == fieldNo) : all;
        }
        return [];
    };
    /**
     * Returns the last unknown field by field number.
     */
    UnknownFieldHandler.last = (message, fieldNo) => UnknownFieldHandler.list(message, fieldNo).slice(-1)[0];
    const is = (message) => message && Array.isArray(message[UnknownFieldHandler.symbol]);
})(UnknownFieldHandler || (UnknownFieldHandler = {}));
/**
 * Protobuf binary format wire types.
 *
 * A wire type provides just enough information to find the length of the
 * following value.
 *
 * See https://developers.google.com/protocol-buffers/docs/encoding#structure
 */
var WireType;
(function (WireType) {
    /**
     * Used for int32, int64, uint32, uint64, sint32, sint64, bool, enum
     */
    WireType[WireType["Varint"] = 0] = "Varint";
    /**
     * Used for fixed64, sfixed64, double.
     * Always 8 bytes with little-endian byte order.
     */
    WireType[WireType["Bit64"] = 1] = "Bit64";
    /**
     * Used for string, bytes, embedded messages, packed repeated fields
     *
     * Only repeated numeric types (types which use the varint, 32-bit,
     * or 64-bit wire types) can be packed. In proto3, such fields are
     * packed by default.
     */
    WireType[WireType["LengthDelimited"] = 2] = "LengthDelimited";
    /**
     * Used for groups
     * @deprecated
     */
    WireType[WireType["StartGroup"] = 3] = "StartGroup";
    /**
     * Used for groups
     * @deprecated
     */
    WireType[WireType["EndGroup"] = 4] = "EndGroup";
    /**
     * Used for fixed32, sfixed32, float.
     * Always 4 bytes with little-endian byte order.
     */
    WireType[WireType["Bit32"] = 5] = "Bit32";
})(WireType || (WireType = {}));

// Copyright 2008 Google Inc.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
// * Neither the name of Google Inc. nor the names of its
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Code generated by the Protocol Buffer compiler is owned by the owner
// of the input file used when generating it.  This code is not
// standalone and requires a support library to be linked with it.  This
// support library is itself covered by the above license.
/**
 * Read a 64 bit varint as two JS numbers.
 *
 * Returns tuple:
 * [0]: low bits
 * [0]: high bits
 *
 * Copyright 2008 Google Inc.  All rights reserved.
 *
 * See https://github.com/protocolbuffers/protobuf/blob/8a71927d74a4ce34efe2d8769fda198f52d20d12/js/experimental/runtime/kernel/buffer_decoder.js#L175
 */
function varint64read() {
    let lowBits = 0;
    let highBits = 0;
    for (let shift = 0; shift < 28; shift += 7) {
        let b = this.buf[this.pos++];
        lowBits |= (b & 0x7F) << shift;
        if ((b & 0x80) == 0) {
            this.assertBounds();
            return [lowBits, highBits];
        }
    }
    let middleByte = this.buf[this.pos++];
    // last four bits of the first 32 bit number
    lowBits |= (middleByte & 0x0F) << 28;
    // 3 upper bits are part of the next 32 bit number
    highBits = (middleByte & 0x70) >> 4;
    if ((middleByte & 0x80) == 0) {
        this.assertBounds();
        return [lowBits, highBits];
    }
    for (let shift = 3; shift <= 31; shift += 7) {
        let b = this.buf[this.pos++];
        highBits |= (b & 0x7F) << shift;
        if ((b & 0x80) == 0) {
            this.assertBounds();
            return [lowBits, highBits];
        }
    }
    throw new Error('invalid varint');
}
/**
 * Write a 64 bit varint, given as two JS numbers, to the given bytes array.
 *
 * Copyright 2008 Google Inc.  All rights reserved.
 *
 * See https://github.com/protocolbuffers/protobuf/blob/8a71927d74a4ce34efe2d8769fda198f52d20d12/js/experimental/runtime/kernel/writer.js#L344
 */
function varint64write(lo, hi, bytes) {
    for (let i = 0; i < 28; i = i + 7) {
        const shift = lo >>> i;
        const hasNext = !((shift >>> 7) == 0 && hi == 0);
        const byte = (hasNext ? shift | 0x80 : shift) & 0xFF;
        bytes.push(byte);
        if (!hasNext) {
            return;
        }
    }
    const splitBits = ((lo >>> 28) & 0x0F) | ((hi & 0x07) << 4);
    const hasMoreBits = !((hi >> 3) == 0);
    bytes.push((hasMoreBits ? splitBits | 0x80 : splitBits) & 0xFF);
    if (!hasMoreBits) {
        return;
    }
    for (let i = 3; i < 31; i = i + 7) {
        const shift = hi >>> i;
        const hasNext = !((shift >>> 7) == 0);
        const byte = (hasNext ? shift | 0x80 : shift) & 0xFF;
        bytes.push(byte);
        if (!hasNext) {
            return;
        }
    }
    bytes.push((hi >>> 31) & 0x01);
}
// constants for binary math
const TWO_PWR_32_DBL$1 = (1 << 16) * (1 << 16);
/**
 * Parse decimal string of 64 bit integer value as two JS numbers.
 *
 * Returns tuple:
 * [0]: minus sign?
 * [1]: low bits
 * [2]: high bits
 *
 * Copyright 2008 Google Inc.
 */
function int64fromString(dec) {
    // Check for minus sign.
    let minus = dec[0] == '-';
    if (minus)
        dec = dec.slice(1);
    // Work 6 decimal digits at a time, acting like we're converting base 1e6
    // digits to binary. This is safe to do with floating point math because
    // Number.isSafeInteger(ALL_32_BITS * 1e6) == true.
    const base = 1e6;
    let lowBits = 0;
    let highBits = 0;
    function add1e6digit(begin, end) {
        // Note: Number('') is 0.
        const digit1e6 = Number(dec.slice(begin, end));
        highBits *= base;
        lowBits = lowBits * base + digit1e6;
        // Carry bits from lowBits to highBits
        if (lowBits >= TWO_PWR_32_DBL$1) {
            highBits = highBits + ((lowBits / TWO_PWR_32_DBL$1) | 0);
            lowBits = lowBits % TWO_PWR_32_DBL$1;
        }
    }
    add1e6digit(-24, -18);
    add1e6digit(-18, -12);
    add1e6digit(-12, -6);
    add1e6digit(-6);
    return [minus, lowBits, highBits];
}
/**
 * Format 64 bit integer value (as two JS numbers) to decimal string.
 *
 * Copyright 2008 Google Inc.
 */
function int64toString(bitsLow, bitsHigh) {
    // Skip the expensive conversion if the number is small enough to use the
    // built-in conversions.
    if ((bitsHigh >>> 0) <= 0x1FFFFF) {
        return '' + (TWO_PWR_32_DBL$1 * bitsHigh + (bitsLow >>> 0));
    }
    // What this code is doing is essentially converting the input number from
    // base-2 to base-1e7, which allows us to represent the 64-bit range with
    // only 3 (very large) digits. Those digits are then trivial to convert to
    // a base-10 string.
    // The magic numbers used here are -
    // 2^24 = 16777216 = (1,6777216) in base-1e7.
    // 2^48 = 281474976710656 = (2,8147497,6710656) in base-1e7.
    // Split 32:32 representation into 16:24:24 representation so our
    // intermediate digits don't overflow.
    let low = bitsLow & 0xFFFFFF;
    let mid = (((bitsLow >>> 24) | (bitsHigh << 8)) >>> 0) & 0xFFFFFF;
    let high = (bitsHigh >> 16) & 0xFFFF;
    // Assemble our three base-1e7 digits, ignoring carries. The maximum
    // value in a digit at this step is representable as a 48-bit integer, which
    // can be stored in a 64-bit floating point number.
    let digitA = low + (mid * 6777216) + (high * 6710656);
    let digitB = mid + (high * 8147497);
    let digitC = (high * 2);
    // Apply carries from A to B and from B to C.
    let base = 10000000;
    if (digitA >= base) {
        digitB += Math.floor(digitA / base);
        digitA %= base;
    }
    if (digitB >= base) {
        digitC += Math.floor(digitB / base);
        digitB %= base;
    }
    // Convert base-1e7 digits to base-10, with optional leading zeroes.
    function decimalFrom1e7(digit1e7, needLeadingZeros) {
        let partial = digit1e7 ? String(digit1e7) : '';
        if (needLeadingZeros) {
            return '0000000'.slice(partial.length) + partial;
        }
        return partial;
    }
    return decimalFrom1e7(digitC, /*needLeadingZeros=*/ 0) +
        decimalFrom1e7(digitB, /*needLeadingZeros=*/ digitC) +
        // If the final 1e7 digit didn't need leading zeros, we would have
        // returned via the trivial code path at the top.
        decimalFrom1e7(digitA, /*needLeadingZeros=*/ 1);
}
/**
 * Write a 32 bit varint, signed or unsigned. Same as `varint64write(0, value, bytes)`
 *
 * Copyright 2008 Google Inc.  All rights reserved.
 *
 * See https://github.com/protocolbuffers/protobuf/blob/1b18833f4f2a2f681f4e4a25cdf3b0a43115ec26/js/binary/encoder.js#L144
 */
function varint32write(value, bytes) {
    if (value >= 0) {
        // write value as varint 32
        while (value > 0x7f) {
            bytes.push((value & 0x7f) | 0x80);
            value = value >>> 7;
        }
        bytes.push(value);
    }
    else {
        for (let i = 0; i < 9; i++) {
            bytes.push(value & 127 | 128);
            value = value >> 7;
        }
        bytes.push(1);
    }
}
/**
 * Read an unsigned 32 bit varint.
 *
 * See https://github.com/protocolbuffers/protobuf/blob/8a71927d74a4ce34efe2d8769fda198f52d20d12/js/experimental/runtime/kernel/buffer_decoder.js#L220
 */
function varint32read() {
    let b = this.buf[this.pos++];
    let result = b & 0x7F;
    if ((b & 0x80) == 0) {
        this.assertBounds();
        return result;
    }
    b = this.buf[this.pos++];
    result |= (b & 0x7F) << 7;
    if ((b & 0x80) == 0) {
        this.assertBounds();
        return result;
    }
    b = this.buf[this.pos++];
    result |= (b & 0x7F) << 14;
    if ((b & 0x80) == 0) {
        this.assertBounds();
        return result;
    }
    b = this.buf[this.pos++];
    result |= (b & 0x7F) << 21;
    if ((b & 0x80) == 0) {
        this.assertBounds();
        return result;
    }
    // Extract only last 4 bits
    b = this.buf[this.pos++];
    result |= (b & 0x0F) << 28;
    for (let readBytes = 5; ((b & 0x80) !== 0) && readBytes < 10; readBytes++)
        b = this.buf[this.pos++];
    if ((b & 0x80) != 0)
        throw new Error('invalid varint');
    this.assertBounds();
    // Result can have 32 bits, convert it to unsigned
    return result >>> 0;
}

let BI;
function detectBi() {
    const dv = new DataView(new ArrayBuffer(8));
    const ok = globalThis.BigInt !== undefined
        && typeof dv.getBigInt64 === "function"
        && typeof dv.getBigUint64 === "function"
        && typeof dv.setBigInt64 === "function"
        && typeof dv.setBigUint64 === "function";
    BI = ok ? {
        MIN: BigInt("-9223372036854775808"),
        MAX: BigInt("9223372036854775807"),
        UMIN: BigInt("0"),
        UMAX: BigInt("18446744073709551615"),
        C: BigInt,
        V: dv,
    } : undefined;
}
detectBi();
function assertBi(bi) {
    if (!bi)
        throw new Error("BigInt unavailable, see https://github.com/timostamm/protobuf-ts/blob/v1.0.8/MANUAL.md#bigint-support");
}
// used to validate from(string) input (when bigint is unavailable)
const RE_DECIMAL_STR = /^-?[0-9]+$/;
// constants for binary math
const TWO_PWR_32_DBL = 0x100000000;
const HALF_2_PWR_32 = 0x080000000;
// base class for PbLong and PbULong provides shared code
class SharedPbLong {
    /**
     * Create a new instance with the given bits.
     */
    constructor(lo, hi) {
        this.lo = lo | 0;
        this.hi = hi | 0;
    }
    /**
     * Is this instance equal to 0?
     */
    isZero() {
        return this.lo == 0 && this.hi == 0;
    }
    /**
     * Convert to a native number.
     */
    toNumber() {
        let result = this.hi * TWO_PWR_32_DBL + (this.lo >>> 0);
        if (!Number.isSafeInteger(result))
            throw new Error("cannot convert to safe number");
        return result;
    }
}
/**
 * 64-bit unsigned integer as two 32-bit values.
 * Converts between `string`, `number` and `bigint` representations.
 */
class PbULong extends SharedPbLong {
    /**
     * Create instance from a `string`, `number` or `bigint`.
     */
    static from(value) {
        if (BI)
            // noinspection FallThroughInSwitchStatementJS
            switch (typeof value) {
                case "string":
                    if (value == "0")
                        return this.ZERO;
                    if (value == "")
                        throw new Error('string is no integer');
                    value = BI.C(value);
                case "number":
                    if (value === 0)
                        return this.ZERO;
                    value = BI.C(value);
                case "bigint":
                    if (!value)
                        return this.ZERO;
                    if (value < BI.UMIN)
                        throw new Error('signed value for ulong');
                    if (value > BI.UMAX)
                        throw new Error('ulong too large');
                    BI.V.setBigUint64(0, value, true);
                    return new PbULong(BI.V.getInt32(0, true), BI.V.getInt32(4, true));
            }
        else
            switch (typeof value) {
                case "string":
                    if (value == "0")
                        return this.ZERO;
                    value = value.trim();
                    if (!RE_DECIMAL_STR.test(value))
                        throw new Error('string is no integer');
                    let [minus, lo, hi] = int64fromString(value);
                    if (minus)
                        throw new Error('signed value for ulong');
                    return new PbULong(lo, hi);
                case "number":
                    if (value == 0)
                        return this.ZERO;
                    if (!Number.isSafeInteger(value))
                        throw new Error('number is no integer');
                    if (value < 0)
                        throw new Error('signed value for ulong');
                    return new PbULong(value, value / TWO_PWR_32_DBL);
            }
        throw new Error('unknown value ' + typeof value);
    }
    /**
     * Convert to decimal string.
     */
    toString() {
        return BI ? this.toBigInt().toString() : int64toString(this.lo, this.hi);
    }
    /**
     * Convert to native bigint.
     */
    toBigInt() {
        assertBi(BI);
        BI.V.setInt32(0, this.lo, true);
        BI.V.setInt32(4, this.hi, true);
        return BI.V.getBigUint64(0, true);
    }
}
/**
 * ulong 0 singleton.
 */
PbULong.ZERO = new PbULong(0, 0);
/**
 * 64-bit signed integer as two 32-bit values.
 * Converts between `string`, `number` and `bigint` representations.
 */
class PbLong extends SharedPbLong {
    /**
     * Create instance from a `string`, `number` or `bigint`.
     */
    static from(value) {
        if (BI)
            // noinspection FallThroughInSwitchStatementJS
            switch (typeof value) {
                case "string":
                    if (value == "0")
                        return this.ZERO;
                    if (value == "")
                        throw new Error('string is no integer');
                    value = BI.C(value);
                case "number":
                    if (value === 0)
                        return this.ZERO;
                    value = BI.C(value);
                case "bigint":
                    if (!value)
                        return this.ZERO;
                    if (value < BI.MIN)
                        throw new Error('signed long too small');
                    if (value > BI.MAX)
                        throw new Error('signed long too large');
                    BI.V.setBigInt64(0, value, true);
                    return new PbLong(BI.V.getInt32(0, true), BI.V.getInt32(4, true));
            }
        else
            switch (typeof value) {
                case "string":
                    if (value == "0")
                        return this.ZERO;
                    value = value.trim();
                    if (!RE_DECIMAL_STR.test(value))
                        throw new Error('string is no integer');
                    let [minus, lo, hi] = int64fromString(value);
                    if (minus) {
                        if (hi > HALF_2_PWR_32 || (hi == HALF_2_PWR_32 && lo != 0))
                            throw new Error('signed long too small');
                    }
                    else if (hi >= HALF_2_PWR_32)
                        throw new Error('signed long too large');
                    let pbl = new PbLong(lo, hi);
                    return minus ? pbl.negate() : pbl;
                case "number":
                    if (value == 0)
                        return this.ZERO;
                    if (!Number.isSafeInteger(value))
                        throw new Error('number is no integer');
                    return value > 0
                        ? new PbLong(value, value / TWO_PWR_32_DBL)
                        : new PbLong(-value, -value / TWO_PWR_32_DBL).negate();
            }
        throw new Error('unknown value ' + typeof value);
    }
    /**
     * Do we have a minus sign?
     */
    isNegative() {
        return (this.hi & HALF_2_PWR_32) !== 0;
    }
    /**
     * Negate two's complement.
     * Invert all the bits and add one to the result.
     */
    negate() {
        let hi = ~this.hi, lo = this.lo;
        if (lo)
            lo = ~lo + 1;
        else
            hi += 1;
        return new PbLong(lo, hi);
    }
    /**
     * Convert to decimal string.
     */
    toString() {
        if (BI)
            return this.toBigInt().toString();
        if (this.isNegative()) {
            let n = this.negate();
            return '-' + int64toString(n.lo, n.hi);
        }
        return int64toString(this.lo, this.hi);
    }
    /**
     * Convert to native bigint.
     */
    toBigInt() {
        assertBi(BI);
        BI.V.setInt32(0, this.lo, true);
        BI.V.setInt32(4, this.hi, true);
        return BI.V.getBigInt64(0, true);
    }
}
/**
 * long 0 singleton.
 */
PbLong.ZERO = new PbLong(0, 0);

const defaultsRead$1 = {
    readUnknownField: true,
    readerFactory: bytes => new BinaryReader(bytes),
};
/**
 * Make options for reading binary data form partial options.
 */
function binaryReadOptions(options) {
    return options ? Object.assign(Object.assign({}, defaultsRead$1), options) : defaultsRead$1;
}
class BinaryReader {
    constructor(buf, textDecoder) {
        this.varint64 = varint64read; // dirty cast for `this`
        /**
         * Read a `uint32` field, an unsigned 32 bit varint.
         */
        this.uint32 = varint32read; // dirty cast for `this` and access to protected `buf`
        this.buf = buf;
        this.len = buf.length;
        this.pos = 0;
        this.view = new DataView(buf.buffer, buf.byteOffset, buf.byteLength);
        this.textDecoder = textDecoder !== null && textDecoder !== void 0 ? textDecoder : new TextDecoder("utf-8", {
            fatal: true,
            ignoreBOM: true,
        });
    }
    /**
     * Reads a tag - field number and wire type.
     */
    tag() {
        let tag = this.uint32(), fieldNo = tag >>> 3, wireType = tag & 7;
        if (fieldNo <= 0 || wireType < 0 || wireType > 5)
            throw new Error("illegal tag: field no " + fieldNo + " wire type " + wireType);
        return [fieldNo, wireType];
    }
    /**
     * Skip one element on the wire and return the skipped data.
     * Supports WireType.StartGroup since v2.0.0-alpha.23.
     */
    skip(wireType) {
        let start = this.pos;
        // noinspection FallThroughInSwitchStatementJS
        switch (wireType) {
            case WireType.Varint:
                while (this.buf[this.pos++] & 0x80) {
                    // ignore
                }
                break;
            case WireType.Bit64:
                this.pos += 4;
            case WireType.Bit32:
                this.pos += 4;
                break;
            case WireType.LengthDelimited:
                let len = this.uint32();
                this.pos += len;
                break;
            case WireType.StartGroup:
                // From descriptor.proto: Group type is deprecated, not supported in proto3.
                // But we must still be able to parse and treat as unknown.
                let t;
                while ((t = this.tag()[1]) !== WireType.EndGroup) {
                    this.skip(t);
                }
                break;
            default:
                throw new Error("cant skip wire type " + wireType);
        }
        this.assertBounds();
        return this.buf.subarray(start, this.pos);
    }
    /**
     * Throws error if position in byte array is out of range.
     */
    assertBounds() {
        if (this.pos > this.len)
            throw new RangeError("premature EOF");
    }
    /**
     * Read a `int32` field, a signed 32 bit varint.
     */
    int32() {
        return this.uint32() | 0;
    }
    /**
     * Read a `sint32` field, a signed, zigzag-encoded 32-bit varint.
     */
    sint32() {
        let zze = this.uint32();
        // decode zigzag
        return (zze >>> 1) ^ -(zze & 1);
    }
    /**
     * Read a `int64` field, a signed 64-bit varint.
     */
    int64() {
        return new PbLong(...this.varint64());
    }
    /**
     * Read a `uint64` field, an unsigned 64-bit varint.
     */
    uint64() {
        return new PbULong(...this.varint64());
    }
    /**
     * Read a `sint64` field, a signed, zig-zag-encoded 64-bit varint.
     */
    sint64() {
        let [lo, hi] = this.varint64();
        // decode zig zag
        let s = -(lo & 1);
        lo = ((lo >>> 1 | (hi & 1) << 31) ^ s);
        hi = (hi >>> 1 ^ s);
        return new PbLong(lo, hi);
    }
    /**
     * Read a `bool` field, a variant.
     */
    bool() {
        let [lo, hi] = this.varint64();
        return lo !== 0 || hi !== 0;
    }
    /**
     * Read a `fixed32` field, an unsigned, fixed-length 32-bit integer.
     */
    fixed32() {
        return this.view.getUint32((this.pos += 4) - 4, true);
    }
    /**
     * Read a `sfixed32` field, a signed, fixed-length 32-bit integer.
     */
    sfixed32() {
        return this.view.getInt32((this.pos += 4) - 4, true);
    }
    /**
     * Read a `fixed64` field, an unsigned, fixed-length 64 bit integer.
     */
    fixed64() {
        return new PbULong(this.sfixed32(), this.sfixed32());
    }
    /**
     * Read a `fixed64` field, a signed, fixed-length 64-bit integer.
     */
    sfixed64() {
        return new PbLong(this.sfixed32(), this.sfixed32());
    }
    /**
     * Read a `float` field, 32-bit floating point number.
     */
    float() {
        return this.view.getFloat32((this.pos += 4) - 4, true);
    }
    /**
     * Read a `double` field, a 64-bit floating point number.
     */
    double() {
        return this.view.getFloat64((this.pos += 8) - 8, true);
    }
    /**
     * Read a `bytes` field, length-delimited arbitrary data.
     */
    bytes() {
        let len = this.uint32();
        let start = this.pos;
        this.pos += len;
        this.assertBounds();
        return this.buf.subarray(start, start + len);
    }
    /**
     * Read a `string` field, length-delimited data converted to UTF-8 text.
     */
    string() {
        return this.textDecoder.decode(this.bytes());
    }
}

/**
 * assert that condition is true or throw error (with message)
 */
function assert(condition, msg) {
    if (!condition) {
        throw new Error(msg);
    }
}
const FLOAT32_MAX = 3.4028234663852886e+38, FLOAT32_MIN = -34028234663852886e22, UINT32_MAX = 0xFFFFFFFF, INT32_MAX = 0X7FFFFFFF, INT32_MIN = -2147483648;
function assertInt32(arg) {
    if (typeof arg !== "number")
        throw new Error('invalid int 32: ' + typeof arg);
    if (!Number.isInteger(arg) || arg > INT32_MAX || arg < INT32_MIN)
        throw new Error('invalid int 32: ' + arg);
}
function assertUInt32(arg) {
    if (typeof arg !== "number")
        throw new Error('invalid uint 32: ' + typeof arg);
    if (!Number.isInteger(arg) || arg > UINT32_MAX || arg < 0)
        throw new Error('invalid uint 32: ' + arg);
}
function assertFloat32(arg) {
    if (typeof arg !== "number")
        throw new Error('invalid float 32: ' + typeof arg);
    if (!Number.isFinite(arg))
        return;
    if (arg > FLOAT32_MAX || arg < FLOAT32_MIN)
        throw new Error('invalid float 32: ' + arg);
}

const defaultsWrite$1 = {
    writeUnknownFields: true,
    writerFactory: () => new BinaryWriter(),
};
/**
 * Make options for writing binary data form partial options.
 */
function binaryWriteOptions(options) {
    return options ? Object.assign(Object.assign({}, defaultsWrite$1), options) : defaultsWrite$1;
}
class BinaryWriter {
    constructor(textEncoder) {
        /**
         * Previous fork states.
         */
        this.stack = [];
        this.textEncoder = textEncoder !== null && textEncoder !== void 0 ? textEncoder : new TextEncoder();
        this.chunks = [];
        this.buf = [];
    }
    /**
     * Return all bytes written and reset this writer.
     */
    finish() {
        this.chunks.push(new Uint8Array(this.buf)); // flush the buffer
        let len = 0;
        for (let i = 0; i < this.chunks.length; i++)
            len += this.chunks[i].length;
        let bytes = new Uint8Array(len);
        let offset = 0;
        for (let i = 0; i < this.chunks.length; i++) {
            bytes.set(this.chunks[i], offset);
            offset += this.chunks[i].length;
        }
        this.chunks = [];
        return bytes;
    }
    /**
     * Start a new fork for length-delimited data like a message
     * or a packed repeated field.
     *
     * Must be joined later with `join()`.
     */
    fork() {
        this.stack.push({ chunks: this.chunks, buf: this.buf });
        this.chunks = [];
        this.buf = [];
        return this;
    }
    /**
     * Join the last fork. Write its length and bytes, then
     * return to the previous state.
     */
    join() {
        // get chunk of fork
        let chunk = this.finish();
        // restore previous state
        let prev = this.stack.pop();
        if (!prev)
            throw new Error('invalid state, fork stack empty');
        this.chunks = prev.chunks;
        this.buf = prev.buf;
        // write length of chunk as varint
        this.uint32(chunk.byteLength);
        return this.raw(chunk);
    }
    /**
     * Writes a tag (field number and wire type).
     *
     * Equivalent to `uint32( (fieldNo << 3 | type) >>> 0 )`.
     *
     * Generated code should compute the tag ahead of time and call `uint32()`.
     */
    tag(fieldNo, type) {
        return this.uint32((fieldNo << 3 | type) >>> 0);
    }
    /**
     * Write a chunk of raw bytes.
     */
    raw(chunk) {
        if (this.buf.length) {
            this.chunks.push(new Uint8Array(this.buf));
            this.buf = [];
        }
        this.chunks.push(chunk);
        return this;
    }
    /**
     * Write a `uint32` value, an unsigned 32 bit varint.
     */
    uint32(value) {
        assertUInt32(value);
        // write value as varint 32, inlined for speed
        while (value > 0x7f) {
            this.buf.push((value & 0x7f) | 0x80);
            value = value >>> 7;
        }
        this.buf.push(value);
        return this;
    }
    /**
     * Write a `int32` value, a signed 32 bit varint.
     */
    int32(value) {
        assertInt32(value);
        varint32write(value, this.buf);
        return this;
    }
    /**
     * Write a `bool` value, a variant.
     */
    bool(value) {
        this.buf.push(value ? 1 : 0);
        return this;
    }
    /**
     * Write a `bytes` value, length-delimited arbitrary data.
     */
    bytes(value) {
        this.uint32(value.byteLength); // write length of chunk as varint
        return this.raw(value);
    }
    /**
     * Write a `string` value, length-delimited data converted to UTF-8 text.
     */
    string(value) {
        let chunk = this.textEncoder.encode(value);
        this.uint32(chunk.byteLength); // write length of chunk as varint
        return this.raw(chunk);
    }
    /**
     * Write a `float` value, 32-bit floating point number.
     */
    float(value) {
        assertFloat32(value);
        let chunk = new Uint8Array(4);
        new DataView(chunk.buffer).setFloat32(0, value, true);
        return this.raw(chunk);
    }
    /**
     * Write a `double` value, a 64-bit floating point number.
     */
    double(value) {
        let chunk = new Uint8Array(8);
        new DataView(chunk.buffer).setFloat64(0, value, true);
        return this.raw(chunk);
    }
    /**
     * Write a `fixed32` value, an unsigned, fixed-length 32-bit integer.
     */
    fixed32(value) {
        assertUInt32(value);
        let chunk = new Uint8Array(4);
        new DataView(chunk.buffer).setUint32(0, value, true);
        return this.raw(chunk);
    }
    /**
     * Write a `sfixed32` value, a signed, fixed-length 32-bit integer.
     */
    sfixed32(value) {
        assertInt32(value);
        let chunk = new Uint8Array(4);
        new DataView(chunk.buffer).setInt32(0, value, true);
        return this.raw(chunk);
    }
    /**
     * Write a `sint32` value, a signed, zigzag-encoded 32-bit varint.
     */
    sint32(value) {
        assertInt32(value);
        // zigzag encode
        value = ((value << 1) ^ (value >> 31)) >>> 0;
        varint32write(value, this.buf);
        return this;
    }
    /**
     * Write a `fixed64` value, a signed, fixed-length 64-bit integer.
     */
    sfixed64(value) {
        let chunk = new Uint8Array(8);
        let view = new DataView(chunk.buffer);
        let long = PbLong.from(value);
        view.setInt32(0, long.lo, true);
        view.setInt32(4, long.hi, true);
        return this.raw(chunk);
    }
    /**
     * Write a `fixed64` value, an unsigned, fixed-length 64 bit integer.
     */
    fixed64(value) {
        let chunk = new Uint8Array(8);
        let view = new DataView(chunk.buffer);
        let long = PbULong.from(value);
        view.setInt32(0, long.lo, true);
        view.setInt32(4, long.hi, true);
        return this.raw(chunk);
    }
    /**
     * Write a `int64` value, a signed 64-bit varint.
     */
    int64(value) {
        let long = PbLong.from(value);
        varint64write(long.lo, long.hi, this.buf);
        return this;
    }
    /**
     * Write a `sint64` value, a signed, zig-zag-encoded 64-bit varint.
     */
    sint64(value) {
        let long = PbLong.from(value), 
        // zigzag encode
        sign = long.hi >> 31, lo = (long.lo << 1) ^ sign, hi = ((long.hi << 1) | (long.lo >>> 31)) ^ sign;
        varint64write(lo, hi, this.buf);
        return this;
    }
    /**
     * Write a `uint64` value, an unsigned 64-bit varint.
     */
    uint64(value) {
        let long = PbULong.from(value);
        varint64write(long.lo, long.hi, this.buf);
        return this;
    }
}

const defaultsWrite = {
    emitDefaultValues: false,
    enumAsInteger: false,
    useProtoFieldName: false,
    prettySpaces: 0,
}, defaultsRead = {
    ignoreUnknownFields: false,
};
/**
 * Make options for reading JSON data from partial options.
 */
function jsonReadOptions(options) {
    return options ? Object.assign(Object.assign({}, defaultsRead), options) : defaultsRead;
}
/**
 * Make options for writing JSON data from partial options.
 */
function jsonWriteOptions(options) {
    return options ? Object.assign(Object.assign({}, defaultsWrite), options) : defaultsWrite;
}

/**
 * The symbol used as a key on message objects to store the message type.
 *
 * Note that this is an experimental feature - it is here to stay, but
 * implementation details may change without notice.
 */
const MESSAGE_TYPE = Symbol.for("protobuf-ts/message-type");

/**
 * Converts snake_case to lowerCamelCase.
 *
 * Should behave like protoc:
 * https://github.com/protocolbuffers/protobuf/blob/e8ae137c96444ea313485ed1118c5e43b2099cf1/src/google/protobuf/compiler/java/java_helpers.cc#L118
 */
function lowerCamelCase(snakeCase) {
    let capNext = false;
    const sb = [];
    for (let i = 0; i < snakeCase.length; i++) {
        let next = snakeCase.charAt(i);
        if (next == '_') {
            capNext = true;
        }
        else if (/\d/.test(next)) {
            sb.push(next);
            capNext = true;
        }
        else if (capNext) {
            sb.push(next.toUpperCase());
            capNext = false;
        }
        else if (i == 0) {
            sb.push(next.toLowerCase());
        }
        else {
            sb.push(next);
        }
    }
    return sb.join('');
}

/**
 * Scalar value types. This is a subset of field types declared by protobuf
 * enum google.protobuf.FieldDescriptorProto.Type The types GROUP and MESSAGE
 * are omitted, but the numerical values are identical.
 */
var ScalarType;
(function (ScalarType) {
    // 0 is reserved for errors.
    // Order is weird for historical reasons.
    ScalarType[ScalarType["DOUBLE"] = 1] = "DOUBLE";
    ScalarType[ScalarType["FLOAT"] = 2] = "FLOAT";
    // Not ZigZag encoded.  Negative numbers take 10 bytes.  Use TYPE_SINT64 if
    // negative values are likely.
    ScalarType[ScalarType["INT64"] = 3] = "INT64";
    ScalarType[ScalarType["UINT64"] = 4] = "UINT64";
    // Not ZigZag encoded.  Negative numbers take 10 bytes.  Use TYPE_SINT32 if
    // negative values are likely.
    ScalarType[ScalarType["INT32"] = 5] = "INT32";
    ScalarType[ScalarType["FIXED64"] = 6] = "FIXED64";
    ScalarType[ScalarType["FIXED32"] = 7] = "FIXED32";
    ScalarType[ScalarType["BOOL"] = 8] = "BOOL";
    ScalarType[ScalarType["STRING"] = 9] = "STRING";
    // Tag-delimited aggregate.
    // Group type is deprecated and not supported in proto3. However, Proto3
    // implementations should still be able to parse the group wire format and
    // treat group fields as unknown fields.
    // TYPE_GROUP = 10,
    // TYPE_MESSAGE = 11,  // Length-delimited aggregate.
    // New in version 2.
    ScalarType[ScalarType["BYTES"] = 12] = "BYTES";
    ScalarType[ScalarType["UINT32"] = 13] = "UINT32";
    // TYPE_ENUM = 14,
    ScalarType[ScalarType["SFIXED32"] = 15] = "SFIXED32";
    ScalarType[ScalarType["SFIXED64"] = 16] = "SFIXED64";
    ScalarType[ScalarType["SINT32"] = 17] = "SINT32";
    ScalarType[ScalarType["SINT64"] = 18] = "SINT64";
})(ScalarType || (ScalarType = {}));
/**
 * JavaScript representation of 64 bit integral types. Equivalent to the
 * field option "jstype".
 *
 * By default, protobuf-ts represents 64 bit types as `bigint`.
 *
 * You can change the default behaviour by enabling the plugin parameter
 * `long_type_string`, which will represent 64 bit types as `string`.
 *
 * Alternatively, you can change the behaviour for individual fields
 * with the field option "jstype":
 *
 * ```protobuf
 * uint64 my_field = 1 [jstype = JS_STRING];
 * uint64 other_field = 2 [jstype = JS_NUMBER];
 * ```
 */
var LongType;
(function (LongType) {
    /**
     * Use JavaScript `bigint`.
     *
     * Field option `[jstype = JS_NORMAL]`.
     */
    LongType[LongType["BIGINT"] = 0] = "BIGINT";
    /**
     * Use JavaScript `string`.
     *
     * Field option `[jstype = JS_STRING]`.
     */
    LongType[LongType["STRING"] = 1] = "STRING";
    /**
     * Use JavaScript `number`.
     *
     * Large values will loose precision.
     *
     * Field option `[jstype = JS_NUMBER]`.
     */
    LongType[LongType["NUMBER"] = 2] = "NUMBER";
})(LongType || (LongType = {}));
/**
 * Protobuf 2.1.0 introduced packed repeated fields.
 * Setting the field option `[packed = true]` enables packing.
 *
 * In proto3, all repeated fields are packed by default.
 * Setting the field option `[packed = false]` disables packing.
 *
 * Packed repeated fields are encoded with a single tag,
 * then a length-delimiter, then the element values.
 *
 * Unpacked repeated fields are encoded with a tag and
 * value for each element.
 *
 * `bytes` and `string` cannot be packed.
 */
var RepeatType;
(function (RepeatType) {
    /**
     * The field is not repeated.
     */
    RepeatType[RepeatType["NO"] = 0] = "NO";
    /**
     * The field is repeated and should be packed.
     * Invalid for `bytes` and `string`, they cannot be packed.
     */
    RepeatType[RepeatType["PACKED"] = 1] = "PACKED";
    /**
     * The field is repeated but should not be packed.
     * The only valid repeat type for repeated `bytes` and `string`.
     */
    RepeatType[RepeatType["UNPACKED"] = 2] = "UNPACKED";
})(RepeatType || (RepeatType = {}));
/**
 * Turns PartialFieldInfo into FieldInfo.
 */
function normalizeFieldInfo(field) {
    var _a, _b, _c, _d;
    field.localName = (_a = field.localName) !== null && _a !== void 0 ? _a : lowerCamelCase(field.name);
    field.jsonName = (_b = field.jsonName) !== null && _b !== void 0 ? _b : lowerCamelCase(field.name);
    field.repeat = (_c = field.repeat) !== null && _c !== void 0 ? _c : RepeatType.NO;
    field.opt = (_d = field.opt) !== null && _d !== void 0 ? _d : (field.repeat ? false : field.oneof ? false : field.kind == "message");
    return field;
}

/**
 * Is the given value a valid oneof group?
 *
 * We represent protobuf `oneof` as algebraic data types (ADT) in generated
 * code. But when working with messages of unknown type, the ADT does not
 * help us.
 *
 * This type guard checks if the given object adheres to the ADT rules, which
 * are as follows:
 *
 * 1) Must be an object.
 *
 * 2) Must have a "oneofKind" discriminator property.
 *
 * 3) If "oneofKind" is `undefined`, no member field is selected. The object
 * must not have any other properties.
 *
 * 4) If "oneofKind" is a `string`, the member field with this name is
 * selected.
 *
 * 5) If a member field is selected, the object must have a second property
 * with this name. The property must not be `undefined`.
 *
 * 6) No extra properties are allowed. The object has either one property
 * (no selection) or two properties (selection).
 *
 */
function isOneofGroup(any) {
    if (typeof any != 'object' || any === null || !any.hasOwnProperty('oneofKind')) {
        return false;
    }
    switch (typeof any.oneofKind) {
        case "string":
            if (any[any.oneofKind] === undefined)
                return false;
            return Object.keys(any).length == 2;
        case "undefined":
            return Object.keys(any).length == 1;
        default:
            return false;
    }
}

// noinspection JSMethodCanBeStatic
class ReflectionTypeCheck {
    constructor(info) {
        var _a;
        this.fields = (_a = info.fields) !== null && _a !== void 0 ? _a : [];
    }
    prepare() {
        if (this.data)
            return;
        const req = [], known = [], oneofs = [];
        for (let field of this.fields) {
            if (field.oneof) {
                if (!oneofs.includes(field.oneof)) {
                    oneofs.push(field.oneof);
                    req.push(field.oneof);
                    known.push(field.oneof);
                }
            }
            else {
                known.push(field.localName);
                switch (field.kind) {
                    case "scalar":
                    case "enum":
                        if (!field.opt || field.repeat)
                            req.push(field.localName);
                        break;
                    case "message":
                        if (field.repeat)
                            req.push(field.localName);
                        break;
                    case "map":
                        req.push(field.localName);
                        break;
                }
            }
        }
        this.data = { req, known, oneofs: Object.values(oneofs) };
    }
    /**
     * Is the argument a valid message as specified by the
     * reflection information?
     *
     * Checks all field types recursively. The `depth`
     * specifies how deep into the structure the check will be.
     *
     * With a depth of 0, only the presence of fields
     * is checked.
     *
     * With a depth of 1 or more, the field types are checked.
     *
     * With a depth of 2 or more, the members of map, repeated
     * and message fields are checked.
     *
     * Message fields will be checked recursively with depth - 1.
     *
     * The number of map entries / repeated values being checked
     * is < depth.
     */
    is(message, depth, allowExcessProperties = false) {
        if (depth < 0)
            return true;
        if (message === null || message === undefined || typeof message != 'object')
            return false;
        this.prepare();
        let keys = Object.keys(message), data = this.data;
        // if a required field is missing in arg, this cannot be a T
        if (keys.length < data.req.length || data.req.some(n => !keys.includes(n)))
            return false;
        if (!allowExcessProperties) {
            // if the arg contains a key we dont know, this is not a literal T
            if (keys.some(k => !data.known.includes(k)))
                return false;
        }
        // "With a depth of 0, only the presence and absence of fields is checked."
        // "With a depth of 1 or more, the field types are checked."
        if (depth < 1) {
            return true;
        }
        // check oneof group
        for (const name of data.oneofs) {
            const group = message[name];
            if (!isOneofGroup(group))
                return false;
            if (group.oneofKind === undefined)
                continue;
            const field = this.fields.find(f => f.localName === group.oneofKind);
            if (!field)
                return false; // we found no field, but have a kind, something is wrong
            if (!this.field(group[group.oneofKind], field, allowExcessProperties, depth))
                return false;
        }
        // check types
        for (const field of this.fields) {
            if (field.oneof !== undefined)
                continue;
            if (!this.field(message[field.localName], field, allowExcessProperties, depth))
                return false;
        }
        return true;
    }
    field(arg, field, allowExcessProperties, depth) {
        let repeated = field.repeat;
        switch (field.kind) {
            case "scalar":
                if (arg === undefined)
                    return field.opt;
                if (repeated)
                    return this.scalars(arg, field.T, depth, field.L);
                return this.scalar(arg, field.T, field.L);
            case "enum":
                if (arg === undefined)
                    return field.opt;
                if (repeated)
                    return this.scalars(arg, ScalarType.INT32, depth);
                return this.scalar(arg, ScalarType.INT32);
            case "message":
                if (arg === undefined)
                    return true;
                if (repeated)
                    return this.messages(arg, field.T(), allowExcessProperties, depth);
                return this.message(arg, field.T(), allowExcessProperties, depth);
            case "map":
                if (typeof arg != 'object' || arg === null)
                    return false;
                if (depth < 2)
                    return true;
                if (!this.mapKeys(arg, field.K, depth))
                    return false;
                switch (field.V.kind) {
                    case "scalar":
                        return this.scalars(Object.values(arg), field.V.T, depth, field.V.L);
                    case "enum":
                        return this.scalars(Object.values(arg), ScalarType.INT32, depth);
                    case "message":
                        return this.messages(Object.values(arg), field.V.T(), allowExcessProperties, depth);
                }
                break;
        }
        return true;
    }
    message(arg, type, allowExcessProperties, depth) {
        if (allowExcessProperties) {
            return type.isAssignable(arg, depth);
        }
        return type.is(arg, depth);
    }
    messages(arg, type, allowExcessProperties, depth) {
        if (!Array.isArray(arg))
            return false;
        if (depth < 2)
            return true;
        if (allowExcessProperties) {
            for (let i = 0; i < arg.length && i < depth; i++)
                if (!type.isAssignable(arg[i], depth - 1))
                    return false;
        }
        else {
            for (let i = 0; i < arg.length && i < depth; i++)
                if (!type.is(arg[i], depth - 1))
                    return false;
        }
        return true;
    }
    scalar(arg, type, longType) {
        let argType = typeof arg;
        switch (type) {
            case ScalarType.UINT64:
            case ScalarType.FIXED64:
            case ScalarType.INT64:
            case ScalarType.SFIXED64:
            case ScalarType.SINT64:
                switch (longType) {
                    case LongType.BIGINT:
                        return argType == "bigint";
                    case LongType.NUMBER:
                        return argType == "number" && !isNaN(arg);
                    default:
                        return argType == "string";
                }
            case ScalarType.BOOL:
                return argType == 'boolean';
            case ScalarType.STRING:
                return argType == 'string';
            case ScalarType.BYTES:
                return arg instanceof Uint8Array;
            case ScalarType.DOUBLE:
            case ScalarType.FLOAT:
                return argType == 'number' && !isNaN(arg);
            default:
                // case ScalarType.UINT32:
                // case ScalarType.FIXED32:
                // case ScalarType.INT32:
                // case ScalarType.SINT32:
                // case ScalarType.SFIXED32:
                return argType == 'number' && Number.isInteger(arg);
        }
    }
    scalars(arg, type, depth, longType) {
        if (!Array.isArray(arg))
            return false;
        if (depth < 2)
            return true;
        if (Array.isArray(arg))
            for (let i = 0; i < arg.length && i < depth; i++)
                if (!this.scalar(arg[i], type, longType))
                    return false;
        return true;
    }
    mapKeys(map, type, depth) {
        let keys = Object.keys(map);
        switch (type) {
            case ScalarType.INT32:
            case ScalarType.FIXED32:
            case ScalarType.SFIXED32:
            case ScalarType.SINT32:
            case ScalarType.UINT32:
                return this.scalars(keys.slice(0, depth).map(k => parseInt(k)), type, depth);
            case ScalarType.BOOL:
                return this.scalars(keys.slice(0, depth).map(k => k == 'true' ? true : k == 'false' ? false : k), type, depth);
            default:
                return this.scalars(keys, type, depth, LongType.STRING);
        }
    }
}

/**
 * Utility method to convert a PbLong or PbUlong to a JavaScript
 * representation during runtime.
 *
 * Works with generated field information, `undefined` is equivalent
 * to `STRING`.
 */
function reflectionLongConvert(long, type) {
    switch (type) {
        case LongType.BIGINT:
            return long.toBigInt();
        case LongType.NUMBER:
            return long.toNumber();
        default:
            // case undefined:
            // case LongType.STRING:
            return long.toString();
    }
}

/**
 * Reads proto3 messages in canonical JSON format using reflection information.
 *
 * https://developers.google.com/protocol-buffers/docs/proto3#json
 */
class ReflectionJsonReader {
    constructor(info) {
        this.info = info;
    }
    prepare() {
        var _a;
        if (this.fMap === undefined) {
            this.fMap = {};
            const fieldsInput = (_a = this.info.fields) !== null && _a !== void 0 ? _a : [];
            for (const field of fieldsInput) {
                this.fMap[field.name] = field;
                this.fMap[field.jsonName] = field;
                this.fMap[field.localName] = field;
            }
        }
    }
    // Cannot parse JSON <type of jsonValue> for <type name>#<fieldName>.
    assert(condition, fieldName, jsonValue) {
        if (!condition) {
            let what = typeofJsonValue(jsonValue);
            if (what == "number" || what == "boolean")
                what = jsonValue.toString();
            throw new Error(`Cannot parse JSON ${what} for ${this.info.typeName}#${fieldName}`);
        }
    }
    /**
     * Reads a message from canonical JSON format into the target message.
     *
     * Repeated fields are appended. Map entries are added, overwriting
     * existing keys.
     *
     * If a message field is already present, it will be merged with the
     * new data.
     */
    read(input, message, options) {
        this.prepare();
        const oneofsHandled = [];
        for (const [jsonKey, jsonValue] of Object.entries(input)) {
            const field = this.fMap[jsonKey];
            if (!field) {
                if (!options.ignoreUnknownFields)
                    throw new Error(`Found unknown field while reading ${this.info.typeName} from JSON format. JSON key: ${jsonKey}`);
                continue;
            }
            const localName = field.localName;
            // handle oneof ADT
            let target; // this will be the target for the field value, whether it is member of a oneof or not
            if (field.oneof) {
                if (jsonValue === null && (field.kind !== 'enum' || field.T()[0] !== 'google.protobuf.NullValue')) {
                    continue;
                }
                // since json objects are unordered by specification, it is not possible to take the last of multiple oneofs
                if (oneofsHandled.includes(field.oneof))
                    throw new Error(`Multiple members of the oneof group "${field.oneof}" of ${this.info.typeName} are present in JSON.`);
                oneofsHandled.push(field.oneof);
                target = message[field.oneof] = {
                    oneofKind: localName
                };
            }
            else {
                target = message;
            }
            // we have handled oneof above. we just have read the value into `target`.
            if (field.kind == 'map') {
                if (jsonValue === null) {
                    continue;
                }
                // check input
                this.assert(isJsonObject(jsonValue), field.name, jsonValue);
                // our target to put map entries into
                const fieldObj = target[localName];
                // read entries
                for (const [jsonObjKey, jsonObjValue] of Object.entries(jsonValue)) {
                    this.assert(jsonObjValue !== null, field.name + " map value", null);
                    // read value
                    let val;
                    switch (field.V.kind) {
                        case "message":
                            val = field.V.T().internalJsonRead(jsonObjValue, options);
                            break;
                        case "enum":
                            val = this.enum(field.V.T(), jsonObjValue, field.name, options.ignoreUnknownFields);
                            if (val === false)
                                continue;
                            break;
                        case "scalar":
                            val = this.scalar(jsonObjValue, field.V.T, field.V.L, field.name);
                            break;
                    }
                    this.assert(val !== undefined, field.name + " map value", jsonObjValue);
                    // read key
                    let key = jsonObjKey;
                    if (field.K == ScalarType.BOOL)
                        key = key == "true" ? true : key == "false" ? false : key;
                    key = this.scalar(key, field.K, LongType.STRING, field.name).toString();
                    fieldObj[key] = val;
                }
            }
            else if (field.repeat) {
                if (jsonValue === null)
                    continue;
                // check input
                this.assert(Array.isArray(jsonValue), field.name, jsonValue);
                // our target to put array entries into
                const fieldArr = target[localName];
                // read array entries
                for (const jsonItem of jsonValue) {
                    this.assert(jsonItem !== null, field.name, null);
                    let val;
                    switch (field.kind) {
                        case "message":
                            val = field.T().internalJsonRead(jsonItem, options);
                            break;
                        case "enum":
                            val = this.enum(field.T(), jsonItem, field.name, options.ignoreUnknownFields);
                            if (val === false)
                                continue;
                            break;
                        case "scalar":
                            val = this.scalar(jsonItem, field.T, field.L, field.name);
                            break;
                    }
                    this.assert(val !== undefined, field.name, jsonValue);
                    fieldArr.push(val);
                }
            }
            else {
                switch (field.kind) {
                    case "message":
                        if (jsonValue === null && field.T().typeName != 'google.protobuf.Value') {
                            this.assert(field.oneof === undefined, field.name + " (oneof member)", null);
                            continue;
                        }
                        target[localName] = field.T().internalJsonRead(jsonValue, options, target[localName]);
                        break;
                    case "enum":
                        if (jsonValue === null)
                            continue;
                        let val = this.enum(field.T(), jsonValue, field.name, options.ignoreUnknownFields);
                        if (val === false)
                            continue;
                        target[localName] = val;
                        break;
                    case "scalar":
                        if (jsonValue === null)
                            continue;
                        target[localName] = this.scalar(jsonValue, field.T, field.L, field.name);
                        break;
                }
            }
        }
    }
    /**
     * Returns `false` for unrecognized string representations.
     *
     * google.protobuf.NullValue accepts only JSON `null` (or the old `"NULL_VALUE"`).
     */
    enum(type, json, fieldName, ignoreUnknownFields) {
        if (type[0] == 'google.protobuf.NullValue')
            assert(json === null || json === "NULL_VALUE", `Unable to parse field ${this.info.typeName}#${fieldName}, enum ${type[0]} only accepts null.`);
        if (json === null)
            // we require 0 to be default value for all enums
            return 0;
        switch (typeof json) {
            case "number":
                assert(Number.isInteger(json), `Unable to parse field ${this.info.typeName}#${fieldName}, enum can only be integral number, got ${json}.`);
                return json;
            case "string":
                let localEnumName = json;
                if (type[2] && json.substring(0, type[2].length) === type[2])
                    // lookup without the shared prefix
                    localEnumName = json.substring(type[2].length);
                let enumNumber = type[1][localEnumName];
                if (typeof enumNumber === 'undefined' && ignoreUnknownFields) {
                    return false;
                }
                assert(typeof enumNumber == "number", `Unable to parse field ${this.info.typeName}#${fieldName}, enum ${type[0]} has no value for "${json}".`);
                return enumNumber;
        }
        assert(false, `Unable to parse field ${this.info.typeName}#${fieldName}, cannot parse enum value from ${typeof json}".`);
    }
    scalar(json, type, longType, fieldName) {
        let e;
        try {
            switch (type) {
                // float, double: JSON value will be a number or one of the special string values "NaN", "Infinity", and "-Infinity".
                // Either numbers or strings are accepted. Exponent notation is also accepted.
                case ScalarType.DOUBLE:
                case ScalarType.FLOAT:
                    if (json === null)
                        return .0;
                    if (json === "NaN")
                        return Number.NaN;
                    if (json === "Infinity")
                        return Number.POSITIVE_INFINITY;
                    if (json === "-Infinity")
                        return Number.NEGATIVE_INFINITY;
                    if (json === "") {
                        e = "empty string";
                        break;
                    }
                    if (typeof json == "string" && json.trim().length !== json.length) {
                        e = "extra whitespace";
                        break;
                    }
                    if (typeof json != "string" && typeof json != "number") {
                        break;
                    }
                    let float = Number(json);
                    if (Number.isNaN(float)) {
                        e = "not a number";
                        break;
                    }
                    if (!Number.isFinite(float)) {
                        // infinity and -infinity are handled by string representation above, so this is an error
                        e = "too large or small";
                        break;
                    }
                    if (type == ScalarType.FLOAT)
                        assertFloat32(float);
                    return float;
                // int32, fixed32, uint32: JSON value will be a decimal number. Either numbers or strings are accepted.
                case ScalarType.INT32:
                case ScalarType.FIXED32:
                case ScalarType.SFIXED32:
                case ScalarType.SINT32:
                case ScalarType.UINT32:
                    if (json === null)
                        return 0;
                    let int32;
                    if (typeof json == "number")
                        int32 = json;
                    else if (json === "")
                        e = "empty string";
                    else if (typeof json == "string") {
                        if (json.trim().length !== json.length)
                            e = "extra whitespace";
                        else
                            int32 = Number(json);
                    }
                    if (int32 === undefined)
                        break;
                    if (type == ScalarType.UINT32)
                        assertUInt32(int32);
                    else
                        assertInt32(int32);
                    return int32;
                // int64, fixed64, uint64: JSON value will be a decimal string. Either numbers or strings are accepted.
                case ScalarType.INT64:
                case ScalarType.SFIXED64:
                case ScalarType.SINT64:
                    if (json === null)
                        return reflectionLongConvert(PbLong.ZERO, longType);
                    if (typeof json != "number" && typeof json != "string")
                        break;
                    return reflectionLongConvert(PbLong.from(json), longType);
                case ScalarType.FIXED64:
                case ScalarType.UINT64:
                    if (json === null)
                        return reflectionLongConvert(PbULong.ZERO, longType);
                    if (typeof json != "number" && typeof json != "string")
                        break;
                    return reflectionLongConvert(PbULong.from(json), longType);
                // bool:
                case ScalarType.BOOL:
                    if (json === null)
                        return false;
                    if (typeof json !== "boolean")
                        break;
                    return json;
                // string:
                case ScalarType.STRING:
                    if (json === null)
                        return "";
                    if (typeof json !== "string") {
                        e = "extra whitespace";
                        break;
                    }
                    try {
                        encodeURIComponent(json);
                    }
                    catch (e) {
                        e = "invalid UTF8";
                        break;
                    }
                    return json;
                // bytes: JSON value will be the data encoded as a string using standard base64 encoding with paddings.
                // Either standard or URL-safe base64 encoding with/without paddings are accepted.
                case ScalarType.BYTES:
                    if (json === null || json === "")
                        return new Uint8Array(0);
                    if (typeof json !== 'string')
                        break;
                    return base64decode(json);
            }
        }
        catch (error) {
            e = error.message;
        }
        this.assert(false, fieldName + (e ? " - " + e : ""), json);
    }
}

/**
 * Writes proto3 messages in canonical JSON format using reflection
 * information.
 *
 * https://developers.google.com/protocol-buffers/docs/proto3#json
 */
class ReflectionJsonWriter {
    constructor(info) {
        var _a;
        this.fields = (_a = info.fields) !== null && _a !== void 0 ? _a : [];
    }
    /**
     * Converts the message to a JSON object, based on the field descriptors.
     */
    write(message, options) {
        const json = {}, source = message;
        for (const field of this.fields) {
            // field is not part of a oneof, simply write as is
            if (!field.oneof) {
                let jsonValue = this.field(field, source[field.localName], options);
                if (jsonValue !== undefined)
                    json[options.useProtoFieldName ? field.name : field.jsonName] = jsonValue;
                continue;
            }
            // field is part of a oneof
            const group = source[field.oneof];
            if (group.oneofKind !== field.localName)
                continue; // not selected, skip
            const opt = field.kind == 'scalar' || field.kind == 'enum'
                ? Object.assign(Object.assign({}, options), { emitDefaultValues: true }) : options;
            let jsonValue = this.field(field, group[field.localName], opt);
            assert(jsonValue !== undefined);
            json[options.useProtoFieldName ? field.name : field.jsonName] = jsonValue;
        }
        return json;
    }
    field(field, value, options) {
        let jsonValue = undefined;
        if (field.kind == 'map') {
            assert(typeof value == "object" && value !== null);
            const jsonObj = {};
            switch (field.V.kind) {
                case "scalar":
                    for (const [entryKey, entryValue] of Object.entries(value)) {
                        const val = this.scalar(field.V.T, entryValue, field.name, false, true);
                        assert(val !== undefined);
                        jsonObj[entryKey.toString()] = val; // JSON standard allows only (double quoted) string as property key
                    }
                    break;
                case "message":
                    const messageType = field.V.T();
                    for (const [entryKey, entryValue] of Object.entries(value)) {
                        const val = this.message(messageType, entryValue, field.name, options);
                        assert(val !== undefined);
                        jsonObj[entryKey.toString()] = val; // JSON standard allows only (double quoted) string as property key
                    }
                    break;
                case "enum":
                    const enumInfo = field.V.T();
                    for (const [entryKey, entryValue] of Object.entries(value)) {
                        assert(entryValue === undefined || typeof entryValue == 'number');
                        const val = this.enum(enumInfo, entryValue, field.name, false, true, options.enumAsInteger);
                        assert(val !== undefined);
                        jsonObj[entryKey.toString()] = val; // JSON standard allows only (double quoted) string as property key
                    }
                    break;
            }
            if (options.emitDefaultValues || Object.keys(jsonObj).length > 0)
                jsonValue = jsonObj;
        }
        else if (field.repeat) {
            assert(Array.isArray(value));
            const jsonArr = [];
            switch (field.kind) {
                case "scalar":
                    for (let i = 0; i < value.length; i++) {
                        const val = this.scalar(field.T, value[i], field.name, field.opt, true);
                        assert(val !== undefined);
                        jsonArr.push(val);
                    }
                    break;
                case "enum":
                    const enumInfo = field.T();
                    for (let i = 0; i < value.length; i++) {
                        assert(value[i] === undefined || typeof value[i] == 'number');
                        const val = this.enum(enumInfo, value[i], field.name, field.opt, true, options.enumAsInteger);
                        assert(val !== undefined);
                        jsonArr.push(val);
                    }
                    break;
                case "message":
                    const messageType = field.T();
                    for (let i = 0; i < value.length; i++) {
                        const val = this.message(messageType, value[i], field.name, options);
                        assert(val !== undefined);
                        jsonArr.push(val);
                    }
                    break;
            }
            // add converted array to json output
            if (options.emitDefaultValues || jsonArr.length > 0 || options.emitDefaultValues)
                jsonValue = jsonArr;
        }
        else {
            switch (field.kind) {
                case "scalar":
                    jsonValue = this.scalar(field.T, value, field.name, field.opt, options.emitDefaultValues);
                    break;
                case "enum":
                    jsonValue = this.enum(field.T(), value, field.name, field.opt, options.emitDefaultValues, options.enumAsInteger);
                    break;
                case "message":
                    jsonValue = this.message(field.T(), value, field.name, options);
                    break;
            }
        }
        return jsonValue;
    }
    /**
     * Returns `null` as the default for google.protobuf.NullValue.
     */
    enum(type, value, fieldName, optional, emitDefaultValues, enumAsInteger) {
        if (type[0] == 'google.protobuf.NullValue')
            return !emitDefaultValues && !optional ? undefined : null;
        if (value === undefined) {
            assert(optional);
            return undefined;
        }
        if (value === 0 && !emitDefaultValues && !optional)
            // we require 0 to be default value for all enums
            return undefined;
        assert(typeof value == 'number');
        assert(Number.isInteger(value));
        if (enumAsInteger || !type[1].hasOwnProperty(value))
            // if we don't now the enum value, just return the number
            return value;
        if (type[2])
            // restore the dropped prefix
            return type[2] + type[1][value];
        return type[1][value];
    }
    message(type, value, fieldName, options) {
        if (value === undefined)
            return options.emitDefaultValues ? null : undefined;
        return type.internalJsonWrite(value, options);
    }
    scalar(type, value, fieldName, optional, emitDefaultValues) {
        if (value === undefined) {
            assert(optional);
            return undefined;
        }
        const ed = emitDefaultValues || optional;
        // noinspection FallThroughInSwitchStatementJS
        switch (type) {
            // int32, fixed32, uint32: JSON value will be a decimal number. Either numbers or strings are accepted.
            case ScalarType.INT32:
            case ScalarType.SFIXED32:
            case ScalarType.SINT32:
                if (value === 0)
                    return ed ? 0 : undefined;
                assertInt32(value);
                return value;
            case ScalarType.FIXED32:
            case ScalarType.UINT32:
                if (value === 0)
                    return ed ? 0 : undefined;
                assertUInt32(value);
                return value;
            // float, double: JSON value will be a number or one of the special string values "NaN", "Infinity", and "-Infinity".
            // Either numbers or strings are accepted. Exponent notation is also accepted.
            case ScalarType.FLOAT:
                assertFloat32(value);
            case ScalarType.DOUBLE:
                if (value === 0)
                    return ed ? 0 : undefined;
                assert(typeof value == 'number');
                if (Number.isNaN(value))
                    return 'NaN';
                if (value === Number.POSITIVE_INFINITY)
                    return 'Infinity';
                if (value === Number.NEGATIVE_INFINITY)
                    return '-Infinity';
                return value;
            // string:
            case ScalarType.STRING:
                if (value === "")
                    return ed ? '' : undefined;
                assert(typeof value == 'string');
                return value;
            // bool:
            case ScalarType.BOOL:
                if (value === false)
                    return ed ? false : undefined;
                assert(typeof value == 'boolean');
                return value;
            // JSON value will be a decimal string. Either numbers or strings are accepted.
            case ScalarType.UINT64:
            case ScalarType.FIXED64:
                assert(typeof value == 'number' || typeof value == 'string' || typeof value == 'bigint');
                let ulong = PbULong.from(value);
                if (ulong.isZero() && !ed)
                    return undefined;
                return ulong.toString();
            // JSON value will be a decimal string. Either numbers or strings are accepted.
            case ScalarType.INT64:
            case ScalarType.SFIXED64:
            case ScalarType.SINT64:
                assert(typeof value == 'number' || typeof value == 'string' || typeof value == 'bigint');
                let long = PbLong.from(value);
                if (long.isZero() && !ed)
                    return undefined;
                return long.toString();
            // bytes: JSON value will be the data encoded as a string using standard base64 encoding with paddings.
            // Either standard or URL-safe base64 encoding with/without paddings are accepted.
            case ScalarType.BYTES:
                assert(value instanceof Uint8Array);
                if (!value.byteLength)
                    return ed ? "" : undefined;
                return base64encode(value);
        }
    }
}

/**
 * Creates the default value for a scalar type.
 */
function reflectionScalarDefault(type, longType = LongType.STRING) {
    switch (type) {
        case ScalarType.BOOL:
            return false;
        case ScalarType.UINT64:
        case ScalarType.FIXED64:
            return reflectionLongConvert(PbULong.ZERO, longType);
        case ScalarType.INT64:
        case ScalarType.SFIXED64:
        case ScalarType.SINT64:
            return reflectionLongConvert(PbLong.ZERO, longType);
        case ScalarType.DOUBLE:
        case ScalarType.FLOAT:
            return 0.0;
        case ScalarType.BYTES:
            return new Uint8Array(0);
        case ScalarType.STRING:
            return "";
        default:
            // case ScalarType.INT32:
            // case ScalarType.UINT32:
            // case ScalarType.SINT32:
            // case ScalarType.FIXED32:
            // case ScalarType.SFIXED32:
            return 0;
    }
}

/**
 * Reads proto3 messages in binary format using reflection information.
 *
 * https://developers.google.com/protocol-buffers/docs/encoding
 */
class ReflectionBinaryReader {
    constructor(info) {
        this.info = info;
    }
    prepare() {
        var _a;
        if (!this.fieldNoToField) {
            const fieldsInput = (_a = this.info.fields) !== null && _a !== void 0 ? _a : [];
            this.fieldNoToField = new Map(fieldsInput.map(field => [field.no, field]));
        }
    }
    /**
     * Reads a message from binary format into the target message.
     *
     * Repeated fields are appended. Map entries are added, overwriting
     * existing keys.
     *
     * If a message field is already present, it will be merged with the
     * new data.
     */
    read(reader, message, options, length) {
        this.prepare();
        const end = length === undefined ? reader.len : reader.pos + length;
        while (reader.pos < end) {
            // read the tag and find the field
            const [fieldNo, wireType] = reader.tag(), field = this.fieldNoToField.get(fieldNo);
            if (!field) {
                let u = options.readUnknownField;
                if (u == "throw")
                    throw new Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.info.typeName}`);
                let d = reader.skip(wireType);
                if (u !== false)
                    (u === true ? UnknownFieldHandler.onRead : u)(this.info.typeName, message, fieldNo, wireType, d);
                continue;
            }
            // target object for the field we are reading
            let target = message, repeated = field.repeat, localName = field.localName;
            // if field is member of oneof ADT, use ADT as target
            if (field.oneof) {
                target = target[field.oneof];
                // if other oneof member selected, set new ADT
                if (target.oneofKind !== localName)
                    target = message[field.oneof] = {
                        oneofKind: localName
                    };
            }
            // we have handled oneof above, we just have read the value into `target[localName]`
            switch (field.kind) {
                case "scalar":
                case "enum":
                    let T = field.kind == "enum" ? ScalarType.INT32 : field.T;
                    let L = field.kind == "scalar" ? field.L : undefined;
                    if (repeated) {
                        let arr = target[localName]; // safe to assume presence of array, oneof cannot contain repeated values
                        if (wireType == WireType.LengthDelimited && T != ScalarType.STRING && T != ScalarType.BYTES) {
                            let e = reader.uint32() + reader.pos;
                            while (reader.pos < e)
                                arr.push(this.scalar(reader, T, L));
                        }
                        else
                            arr.push(this.scalar(reader, T, L));
                    }
                    else
                        target[localName] = this.scalar(reader, T, L);
                    break;
                case "message":
                    if (repeated) {
                        let arr = target[localName]; // safe to assume presence of array, oneof cannot contain repeated values
                        let msg = field.T().internalBinaryRead(reader, reader.uint32(), options);
                        arr.push(msg);
                    }
                    else
                        target[localName] = field.T().internalBinaryRead(reader, reader.uint32(), options, target[localName]);
                    break;
                case "map":
                    let [mapKey, mapVal] = this.mapEntry(field, reader, options);
                    // safe to assume presence of map object, oneof cannot contain repeated values
                    target[localName][mapKey] = mapVal;
                    break;
            }
        }
    }
    /**
     * Read a map field, expecting key field = 1, value field = 2
     */
    mapEntry(field, reader, options) {
        let length = reader.uint32();
        let end = reader.pos + length;
        let key = undefined; // javascript only allows number or string for object properties
        let val = undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    if (field.K == ScalarType.BOOL)
                        key = reader.bool().toString();
                    else
                        // long types are read as string, number types are okay as number
                        key = this.scalar(reader, field.K, LongType.STRING);
                    break;
                case 2:
                    switch (field.V.kind) {
                        case "scalar":
                            val = this.scalar(reader, field.V.T, field.V.L);
                            break;
                        case "enum":
                            val = reader.int32();
                            break;
                        case "message":
                            val = field.V.T().internalBinaryRead(reader, reader.uint32(), options);
                            break;
                    }
                    break;
                default:
                    throw new Error(`Unknown field ${fieldNo} (wire type ${wireType}) in map entry for ${this.info.typeName}#${field.name}`);
            }
        }
        if (key === undefined) {
            let keyRaw = reflectionScalarDefault(field.K);
            key = field.K == ScalarType.BOOL ? keyRaw.toString() : keyRaw;
        }
        if (val === undefined)
            switch (field.V.kind) {
                case "scalar":
                    val = reflectionScalarDefault(field.V.T, field.V.L);
                    break;
                case "enum":
                    val = 0;
                    break;
                case "message":
                    val = field.V.T().create();
                    break;
            }
        return [key, val];
    }
    scalar(reader, type, longType) {
        switch (type) {
            case ScalarType.INT32:
                return reader.int32();
            case ScalarType.STRING:
                return reader.string();
            case ScalarType.BOOL:
                return reader.bool();
            case ScalarType.DOUBLE:
                return reader.double();
            case ScalarType.FLOAT:
                return reader.float();
            case ScalarType.INT64:
                return reflectionLongConvert(reader.int64(), longType);
            case ScalarType.UINT64:
                return reflectionLongConvert(reader.uint64(), longType);
            case ScalarType.FIXED64:
                return reflectionLongConvert(reader.fixed64(), longType);
            case ScalarType.FIXED32:
                return reader.fixed32();
            case ScalarType.BYTES:
                return reader.bytes();
            case ScalarType.UINT32:
                return reader.uint32();
            case ScalarType.SFIXED32:
                return reader.sfixed32();
            case ScalarType.SFIXED64:
                return reflectionLongConvert(reader.sfixed64(), longType);
            case ScalarType.SINT32:
                return reader.sint32();
            case ScalarType.SINT64:
                return reflectionLongConvert(reader.sint64(), longType);
        }
    }
}

/**
 * Writes proto3 messages in binary format using reflection information.
 *
 * https://developers.google.com/protocol-buffers/docs/encoding
 */
class ReflectionBinaryWriter {
    constructor(info) {
        this.info = info;
    }
    prepare() {
        if (!this.fields) {
            const fieldsInput = this.info.fields ? this.info.fields.concat() : [];
            this.fields = fieldsInput.sort((a, b) => a.no - b.no);
        }
    }
    /**
     * Writes the message to binary format.
     */
    write(message, writer, options) {
        this.prepare();
        for (const field of this.fields) {
            let value, // this will be our field value, whether it is member of a oneof or not
            emitDefault, // whether we emit the default value (only true for oneof members)
            repeated = field.repeat, localName = field.localName;
            // handle oneof ADT
            if (field.oneof) {
                const group = message[field.oneof];
                if (group.oneofKind !== localName)
                    continue; // if field is not selected, skip
                value = group[localName];
                emitDefault = true;
            }
            else {
                value = message[localName];
                emitDefault = false;
            }
            // we have handled oneof above. we just have to honor `emitDefault`.
            switch (field.kind) {
                case "scalar":
                case "enum":
                    let T = field.kind == "enum" ? ScalarType.INT32 : field.T;
                    if (repeated) {
                        assert(Array.isArray(value));
                        if (repeated == RepeatType.PACKED)
                            this.packed(writer, T, field.no, value);
                        else
                            for (const item of value)
                                this.scalar(writer, T, field.no, item, true);
                    }
                    else if (value === undefined)
                        assert(field.opt);
                    else
                        this.scalar(writer, T, field.no, value, emitDefault || field.opt);
                    break;
                case "message":
                    if (repeated) {
                        assert(Array.isArray(value));
                        for (const item of value)
                            this.message(writer, options, field.T(), field.no, item);
                    }
                    else {
                        this.message(writer, options, field.T(), field.no, value);
                    }
                    break;
                case "map":
                    assert(typeof value == 'object' && value !== null);
                    for (const [key, val] of Object.entries(value))
                        this.mapEntry(writer, options, field, key, val);
                    break;
            }
        }
        let u = options.writeUnknownFields;
        if (u !== false)
            (u === true ? UnknownFieldHandler.onWrite : u)(this.info.typeName, message, writer);
    }
    mapEntry(writer, options, field, key, value) {
        writer.tag(field.no, WireType.LengthDelimited);
        writer.fork();
        // javascript only allows number or string for object properties
        // we convert from our representation to the protobuf type
        let keyValue = key;
        switch (field.K) {
            case ScalarType.INT32:
            case ScalarType.FIXED32:
            case ScalarType.UINT32:
            case ScalarType.SFIXED32:
            case ScalarType.SINT32:
                keyValue = Number.parseInt(key);
                break;
            case ScalarType.BOOL:
                assert(key == 'true' || key == 'false');
                keyValue = key == 'true';
                break;
        }
        // write key, expecting key field number = 1
        this.scalar(writer, field.K, 1, keyValue, true);
        // write value, expecting value field number = 2
        switch (field.V.kind) {
            case 'scalar':
                this.scalar(writer, field.V.T, 2, value, true);
                break;
            case 'enum':
                this.scalar(writer, ScalarType.INT32, 2, value, true);
                break;
            case 'message':
                this.message(writer, options, field.V.T(), 2, value);
                break;
        }
        writer.join();
    }
    message(writer, options, handler, fieldNo, value) {
        if (value === undefined)
            return;
        handler.internalBinaryWrite(value, writer.tag(fieldNo, WireType.LengthDelimited).fork(), options);
        writer.join();
    }
    /**
     * Write a single scalar value.
     */
    scalar(writer, type, fieldNo, value, emitDefault) {
        let [wireType, method, isDefault] = this.scalarInfo(type, value);
        if (!isDefault || emitDefault) {
            writer.tag(fieldNo, wireType);
            writer[method](value);
        }
    }
    /**
     * Write an array of scalar values in packed format.
     */
    packed(writer, type, fieldNo, value) {
        if (!value.length)
            return;
        assert(type !== ScalarType.BYTES && type !== ScalarType.STRING);
        // write tag
        writer.tag(fieldNo, WireType.LengthDelimited);
        // begin length-delimited
        writer.fork();
        // write values without tags
        let [, method,] = this.scalarInfo(type);
        for (let i = 0; i < value.length; i++)
            writer[method](value[i]);
        // end length delimited
        writer.join();
    }
    /**
     * Get information for writing a scalar value.
     *
     * Returns tuple:
     * [0]: appropriate WireType
     * [1]: name of the appropriate method of IBinaryWriter
     * [2]: whether the given value is a default value
     *
     * If argument `value` is omitted, [2] is always false.
     */
    scalarInfo(type, value) {
        let t = WireType.Varint;
        let m;
        let i = value === undefined;
        let d = value === 0;
        switch (type) {
            case ScalarType.INT32:
                m = "int32";
                break;
            case ScalarType.STRING:
                d = i || !value.length;
                t = WireType.LengthDelimited;
                m = "string";
                break;
            case ScalarType.BOOL:
                d = value === false;
                m = "bool";
                break;
            case ScalarType.UINT32:
                m = "uint32";
                break;
            case ScalarType.DOUBLE:
                t = WireType.Bit64;
                m = "double";
                break;
            case ScalarType.FLOAT:
                t = WireType.Bit32;
                m = "float";
                break;
            case ScalarType.INT64:
                d = i || PbLong.from(value).isZero();
                m = "int64";
                break;
            case ScalarType.UINT64:
                d = i || PbULong.from(value).isZero();
                m = "uint64";
                break;
            case ScalarType.FIXED64:
                d = i || PbULong.from(value).isZero();
                t = WireType.Bit64;
                m = "fixed64";
                break;
            case ScalarType.BYTES:
                d = i || !value.byteLength;
                t = WireType.LengthDelimited;
                m = "bytes";
                break;
            case ScalarType.FIXED32:
                t = WireType.Bit32;
                m = "fixed32";
                break;
            case ScalarType.SFIXED32:
                t = WireType.Bit32;
                m = "sfixed32";
                break;
            case ScalarType.SFIXED64:
                d = i || PbLong.from(value).isZero();
                t = WireType.Bit64;
                m = "sfixed64";
                break;
            case ScalarType.SINT32:
                m = "sint32";
                break;
            case ScalarType.SINT64:
                d = i || PbLong.from(value).isZero();
                m = "sint64";
                break;
        }
        return [t, m, i || d];
    }
}

/**
 * Creates an instance of the generic message, using the field
 * information.
 */
function reflectionCreate(type) {
    /**
     * This ternary can be removed in the next major version.
     * The `Object.create()` code path utilizes a new `messagePrototype`
     * property on the `IMessageType` which has this same `MESSAGE_TYPE`
     * non-enumerable property on it. Doing it this way means that we only
     * pay the cost of `Object.defineProperty()` once per `IMessageType`
     * class of once per "instance". The falsy code path is only provided
     * for backwards compatibility in cases where the runtime library is
     * updated without also updating the generated code.
     */
    const msg = type.messagePrototype
        ? Object.create(type.messagePrototype)
        : Object.defineProperty({}, MESSAGE_TYPE, { value: type });
    for (let field of type.fields) {
        let name = field.localName;
        if (field.opt)
            continue;
        if (field.oneof)
            msg[field.oneof] = { oneofKind: undefined };
        else if (field.repeat)
            msg[name] = [];
        else
            switch (field.kind) {
                case "scalar":
                    msg[name] = reflectionScalarDefault(field.T, field.L);
                    break;
                case "enum":
                    // we require 0 to be default value for all enums
                    msg[name] = 0;
                    break;
                case "map":
                    msg[name] = {};
                    break;
            }
    }
    return msg;
}

/**
 * Copy partial data into the target message.
 *
 * If a singular scalar or enum field is present in the source, it
 * replaces the field in the target.
 *
 * If a singular message field is present in the source, it is merged
 * with the target field by calling mergePartial() of the responsible
 * message type.
 *
 * If a repeated field is present in the source, its values replace
 * all values in the target array, removing extraneous values.
 * Repeated message fields are copied, not merged.
 *
 * If a map field is present in the source, entries are added to the
 * target map, replacing entries with the same key. Entries that only
 * exist in the target remain. Entries with message values are copied,
 * not merged.
 *
 * Note that this function differs from protobuf merge semantics,
 * which appends repeated fields.
 */
function reflectionMergePartial(info, target, source) {
    let fieldValue, // the field value we are working with
    input = source, output; // where we want our field value to go
    for (let field of info.fields) {
        let name = field.localName;
        if (field.oneof) {
            const group = input[field.oneof]; // this is the oneof`s group in the source
            if ((group === null || group === void 0 ? void 0 : group.oneofKind) == undefined) { // the user is free to omit
                continue; // we skip this field, and all other members too
            }
            fieldValue = group[name]; // our value comes from the the oneof group of the source
            output = target[field.oneof]; // and our output is the oneof group of the target
            output.oneofKind = group.oneofKind; // always update discriminator
            if (fieldValue == undefined) {
                delete output[name]; // remove any existing value
                continue; // skip further work on field
            }
        }
        else {
            fieldValue = input[name]; // we are using the source directly
            output = target; // we want our field value to go directly into the target
            if (fieldValue == undefined) {
                continue; // skip further work on field, existing value is used as is
            }
        }
        if (field.repeat)
            output[name].length = fieldValue.length; // resize target array to match source array
        // now we just work with `fieldValue` and `output` to merge the value
        switch (field.kind) {
            case "scalar":
            case "enum":
                if (field.repeat)
                    for (let i = 0; i < fieldValue.length; i++)
                        output[name][i] = fieldValue[i]; // not a reference type
                else
                    output[name] = fieldValue; // not a reference type
                break;
            case "message":
                let T = field.T();
                if (field.repeat)
                    for (let i = 0; i < fieldValue.length; i++)
                        output[name][i] = T.create(fieldValue[i]);
                else if (output[name] === undefined)
                    output[name] = T.create(fieldValue); // nothing to merge with
                else
                    T.mergePartial(output[name], fieldValue);
                break;
            case "map":
                // Map and repeated fields are simply overwritten, not appended or merged
                switch (field.V.kind) {
                    case "scalar":
                    case "enum":
                        Object.assign(output[name], fieldValue); // elements are not reference types
                        break;
                    case "message":
                        let T = field.V.T();
                        for (let k of Object.keys(fieldValue))
                            output[name][k] = T.create(fieldValue[k]);
                        break;
                }
                break;
        }
    }
}

/**
 * Determines whether two message of the same type have the same field values.
 * Checks for deep equality, traversing repeated fields, oneof groups, maps
 * and messages recursively.
 * Will also return true if both messages are `undefined`.
 */
function reflectionEquals(info, a, b) {
    if (a === b)
        return true;
    if (!a || !b)
        return false;
    for (let field of info.fields) {
        let localName = field.localName;
        let val_a = field.oneof ? a[field.oneof][localName] : a[localName];
        let val_b = field.oneof ? b[field.oneof][localName] : b[localName];
        switch (field.kind) {
            case "enum":
            case "scalar":
                let t = field.kind == "enum" ? ScalarType.INT32 : field.T;
                if (!(field.repeat
                    ? repeatedPrimitiveEq(t, val_a, val_b)
                    : primitiveEq(t, val_a, val_b)))
                    return false;
                break;
            case "map":
                if (!(field.V.kind == "message"
                    ? repeatedMsgEq(field.V.T(), objectValues(val_a), objectValues(val_b))
                    : repeatedPrimitiveEq(field.V.kind == "enum" ? ScalarType.INT32 : field.V.T, objectValues(val_a), objectValues(val_b))))
                    return false;
                break;
            case "message":
                let T = field.T();
                if (!(field.repeat
                    ? repeatedMsgEq(T, val_a, val_b)
                    : T.equals(val_a, val_b)))
                    return false;
                break;
        }
    }
    return true;
}
const objectValues = Object.values;
function primitiveEq(type, a, b) {
    if (a === b)
        return true;
    if (type !== ScalarType.BYTES)
        return false;
    let ba = a;
    let bb = b;
    if (ba.length !== bb.length)
        return false;
    for (let i = 0; i < ba.length; i++)
        if (ba[i] != bb[i])
            return false;
    return true;
}
function repeatedPrimitiveEq(type, a, b) {
    if (a.length !== b.length)
        return false;
    for (let i = 0; i < a.length; i++)
        if (!primitiveEq(type, a[i], b[i]))
            return false;
    return true;
}
function repeatedMsgEq(type, a, b) {
    if (a.length !== b.length)
        return false;
    for (let i = 0; i < a.length; i++)
        if (!type.equals(a[i], b[i]))
            return false;
    return true;
}

const baseDescriptors = Object.getOwnPropertyDescriptors(Object.getPrototypeOf({}));
const messageTypeDescriptor = baseDescriptors[MESSAGE_TYPE] = {};
/**
 * This standard message type provides reflection-based
 * operations to work with a message.
 */
class MessageType {
    constructor(name, fields, options) {
        this.defaultCheckDepth = 16;
        this.typeName = name;
        this.fields = fields.map(normalizeFieldInfo);
        this.options = options !== null && options !== void 0 ? options : {};
        messageTypeDescriptor.value = this;
        this.messagePrototype = Object.create(null, baseDescriptors);
        this.refTypeCheck = new ReflectionTypeCheck(this);
        this.refJsonReader = new ReflectionJsonReader(this);
        this.refJsonWriter = new ReflectionJsonWriter(this);
        this.refBinReader = new ReflectionBinaryReader(this);
        this.refBinWriter = new ReflectionBinaryWriter(this);
    }
    create(value) {
        let message = reflectionCreate(this);
        if (value !== undefined) {
            reflectionMergePartial(this, message, value);
        }
        return message;
    }
    /**
     * Clone the message.
     *
     * Unknown fields are discarded.
     */
    clone(message) {
        let copy = this.create();
        reflectionMergePartial(this, copy, message);
        return copy;
    }
    /**
     * Determines whether two message of the same type have the same field values.
     * Checks for deep equality, traversing repeated fields, oneof groups, maps
     * and messages recursively.
     * Will also return true if both messages are `undefined`.
     */
    equals(a, b) {
        return reflectionEquals(this, a, b);
    }
    /**
     * Is the given value assignable to our message type
     * and contains no [excess properties](https://www.typescriptlang.org/docs/handbook/interfaces.html#excess-property-checks)?
     */
    is(arg, depth = this.defaultCheckDepth) {
        return this.refTypeCheck.is(arg, depth, false);
    }
    /**
     * Is the given value assignable to our message type,
     * regardless of [excess properties](https://www.typescriptlang.org/docs/handbook/interfaces.html#excess-property-checks)?
     */
    isAssignable(arg, depth = this.defaultCheckDepth) {
        return this.refTypeCheck.is(arg, depth, true);
    }
    /**
     * Copy partial data into the target message.
     */
    mergePartial(target, source) {
        reflectionMergePartial(this, target, source);
    }
    /**
     * Create a new message from binary format.
     */
    fromBinary(data, options) {
        let opt = binaryReadOptions(options);
        return this.internalBinaryRead(opt.readerFactory(data), data.byteLength, opt);
    }
    /**
     * Read a new message from a JSON value.
     */
    fromJson(json, options) {
        return this.internalJsonRead(json, jsonReadOptions(options));
    }
    /**
     * Read a new message from a JSON string.
     * This is equivalent to `T.fromJson(JSON.parse(json))`.
     */
    fromJsonString(json, options) {
        let value = JSON.parse(json);
        return this.fromJson(value, options);
    }
    /**
     * Write the message to canonical JSON value.
     */
    toJson(message, options) {
        return this.internalJsonWrite(message, jsonWriteOptions(options));
    }
    /**
     * Convert the message to canonical JSON string.
     * This is equivalent to `JSON.stringify(T.toJson(t))`
     */
    toJsonString(message, options) {
        var _a;
        let value = this.toJson(message, options);
        return JSON.stringify(value, null, (_a = options === null || options === void 0 ? void 0 : options.prettySpaces) !== null && _a !== void 0 ? _a : 0);
    }
    /**
     * Write the message to binary format.
     */
    toBinary(message, options) {
        let opt = binaryWriteOptions(options);
        return this.internalBinaryWrite(message, opt.writerFactory(), opt).finish();
    }
    /**
     * This is an internal method. If you just want to read a message from
     * JSON, use `fromJson()` or `fromJsonString()`.
     *
     * Reads JSON value and merges the fields into the target
     * according to protobuf rules. If the target is omitted,
     * a new instance is created first.
     */
    internalJsonRead(json, options, target) {
        if (json !== null && typeof json == "object" && !Array.isArray(json)) {
            let message = target !== null && target !== void 0 ? target : this.create();
            this.refJsonReader.read(json, message, options);
            return message;
        }
        throw new Error(`Unable to parse message ${this.typeName} from JSON ${typeofJsonValue(json)}.`);
    }
    /**
     * This is an internal method. If you just want to write a message
     * to JSON, use `toJson()` or `toJsonString().
     *
     * Writes JSON value and returns it.
     */
    internalJsonWrite(message, options) {
        return this.refJsonWriter.write(message, options);
    }
    /**
     * This is an internal method. If you just want to write a message
     * in binary format, use `toBinary()`.
     *
     * Serializes the message in binary format and appends it to the given
     * writer. Returns passed writer.
     */
    internalBinaryWrite(message, writer, options) {
        this.refBinWriter.write(message, writer, options);
        return writer;
    }
    /**
     * This is an internal method. If you just want to read a message from
     * binary data, use `fromBinary()`.
     *
     * Reads data from binary format and merges the fields into
     * the target according to protobuf rules. If the target is
     * omitted, a new instance is created first.
     */
    internalBinaryRead(reader, length, options, target) {
        let message = target !== null && target !== void 0 ? target : this.create();
        this.refBinReader.read(reader, message, options, length);
        return message;
    }
}

function ProtoField(no, type, optional, repeat) {
  if (typeof type === "function") {
    return { kind: "message", no, type, optional: optional ?? false, repeat: repeat ?? false };
  } else {
    return { kind: "scalar", no, type, optional: optional ?? false, repeat: repeat ?? false };
  }
}
class NapProtoRealMsg {
  _field;
  _proto_msg;
  static cache = /* @__PURE__ */ new WeakMap();
  constructor(fields) {
    this._field = Object.keys(fields).map((key) => {
      const field = fields[key];
      if (field.kind === "scalar") {
        const repeatType = field.repeat ? [ScalarType.STRING, ScalarType.BYTES].includes(field.type) ? RepeatType.UNPACKED : RepeatType.PACKED : RepeatType.NO;
        return {
          no: field.no,
          name: key,
          kind: "scalar",
          T: field.type,
          opt: field.optional,
          repeat: repeatType
        };
      } else if (field.kind === "message") {
        return {
          no: field.no,
          name: key,
          kind: "message",
          repeat: field.repeat ? RepeatType.PACKED : RepeatType.NO,
          T: () => NapProtoRealMsg.getInstance(field.type())._proto_msg
        };
      } else {
        throw new Error(`Unknown field kind: ${field.kind}`);
      }
    });
    this._proto_msg = new MessageType("nya", this._field);
  }
  static getInstance(fields) {
    let instance = this.cache.get(fields);
    if (!instance) {
      instance = new NapProtoRealMsg(fields);
      this.cache.set(fields, instance);
    }
    return instance;
  }
  encode(data) {
    return this._proto_msg.toBinary(this._proto_msg.create(data));
  }
  decode(data) {
    return this._proto_msg.fromBinary(data);
  }
}
class NapProtoMsg {
  realMsg;
  constructor(fields) {
    this.realMsg = NapProtoRealMsg.getInstance(fields);
  }
  encode(data) {
    return this.realMsg.encode(data);
  }
  decode(data) {
    return this.realMsg.decode(data);
  }
}

var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

function getDefaultExportFromCjs (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

function getAugmentedNamespace(n) {
  if (Object.prototype.hasOwnProperty.call(n, '__esModule')) return n;
  var f = n.default;
	if (typeof f == "function") {
		var a = function a () {
			if (this instanceof a) {
        return Reflect.construct(f, arguments, this.constructor);
			}
			return f.apply(this, arguments);
		};
		a.prototype = f.prototype;
  } else a = {};
  Object.defineProperty(a, '__esModule', {value: true});
	Object.keys(n).forEach(function (k) {
		var d = Object.getOwnPropertyDescriptor(n, k);
		Object.defineProperty(a, k, d.get ? d : {
			enumerable: true,
			get: function () {
				return n[k];
			}
		});
	});
	return a;
}

var _Reflect = {};

/*! *****************************************************************************
Copyright (C) Microsoft. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */

var hasRequired_Reflect;

function require_Reflect () {
	if (hasRequired_Reflect) return _Reflect;
	hasRequired_Reflect = 1;
	var Reflect;
	(function (Reflect) {
	    // Metadata Proposal
	    // https://rbuckton.github.io/reflect-metadata/
	    (function (factory) {
	        var root = typeof globalThis === "object" ? globalThis :
	            typeof commonjsGlobal === "object" ? commonjsGlobal :
	                typeof self === "object" ? self :
	                    typeof this === "object" ? this :
	                        sloppyModeThis();
	        var exporter = makeExporter(Reflect);
	        if (typeof root.Reflect !== "undefined") {
	            exporter = makeExporter(root.Reflect, exporter);
	        }
	        factory(exporter, root);
	        if (typeof root.Reflect === "undefined") {
	            root.Reflect = Reflect;
	        }
	        function makeExporter(target, previous) {
	            return function (key, value) {
	                Object.defineProperty(target, key, { configurable: true, writable: true, value: value });
	                if (previous)
	                    previous(key, value);
	            };
	        }
	        function functionThis() {
	            try {
	                return Function("return this;")();
	            }
	            catch (_) { }
	        }
	        function indirectEvalThis() {
	            try {
	                return (void 0, eval)("(function() { return this; })()");
	            }
	            catch (_) { }
	        }
	        function sloppyModeThis() {
	            return functionThis() || indirectEvalThis();
	        }
	    })(function (exporter, root) {
	        var hasOwn = Object.prototype.hasOwnProperty;
	        // feature test for Symbol support
	        var supportsSymbol = typeof Symbol === "function";
	        var toPrimitiveSymbol = supportsSymbol && typeof Symbol.toPrimitive !== "undefined" ? Symbol.toPrimitive : "@@toPrimitive";
	        var iteratorSymbol = supportsSymbol && typeof Symbol.iterator !== "undefined" ? Symbol.iterator : "@@iterator";
	        var supportsCreate = typeof Object.create === "function"; // feature test for Object.create support
	        var supportsProto = { __proto__: [] } instanceof Array; // feature test for __proto__ support
	        var downLevel = !supportsCreate && !supportsProto;
	        var HashMap = {
	            // create an object in dictionary mode (a.k.a. "slow" mode in v8)
	            create: supportsCreate
	                ? function () { return MakeDictionary(Object.create(null)); }
	                : supportsProto
	                    ? function () { return MakeDictionary({ __proto__: null }); }
	                    : function () { return MakeDictionary({}); },
	            has: downLevel
	                ? function (map, key) { return hasOwn.call(map, key); }
	                : function (map, key) { return key in map; },
	            get: downLevel
	                ? function (map, key) { return hasOwn.call(map, key) ? map[key] : undefined; }
	                : function (map, key) { return map[key]; },
	        };
	        // Load global or shim versions of Map, Set, and WeakMap
	        var functionPrototype = Object.getPrototypeOf(Function);
	        var _Map = typeof Map === "function" && typeof Map.prototype.entries === "function" ? Map : CreateMapPolyfill();
	        var _Set = typeof Set === "function" && typeof Set.prototype.entries === "function" ? Set : CreateSetPolyfill();
	        var _WeakMap = typeof WeakMap === "function" ? WeakMap : CreateWeakMapPolyfill();
	        var registrySymbol = supportsSymbol ? Symbol.for("@reflect-metadata:registry") : undefined;
	        var metadataRegistry = GetOrCreateMetadataRegistry();
	        var metadataProvider = CreateMetadataProvider(metadataRegistry);
	        /**
	         * Applies a set of decorators to a property of a target object.
	         * @param decorators An array of decorators.
	         * @param target The target object.
	         * @param propertyKey (Optional) The property key to decorate.
	         * @param attributes (Optional) The property descriptor for the target key.
	         * @remarks Decorators are applied in reverse order.
	         * @example
	         *
	         *     class Example {
	         *         // property declarations are not part of ES6, though they are valid in TypeScript:
	         *         // static staticProperty;
	         *         // property;
	         *
	         *         constructor(p) { }
	         *         static staticMethod(p) { }
	         *         method(p) { }
	         *     }
	         *
	         *     // constructor
	         *     Example = Reflect.decorate(decoratorsArray, Example);
	         *
	         *     // property (on constructor)
	         *     Reflect.decorate(decoratorsArray, Example, "staticProperty");
	         *
	         *     // property (on prototype)
	         *     Reflect.decorate(decoratorsArray, Example.prototype, "property");
	         *
	         *     // method (on constructor)
	         *     Object.defineProperty(Example, "staticMethod",
	         *         Reflect.decorate(decoratorsArray, Example, "staticMethod",
	         *             Object.getOwnPropertyDescriptor(Example, "staticMethod")));
	         *
	         *     // method (on prototype)
	         *     Object.defineProperty(Example.prototype, "method",
	         *         Reflect.decorate(decoratorsArray, Example.prototype, "method",
	         *             Object.getOwnPropertyDescriptor(Example.prototype, "method")));
	         *
	         */
	        function decorate(decorators, target, propertyKey, attributes) {
	            if (!IsUndefined(propertyKey)) {
	                if (!IsArray(decorators))
	                    throw new TypeError();
	                if (!IsObject(target))
	                    throw new TypeError();
	                if (!IsObject(attributes) && !IsUndefined(attributes) && !IsNull(attributes))
	                    throw new TypeError();
	                if (IsNull(attributes))
	                    attributes = undefined;
	                propertyKey = ToPropertyKey(propertyKey);
	                return DecorateProperty(decorators, target, propertyKey, attributes);
	            }
	            else {
	                if (!IsArray(decorators))
	                    throw new TypeError();
	                if (!IsConstructor(target))
	                    throw new TypeError();
	                return DecorateConstructor(decorators, target);
	            }
	        }
	        exporter("decorate", decorate);
	        // 4.1.2 Reflect.metadata(metadataKey, metadataValue)
	        // https://rbuckton.github.io/reflect-metadata/#reflect.metadata
	        /**
	         * A default metadata decorator factory that can be used on a class, class member, or parameter.
	         * @param metadataKey The key for the metadata entry.
	         * @param metadataValue The value for the metadata entry.
	         * @returns A decorator function.
	         * @remarks
	         * If `metadataKey` is already defined for the target and target key, the
	         * metadataValue for that key will be overwritten.
	         * @example
	         *
	         *     // constructor
	         *     @Reflect.metadata(key, value)
	         *     class Example {
	         *     }
	         *
	         *     // property (on constructor, TypeScript only)
	         *     class Example {
	         *         @Reflect.metadata(key, value)
	         *         static staticProperty;
	         *     }
	         *
	         *     // property (on prototype, TypeScript only)
	         *     class Example {
	         *         @Reflect.metadata(key, value)
	         *         property;
	         *     }
	         *
	         *     // method (on constructor)
	         *     class Example {
	         *         @Reflect.metadata(key, value)
	         *         static staticMethod() { }
	         *     }
	         *
	         *     // method (on prototype)
	         *     class Example {
	         *         @Reflect.metadata(key, value)
	         *         method() { }
	         *     }
	         *
	         */
	        function metadata(metadataKey, metadataValue) {
	            function decorator(target, propertyKey) {
	                if (!IsObject(target))
	                    throw new TypeError();
	                if (!IsUndefined(propertyKey) && !IsPropertyKey(propertyKey))
	                    throw new TypeError();
	                OrdinaryDefineOwnMetadata(metadataKey, metadataValue, target, propertyKey);
	            }
	            return decorator;
	        }
	        exporter("metadata", metadata);
	        /**
	         * Define a unique metadata entry on the target.
	         * @param metadataKey A key used to store and retrieve metadata.
	         * @param metadataValue A value that contains attached metadata.
	         * @param target The target object on which to define metadata.
	         * @param propertyKey (Optional) The property key for the target.
	         * @example
	         *
	         *     class Example {
	         *         // property declarations are not part of ES6, though they are valid in TypeScript:
	         *         // static staticProperty;
	         *         // property;
	         *
	         *         constructor(p) { }
	         *         static staticMethod(p) { }
	         *         method(p) { }
	         *     }
	         *
	         *     // constructor
	         *     Reflect.defineMetadata("custom:annotation", options, Example);
	         *
	         *     // property (on constructor)
	         *     Reflect.defineMetadata("custom:annotation", options, Example, "staticProperty");
	         *
	         *     // property (on prototype)
	         *     Reflect.defineMetadata("custom:annotation", options, Example.prototype, "property");
	         *
	         *     // method (on constructor)
	         *     Reflect.defineMetadata("custom:annotation", options, Example, "staticMethod");
	         *
	         *     // method (on prototype)
	         *     Reflect.defineMetadata("custom:annotation", options, Example.prototype, "method");
	         *
	         *     // decorator factory as metadata-producing annotation.
	         *     function MyAnnotation(options): Decorator {
	         *         return (target, key?) => Reflect.defineMetadata("custom:annotation", options, target, key);
	         *     }
	         *
	         */
	        function defineMetadata(metadataKey, metadataValue, target, propertyKey) {
	            if (!IsObject(target))
	                throw new TypeError();
	            if (!IsUndefined(propertyKey))
	                propertyKey = ToPropertyKey(propertyKey);
	            return OrdinaryDefineOwnMetadata(metadataKey, metadataValue, target, propertyKey);
	        }
	        exporter("defineMetadata", defineMetadata);
	        /**
	         * Gets a value indicating whether the target object or its prototype chain has the provided metadata key defined.
	         * @param metadataKey A key used to store and retrieve metadata.
	         * @param target The target object on which the metadata is defined.
	         * @param propertyKey (Optional) The property key for the target.
	         * @returns `true` if the metadata key was defined on the target object or its prototype chain; otherwise, `false`.
	         * @example
	         *
	         *     class Example {
	         *         // property declarations are not part of ES6, though they are valid in TypeScript:
	         *         // static staticProperty;
	         *         // property;
	         *
	         *         constructor(p) { }
	         *         static staticMethod(p) { }
	         *         method(p) { }
	         *     }
	         *
	         *     // constructor
	         *     result = Reflect.hasMetadata("custom:annotation", Example);
	         *
	         *     // property (on constructor)
	         *     result = Reflect.hasMetadata("custom:annotation", Example, "staticProperty");
	         *
	         *     // property (on prototype)
	         *     result = Reflect.hasMetadata("custom:annotation", Example.prototype, "property");
	         *
	         *     // method (on constructor)
	         *     result = Reflect.hasMetadata("custom:annotation", Example, "staticMethod");
	         *
	         *     // method (on prototype)
	         *     result = Reflect.hasMetadata("custom:annotation", Example.prototype, "method");
	         *
	         */
	        function hasMetadata(metadataKey, target, propertyKey) {
	            if (!IsObject(target))
	                throw new TypeError();
	            if (!IsUndefined(propertyKey))
	                propertyKey = ToPropertyKey(propertyKey);
	            return OrdinaryHasMetadata(metadataKey, target, propertyKey);
	        }
	        exporter("hasMetadata", hasMetadata);
	        /**
	         * Gets a value indicating whether the target object has the provided metadata key defined.
	         * @param metadataKey A key used to store and retrieve metadata.
	         * @param target The target object on which the metadata is defined.
	         * @param propertyKey (Optional) The property key for the target.
	         * @returns `true` if the metadata key was defined on the target object; otherwise, `false`.
	         * @example
	         *
	         *     class Example {
	         *         // property declarations are not part of ES6, though they are valid in TypeScript:
	         *         // static staticProperty;
	         *         // property;
	         *
	         *         constructor(p) { }
	         *         static staticMethod(p) { }
	         *         method(p) { }
	         *     }
	         *
	         *     // constructor
	         *     result = Reflect.hasOwnMetadata("custom:annotation", Example);
	         *
	         *     // property (on constructor)
	         *     result = Reflect.hasOwnMetadata("custom:annotation", Example, "staticProperty");
	         *
	         *     // property (on prototype)
	         *     result = Reflect.hasOwnMetadata("custom:annotation", Example.prototype, "property");
	         *
	         *     // method (on constructor)
	         *     result = Reflect.hasOwnMetadata("custom:annotation", Example, "staticMethod");
	         *
	         *     // method (on prototype)
	         *     result = Reflect.hasOwnMetadata("custom:annotation", Example.prototype, "method");
	         *
	         */
	        function hasOwnMetadata(metadataKey, target, propertyKey) {
	            if (!IsObject(target))
	                throw new TypeError();
	            if (!IsUndefined(propertyKey))
	                propertyKey = ToPropertyKey(propertyKey);
	            return OrdinaryHasOwnMetadata(metadataKey, target, propertyKey);
	        }
	        exporter("hasOwnMetadata", hasOwnMetadata);
	        /**
	         * Gets the metadata value for the provided metadata key on the target object or its prototype chain.
	         * @param metadataKey A key used to store and retrieve metadata.
	         * @param target The target object on which the metadata is defined.
	         * @param propertyKey (Optional) The property key for the target.
	         * @returns The metadata value for the metadata key if found; otherwise, `undefined`.
	         * @example
	         *
	         *     class Example {
	         *         // property declarations are not part of ES6, though they are valid in TypeScript:
	         *         // static staticProperty;
	         *         // property;
	         *
	         *         constructor(p) { }
	         *         static staticMethod(p) { }
	         *         method(p) { }
	         *     }
	         *
	         *     // constructor
	         *     result = Reflect.getMetadata("custom:annotation", Example);
	         *
	         *     // property (on constructor)
	         *     result = Reflect.getMetadata("custom:annotation", Example, "staticProperty");
	         *
	         *     // property (on prototype)
	         *     result = Reflect.getMetadata("custom:annotation", Example.prototype, "property");
	         *
	         *     // method (on constructor)
	         *     result = Reflect.getMetadata("custom:annotation", Example, "staticMethod");
	         *
	         *     // method (on prototype)
	         *     result = Reflect.getMetadata("custom:annotation", Example.prototype, "method");
	         *
	         */
	        function getMetadata(metadataKey, target, propertyKey) {
	            if (!IsObject(target))
	                throw new TypeError();
	            if (!IsUndefined(propertyKey))
	                propertyKey = ToPropertyKey(propertyKey);
	            return OrdinaryGetMetadata(metadataKey, target, propertyKey);
	        }
	        exporter("getMetadata", getMetadata);
	        /**
	         * Gets the metadata value for the provided metadata key on the target object.
	         * @param metadataKey A key used to store and retrieve metadata.
	         * @param target The target object on which the metadata is defined.
	         * @param propertyKey (Optional) The property key for the target.
	         * @returns The metadata value for the metadata key if found; otherwise, `undefined`.
	         * @example
	         *
	         *     class Example {
	         *         // property declarations are not part of ES6, though they are valid in TypeScript:
	         *         // static staticProperty;
	         *         // property;
	         *
	         *         constructor(p) { }
	         *         static staticMethod(p) { }
	         *         method(p) { }
	         *     }
	         *
	         *     // constructor
	         *     result = Reflect.getOwnMetadata("custom:annotation", Example);
	         *
	         *     // property (on constructor)
	         *     result = Reflect.getOwnMetadata("custom:annotation", Example, "staticProperty");
	         *
	         *     // property (on prototype)
	         *     result = Reflect.getOwnMetadata("custom:annotation", Example.prototype, "property");
	         *
	         *     // method (on constructor)
	         *     result = Reflect.getOwnMetadata("custom:annotation", Example, "staticMethod");
	         *
	         *     // method (on prototype)
	         *     result = Reflect.getOwnMetadata("custom:annotation", Example.prototype, "method");
	         *
	         */
	        function getOwnMetadata(metadataKey, target, propertyKey) {
	            if (!IsObject(target))
	                throw new TypeError();
	            if (!IsUndefined(propertyKey))
	                propertyKey = ToPropertyKey(propertyKey);
	            return OrdinaryGetOwnMetadata(metadataKey, target, propertyKey);
	        }
	        exporter("getOwnMetadata", getOwnMetadata);
	        /**
	         * Gets the metadata keys defined on the target object or its prototype chain.
	         * @param target The target object on which the metadata is defined.
	         * @param propertyKey (Optional) The property key for the target.
	         * @returns An array of unique metadata keys.
	         * @example
	         *
	         *     class Example {
	         *         // property declarations are not part of ES6, though they are valid in TypeScript:
	         *         // static staticProperty;
	         *         // property;
	         *
	         *         constructor(p) { }
	         *         static staticMethod(p) { }
	         *         method(p) { }
	         *     }
	         *
	         *     // constructor
	         *     result = Reflect.getMetadataKeys(Example);
	         *
	         *     // property (on constructor)
	         *     result = Reflect.getMetadataKeys(Example, "staticProperty");
	         *
	         *     // property (on prototype)
	         *     result = Reflect.getMetadataKeys(Example.prototype, "property");
	         *
	         *     // method (on constructor)
	         *     result = Reflect.getMetadataKeys(Example, "staticMethod");
	         *
	         *     // method (on prototype)
	         *     result = Reflect.getMetadataKeys(Example.prototype, "method");
	         *
	         */
	        function getMetadataKeys(target, propertyKey) {
	            if (!IsObject(target))
	                throw new TypeError();
	            if (!IsUndefined(propertyKey))
	                propertyKey = ToPropertyKey(propertyKey);
	            return OrdinaryMetadataKeys(target, propertyKey);
	        }
	        exporter("getMetadataKeys", getMetadataKeys);
	        /**
	         * Gets the unique metadata keys defined on the target object.
	         * @param target The target object on which the metadata is defined.
	         * @param propertyKey (Optional) The property key for the target.
	         * @returns An array of unique metadata keys.
	         * @example
	         *
	         *     class Example {
	         *         // property declarations are not part of ES6, though they are valid in TypeScript:
	         *         // static staticProperty;
	         *         // property;
	         *
	         *         constructor(p) { }
	         *         static staticMethod(p) { }
	         *         method(p) { }
	         *     }
	         *
	         *     // constructor
	         *     result = Reflect.getOwnMetadataKeys(Example);
	         *
	         *     // property (on constructor)
	         *     result = Reflect.getOwnMetadataKeys(Example, "staticProperty");
	         *
	         *     // property (on prototype)
	         *     result = Reflect.getOwnMetadataKeys(Example.prototype, "property");
	         *
	         *     // method (on constructor)
	         *     result = Reflect.getOwnMetadataKeys(Example, "staticMethod");
	         *
	         *     // method (on prototype)
	         *     result = Reflect.getOwnMetadataKeys(Example.prototype, "method");
	         *
	         */
	        function getOwnMetadataKeys(target, propertyKey) {
	            if (!IsObject(target))
	                throw new TypeError();
	            if (!IsUndefined(propertyKey))
	                propertyKey = ToPropertyKey(propertyKey);
	            return OrdinaryOwnMetadataKeys(target, propertyKey);
	        }
	        exporter("getOwnMetadataKeys", getOwnMetadataKeys);
	        /**
	         * Deletes the metadata entry from the target object with the provided key.
	         * @param metadataKey A key used to store and retrieve metadata.
	         * @param target The target object on which the metadata is defined.
	         * @param propertyKey (Optional) The property key for the target.
	         * @returns `true` if the metadata entry was found and deleted; otherwise, false.
	         * @example
	         *
	         *     class Example {
	         *         // property declarations are not part of ES6, though they are valid in TypeScript:
	         *         // static staticProperty;
	         *         // property;
	         *
	         *         constructor(p) { }
	         *         static staticMethod(p) { }
	         *         method(p) { }
	         *     }
	         *
	         *     // constructor
	         *     result = Reflect.deleteMetadata("custom:annotation", Example);
	         *
	         *     // property (on constructor)
	         *     result = Reflect.deleteMetadata("custom:annotation", Example, "staticProperty");
	         *
	         *     // property (on prototype)
	         *     result = Reflect.deleteMetadata("custom:annotation", Example.prototype, "property");
	         *
	         *     // method (on constructor)
	         *     result = Reflect.deleteMetadata("custom:annotation", Example, "staticMethod");
	         *
	         *     // method (on prototype)
	         *     result = Reflect.deleteMetadata("custom:annotation", Example.prototype, "method");
	         *
	         */
	        function deleteMetadata(metadataKey, target, propertyKey) {
	            if (!IsObject(target))
	                throw new TypeError();
	            if (!IsUndefined(propertyKey))
	                propertyKey = ToPropertyKey(propertyKey);
	            if (!IsObject(target))
	                throw new TypeError();
	            if (!IsUndefined(propertyKey))
	                propertyKey = ToPropertyKey(propertyKey);
	            var provider = GetMetadataProvider(target, propertyKey, /*Create*/ false);
	            if (IsUndefined(provider))
	                return false;
	            return provider.OrdinaryDeleteMetadata(metadataKey, target, propertyKey);
	        }
	        exporter("deleteMetadata", deleteMetadata);
	        function DecorateConstructor(decorators, target) {
	            for (var i = decorators.length - 1; i >= 0; --i) {
	                var decorator = decorators[i];
	                var decorated = decorator(target);
	                if (!IsUndefined(decorated) && !IsNull(decorated)) {
	                    if (!IsConstructor(decorated))
	                        throw new TypeError();
	                    target = decorated;
	                }
	            }
	            return target;
	        }
	        function DecorateProperty(decorators, target, propertyKey, descriptor) {
	            for (var i = decorators.length - 1; i >= 0; --i) {
	                var decorator = decorators[i];
	                var decorated = decorator(target, propertyKey, descriptor);
	                if (!IsUndefined(decorated) && !IsNull(decorated)) {
	                    if (!IsObject(decorated))
	                        throw new TypeError();
	                    descriptor = decorated;
	                }
	            }
	            return descriptor;
	        }
	        // 3.1.1.1 OrdinaryHasMetadata(MetadataKey, O, P)
	        // https://rbuckton.github.io/reflect-metadata/#ordinaryhasmetadata
	        function OrdinaryHasMetadata(MetadataKey, O, P) {
	            var hasOwn = OrdinaryHasOwnMetadata(MetadataKey, O, P);
	            if (hasOwn)
	                return true;
	            var parent = OrdinaryGetPrototypeOf(O);
	            if (!IsNull(parent))
	                return OrdinaryHasMetadata(MetadataKey, parent, P);
	            return false;
	        }
	        // 3.1.2.1 OrdinaryHasOwnMetadata(MetadataKey, O, P)
	        // https://rbuckton.github.io/reflect-metadata/#ordinaryhasownmetadata
	        function OrdinaryHasOwnMetadata(MetadataKey, O, P) {
	            var provider = GetMetadataProvider(O, P, /*Create*/ false);
	            if (IsUndefined(provider))
	                return false;
	            return ToBoolean(provider.OrdinaryHasOwnMetadata(MetadataKey, O, P));
	        }
	        // 3.1.3.1 OrdinaryGetMetadata(MetadataKey, O, P)
	        // https://rbuckton.github.io/reflect-metadata/#ordinarygetmetadata
	        function OrdinaryGetMetadata(MetadataKey, O, P) {
	            var hasOwn = OrdinaryHasOwnMetadata(MetadataKey, O, P);
	            if (hasOwn)
	                return OrdinaryGetOwnMetadata(MetadataKey, O, P);
	            var parent = OrdinaryGetPrototypeOf(O);
	            if (!IsNull(parent))
	                return OrdinaryGetMetadata(MetadataKey, parent, P);
	            return undefined;
	        }
	        // 3.1.4.1 OrdinaryGetOwnMetadata(MetadataKey, O, P)
	        // https://rbuckton.github.io/reflect-metadata/#ordinarygetownmetadata
	        function OrdinaryGetOwnMetadata(MetadataKey, O, P) {
	            var provider = GetMetadataProvider(O, P, /*Create*/ false);
	            if (IsUndefined(provider))
	                return;
	            return provider.OrdinaryGetOwnMetadata(MetadataKey, O, P);
	        }
	        // 3.1.5.1 OrdinaryDefineOwnMetadata(MetadataKey, MetadataValue, O, P)
	        // https://rbuckton.github.io/reflect-metadata/#ordinarydefineownmetadata
	        function OrdinaryDefineOwnMetadata(MetadataKey, MetadataValue, O, P) {
	            var provider = GetMetadataProvider(O, P, /*Create*/ true);
	            provider.OrdinaryDefineOwnMetadata(MetadataKey, MetadataValue, O, P);
	        }
	        // 3.1.6.1 OrdinaryMetadataKeys(O, P)
	        // https://rbuckton.github.io/reflect-metadata/#ordinarymetadatakeys
	        function OrdinaryMetadataKeys(O, P) {
	            var ownKeys = OrdinaryOwnMetadataKeys(O, P);
	            var parent = OrdinaryGetPrototypeOf(O);
	            if (parent === null)
	                return ownKeys;
	            var parentKeys = OrdinaryMetadataKeys(parent, P);
	            if (parentKeys.length <= 0)
	                return ownKeys;
	            if (ownKeys.length <= 0)
	                return parentKeys;
	            var set = new _Set();
	            var keys = [];
	            for (var _i = 0, ownKeys_1 = ownKeys; _i < ownKeys_1.length; _i++) {
	                var key = ownKeys_1[_i];
	                var hasKey = set.has(key);
	                if (!hasKey) {
	                    set.add(key);
	                    keys.push(key);
	                }
	            }
	            for (var _a = 0, parentKeys_1 = parentKeys; _a < parentKeys_1.length; _a++) {
	                var key = parentKeys_1[_a];
	                var hasKey = set.has(key);
	                if (!hasKey) {
	                    set.add(key);
	                    keys.push(key);
	                }
	            }
	            return keys;
	        }
	        // 3.1.7.1 OrdinaryOwnMetadataKeys(O, P)
	        // https://rbuckton.github.io/reflect-metadata/#ordinaryownmetadatakeys
	        function OrdinaryOwnMetadataKeys(O, P) {
	            var provider = GetMetadataProvider(O, P, /*create*/ false);
	            if (!provider) {
	                return [];
	            }
	            return provider.OrdinaryOwnMetadataKeys(O, P);
	        }
	        // 6 ECMAScript Data Types and Values
	        // https://tc39.github.io/ecma262/#sec-ecmascript-data-types-and-values
	        function Type(x) {
	            if (x === null)
	                return 1 /* Null */;
	            switch (typeof x) {
	                case "undefined": return 0 /* Undefined */;
	                case "boolean": return 2 /* Boolean */;
	                case "string": return 3 /* String */;
	                case "symbol": return 4 /* Symbol */;
	                case "number": return 5 /* Number */;
	                case "object": return x === null ? 1 /* Null */ : 6 /* Object */;
	                default: return 6 /* Object */;
	            }
	        }
	        // 6.1.1 The Undefined Type
	        // https://tc39.github.io/ecma262/#sec-ecmascript-language-types-undefined-type
	        function IsUndefined(x) {
	            return x === undefined;
	        }
	        // 6.1.2 The Null Type
	        // https://tc39.github.io/ecma262/#sec-ecmascript-language-types-null-type
	        function IsNull(x) {
	            return x === null;
	        }
	        // 6.1.5 The Symbol Type
	        // https://tc39.github.io/ecma262/#sec-ecmascript-language-types-symbol-type
	        function IsSymbol(x) {
	            return typeof x === "symbol";
	        }
	        // 6.1.7 The Object Type
	        // https://tc39.github.io/ecma262/#sec-object-type
	        function IsObject(x) {
	            return typeof x === "object" ? x !== null : typeof x === "function";
	        }
	        // 7.1 Type Conversion
	        // https://tc39.github.io/ecma262/#sec-type-conversion
	        // 7.1.1 ToPrimitive(input [, PreferredType])
	        // https://tc39.github.io/ecma262/#sec-toprimitive
	        function ToPrimitive(input, PreferredType) {
	            switch (Type(input)) {
	                case 0 /* Undefined */: return input;
	                case 1 /* Null */: return input;
	                case 2 /* Boolean */: return input;
	                case 3 /* String */: return input;
	                case 4 /* Symbol */: return input;
	                case 5 /* Number */: return input;
	            }
	            var hint = "string" ;
	            var exoticToPrim = GetMethod(input, toPrimitiveSymbol);
	            if (exoticToPrim !== undefined) {
	                var result = exoticToPrim.call(input, hint);
	                if (IsObject(result))
	                    throw new TypeError();
	                return result;
	            }
	            return OrdinaryToPrimitive(input);
	        }
	        // 7.1.1.1 OrdinaryToPrimitive(O, hint)
	        // https://tc39.github.io/ecma262/#sec-ordinarytoprimitive
	        function OrdinaryToPrimitive(O, hint) {
	            var valueOf, result, toString_2; {
	                var toString_1 = O.toString;
	                if (IsCallable(toString_1)) {
	                    var result = toString_1.call(O);
	                    if (!IsObject(result))
	                        return result;
	                }
	                var valueOf = O.valueOf;
	                if (IsCallable(valueOf)) {
	                    var result = valueOf.call(O);
	                    if (!IsObject(result))
	                        return result;
	                }
	            }
	            throw new TypeError();
	        }
	        // 7.1.2 ToBoolean(argument)
	        // https://tc39.github.io/ecma262/2016/#sec-toboolean
	        function ToBoolean(argument) {
	            return !!argument;
	        }
	        // 7.1.12 ToString(argument)
	        // https://tc39.github.io/ecma262/#sec-tostring
	        function ToString(argument) {
	            return "" + argument;
	        }
	        // 7.1.14 ToPropertyKey(argument)
	        // https://tc39.github.io/ecma262/#sec-topropertykey
	        function ToPropertyKey(argument) {
	            var key = ToPrimitive(argument);
	            if (IsSymbol(key))
	                return key;
	            return ToString(key);
	        }
	        // 7.2 Testing and Comparison Operations
	        // https://tc39.github.io/ecma262/#sec-testing-and-comparison-operations
	        // 7.2.2 IsArray(argument)
	        // https://tc39.github.io/ecma262/#sec-isarray
	        function IsArray(argument) {
	            return Array.isArray
	                ? Array.isArray(argument)
	                : argument instanceof Object
	                    ? argument instanceof Array
	                    : Object.prototype.toString.call(argument) === "[object Array]";
	        }
	        // 7.2.3 IsCallable(argument)
	        // https://tc39.github.io/ecma262/#sec-iscallable
	        function IsCallable(argument) {
	            // NOTE: This is an approximation as we cannot check for [[Call]] internal method.
	            return typeof argument === "function";
	        }
	        // 7.2.4 IsConstructor(argument)
	        // https://tc39.github.io/ecma262/#sec-isconstructor
	        function IsConstructor(argument) {
	            // NOTE: This is an approximation as we cannot check for [[Construct]] internal method.
	            return typeof argument === "function";
	        }
	        // 7.2.7 IsPropertyKey(argument)
	        // https://tc39.github.io/ecma262/#sec-ispropertykey
	        function IsPropertyKey(argument) {
	            switch (Type(argument)) {
	                case 3 /* String */: return true;
	                case 4 /* Symbol */: return true;
	                default: return false;
	            }
	        }
	        function SameValueZero(x, y) {
	            return x === y || x !== x && y !== y;
	        }
	        // 7.3 Operations on Objects
	        // https://tc39.github.io/ecma262/#sec-operations-on-objects
	        // 7.3.9 GetMethod(V, P)
	        // https://tc39.github.io/ecma262/#sec-getmethod
	        function GetMethod(V, P) {
	            var func = V[P];
	            if (func === undefined || func === null)
	                return undefined;
	            if (!IsCallable(func))
	                throw new TypeError();
	            return func;
	        }
	        // 7.4 Operations on Iterator Objects
	        // https://tc39.github.io/ecma262/#sec-operations-on-iterator-objects
	        function GetIterator(obj) {
	            var method = GetMethod(obj, iteratorSymbol);
	            if (!IsCallable(method))
	                throw new TypeError(); // from Call
	            var iterator = method.call(obj);
	            if (!IsObject(iterator))
	                throw new TypeError();
	            return iterator;
	        }
	        // 7.4.4 IteratorValue(iterResult)
	        // https://tc39.github.io/ecma262/2016/#sec-iteratorvalue
	        function IteratorValue(iterResult) {
	            return iterResult.value;
	        }
	        // 7.4.5 IteratorStep(iterator)
	        // https://tc39.github.io/ecma262/#sec-iteratorstep
	        function IteratorStep(iterator) {
	            var result = iterator.next();
	            return result.done ? false : result;
	        }
	        // 7.4.6 IteratorClose(iterator, completion)
	        // https://tc39.github.io/ecma262/#sec-iteratorclose
	        function IteratorClose(iterator) {
	            var f = iterator["return"];
	            if (f)
	                f.call(iterator);
	        }
	        // 9.1 Ordinary Object Internal Methods and Internal Slots
	        // https://tc39.github.io/ecma262/#sec-ordinary-object-internal-methods-and-internal-slots
	        // 9.1.1.1 OrdinaryGetPrototypeOf(O)
	        // https://tc39.github.io/ecma262/#sec-ordinarygetprototypeof
	        function OrdinaryGetPrototypeOf(O) {
	            var proto = Object.getPrototypeOf(O);
	            if (typeof O !== "function" || O === functionPrototype)
	                return proto;
	            // TypeScript doesn't set __proto__ in ES5, as it's non-standard.
	            // Try to determine the superclass constructor. Compatible implementations
	            // must either set __proto__ on a subclass constructor to the superclass constructor,
	            // or ensure each class has a valid `constructor` property on its prototype that
	            // points back to the constructor.
	            // If this is not the same as Function.[[Prototype]], then this is definately inherited.
	            // This is the case when in ES6 or when using __proto__ in a compatible browser.
	            if (proto !== functionPrototype)
	                return proto;
	            // If the super prototype is Object.prototype, null, or undefined, then we cannot determine the heritage.
	            var prototype = O.prototype;
	            var prototypeProto = prototype && Object.getPrototypeOf(prototype);
	            if (prototypeProto == null || prototypeProto === Object.prototype)
	                return proto;
	            // If the constructor was not a function, then we cannot determine the heritage.
	            var constructor = prototypeProto.constructor;
	            if (typeof constructor !== "function")
	                return proto;
	            // If we have some kind of self-reference, then we cannot determine the heritage.
	            if (constructor === O)
	                return proto;
	            // we have a pretty good guess at the heritage.
	            return constructor;
	        }
	        // Global metadata registry
	        // - Allows `import "reflect-metadata"` and `import "reflect-metadata/no-conflict"` to interoperate.
	        // - Uses isolated metadata if `Reflect` is frozen before the registry can be installed.
	        /**
	         * Creates a registry used to allow multiple `reflect-metadata` providers.
	         */
	        function CreateMetadataRegistry() {
	            var fallback;
	            if (!IsUndefined(registrySymbol) &&
	                typeof root.Reflect !== "undefined" &&
	                !(registrySymbol in root.Reflect) &&
	                typeof root.Reflect.defineMetadata === "function") {
	                // interoperate with older version of `reflect-metadata` that did not support a registry.
	                fallback = CreateFallbackProvider(root.Reflect);
	            }
	            var first;
	            var second;
	            var rest;
	            var targetProviderMap = new _WeakMap();
	            var registry = {
	                registerProvider: registerProvider,
	                getProvider: getProvider,
	                setProvider: setProvider,
	            };
	            return registry;
	            function registerProvider(provider) {
	                if (!Object.isExtensible(registry)) {
	                    throw new Error("Cannot add provider to a frozen registry.");
	                }
	                switch (true) {
	                    case fallback === provider: break;
	                    case IsUndefined(first):
	                        first = provider;
	                        break;
	                    case first === provider: break;
	                    case IsUndefined(second):
	                        second = provider;
	                        break;
	                    case second === provider: break;
	                    default:
	                        if (rest === undefined)
	                            rest = new _Set();
	                        rest.add(provider);
	                        break;
	                }
	            }
	            function getProviderNoCache(O, P) {
	                if (!IsUndefined(first)) {
	                    if (first.isProviderFor(O, P))
	                        return first;
	                    if (!IsUndefined(second)) {
	                        if (second.isProviderFor(O, P))
	                            return first;
	                        if (!IsUndefined(rest)) {
	                            var iterator = GetIterator(rest);
	                            while (true) {
	                                var next = IteratorStep(iterator);
	                                if (!next) {
	                                    return undefined;
	                                }
	                                var provider = IteratorValue(next);
	                                if (provider.isProviderFor(O, P)) {
	                                    IteratorClose(iterator);
	                                    return provider;
	                                }
	                            }
	                        }
	                    }
	                }
	                if (!IsUndefined(fallback) && fallback.isProviderFor(O, P)) {
	                    return fallback;
	                }
	                return undefined;
	            }
	            function getProvider(O, P) {
	                var providerMap = targetProviderMap.get(O);
	                var provider;
	                if (!IsUndefined(providerMap)) {
	                    provider = providerMap.get(P);
	                }
	                if (!IsUndefined(provider)) {
	                    return provider;
	                }
	                provider = getProviderNoCache(O, P);
	                if (!IsUndefined(provider)) {
	                    if (IsUndefined(providerMap)) {
	                        providerMap = new _Map();
	                        targetProviderMap.set(O, providerMap);
	                    }
	                    providerMap.set(P, provider);
	                }
	                return provider;
	            }
	            function hasProvider(provider) {
	                if (IsUndefined(provider))
	                    throw new TypeError();
	                return first === provider || second === provider || !IsUndefined(rest) && rest.has(provider);
	            }
	            function setProvider(O, P, provider) {
	                if (!hasProvider(provider)) {
	                    throw new Error("Metadata provider not registered.");
	                }
	                var existingProvider = getProvider(O, P);
	                if (existingProvider !== provider) {
	                    if (!IsUndefined(existingProvider)) {
	                        return false;
	                    }
	                    var providerMap = targetProviderMap.get(O);
	                    if (IsUndefined(providerMap)) {
	                        providerMap = new _Map();
	                        targetProviderMap.set(O, providerMap);
	                    }
	                    providerMap.set(P, provider);
	                }
	                return true;
	            }
	        }
	        /**
	         * Gets or creates the shared registry of metadata providers.
	         */
	        function GetOrCreateMetadataRegistry() {
	            var metadataRegistry;
	            if (!IsUndefined(registrySymbol) && IsObject(root.Reflect) && Object.isExtensible(root.Reflect)) {
	                metadataRegistry = root.Reflect[registrySymbol];
	            }
	            if (IsUndefined(metadataRegistry)) {
	                metadataRegistry = CreateMetadataRegistry();
	            }
	            if (!IsUndefined(registrySymbol) && IsObject(root.Reflect) && Object.isExtensible(root.Reflect)) {
	                Object.defineProperty(root.Reflect, registrySymbol, {
	                    enumerable: false,
	                    configurable: false,
	                    writable: false,
	                    value: metadataRegistry
	                });
	            }
	            return metadataRegistry;
	        }
	        function CreateMetadataProvider(registry) {
	            // [[Metadata]] internal slot
	            // https://rbuckton.github.io/reflect-metadata/#ordinary-object-internal-methods-and-internal-slots
	            var metadata = new _WeakMap();
	            var provider = {
	                isProviderFor: function (O, P) {
	                    var targetMetadata = metadata.get(O);
	                    if (IsUndefined(targetMetadata))
	                        return false;
	                    return targetMetadata.has(P);
	                },
	                OrdinaryDefineOwnMetadata: OrdinaryDefineOwnMetadata,
	                OrdinaryHasOwnMetadata: OrdinaryHasOwnMetadata,
	                OrdinaryGetOwnMetadata: OrdinaryGetOwnMetadata,
	                OrdinaryOwnMetadataKeys: OrdinaryOwnMetadataKeys,
	                OrdinaryDeleteMetadata: OrdinaryDeleteMetadata,
	            };
	            metadataRegistry.registerProvider(provider);
	            return provider;
	            function GetOrCreateMetadataMap(O, P, Create) {
	                var targetMetadata = metadata.get(O);
	                var createdTargetMetadata = false;
	                if (IsUndefined(targetMetadata)) {
	                    if (!Create)
	                        return undefined;
	                    targetMetadata = new _Map();
	                    metadata.set(O, targetMetadata);
	                    createdTargetMetadata = true;
	                }
	                var metadataMap = targetMetadata.get(P);
	                if (IsUndefined(metadataMap)) {
	                    if (!Create)
	                        return undefined;
	                    metadataMap = new _Map();
	                    targetMetadata.set(P, metadataMap);
	                    if (!registry.setProvider(O, P, provider)) {
	                        targetMetadata.delete(P);
	                        if (createdTargetMetadata) {
	                            metadata.delete(O);
	                        }
	                        throw new Error("Wrong provider for target.");
	                    }
	                }
	                return metadataMap;
	            }
	            // 3.1.2.1 OrdinaryHasOwnMetadata(MetadataKey, O, P)
	            // https://rbuckton.github.io/reflect-metadata/#ordinaryhasownmetadata
	            function OrdinaryHasOwnMetadata(MetadataKey, O, P) {
	                var metadataMap = GetOrCreateMetadataMap(O, P, /*Create*/ false);
	                if (IsUndefined(metadataMap))
	                    return false;
	                return ToBoolean(metadataMap.has(MetadataKey));
	            }
	            // 3.1.4.1 OrdinaryGetOwnMetadata(MetadataKey, O, P)
	            // https://rbuckton.github.io/reflect-metadata/#ordinarygetownmetadata
	            function OrdinaryGetOwnMetadata(MetadataKey, O, P) {
	                var metadataMap = GetOrCreateMetadataMap(O, P, /*Create*/ false);
	                if (IsUndefined(metadataMap))
	                    return undefined;
	                return metadataMap.get(MetadataKey);
	            }
	            // 3.1.5.1 OrdinaryDefineOwnMetadata(MetadataKey, MetadataValue, O, P)
	            // https://rbuckton.github.io/reflect-metadata/#ordinarydefineownmetadata
	            function OrdinaryDefineOwnMetadata(MetadataKey, MetadataValue, O, P) {
	                var metadataMap = GetOrCreateMetadataMap(O, P, /*Create*/ true);
	                metadataMap.set(MetadataKey, MetadataValue);
	            }
	            // 3.1.7.1 OrdinaryOwnMetadataKeys(O, P)
	            // https://rbuckton.github.io/reflect-metadata/#ordinaryownmetadatakeys
	            function OrdinaryOwnMetadataKeys(O, P) {
	                var keys = [];
	                var metadataMap = GetOrCreateMetadataMap(O, P, /*Create*/ false);
	                if (IsUndefined(metadataMap))
	                    return keys;
	                var keysObj = metadataMap.keys();
	                var iterator = GetIterator(keysObj);
	                var k = 0;
	                while (true) {
	                    var next = IteratorStep(iterator);
	                    if (!next) {
	                        keys.length = k;
	                        return keys;
	                    }
	                    var nextValue = IteratorValue(next);
	                    try {
	                        keys[k] = nextValue;
	                    }
	                    catch (e) {
	                        try {
	                            IteratorClose(iterator);
	                        }
	                        finally {
	                            throw e;
	                        }
	                    }
	                    k++;
	                }
	            }
	            function OrdinaryDeleteMetadata(MetadataKey, O, P) {
	                var metadataMap = GetOrCreateMetadataMap(O, P, /*Create*/ false);
	                if (IsUndefined(metadataMap))
	                    return false;
	                if (!metadataMap.delete(MetadataKey))
	                    return false;
	                if (metadataMap.size === 0) {
	                    var targetMetadata = metadata.get(O);
	                    if (!IsUndefined(targetMetadata)) {
	                        targetMetadata.delete(P);
	                        if (targetMetadata.size === 0) {
	                            metadata.delete(targetMetadata);
	                        }
	                    }
	                }
	                return true;
	            }
	        }
	        function CreateFallbackProvider(reflect) {
	            var defineMetadata = reflect.defineMetadata, hasOwnMetadata = reflect.hasOwnMetadata, getOwnMetadata = reflect.getOwnMetadata, getOwnMetadataKeys = reflect.getOwnMetadataKeys, deleteMetadata = reflect.deleteMetadata;
	            var metadataOwner = new _WeakMap();
	            var provider = {
	                isProviderFor: function (O, P) {
	                    var metadataPropertySet = metadataOwner.get(O);
	                    if (!IsUndefined(metadataPropertySet) && metadataPropertySet.has(P)) {
	                        return true;
	                    }
	                    if (getOwnMetadataKeys(O, P).length) {
	                        if (IsUndefined(metadataPropertySet)) {
	                            metadataPropertySet = new _Set();
	                            metadataOwner.set(O, metadataPropertySet);
	                        }
	                        metadataPropertySet.add(P);
	                        return true;
	                    }
	                    return false;
	                },
	                OrdinaryDefineOwnMetadata: defineMetadata,
	                OrdinaryHasOwnMetadata: hasOwnMetadata,
	                OrdinaryGetOwnMetadata: getOwnMetadata,
	                OrdinaryOwnMetadataKeys: getOwnMetadataKeys,
	                OrdinaryDeleteMetadata: deleteMetadata,
	            };
	            return provider;
	        }
	        /**
	         * Gets the metadata provider for an object. If the object has no metadata provider and this is for a create operation,
	         * then this module's metadata provider is assigned to the object.
	         */
	        function GetMetadataProvider(O, P, Create) {
	            var registeredProvider = metadataRegistry.getProvider(O, P);
	            if (!IsUndefined(registeredProvider)) {
	                return registeredProvider;
	            }
	            if (Create) {
	                if (metadataRegistry.setProvider(O, P, metadataProvider)) {
	                    return metadataProvider;
	                }
	                throw new Error("Illegal state.");
	            }
	            return undefined;
	        }
	        // naive Map shim
	        function CreateMapPolyfill() {
	            var cacheSentinel = {};
	            var arraySentinel = [];
	            var MapIterator = /** @class */ (function () {
	                function MapIterator(keys, values, selector) {
	                    this._index = 0;
	                    this._keys = keys;
	                    this._values = values;
	                    this._selector = selector;
	                }
	                MapIterator.prototype["@@iterator"] = function () { return this; };
	                MapIterator.prototype[iteratorSymbol] = function () { return this; };
	                MapIterator.prototype.next = function () {
	                    var index = this._index;
	                    if (index >= 0 && index < this._keys.length) {
	                        var result = this._selector(this._keys[index], this._values[index]);
	                        if (index + 1 >= this._keys.length) {
	                            this._index = -1;
	                            this._keys = arraySentinel;
	                            this._values = arraySentinel;
	                        }
	                        else {
	                            this._index++;
	                        }
	                        return { value: result, done: false };
	                    }
	                    return { value: undefined, done: true };
	                };
	                MapIterator.prototype.throw = function (error) {
	                    if (this._index >= 0) {
	                        this._index = -1;
	                        this._keys = arraySentinel;
	                        this._values = arraySentinel;
	                    }
	                    throw error;
	                };
	                MapIterator.prototype.return = function (value) {
	                    if (this._index >= 0) {
	                        this._index = -1;
	                        this._keys = arraySentinel;
	                        this._values = arraySentinel;
	                    }
	                    return { value: value, done: true };
	                };
	                return MapIterator;
	            }());
	            var Map = /** @class */ (function () {
	                function Map() {
	                    this._keys = [];
	                    this._values = [];
	                    this._cacheKey = cacheSentinel;
	                    this._cacheIndex = -2;
	                }
	                Object.defineProperty(Map.prototype, "size", {
	                    get: function () { return this._keys.length; },
	                    enumerable: true,
	                    configurable: true
	                });
	                Map.prototype.has = function (key) { return this._find(key, /*insert*/ false) >= 0; };
	                Map.prototype.get = function (key) {
	                    var index = this._find(key, /*insert*/ false);
	                    return index >= 0 ? this._values[index] : undefined;
	                };
	                Map.prototype.set = function (key, value) {
	                    var index = this._find(key, /*insert*/ true);
	                    this._values[index] = value;
	                    return this;
	                };
	                Map.prototype.delete = function (key) {
	                    var index = this._find(key, /*insert*/ false);
	                    if (index >= 0) {
	                        var size = this._keys.length;
	                        for (var i = index + 1; i < size; i++) {
	                            this._keys[i - 1] = this._keys[i];
	                            this._values[i - 1] = this._values[i];
	                        }
	                        this._keys.length--;
	                        this._values.length--;
	                        if (SameValueZero(key, this._cacheKey)) {
	                            this._cacheKey = cacheSentinel;
	                            this._cacheIndex = -2;
	                        }
	                        return true;
	                    }
	                    return false;
	                };
	                Map.prototype.clear = function () {
	                    this._keys.length = 0;
	                    this._values.length = 0;
	                    this._cacheKey = cacheSentinel;
	                    this._cacheIndex = -2;
	                };
	                Map.prototype.keys = function () { return new MapIterator(this._keys, this._values, getKey); };
	                Map.prototype.values = function () { return new MapIterator(this._keys, this._values, getValue); };
	                Map.prototype.entries = function () { return new MapIterator(this._keys, this._values, getEntry); };
	                Map.prototype["@@iterator"] = function () { return this.entries(); };
	                Map.prototype[iteratorSymbol] = function () { return this.entries(); };
	                Map.prototype._find = function (key, insert) {
	                    if (!SameValueZero(this._cacheKey, key)) {
	                        this._cacheIndex = -1;
	                        for (var i = 0; i < this._keys.length; i++) {
	                            if (SameValueZero(this._keys[i], key)) {
	                                this._cacheIndex = i;
	                                break;
	                            }
	                        }
	                    }
	                    if (this._cacheIndex < 0 && insert) {
	                        this._cacheIndex = this._keys.length;
	                        this._keys.push(key);
	                        this._values.push(undefined);
	                    }
	                    return this._cacheIndex;
	                };
	                return Map;
	            }());
	            return Map;
	            function getKey(key, _) {
	                return key;
	            }
	            function getValue(_, value) {
	                return value;
	            }
	            function getEntry(key, value) {
	                return [key, value];
	            }
	        }
	        // naive Set shim
	        function CreateSetPolyfill() {
	            var Set = /** @class */ (function () {
	                function Set() {
	                    this._map = new _Map();
	                }
	                Object.defineProperty(Set.prototype, "size", {
	                    get: function () { return this._map.size; },
	                    enumerable: true,
	                    configurable: true
	                });
	                Set.prototype.has = function (value) { return this._map.has(value); };
	                Set.prototype.add = function (value) { return this._map.set(value, value), this; };
	                Set.prototype.delete = function (value) { return this._map.delete(value); };
	                Set.prototype.clear = function () { this._map.clear(); };
	                Set.prototype.keys = function () { return this._map.keys(); };
	                Set.prototype.values = function () { return this._map.keys(); };
	                Set.prototype.entries = function () { return this._map.entries(); };
	                Set.prototype["@@iterator"] = function () { return this.keys(); };
	                Set.prototype[iteratorSymbol] = function () { return this.keys(); };
	                return Set;
	            }());
	            return Set;
	        }
	        // naive WeakMap shim
	        function CreateWeakMapPolyfill() {
	            var UUID_SIZE = 16;
	            var keys = HashMap.create();
	            var rootKey = CreateUniqueKey();
	            return /** @class */ (function () {
	                function WeakMap() {
	                    this._key = CreateUniqueKey();
	                }
	                WeakMap.prototype.has = function (target) {
	                    var table = GetOrCreateWeakMapTable(target, /*create*/ false);
	                    return table !== undefined ? HashMap.has(table, this._key) : false;
	                };
	                WeakMap.prototype.get = function (target) {
	                    var table = GetOrCreateWeakMapTable(target, /*create*/ false);
	                    return table !== undefined ? HashMap.get(table, this._key) : undefined;
	                };
	                WeakMap.prototype.set = function (target, value) {
	                    var table = GetOrCreateWeakMapTable(target, /*create*/ true);
	                    table[this._key] = value;
	                    return this;
	                };
	                WeakMap.prototype.delete = function (target) {
	                    var table = GetOrCreateWeakMapTable(target, /*create*/ false);
	                    return table !== undefined ? delete table[this._key] : false;
	                };
	                WeakMap.prototype.clear = function () {
	                    // NOTE: not a real clear, just makes the previous data unreachable
	                    this._key = CreateUniqueKey();
	                };
	                return WeakMap;
	            }());
	            function CreateUniqueKey() {
	                var key;
	                do
	                    key = "@@WeakMap@@" + CreateUUID();
	                while (HashMap.has(keys, key));
	                keys[key] = true;
	                return key;
	            }
	            function GetOrCreateWeakMapTable(target, create) {
	                if (!hasOwn.call(target, rootKey)) {
	                    if (!create)
	                        return undefined;
	                    Object.defineProperty(target, rootKey, { value: HashMap.create() });
	                }
	                return target[rootKey];
	            }
	            function FillRandomBytes(buffer, size) {
	                for (var i = 0; i < size; ++i)
	                    buffer[i] = Math.random() * 0xff | 0;
	                return buffer;
	            }
	            function GenRandomBytes(size) {
	                if (typeof Uint8Array === "function") {
	                    var array = new Uint8Array(size);
	                    if (typeof crypto !== "undefined") {
	                        crypto.getRandomValues(array);
	                    }
	                    else if (typeof msCrypto !== "undefined") {
	                        msCrypto.getRandomValues(array);
	                    }
	                    else {
	                        FillRandomBytes(array, size);
	                    }
	                    return array;
	                }
	                return FillRandomBytes(new Array(size), size);
	            }
	            function CreateUUID() {
	                var data = GenRandomBytes(UUID_SIZE);
	                // mark as random - RFC 4122 § 4.4
	                data[6] = data[6] & 0x4f | 0x40;
	                data[8] = data[8] & 0xbf | 0x80;
	                var result = "";
	                for (var offset = 0; offset < UUID_SIZE; ++offset) {
	                    var byte = data[offset];
	                    if (offset === 4 || offset === 6 || offset === 8)
	                        result += "-";
	                    if (byte < 16)
	                        result += "0";
	                    result += byte.toString(16).toLowerCase();
	                }
	                return result;
	            }
	        }
	        // uses a heuristic used by v8 and chakra to force an object into dictionary mode.
	        function MakeDictionary(obj) {
	            obj.__ = undefined;
	            delete obj.__;
	            return obj;
	        }
	    });
	})(Reflect || (Reflect = {}));
	return _Reflect;
}

require_Reflect();

function e(e){return ("object"==typeof e&&null!==e||"function"==typeof e)&&"function"==typeof e.then}function t$1(e){switch(typeof e){case "string":case "symbol":return e.toString();case "function":return e.name;default:throw new Error(`Unexpected ${typeof e} service id type`)}}const n$1=Symbol.for("@inversifyjs/common/islazyServiceIdentifier");class r{[n$1];#e;constructor(e){this.#e=e,this[n$1]=true;}static is(e){return "object"==typeof e&&null!==e&&true===e[n$1]}unwrap(){return this.#e()}}

function c$2(t,n,e){return Reflect.getOwnMetadata(n,t,e)}function a$1(t,n,e,u){Reflect.defineMetadata(n,e,t,u);}function i$1(t,n,e,u,f){const r=u(c$2(t,n,f)??e());Reflect.defineMetadata(n,r,t,f);}

const a="@inversifyjs/container/bindingId";function c$1(){const i=c$2(Object,a)??0;return i===Number.MAX_SAFE_INTEGER?a$1(Object,a,Number.MIN_SAFE_INTEGER):i$1(Object,a,()=>i,e=>e+1),i}const d={Request:"Request",Singleton:"Singleton",Transient:"Transient"},u={ConstantValue:"ConstantValue",DynamicValue:"DynamicValue",Factory:"Factory",Instance:"Instance",Provider:"Provider",ResolvedValue:"ResolvedValue",ServiceRedirection:"ServiceRedirection"};function*l$1(...e){for(const t of e)yield*t;}class p{#e;#t;#n;constructor(e){this.#e=new Map,this.#t={};for(const t of Reflect.ownKeys(e))this.#t[t]=new Map;this.#n=e;}add(e,t){this.#i(e).push(t);for(const n of Reflect.ownKeys(t))this.#o(n,t[n]).push(e);}clone(){const e=this.#r(),t=this.#s(),n=Reflect.ownKeys(this.#n),i=this._buildNewInstance(this.#n);this.#a(this.#e,i.#e,e,t);for(const t of n)this.#c(this.#t[t],i.#t[t],e);return i}get(e,t){return this.#t[e].get(t)}getAllKeys(e){return this.#t[e].keys()}removeByRelation(e,t){const n=this.get(e,t);if(void 0===n)return;const i=new Set(n);for(const n of i){const i=this.#e.get(n);if(void 0===i)throw new Error("Expecting model relation, none found");for(const o of i)o[e]===t&&this.#d(n,o);this.#e.delete(n);}}_buildNewInstance(e){return new p(e)}_cloneModel(e){return e}_cloneRelation(e){return e}#r(){const e=new Map;for(const t of this.#e.keys()){const n=this._cloneModel(t);e.set(t,n);}return e}#s(){const e=new Map;for(const t of this.#e.values())for(const n of t){const t=this._cloneRelation(n);e.set(n,t);}return e}#i(e){let t=this.#e.get(e);return void 0===t&&(t=[],this.#e.set(e,t)),t}#o(e,t){let n=this.#t[e].get(t);return void 0===n&&(n=[],this.#t[e].set(t,n)),n}#u(e,t){const n=t.get(e);if(void 0===n)throw new Error("Expecting model to be cloned, none found");return n}#l(e,t){const n=t.get(e);if(void 0===n)throw new Error("Expecting relation to be cloned, none found");return n}#c(e,t,n){for(const[i,o]of e){const e=new Array;for(const t of o)e.push(this.#u(t,n));t.set(i,e);}}#a(e,t,n,i){for(const[o,r]of e){const e=new Array;for(const t of r)e.push(this.#l(t,i));t.set(this.#u(o,n),e);}}#d(e,t){for(const n of Reflect.ownKeys(t))this.#p(e,n,t[n]);}#p(e,t,n){const i=this.#t[t].get(n);if(void 0!==i){const o=i.indexOf(e);-1!==o&&i.splice(o,1),0===i.length&&this.#t[t].delete(n);}}}var f;!function(e){e.moduleId="moduleId",e.serviceId="serviceId";}(f||(f={}));class v{#f;#v;constructor(e,t){this.#f=t??new p({moduleId:{isOptional:true},serviceId:{isOptional:false}}),this.#v=e;}static build(e){return new v(e)}add(e,t){this.#f.add(e,t);}clone(){return new v(this.#v,this.#f.clone())}get(e){const t=[],n=this.#f.get(f.serviceId,e);void 0!==n&&t.push(n);const i=this.#v()?.get(e);if(void 0!==i&&t.push(i),0!==t.length)return l$1(...t)}removeAllByModuleId(e){this.#f.removeByRelation(f.moduleId,e);}removeAllByServiceId(e){this.#f.removeByRelation(f.serviceId,e);}}const h="@inversifyjs/core/classMetadataReflectKey";function g$1(){return {constructorArguments:[],lifecycle:{postConstructMethodNames:new Set,preDestroyMethodNames:new Set},properties:new Map,scope:void 0}}const m="@inversifyjs/core/pendingClassMetadataCountReflectKey";const y=Symbol.for("@inversifyjs/core/InversifyCoreError");let M$1 = class M extends Error{[y];kind;constructor(e,t,n){super(t,n),this[y]=true,this.kind=e;}static is(e){return "object"==typeof e&&null!==e&&true===e[y]}static isErrorOfKind(e,t){return M.is(e)&&e.kind===t}};var I$1,b,w,C$1,S$1;function N$1(t){const n=c$2(t,h)??g$1();if(!function(t){const n=c$2(t,m);return void 0!==n&&0!==n}(t))return function(e,t){const n=[];if(t.length<e.length)throw new M$1(I$1.missingInjectionDecorator,`Found unexpected missing metadata on type "${e.name}". "${e.name}" constructor requires at least ${e.length.toString()} arguments, found ${t.length.toString()} instead.\nAre you using @inject, @multiInject or @unmanaged decorators in every non optional constructor argument?\n\nIf you're using typescript and want to rely on auto injection, set "emitDecoratorMetadata" compiler option to true`);for(let e=0;e<t.length;++e) void 0===t[e]&&n.push(e);if(n.length>0)throw new M$1(I$1.missingInjectionDecorator,`Found unexpected missing metadata on type "${e.name}" at constructor indexes "${n.join('", "')}".\n\nAre you using @inject, @multiInject or @unmanaged decorators at those indexes?\n\nIf you're using typescript and want to rely on auto injection, set "emitDecoratorMetadata" compiler option to true`)}(t,n.constructorArguments),n;!function(e,t){const n=[];for(let i=0;i<t.constructorArguments.length;++i){const o=t.constructorArguments[i];void 0!==o&&o.kind!==b.unknown||n.push(`  - Missing or incomplete metadata for type "${e.name}" at constructor argument with index ${i.toString()}.\nEvery constructor parameter must be decorated either with @inject, @multiInject or @unmanaged decorator.`);}for(const[i,o]of t.properties)o.kind===b.unknown&&n.push(`  - Missing or incomplete metadata for type "${e.name}" at property "${i.toString()}".\nThis property must be decorated either with @inject or @multiInject decorator.`);if(0===n.length)throw new M$1(I$1.unknown,`Unexpected class metadata for type "${e.name}" with uncompletion traces.\nThis might be caused by one of the following reasons:\n\n1. A third party library is targeting inversify reflection metadata.\n2. A bug is causing the issue. Consider submiting an issue to fix it.`);throw new M$1(I$1.missingInjectionDecorator,`Invalid class metadata at type ${e.name}:\n\n${n.join("\n\n")}`)}(t,n);}function P$1(e,t){const n=N$1(t).scope??e.scope;return {cache:{isRight:false,value:void 0},id:c$1(),implementationType:t,isSatisfiedBy:()=>true,moduleId:void 0,onActivation:void 0,onDeactivation:void 0,scope:n,serviceIdentifier:t,type:u.Instance}}function A$2(e){return e.isRight?{isRight:true,value:e.value}:e}function R(e){switch(e.type){case u.ConstantValue:case u.DynamicValue:return function(e){return {cache:A$2(e.cache),id:e.id,isSatisfiedBy:e.isSatisfiedBy,moduleId:e.moduleId,onActivation:e.onActivation,onDeactivation:e.onDeactivation,scope:e.scope,serviceIdentifier:e.serviceIdentifier,type:e.type,value:e.value}}(e);case u.Factory:return function(e){return {cache:A$2(e.cache),factory:e.factory,id:e.id,isSatisfiedBy:e.isSatisfiedBy,moduleId:e.moduleId,onActivation:e.onActivation,onDeactivation:e.onDeactivation,scope:e.scope,serviceIdentifier:e.serviceIdentifier,type:e.type}}(e);case u.Instance:return function(e){return {cache:A$2(e.cache),id:e.id,implementationType:e.implementationType,isSatisfiedBy:e.isSatisfiedBy,moduleId:e.moduleId,onActivation:e.onActivation,onDeactivation:e.onDeactivation,scope:e.scope,serviceIdentifier:e.serviceIdentifier,type:e.type}}(e);case u.Provider:return function(e){return {cache:A$2(e.cache),id:e.id,isSatisfiedBy:e.isSatisfiedBy,moduleId:e.moduleId,onActivation:e.onActivation,onDeactivation:e.onDeactivation,provider:e.provider,scope:e.scope,serviceIdentifier:e.serviceIdentifier,type:e.type}}(e);case u.ResolvedValue:return function(e){return {cache:A$2(e.cache),factory:e.factory,id:e.id,isSatisfiedBy:e.isSatisfiedBy,metadata:e.metadata,moduleId:e.moduleId,onActivation:e.onActivation,onDeactivation:e.onDeactivation,scope:e.scope,serviceIdentifier:e.serviceIdentifier,type:e.type}}(e);case u.ServiceRedirection:return function(e){return {id:e.id,isSatisfiedBy:e.isSatisfiedBy,moduleId:e.moduleId,serviceIdentifier:e.serviceIdentifier,targetServiceIdentifier:e.targetServiceIdentifier,type:e.type}}(e)}}!function(e){e[e.injectionDecoratorConflict=0]="injectionDecoratorConflict",e[e.missingInjectionDecorator=1]="missingInjectionDecorator",e[e.planning=2]="planning",e[e.resolution=3]="resolution",e[e.unknown=4]="unknown";}(I$1||(I$1={})),function(e){e[e.unknown=32]="unknown";}(b||(b={})),function(e){e.id="id",e.moduleId="moduleId",e.serviceId="serviceId";}(w||(w={}));let x$3 = class x extends p{_buildNewInstance(e){return new x(e)}_cloneModel(e){return R(e)}};let T$2 = class T{#h;#g;#v;constructor(e,t,n){this.#g=n??new x$3({id:{isOptional:false},moduleId:{isOptional:true},serviceId:{isOptional:false}}),this.#v=e,this.#h=t;}static build(e,t){return new T(e,t)}clone(){return new T(this.#v,this.#h,this.#g.clone())}get(e){const t=this.getNonParentBindings(e)??this.#v()?.get(e);if(void 0!==t)return t;const n=this.#m(e);return void 0===n?n:[n]}*getChained(e){const t=this.getNonParentBindings(e);void 0!==t&&(yield*t);const n=this.#v();if(void 0===n){if(void 0===t){const t=this.#m(e);void 0!==t&&(yield t);}}else yield*n.getChained(e);}getBoundServices(){const e=new Set(this.#g.getAllKeys(w.serviceId)),t=this.#v();if(void 0!==t)for(const n of t.getBoundServices())e.add(n);return e}getById(e){return this.#g.get(w.id,e)??this.#v()?.getById(e)}getByModuleId(e){return this.#g.get(w.moduleId,e)??this.#v()?.getByModuleId(e)}getNonParentBindings(e){return this.#g.get(w.serviceId,e)}getNonParentBoundServices(){return this.#g.getAllKeys(w.serviceId)}removeById(e){this.#g.removeByRelation(w.id,e);}removeAllByModuleId(e){this.#g.removeByRelation(w.moduleId,e);}removeAllByServiceId(e){this.#g.removeByRelation(w.serviceId,e);}set(e){const t={[w.id]:e.id,[w.serviceId]:e.serviceIdentifier};void 0!==e.moduleId&&(t[w.moduleId]=e.moduleId),this.#g.add(e,t);}#m(e){if(void 0===this.#h||"function"!=typeof e)return;const t=P$1(this.#h,e);return this.set(t),t}};!function(e){e.moduleId="moduleId",e.serviceId="serviceId";}(C$1||(C$1={}));let j$2 = class j{#y;#v;constructor(e,t){this.#y=t??new p({moduleId:{isOptional:true},serviceId:{isOptional:false}}),this.#v=e;}static build(e){return new j(e)}add(e,t){this.#y.add(e,t);}clone(){return new j(this.#v,this.#y.clone())}get(e){const t=[],n=this.#y.get(C$1.serviceId,e);void 0!==n&&t.push(n);const i=this.#v()?.get(e);if(void 0!==i&&t.push(i),0!==t.length)return l$1(...t)}removeAllByModuleId(e){this.#y.removeByRelation(C$1.moduleId,e);}removeAllByServiceId(e){this.#y.removeByRelation(C$1.serviceId,e);}};!function(e){e[e.multipleInjection=0]="multipleInjection",e[e.singleInjection=1]="singleInjection",e[e.unmanaged=2]="unmanaged";}(S$1||(S$1={}));var E$1;!function(e){e[e.method=0]="method",e[e.parameter=1]="parameter",e[e.property=2]="property";}(E$1||(E$1={}));const K$1="@inversifyjs/core/classIsInjectableFlagReflectKey";const q$1=[Array,BigInt,Boolean,Function,Number,Object,String];function G$1(t){const i=c$2(t,"design:paramtypes");void 0!==i&&i$1(t,h,g$1,function(e){return t=>(e.forEach((e,n)=>{var i;void 0!==t.constructorArguments[n]||(i=e,q$1.includes(i))||(t.constructorArguments[n]=function(e){return {isFromTypescriptParamType:true,kind:S$1.singleInjection,name:void 0,optional:false,tags:new Map,value:e}}(e));}),t)}(i));}function W$2(i){return o=>{!function(n){if(void 0!==c$2(n,K$1))throw new M$1(I$1.injectionDecoratorConflict,`Cannot apply @injectable decorator multiple times at class "${n.name}"`);a$1(n,K$1,true);}(o),G$1(o);}}var fe;function ve(e){if(!(e instanceof Error))return  false;return e instanceof RangeError&&/stack space|call stack|too much recursion/i.test(e.message)||"InternalError"===e.name&&/too much recursion/.test(e.message)}function he(e,t){if(ve(t)){const n=function(e){const t=[...e];if(0===t.length)return "(No dependency trace)";return t.map(t$1).join(" -> ")}(function(e){const t=new Set;for(const n of e.servicesBranch){if(t.has(n))return [...t,n];t.add(n);}return [...t]}(e));throw new M$1(I$1.planning,`Circular dependency found: ${n}`,{cause:t})}throw t}!function(e){e[e.multipleInjection=0]="multipleInjection",e[e.singleInjection=1]="singleInjection";}(fe||(fe={}));const ge=Symbol.for("@inversifyjs/core/LazyPlanServiceNode");class me{[ge];_serviceIdentifier;_serviceNode;constructor(e,t){this[ge]=true,this._serviceNode=e,this._serviceIdentifier=t;}get bindings(){return this._getNode().bindings}get isContextFree(){return this._getNode().isContextFree}get serviceIdentifier(){return this._serviceIdentifier}set bindings(e){this._getNode().bindings=e;}set isContextFree(e){this._getNode().isContextFree=e;}static is(e){return "object"==typeof e&&null!==e&&true===e[ge]}invalidate(){this._serviceNode=void 0;}isExpanded(){return void 0!==this._serviceNode}_getNode(){return void 0===this._serviceNode&&(this._serviceNode=this._buildPlanServiceNode()),this._serviceNode}}class ye{#M;constructor(e){this.#M=e;}get name(){return this.#M.elem.name}get serviceIdentifier(){return this.#M.elem.serviceIdentifier}get tags(){return this.#M.elem.tags}getAncestor(){if(this.#M.elem.getAncestorsCalled=true,void 0!==this.#M.previous)return new ye(this.#M.previous)}}function Me(e,t,n){const i=n?.customServiceIdentifier??t.serviceIdentifier,o=(true===n?.chained?[...e.operations.getBindingsChained(i)]:[...e.operations.getBindings(i)??[]]).filter(e=>e.isSatisfiedBy(t));if(0===o.length&&void 0!==e.autobindOptions&&"function"==typeof i){const n=P$1(e.autobindOptions,i);e.operations.setBinding(n),n.isSatisfiedBy(t)&&o.push(n);}return o}class Ie{last;constructor(e){this.last=e;}concat(e){return new Ie({elem:e,previous:this.last})}[Symbol.iterator](){let e=this.last;return {next:()=>{if(void 0===e)return {done:true,value:void 0};const t=e.elem;return e=e.previous,{done:false,value:t}}}}}function be(e){const t=new Map;return void 0!==e.rootConstraints.tag&&t.set(e.rootConstraints.tag.key,e.rootConstraints.tag.value),new Ie({elem:{getAncestorsCalled:false,name:e.rootConstraints.name,serviceIdentifier:e.rootConstraints.serviceIdentifier,tags:t},previous:void 0})}function we(e){return void 0!==e.redirections}function Ce(e,t,n,i){const r=n.elem.serviceIdentifier,s=n.previous?.elem.serviceIdentifier;Array.isArray(e)?function(e,t,n,i,r,s){if(0!==e.length){const t=s[s.length-1]??n,a=`Ambiguous bindings found for service: "${t$1(t)}".${Ae(s)}\n\nRegistered bindings:\n\n${e.map(e=>function(e){switch(e.type){case u.Instance:return `[ type: "${e.type}", serviceIdentifier: "${t$1(e.serviceIdentifier)}", scope: "${e.scope}", implementationType: "${e.implementationType.name}" ]`;case u.ServiceRedirection:return `[ type: "${e.type}", serviceIdentifier: "${t$1(e.serviceIdentifier)}", redirection: "${t$1(e.targetServiceIdentifier)}" ]`;default:return `[ type: "${e.type}", serviceIdentifier: "${t$1(e.serviceIdentifier)}", scope: "${e.scope}" ]`}}(e.binding)).join("\n")}\n\nTrying to resolve bindings for "${Ne(n,i)}".${Pe(r)}`;throw new M$1(I$1.planning,a)}t||Se(n,i,r,s);}(e,t,r,s,n.elem,i):function(e,t,n,i,o,r){ void 0!==e||t||Se(n,i,o,r);}(e,t,r,s,n.elem,i);}function Se(e,t,n,i){const r=i[i.length-1]??e,s=`No bindings found for service: "${t$1(r)}".\n\nTrying to resolve bindings for "${Ne(e,t)}".${Ae(i)}${Pe(n)}`;throw new M$1(I$1.planning,s)}function Ne(e,t){return void 0===t?`${t$1(e)} (Root service)`:t$1(t)}function Pe(e){const t=0===e.tags.size?"":`\n- tags:\n  - ${[...e.tags.keys()].map(e=>e.toString()).join("\n  - ")}`;return `\n\nBinding constraints:\n- service identifier: ${t$1(e.serviceIdentifier)}\n- name: ${e.name?.toString()??"-"}${t}`}function Ae(e){return 0===e.length?"":`\n\n- service redirections:\n  - ${e.map(e=>t$1(e)).join("\n  - ")}`}function Re(e,t,n,i){if(1===e.redirections.length){const[o]=e.redirections;return void(we(o)&&Re(o,t,n,[...i,o.binding.targetServiceIdentifier]))}Ce(e.redirections,t,n,i);}function xe(e,t,n){if(Array.isArray(e.bindings)&&1===e.bindings.length){const[i]=e.bindings;return void(we(i)&&Re(i,t,n,[i.binding.targetServiceIdentifier]))}Ce(e.bindings,t,n,[]);}function Te(e){return r.is(e)?e.unwrap():e}function je(e){return (t,n,i)=>{const o=Te(i.value),r=n.concat({getAncestorsCalled:false,name:i.name,serviceIdentifier:o,tags:i.tags}),s=new ye(r.last),a=i.kind===S$1.multipleInjection&&i.chained,c=Me(t,s,{chained:a}),d=[],u={bindings:d,isContextFree:true,serviceIdentifier:o};if(d.push(...e(t,r,c,u,a)),u.isContextFree=!r.last.elem.getAncestorsCalled,i.kind===S$1.singleInjection){xe(u,i.optional,r.last);const[e]=d;u.bindings=e;}return u}}function Be(e){return (t,n,i)=>{const o=Te(i.value),r=n.concat({getAncestorsCalled:false,name:i.name,serviceIdentifier:o,tags:i.tags}),s=new ye(r.last),a=i.kind===fe.multipleInjection&&i.chained,c=Me(t,s,{chained:a}),d=[],u={bindings:d,isContextFree:true,serviceIdentifier:o};if(d.push(...e(t,r,c,u,a)),u.isContextFree=!r.last.elem.getAncestorsCalled,i.kind===fe.singleInjection){xe(u,i.optional,r.last);const[e]=d;u.bindings=e;}return u}}function Fe(e){const t=function(e){return (t,n,i)=>{const o={binding:n,classMetadata:t.operations.getClassMetadata(n.implementationType),constructorParams:[],propertyParams:new Map},r={autobindOptions:t.autobindOptions,node:o,operations:t.operations,servicesBranch:t.servicesBranch};return e(r,i)}}(e),n=function(e){return (t,n,i)=>{const o={binding:n,params:[]},r={autobindOptions:t.autobindOptions,node:o,operations:t.operations,servicesBranch:t.servicesBranch};return e(r,i)}}(e),i=(e,i,r,s,a)=>{const c=we(s)?s.binding.targetServiceIdentifier:s.serviceIdentifier;e.servicesBranch.push(c);const d=[];for(const s of r)switch(s.type){case u.Instance:d.push(t(e,s,i));break;case u.ResolvedValue:d.push(n(e,s,i));break;case u.ServiceRedirection:{const t=o(e,i,s,a);d.push(t);break}default:d.push({binding:s});}return e.servicesBranch.pop(),d},o=function(e){return (t,n,i,o)=>{const r={binding:i,redirections:[]},s=Me(t,new ye(n.last),{chained:o,customServiceIdentifier:i.targetServiceIdentifier});return r.redirections.push(...e(t,n,s,r,o)),r}}(i);return i}function ke(e,t,n,i){if(void 0!==e&&(me.is(n)&&!n.isExpanded()||n.isContextFree)){const i={tree:{root:n}};t.setPlan(e,i);}else t.setNonCachedServiceNode(n,i);}class $e extends me{#I;#b;#w;#C;constructor(e,t,n,i,o){super(o,Te(i.value)),this.#b=t,this.#I=e,this.#w=n,this.#C=i;}_buildPlanServiceNode(){return this.#b(this.#I,this.#w,this.#C)}}class De extends me{#I;#S;#w;#N;constructor(e,t,n,i,o){super(o,Te(i.value)),this.#I=e,this.#S=t,this.#w=n,this.#N=i;}_buildPlanServiceNode(){return this.#S(this.#I,this.#w,this.#N)}}function Ve(e,t,n,i){const o=function(e,t){const n=function(e,t){return (n,i,o)=>{if(o.kind===S$1.unmanaged)return;const s=function(e){let t;if(0===e.tags.size)t=void 0;else {if(1!==e.tags.size)return;{const[n,i]=e.tags.entries().next().value;t={key:n,value:i};}}const n=r.is(e.value)?e.value.unwrap():e.value;return e.kind===S$1.multipleInjection?{chained:e.chained,isMultiple:true,name:e.name,optional:e.optional,serviceIdentifier:n,tag:t}:{isMultiple:false,name:e.name,optional:e.optional,serviceIdentifier:n,tag:t}}(o);if(void 0!==s){const e=n.operations.getPlan(s);if(void 0!==e&&e.tree.root.isContextFree)return e.tree.root}const a=t(n,i,o),c=new $e(n,e,i,o,a);return ke(s,n.operations,c,{bindingConstraintsList:i,chainedBindings:o.kind===S$1.multipleInjection&&o.chained,optionalBindings:o.optional}),c}}(e,t);return (e,t,i)=>{const o=t.classMetadata;for(const[r,s]of o.constructorArguments.entries())t.constructorParams[r]=n(e,i,s);for(const[r,s]of o.properties){const o=n(e,i,s);void 0!==o&&t.propertyParams.set(r,o);}return e.node}}(e,n),s=function(e,t){const n=function(e,t){return (n,i,o)=>{const s=function(e){let t;if(0===e.tags.size)t=void 0;else {if(1!==e.tags.size)return;{const[n,i]=e.tags.entries().next().value;t={key:n,value:i};}}const n=r.is(e.value)?e.value.unwrap():e.value;return e.kind===fe.multipleInjection?{chained:e.chained,isMultiple:true,name:e.name,optional:e.optional,serviceIdentifier:n,tag:t}:{isMultiple:false,name:e.name,optional:e.optional,serviceIdentifier:n,tag:t}}(o);if(void 0!==s){const e=n.operations.getPlan(s);if(void 0!==e&&e.tree.root.isContextFree)return e.tree.root}const a=t(n,i,o),c=new De(n,e,i,o,a);return ke(s,n.operations,c,{bindingConstraintsList:i,chainedBindings:o.kind===fe.multipleInjection&&o.chained,optionalBindings:o.optional}),c}}(e,t);return (e,t,i)=>{const o=t.binding.metadata;for(const[r,s]of o.arguments.entries())t.params[r]=n(e,i,s);return e.node}}(t,i);return (e,t)=>e.node.binding.type===u.Instance?o(e,e.node,t):s(e,e.node,t)}class Oe extends me{#I;constructor(e,t){super(t,t.serviceIdentifier),this.#I=e;}_buildPlanServiceNode(){return Ue(this.#I)}}const Ee=je(Le),_e=Be(Le),ze=Fe(Ve(Ee,_e,Ee,_e));function Le(e,t,n,i,o){return ze(e,t,n,i,o)}const Ue=function(e){return t=>{const n=be(t),i=new ye(n.last),o=t.rootConstraints.isMultiple&&t.rootConstraints.chained,r=Me(t,i,{chained:o}),s=[],a={bindings:s,isContextFree:true,serviceIdentifier:t.rootConstraints.serviceIdentifier};if(s.push(...e(t,n,r,a,o)),a.isContextFree=!n.last.elem.getAncestorsCalled,!t.rootConstraints.isMultiple){xe(a,t.rootConstraints.isOptional??false,n.last);const[e]=s;a.bindings=e;}return a}}(ze);function Ke(e){try{const t=function(e){return e.rootConstraints.isMultiple?{chained:e.rootConstraints.chained,isMultiple:!0,name:e.rootConstraints.name,optional:e.rootConstraints.isOptional??!1,serviceIdentifier:e.rootConstraints.serviceIdentifier,tag:e.rootConstraints.tag}:{isMultiple:!1,name:e.rootConstraints.name,optional:e.rootConstraints.isOptional??!1,serviceIdentifier:e.rootConstraints.serviceIdentifier,tag:e.rootConstraints.tag}}(e),n=e.operations.getPlan(t);if(void 0!==n)return n;const i=Ue(e),o={tree:{root:new Oe(e,i)}};return e.operations.setPlan(t,o),o}catch(t){he(e,t);}}var qe;!function(e){e.bindingAdded="bindingAdded",e.bindingRemoved="bindingRemoved";}(qe||(qe={}));class Ge{#P;#A;#R;constructor(){this.#P=[],this.#A=8,this.#R=1024;}*[Symbol.iterator](){let e=0;for(const t of this.#P){const n=t.deref();void 0===n?++e:yield n;}this.#P.length>=this.#A&&this.#x(e)&&this.#T(e);}push(e){const t=new WeakRef(e);if(this.#P.push(t),this.#P.length>=this.#A&&this.#P.length%this.#R===0){let e=0;for(const t of this.#P) void 0===t.deref()&&++e;this.#x(e)&&this.#T(e);}}#T(e){const t=new Array(this.#P.length-e);let n=0;for(const e of this.#P)e.deref()&&(t[n++]=e);this.#P=t;}#x(e){return e>=.5*this.#P.length}}const We=Fe(Ve(Ee,_e,function(e,t,n){return Xe(e,t,n)},function(e,t,n){return He(e,t,n)})),Xe=function(e){const t=je(e);return (e,n,i)=>{try{return t(e,n,i)}catch(e){if(M$1.isErrorOfKind(e,I$1.planning))return;throw e}}}(We),He=function(e){const t=Be(e);return (e,n,i)=>{try{return t(e,n,i)}catch(e){if(M$1.isErrorOfKind(e,I$1.planning))return;throw e}}}(We);function Je(e,t,n,i,o){if(me.is(t)&&!t.isExpanded())return {isContextFreeBinding:true,shouldInvalidateServiceNode:false};const r=new ye(i.last);return !n.isSatisfiedBy(r)||i.last.elem.getAncestorsCalled?{isContextFreeBinding:!i.last.elem.getAncestorsCalled,shouldInvalidateServiceNode:false}:function(e,t,n,i,o){let r;try{[r]=We(e,i,[n],t,o);}catch(e){if(ve(e))return {isContextFreeBinding:false,shouldInvalidateServiceNode:true};throw e}return function(e,t){if(Array.isArray(e.bindings))e.bindings.push(t);else {if(void 0!==e.bindings){if(!me.is(e))throw new M$1(I$1.planning,"Unexpected non-lazy plan service node. This is likely a bug in the planning logic. Please, report this issue");return {isContextFreeBinding:true,shouldInvalidateServiceNode:true}}e.bindings=t;}return {isContextFreeBinding:true,shouldInvalidateServiceNode:false}}(t,r)}(e,t,n,i,o)}function Qe(e,t,n,i){if(me.is(e)&&!e.isExpanded())return {bindingNodeRemoved:void 0,isContextFreeBinding:true};const o=new ye(n.last);if(!t.isSatisfiedBy(o)||n.last.elem.getAncestorsCalled)return {bindingNodeRemoved:void 0,isContextFreeBinding:!n.last.elem.getAncestorsCalled};let r;if(Array.isArray(e.bindings))e.bindings=e.bindings.filter(e=>e.binding!==t||(r=e,false));else if(e.bindings?.binding===t)if(r=e.bindings,i)e.bindings=void 0;else {if(!me.is(e))throw new M$1(I$1.planning,"Unexpected non-lazy plan service node. This is likely a bug in the planning logic. Please, report this issue");e.invalidate();}return {bindingNodeRemoved:r,isContextFreeBinding:true}}class Ye{#j;#B;#F;#k;#$;#D;constructor(){this.#j=new Map,this.#B=this.#V(),this.#F=this.#V(),this.#k=this.#V(),this.#$=this.#V(),this.#D=new Ge;}clearCache(){for(const e of this.#O())e.clear();for(const e of this.#D)e.clearCache();}get(e){return void 0===e.name?void 0===e.tag?this.#E(this.#B,e).get(e.serviceIdentifier):this.#E(this.#$,e).get(e.serviceIdentifier)?.get(e.tag.key)?.get(e.tag.value):void 0===e.tag?this.#E(this.#F,e).get(e.serviceIdentifier)?.get(e.name):this.#E(this.#k,e).get(e.serviceIdentifier)?.get(e.name)?.get(e.tag.key)?.get(e.tag.value)}invalidateServiceBinding(e){this.#_(e),this.#z(e),this.#L(e),this.#U(e),this.#K(e);for(const t of this.#D)t.invalidateServiceBinding(e);}set(e,t){ void 0===e.name?void 0===e.tag?this.#E(this.#B,e).set(e.serviceIdentifier,t):this.#q(this.#q(this.#E(this.#$,e),e.serviceIdentifier),e.tag.key).set(e.tag.value,t):void 0===e.tag?this.#q(this.#E(this.#F,e),e.serviceIdentifier).set(e.name,t):this.#q(this.#q(this.#q(this.#E(this.#k,e),e.serviceIdentifier),e.name),e.tag.key).set(e.tag.value,t);}setNonCachedServiceNode(e,t){let n=this.#j.get(e.serviceIdentifier);void 0===n&&(n=new Map,this.#j.set(e.serviceIdentifier,n)),n.set(e,t);}subscribe(e){this.#D.push(e);}#V(){const e=new Array(8);for(let t=0;t<e.length;++t)e[t]=new Map;return e}#G(e,t,n,i){const o=!!(2&t);let r;if(o){r={chained:!!(0&t),isMultiple:o,serviceIdentifier:e.binding.serviceIdentifier};}else r={isMultiple:o,serviceIdentifier:e.binding.serviceIdentifier};return !!(1&t)&&(r.isOptional=true),void 0!==n&&(r.name=n),void 0!==i&&(r.tag=i),{autobindOptions:void 0,operations:e.operations,rootConstraints:r,servicesBranch:[]}}#q(e,t){let n=e.get(t);return void 0===n&&(n=new Map,e.set(t,n)),n}#E(e,t){return e[this.#W(t)]}#O(){return [this.#j,...this.#B,...this.#F,...this.#k,...this.#$]}#W(e){return e.isMultiple?(e.chained?4:0)|(e.optional?1:0)|2:e.optional?1:0}#z(e){for(const[t,n]of this.#F.entries()){const i=n.get(e.binding.serviceIdentifier);if(void 0!==i)for(const[n,o]of i.entries())this.#X(e,o,t,n,void 0);}}#L(e){for(const[t,n]of this.#k.entries()){const i=n.get(e.binding.serviceIdentifier);if(void 0!==i)for(const[n,o]of i.entries())for(const[i,r]of o.entries())for(const[o,s]of r.entries())this.#X(e,s,t,n,{key:i,value:o});}}#H(e){switch(e.binding.type){case u.ServiceRedirection:for(const t of e.redirections)this.#H(t);break;case u.Instance:for(const t of e.constructorParams) void 0!==t&&this.#J(t);for(const t of e.propertyParams.values())this.#J(t);break;case u.ResolvedValue:for(const t of e.params)this.#J(t);}}#J(e){const t=this.#j.get(e.serviceIdentifier);void 0!==t&&t.has(e)&&(t.delete(e),this.#Q(e));}#Q(e){if((!me.is(e)||e.isExpanded())&&void 0!==e.bindings)if(Array.isArray(e.bindings))for(const t of e.bindings)this.#H(t);else this.#H(e.bindings);}#K(e){const t=this.#j.get(e.binding.serviceIdentifier);if(void 0!==t)switch(e.kind){case qe.bindingAdded:for(const[n,i]of t){const t=Je({autobindOptions:void 0,operations:e.operations,servicesBranch:[]},n,e.binding,i.bindingConstraintsList,i.chainedBindings);t.isContextFreeBinding?t.shouldInvalidateServiceNode&&me.is(n)&&(this.#Q(n),n.invalidate()):this.clearCache();}break;case qe.bindingRemoved:for(const[n,i]of t){const t=Qe(n,e.binding,i.bindingConstraintsList,i.optionalBindings);t.isContextFreeBinding?void 0!==t.bindingNodeRemoved&&this.#H(t.bindingNodeRemoved):this.clearCache();}}}#_(e){for(const[t,n]of this.#B.entries()){const i=n.get(e.binding.serviceIdentifier);this.#X(e,i,t,void 0,void 0);}}#U(e){for(const[t,n]of this.#$.entries()){const i=n.get(e.binding.serviceIdentifier);if(void 0!==i)for(const[n,o]of i.entries())for(const[i,r]of o.entries())this.#X(e,r,t,void 0,{key:n,value:i});}}#X(e,t,n,i,o){if(void 0!==t&&me.is(t.tree.root)){const c=this.#G(e,n,i,o);switch(e.kind){case qe.bindingAdded:{const n=(r=c,s=t.tree.root,a=e.binding,me.is(s)&&!s.isExpanded()?{isContextFreeBinding:true,shouldInvalidateServiceNode:false}:Je(r,s,a,be(r),r.rootConstraints.isMultiple&&r.rootConstraints.chained));n.isContextFreeBinding?n.shouldInvalidateServiceNode&&(this.#Q(t.tree.root),t.tree.root.invalidate()):this.clearCache();}break;case qe.bindingRemoved:{const n=function(e,t,n){return me.is(t)&&!t.isExpanded()?{bindingNodeRemoved:void 0,isContextFreeBinding:true}:Qe(t,n,be(e),e.rootConstraints.isOptional??false)}(c,t.tree.root,e.binding);n.isContextFreeBinding?void 0!==n.bindingNodeRemoved&&this.#H(n.bindingNodeRemoved):this.clearCache();}}}var r,s,a;}}function Ze(e,t){if(ve(t)){const n=function(e){const t=[...e];if(0===t.length)return "(No dependency trace)";return t.map(t$1).join(" -> ")}(function(e){const t=e.planResult.tree.root,n=[];function i(e){const t=n.indexOf(e);if(-1!==t){return [...n.slice(t),e].map(e=>e.serviceIdentifier)}n.push(e);try{for(const t of function(e){const t=[],n=e.bindings;if(void 0===n)return t;const i=e=>{if(we(e))for(const t of e.redirections)i(t);else switch(e.binding.type){case u.Instance:{const n=e;for(const e of n.constructorParams)void 0!==e&&t.push(e);for(const e of n.propertyParams.values())t.push(e);break}case u.ResolvedValue:{const n=e;for(const e of n.params)t.push(e);break}}};if(Array.isArray(n))for(const e of n)i(e);else i(n);return t}(e)){const e=i(t);if(void 0!==e)return e}}finally{n.pop();}}return i(t)??[]}(e));throw new M$1(I$1.planning,`Circular dependency found: ${n}`,{cause:t})}throw t}function et$1(e$1,t){return e(t)?(e$1.cache={isRight:true,value:t},t.then(t=>tt(e$1,t))):tt(e$1,t)}function tt(e,t){return e.cache={isRight:true,value:t},t}function nt(e$1,t,n){const i=e$1.getActivations(t);return void 0===i?n:e(n)?it(e$1,n,i[Symbol.iterator]()):function(e$1,t,n){let i=t,o=n.next();for(;true!==o.done;){const t=o.value(e$1.context,i);if(e(t))return it(e$1,t,n);i=t,o=n.next();}return i}(e$1,n,i[Symbol.iterator]())}async function it(e,t,n){let i=await t,o=n.next();for(;true!==o.done;)i=await o.value(e.context,i),o=n.next();return i}function ot(e$1,t,n){let i=n;if(void 0!==t.onActivation){const n=t.onActivation;i=e(i)?i.then(t=>n(e$1.context,t)):n(e$1.context,i);}return nt(e$1,t.serviceIdentifier,i)}function rt(e){return (t,n)=>{if(n.cache.isRight)return n.cache.value;return et$1(n,ot(t,n,e(t,n)))}}const st=rt(function(e,t){return t.value});function at(e){return e}function ct(e,t){return (n,i)=>{const o=e(i);switch(o.scope){case d.Singleton:if(o.cache.isRight)return o.cache.value;return et$1(o,ot(n,o,t(n,i)));case d.Request:{if(n.requestScopeCache.has(o.id))return n.requestScopeCache.get(o.id);const e=ot(n,o,t(n,i));return n.requestScopeCache.set(o.id,e),e}case d.Transient:return ot(n,o,t(n,i))}}}const dt=(e=>ct(at,e))(function(e,t){return t.value(e.context)});const ut=rt(function(e,t){return t.factory(e.context)});function lt(e$1,t,n){const i=function(e$1,t,n){if(!(n in e$1))throw new M$1(I$1.resolution,`Expecting a "${n.toString()}" property when resolving "${t.implementationType.name}" class @postConstruct decorated method, none found.`);if("function"!=typeof e$1[n])throw new M$1(I$1.resolution,`Expecting a "${n.toString()}" method when resolving "${t.implementationType.name}" class @postConstruct decorated method, a non function property was found instead.`);{let i;try{i=e$1[n]();}catch(e){throw new M$1(I$1.resolution,`Unexpected error found when calling "${n.toString()}" @postConstruct decorated method on class "${t.implementationType.name}"`,{cause:e})}if(e(i))return async function(e,t,n){try{await n;}catch(n){throw new M$1(I$1.resolution,`Unexpected error found when calling "${t.toString()}" @postConstruct decorated method on class "${e.implementationType.name}"`,{cause:n})}}(t,n,i)}}(e$1,t,n);return e(i)?i.then(()=>e$1):e$1}function pt(e$1,t,n){if(0===n.size)return e$1;let i=e$1;for(const e$1 of n)i=e(i)?i.then(n=>lt(n,t,e$1)):lt(i,t,e$1);return i}function ft(e$1){return (t,n,i)=>{const o=new i.binding.implementationType(...t),r=e$1(n,o,i);return e(r)?r.then(()=>pt(o,i.binding,i.classMetadata.lifecycle.postConstructMethodNames)):pt(o,i.binding,i.classMetadata.lifecycle.postConstructMethodNames)}}const vt=rt(function(e,t){return t.provider(e.context)});function ht(e){return e.binding}function gt(e){return e.binding}const mt=function(e$1){return (t,n,i)=>{const o=[];for(const[r,a]of i.propertyParams){const c=i.classMetadata.properties.get(r);if(void 0===c)throw new M$1(I$1.resolution,`Expecting metadata at property "${r.toString()}", none found`);c.kind!==S$1.unmanaged&&void 0!==a.bindings&&(n[r]=e$1(t,a),e(n[r])&&o.push((async()=>{n[r]=await n[r];})()));}if(o.length>0)return Promise.all(o).then(()=>{})}}(Nt),yt=function(e){return function t(n,i){const o=[];for(const r of i.redirections)we(r)?o.push(...t(n,r)):o.push(e(n,r));return o}}(St),Mt=function(e$1,t,n){return (i,o)=>{const r=e$1(i,o);return e(r)?t(r,i,o):n(r,i,o)}}(function(e$1){return (t,n)=>{const i=[];for(const o of n.constructorParams) void 0===o?i.push(void 0):i.push(e$1(t,o));return i.some(e)?Promise.all(i):i}}(Nt),function(e){return async(t,n,i)=>{const o=await t;return e(o,n,i)}}(ft(mt)),ft(mt)),It=function(e$1){return (t,n)=>{const i=e$1(t,n);return e(i)?i.then(e=>n.binding.factory(...e)):n.binding.factory(...i)}}(function(e$1){return (t,n)=>{const i=[];for(const o of n.params)i.push(e$1(t,o));return i.some(e)?Promise.all(i):i}}(Nt)),bt=(e=>ct(ht,e))(Mt),wt=(e=>ct(gt,e))(It);function Ct(e){try{return Nt(e,e.planResult.tree.root)}catch(t){Ze(e,t);}}function St(e,t){switch(t.binding.type){case u.ConstantValue:return st(e,t.binding);case u.DynamicValue:return dt(e,t.binding);case u.Factory:return ut(e,t.binding);case u.Instance:return bt(e,t);case u.Provider:return vt(e,t.binding);case u.ResolvedValue:return wt(e,t)}}function Nt(e$1,t){if(void 0!==t.bindings)return Array.isArray(t.bindings)?function(e$1,t){const n=[];for(const i of t)we(i)?n.push(...yt(e$1,i)):n.push(St(e$1,i));if(n.some(e))return Promise.all(n);return n}(e$1,t.bindings):function(e,t){if(we(t)){const n=yt(e,t);if(1===n.length)return n[0];throw new M$1(I$1.resolution,"Unexpected multiple resolved values on single injection")}return St(e,t)}(e$1,t.bindings)}function Pt(e){return void 0!==e.scope}function At(e,t){if("function"==typeof e[t]){return e[t]()}}function Rt(e,t){const n=e.lifecycle.preDestroyMethodNames;if(0===n.size)return;let i;for(const e of n)i=void 0===i?At(t,e):i.then(()=>At(t,e));return i}function xt(e$1,t,n){const i=e$1.getDeactivations(t);if(void 0!==i)return e(n)?Tt(n,i[Symbol.iterator]()):function(e$1,t){let n=t.next();for(;true!==n.done;){const i=n.value(e$1);if(e(i))return Tt(e$1,t);n=t.next();}}(n,i[Symbol.iterator]())}async function Tt(e,t){const n=await e;let i=t.next();for(;true!==i.done;)await i.value(n),i=t.next();}function jt(e$1,t){const n=function(e$1,t){if(t.type===u.Instance){const n=e$1.getClassMetadata(t.implementationType),i=t.cache.value;return e(i)?i.then(e=>Rt(n,e)):Rt(n,i)}}(e$1,t);return void 0===n?Bt(e$1,t):n.then(()=>Bt(e$1,t))}function Bt(e$1,t){const n=t.cache;return e(n.value)?n.value.then(n=>Ft(e$1,t,n)):Ft(e$1,t,n.value)}function Ft(e,t,n){let i;if(void 0!==t.onDeactivation){i=(0, t.onDeactivation)(n);}return void 0===i?xt(e,t.serviceIdentifier,n):i.then(()=>xt(e,t.serviceIdentifier,n))}function kt(e,t){if(void 0===t)return;const n=function(e){const t=[];for(const n of e)Pt(n)&&n.scope===d.Singleton&&n.cache.isRight&&t.push(n);return t}(t),i=[];for(const t of n){const n=jt(e,t);void 0!==n&&i.push(n);}return i.length>0?Promise.all(i).then(()=>{}):void 0}function $t(e,t){const n=e.getBindingsFromModule(t);return kt(e,n)}function Dt(e,t){const n=e.getBindings(t);return kt(e,n)}

const t=Symbol.for("@inversifyjs/plugin/isPlugin");

const I=Symbol.for("@inversifyjs/container/bindingIdentifier");function A$1(e){return "object"==typeof e&&null!==e&&true===e[I]}class P{static always=e=>true}const C=Symbol.for("@inversifyjs/container/InversifyContainerError");class B extends Error{[C];kind;constructor(e,n,i){super(n,i),this[C]=true,this.kind=e;}static is(e){return "object"==typeof e&&null!==e&&true===e[C]}static isErrorOfKind(e,n){return B.is(e)&&e.kind===n}}var O;function x$2(e){return {[I]:true,id:e.id}}function k(e){return n=>{for(let i=n.getAncestor();void 0!==i;i=i.getAncestor())if(e(i))return  true;return  false}}function N(e){return n=>n.name===e}function F(e){return n=>n.serviceIdentifier===e}function U(e,n){return i=>i.tags.has(e)&&i.tags.get(e)===n}function D(e){return void 0===e.name&&0===e.tags.size}function j$1(e){const n=k(e);return e=>!n(e)}function T$1(e){return n=>{const i=n.getAncestor();return void 0===i||!e(i)}}function V(e){return n=>{const i=n.getAncestor();return void 0!==i&&e(i)}}!function(e){e[e.invalidOperation=0]="invalidOperation";}(O||(O={}));class E{#i;constructor(e){this.#i=e;}getIdentifier(){return x$2(this.#i)}inRequestScope(){return this.#i.scope=d.Request,new G(this.#i)}inSingletonScope(){return this.#i.scope=d.Singleton,new G(this.#i)}inTransientScope(){return this.#i.scope=d.Transient,new G(this.#i)}}let L$1 = class L{#t;#r;#a;#s;constructor(e,n,i,t){this.#t=e,this.#r=n,this.#a=i,this.#s=t;}to(e){const n=N$1(e),i={cache:{isRight:false,value:void 0},id:c$1(),implementationType:e,isSatisfiedBy:P.always,moduleId:this.#r,onActivation:void 0,onDeactivation:void 0,scope:n.scope??this.#a,serviceIdentifier:this.#s,type:u.Instance};return this.#t(i),new H(i)}toSelf(){if("function"!=typeof this.#s)throw new Error('"toSelf" function can only be applied when a newable function is used as service identifier');return this.to(this.#s)}toConstantValue(e){const n={cache:{isRight:false,value:void 0},id:c$1(),isSatisfiedBy:P.always,moduleId:this.#r,onActivation:void 0,onDeactivation:void 0,scope:d.Singleton,serviceIdentifier:this.#s,type:u.ConstantValue,value:e};return this.#t(n),new G(n)}toDynamicValue(e){const n={cache:{isRight:false,value:void 0},id:c$1(),isSatisfiedBy:P.always,moduleId:this.#r,onActivation:void 0,onDeactivation:void 0,scope:this.#a,serviceIdentifier:this.#s,type:u.DynamicValue,value:e};return this.#t(n),new H(n)}toResolvedValue(e,n){const i={cache:{isRight:false,value:void 0},factory:e,id:c$1(),isSatisfiedBy:P.always,metadata:this.#o(n),moduleId:this.#r,onActivation:void 0,onDeactivation:void 0,scope:this.#a,serviceIdentifier:this.#s,type:u.ResolvedValue};return this.#t(i),new H(i)}toFactory(e){const n={cache:{isRight:false,value:void 0},factory:e,id:c$1(),isSatisfiedBy:P.always,moduleId:this.#r,onActivation:void 0,onDeactivation:void 0,scope:d.Singleton,serviceIdentifier:this.#s,type:u.Factory};return this.#t(n),new G(n)}toProvider(e){const n={cache:{isRight:false,value:void 0},id:c$1(),isSatisfiedBy:P.always,moduleId:this.#r,onActivation:void 0,onDeactivation:void 0,provider:e,scope:d.Singleton,serviceIdentifier:this.#s,type:u.Provider};return this.#t(n),new G(n)}toService(e){const n={id:c$1(),isSatisfiedBy:P.always,moduleId:this.#r,serviceIdentifier:this.#s,targetServiceIdentifier:e,type:u.ServiceRedirection};this.#t(n);}#o(e){return {arguments:(e??[]).map(e=>function(e){return "object"==typeof e&&!r.is(e)}(e)?function(e){return  true===e.isMultiple}(e)?{chained:e.chained??false,kind:fe.multipleInjection,name:e.name,optional:e.optional??false,tags:new Map((e.tags??[]).map(e=>[e.key,e.value])),value:e.serviceIdentifier}:{kind:fe.singleInjection,name:e.name,optional:e.optional??false,tags:new Map((e.tags??[]).map(e=>[e.key,e.value])),value:e.serviceIdentifier}:{kind:fe.singleInjection,name:void 0,optional:false,tags:new Map,value:e})}}};class ${#i;constructor(e){this.#i=e;}getIdentifier(){return x$2(this.#i)}onActivation(e){return this.#i.onActivation=e,new q(this.#i)}onDeactivation(e){if(this.#i.onDeactivation=e,this.#i.scope!==d.Singleton)throw new B(O.invalidOperation,`Binding for service "${t$1(this.#i.serviceIdentifier)}" has a deactivation function, but its scope is not singleton. Deactivation functions can only be used with singleton bindings.`);return new q(this.#i)}}class q{#i;constructor(e){this.#i=e;}getIdentifier(){return x$2(this.#i)}when(e){return this.#i.isSatisfiedBy=e,new $(this.#i)}whenAnyAncestor(e){return this.when(k(e))}whenAnyAncestorIs(e){return this.when(k(F(e)))}whenAnyAncestorNamed(e){return this.when(function(e){return k(N(e))}(e))}whenAnyAncestorTagged(e,n){return this.when(function(e,n){return k(U(e,n))}(e,n))}whenDefault(){return this.when(D)}whenNamed(e){return this.when(N(e))}whenNoParent(e){return this.when(T$1(e))}whenNoParentIs(e){return this.when(T$1(F(e)))}whenNoParentNamed(e){return this.when(function(e){return T$1(N(e))}(e))}whenNoParentTagged(e,n){return this.when(function(e,n){return T$1(U(e,n))}(e,n))}whenParent(e){return this.when(V(e))}whenParentIs(e){return this.when(V(F(e)))}whenParentNamed(e){return this.when(function(e){return V(N(e))}(e))}whenParentTagged(e,n){return this.when(function(e,n){return V(U(e,n))}(e,n))}whenTagged(e,n){return this.when(U(e,n))}whenNoAncestor(e){return this.when(j$1(e))}whenNoAncestorIs(e){return this.when(j$1(F(e)))}whenNoAncestorNamed(e){return this.when(function(e){return j$1(N(e))}(e))}whenNoAncestorTagged(e,n){return this.when(function(e,n){return j$1(U(e,n))}(e,n))}}class G extends q{#c;constructor(e){super(e),this.#c=new $(e);}onActivation(e){return this.#c.onActivation(e)}onDeactivation(e){return this.#c.onDeactivation(e)}}class H extends G{#d;constructor(e){super(e),this.#d=new E(e);}inRequestScope(){return this.#d.inRequestScope()}inSingletonScope(){return this.#d.inSingletonScope()}inTransientScope(){return this.#d.inTransientScope()}}class _{#l;#a;#u;#h;constructor(e,n,i,t){this.#l=e,this.#a=n,this.#u=i,this.#h=t;}bind(e){return new L$1(e=>{this.#v(e);},void 0,this.#a,e)}isBound(e,n){const i=this.#h.bindingService.get(e);return this.#g(e,i,n)}isCurrentBound(e,n){const i=this.#h.bindingService.getNonParentBindings(e);return this.#g(e,i,n)}async rebind(e){return await this.unbind(e),this.bind(e)}rebindSync(e){return this.unbindSync(e),this.bind(e)}async unbind(e){await this.#f(e);}async unbindAll(){const e=[...this.#h.bindingService.getNonParentBoundServices()];await Promise.all(e.map(async e=>Dt(this.#l,e)));for(const n of e)this.#h.activationService.removeAllByServiceId(n),this.#h.bindingService.removeAllByServiceId(n),this.#h.deactivationService.removeAllByServiceId(n);this.#h.planResultCacheService.clearCache();}unbindSync(e){ void 0!==this.#f(e)&&this.#b(e);}#v(e){this.#h.bindingService.set(e),this.#u.invalidateService({binding:e,kind:qe.bindingAdded});}#b(e){let n;if(A$1(e)){const t=this.#h.bindingService.getById(e.id),r=(i=t,function(e){if(void 0===e)return;const n=e.next();return  true!==n.done?n.value:void 0}(i?.[Symbol.iterator]()))?.serviceIdentifier;n=void 0===r?"Unexpected asynchronous deactivation when unbinding binding identifier. Consider using Container.unbind() instead.":`Unexpected asynchronous deactivation when unbinding "${t$1(r)}" binding. Consider using Container.unbind() instead.`;}else n=`Unexpected asynchronous deactivation when unbinding "${t$1(e)}" service. Consider using Container.unbind() instead.`;var i;throw new B(O.invalidOperation,n)}#f(e){return A$1(e)?this.#p(e):this.#S(e)}#p(e){const n=this.#h.bindingService.getById(e.id),i=void 0===n?void 0:[...n],t=kt(this.#l,n);if(void 0!==t)return t.then(()=>{this.#M(i,e);});this.#M(i,e);}#M(e,n){if(this.#h.bindingService.removeById(n.id),void 0!==e)for(const n of e)this.#u.invalidateService({binding:n,kind:qe.bindingRemoved});}#S(e){const n=this.#h.bindingService.get(e),i=void 0===n?void 0:[...n],t=kt(this.#l,n);if(void 0!==t)return t.then(()=>{this.#R(e,i);});this.#R(e,i);}#R(e,n){if(this.#h.activationService.removeAllByServiceId(e),this.#h.bindingService.removeAllByServiceId(e),this.#h.deactivationService.removeAllByServiceId(e),void 0!==n)for(const e of n)this.#u.invalidateService({binding:e,kind:qe.bindingRemoved});}#g(e,n,i){if(void 0===n)return  false;const t={getAncestor:()=>{},name:i?.name,serviceIdentifier:e,tags:new Map};void 0!==i?.tag&&t.tags.set(i.tag.key,i.tag.value);for(const e of n)if(e.isSatisfiedBy(t))return  true;return  false}}class z{#y;#l;#a;#u;#h;constructor(e,n,i,t,r){this.#y=e,this.#l=n,this.#a=i,this.#u=t,this.#h=r;}async load(...e){await Promise.all(this.#n(...e));}loadSync(...e){const n=this.#n(...e);for(const e of n)if(void 0!==e)throw new B(O.invalidOperation,"Unexpected asynchronous module load. Consider using Container.load() instead.")}async unload(...e){await Promise.all(this.#m(...e)),this.#w(e);}unloadSync(...e){const n=this.#m(...e);for(const e of n)if(void 0!==e)throw new B(O.invalidOperation,"Unexpected asynchronous module unload. Consider using Container.unload() instead.");this.#w(e);}#I(e){return {bind:n=>new L$1(e=>{this.#v(e);},e,this.#a,n),isBound:this.#y.isBound.bind(this.#y),onActivation:(n,i)=>{this.#h.activationService.add(i,{moduleId:e,serviceId:n});},onDeactivation:(n,i)=>{this.#h.deactivationService.add(i,{moduleId:e,serviceId:n});},rebind:this.#y.rebind.bind(this.#y),rebindSync:this.#y.rebindSync.bind(this.#y),unbind:this.#y.unbind.bind(this.#y),unbindSync:this.#y.unbindSync.bind(this.#y)}}#w(e){for(const n of e)this.#h.activationService.removeAllByModuleId(n.id),this.#h.bindingService.removeAllByModuleId(n.id),this.#h.deactivationService.removeAllByModuleId(n.id);this.#h.planResultCacheService.clearCache();}#n(...e){return e.map(e=>e.load(this.#I(e.id)))}#v(e){this.#h.bindingService.set(e),this.#u.invalidateService({binding:e,kind:qe.bindingAdded});}#m(...e){return e.map(e=>$t(this.#l,e.id))}}class K{deactivationParams;constructor(e){this.deactivationParams=function(e){return {getBindings:e.bindingService.get.bind(e.bindingService),getBindingsFromModule:e.bindingService.getByModuleId.bind(e.bindingService),getClassMetadata:N$1,getDeactivations:e.deactivationService.get.bind(e.deactivationService)}}(e),e.onReset(()=>{!function(e,n){n.getBindings=e.bindingService.get.bind(e.bindingService),n.getBindingsFromModule=e.bindingService.getByModuleId.bind(e.bindingService),n.getDeactivations=e.deactivationService.get.bind(e.deactivationService);}(e,this.deactivationParams);});}}let X$1 = class X{planParamsOperations;#h;constructor(e){this.#h=e,this.planParamsOperations={getBindings:this.#h.bindingService.get.bind(this.#h.bindingService),getBindingsChained:this.#h.bindingService.getChained.bind(this.#h.bindingService),getClassMetadata:N$1,getPlan:this.#h.planResultCacheService.get.bind(this.#h.planResultCacheService),setBinding:this.#v.bind(this),setNonCachedServiceNode:this.#h.planResultCacheService.setNonCachedServiceNode.bind(this.#h.planResultCacheService),setPlan:this.#h.planResultCacheService.set.bind(this.#h.planResultCacheService)},this.#h.onReset(()=>{this.#A();});}#A(){this.planParamsOperations.getBindings=this.#h.bindingService.get.bind(this.#h.bindingService),this.planParamsOperations.getBindingsChained=this.#h.bindingService.getChained.bind(this.#h.bindingService),this.planParamsOperations.setBinding=this.#v.bind(this);}#v(e){this.#h.bindingService.set(e),this.#h.planResultCacheService.invalidateServiceBinding({binding:e,kind:qe.bindingAdded,operations:this.planParamsOperations});}};class J{#P;#h;constructor(e,n){this.#P=e,this.#h=n;}invalidateService(e){this.#h.planResultCacheService.invalidateServiceBinding({...e,operations:this.#P.planParamsOperations});}}class Q{#C;#B;#O;#h;constructor(e,n,i){this.#h=n,this.#O=i,this.#C=this.#x(e),this.#B=this.#k();}register(e,n){const i=new n(e,this.#B);if(true!==i[t])throw new B(O.invalidOperation,"Invalid plugin. The plugin must extend the Plugin class");i.load(this.#C);}#x(e){return {define:(n,i)=>{if(Object.prototype.hasOwnProperty.call(e,n))throw new B(O.invalidOperation,`Container already has a method named "${String(n)}"`);e[n]=i;},onPlan:this.#O.onPlan.bind(this.#O)}}#k(){const e=this.#h;return {get activationService(){return e.activationService},get bindingService(){return e.bindingService},get deactivationService(){return e.deactivationService},get planResultCacheService(){return e.planResultCacheService}}}}let W$1 = class W{activationService;bindingService;deactivationService;planResultCacheService;#N;constructor(e,n,i,t){this.activationService=e,this.bindingService=n,this.deactivationService=i,this.planResultCacheService=t,this.#N=[];}reset(e,n,i){this.activationService=e,this.bindingService=n,this.deactivationService=i,this.planResultCacheService.clearCache();for(const e of this.#N)e();}onReset(e){this.#N.push(e);}};class Y{#F;#a;#U;#D;#j;#P;#h;constructor(e,n,i,t){this.#P=e,this.#h=n,this.#D=this.#T(),this.#F=i,this.#a=t,this.#U=e=>this.#h.activationService.get(e),this.#j=[],this.#h.onReset(()=>{this.#A();});}get(e$1,n){const i=this.#V(false,e$1,n),t=this.#E(i);if(e(t))throw new B(O.invalidOperation,`Unexpected asynchronous service when resolving service "${t$1(e$1)}"`);return t}getAll(e$1,n){const i=this.#V(true,e$1,n),t=this.#E(i);if(e(t))throw new B(O.invalidOperation,`Unexpected asynchronous service when resolving service "${t$1(e$1)}"`);return t}async getAllAsync(e,n){const i=this.#V(true,e,n);return this.#E(i)}async getAsync(e,n){const i=this.#V(false,e,n);return this.#E(i)}onPlan(e){this.#j.push(e);}#A(){this.#D=this.#T();}#L(e,n,i){const t=i?.name,r=i?.optional??false,a=i?.tag;return e?{chained:i?.chained??false,isMultiple:e,name:t,optional:r,serviceIdentifier:n,tag:a}:{isMultiple:e,name:t,optional:r,serviceIdentifier:n,tag:a}}#$(e,n,i){const t={autobindOptions:i?.autobind??this.#F?{scope:this.#a}:void 0,operations:this.#P.planParamsOperations,rootConstraints:this.#q(e,n,i),servicesBranch:[]};return this.#G(t,i),t}#q(e,n,i){return n?{chained:i?.chained??false,isMultiple:n,serviceIdentifier:e}:{isMultiple:n,serviceIdentifier:e}}#V(e,n,i){const t=this.#L(e,n,i),r=this.#h.planResultCacheService.get(t);if(void 0!==r)return r;const a=Ke(this.#$(n,e,i));for(const e of this.#j)e(t,a);return a}#T(){return {get:this.get.bind(this),getAll:this.getAll.bind(this),getAllAsync:this.getAllAsync.bind(this),getAsync:this.getAsync.bind(this)}}#E(e){return Ct({context:this.#D,getActivations:this.#U,planResult:e,requestScopeCache:new Map})}#G(e,n){ void 0!==n&&(void 0!==n.name&&(e.rootConstraints.name=n.name),true===n.optional&&(e.rootConstraints.isOptional=true),void 0!==n.tag&&(e.rootConstraints.tag={key:n.tag.key,value:n.tag.value}),e.rootConstraints.isMultiple&&(e.rootConstraints.chained=n?.chained??false));}}let Z$1 = class Z{#h;#H;constructor(e){this.#h=e,this.#H=[];}restore(){const e=this.#H.pop();if(void 0===e)throw new B(O.invalidOperation,"No snapshot available to restore");this.#h.reset(e.activationService,e.bindingService,e.deactivationService);}snapshot(){this.#H.push({activationService:this.#h.activationService.clone(),bindingService:this.#h.bindingService.clone(),deactivationService:this.#h.deactivationService.clone()});}};const ee$1=d.Transient;class ne{#y;#_;#z;#h;#O;#K;constructor(e){const n=e?.autobind??false,i=e?.defaultScope??ee$1;this.#h=this.#X(e,n,i);const t=new X$1(this.#h),r=new J(t,this.#h),a=new K(this.#h);this.#y=new _(a.deactivationParams,i,r,this.#h),this.#_=new z(this.#y,a.deactivationParams,i,r,this.#h),this.#O=new Y(t,this.#h,n,i),this.#z=new Q(this,this.#h,this.#O),this.#K=new Z$1(this.#h);}bind(e){return this.#y.bind(e)}get(e,n){return this.#O.get(e,n)}getAll(e,n){return this.#O.getAll(e,n)}async getAllAsync(e,n){return this.#O.getAllAsync(e,n)}async getAsync(e,n){return this.#O.getAsync(e,n)}isBound(e,n){return this.#y.isBound(e,n)}isCurrentBound(e,n){return this.#y.isCurrentBound(e,n)}async load(...e){return this.#_.load(...e)}loadSync(...e){this.#_.loadSync(...e);}onActivation(e,n){this.#h.activationService.add(n,{serviceId:e});}onDeactivation(e,n){this.#h.deactivationService.add(n,{serviceId:e});}register(e){this.#z.register(this,e);}restore(){this.#K.restore();}async rebind(e){return this.#y.rebind(e)}rebindSync(e){return this.#y.rebindSync(e)}snapshot(){this.#K.snapshot();}async unbind(e){await this.#y.unbind(e);}async unbindAll(){return this.#y.unbindAll()}unbindSync(e){this.#y.unbindSync(e);}async unload(...e){return this.#_.unload(...e)}unloadSync(...e){this.#_.unloadSync(...e);}#J(e,n){if(e)return {scope:n}}#X(e,n,i){const t=this.#J(n,i);if(void 0===e?.parent)return new W$1(v.build(()=>{}),T$2.build(()=>{},t),j$2.build(()=>{}),new Ye);const r=new Ye,a=e.parent;return a.#h.planResultCacheService.subscribe(r),new W$1(v.build(()=>a.#h.activationService),T$2.build(()=>a.#h.bindingService,t),j$2.build(()=>a.#h.deactivationService),r)}}

var NTSex = /* @__PURE__ */ ((NTSex2) => {
  NTSex2[NTSex2["GENDER_UNKOWN"] = 0] = "GENDER_UNKOWN";
  NTSex2[NTSex2["GENDER_MALE"] = 1] = "GENDER_MALE";
  NTSex2[NTSex2["GENDER_FEMALE"] = 2] = "GENDER_FEMALE";
  NTSex2[NTSex2["GENDER_PRIVACY"] = 255] = "GENDER_PRIVACY";
  return NTSex2;
})(NTSex || {});
var BuddyListReqType = /* @__PURE__ */ ((BuddyListReqType2) => {
  BuddyListReqType2[BuddyListReqType2["KNOMAL"] = 0] = "KNOMAL";
  BuddyListReqType2[BuddyListReqType2["KLETTER"] = 1] = "KLETTER";
  return BuddyListReqType2;
})(BuddyListReqType || {});
var UserDetailSource = /* @__PURE__ */ ((UserDetailSource2) => {
  UserDetailSource2[UserDetailSource2["KDB"] = 0] = "KDB";
  UserDetailSource2[UserDetailSource2["KSERVER"] = 1] = "KSERVER";
  return UserDetailSource2;
})(UserDetailSource || {});
var ProfileBizType = /* @__PURE__ */ ((ProfileBizType2) => {
  ProfileBizType2[ProfileBizType2["KALL"] = 0] = "KALL";
  ProfileBizType2[ProfileBizType2["KBASEEXTEND"] = 1] = "KBASEEXTEND";
  ProfileBizType2[ProfileBizType2["KVAS"] = 2] = "KVAS";
  ProfileBizType2[ProfileBizType2["KQZONE"] = 3] = "KQZONE";
  ProfileBizType2[ProfileBizType2["KOTHER"] = 4] = "KOTHER";
  return ProfileBizType2;
})(ProfileBizType || {});

var GroupInfoSource = /* @__PURE__ */ ((GroupInfoSource2) => {
  GroupInfoSource2[GroupInfoSource2["KUNSPECIFIED"] = 0] = "KUNSPECIFIED";
  GroupInfoSource2[GroupInfoSource2["KBIGDATACARD"] = 1] = "KBIGDATACARD";
  GroupInfoSource2[GroupInfoSource2["KDATACARD"] = 2] = "KDATACARD";
  GroupInfoSource2[GroupInfoSource2["KNOTICE"] = 3] = "KNOTICE";
  GroupInfoSource2[GroupInfoSource2["KAIO"] = 4] = "KAIO";
  GroupInfoSource2[GroupInfoSource2["KRECENTCONTACT"] = 5] = "KRECENTCONTACT";
  GroupInfoSource2[GroupInfoSource2["KMOREPANEL"] = 6] = "KMOREPANEL";
  return GroupInfoSource2;
})(GroupInfoSource || {});
var NTGroupMemberRole = /* @__PURE__ */ ((NTGroupMemberRole2) => {
  NTGroupMemberRole2[NTGroupMemberRole2["KUNSPECIFIED"] = 0] = "KUNSPECIFIED";
  NTGroupMemberRole2[NTGroupMemberRole2["KSTRANGER"] = 1] = "KSTRANGER";
  NTGroupMemberRole2[NTGroupMemberRole2["KMEMBER"] = 2] = "KMEMBER";
  NTGroupMemberRole2[NTGroupMemberRole2["KADMIN"] = 3] = "KADMIN";
  NTGroupMemberRole2[NTGroupMemberRole2["KOWNER"] = 4] = "KOWNER";
  return NTGroupMemberRole2;
})(NTGroupMemberRole || {});

var ElementType = /* @__PURE__ */ ((ElementType2) => {
  ElementType2[ElementType2["UNKNOWN"] = 0] = "UNKNOWN";
  ElementType2[ElementType2["TEXT"] = 1] = "TEXT";
  ElementType2[ElementType2["PIC"] = 2] = "PIC";
  ElementType2[ElementType2["FILE"] = 3] = "FILE";
  ElementType2[ElementType2["PTT"] = 4] = "PTT";
  ElementType2[ElementType2["VIDEO"] = 5] = "VIDEO";
  ElementType2[ElementType2["FACE"] = 6] = "FACE";
  ElementType2[ElementType2["REPLY"] = 7] = "REPLY";
  ElementType2[ElementType2["GreyTip"] = 8] = "GreyTip";
  ElementType2[ElementType2["WALLET"] = 9] = "WALLET";
  ElementType2[ElementType2["ARK"] = 10] = "ARK";
  ElementType2[ElementType2["MFACE"] = 11] = "MFACE";
  ElementType2[ElementType2["LIVEGIFT"] = 12] = "LIVEGIFT";
  ElementType2[ElementType2["STRUCTLONGMSG"] = 13] = "STRUCTLONGMSG";
  ElementType2[ElementType2["MARKDOWN"] = 14] = "MARKDOWN";
  ElementType2[ElementType2["GIPHY"] = 15] = "GIPHY";
  ElementType2[ElementType2["MULTIFORWARD"] = 16] = "MULTIFORWARD";
  ElementType2[ElementType2["INLINEKEYBOARD"] = 17] = "INLINEKEYBOARD";
  ElementType2[ElementType2["INTEXTGIFT"] = 18] = "INTEXTGIFT";
  ElementType2[ElementType2["CALENDAR"] = 19] = "CALENDAR";
  ElementType2[ElementType2["YOLOGAMERESULT"] = 20] = "YOLOGAMERESULT";
  ElementType2[ElementType2["AVRECORD"] = 21] = "AVRECORD";
  ElementType2[ElementType2["FEED"] = 22] = "FEED";
  ElementType2[ElementType2["TOFURECORD"] = 23] = "TOFURECORD";
  ElementType2[ElementType2["ACEBUBBLE"] = 24] = "ACEBUBBLE";
  ElementType2[ElementType2["ACTIVITY"] = 25] = "ACTIVITY";
  ElementType2[ElementType2["TOFU"] = 26] = "TOFU";
  ElementType2[ElementType2["FACEBUBBLE"] = 27] = "FACEBUBBLE";
  ElementType2[ElementType2["SHARELOCATION"] = 28] = "SHARELOCATION";
  ElementType2[ElementType2["TASKTOPMSG"] = 29] = "TASKTOPMSG";
  ElementType2[ElementType2["RECOMMENDEDMSG"] = 43] = "RECOMMENDEDMSG";
  ElementType2[ElementType2["ACTIONBAR"] = 44] = "ACTIONBAR";
  return ElementType2;
})(ElementType || {});
var NTMsgType = /* @__PURE__ */ ((NTMsgType2) => {
  NTMsgType2[NTMsgType2["KMSGTYPEARKSTRUCT"] = 11] = "KMSGTYPEARKSTRUCT";
  NTMsgType2[NTMsgType2["KMSGTYPEFACEBUBBLE"] = 24] = "KMSGTYPEFACEBUBBLE";
  NTMsgType2[NTMsgType2["KMSGTYPEFILE"] = 3] = "KMSGTYPEFILE";
  NTMsgType2[NTMsgType2["KMSGTYPEGIFT"] = 14] = "KMSGTYPEGIFT";
  NTMsgType2[NTMsgType2["KMSGTYPEGIPHY"] = 13] = "KMSGTYPEGIPHY";
  NTMsgType2[NTMsgType2["KMSGTYPEGRAYTIPS"] = 5] = "KMSGTYPEGRAYTIPS";
  NTMsgType2[NTMsgType2["KMSGTYPEMIX"] = 2] = "KMSGTYPEMIX";
  NTMsgType2[NTMsgType2["KMSGTYPEMULTIMSGFORWARD"] = 8] = "KMSGTYPEMULTIMSGFORWARD";
  NTMsgType2[NTMsgType2["KMSGTYPENULL"] = 1] = "KMSGTYPENULL";
  NTMsgType2[NTMsgType2["KMSGTYPEONLINEFILE"] = 21] = "KMSGTYPEONLINEFILE";
  NTMsgType2[NTMsgType2["KMSGTYPEONLINEFOLDER"] = 27] = "KMSGTYPEONLINEFOLDER";
  NTMsgType2[NTMsgType2["KMSGTYPEPROLOGUE"] = 29] = "KMSGTYPEPROLOGUE";
  NTMsgType2[NTMsgType2["KMSGTYPEPTT"] = 6] = "KMSGTYPEPTT";
  NTMsgType2[NTMsgType2["KMSGTYPEREPLY"] = 9] = "KMSGTYPEREPLY";
  NTMsgType2[NTMsgType2["KMSGTYPESHARELOCATION"] = 25] = "KMSGTYPESHARELOCATION";
  NTMsgType2[NTMsgType2["KMSGTYPESTRUCT"] = 4] = "KMSGTYPESTRUCT";
  NTMsgType2[NTMsgType2["KMSGTYPESTRUCTLONGMSG"] = 12] = "KMSGTYPESTRUCTLONGMSG";
  NTMsgType2[NTMsgType2["KMSGTYPETEXTGIFT"] = 15] = "KMSGTYPETEXTGIFT";
  NTMsgType2[NTMsgType2["KMSGTYPEUNKNOWN"] = 0] = "KMSGTYPEUNKNOWN";
  NTMsgType2[NTMsgType2["KMSGTYPEVIDEO"] = 7] = "KMSGTYPEVIDEO";
  NTMsgType2[NTMsgType2["KMSGTYPEWALLET"] = 10] = "KMSGTYPEWALLET";
  return NTMsgType2;
})(NTMsgType || {});
var PicType = /* @__PURE__ */ ((PicType2) => {
  PicType2[PicType2["NEWPIC_APNG"] = 2001] = "NEWPIC_APNG";
  PicType2[PicType2["NEWPIC_BMP"] = 1005] = "NEWPIC_BMP";
  PicType2[PicType2["NEWPIC_GIF"] = 2e3] = "NEWPIC_GIF";
  PicType2[PicType2["NEWPIC_JPEG"] = 1e3] = "NEWPIC_JPEG";
  PicType2[PicType2["NEWPIC_PNG"] = 1001] = "NEWPIC_PNG";
  PicType2[PicType2["NEWPIC_PROGERSSIV_JPEG"] = 1003] = "NEWPIC_PROGERSSIV_JPEG";
  PicType2[PicType2["NEWPIC_SHARPP"] = 1004] = "NEWPIC_SHARPP";
  PicType2[PicType2["NEWPIC_WEBP"] = 1002] = "NEWPIC_WEBP";
  return PicType2;
})(PicType || {});
var NTMsgAtType = /* @__PURE__ */ ((NTMsgAtType2) => {
  NTMsgAtType2[NTMsgAtType2["ATTYPEALL"] = 1] = "ATTYPEALL";
  NTMsgAtType2[NTMsgAtType2["ATTYPECATEGORY"] = 512] = "ATTYPECATEGORY";
  NTMsgAtType2[NTMsgAtType2["ATTYPECHANNEL"] = 16] = "ATTYPECHANNEL";
  NTMsgAtType2[NTMsgAtType2["ATTYPEME"] = 4] = "ATTYPEME";
  NTMsgAtType2[NTMsgAtType2["ATTYPEONE"] = 2] = "ATTYPEONE";
  NTMsgAtType2[NTMsgAtType2["ATTYPEONLINE"] = 64] = "ATTYPEONLINE";
  NTMsgAtType2[NTMsgAtType2["ATTYPEROLE"] = 8] = "ATTYPEROLE";
  NTMsgAtType2[NTMsgAtType2["ATTYPESUMMON"] = 32] = "ATTYPESUMMON";
  NTMsgAtType2[NTMsgAtType2["ATTYPESUMMONONLINE"] = 128] = "ATTYPESUMMONONLINE";
  NTMsgAtType2[NTMsgAtType2["ATTYPESUMMONROLE"] = 256] = "ATTYPESUMMONROLE";
  NTMsgAtType2[NTMsgAtType2["ATTYPEUNKNOWN"] = 0] = "ATTYPEUNKNOWN";
  return NTMsgAtType2;
})(NTMsgAtType || {});
var MsgSourceType = /* @__PURE__ */ ((MsgSourceType2) => {
  MsgSourceType2[MsgSourceType2["K_DOWN_SOURCETYPE_AIOINNER"] = 1] = "K_DOWN_SOURCETYPE_AIOINNER";
  MsgSourceType2[MsgSourceType2["K_DOWN_SOURCETYPE_BIGSCREEN"] = 2] = "K_DOWN_SOURCETYPE_BIGSCREEN";
  MsgSourceType2[MsgSourceType2["K_DOWN_SOURCETYPE_HISTORY"] = 3] = "K_DOWN_SOURCETYPE_HISTORY";
  MsgSourceType2[MsgSourceType2["K_DOWN_SOURCETYPE_UNKNOWN"] = 0] = "K_DOWN_SOURCETYPE_UNKNOWN";
  return MsgSourceType2;
})(MsgSourceType || {});
var ChatType = /* @__PURE__ */ ((ChatType2) => {
  ChatType2[ChatType2["KCHATTYPEADELIE"] = 42] = "KCHATTYPEADELIE";
  ChatType2[ChatType2["KCHATTYPEBUDDYNOTIFY"] = 5] = "KCHATTYPEBUDDYNOTIFY";
  ChatType2[ChatType2["KCHATTYPEC2C"] = 1] = "KCHATTYPEC2C";
  ChatType2[ChatType2["KCHATTYPECIRCLE"] = 113] = "KCHATTYPECIRCLE";
  ChatType2[ChatType2["KCHATTYPEDATALINE"] = 8] = "KCHATTYPEDATALINE";
  ChatType2[ChatType2["KCHATTYPEDATALINEMQQ"] = 134] = "KCHATTYPEDATALINEMQQ";
  ChatType2[ChatType2["KCHATTYPEDISC"] = 3] = "KCHATTYPEDISC";
  ChatType2[ChatType2["KCHATTYPEFAV"] = 41] = "KCHATTYPEFAV";
  ChatType2[ChatType2["KCHATTYPEGAMEMESSAGE"] = 105] = "KCHATTYPEGAMEMESSAGE";
  ChatType2[ChatType2["KCHATTYPEGAMEMESSAGEFOLDER"] = 116] = "KCHATTYPEGAMEMESSAGEFOLDER";
  ChatType2[ChatType2["KCHATTYPEGROUP"] = 2] = "KCHATTYPEGROUP";
  ChatType2[ChatType2["KCHATTYPEGROUPBLESS"] = 133] = "KCHATTYPEGROUPBLESS";
  ChatType2[ChatType2["KCHATTYPEGROUPGUILD"] = 9] = "KCHATTYPEGROUPGUILD";
  ChatType2[ChatType2["KCHATTYPEGROUPHELPER"] = 7] = "KCHATTYPEGROUPHELPER";
  ChatType2[ChatType2["KCHATTYPEGROUPNOTIFY"] = 6] = "KCHATTYPEGROUPNOTIFY";
  ChatType2[ChatType2["KCHATTYPEGUILD"] = 4] = "KCHATTYPEGUILD";
  ChatType2[ChatType2["KCHATTYPEGUILDMETA"] = 16] = "KCHATTYPEGUILDMETA";
  ChatType2[ChatType2["KCHATTYPEMATCHFRIEND"] = 104] = "KCHATTYPEMATCHFRIEND";
  ChatType2[ChatType2["KCHATTYPEMATCHFRIENDFOLDER"] = 109] = "KCHATTYPEMATCHFRIENDFOLDER";
  ChatType2[ChatType2["KCHATTYPENEARBY"] = 106] = "KCHATTYPENEARBY";
  ChatType2[ChatType2["KCHATTYPENEARBYASSISTANT"] = 107] = "KCHATTYPENEARBYASSISTANT";
  ChatType2[ChatType2["KCHATTYPENEARBYFOLDER"] = 110] = "KCHATTYPENEARBYFOLDER";
  ChatType2[ChatType2["KCHATTYPENEARBYHELLOFOLDER"] = 112] = "KCHATTYPENEARBYHELLOFOLDER";
  ChatType2[ChatType2["KCHATTYPENEARBYINTERACT"] = 108] = "KCHATTYPENEARBYINTERACT";
  ChatType2[ChatType2["KCHATTYPEQQNOTIFY"] = 132] = "KCHATTYPEQQNOTIFY";
  ChatType2[ChatType2["KCHATTYPERELATEACCOUNT"] = 131] = "KCHATTYPERELATEACCOUNT";
  ChatType2[ChatType2["KCHATTYPESERVICEASSISTANT"] = 118] = "KCHATTYPESERVICEASSISTANT";
  ChatType2[ChatType2["KCHATTYPESERVICEASSISTANTSUB"] = 201] = "KCHATTYPESERVICEASSISTANTSUB";
  ChatType2[ChatType2["KCHATTYPESQUAREPUBLIC"] = 115] = "KCHATTYPESQUAREPUBLIC";
  ChatType2[ChatType2["KCHATTYPESUBSCRIBEFOLDER"] = 30] = "KCHATTYPESUBSCRIBEFOLDER";
  ChatType2[ChatType2["KCHATTYPETEMPADDRESSBOOK"] = 111] = "KCHATTYPETEMPADDRESSBOOK";
  ChatType2[ChatType2["KCHATTYPETEMPBUSSINESSCRM"] = 102] = "KCHATTYPETEMPBUSSINESSCRM";
  ChatType2[ChatType2["KCHATTYPETEMPC2CFROMGROUP"] = 100] = "KCHATTYPETEMPC2CFROMGROUP";
  ChatType2[ChatType2["KCHATTYPETEMPC2CFROMUNKNOWN"] = 99] = "KCHATTYPETEMPC2CFROMUNKNOWN";
  ChatType2[ChatType2["KCHATTYPETEMPFRIENDVERIFY"] = 101] = "KCHATTYPETEMPFRIENDVERIFY";
  ChatType2[ChatType2["KCHATTYPETEMPNEARBYPRO"] = 119] = "KCHATTYPETEMPNEARBYPRO";
  ChatType2[ChatType2["KCHATTYPETEMPPUBLICACCOUNT"] = 103] = "KCHATTYPETEMPPUBLICACCOUNT";
  ChatType2[ChatType2["KCHATTYPETEMPWPA"] = 117] = "KCHATTYPETEMPWPA";
  ChatType2[ChatType2["KCHATTYPEUNKNOWN"] = 0] = "KCHATTYPEUNKNOWN";
  ChatType2[ChatType2["KCHATTYPEWEIYUN"] = 40] = "KCHATTYPEWEIYUN";
  return ChatType2;
})(ChatType || {});
var NTGrayTipElementSubTypeV2 = /* @__PURE__ */ ((NTGrayTipElementSubTypeV22) => {
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_AIOOP"] = 15] = "GRAYTIP_ELEMENT_SUBTYPE_AIOOP";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_BLOCK"] = 14] = "GRAYTIP_ELEMENT_SUBTYPE_BLOCK";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_BUDDY"] = 5] = "GRAYTIP_ELEMENT_SUBTYPE_BUDDY";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_BUDDYNOTIFY"] = 9] = "GRAYTIP_ELEMENT_SUBTYPE_BUDDYNOTIFY";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_EMOJIREPLY"] = 3] = "GRAYTIP_ELEMENT_SUBTYPE_EMOJIREPLY";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_ESSENCE"] = 7] = "GRAYTIP_ELEMENT_SUBTYPE_ESSENCE";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_FEED"] = 6] = "GRAYTIP_ELEMENT_SUBTYPE_FEED";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_FEEDCHANNELMSG"] = 11] = "GRAYTIP_ELEMENT_SUBTYPE_FEEDCHANNELMSG";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_FILE"] = 10] = "GRAYTIP_ELEMENT_SUBTYPE_FILE";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_GROUP"] = 4] = "GRAYTIP_ELEMENT_SUBTYPE_GROUP";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_GROUPNOTIFY"] = 8] = "GRAYTIP_ELEMENT_SUBTYPE_GROUPNOTIFY";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_JSON"] = 17] = "GRAYTIP_ELEMENT_SUBTYPE_JSON";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_LOCALMSG"] = 13] = "GRAYTIP_ELEMENT_SUBTYPE_LOCALMSG";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_PROCLAMATION"] = 2] = "GRAYTIP_ELEMENT_SUBTYPE_PROCLAMATION";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_REVOKE"] = 1] = "GRAYTIP_ELEMENT_SUBTYPE_REVOKE";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_UNKNOWN"] = 0] = "GRAYTIP_ELEMENT_SUBTYPE_UNKNOWN";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_WALLET"] = 16] = "GRAYTIP_ELEMENT_SUBTYPE_WALLET";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_XMLMSG"] = 12] = "GRAYTIP_ELEMENT_SUBTYPE_XMLMSG";
  return NTGrayTipElementSubTypeV22;
})(NTGrayTipElementSubTypeV2 || {});
var FaceIndex = /* @__PURE__ */ ((FaceIndex2) => {
  FaceIndex2[FaceIndex2["DICE"] = 358] = "DICE";
  FaceIndex2[FaceIndex2["RPS"] = 359] = "RPS";
  return FaceIndex2;
})(FaceIndex || {});
var TipGroupElementType = /* @__PURE__ */ ((TipGroupElementType2) => {
  TipGroupElementType2[TipGroupElementType2["KUNKNOWN"] = 0] = "KUNKNOWN";
  TipGroupElementType2[TipGroupElementType2["KMEMBERADD"] = 1] = "KMEMBERADD";
  TipGroupElementType2[TipGroupElementType2["KDISBANDED"] = 2] = "KDISBANDED";
  TipGroupElementType2[TipGroupElementType2["KQUITTE"] = 3] = "KQUITTE";
  TipGroupElementType2[TipGroupElementType2["KCREATED"] = 4] = "KCREATED";
  TipGroupElementType2[TipGroupElementType2["KGROUPNAMEMODIFIED"] = 5] = "KGROUPNAMEMODIFIED";
  TipGroupElementType2[TipGroupElementType2["KBLOCK"] = 6] = "KBLOCK";
  TipGroupElementType2[TipGroupElementType2["KUNBLOCK"] = 7] = "KUNBLOCK";
  TipGroupElementType2[TipGroupElementType2["KSHUTUP"] = 8] = "KSHUTUP";
  TipGroupElementType2[TipGroupElementType2["KBERECYCLED"] = 9] = "KBERECYCLED";
  TipGroupElementType2[TipGroupElementType2["KDISBANDORBERECYCLED"] = 10] = "KDISBANDORBERECYCLED";
  return TipGroupElementType2;
})(TipGroupElementType || {});
var SendStatusType = /* @__PURE__ */ ((SendStatusType2) => {
  SendStatusType2[SendStatusType2["KSEND_STATUS_FAILED"] = 0] = "KSEND_STATUS_FAILED";
  SendStatusType2[SendStatusType2["KSEND_STATUS_SENDING"] = 1] = "KSEND_STATUS_SENDING";
  SendStatusType2[SendStatusType2["KSEND_STATUS_SUCCESS"] = 2] = "KSEND_STATUS_SUCCESS";
  SendStatusType2[SendStatusType2["KSEND_STATUS_SUCCESS_NOSEQ"] = 3] = "KSEND_STATUS_SUCCESS_NOSEQ";
  return SendStatusType2;
})(SendStatusType || {});
var FaceType = /* @__PURE__ */ ((FaceType2) => {
  FaceType2[FaceType2["Unknown"] = 0] = "Unknown";
  FaceType2[FaceType2["OldFace"] = 1] = "OldFace";
  FaceType2[FaceType2["Normal"] = 2] = "Normal";
  FaceType2[FaceType2["AniSticke"] = 3] = "AniSticke";
  FaceType2[FaceType2["Lottie"] = 4] = "Lottie";
  FaceType2[FaceType2["Poke"] = 5] = "Poke";
  return FaceType2;
})(FaceType || {});

var GroupNotifyMsgType = /* @__PURE__ */ ((GroupNotifyMsgType2) => {
  GroupNotifyMsgType2[GroupNotifyMsgType2["UN_SPECIFIED"] = 0] = "UN_SPECIFIED";
  GroupNotifyMsgType2[GroupNotifyMsgType2["INVITED_BY_MEMBER"] = 1] = "INVITED_BY_MEMBER";
  GroupNotifyMsgType2[GroupNotifyMsgType2["REFUSE_INVITED"] = 2] = "REFUSE_INVITED";
  GroupNotifyMsgType2[GroupNotifyMsgType2["REFUSED_BY_ADMINI_STRATOR"] = 3] = "REFUSED_BY_ADMINI_STRATOR";
  GroupNotifyMsgType2[GroupNotifyMsgType2["AGREED_TOJOIN_DIRECT"] = 4] = "AGREED_TOJOIN_DIRECT";
  GroupNotifyMsgType2[GroupNotifyMsgType2["INVITED_NEED_ADMINI_STRATOR_PASS"] = 5] = "INVITED_NEED_ADMINI_STRATOR_PASS";
  GroupNotifyMsgType2[GroupNotifyMsgType2["AGREED_TO_JOIN_BY_ADMINI_STRATOR"] = 6] = "AGREED_TO_JOIN_BY_ADMINI_STRATOR";
  GroupNotifyMsgType2[GroupNotifyMsgType2["REQUEST_JOIN_NEED_ADMINI_STRATOR_PASS"] = 7] = "REQUEST_JOIN_NEED_ADMINI_STRATOR_PASS";
  GroupNotifyMsgType2[GroupNotifyMsgType2["SET_ADMIN"] = 8] = "SET_ADMIN";
  GroupNotifyMsgType2[GroupNotifyMsgType2["KICK_MEMBER_NOTIFY_ADMIN"] = 9] = "KICK_MEMBER_NOTIFY_ADMIN";
  GroupNotifyMsgType2[GroupNotifyMsgType2["KICK_MEMBER_NOTIFY_KICKED"] = 10] = "KICK_MEMBER_NOTIFY_KICKED";
  GroupNotifyMsgType2[GroupNotifyMsgType2["MEMBER_LEAVE_NOTIFY_ADMIN"] = 11] = "MEMBER_LEAVE_NOTIFY_ADMIN";
  GroupNotifyMsgType2[GroupNotifyMsgType2["CANCEL_ADMIN_NOTIFY_CANCELED"] = 12] = "CANCEL_ADMIN_NOTIFY_CANCELED";
  GroupNotifyMsgType2[GroupNotifyMsgType2["CANCEL_ADMIN_NOTIFY_ADMIN"] = 13] = "CANCEL_ADMIN_NOTIFY_ADMIN";
  GroupNotifyMsgType2[GroupNotifyMsgType2["TRANSFER_GROUP_NOTIFY_OLDOWNER"] = 14] = "TRANSFER_GROUP_NOTIFY_OLDOWNER";
  GroupNotifyMsgType2[GroupNotifyMsgType2["TRANSFER_GROUP_NOTIFY_ADMIN"] = 15] = "TRANSFER_GROUP_NOTIFY_ADMIN";
  return GroupNotifyMsgType2;
})(GroupNotifyMsgType || {});
var GroupNotifyMsgStatus = /* @__PURE__ */ ((GroupNotifyMsgStatus2) => {
  GroupNotifyMsgStatus2[GroupNotifyMsgStatus2["KINIT"] = 0] = "KINIT";
  GroupNotifyMsgStatus2[GroupNotifyMsgStatus2["KUNHANDLE"] = 1] = "KUNHANDLE";
  GroupNotifyMsgStatus2[GroupNotifyMsgStatus2["KAGREED"] = 2] = "KAGREED";
  GroupNotifyMsgStatus2[GroupNotifyMsgStatus2["KREFUSED"] = 3] = "KREFUSED";
  GroupNotifyMsgStatus2[GroupNotifyMsgStatus2["KIGNORED"] = 4] = "KIGNORED";
  return GroupNotifyMsgStatus2;
})(GroupNotifyMsgStatus || {});
var NTGroupRequestOperateTypes = /* @__PURE__ */ ((NTGroupRequestOperateTypes2) => {
  NTGroupRequestOperateTypes2[NTGroupRequestOperateTypes2["KUNSPECIFIED"] = 0] = "KUNSPECIFIED";
  NTGroupRequestOperateTypes2[NTGroupRequestOperateTypes2["KAGREE"] = 1] = "KAGREE";
  NTGroupRequestOperateTypes2[NTGroupRequestOperateTypes2["KREFUSE"] = 2] = "KREFUSE";
  NTGroupRequestOperateTypes2[NTGroupRequestOperateTypes2["KIGNORE"] = 3] = "KIGNORE";
  NTGroupRequestOperateTypes2[NTGroupRequestOperateTypes2["KDELETE"] = 4] = "KDELETE";
  return NTGroupRequestOperateTypes2;
})(NTGroupRequestOperateTypes || {});
var BuddyReqType = /* @__PURE__ */ ((BuddyReqType2) => {
  BuddyReqType2[BuddyReqType2["KMEINITIATOR"] = 0] = "KMEINITIATOR";
  BuddyReqType2[BuddyReqType2["KPEERINITIATOR"] = 1] = "KPEERINITIATOR";
  BuddyReqType2[BuddyReqType2["KMEAGREED"] = 2] = "KMEAGREED";
  BuddyReqType2[BuddyReqType2["KMEAGREEDANDADDED"] = 3] = "KMEAGREEDANDADDED";
  BuddyReqType2[BuddyReqType2["KPEERAGREED"] = 4] = "KPEERAGREED";
  BuddyReqType2[BuddyReqType2["KPEERAGREEDANDADDED"] = 5] = "KPEERAGREEDANDADDED";
  BuddyReqType2[BuddyReqType2["KPEERREFUSED"] = 6] = "KPEERREFUSED";
  BuddyReqType2[BuddyReqType2["KMEREFUSED"] = 7] = "KMEREFUSED";
  BuddyReqType2[BuddyReqType2["KMEIGNORED"] = 8] = "KMEIGNORED";
  BuddyReqType2[BuddyReqType2["KMEAGREEANYONE"] = 9] = "KMEAGREEANYONE";
  BuddyReqType2[BuddyReqType2["KMESETQUESTION"] = 10] = "KMESETQUESTION";
  BuddyReqType2[BuddyReqType2["KMEAGREEANDADDFAILED"] = 11] = "KMEAGREEANDADDFAILED";
  BuddyReqType2[BuddyReqType2["KMSGINFO"] = 12] = "KMSGINFO";
  BuddyReqType2[BuddyReqType2["KMEINITIATORWAITPEERCONFIRM"] = 13] = "KMEINITIATORWAITPEERCONFIRM";
  return BuddyReqType2;
})(BuddyReqType || {});
var MemberExtSourceType = /* @__PURE__ */ ((MemberExtSourceType2) => {
  MemberExtSourceType2[MemberExtSourceType2["DEFAULTTYPE"] = 0] = "DEFAULTTYPE";
  MemberExtSourceType2[MemberExtSourceType2["TITLETYPE"] = 1] = "TITLETYPE";
  MemberExtSourceType2[MemberExtSourceType2["NEWGROUPTYPE"] = 2] = "NEWGROUPTYPE";
  return MemberExtSourceType2;
})(MemberExtSourceType || {});

var WebHonorType = /* @__PURE__ */ ((WebHonorType2) => {
  WebHonorType2["ALL"] = "all";
  WebHonorType2["TALKATIVE"] = "talkative";
  WebHonorType2["PERFORMER"] = "performer";
  WebHonorType2["LEGEND"] = "legend";
  WebHonorType2["STRONG_NEWBIE"] = "strong_newbie";
  WebHonorType2["EMOTION"] = "emotion";
  return WebHonorType2;
})(WebHonorType || {});

const IMAGE_HTTP_HOST = "https://gchat.qpic.cn";
const IMAGE_HTTP_HOST_NT = "https://multimedia.nt.qq.com.cn";

var JsonGrayBusiId = /* @__PURE__ */ ((JsonGrayBusiId2) => {
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_AV_C2C_NOTICE"] = 2021] = "AIO_AV_C2C_NOTICE";
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_AV_GROUP_NOTICE"] = 2022] = "AIO_AV_GROUP_NOTICE";
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_C2C_DONT_DISTURB"] = 2100] = "AIO_C2C_DONT_DISTURB";
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_CRM_FLAGS_TIPS"] = 2050] = "AIO_CRM_FLAGS_TIPS";
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_GROUP_ESSENCE_MSG_TIP"] = 2401] = "AIO_GROUP_ESSENCE_MSG_TIP";
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_NUDGE_CUSTOM_GUIDE"] = 2041] = "AIO_NUDGE_CUSTOM_GUIDE";
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_PUSH_GUIDE_GRAY_TIPS"] = 2701] = "AIO_PUSH_GUIDE_GRAY_TIPS";
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_RECALL_MSGCUSTOM_WORDINGGUIDE"] = 2e3] = "AIO_RECALL_MSGCUSTOM_WORDINGGUIDE";
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_ROBOT_SAFETY_TIP"] = 2201] = "AIO_ROBOT_SAFETY_TIP";
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_ZPLAN_EMOTICON_GUIDE"] = 2301] = "AIO_ZPLAN_EMOTICON_GUIDE";
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_ZPLAN_SCENE_LINKAGE"] = 2302] = "AIO_ZPLAN_SCENE_LINKAGE";
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_ZPLAN_SEND_MEME"] = 2300] = "AIO_ZPLAN_SEND_MEME";
  JsonGrayBusiId2[JsonGrayBusiId2["DISBAND_DISCUSSION_GRAY_TIP_ID"] = 2603] = "DISBAND_DISCUSSION_GRAY_TIP_ID";
  JsonGrayBusiId2[JsonGrayBusiId2["FILE_SENDING_SIZE_4GB_LIMIT"] = 3003] = "FILE_SENDING_SIZE_4GB_LIMIT";
  JsonGrayBusiId2[JsonGrayBusiId2["GROUP_AIO_CONFIGURABLE_GRAY_TIPS"] = 2407] = "GROUP_AIO_CONFIGURABLE_GRAY_TIPS";
  JsonGrayBusiId2[JsonGrayBusiId2["GROUP_AIO_HOME_SCHOOL_WELCOME_GRAY_TIP_ID"] = 2404] = "GROUP_AIO_HOME_SCHOOL_WELCOME_GRAY_TIP_ID";
  JsonGrayBusiId2[JsonGrayBusiId2["GROUP_AIO_MSG_FREQUENCY_GRAY_TIP_ID"] = 2406] = "GROUP_AIO_MSG_FREQUENCY_GRAY_TIP_ID";
  JsonGrayBusiId2[JsonGrayBusiId2["GROUP_AIO_SHUTUP_GRAY_TIP_ID"] = 2402] = "GROUP_AIO_SHUTUP_GRAY_TIP_ID";
  JsonGrayBusiId2[JsonGrayBusiId2["GROUP_AIO_TEMPORARY_GRAY_TIP_ID"] = 2405] = "GROUP_AIO_TEMPORARY_GRAY_TIP_ID";
  JsonGrayBusiId2[JsonGrayBusiId2["GROUP_AIO_UNREAD_MSG_AI_SUMMARY"] = 2408] = "GROUP_AIO_UNREAD_MSG_AI_SUMMARY";
  JsonGrayBusiId2[JsonGrayBusiId2["GROUP_AIO_UPLOAD_PERMISSIONS_GRAY_TIP_ID"] = 2403] = "GROUP_AIO_UPLOAD_PERMISSIONS_GRAY_TIP_ID";
  JsonGrayBusiId2[JsonGrayBusiId2["LITE_ACTION"] = 86] = "LITE_ACTION";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_CANCEL_RECV_ON_RECVING"] = 4] = "ONLINE_FILE_CANCEL_RECV_ON_RECVING";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_GO_OFFLINE"] = 11] = "ONLINE_FILE_GO_OFFLINE";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_GO_OFFLINE_ALL"] = 12] = "ONLINE_FILE_GO_OFFLINE_ALL";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_RECV_BY_MOBILE"] = 13] = "ONLINE_FILE_RECV_BY_MOBILE";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_RECV_ERROR"] = 10] = "ONLINE_FILE_RECV_ERROR";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_REFUSE_ALL_RECV"] = 7] = "ONLINE_FILE_REFUSE_ALL_RECV";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_REFUSE_ALL_RECV_ON_RECVING"] = 8] = "ONLINE_FILE_REFUSE_ALL_RECV_ON_RECVING";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_REFUSE_RECV"] = 3] = "ONLINE_FILE_REFUSE_RECV";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_SEND_ERROR"] = 9] = "ONLINE_FILE_SEND_ERROR";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_STOP_ALL_SEND"] = 5] = "ONLINE_FILE_STOP_ALL_SEND";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_STOP_ALL_SEND_ON_SENDING"] = 6] = "ONLINE_FILE_STOP_ALL_SEND_ON_SENDING";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_STOP_SEND"] = 1] = "ONLINE_FILE_STOP_SEND";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_STOP_SEND_ON_SENDING"] = 2] = "ONLINE_FILE_STOP_SEND_ON_SENDING";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_GROUP_HOME_WORK"] = 51] = "ONLINE_GROUP_HOME_WORK";
  JsonGrayBusiId2[JsonGrayBusiId2["PTT_AUTO_CHANGE_GUIDE"] = 2060] = "PTT_AUTO_CHANGE_GUIDE";
  JsonGrayBusiId2[JsonGrayBusiId2["QCIRCLE_SHOW_FULE_TIPS"] = 2601] = "QCIRCLE_SHOW_FULE_TIPS";
  JsonGrayBusiId2[JsonGrayBusiId2["QWALLET_GRAY_TIP_ID"] = 2602] = "QWALLET_GRAY_TIP_ID";
  JsonGrayBusiId2[JsonGrayBusiId2["RED_BAG"] = 81] = "RED_BAG";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_C2C_GROUP_AIO_SETUP_GROUP_AND_REMARK"] = 1005] = "RELATION_C2C_GROUP_AIO_SETUP_GROUP_AND_REMARK";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_C2C_LOVER_BONUS"] = 1003] = "RELATION_C2C_LOVER_BONUS";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_C2C_MEMBER_ADD"] = 1017] = "RELATION_C2C_MEMBER_ADD";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_C2C_REACTIVE_DEGRADE_MSG"] = 1019] = "RELATION_C2C_REACTIVE_DEGRADE_MSG";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_C2C_REACTIVE_UPGRADE_MSG"] = 1018] = "RELATION_C2C_REACTIVE_UPGRADE_MSG";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_C2C_SAY_HELLO"] = 1004] = "RELATION_C2C_SAY_HELLO";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_CHAIN_BLACKED"] = 1e3] = "RELATION_CHAIN_BLACKED";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_CHAIN_MATCH_FRIEND"] = 1007] = "RELATION_CHAIN_MATCH_FRIEND";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_CREATE_GROUP_GRAY_TIP_ID"] = 1009] = "RELATION_CREATE_GROUP_GRAY_TIP_ID";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_EMOJIEGG_SHOW"] = 1001] = "RELATION_EMOJIEGG_SHOW";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_EMOJIEGG_WILL_DEGRADE"] = 1002] = "RELATION_EMOJIEGG_WILL_DEGRADE";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_FRIEND_CLONE_INFO"] = 1006] = "RELATION_FRIEND_CLONE_INFO";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_GROUP_BATCH_ADD_FRIEND"] = 1020] = "RELATION_GROUP_BATCH_ADD_FRIEND";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_GROUP_MEMBER_ADD"] = 1022] = "RELATION_GROUP_MEMBER_ADD";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_GROUP_MEMBER_ADD_WITH_MODIFY_NAME"] = 1015] = "RELATION_GROUP_MEMBER_ADD_WITH_MODIFY_NAME";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_GROUP_MEMBER_ADD_WITH_WELCOME"] = 1016] = "RELATION_GROUP_MEMBER_ADD_WITH_WELCOME";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_GROUP_MEMBER_RECOMMEND"] = 1021] = "RELATION_GROUP_MEMBER_RECOMMEND";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_GROUP_SHUT_UP"] = 1014] = "RELATION_GROUP_SHUT_UP";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_LIMIT_TMP_CONVERSATION_SET"] = 1011] = "RELATION_LIMIT_TMP_CONVERSATION_SET";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_NEARBY_GOTO_VERIFY"] = 1008] = "RELATION_NEARBY_GOTO_VERIFY";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_ONEWAY_FRIEND_GRAY_TIP_ID"] = 1012] = "RELATION_ONEWAY_FRIEND_GRAY_TIP_ID";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_ONEWAY_FRIEND_NEW_GRAY_TIP_ID"] = 1013] = "RELATION_ONEWAY_FRIEND_NEW_GRAY_TIP_ID";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_YQT"] = 1010] = "RELATION_YQT";
  JsonGrayBusiId2[JsonGrayBusiId2["TROOP_ADD_FRIEND_ACTIVE"] = 19264] = "TROOP_ADD_FRIEND_ACTIVE";
  JsonGrayBusiId2[JsonGrayBusiId2["TROOP_ADD_FRIEND_HOT_CHAT"] = 19265] = "TROOP_ADD_FRIEND_HOT_CHAT";
  JsonGrayBusiId2[JsonGrayBusiId2["TROOP_ADD_FRIEND_NEW_MEMBER"] = 19267] = "TROOP_ADD_FRIEND_NEW_MEMBER";
  JsonGrayBusiId2[JsonGrayBusiId2["TROOP_ADD_FRIEND_REPLY_OR_AT"] = 19266] = "TROOP_ADD_FRIEND_REPLY_OR_AT";
  JsonGrayBusiId2[JsonGrayBusiId2["TROOP_BREAK_ICE"] = 10405] = "TROOP_BREAK_ICE";
  JsonGrayBusiId2[JsonGrayBusiId2["TROOP_FLAME_IGNITED"] = 19273] = "TROOP_FLAME_IGNITED";
  JsonGrayBusiId2[JsonGrayBusiId2["UI_RESERVE_100000_110000"] = 1e5] = "UI_RESERVE_100000_110000";
  JsonGrayBusiId2[JsonGrayBusiId2["VAS_FILE_UPLOAD_OVER_1G"] = 3002] = "VAS_FILE_UPLOAD_OVER_1G";
  JsonGrayBusiId2[JsonGrayBusiId2["VAS_FILE_UPLOAD_OVER_LIMIT"] = 3001] = "VAS_FILE_UPLOAD_OVER_LIMIT";
  return JsonGrayBusiId2;
})(JsonGrayBusiId || {});

const defaultMessages = 'End-Of-Stream';
/**
 * Thrown on read operation of the end of file or stream has been reached
 */
class EndOfStreamError extends Error {
    constructor() {
        super(defaultMessages);
        this.name = "EndOfStreamError";
    }
}
class AbortError extends Error {
    constructor(message = "The operation was aborted") {
        super(message);
        this.name = "AbortError";
    }
}

class Deferred {
    constructor() {
        this.resolve = () => null;
        this.reject = () => null;
        this.promise = new Promise((resolve, reject) => {
            this.reject = reject;
            this.resolve = resolve;
        });
    }
}

class AbstractStreamReader {
    constructor() {
        this.endOfStream = false;
        this.interrupted = false;
        /**
         * Store peeked data
         * @type {Array}
         */
        this.peekQueue = [];
    }
    async peek(uint8Array, mayBeLess = false) {
        const bytesRead = await this.read(uint8Array, mayBeLess);
        this.peekQueue.push(uint8Array.subarray(0, bytesRead)); // Put read data back to peek buffer
        return bytesRead;
    }
    async read(buffer, mayBeLess = false) {
        if (buffer.length === 0) {
            return 0;
        }
        let bytesRead = this.readFromPeekBuffer(buffer);
        if (!this.endOfStream) {
            bytesRead += await this.readRemainderFromStream(buffer.subarray(bytesRead), mayBeLess);
        }
        if (bytesRead === 0 && !mayBeLess) {
            throw new EndOfStreamError();
        }
        return bytesRead;
    }
    /**
     * Read chunk from stream
     * @param buffer - Target Uint8Array (or Buffer) to store data read from stream in
     * @returns Number of bytes read
     */
    readFromPeekBuffer(buffer) {
        let remaining = buffer.length;
        let bytesRead = 0;
        // consume peeked data first
        while (this.peekQueue.length > 0 && remaining > 0) {
            const peekData = this.peekQueue.pop(); // Front of queue
            if (!peekData)
                throw new Error('peekData should be defined');
            const lenCopy = Math.min(peekData.length, remaining);
            buffer.set(peekData.subarray(0, lenCopy), bytesRead);
            bytesRead += lenCopy;
            remaining -= lenCopy;
            if (lenCopy < peekData.length) {
                // remainder back to queue
                this.peekQueue.push(peekData.subarray(lenCopy));
            }
        }
        return bytesRead;
    }
    async readRemainderFromStream(buffer, mayBeLess) {
        let bytesRead = 0;
        // Continue reading from stream if required
        while (bytesRead < buffer.length && !this.endOfStream) {
            if (this.interrupted) {
                throw new AbortError();
            }
            const chunkLen = await this.readFromStream(buffer.subarray(bytesRead), mayBeLess);
            if (chunkLen === 0)
                break;
            bytesRead += chunkLen;
        }
        if (!mayBeLess && bytesRead < buffer.length) {
            throw new EndOfStreamError();
        }
        return bytesRead;
    }
}

/**
 * Node.js Readable Stream Reader
 * Ref: https://nodejs.org/api/stream.html#readable-streams
 */
class StreamReader extends AbstractStreamReader {
    constructor(s) {
        super();
        this.s = s;
        /**
         * Deferred used for postponed read request (as not data is yet available to read)
         */
        this.deferred = null;
        if (!s.read || !s.once) {
            throw new Error('Expected an instance of stream.Readable');
        }
        this.s.once('end', () => {
            this.endOfStream = true;
            if (this.deferred) {
                this.deferred.resolve(0);
            }
        });
        this.s.once('error', err => this.reject(err));
        this.s.once('close', () => this.abort());
    }
    /**
     * Read chunk from stream
     * @param buffer Target Uint8Array (or Buffer) to store data read from stream in
     * @param mayBeLess - If true, may fill the buffer partially
     * @returns Number of bytes read
     */
    async readFromStream(buffer, mayBeLess) {
        if (buffer.length === 0)
            return 0;
        const readBuffer = this.s.read(buffer.length);
        if (readBuffer) {
            buffer.set(readBuffer);
            return readBuffer.length;
        }
        const request = {
            buffer,
            mayBeLess,
            deferred: new Deferred()
        };
        this.deferred = request.deferred;
        this.s.once('readable', () => {
            this.readDeferred(request);
        });
        return request.deferred.promise;
    }
    /**
     * Process deferred read request
     * @param request Deferred read request
     */
    readDeferred(request) {
        const readBuffer = this.s.read(request.buffer.length);
        if (readBuffer) {
            request.buffer.set(readBuffer);
            request.deferred.resolve(readBuffer.length);
            this.deferred = null;
        }
        else {
            this.s.once('readable', () => {
                this.readDeferred(request);
            });
        }
    }
    reject(err) {
        this.interrupted = true;
        if (this.deferred) {
            this.deferred.reject(err);
            this.deferred = null;
        }
    }
    async abort() {
        this.reject(new AbortError());
    }
    async close() {
        return this.abort();
    }
}

class WebStreamReader extends AbstractStreamReader {
    constructor(reader) {
        super();
        this.reader = reader;
    }
    async abort() {
        return this.close();
    }
    async close() {
        this.reader.releaseLock();
    }
}

/**
 * Read from a WebStream using a BYOB reader
 * Reference: https://nodejs.org/api/webstreams.html#class-readablestreambyobreader
 */
class WebStreamByobReader extends WebStreamReader {
    /**
     * Read from stream
     * @param buffer - Target Uint8Array (or Buffer) to store data read from stream in
     * @param mayBeLess - If true, may fill the buffer partially
     * @protected Bytes read
     */
    async readFromStream(buffer, mayBeLess) {
        if (buffer.length === 0)
            return 0;
        // @ts-ignore
        const result = await this.reader.read(new Uint8Array(buffer.length), { min: mayBeLess ? undefined : buffer.length });
        if (result.done) {
            this.endOfStream = result.done;
        }
        if (result.value) {
            buffer.set(result.value);
            return result.value.length;
        }
        return 0;
    }
}

class WebStreamDefaultReader extends AbstractStreamReader {
    constructor(reader) {
        super();
        this.reader = reader;
        this.buffer = null; // Internal buffer to store excess data
    }
    /**
     * Copy chunk to target, and store the remainder in this.buffer
     */
    writeChunk(target, chunk) {
        const written = Math.min(chunk.length, target.length);
        target.set(chunk.subarray(0, written));
        // Adjust the remainder of the buffer
        if (written < chunk.length) {
            this.buffer = chunk.subarray(written);
        }
        else {
            this.buffer = null;
        }
        return written;
    }
    /**
     * Read from stream
     * @param buffer - Target Uint8Array (or Buffer) to store data read from stream in
     * @param mayBeLess - If true, may fill the buffer partially
     * @protected Bytes read
     */
    async readFromStream(buffer, mayBeLess) {
        if (buffer.length === 0)
            return 0;
        let totalBytesRead = 0;
        // Serve from the internal buffer first
        if (this.buffer) {
            totalBytesRead += this.writeChunk(buffer, this.buffer);
        }
        // Continue reading from the stream if more data is needed
        while (totalBytesRead < buffer.length && !this.endOfStream) {
            const result = await this.reader.read();
            if (result.done) {
                this.endOfStream = true;
                break;
            }
            if (result.value) {
                totalBytesRead += this.writeChunk(buffer.subarray(totalBytesRead), result.value);
            }
        }
        if (!mayBeLess && totalBytesRead === 0 && this.endOfStream) {
            throw new EndOfStreamError();
        }
        return totalBytesRead;
    }
    abort() {
        this.interrupted = true;
        return this.reader.cancel();
    }
    async close() {
        await this.abort();
        this.reader.releaseLock();
    }
}

function makeWebStreamReader(stream) {
    try {
        const reader = stream.getReader({ mode: "byob" });
        if (reader instanceof ReadableStreamDefaultReader) {
            // Fallback to default reader in case `mode: byob` is ignored
            return new WebStreamDefaultReader(reader);
        }
        return new WebStreamByobReader(reader);
    }
    catch (error) {
        if (error instanceof TypeError) {
            // Fallback to default reader in case `mode: byob` rejected by a `TypeError`
            return new WebStreamDefaultReader(stream.getReader());
        }
        throw error;
    }
}

/**
 * Core tokenizer
 */
class AbstractTokenizer {
    /**
     * Constructor
     * @param options Tokenizer options
     * @protected
     */
    constructor(options) {
        this.numBuffer = new Uint8Array(8);
        /**
         * Tokenizer-stream position
         */
        this.position = 0;
        this.onClose = options?.onClose;
        if (options?.abortSignal) {
            options.abortSignal.addEventListener('abort', () => {
                this.abort();
            });
        }
    }
    /**
     * Read a token from the tokenizer-stream
     * @param token - The token to read
     * @param position - If provided, the desired position in the tokenizer-stream
     * @returns Promise with token data
     */
    async readToken(token, position = this.position) {
        const uint8Array = new Uint8Array(token.len);
        const len = await this.readBuffer(uint8Array, { position });
        if (len < token.len)
            throw new EndOfStreamError();
        return token.get(uint8Array, 0);
    }
    /**
     * Peek a token from the tokenizer-stream.
     * @param token - Token to peek from the tokenizer-stream.
     * @param position - Offset where to begin reading within the file. If position is null, data will be read from the current file position.
     * @returns Promise with token data
     */
    async peekToken(token, position = this.position) {
        const uint8Array = new Uint8Array(token.len);
        const len = await this.peekBuffer(uint8Array, { position });
        if (len < token.len)
            throw new EndOfStreamError();
        return token.get(uint8Array, 0);
    }
    /**
     * Read a numeric token from the stream
     * @param token - Numeric token
     * @returns Promise with number
     */
    async readNumber(token) {
        const len = await this.readBuffer(this.numBuffer, { length: token.len });
        if (len < token.len)
            throw new EndOfStreamError();
        return token.get(this.numBuffer, 0);
    }
    /**
     * Read a numeric token from the stream
     * @param token - Numeric token
     * @returns Promise with number
     */
    async peekNumber(token) {
        const len = await this.peekBuffer(this.numBuffer, { length: token.len });
        if (len < token.len)
            throw new EndOfStreamError();
        return token.get(this.numBuffer, 0);
    }
    /**
     * Ignore number of bytes, advances the pointer in under tokenizer-stream.
     * @param length - Number of bytes to ignore
     * @return resolves the number of bytes ignored, equals length if this available, otherwise the number of bytes available
     */
    async ignore(length) {
        if (this.fileInfo.size !== undefined) {
            const bytesLeft = this.fileInfo.size - this.position;
            if (length > bytesLeft) {
                this.position += bytesLeft;
                return bytesLeft;
            }
        }
        this.position += length;
        return length;
    }
    async close() {
        await this.abort();
        await this.onClose?.();
    }
    normalizeOptions(uint8Array, options) {
        if (!this.supportsRandomAccess() && options && options.position !== undefined && options.position < this.position) {
            throw new Error('`options.position` must be equal or greater than `tokenizer.position`');
        }
        return {
            ...{
                mayBeLess: false,
                offset: 0,
                length: uint8Array.length,
                position: this.position
            }, ...options
        };
    }
    abort() {
        return Promise.resolve(); // Ignore abort signal
    }
}

const maxBufferSize = 256000;
class ReadStreamTokenizer extends AbstractTokenizer {
    /**
     * Constructor
     * @param streamReader stream-reader to read from
     * @param options Tokenizer options
     */
    constructor(streamReader, options) {
        super(options);
        this.streamReader = streamReader;
        this.fileInfo = options?.fileInfo ?? {};
    }
    /**
     * Read buffer from tokenizer
     * @param uint8Array - Target Uint8Array to fill with data read from the tokenizer-stream
     * @param options - Read behaviour options
     * @returns Promise with number of bytes read
     */
    async readBuffer(uint8Array, options) {
        const normOptions = this.normalizeOptions(uint8Array, options);
        const skipBytes = normOptions.position - this.position;
        if (skipBytes > 0) {
            await this.ignore(skipBytes);
            return this.readBuffer(uint8Array, options);
        }
        if (skipBytes < 0) {
            throw new Error('`options.position` must be equal or greater than `tokenizer.position`');
        }
        if (normOptions.length === 0) {
            return 0;
        }
        const bytesRead = await this.streamReader.read(uint8Array.subarray(0, normOptions.length), normOptions.mayBeLess);
        this.position += bytesRead;
        if ((!options || !options.mayBeLess) && bytesRead < normOptions.length) {
            throw new EndOfStreamError();
        }
        return bytesRead;
    }
    /**
     * Peek (read ahead) buffer from tokenizer
     * @param uint8Array - Uint8Array (or Buffer) to write data to
     * @param options - Read behaviour options
     * @returns Promise with number of bytes peeked
     */
    async peekBuffer(uint8Array, options) {
        const normOptions = this.normalizeOptions(uint8Array, options);
        let bytesRead = 0;
        if (normOptions.position) {
            const skipBytes = normOptions.position - this.position;
            if (skipBytes > 0) {
                const skipBuffer = new Uint8Array(normOptions.length + skipBytes);
                bytesRead = await this.peekBuffer(skipBuffer, { mayBeLess: normOptions.mayBeLess });
                uint8Array.set(skipBuffer.subarray(skipBytes));
                return bytesRead - skipBytes;
            }
            if (skipBytes < 0) {
                throw new Error('Cannot peek from a negative offset in a stream');
            }
        }
        if (normOptions.length > 0) {
            try {
                bytesRead = await this.streamReader.peek(uint8Array.subarray(0, normOptions.length), normOptions.mayBeLess);
            }
            catch (err) {
                if (options?.mayBeLess && err instanceof EndOfStreamError) {
                    return 0;
                }
                throw err;
            }
            if ((!normOptions.mayBeLess) && bytesRead < normOptions.length) {
                throw new EndOfStreamError();
            }
        }
        return bytesRead;
    }
    async ignore(length) {
        // debug(`ignore ${this.position}...${this.position + length - 1}`);
        const bufSize = Math.min(maxBufferSize, length);
        const buf = new Uint8Array(bufSize);
        let totBytesRead = 0;
        while (totBytesRead < length) {
            const remaining = length - totBytesRead;
            const bytesRead = await this.readBuffer(buf, { length: Math.min(bufSize, remaining) });
            if (bytesRead < 0) {
                return bytesRead;
            }
            totBytesRead += bytesRead;
        }
        return totBytesRead;
    }
    abort() {
        return this.streamReader.abort();
    }
    async close() {
        return this.streamReader.close();
    }
    supportsRandomAccess() {
        return false;
    }
}

class BufferTokenizer extends AbstractTokenizer {
    /**
     * Construct BufferTokenizer
     * @param uint8Array - Uint8Array to tokenize
     * @param options Tokenizer options
     */
    constructor(uint8Array, options) {
        super(options);
        this.uint8Array = uint8Array;
        this.fileInfo = { ...options?.fileInfo ?? {}, ...{ size: uint8Array.length } };
    }
    /**
     * Read buffer from tokenizer
     * @param uint8Array - Uint8Array to tokenize
     * @param options - Read behaviour options
     * @returns {Promise<number>}
     */
    async readBuffer(uint8Array, options) {
        if (options?.position) {
            this.position = options.position;
        }
        const bytesRead = await this.peekBuffer(uint8Array, options);
        this.position += bytesRead;
        return bytesRead;
    }
    /**
     * Peek (read ahead) buffer from tokenizer
     * @param uint8Array
     * @param options - Read behaviour options
     * @returns {Promise<number>}
     */
    async peekBuffer(uint8Array, options) {
        const normOptions = this.normalizeOptions(uint8Array, options);
        const bytes2read = Math.min(this.uint8Array.length - normOptions.position, normOptions.length);
        if ((!normOptions.mayBeLess) && bytes2read < normOptions.length) {
            throw new EndOfStreamError();
        }
        uint8Array.set(this.uint8Array.subarray(normOptions.position, normOptions.position + bytes2read));
        return bytes2read;
    }
    close() {
        return super.close();
    }
    supportsRandomAccess() {
        return true;
    }
    setPosition(position) {
        this.position = position;
    }
}

class BlobTokenizer extends AbstractTokenizer {
    /**
     * Construct BufferTokenizer
     * @param blob - Uint8Array to tokenize
     * @param options Tokenizer options
     */
    constructor(blob, options) {
        super(options);
        this.blob = blob;
        this.fileInfo = { ...options?.fileInfo ?? {}, ...{ size: blob.size, mimeType: blob.type } };
    }
    /**
     * Read buffer from tokenizer
     * @param uint8Array - Uint8Array to tokenize
     * @param options - Read behaviour options
     * @returns {Promise<number>}
     */
    async readBuffer(uint8Array, options) {
        if (options?.position) {
            this.position = options.position;
        }
        const bytesRead = await this.peekBuffer(uint8Array, options);
        this.position += bytesRead;
        return bytesRead;
    }
    /**
     * Peek (read ahead) buffer from tokenizer
     * @param buffer
     * @param options - Read behaviour options
     * @returns {Promise<number>}
     */
    async peekBuffer(buffer, options) {
        const normOptions = this.normalizeOptions(buffer, options);
        const bytes2read = Math.min(this.blob.size - normOptions.position, normOptions.length);
        if ((!normOptions.mayBeLess) && bytes2read < normOptions.length) {
            throw new EndOfStreamError();
        }
        const arrayBuffer = await this.blob.slice(normOptions.position, normOptions.position + bytes2read).arrayBuffer();
        buffer.set(new Uint8Array(arrayBuffer));
        return bytes2read;
    }
    close() {
        return super.close();
    }
    supportsRandomAccess() {
        return true;
    }
    setPosition(position) {
        this.position = position;
    }
}

/**
 * Construct ReadStreamTokenizer from given Stream.
 * Will set fileSize, if provided given Stream has set the .path property/
 * @param stream - Read from Node.js Stream.Readable
 * @param options - Tokenizer options
 * @returns ReadStreamTokenizer
 */
function fromStream$1(stream, options) {
    const streamReader = new StreamReader(stream);
    const _options = options ?? {};
    const chainedClose = _options.onClose;
    _options.onClose = async () => {
        await streamReader.close();
        if (chainedClose) {
            return chainedClose();
        }
    };
    return new ReadStreamTokenizer(streamReader, _options);
}
/**
 * Construct ReadStreamTokenizer from given ReadableStream (WebStream API).
 * Will set fileSize, if provided given Stream has set the .path property/
 * @param webStream - Read from Node.js Stream.Readable (must be a byte stream)
 * @param options - Tokenizer options
 * @returns ReadStreamTokenizer
 */
function fromWebStream(webStream, options) {
    const webStreamReader = makeWebStreamReader(webStream);
    const _options = options ?? {};
    const chainedClose = _options.onClose;
    _options.onClose = async () => {
        await webStreamReader.close();
        if (chainedClose) {
            return chainedClose();
        }
    };
    return new ReadStreamTokenizer(webStreamReader, _options);
}
/**
 * Construct ReadStreamTokenizer from given Buffer.
 * @param uint8Array - Uint8Array to tokenize
 * @param options - Tokenizer options
 * @returns BufferTokenizer
 */
function fromBuffer$1(uint8Array, options) {
    return new BufferTokenizer(uint8Array, options);
}
/**
 * Construct ReadStreamTokenizer from given Blob.
 * @param blob - Uint8Array to tokenize
 * @param options - Tokenizer options
 * @returns BufferTokenizer
 */
function fromBlob(blob, options) {
    return new BlobTokenizer(blob, options);
}

class FileTokenizer extends AbstractTokenizer {
    /**
     * Create tokenizer from provided file path
     * @param sourceFilePath File path
     */
    static async fromFile(sourceFilePath) {
        const fileHandle = await open(sourceFilePath, 'r');
        const stat = await fileHandle.stat();
        return new FileTokenizer(fileHandle, { fileInfo: { path: sourceFilePath, size: stat.size } });
    }
    constructor(fileHandle, options) {
        super(options);
        this.fileHandle = fileHandle;
        this.fileInfo = options.fileInfo;
    }
    /**
     * Read buffer from file
     * @param uint8Array - Uint8Array to write result to
     * @param options - Read behaviour options
     * @returns Promise number of bytes read
     */
    async readBuffer(uint8Array, options) {
        const normOptions = this.normalizeOptions(uint8Array, options);
        this.position = normOptions.position;
        if (normOptions.length === 0)
            return 0;
        const res = await this.fileHandle.read(uint8Array, 0, normOptions.length, normOptions.position);
        this.position += res.bytesRead;
        if (res.bytesRead < normOptions.length && (!options || !options.mayBeLess)) {
            throw new EndOfStreamError();
        }
        return res.bytesRead;
    }
    /**
     * Peek buffer from file
     * @param uint8Array - Uint8Array (or Buffer) to write data to
     * @param options - Read behaviour options
     * @returns Promise number of bytes read
     */
    async peekBuffer(uint8Array, options) {
        const normOptions = this.normalizeOptions(uint8Array, options);
        const res = await this.fileHandle.read(uint8Array, 0, normOptions.length, normOptions.position);
        if ((!normOptions.mayBeLess) && res.bytesRead < normOptions.length) {
            throw new EndOfStreamError();
        }
        return res.bytesRead;
    }
    async close() {
        await this.fileHandle.close();
        return super.close();
    }
    setPosition(position) {
        this.position = position;
    }
    supportsRandomAccess() {
        return true;
    }
}

/**
 * Construct ReadStreamTokenizer from given Stream.
 * Will set fileSize, if provided given Stream has set the .path property.
 * @param stream - Node.js Stream.Readable
 * @param options - Pass additional file information to the tokenizer
 * @returns Tokenizer
 */
async function fromStream(stream, options) {
    const rst = fromStream$1(stream, options);
    if (stream.path) {
        const stat$1 = await stat(stream.path);
        rst.fileInfo.path = stream.path;
        rst.fileInfo.size = stat$1.size;
    }
    return rst;
}
const fromFile = FileTokenizer.fromFile;

var ieee754 = {};

/*! ieee754. BSD-3-Clause License. Feross Aboukhadijeh <https://feross.org/opensource> */

var hasRequiredIeee754;

function requireIeee754 () {
	if (hasRequiredIeee754) return ieee754;
	hasRequiredIeee754 = 1;
	ieee754.read = function (buffer, offset, isLE, mLen, nBytes) {
	  var e, m;
	  var eLen = (nBytes * 8) - mLen - 1;
	  var eMax = (1 << eLen) - 1;
	  var eBias = eMax >> 1;
	  var nBits = -7;
	  var i = isLE ? (nBytes - 1) : 0;
	  var d = isLE ? -1 : 1;
	  var s = buffer[offset + i];

	  i += d;

	  e = s & ((1 << (-nBits)) - 1);
	  s >>= (-nBits);
	  nBits += eLen;
	  for (; nBits > 0; e = (e * 256) + buffer[offset + i], i += d, nBits -= 8) {}

	  m = e & ((1 << (-nBits)) - 1);
	  e >>= (-nBits);
	  nBits += mLen;
	  for (; nBits > 0; m = (m * 256) + buffer[offset + i], i += d, nBits -= 8) {}

	  if (e === 0) {
	    e = 1 - eBias;
	  } else if (e === eMax) {
	    return m ? NaN : ((s ? -1 : 1) * Infinity)
	  } else {
	    m = m + Math.pow(2, mLen);
	    e = e - eBias;
	  }
	  return (s ? -1 : 1) * m * Math.pow(2, e - mLen)
	};

	ieee754.write = function (buffer, value, offset, isLE, mLen, nBytes) {
	  var e, m, c;
	  var eLen = (nBytes * 8) - mLen - 1;
	  var eMax = (1 << eLen) - 1;
	  var eBias = eMax >> 1;
	  var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0);
	  var i = isLE ? 0 : (nBytes - 1);
	  var d = isLE ? 1 : -1;
	  var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0;

	  value = Math.abs(value);

	  if (isNaN(value) || value === Infinity) {
	    m = isNaN(value) ? 1 : 0;
	    e = eMax;
	  } else {
	    e = Math.floor(Math.log(value) / Math.LN2);
	    if (value * (c = Math.pow(2, -e)) < 1) {
	      e--;
	      c *= 2;
	    }
	    if (e + eBias >= 1) {
	      value += rt / c;
	    } else {
	      value += rt * Math.pow(2, 1 - eBias);
	    }
	    if (value * c >= 2) {
	      e++;
	      c /= 2;
	    }

	    if (e + eBias >= eMax) {
	      m = 0;
	      e = eMax;
	    } else if (e + eBias >= 1) {
	      m = ((value * c) - 1) * Math.pow(2, mLen);
	      e = e + eBias;
	    } else {
	      m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
	      e = 0;
	    }
	  }

	  for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}

	  e = (e << mLen) | m;
	  eLen += mLen;
	  for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}

	  buffer[offset + i - d] |= s * 128;
	};
	return ieee754;
}

requireIeee754();

// text-polyfill.ts
// Minimal encode/decode for utf-8, utf-16le, ascii, latin1, windows-1252
const WINDOWS_1252_EXTRA = {
    0x80: "€", 0x82: "‚", 0x83: "ƒ", 0x84: "„", 0x85: "…", 0x86: "†",
    0x87: "‡", 0x88: "ˆ", 0x89: "‰", 0x8a: "Š", 0x8b: "‹", 0x8c: "Œ",
    0x8e: "Ž", 0x91: "‘", 0x92: "’", 0x93: "“", 0x94: "”", 0x95: "•",
    0x96: "–", 0x97: "—", 0x98: "˜", 0x99: "™", 0x9a: "š", 0x9b: "›",
    0x9c: "œ", 0x9e: "ž", 0x9f: "Ÿ",
};
for (const [code, char] of Object.entries(WINDOWS_1252_EXTRA)) {
}
/**
 * Decode text from binary data
 * @param bytes Binary data
 * @param encoding Encoding
 */
function textDecode(bytes, encoding = "utf-8") {
    switch (encoding.toLowerCase()) {
        case "utf-8":
        case "utf8":
            if (typeof globalThis.TextDecoder !== "undefined") {
                return new globalThis.TextDecoder("utf-8").decode(bytes);
            }
            return decodeUTF8(bytes);
        case "utf-16le":
            return decodeUTF16LE(bytes);
        case "ascii":
            return decodeASCII(bytes);
        case "latin1":
        case "iso-8859-1":
            return decodeLatin1(bytes);
        case "windows-1252":
            return decodeWindows1252(bytes);
        default:
            throw new RangeError(`Encoding '${encoding}' not supported`);
    }
}
// --- Internal helpers ---
function decodeUTF8(bytes) {
    let out = "";
    let i = 0;
    while (i < bytes.length) {
        const b1 = bytes[i++];
        if (b1 < 0x80) {
            out += String.fromCharCode(b1);
        }
        else if (b1 < 0xe0) {
            const b2 = bytes[i++] & 0x3f;
            out += String.fromCharCode(((b1 & 0x1f) << 6) | b2);
        }
        else if (b1 < 0xf0) {
            const b2 = bytes[i++] & 0x3f;
            const b3 = bytes[i++] & 0x3f;
            out += String.fromCharCode(((b1 & 0x0f) << 12) | (b2 << 6) | b3);
        }
        else {
            const b2 = bytes[i++] & 0x3f;
            const b3 = bytes[i++] & 0x3f;
            const b4 = bytes[i++] & 0x3f;
            let cp = ((b1 & 0x07) << 18) |
                (b2 << 12) |
                (b3 << 6) |
                b4;
            cp -= 0x10000;
            out += String.fromCharCode(0xd800 + ((cp >> 10) & 0x3ff), 0xdc00 + (cp & 0x3ff));
        }
    }
    return out;
}
function decodeUTF16LE(bytes) {
    let out = "";
    for (let i = 0; i < bytes.length; i += 2) {
        out += String.fromCharCode(bytes[i] | (bytes[i + 1] << 8));
    }
    return out;
}
function decodeASCII(bytes) {
    return String.fromCharCode(...bytes.map((b) => b & 0x7f));
}
function decodeLatin1(bytes) {
    return String.fromCharCode(...bytes);
}
function decodeWindows1252(bytes) {
    let out = "";
    for (const b of bytes) {
        if (b >= 0x80 && b <= 0x9f && WINDOWS_1252_EXTRA[b]) {
            out += WINDOWS_1252_EXTRA[b];
        }
        else {
            out += String.fromCharCode(b);
        }
    }
    return out;
}

// Primitive types
function dv(array) {
    return new DataView(array.buffer, array.byteOffset);
}
/*
 * 8-bit unsigned integer
 */
const UINT8 = {
    len: 1,
    get(array, offset) {
        return dv(array).getUint8(offset);
    },
    put(array, offset, value) {
        dv(array).setUint8(offset, value);
        return offset + 1;
    }
};
/**
 * 16-bit unsigned integer, Little Endian byte order
 */
const UINT16_LE = {
    len: 2,
    get(array, offset) {
        return dv(array).getUint16(offset, true);
    },
    put(array, offset, value) {
        dv(array).setUint16(offset, value, true);
        return offset + 2;
    }
};
/**
 * 16-bit unsigned integer, Big Endian byte order
 */
const UINT16_BE = {
    len: 2,
    get(array, offset) {
        return dv(array).getUint16(offset);
    },
    put(array, offset, value) {
        dv(array).setUint16(offset, value);
        return offset + 2;
    }
};
/**
 * 32-bit unsigned integer, Little Endian byte order
 */
const UINT32_LE = {
    len: 4,
    get(array, offset) {
        return dv(array).getUint32(offset, true);
    },
    put(array, offset, value) {
        dv(array).setUint32(offset, value, true);
        return offset + 4;
    }
};
/**
 * 32-bit unsigned integer, Big Endian byte order
 */
const UINT32_BE = {
    len: 4,
    get(array, offset) {
        return dv(array).getUint32(offset);
    },
    put(array, offset, value) {
        dv(array).setUint32(offset, value);
        return offset + 4;
    }
};
/**
 * 32-bit signed integer, Big Endian byte order
 */
const INT32_BE = {
    len: 4,
    get(array, offset) {
        return dv(array).getInt32(offset);
    },
    put(array, offset, value) {
        dv(array).setInt32(offset, value);
        return offset + 4;
    }
};
/**
 * 64-bit unsigned integer, Little Endian byte order
 */
const UINT64_LE = {
    len: 8,
    get(array, offset) {
        return dv(array).getBigUint64(offset, true);
    },
    put(array, offset, value) {
        dv(array).setBigUint64(offset, value, true);
        return offset + 8;
    }
};
/**
 * Consume a fixed number of bytes from the stream and return a string with a specified encoding.
 * Supports all encodings supported by TextDecoder, plus 'windows-1252'.
 */
class StringType {
    constructor(len, encoding) {
        this.len = len;
        this.encoding = encoding;
    }
    get(data, offset = 0) {
        const bytes = data.subarray(offset, offset + this.len);
        return textDecode(bytes, this.encoding);
    }
}

var require$1 = createRequire('/');
// DEFLATE is a complex format; to read this code, you should probably check the RFC first:
// https://tools.ietf.org/html/rfc1951
// You may also wish to take a look at the guide I made about this program:
// https://gist.github.com/101arrowz/253f31eb5abc3d9275ab943003ffecad
// Some of the following code is similar to that of UZIP.js:
// https://github.com/photopea/UZIP.js
// However, the vast majority of the codebase has diverged from UZIP.js to increase performance and reduce bundle size.
// Sometimes 0 will appear where -1 would be more appropriate. This is because using a uint
// is better for memory in most engines (I *think*).
// Mediocre shim
var Worker;
var workerAdd = ";var __w=require('worker_threads');__w.parentPort.on('message',function(m){onmessage({data:m})}),postMessage=function(m,t){__w.parentPort.postMessage(m,t)},close=process.exit;self=global";
try {
    Worker = require$1('worker_threads').Worker;
}
catch (e) {
}
var wk = Worker ? function (c, _, msg, transfer, cb) {
    var done = false;
    var w = new Worker(c + workerAdd, { eval: true })
        .on('error', function (e) { return cb(e, null); })
        .on('message', function (m) { return cb(null, m); })
        .on('exit', function (c) {
        if (c && !done)
            cb(new Error('exited with code ' + c), null);
    });
    w.postMessage(msg, transfer);
    w.terminate = function () {
        done = true;
        return Worker.prototype.terminate.call(w);
    };
    return w;
} : function (_, __, ___, ____, cb) {
    setImmediate(function () { return cb(new Error('async operations unsupported - update to Node 12+ (or Node 10-11 with the --experimental-worker CLI flag)'), null); });
    var NOP = function () { };
    return {
        terminate: NOP,
        postMessage: NOP
    };
};

// aliases for shorter compressed code (most minifers don't do this)
var u8 = Uint8Array, u16 = Uint16Array, i32 = Int32Array;
// fixed length extra bits
var fleb = new u8([0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, /* unused */ 0, 0, /* impossible */ 0]);
// fixed distance extra bits
var fdeb = new u8([0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, /* unused */ 0, 0]);
// code length index map
var clim = new u8([16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15]);
// get base, reverse index map from extra bits
var freb = function (eb, start) {
    var b = new u16(31);
    for (var i = 0; i < 31; ++i) {
        b[i] = start += 1 << eb[i - 1];
    }
    // numbers here are at max 18 bits
    var r = new i32(b[30]);
    for (var i = 1; i < 30; ++i) {
        for (var j = b[i]; j < b[i + 1]; ++j) {
            r[j] = ((j - b[i]) << 5) | i;
        }
    }
    return { b: b, r: r };
};
var _a$y = freb(fleb, 2), fl = _a$y.b, revfl = _a$y.r;
// we can ignore the fact that the other numbers are wrong; they never happen anyway
fl[28] = 258, revfl[258] = 28;
var _b = freb(fdeb, 0), fd = _b.b;
// map of value to reverse (assuming 16 bits)
var rev = new u16(32768);
for (var i = 0; i < 32768; ++i) {
    // reverse table algorithm from SO
    var x$1 = ((i & 0xAAAA) >> 1) | ((i & 0x5555) << 1);
    x$1 = ((x$1 & 0xCCCC) >> 2) | ((x$1 & 0x3333) << 2);
    x$1 = ((x$1 & 0xF0F0) >> 4) | ((x$1 & 0x0F0F) << 4);
    rev[i] = (((x$1 & 0xFF00) >> 8) | ((x$1 & 0x00FF) << 8)) >> 1;
}
// create huffman tree from u8 "map": index -> code length for code index
// mb (max bits) must be at most 15
// TODO: optimize/split up?
var hMap = (function (cd, mb, r) {
    var s = cd.length;
    // index
    var i = 0;
    // u16 "map": index -> # of codes with bit length = index
    var l = new u16(mb);
    // length of cd must be 288 (total # of codes)
    for (; i < s; ++i) {
        if (cd[i])
            ++l[cd[i] - 1];
    }
    // u16 "map": index -> minimum code for bit length = index
    var le = new u16(mb);
    for (i = 1; i < mb; ++i) {
        le[i] = (le[i - 1] + l[i - 1]) << 1;
    }
    var co;
    if (r) {
        // u16 "map": index -> number of actual bits, symbol for code
        co = new u16(1 << mb);
        // bits to remove for reverser
        var rvb = 15 - mb;
        for (i = 0; i < s; ++i) {
            // ignore 0 lengths
            if (cd[i]) {
                // num encoding both symbol and bits read
                var sv = (i << 4) | cd[i];
                // free bits
                var r_1 = mb - cd[i];
                // start value
                var v = le[cd[i] - 1]++ << r_1;
                // m is end value
                for (var m = v | ((1 << r_1) - 1); v <= m; ++v) {
                    // every 16 bit value starting with the code yields the same result
                    co[rev[v] >> rvb] = sv;
                }
            }
        }
    }
    else {
        co = new u16(s);
        for (i = 0; i < s; ++i) {
            if (cd[i]) {
                co[i] = rev[le[cd[i] - 1]++] >> (15 - cd[i]);
            }
        }
    }
    return co;
});
// fixed length tree
var flt = new u8(288);
for (var i = 0; i < 144; ++i)
    flt[i] = 8;
for (var i = 144; i < 256; ++i)
    flt[i] = 9;
for (var i = 256; i < 280; ++i)
    flt[i] = 7;
for (var i = 280; i < 288; ++i)
    flt[i] = 8;
// fixed distance tree
var fdt = new u8(32);
for (var i = 0; i < 32; ++i)
    fdt[i] = 5;
// fixed length map
var flrm = /*#__PURE__*/ hMap(flt, 9, 1);
// fixed distance map
var fdrm = /*#__PURE__*/ hMap(fdt, 5, 1);
// find max of array
var max$1 = function (a) {
    var m = a[0];
    for (var i = 1; i < a.length; ++i) {
        if (a[i] > m)
            m = a[i];
    }
    return m;
};
// read d, starting at bit p and mask with m
var bits = function (d, p, m) {
    var o = (p / 8) | 0;
    return ((d[o] | (d[o + 1] << 8)) >> (p & 7)) & m;
};
// read d, starting at bit p continuing for at least 16 bits
var bits16 = function (d, p) {
    var o = (p / 8) | 0;
    return ((d[o] | (d[o + 1] << 8) | (d[o + 2] << 16)) >> (p & 7));
};
// get end of byte
var shft = function (p) { return ((p + 7) / 8) | 0; };
// typed array slice - allows garbage collector to free original reference,
// while being more compatible than .slice
var slc = function (v, s, e) {
    if (s == null || s < 0)
        s = 0;
    if (e == null || e > v.length)
        e = v.length;
    // can't use .constructor in case user-supplied
    return new u8(v.subarray(s, e));
};
// error codes
var ec = [
    'unexpected EOF',
    'invalid block type',
    'invalid length/literal',
    'invalid distance',
    'stream finished',
    'no stream handler',
    ,
    'no callback',
    'invalid UTF-8 data',
    'extra field too long',
    'date not in range 1980-2099',
    'filename too long',
    'stream finishing',
    'invalid zip data'
    // determined by unknown compression method
];
var err = function (ind, msg, nt) {
    var e = new Error(msg || ec[ind]);
    e.code = ind;
    if (Error.captureStackTrace)
        Error.captureStackTrace(e, err);
    if (!nt)
        throw e;
    return e;
};
// expands raw DEFLATE data
var inflt = function (dat, st, buf, dict) {
    // source length       dict length
    var sl = dat.length, dl = dict ? dict.length : 0;
    if (!sl || st.f && !st.l)
        return buf || new u8(0);
    var noBuf = !buf;
    // have to estimate size
    var resize = noBuf || st.i != 2;
    // no state
    var noSt = st.i;
    // Assumes roughly 33% compression ratio average
    if (noBuf)
        buf = new u8(sl * 3);
    // ensure buffer can fit at least l elements
    var cbuf = function (l) {
        var bl = buf.length;
        // need to increase size to fit
        if (l > bl) {
            // Double or set to necessary, whichever is greater
            var nbuf = new u8(Math.max(bl * 2, l));
            nbuf.set(buf);
            buf = nbuf;
        }
    };
    //  last chunk         bitpos           bytes
    var final = st.f || 0, pos = st.p || 0, bt = st.b || 0, lm = st.l, dm = st.d, lbt = st.m, dbt = st.n;
    // total bits
    var tbts = sl * 8;
    do {
        if (!lm) {
            // BFINAL - this is only 1 when last chunk is next
            final = bits(dat, pos, 1);
            // type: 0 = no compression, 1 = fixed huffman, 2 = dynamic huffman
            var type = bits(dat, pos + 1, 3);
            pos += 3;
            if (!type) {
                // go to end of byte boundary
                var s = shft(pos) + 4, l = dat[s - 4] | (dat[s - 3] << 8), t = s + l;
                if (t > sl) {
                    if (noSt)
                        err(0);
                    break;
                }
                // ensure size
                if (resize)
                    cbuf(bt + l);
                // Copy over uncompressed data
                buf.set(dat.subarray(s, t), bt);
                // Get new bitpos, update byte count
                st.b = bt += l, st.p = pos = t * 8, st.f = final;
                continue;
            }
            else if (type == 1)
                lm = flrm, dm = fdrm, lbt = 9, dbt = 5;
            else if (type == 2) {
                //  literal                            lengths
                var hLit = bits(dat, pos, 31) + 257, hcLen = bits(dat, pos + 10, 15) + 4;
                var tl = hLit + bits(dat, pos + 5, 31) + 1;
                pos += 14;
                // length+distance tree
                var ldt = new u8(tl);
                // code length tree
                var clt = new u8(19);
                for (var i = 0; i < hcLen; ++i) {
                    // use index map to get real code
                    clt[clim[i]] = bits(dat, pos + i * 3, 7);
                }
                pos += hcLen * 3;
                // code lengths bits
                var clb = max$1(clt), clbmsk = (1 << clb) - 1;
                // code lengths map
                var clm = hMap(clt, clb, 1);
                for (var i = 0; i < tl;) {
                    var r = clm[bits(dat, pos, clbmsk)];
                    // bits read
                    pos += r & 15;
                    // symbol
                    var s = r >> 4;
                    // code length to copy
                    if (s < 16) {
                        ldt[i++] = s;
                    }
                    else {
                        //  copy   count
                        var c = 0, n = 0;
                        if (s == 16)
                            n = 3 + bits(dat, pos, 3), pos += 2, c = ldt[i - 1];
                        else if (s == 17)
                            n = 3 + bits(dat, pos, 7), pos += 3;
                        else if (s == 18)
                            n = 11 + bits(dat, pos, 127), pos += 7;
                        while (n--)
                            ldt[i++] = c;
                    }
                }
                //    length tree                 distance tree
                var lt = ldt.subarray(0, hLit), dt = ldt.subarray(hLit);
                // max length bits
                lbt = max$1(lt);
                // max dist bits
                dbt = max$1(dt);
                lm = hMap(lt, lbt, 1);
                dm = hMap(dt, dbt, 1);
            }
            else
                err(1);
            if (pos > tbts) {
                if (noSt)
                    err(0);
                break;
            }
        }
        // Make sure the buffer can hold this + the largest possible addition
        // Maximum chunk size (practically, theoretically infinite) is 2^17
        if (resize)
            cbuf(bt + 131072);
        var lms = (1 << lbt) - 1, dms = (1 << dbt) - 1;
        var lpos = pos;
        for (;; lpos = pos) {
            // bits read, code
            var c = lm[bits16(dat, pos) & lms], sym = c >> 4;
            pos += c & 15;
            if (pos > tbts) {
                if (noSt)
                    err(0);
                break;
            }
            if (!c)
                err(2);
            if (sym < 256)
                buf[bt++] = sym;
            else if (sym == 256) {
                lpos = pos, lm = null;
                break;
            }
            else {
                var add = sym - 254;
                // no extra bits needed if less
                if (sym > 264) {
                    // index
                    var i = sym - 257, b = fleb[i];
                    add = bits(dat, pos, (1 << b) - 1) + fl[i];
                    pos += b;
                }
                // dist
                var d = dm[bits16(dat, pos) & dms], dsym = d >> 4;
                if (!d)
                    err(3);
                pos += d & 15;
                var dt = fd[dsym];
                if (dsym > 3) {
                    var b = fdeb[dsym];
                    dt += bits16(dat, pos) & (1 << b) - 1, pos += b;
                }
                if (pos > tbts) {
                    if (noSt)
                        err(0);
                    break;
                }
                if (resize)
                    cbuf(bt + 131072);
                var end = bt + add;
                if (bt < dt) {
                    var shift = dl - dt, dend = Math.min(dt, end);
                    if (shift + bt < 0)
                        err(3);
                    for (; bt < dend; ++bt)
                        buf[bt] = dict[shift + bt];
                }
                for (; bt < end; ++bt)
                    buf[bt] = buf[bt - dt];
            }
        }
        st.l = lm, st.p = lpos, st.b = bt, st.f = final;
        if (lm)
            final = 1, st.m = lbt, st.d = dm, st.n = dbt;
    } while (!final);
    // don't reallocate for streams or user buffers
    return bt != buf.length && noBuf ? slc(buf, 0, bt) : buf.subarray(0, bt);
};
// empty
var et = /*#__PURE__*/ new u8(0);
// Walmart object spread
var mrg = function (a, b) {
    var o = {};
    for (var k in a)
        o[k] = a[k];
    for (var k in b)
        o[k] = b[k];
    return o;
};
// worker clone
// This is possibly the craziest part of the entire codebase, despite how simple it may seem.
// The only parameter to this function is a closure that returns an array of variables outside of the function scope.
// We're going to try to figure out the variable names used in the closure as strings because that is crucial for workerization.
// We will return an object mapping of true variable name to value (basically, the current scope as a JS object).
// The reason we can't just use the original variable names is minifiers mangling the toplevel scope.
// This took me three weeks to figure out how to do.
var wcln = function (fn, fnStr, td) {
    var dt = fn();
    var st = fn.toString();
    var ks = st.slice(st.indexOf('[') + 1, st.lastIndexOf(']')).replace(/\s+/g, '').split(',');
    for (var i = 0; i < dt.length; ++i) {
        var v = dt[i], k = ks[i];
        if (typeof v == 'function') {
            fnStr += ';' + k + '=';
            var st_1 = v.toString();
            if (v.prototype) {
                // for global objects
                if (st_1.indexOf('[native code]') != -1) {
                    var spInd = st_1.indexOf(' ', 8) + 1;
                    fnStr += st_1.slice(spInd, st_1.indexOf('(', spInd));
                }
                else {
                    fnStr += st_1;
                    for (var t in v.prototype)
                        fnStr += ';' + k + '.prototype.' + t + '=' + v.prototype[t].toString();
                }
            }
            else
                fnStr += st_1;
        }
        else
            td[k] = v;
    }
    return fnStr;
};
var ch = [];
// clone bufs
var cbfs = function (v) {
    var tl = [];
    for (var k in v) {
        if (v[k].buffer) {
            tl.push((v[k] = new v[k].constructor(v[k])).buffer);
        }
    }
    return tl;
};
// use a worker to execute code
var wrkr = function (fns, init, id, cb) {
    if (!ch[id]) {
        var fnStr = '', td_1 = {}, m = fns.length - 1;
        for (var i = 0; i < m; ++i)
            fnStr = wcln(fns[i], fnStr, td_1);
        ch[id] = { c: wcln(fns[m], fnStr, td_1), e: td_1 };
    }
    var td = mrg({}, ch[id].e);
    return wk(ch[id].c + ';onmessage=function(e){for(var k in e.data)self[k]=e.data[k];onmessage=' + init.toString() + '}', id, td, cbfs(td), cb);
};
// base async inflate fn
var bInflt = function () { return [u8, u16, i32, fleb, fdeb, clim, fl, fd, flrm, fdrm, rev, ec, hMap, max$1, bits, bits16, shft, slc, err, inflt, inflateSync, pbf, gopt]; };
// gunzip extra
var guze = function () { return [gzs, gzl]; };
// post buf
var pbf = function (msg) { return postMessage(msg, [msg.buffer]); };
// get opts
var gopt = function (o) { return o && {
    out: o.size && new u8(o.size),
    dictionary: o.dictionary
}; };
// auto stream
var astrm = function (strm) {
    strm.ondata = function (dat, final) { return postMessage([dat, final], [dat.buffer]); };
    return function (ev) {
        if (ev.data.length) {
            strm.push(ev.data[0], ev.data[1]);
            postMessage([ev.data[0].length]);
        }
        else
            strm.flush();
    };
};
// async stream attach
var astrmify = function (fns, strm, opts, init, id, flush, ext) {
    var t;
    var w = wrkr(fns, init, id, function (err, dat) {
        if (err)
            w.terminate(), strm.ondata.call(strm, err);
        else if (!Array.isArray(dat))
            ext(dat);
        else if (dat.length == 1) {
            strm.queuedSize -= dat[0];
            if (strm.ondrain)
                strm.ondrain(dat[0]);
        }
        else {
            if (dat[1])
                w.terminate();
            strm.ondata.call(strm, err, dat[0], dat[1]);
        }
    });
    w.postMessage(opts);
    strm.queuedSize = 0;
    strm.push = function (d, f) {
        if (!strm.ondata)
            err(5);
        if (t)
            strm.ondata(err(4, 0, 1), null, !!f);
        strm.queuedSize += d.length;
        w.postMessage([d, t = f], [d.buffer]);
    };
    strm.terminate = function () { w.terminate(); };
};
// gzip footer: -8 to -4 = CRC, -4 to -0 is length
// gzip start
var gzs = function (d) {
    if (d[0] != 31 || d[1] != 139 || d[2] != 8)
        err(6, 'invalid gzip data');
    var flg = d[3];
    var st = 10;
    if (flg & 4)
        st += (d[10] | d[11] << 8) + 2;
    for (var zs = (flg >> 3 & 1) + (flg >> 4 & 1); zs > 0; zs -= !d[st++])
        ;
    return st + (flg & 2);
};
// gzip length
var gzl = function (d) {
    var l = d.length;
    return (d[l - 4] | d[l - 3] << 8 | d[l - 2] << 16 | d[l - 1] << 24) >>> 0;
};
// zlib start
var zls = function (d, dict) {
    if ((d[0] & 15) != 8 || (d[0] >> 4) > 7 || ((d[0] << 8 | d[1]) % 31))
        err(6, 'invalid zlib data');
    if ((d[1] >> 5 & 1) == 1)
        err(6, 'invalid zlib data: ' + (d[1] & 32 ? 'need' : 'unexpected') + ' dictionary');
    return (d[1] >> 3 & 4) + 2;
};
function StrmOpt(opts, cb) {
    if (typeof opts == 'function')
        cb = opts, opts = {};
    this.ondata = cb;
    return opts;
}
/**
 * Streaming DEFLATE decompression
 */
var Inflate = /*#__PURE__*/ (function () {
    function Inflate(opts, cb) {
        // no StrmOpt here to avoid adding to workerizer
        if (typeof opts == 'function')
            cb = opts, opts = {};
        this.ondata = cb;
        var dict = opts && opts.dictionary && opts.dictionary.subarray(-32768);
        this.s = { i: 0, b: dict ? dict.length : 0 };
        this.o = new u8(32768);
        this.p = new u8(0);
        if (dict)
            this.o.set(dict);
    }
    Inflate.prototype.e = function (c) {
        if (!this.ondata)
            err(5);
        if (this.d)
            err(4);
        if (!this.p.length)
            this.p = c;
        else if (c.length) {
            var n = new u8(this.p.length + c.length);
            n.set(this.p), n.set(c, this.p.length), this.p = n;
        }
    };
    Inflate.prototype.c = function (final) {
        this.s.i = +(this.d = final || false);
        var bts = this.s.b;
        var dt = inflt(this.p, this.s, this.o);
        this.ondata(slc(dt, bts, this.s.b), this.d);
        this.o = slc(dt, this.s.b - 32768), this.s.b = this.o.length;
        this.p = slc(this.p, (this.s.p / 8) | 0), this.s.p &= 7;
    };
    /**
     * Pushes a chunk to be inflated
     * @param chunk The chunk to push
     * @param final Whether this is the final chunk
     */
    Inflate.prototype.push = function (chunk, final) {
        this.e(chunk), this.c(final);
    };
    return Inflate;
}());
/**
 * Expands DEFLATE data with no wrapper
 * @param data The data to decompress
 * @param opts The decompression options
 * @returns The decompressed version of the data
 */
function inflateSync(data, opts) {
    return inflt(data, { i: 2 }, opts && opts.out, opts && opts.dictionary);
}
/**
 * Streaming single or multi-member GZIP decompression
 */
var Gunzip = /*#__PURE__*/ (function () {
    function Gunzip(opts, cb) {
        this.v = 1;
        this.r = 0;
        Inflate.call(this, opts, cb);
    }
    /**
     * Pushes a chunk to be GUNZIPped
     * @param chunk The chunk to push
     * @param final Whether this is the last chunk
     */
    Gunzip.prototype.push = function (chunk, final) {
        Inflate.prototype.e.call(this, chunk);
        this.r += chunk.length;
        if (this.v) {
            var p = this.p.subarray(this.v - 1);
            var s = p.length > 3 ? gzs(p) : 4;
            if (s > p.length) {
                if (!final)
                    return;
            }
            else if (this.v > 1 && this.onmember) {
                this.onmember(this.r - p.length);
            }
            this.p = p.subarray(s), this.v = 0;
        }
        // necessary to prevent TS from using the closure value
        // This allows for workerization to function correctly
        Inflate.prototype.c.call(this, final);
        // process concatenated GZIP
        if (this.s.f && !this.s.l && !final) {
            this.v = shft(this.s.p) + 9;
            this.s = { i: 0 };
            this.o = new u8(0);
            this.push(new u8(0), final);
        }
    };
    return Gunzip;
}());
/**
 * Asynchronous streaming single or multi-member GZIP decompression
 */
var AsyncGunzip = /*#__PURE__*/ (function () {
    function AsyncGunzip(opts, cb) {
        var _this = this;
        astrmify([
            bInflt,
            guze,
            function () { return [astrm, Inflate, Gunzip]; }
        ], this, StrmOpt.call(this, opts, cb), function (ev) {
            var strm = new Gunzip(ev.data);
            strm.onmember = function (offset) { return postMessage(offset); };
            onmessage = astrm(strm);
        }, 9, 0, function (offset) { return _this.onmember && _this.onmember(offset); });
    }
    return AsyncGunzip;
}());
/**
 * Expands GZIP data
 * @param data The data to decompress
 * @param opts The decompression options
 * @returns The decompressed version of the data
 */
function gunzipSync(data, opts) {
    var st = gzs(data);
    if (st + 8 > data.length)
        err(6, 'invalid gzip data');
    return inflt(data.subarray(st, -8), { i: 2 }, new u8(gzl(data)), opts);
}
/**
 * Expands Zlib data
 * @param data The data to decompress
 * @param opts The decompression options
 * @returns The decompressed version of the data
 */
function unzlibSync(data, opts) {
    return inflt(data.subarray(zls(data), -4), { i: 2 }, opts, opts);
}
/**
 * Expands compressed GZIP, Zlib, or raw DEFLATE data, automatically detecting the format
 * @param data The data to decompress
 * @param opts The decompression options
 * @returns The decompressed version of the data
 */
function decompressSync(data, opts) {
    return (data[0] == 31 && data[1] == 139 && data[2] == 8)
        ? gunzipSync(data, opts)
        : ((data[0] & 15) != 8 || (data[0] >> 4) > 7 || ((data[0] << 8 | data[1]) % 31))
            ? inflateSync(data, opts)
            : unzlibSync(data, opts);
}
// text decoder
var td = typeof TextDecoder != 'undefined' && /*#__PURE__*/ new TextDecoder();
// text decoder stream
var tds = 0;
try {
    td.decode(et, { stream: true });
    tds = 1;
}
catch (e) { }

var browser$5 = {exports: {}};

/**
 * Helpers.
 */

var ms$1;
var hasRequiredMs$2;

function requireMs$2 () {
	if (hasRequiredMs$2) return ms$1;
	hasRequiredMs$2 = 1;
	var s = 1000;
	var m = s * 60;
	var h = m * 60;
	var d = h * 24;
	var w = d * 7;
	var y = d * 365.25;

	/**
	 * Parse or format the given `val`.
	 *
	 * Options:
	 *
	 *  - `long` verbose formatting [false]
	 *
	 * @param {String|Number} val
	 * @param {Object} [options]
	 * @throws {Error} throw an error if val is not a non-empty string or a number
	 * @return {String|Number}
	 * @api public
	 */

	ms$1 = function (val, options) {
	  options = options || {};
	  var type = typeof val;
	  if (type === 'string' && val.length > 0) {
	    return parse(val);
	  } else if (type === 'number' && isFinite(val)) {
	    return options.long ? fmtLong(val) : fmtShort(val);
	  }
	  throw new Error(
	    'val is not a non-empty string or a valid number. val=' +
	      JSON.stringify(val)
	  );
	};

	/**
	 * Parse the given `str` and return milliseconds.
	 *
	 * @param {String} str
	 * @return {Number}
	 * @api private
	 */

	function parse(str) {
	  str = String(str);
	  if (str.length > 100) {
	    return;
	  }
	  var match = /^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(
	    str
	  );
	  if (!match) {
	    return;
	  }
	  var n = parseFloat(match[1]);
	  var type = (match[2] || 'ms').toLowerCase();
	  switch (type) {
	    case 'years':
	    case 'year':
	    case 'yrs':
	    case 'yr':
	    case 'y':
	      return n * y;
	    case 'weeks':
	    case 'week':
	    case 'w':
	      return n * w;
	    case 'days':
	    case 'day':
	    case 'd':
	      return n * d;
	    case 'hours':
	    case 'hour':
	    case 'hrs':
	    case 'hr':
	    case 'h':
	      return n * h;
	    case 'minutes':
	    case 'minute':
	    case 'mins':
	    case 'min':
	    case 'm':
	      return n * m;
	    case 'seconds':
	    case 'second':
	    case 'secs':
	    case 'sec':
	    case 's':
	      return n * s;
	    case 'milliseconds':
	    case 'millisecond':
	    case 'msecs':
	    case 'msec':
	    case 'ms':
	      return n;
	    default:
	      return undefined;
	  }
	}

	/**
	 * Short format for `ms`.
	 *
	 * @param {Number} ms
	 * @return {String}
	 * @api private
	 */

	function fmtShort(ms) {
	  var msAbs = Math.abs(ms);
	  if (msAbs >= d) {
	    return Math.round(ms / d) + 'd';
	  }
	  if (msAbs >= h) {
	    return Math.round(ms / h) + 'h';
	  }
	  if (msAbs >= m) {
	    return Math.round(ms / m) + 'm';
	  }
	  if (msAbs >= s) {
	    return Math.round(ms / s) + 's';
	  }
	  return ms + 'ms';
	}

	/**
	 * Long format for `ms`.
	 *
	 * @param {Number} ms
	 * @return {String}
	 * @api private
	 */

	function fmtLong(ms) {
	  var msAbs = Math.abs(ms);
	  if (msAbs >= d) {
	    return plural(ms, msAbs, d, 'day');
	  }
	  if (msAbs >= h) {
	    return plural(ms, msAbs, h, 'hour');
	  }
	  if (msAbs >= m) {
	    return plural(ms, msAbs, m, 'minute');
	  }
	  if (msAbs >= s) {
	    return plural(ms, msAbs, s, 'second');
	  }
	  return ms + ' ms';
	}

	/**
	 * Pluralization helper.
	 */

	function plural(ms, msAbs, n, name) {
	  var isPlural = msAbs >= n * 1.5;
	  return Math.round(ms / n) + ' ' + name + (isPlural ? 's' : '');
	}
	return ms$1;
}

var common$1;
var hasRequiredCommon$1;

function requireCommon$1 () {
	if (hasRequiredCommon$1) return common$1;
	hasRequiredCommon$1 = 1;
	/**
	 * This is the common logic for both the Node.js and web browser
	 * implementations of `debug()`.
	 */

	function setup(env) {
		createDebug.debug = createDebug;
		createDebug.default = createDebug;
		createDebug.coerce = coerce;
		createDebug.disable = disable;
		createDebug.enable = enable;
		createDebug.enabled = enabled;
		createDebug.humanize = requireMs$2();
		createDebug.destroy = destroy;

		Object.keys(env).forEach(key => {
			createDebug[key] = env[key];
		});

		/**
		* The currently active debug mode names, and names to skip.
		*/

		createDebug.names = [];
		createDebug.skips = [];

		/**
		* Map of special "%n" handling functions, for the debug "format" argument.
		*
		* Valid key names are a single, lower or upper-case letter, i.e. "n" and "N".
		*/
		createDebug.formatters = {};

		/**
		* Selects a color for a debug namespace
		* @param {String} namespace The namespace string for the debug instance to be colored
		* @return {Number|String} An ANSI color code for the given namespace
		* @api private
		*/
		function selectColor(namespace) {
			let hash = 0;

			for (let i = 0; i < namespace.length; i++) {
				hash = ((hash << 5) - hash) + namespace.charCodeAt(i);
				hash |= 0; // Convert to 32bit integer
			}

			return createDebug.colors[Math.abs(hash) % createDebug.colors.length];
		}
		createDebug.selectColor = selectColor;

		/**
		* Create a debugger with the given `namespace`.
		*
		* @param {String} namespace
		* @return {Function}
		* @api public
		*/
		function createDebug(namespace) {
			let prevTime;
			let enableOverride = null;
			let namespacesCache;
			let enabledCache;

			function debug(...args) {
				// Disabled?
				if (!debug.enabled) {
					return;
				}

				const self = debug;

				// Set `diff` timestamp
				const curr = Number(new Date());
				const ms = curr - (prevTime || curr);
				self.diff = ms;
				self.prev = prevTime;
				self.curr = curr;
				prevTime = curr;

				args[0] = createDebug.coerce(args[0]);

				if (typeof args[0] !== 'string') {
					// Anything else let's inspect with %O
					args.unshift('%O');
				}

				// Apply any `formatters` transformations
				let index = 0;
				args[0] = args[0].replace(/%([a-zA-Z%])/g, (match, format) => {
					// If we encounter an escaped % then don't increase the array index
					if (match === '%%') {
						return '%';
					}
					index++;
					const formatter = createDebug.formatters[format];
					if (typeof formatter === 'function') {
						const val = args[index];
						match = formatter.call(self, val);

						// Now we need to remove `args[index]` since it's inlined in the `format`
						args.splice(index, 1);
						index--;
					}
					return match;
				});

				// Apply env-specific formatting (colors, etc.)
				createDebug.formatArgs.call(self, args);

				const logFn = self.log || createDebug.log;
				logFn.apply(self, args);
			}

			debug.namespace = namespace;
			debug.useColors = createDebug.useColors();
			debug.color = createDebug.selectColor(namespace);
			debug.extend = extend;
			debug.destroy = createDebug.destroy; // XXX Temporary. Will be removed in the next major release.

			Object.defineProperty(debug, 'enabled', {
				enumerable: true,
				configurable: false,
				get: () => {
					if (enableOverride !== null) {
						return enableOverride;
					}
					if (namespacesCache !== createDebug.namespaces) {
						namespacesCache = createDebug.namespaces;
						enabledCache = createDebug.enabled(namespace);
					}

					return enabledCache;
				},
				set: v => {
					enableOverride = v;
				}
			});

			// Env-specific initialization logic for debug instances
			if (typeof createDebug.init === 'function') {
				createDebug.init(debug);
			}

			return debug;
		}

		function extend(namespace, delimiter) {
			const newDebug = createDebug(this.namespace + (typeof delimiter === 'undefined' ? ':' : delimiter) + namespace);
			newDebug.log = this.log;
			return newDebug;
		}

		/**
		* Enables a debug mode by namespaces. This can include modes
		* separated by a colon and wildcards.
		*
		* @param {String} namespaces
		* @api public
		*/
		function enable(namespaces) {
			createDebug.save(namespaces);
			createDebug.namespaces = namespaces;

			createDebug.names = [];
			createDebug.skips = [];

			const split = (typeof namespaces === 'string' ? namespaces : '')
				.trim()
				.replace(/\s+/g, ',')
				.split(',')
				.filter(Boolean);

			for (const ns of split) {
				if (ns[0] === '-') {
					createDebug.skips.push(ns.slice(1));
				} else {
					createDebug.names.push(ns);
				}
			}
		}

		/**
		 * Checks if the given string matches a namespace template, honoring
		 * asterisks as wildcards.
		 *
		 * @param {String} search
		 * @param {String} template
		 * @return {Boolean}
		 */
		function matchesTemplate(search, template) {
			let searchIndex = 0;
			let templateIndex = 0;
			let starIndex = -1;
			let matchIndex = 0;

			while (searchIndex < search.length) {
				if (templateIndex < template.length && (template[templateIndex] === search[searchIndex] || template[templateIndex] === '*')) {
					// Match character or proceed with wildcard
					if (template[templateIndex] === '*') {
						starIndex = templateIndex;
						matchIndex = searchIndex;
						templateIndex++; // Skip the '*'
					} else {
						searchIndex++;
						templateIndex++;
					}
				} else if (starIndex !== -1) { // eslint-disable-line no-negated-condition
					// Backtrack to the last '*' and try to match more characters
					templateIndex = starIndex + 1;
					matchIndex++;
					searchIndex = matchIndex;
				} else {
					return false; // No match
				}
			}

			// Handle trailing '*' in template
			while (templateIndex < template.length && template[templateIndex] === '*') {
				templateIndex++;
			}

			return templateIndex === template.length;
		}

		/**
		* Disable debug output.
		*
		* @return {String} namespaces
		* @api public
		*/
		function disable() {
			const namespaces = [
				...createDebug.names,
				...createDebug.skips.map(namespace => '-' + namespace)
			].join(',');
			createDebug.enable('');
			return namespaces;
		}

		/**
		* Returns true if the given mode name is enabled, false otherwise.
		*
		* @param {String} name
		* @return {Boolean}
		* @api public
		*/
		function enabled(name) {
			for (const skip of createDebug.skips) {
				if (matchesTemplate(name, skip)) {
					return false;
				}
			}

			for (const ns of createDebug.names) {
				if (matchesTemplate(name, ns)) {
					return true;
				}
			}

			return false;
		}

		/**
		* Coerce `val`.
		*
		* @param {Mixed} val
		* @return {Mixed}
		* @api private
		*/
		function coerce(val) {
			if (val instanceof Error) {
				return val.stack || val.message;
			}
			return val;
		}

		/**
		* XXX DO NOT USE. This is a temporary stub function.
		* XXX It WILL be removed in the next major release.
		*/
		function destroy() {
			console.warn('Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.');
		}

		createDebug.enable(createDebug.load());

		return createDebug;
	}

	common$1 = setup;
	return common$1;
}

/* eslint-env browser */

var hasRequiredBrowser$5;

function requireBrowser$5 () {
	if (hasRequiredBrowser$5) return browser$5.exports;
	hasRequiredBrowser$5 = 1;
	(function (module, exports$1) {
		/**
		 * This is the web browser implementation of `debug()`.
		 */

		exports$1.formatArgs = formatArgs;
		exports$1.save = save;
		exports$1.load = load;
		exports$1.useColors = useColors;
		exports$1.storage = localstorage();
		exports$1.destroy = (() => {
			let warned = false;

			return () => {
				if (!warned) {
					warned = true;
					console.warn('Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.');
				}
			};
		})();

		/**
		 * Colors.
		 */

		exports$1.colors = [
			'#0000CC',
			'#0000FF',
			'#0033CC',
			'#0033FF',
			'#0066CC',
			'#0066FF',
			'#0099CC',
			'#0099FF',
			'#00CC00',
			'#00CC33',
			'#00CC66',
			'#00CC99',
			'#00CCCC',
			'#00CCFF',
			'#3300CC',
			'#3300FF',
			'#3333CC',
			'#3333FF',
			'#3366CC',
			'#3366FF',
			'#3399CC',
			'#3399FF',
			'#33CC00',
			'#33CC33',
			'#33CC66',
			'#33CC99',
			'#33CCCC',
			'#33CCFF',
			'#6600CC',
			'#6600FF',
			'#6633CC',
			'#6633FF',
			'#66CC00',
			'#66CC33',
			'#9900CC',
			'#9900FF',
			'#9933CC',
			'#9933FF',
			'#99CC00',
			'#99CC33',
			'#CC0000',
			'#CC0033',
			'#CC0066',
			'#CC0099',
			'#CC00CC',
			'#CC00FF',
			'#CC3300',
			'#CC3333',
			'#CC3366',
			'#CC3399',
			'#CC33CC',
			'#CC33FF',
			'#CC6600',
			'#CC6633',
			'#CC9900',
			'#CC9933',
			'#CCCC00',
			'#CCCC33',
			'#FF0000',
			'#FF0033',
			'#FF0066',
			'#FF0099',
			'#FF00CC',
			'#FF00FF',
			'#FF3300',
			'#FF3333',
			'#FF3366',
			'#FF3399',
			'#FF33CC',
			'#FF33FF',
			'#FF6600',
			'#FF6633',
			'#FF9900',
			'#FF9933',
			'#FFCC00',
			'#FFCC33'
		];

		/**
		 * Currently only WebKit-based Web Inspectors, Firefox >= v31,
		 * and the Firebug extension (any Firefox version) are known
		 * to support "%c" CSS customizations.
		 *
		 * TODO: add a `localStorage` variable to explicitly enable/disable colors
		 */

		// eslint-disable-next-line complexity
		function useColors() {
			// NB: In an Electron preload script, document will be defined but not fully
			// initialized. Since we know we're in Chrome, we'll just detect this case
			// explicitly
			if (typeof window !== 'undefined' && window.process && (window.process.type === 'renderer' || window.process.__nwjs)) {
				return true;
			}

			// Internet Explorer and Edge do not support colors.
			if (typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) {
				return false;
			}

			let m;

			// Is webkit? http://stackoverflow.com/a/16459606/376773
			// document is undefined in react-native: https://github.com/facebook/react-native/pull/1632
			// eslint-disable-next-line no-return-assign
			return (typeof document !== 'undefined' && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance) ||
				// Is firebug? http://stackoverflow.com/a/398120/376773
				(typeof window !== 'undefined' && window.console && (window.console.firebug || (window.console.exception && window.console.table))) ||
				// Is firefox >= v31?
				// https://developer.mozilla.org/en-US/docs/Tools/Web_Console#Styling_messages
				(typeof navigator !== 'undefined' && navigator.userAgent && (m = navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/)) && parseInt(m[1], 10) >= 31) ||
				// Double check webkit in userAgent just in case we are in a worker
				(typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/));
		}

		/**
		 * Colorize log arguments if enabled.
		 *
		 * @api public
		 */

		function formatArgs(args) {
			args[0] = (this.useColors ? '%c' : '') +
				this.namespace +
				(this.useColors ? ' %c' : ' ') +
				args[0] +
				(this.useColors ? '%c ' : ' ') +
				'+' + module.exports.humanize(this.diff);

			if (!this.useColors) {
				return;
			}

			const c = 'color: ' + this.color;
			args.splice(1, 0, c, 'color: inherit');

			// The final "%c" is somewhat tricky, because there could be other
			// arguments passed either before or after the %c, so we need to
			// figure out the correct index to insert the CSS into
			let index = 0;
			let lastC = 0;
			args[0].replace(/%[a-zA-Z%]/g, match => {
				if (match === '%%') {
					return;
				}
				index++;
				if (match === '%c') {
					// We only are interested in the *last* %c
					// (the user may have provided their own)
					lastC = index;
				}
			});

			args.splice(lastC, 0, c);
		}

		/**
		 * Invokes `console.debug()` when available.
		 * No-op when `console.debug` is not a "function".
		 * If `console.debug` is not available, falls back
		 * to `console.log`.
		 *
		 * @api public
		 */
		exports$1.log = console.debug || console.log || (() => {});

		/**
		 * Save `namespaces`.
		 *
		 * @param {String} namespaces
		 * @api private
		 */
		function save(namespaces) {
			try {
				if (namespaces) {
					exports$1.storage.setItem('debug', namespaces);
				} else {
					exports$1.storage.removeItem('debug');
				}
			} catch (error) {
				// Swallow
				// XXX (@Qix-) should we be logging these?
			}
		}

		/**
		 * Load `namespaces`.
		 *
		 * @return {String} returns the previously persisted debug modes
		 * @api private
		 */
		function load() {
			let r;
			try {
				r = exports$1.storage.getItem('debug') || exports$1.storage.getItem('DEBUG') ;
			} catch (error) {
				// Swallow
				// XXX (@Qix-) should we be logging these?
			}

			// If debug isn't set in LS, and we're in Electron, try to load $DEBUG
			if (!r && typeof process !== 'undefined' && 'env' in process) {
				r = process.env.DEBUG;
			}

			return r;
		}

		/**
		 * Localstorage attempts to return the localstorage.
		 *
		 * This is necessary because safari throws
		 * when a user disables cookies/localstorage
		 * and you attempt to access it.
		 *
		 * @return {LocalStorage}
		 * @api private
		 */

		function localstorage() {
			try {
				// TVMLKit (Apple TV JS Runtime) does not have a window object, just localStorage in the global context
				// The Browser also has localStorage in the global context.
				return localStorage;
			} catch (error) {
				// Swallow
				// XXX (@Qix-) should we be logging these?
			}
		}

		module.exports = requireCommon$1()(exports$1);

		const {formatters} = module.exports;

		/**
		 * Map %j to `JSON.stringify()`, since no Web Inspectors do that by default.
		 */

		formatters.j = function (v) {
			try {
				return JSON.stringify(v);
			} catch (error) {
				return '[UnexpectedJSONParseError]: ' + error.message;
			}
		}; 
	} (browser$5, browser$5.exports));
	return browser$5.exports;
}

var browserExports = requireBrowser$5();
const initDebug = /*@__PURE__*/getDefaultExportFromCjs(browserExports);

/**
 * Ref https://pkware.cachefly.net/webdocs/casestudies/APPNOTE.TXT
 */
const Signature = {
    LocalFileHeader: 0x04034b50,
    DataDescriptor: 0x08074b50,
    CentralFileHeader: 0x02014b50,
    EndOfCentralDirectory: 0x06054b50
};
const DataDescriptor = {
    get(array) {
        return {
            signature: UINT32_LE.get(array, 0),
            compressedSize: UINT32_LE.get(array, 8),
            uncompressedSize: UINT32_LE.get(array, 12),
        };
    }, len: 16
};
/**
 * First part of the ZIP Local File Header
 * Offset | Bytes| Description
 * -------|------+-------------------------------------------------------------------
 *      0 |    4 | Signature (0x04034b50)
 *      4 |    2 | Minimum version needed to extract
 *      6 |    2 | Bit flag
 *      8 |    2 | Compression method
 *     10 |    2 | File last modification time (MS-DOS format)
 *     12 |    2 | File last modification date (MS-DOS format)
 *     14 |    4 | CRC-32 of uncompressed data
 *     18 |    4 | Compressed size
 *     22 |    4 | Uncompressed size
 *     26 |    2 | File name length (n)
 *     28 |    2 | Extra field length (m)
 *     30 |    n | File name
 * 30 + n |    m | Extra field
 */
const LocalFileHeaderToken = {
    get(array) {
        const flags = UINT16_LE.get(array, 6);
        return {
            signature: UINT32_LE.get(array, 0),
            minVersion: UINT16_LE.get(array, 4),
            dataDescriptor: !!(flags & 0x0008),
            compressedMethod: UINT16_LE.get(array, 8),
            compressedSize: UINT32_LE.get(array, 18),
            uncompressedSize: UINT32_LE.get(array, 22),
            filenameLength: UINT16_LE.get(array, 26),
            extraFieldLength: UINT16_LE.get(array, 28),
            filename: null
        };
    }, len: 30
};
/**
 * 4.3.16  End of central directory record:
 *  end of central dir signature (0x06064b50)                                      4 bytes
 *  number of this disk                                                            2 bytes
 *  number of the disk with the start of the central directory                     2 bytes
 *  total number of entries in the central directory on this disk                  2 bytes
 *  total number of entries in the size of the central directory                   2 bytes
 *  sizeOfTheCentralDirectory                                                      4 bytes
 *  offset of start of central directory with respect to the starting disk number  4 bytes
 *  .ZIP file comment length                                                       2 bytes
 *  .ZIP file comment       (variable size)
 */
const EndOfCentralDirectoryRecordToken = {
    get(array) {
        return {
            signature: UINT32_LE.get(array, 0),
            nrOfThisDisk: UINT16_LE.get(array, 4),
            nrOfThisDiskWithTheStart: UINT16_LE.get(array, 6),
            nrOfEntriesOnThisDisk: UINT16_LE.get(array, 8),
            nrOfEntriesOfSize: UINT16_LE.get(array, 10),
            sizeOfCd: UINT32_LE.get(array, 12),
            offsetOfStartOfCd: UINT32_LE.get(array, 16),
            zipFileCommentLength: UINT16_LE.get(array, 20),
        };
    }, len: 22
};
/**
 * File header:
 *    central file header signature   4 bytes   0 (0x02014b50)
 *    version made by                 2 bytes   4
 *    version needed to extract       2 bytes   6
 *    general purpose bit flag        2 bytes   8
 *    compression method              2 bytes  10
 *    last mod file time              2 bytes  12
 *    last mod file date              2 bytes  14
 *    crc-32                          4 bytes  16
 *    compressed size                 4 bytes  20
 *    uncompressed size               4 bytes  24
 *    file name length                2 bytes  28
 *    extra field length              2 bytes  30
 *    file comment length             2 bytes  32
 *    disk number start               2 bytes  34
 *    internal file attributes        2 bytes  36
 *    external file attributes        4 bytes  38
 *    relative offset of local header 4 bytes  42
 */
const FileHeader = {
    get(array) {
        const flags = UINT16_LE.get(array, 8);
        return {
            signature: UINT32_LE.get(array, 0),
            minVersion: UINT16_LE.get(array, 6),
            dataDescriptor: !!(flags & 0x0008),
            compressedMethod: UINT16_LE.get(array, 10),
            compressedSize: UINT32_LE.get(array, 20),
            uncompressedSize: UINT32_LE.get(array, 24),
            filenameLength: UINT16_LE.get(array, 28),
            extraFieldLength: UINT16_LE.get(array, 30),
            fileCommentLength: UINT16_LE.get(array, 32),
            relativeOffsetOfLocalHeader: UINT32_LE.get(array, 42),
            filename: null
        };
    }, len: 46
};

function signatureToArray(signature) {
    const signatureBytes = new Uint8Array(UINT32_LE.len);
    UINT32_LE.put(signatureBytes, 0, signature);
    return signatureBytes;
}
const debug$1 = initDebug('tokenizer:inflate');
const syncBufferSize = 256 * 1024;
const ddSignatureArray = signatureToArray(Signature.DataDescriptor);
const eocdSignatureBytes = signatureToArray(Signature.EndOfCentralDirectory);
class ZipHandler {
    constructor(tokenizer) {
        this.tokenizer = tokenizer;
        this.syncBuffer = new Uint8Array(syncBufferSize);
    }
    async isZip() {
        return await this.peekSignature() === Signature.LocalFileHeader;
    }
    peekSignature() {
        return this.tokenizer.peekToken(UINT32_LE);
    }
    async findEndOfCentralDirectoryLocator() {
        const randomReadTokenizer = this.tokenizer;
        const chunkLength = Math.min(16 * 1024, randomReadTokenizer.fileInfo.size);
        const buffer = this.syncBuffer.subarray(0, chunkLength);
        await this.tokenizer.readBuffer(buffer, { position: randomReadTokenizer.fileInfo.size - chunkLength });
        // Search the buffer from end to beginning for EOCD signature
        // const signature = 0x06054b50;
        for (let i = buffer.length - 4; i >= 0; i--) {
            // Compare 4 bytes directly without calling readUInt32LE
            if (buffer[i] === eocdSignatureBytes[0] &&
                buffer[i + 1] === eocdSignatureBytes[1] &&
                buffer[i + 2] === eocdSignatureBytes[2] &&
                buffer[i + 3] === eocdSignatureBytes[3]) {
                return randomReadTokenizer.fileInfo.size - chunkLength + i;
            }
        }
        return -1;
    }
    async readCentralDirectory() {
        if (!this.tokenizer.supportsRandomAccess()) {
            debug$1('Cannot reading central-directory without random-read support');
            return;
        }
        debug$1('Reading central-directory...');
        const pos = this.tokenizer.position;
        const offset = await this.findEndOfCentralDirectoryLocator();
        if (offset > 0) {
            debug$1('Central-directory 32-bit signature found');
            const eocdHeader = await this.tokenizer.readToken(EndOfCentralDirectoryRecordToken, offset);
            const files = [];
            this.tokenizer.setPosition(eocdHeader.offsetOfStartOfCd);
            for (let n = 0; n < eocdHeader.nrOfEntriesOfSize; ++n) {
                const entry = await this.tokenizer.readToken(FileHeader);
                if (entry.signature !== Signature.CentralFileHeader) {
                    throw new Error('Expected Central-File-Header signature');
                }
                entry.filename = await this.tokenizer.readToken(new StringType(entry.filenameLength, 'utf-8'));
                await this.tokenizer.ignore(entry.extraFieldLength);
                await this.tokenizer.ignore(entry.fileCommentLength);
                files.push(entry);
                debug$1(`Add central-directory file-entry: n=${n + 1}/${files.length}: filename=${files[n].filename}`);
            }
            this.tokenizer.setPosition(pos);
            return files;
        }
        this.tokenizer.setPosition(pos);
    }
    async unzip(fileCb) {
        const entries = await this.readCentralDirectory();
        if (entries) {
            // Use Central Directory to iterate over files
            return this.iterateOverCentralDirectory(entries, fileCb);
        }
        // Scan Zip files for local-file-header
        let stop = false;
        do {
            const zipHeader = await this.readLocalFileHeader();
            if (!zipHeader)
                break;
            const next = fileCb(zipHeader);
            stop = !!next.stop;
            let fileData = undefined;
            await this.tokenizer.ignore(zipHeader.extraFieldLength);
            if (zipHeader.dataDescriptor && zipHeader.compressedSize === 0) {
                const chunks = [];
                let len = syncBufferSize;
                debug$1('Compressed-file-size unknown, scanning for next data-descriptor-signature....');
                let nextHeaderIndex = -1;
                while (nextHeaderIndex < 0 && len === syncBufferSize) {
                    len = await this.tokenizer.peekBuffer(this.syncBuffer, { mayBeLess: true });
                    nextHeaderIndex = indexOf(this.syncBuffer.subarray(0, len), ddSignatureArray);
                    const size = nextHeaderIndex >= 0 ? nextHeaderIndex : len;
                    if (next.handler) {
                        const data = new Uint8Array(size);
                        await this.tokenizer.readBuffer(data);
                        chunks.push(data);
                    }
                    else {
                        // Move position to the next header if found, skip the whole buffer otherwise
                        await this.tokenizer.ignore(size);
                    }
                }
                debug$1(`Found data-descriptor-signature at pos=${this.tokenizer.position}`);
                if (next.handler) {
                    await this.inflate(zipHeader, mergeArrays(chunks), next.handler);
                }
            }
            else {
                if (next.handler) {
                    debug$1(`Reading compressed-file-data: ${zipHeader.compressedSize} bytes`);
                    fileData = new Uint8Array(zipHeader.compressedSize);
                    await this.tokenizer.readBuffer(fileData);
                    await this.inflate(zipHeader, fileData, next.handler);
                }
                else {
                    debug$1(`Ignoring compressed-file-data: ${zipHeader.compressedSize} bytes`);
                    await this.tokenizer.ignore(zipHeader.compressedSize);
                }
            }
            debug$1(`Reading data-descriptor at pos=${this.tokenizer.position}`);
            if (zipHeader.dataDescriptor) {
                // await this.tokenizer.ignore(DataDescriptor.len);
                const dataDescriptor = await this.tokenizer.readToken(DataDescriptor);
                if (dataDescriptor.signature !== 0x08074b50) {
                    throw new Error(`Expected data-descriptor-signature at position ${this.tokenizer.position - DataDescriptor.len}`);
                }
            }
        } while (!stop);
    }
    async iterateOverCentralDirectory(entries, fileCb) {
        for (const fileHeader of entries) {
            const next = fileCb(fileHeader);
            if (next.handler) {
                this.tokenizer.setPosition(fileHeader.relativeOffsetOfLocalHeader);
                const zipHeader = await this.readLocalFileHeader();
                if (zipHeader) {
                    await this.tokenizer.ignore(zipHeader.extraFieldLength);
                    const fileData = new Uint8Array(fileHeader.compressedSize);
                    await this.tokenizer.readBuffer(fileData);
                    await this.inflate(zipHeader, fileData, next.handler);
                }
            }
            if (next.stop)
                break;
        }
    }
    inflate(zipHeader, fileData, cb) {
        if (zipHeader.compressedMethod === 0) {
            return cb(fileData);
        }
        debug$1(`Decompress filename=${zipHeader.filename}, compressed-size=${fileData.length}`);
        const uncompressedData = decompressSync(fileData);
        return cb(uncompressedData);
    }
    async readLocalFileHeader() {
        const signature = await this.tokenizer.peekToken(UINT32_LE);
        if (signature === Signature.LocalFileHeader) {
            const header = await this.tokenizer.readToken(LocalFileHeaderToken);
            header.filename = await this.tokenizer.readToken(new StringType(header.filenameLength, 'utf-8'));
            return header;
        }
        if (signature === Signature.CentralFileHeader) {
            return false;
        }
        if (signature === 0xE011CFD0) {
            throw new Error('Encrypted ZIP');
        }
        throw new Error('Unexpected signature');
    }
}
function indexOf(buffer, portion) {
    const bufferLength = buffer.length;
    const portionLength = portion.length;
    // Return -1 if the portion is longer than the buffer
    if (portionLength > bufferLength)
        return -1;
    // Search for the portion in the buffer
    for (let i = 0; i <= bufferLength - portionLength; i++) {
        let found = true;
        for (let j = 0; j < portionLength; j++) {
            if (buffer[i + j] !== portion[j]) {
                found = false;
                break;
            }
        }
        if (found) {
            return i; // Return the starting offset
        }
    }
    return -1; // Not found
}
function mergeArrays(chunks) {
    // Concatenate chunks into a single Uint8Array
    const totalLength = chunks.reduce((acc, curr) => acc + curr.length, 0);
    const mergedArray = new Uint8Array(totalLength);
    let offset = 0;
    for (const chunk of chunks) {
        mergedArray.set(chunk, offset);
        offset += chunk.length;
    }
    return mergedArray;
}

class GzipHandler {
    constructor(tokenizer) {
        this.gunzip = undefined;
        this.tokenizer = tokenizer;
    }
    inflate() {
        let done = false;
        let cancelled = false;
        const parent = this;
        return new ReadableStream({
            start: controller => {
                parent.gunzip = new AsyncGunzip((err, chunk, final) => {
                    if (err) {
                        controller.error(err);
                        return;
                    }
                    if (chunk && !cancelled) {
                        controller.enqueue(chunk);
                    }
                    if (final && !cancelled) {
                        controller.close();
                        parent.gunzip.terminate();
                    }
                });
            },
            async pull(controller) {
                const chunkSize = 1024;
                try {
                    const buffer = new Uint8Array(chunkSize);
                    const size = await parent.tokenizer.readBuffer(buffer, { mayBeLess: true });
                    if (size === 0) {
                        if (!done) {
                            done = true;
                            if (!cancelled) {
                                parent.gunzip.push(new Uint8Array(0), true);
                            }
                        }
                        return;
                    }
                    parent.gunzip.push(buffer.subarray(0, size), false);
                }
                catch (err) {
                    controller.error(err);
                }
            },
            cancel: () => {
                parent.gunzip.terminate();
                cancelled = true;
            }
        });
    }
}

({
	utf8: new globalThis.TextDecoder('utf8'),
});

new globalThis.TextEncoder();

Array.from({length: 256}, (_, index) => index.toString(16).padStart(2, '0'));

/**
@param {DataView} view
@returns {number}
*/
function getUintBE(view) {
	const {byteLength} = view;

	if (byteLength === 6) {
		return (view.getUint16(0) * (2 ** 32)) + view.getUint32(2);
	}

	if (byteLength === 5) {
		return (view.getUint8(0) * (2 ** 32)) + view.getUint32(1);
	}

	if (byteLength === 4) {
		return view.getUint32(0);
	}

	if (byteLength === 3) {
		return (view.getUint8(0) * (2 ** 16)) + view.getUint16(1);
	}

	if (byteLength === 2) {
		return view.getUint16(0);
	}

	if (byteLength === 1) {
		return view.getUint8(0);
	}
}

function stringToBytes(string, encoding) {
	if (encoding === 'utf-16le') {
		const bytes = [];
		for (let index = 0; index < string.length; index++) {
			const code = string.charCodeAt(index); // eslint-disable-line unicorn/prefer-code-point
			bytes.push(code & 0xFF, (code >> 8) & 0xFF); // High byte
		}

		return bytes;
	}

	if (encoding === 'utf-16be') {
		const bytes = [];
		for (let index = 0; index < string.length; index++) {
			const code = string.charCodeAt(index); // eslint-disable-line unicorn/prefer-code-point
			bytes.push((code >> 8) & 0xFF, code & 0xFF); // Low byte
		}

		return bytes;
	}

	return [...string].map(character => character.charCodeAt(0)); // eslint-disable-line unicorn/prefer-code-point
}

/**
Checks whether the TAR checksum is valid.

@param {Uint8Array} arrayBuffer - The TAR header `[offset ... offset + 512]`.
@param {number} offset - TAR header offset.
@returns {boolean} `true` if the TAR checksum is valid, otherwise `false`.
*/
function tarHeaderChecksumMatches(arrayBuffer, offset = 0) {
	const readSum = Number.parseInt(new StringType(6).get(arrayBuffer, 148).replace(/\0.*$/, '').trim(), 8); // Read sum in header
	if (Number.isNaN(readSum)) {
		return false;
	}

	let sum = 8 * 0x20; // Initialize signed bit sum

	for (let index = offset; index < offset + 148; index++) {
		sum += arrayBuffer[index];
	}

	for (let index = offset + 156; index < offset + 512; index++) {
		sum += arrayBuffer[index];
	}

	return readSum === sum;
}

/**
ID3 UINT32 sync-safe tokenizer token.
28 bits (representing up to 256MB) integer, the msb is 0 to avoid "false syncsignals".
*/
const uint32SyncSafeToken = {
	get: (buffer, offset) => (buffer[offset + 3] & 0x7F) | ((buffer[offset + 2]) << 7) | ((buffer[offset + 1]) << 14) | ((buffer[offset]) << 21),
	len: 4,
};

const extensions = [
	'jpg',
	'png',
	'apng',
	'gif',
	'webp',
	'flif',
	'xcf',
	'cr2',
	'cr3',
	'orf',
	'arw',
	'dng',
	'nef',
	'rw2',
	'raf',
	'tif',
	'bmp',
	'icns',
	'jxr',
	'psd',
	'indd',
	'zip',
	'tar',
	'rar',
	'gz',
	'bz2',
	'7z',
	'dmg',
	'mp4',
	'mid',
	'mkv',
	'webm',
	'mov',
	'avi',
	'mpg',
	'mp2',
	'mp3',
	'm4a',
	'oga',
	'ogg',
	'ogv',
	'opus',
	'flac',
	'wav',
	'spx',
	'amr',
	'pdf',
	'epub',
	'elf',
	'macho',
	'exe',
	'swf',
	'rtf',
	'wasm',
	'woff',
	'woff2',
	'eot',
	'ttf',
	'otf',
	'ttc',
	'ico',
	'flv',
	'ps',
	'xz',
	'sqlite',
	'nes',
	'crx',
	'xpi',
	'cab',
	'deb',
	'ar',
	'rpm',
	'Z',
	'lz',
	'cfb',
	'mxf',
	'mts',
	'blend',
	'bpg',
	'docx',
	'pptx',
	'xlsx',
	'3gp',
	'3g2',
	'j2c',
	'jp2',
	'jpm',
	'jpx',
	'mj2',
	'aif',
	'qcp',
	'odt',
	'ods',
	'odp',
	'xml',
	'mobi',
	'heic',
	'cur',
	'ktx',
	'ape',
	'wv',
	'dcm',
	'ics',
	'glb',
	'pcap',
	'dsf',
	'lnk',
	'alias',
	'voc',
	'ac3',
	'm4v',
	'm4p',
	'm4b',
	'f4v',
	'f4p',
	'f4b',
	'f4a',
	'mie',
	'asf',
	'ogm',
	'ogx',
	'mpc',
	'arrow',
	'shp',
	'aac',
	'mp1',
	'it',
	's3m',
	'xm',
	'skp',
	'avif',
	'eps',
	'lzh',
	'pgp',
	'asar',
	'stl',
	'chm',
	'3mf',
	'zst',
	'jxl',
	'vcf',
	'jls',
	'pst',
	'dwg',
	'parquet',
	'class',
	'arj',
	'cpio',
	'ace',
	'avro',
	'icc',
	'fbx',
	'vsdx',
	'vtt',
	'apk',
	'drc',
	'lz4',
	'potx',
	'xltx',
	'dotx',
	'xltm',
	'ott',
	'ots',
	'otp',
	'odg',
	'otg',
	'xlsm',
	'docm',
	'dotm',
	'potm',
	'pptm',
	'jar',
	'rm',
	'ppsm',
	'ppsx',
	'tar.gz',
	'reg',
	'dat',
];

const mimeTypes$1 = [
	'image/jpeg',
	'image/png',
	'image/gif',
	'image/webp',
	'image/flif',
	'image/x-xcf',
	'image/x-canon-cr2',
	'image/x-canon-cr3',
	'image/tiff',
	'image/bmp',
	'image/vnd.ms-photo',
	'image/vnd.adobe.photoshop',
	'application/x-indesign',
	'application/epub+zip',
	'application/x-xpinstall',
	'application/vnd.ms-powerpoint.slideshow.macroenabled.12',
	'application/vnd.oasis.opendocument.text',
	'application/vnd.oasis.opendocument.spreadsheet',
	'application/vnd.oasis.opendocument.presentation',
	'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
	'application/vnd.openxmlformats-officedocument.presentationml.presentation',
	'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
	'application/vnd.openxmlformats-officedocument.presentationml.slideshow',
	'application/zip',
	'application/x-tar',
	'application/x-rar-compressed',
	'application/gzip',
	'application/x-bzip2',
	'application/x-7z-compressed',
	'application/x-apple-diskimage',
	'application/vnd.apache.arrow.file',
	'video/mp4',
	'audio/midi',
	'video/matroska',
	'video/webm',
	'video/quicktime',
	'video/vnd.avi',
	'audio/wav',
	'audio/qcelp',
	'audio/x-ms-asf',
	'video/x-ms-asf',
	'application/vnd.ms-asf',
	'video/mpeg',
	'video/3gpp',
	'audio/mpeg',
	'audio/mp4', // RFC 4337
	'video/ogg',
	'audio/ogg',
	'audio/ogg; codecs=opus',
	'application/ogg',
	'audio/flac',
	'audio/ape',
	'audio/wavpack',
	'audio/amr',
	'application/pdf',
	'application/x-elf',
	'application/x-mach-binary',
	'application/x-msdownload',
	'application/x-shockwave-flash',
	'application/rtf',
	'application/wasm',
	'font/woff',
	'font/woff2',
	'application/vnd.ms-fontobject',
	'font/ttf',
	'font/otf',
	'font/collection',
	'image/x-icon',
	'video/x-flv',
	'application/postscript',
	'application/eps',
	'application/x-xz',
	'application/x-sqlite3',
	'application/x-nintendo-nes-rom',
	'application/x-google-chrome-extension',
	'application/vnd.ms-cab-compressed',
	'application/x-deb',
	'application/x-unix-archive',
	'application/x-rpm',
	'application/x-compress',
	'application/x-lzip',
	'application/x-cfb',
	'application/x-mie',
	'application/mxf',
	'video/mp2t',
	'application/x-blender',
	'image/bpg',
	'image/j2c',
	'image/jp2',
	'image/jpx',
	'image/jpm',
	'image/mj2',
	'audio/aiff',
	'application/xml',
	'application/x-mobipocket-ebook',
	'image/heif',
	'image/heif-sequence',
	'image/heic',
	'image/heic-sequence',
	'image/icns',
	'image/ktx',
	'application/dicom',
	'audio/x-musepack',
	'text/calendar',
	'text/vcard',
	'text/vtt',
	'model/gltf-binary',
	'application/vnd.tcpdump.pcap',
	'audio/x-dsf', // Non-standard
	'application/x.ms.shortcut', // Invented by us
	'application/x.apple.alias', // Invented by us
	'audio/x-voc',
	'audio/vnd.dolby.dd-raw',
	'audio/x-m4a',
	'image/apng',
	'image/x-olympus-orf',
	'image/x-sony-arw',
	'image/x-adobe-dng',
	'image/x-nikon-nef',
	'image/x-panasonic-rw2',
	'image/x-fujifilm-raf',
	'video/x-m4v',
	'video/3gpp2',
	'application/x-esri-shape',
	'audio/aac',
	'audio/x-it',
	'audio/x-s3m',
	'audio/x-xm',
	'video/MP1S',
	'video/MP2P',
	'application/vnd.sketchup.skp',
	'image/avif',
	'application/x-lzh-compressed',
	'application/pgp-encrypted',
	'application/x-asar',
	'model/stl',
	'application/vnd.ms-htmlhelp',
	'model/3mf',
	'image/jxl',
	'application/zstd',
	'image/jls',
	'application/vnd.ms-outlook',
	'image/vnd.dwg',
	'application/vnd.apache.parquet',
	'application/java-vm',
	'application/x-arj',
	'application/x-cpio',
	'application/x-ace-compressed',
	'application/avro',
	'application/vnd.iccprofile',
	'application/x.autodesk.fbx', // Invented by us
	'application/vnd.visio',
	'application/vnd.android.package-archive',
	'application/vnd.google.draco', // Invented by us
	'application/x-lz4', // Invented by us
	'application/vnd.openxmlformats-officedocument.presentationml.template',
	'application/vnd.openxmlformats-officedocument.spreadsheetml.template',
	'application/vnd.openxmlformats-officedocument.wordprocessingml.template',
	'application/vnd.ms-excel.template.macroenabled.12',
	'application/vnd.oasis.opendocument.text-template',
	'application/vnd.oasis.opendocument.spreadsheet-template',
	'application/vnd.oasis.opendocument.presentation-template',
	'application/vnd.oasis.opendocument.graphics',
	'application/vnd.oasis.opendocument.graphics-template',
	'application/vnd.ms-excel.sheet.macroenabled.12',
	'application/vnd.ms-word.document.macroenabled.12',
	'application/vnd.ms-word.template.macroenabled.12',
	'application/vnd.ms-powerpoint.template.macroenabled.12',
	'application/vnd.ms-powerpoint.presentation.macroenabled.12',
	'application/java-archive',
	'application/vnd.rn-realmedia',
	'application/x-ms-regedit',
	'application/x-ft-windows-registry-hive',
];

/**
Primary entry point, Node.js specific entry point is index.js
*/


const reasonableDetectionSizeInBytes = 4100; // A fair amount of file-types are detectable within this range.

function getFileTypeFromMimeType(mimeType) {
	mimeType = mimeType.toLowerCase();
	switch (mimeType) {
		case 'application/epub+zip':
			return {
				ext: 'epub',
				mime: mimeType,
			};
		case 'application/vnd.oasis.opendocument.text':
			return {
				ext: 'odt',
				mime: mimeType,
			};
		case 'application/vnd.oasis.opendocument.text-template':
			return {
				ext: 'ott',
				mime: mimeType,
			};
		case 'application/vnd.oasis.opendocument.spreadsheet':
			return {
				ext: 'ods',
				mime: mimeType,
			};
		case 'application/vnd.oasis.opendocument.spreadsheet-template':
			return {
				ext: 'ots',
				mime: mimeType,
			};
		case 'application/vnd.oasis.opendocument.presentation':
			return {
				ext: 'odp',
				mime: mimeType,
			};
		case 'application/vnd.oasis.opendocument.presentation-template':
			return {
				ext: 'otp',
				mime: mimeType,
			};
		case 'application/vnd.oasis.opendocument.graphics':
			return {
				ext: 'odg',
				mime: mimeType,
			};
		case 'application/vnd.oasis.opendocument.graphics-template':
			return {
				ext: 'otg',
				mime: mimeType,
			};
		case 'application/vnd.openxmlformats-officedocument.presentationml.slideshow':
			return {
				ext: 'ppsx',
				mime: mimeType,
			};
		case 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet':
			return {
				ext: 'xlsx',
				mime: mimeType,
			};
		case 'application/vnd.ms-excel.sheet.macroenabled':
			return {
				ext: 'xlsm',
				mime: 'application/vnd.ms-excel.sheet.macroenabled.12',
			};
		case 'application/vnd.openxmlformats-officedocument.spreadsheetml.template':
			return {
				ext: 'xltx',
				mime: mimeType,
			};
		case 'application/vnd.ms-excel.template.macroenabled':
			return {
				ext: 'xltm',
				mime: 'application/vnd.ms-excel.template.macroenabled.12',
			};
		case 'application/vnd.ms-powerpoint.slideshow.macroenabled':
			return {
				ext: 'ppsm',
				mime: 'application/vnd.ms-powerpoint.slideshow.macroenabled.12',
			};
		case 'application/vnd.openxmlformats-officedocument.wordprocessingml.document':
			return {
				ext: 'docx',
				mime: mimeType,
			};
		case 'application/vnd.ms-word.document.macroenabled':
			return {
				ext: 'docm',
				mime: 'application/vnd.ms-word.document.macroenabled.12',
			};
		case 'application/vnd.openxmlformats-officedocument.wordprocessingml.template':
			return {
				ext: 'dotx',
				mime: mimeType,
			};
		case 'application/vnd.ms-word.template.macroenabledtemplate':
			return {
				ext: 'dotm',
				mime: 'application/vnd.ms-word.template.macroenabled.12',
			};
		case 'application/vnd.openxmlformats-officedocument.presentationml.template':
			return {
				ext: 'potx',
				mime: mimeType,
			};
		case 'application/vnd.ms-powerpoint.template.macroenabled':
			return {
				ext: 'potm',
				mime: 'application/vnd.ms-powerpoint.template.macroenabled.12',
			};
		case 'application/vnd.openxmlformats-officedocument.presentationml.presentation':
			return {
				ext: 'pptx',
				mime: mimeType,
			};
		case 'application/vnd.ms-powerpoint.presentation.macroenabled':
			return {
				ext: 'pptm',
				mime: 'application/vnd.ms-powerpoint.presentation.macroenabled.12',
			};
		case 'application/vnd.ms-visio.drawing':
			return {
				ext: 'vsdx',
				mime: 'application/vnd.visio',
			};
		case 'application/vnd.ms-package.3dmanufacturing-3dmodel+xml':
			return {
				ext: '3mf',
				mime: 'model/3mf',
			};
	}
}

function _check(buffer, headers, options) {
	options = {
		offset: 0,
		...options,
	};

	for (const [index, header] of headers.entries()) {
		// If a bitmask is set
		if (options.mask) {
			// If header doesn't equal `buf` with bits masked off
			if (header !== (options.mask[index] & buffer[index + options.offset])) {
				return false;
			}
		} else if (header !== buffer[index + options.offset]) {
			return false;
		}
	}

	return true;
}

let FileTypeParser$1 = class FileTypeParser {
	constructor(options) {
		this.options = {
			mpegOffsetTolerance: 0,
			...options,
		};

		this.detectors = [...(options?.customDetectors ?? []),
			{id: 'core', detect: this.detectConfident},
			{id: 'core.imprecise', detect: this.detectImprecise}];
		this.tokenizerOptions = {
			abortSignal: options?.signal,
		};
	}

	async fromTokenizer(tokenizer) {
		const initialPosition = tokenizer.position;

		// Iterate through all file-type detectors
		for (const detector of this.detectors) {
			const fileType = await detector.detect(tokenizer);
			if (fileType) {
				return fileType;
			}

			if (initialPosition !== tokenizer.position) {
				return undefined; // Cannot proceed scanning of the tokenizer is at an arbitrary position
			}
		}
	}

	async fromBuffer(input) {
		if (!(input instanceof Uint8Array || input instanceof ArrayBuffer)) {
			throw new TypeError(`Expected the \`input\` argument to be of type \`Uint8Array\` or \`ArrayBuffer\`, got \`${typeof input}\``);
		}

		const buffer = input instanceof Uint8Array ? input : new Uint8Array(input);

		if (!(buffer?.length > 1)) {
			return;
		}

		return this.fromTokenizer(fromBuffer$1(buffer, this.tokenizerOptions));
	}

	async fromBlob(blob) {
		const tokenizer = fromBlob(blob, this.tokenizerOptions);
		try {
			return await this.fromTokenizer(tokenizer);
		} finally {
			await tokenizer.close();
		}
	}

	async fromStream(stream) {
		const tokenizer = fromWebStream(stream, this.tokenizerOptions);
		try {
			return await this.fromTokenizer(tokenizer);
		} finally {
			await tokenizer.close();
		}
	}

	async toDetectionStream(stream, options) {
		const {sampleSize = reasonableDetectionSizeInBytes} = options;
		let detectedFileType;
		let firstChunk;

		const reader = stream.getReader({mode: 'byob'});
		try {
			// Read the first chunk from the stream
			const {value: chunk, done} = await reader.read(new Uint8Array(sampleSize));
			firstChunk = chunk;
			if (!done && chunk) {
				try {
					// Attempt to detect the file type from the chunk
					detectedFileType = await this.fromBuffer(chunk.subarray(0, sampleSize));
				} catch (error) {
					if (!(error instanceof EndOfStreamError)) {
						throw error; // Re-throw non-EndOfStreamError
					}

					detectedFileType = undefined;
				}
			}

			firstChunk = chunk;
		} finally {
			reader.releaseLock(); // Ensure the reader is released
		}

		// Create a new ReadableStream to manage locking issues
		const transformStream = new TransformStream({
			async start(controller) {
				controller.enqueue(firstChunk); // Enqueue the initial chunk
			},
			transform(chunk, controller) {
				// Pass through the chunks without modification
				controller.enqueue(chunk);
			},
		});

		const newStream = stream.pipeThrough(transformStream);
		newStream.fileType = detectedFileType;

		return newStream;
	}

	check(header, options) {
		return _check(this.buffer, header, options);
	}

	checkString(header, options) {
		return this.check(stringToBytes(header, options?.encoding), options);
	}

	// Detections with a high degree of certainty in identifying the correct file type
	detectConfident = async tokenizer => {
		this.buffer = new Uint8Array(reasonableDetectionSizeInBytes);

		// Keep reading until EOF if the file size is unknown.
		if (tokenizer.fileInfo.size === undefined) {
			tokenizer.fileInfo.size = Number.MAX_SAFE_INTEGER;
		}

		this.tokenizer = tokenizer;

		await tokenizer.peekBuffer(this.buffer, {length: 32, mayBeLess: true});

		// -- 2-byte signatures --

		if (this.check([0x42, 0x4D])) {
			return {
				ext: 'bmp',
				mime: 'image/bmp',
			};
		}

		if (this.check([0x0B, 0x77])) {
			return {
				ext: 'ac3',
				mime: 'audio/vnd.dolby.dd-raw',
			};
		}

		if (this.check([0x78, 0x01])) {
			return {
				ext: 'dmg',
				mime: 'application/x-apple-diskimage',
			};
		}

		if (this.check([0x4D, 0x5A])) {
			return {
				ext: 'exe',
				mime: 'application/x-msdownload',
			};
		}

		if (this.check([0x25, 0x21])) {
			await tokenizer.peekBuffer(this.buffer, {length: 24, mayBeLess: true});

			if (
				this.checkString('PS-Adobe-', {offset: 2})
				&& this.checkString(' EPSF-', {offset: 14})
			) {
				return {
					ext: 'eps',
					mime: 'application/eps',
				};
			}

			return {
				ext: 'ps',
				mime: 'application/postscript',
			};
		}

		if (
			this.check([0x1F, 0xA0])
			|| this.check([0x1F, 0x9D])
		) {
			return {
				ext: 'Z',
				mime: 'application/x-compress',
			};
		}

		if (this.check([0xC7, 0x71])) {
			return {
				ext: 'cpio',
				mime: 'application/x-cpio',
			};
		}

		if (this.check([0x60, 0xEA])) {
			return {
				ext: 'arj',
				mime: 'application/x-arj',
			};
		}

		// -- 3-byte signatures --

		if (this.check([0xEF, 0xBB, 0xBF])) { // UTF-8-BOM
			// Strip off UTF-8-BOM
			this.tokenizer.ignore(3);
			return this.detectConfident(tokenizer);
		}

		if (this.check([0x47, 0x49, 0x46])) {
			return {
				ext: 'gif',
				mime: 'image/gif',
			};
		}

		if (this.check([0x49, 0x49, 0xBC])) {
			return {
				ext: 'jxr',
				mime: 'image/vnd.ms-photo',
			};
		}

		if (this.check([0x1F, 0x8B, 0x8])) {
			const gzipHandler = new GzipHandler(tokenizer);

			const stream = gzipHandler.inflate();
			try {
				const compressedFileType = await this.fromStream(stream);
				if (compressedFileType && compressedFileType.ext === 'tar') {
					return {
						ext: 'tar.gz',
						mime: 'application/gzip',
					};
				}
			} finally {
				await stream.cancel();
			}

			return {
				ext: 'gz',
				mime: 'application/gzip',
			};
		}

		if (this.check([0x42, 0x5A, 0x68])) {
			return {
				ext: 'bz2',
				mime: 'application/x-bzip2',
			};
		}

		if (this.checkString('ID3')) {
			await tokenizer.ignore(6); // Skip ID3 header until the header size
			const id3HeaderLength = await tokenizer.readToken(uint32SyncSafeToken);
			if (tokenizer.position + id3HeaderLength > tokenizer.fileInfo.size) {
				// Guess file type based on ID3 header for backward compatibility
				return {
					ext: 'mp3',
					mime: 'audio/mpeg',
				};
			}

			await tokenizer.ignore(id3HeaderLength);
			return this.fromTokenizer(tokenizer); // Skip ID3 header, recursion
		}

		// Musepack, SV7
		if (this.checkString('MP+')) {
			return {
				ext: 'mpc',
				mime: 'audio/x-musepack',
			};
		}

		if (
			(this.buffer[0] === 0x43 || this.buffer[0] === 0x46)
			&& this.check([0x57, 0x53], {offset: 1})
		) {
			return {
				ext: 'swf',
				mime: 'application/x-shockwave-flash',
			};
		}

		// -- 4-byte signatures --

		// Requires a sample size of 4 bytes
		if (this.check([0xFF, 0xD8, 0xFF])) {
			if (this.check([0xF7], {offset: 3})) { // JPG7/SOF55, indicating a ISO/IEC 14495 / JPEG-LS file
				return {
					ext: 'jls',
					mime: 'image/jls',
				};
			}

			return {
				ext: 'jpg',
				mime: 'image/jpeg',
			};
		}

		if (this.check([0x4F, 0x62, 0x6A, 0x01])) {
			return {
				ext: 'avro',
				mime: 'application/avro',
			};
		}

		if (this.checkString('FLIF')) {
			return {
				ext: 'flif',
				mime: 'image/flif',
			};
		}

		if (this.checkString('8BPS')) {
			return {
				ext: 'psd',
				mime: 'image/vnd.adobe.photoshop',
			};
		}

		// Musepack, SV8
		if (this.checkString('MPCK')) {
			return {
				ext: 'mpc',
				mime: 'audio/x-musepack',
			};
		}

		if (this.checkString('FORM')) {
			return {
				ext: 'aif',
				mime: 'audio/aiff',
			};
		}

		if (this.checkString('icns', {offset: 0})) {
			return {
				ext: 'icns',
				mime: 'image/icns',
			};
		}

		// Zip-based file formats
		// Need to be before the `zip` check
		if (this.check([0x50, 0x4B, 0x3, 0x4])) { // Local file header signature
			let fileType;
			await new ZipHandler(tokenizer).unzip(zipHeader => {
				switch (zipHeader.filename) {
					case 'META-INF/mozilla.rsa':
						fileType = {
							ext: 'xpi',
							mime: 'application/x-xpinstall',
						};
						return {
							stop: true,
						};
					case 'META-INF/MANIFEST.MF':
						fileType = {
							ext: 'jar',
							mime: 'application/java-archive',
						};
						return {
							stop: true,
						};
					case 'mimetype':
						return {
							async handler(fileData) {
								// Use TextDecoder to decode the UTF-8 encoded data
								const mimeType = new TextDecoder('utf-8').decode(fileData).trim();
								fileType = getFileTypeFromMimeType(mimeType);
							},
							stop: true,
						};

					case '[Content_Types].xml':
						return {
							async handler(fileData) {
								// Use TextDecoder to decode the UTF-8 encoded data
								let xmlContent = new TextDecoder('utf-8').decode(fileData);
								const endPos = xmlContent.indexOf('.main+xml"');
								if (endPos === -1) {
									const mimeType = 'application/vnd.ms-package.3dmanufacturing-3dmodel+xml';
									if (xmlContent.includes(`ContentType="${mimeType}"`)) {
										fileType = getFileTypeFromMimeType(mimeType);
									}
								} else {
									xmlContent = xmlContent.slice(0, Math.max(0, endPos));
									const firstPos = xmlContent.lastIndexOf('"');
									const mimeType = xmlContent.slice(Math.max(0, firstPos + 1));
									fileType = getFileTypeFromMimeType(mimeType);
								}
							},
							stop: true,
						};
					default:
						if (/classes\d*\.dex/.test(zipHeader.filename)) {
							fileType = {
								ext: 'apk',
								mime: 'application/vnd.android.package-archive',
							};
							return {stop: true};
						}

						return {};
				}
			}).catch(error => {
				if (!(error instanceof EndOfStreamError)) {
					throw error; // Re-throw non-EndOfStreamError
				}
			});

			return fileType ?? {
				ext: 'zip',
				mime: 'application/zip',
			};
		}

		if (this.checkString('OggS')) {
			// This is an OGG container
			await tokenizer.ignore(28);
			const type = new Uint8Array(8);
			await tokenizer.readBuffer(type);

			// Needs to be before `ogg` check
			if (_check(type, [0x4F, 0x70, 0x75, 0x73, 0x48, 0x65, 0x61, 0x64])) {
				return {
					ext: 'opus',
					mime: 'audio/ogg; codecs=opus',
				};
			}

			// If ' theora' in header.
			if (_check(type, [0x80, 0x74, 0x68, 0x65, 0x6F, 0x72, 0x61])) {
				return {
					ext: 'ogv',
					mime: 'video/ogg',
				};
			}

			// If '\x01video' in header.
			if (_check(type, [0x01, 0x76, 0x69, 0x64, 0x65, 0x6F, 0x00])) {
				return {
					ext: 'ogm',
					mime: 'video/ogg',
				};
			}

			// If ' FLAC' in header  https://xiph.org/flac/faq.html
			if (_check(type, [0x7F, 0x46, 0x4C, 0x41, 0x43])) {
				return {
					ext: 'oga',
					mime: 'audio/ogg',
				};
			}

			// 'Speex  ' in header https://en.wikipedia.org/wiki/Speex
			if (_check(type, [0x53, 0x70, 0x65, 0x65, 0x78, 0x20, 0x20])) {
				return {
					ext: 'spx',
					mime: 'audio/ogg',
				};
			}

			// If '\x01vorbis' in header
			if (_check(type, [0x01, 0x76, 0x6F, 0x72, 0x62, 0x69, 0x73])) {
				return {
					ext: 'ogg',
					mime: 'audio/ogg',
				};
			}

			// Default OGG container https://www.iana.org/assignments/media-types/application/ogg
			return {
				ext: 'ogx',
				mime: 'application/ogg',
			};
		}

		if (
			this.check([0x50, 0x4B])
			&& (this.buffer[2] === 0x3 || this.buffer[2] === 0x5 || this.buffer[2] === 0x7)
			&& (this.buffer[3] === 0x4 || this.buffer[3] === 0x6 || this.buffer[3] === 0x8)
		) {
			return {
				ext: 'zip',
				mime: 'application/zip',
			};
		}

		if (this.checkString('MThd')) {
			return {
				ext: 'mid',
				mime: 'audio/midi',
			};
		}

		if (
			this.checkString('wOFF')
			&& (
				this.check([0x00, 0x01, 0x00, 0x00], {offset: 4})
				|| this.checkString('OTTO', {offset: 4})
			)
		) {
			return {
				ext: 'woff',
				mime: 'font/woff',
			};
		}

		if (
			this.checkString('wOF2')
			&& (
				this.check([0x00, 0x01, 0x00, 0x00], {offset: 4})
				|| this.checkString('OTTO', {offset: 4})
			)
		) {
			return {
				ext: 'woff2',
				mime: 'font/woff2',
			};
		}

		if (this.check([0xD4, 0xC3, 0xB2, 0xA1]) || this.check([0xA1, 0xB2, 0xC3, 0xD4])) {
			return {
				ext: 'pcap',
				mime: 'application/vnd.tcpdump.pcap',
			};
		}

		// Sony DSD Stream File (DSF)
		if (this.checkString('DSD ')) {
			return {
				ext: 'dsf',
				mime: 'audio/x-dsf', // Non-standard
			};
		}

		if (this.checkString('LZIP')) {
			return {
				ext: 'lz',
				mime: 'application/x-lzip',
			};
		}

		if (this.checkString('fLaC')) {
			return {
				ext: 'flac',
				mime: 'audio/flac',
			};
		}

		if (this.check([0x42, 0x50, 0x47, 0xFB])) {
			return {
				ext: 'bpg',
				mime: 'image/bpg',
			};
		}

		if (this.checkString('wvpk')) {
			return {
				ext: 'wv',
				mime: 'audio/wavpack',
			};
		}

		if (this.checkString('%PDF')) {
			// Assume this is just a normal PDF
			return {
				ext: 'pdf',
				mime: 'application/pdf',
			};
		}

		if (this.check([0x00, 0x61, 0x73, 0x6D])) {
			return {
				ext: 'wasm',
				mime: 'application/wasm',
			};
		}

		// TIFF, little-endian type
		if (this.check([0x49, 0x49])) {
			const fileType = await this.readTiffHeader(false);
			if (fileType) {
				return fileType;
			}
		}

		// TIFF, big-endian type
		if (this.check([0x4D, 0x4D])) {
			const fileType = await this.readTiffHeader(true);
			if (fileType) {
				return fileType;
			}
		}

		if (this.checkString('MAC ')) {
			return {
				ext: 'ape',
				mime: 'audio/ape',
			};
		}

		// https://github.com/file/file/blob/master/magic/Magdir/matroska
		if (this.check([0x1A, 0x45, 0xDF, 0xA3])) { // Root element: EBML
			async function readField() {
				const msb = await tokenizer.peekNumber(UINT8);
				let mask = 0x80;
				let ic = 0; // 0 = A, 1 = B, 2 = C, 3 = D

				while ((msb & mask) === 0 && mask !== 0) {
					++ic;
					mask >>= 1;
				}

				const id = new Uint8Array(ic + 1);
				await tokenizer.readBuffer(id);
				return id;
			}

			async function readElement() {
				const idField = await readField();
				const lengthField = await readField();

				lengthField[0] ^= 0x80 >> (lengthField.length - 1);
				const nrLength = Math.min(6, lengthField.length); // JavaScript can max read 6 bytes integer

				const idView = new DataView(idField.buffer);
				const lengthView = new DataView(lengthField.buffer, lengthField.length - nrLength, nrLength);

				return {
					id: getUintBE(idView),
					len: getUintBE(lengthView),
				};
			}

			async function readChildren(children) {
				while (children > 0) {
					const element = await readElement();
					if (element.id === 0x42_82) {
						const rawValue = await tokenizer.readToken(new StringType(element.len));
						return rawValue.replaceAll(/\00.*$/g, ''); // Return DocType
					}

					await tokenizer.ignore(element.len); // ignore payload
					--children;
				}
			}

			const re = await readElement();
			const documentType = await readChildren(re.len);

			switch (documentType) {
				case 'webm':
					return {
						ext: 'webm',
						mime: 'video/webm',
					};

				case 'matroska':
					return {
						ext: 'mkv',
						mime: 'video/matroska',
					};

				default:
					return;
			}
		}

		if (this.checkString('SQLi')) {
			return {
				ext: 'sqlite',
				mime: 'application/x-sqlite3',
			};
		}

		if (this.check([0x4E, 0x45, 0x53, 0x1A])) {
			return {
				ext: 'nes',
				mime: 'application/x-nintendo-nes-rom',
			};
		}

		if (this.checkString('Cr24')) {
			return {
				ext: 'crx',
				mime: 'application/x-google-chrome-extension',
			};
		}

		if (
			this.checkString('MSCF')
			|| this.checkString('ISc(')
		) {
			return {
				ext: 'cab',
				mime: 'application/vnd.ms-cab-compressed',
			};
		}

		if (this.check([0xED, 0xAB, 0xEE, 0xDB])) {
			return {
				ext: 'rpm',
				mime: 'application/x-rpm',
			};
		}

		if (this.check([0xC5, 0xD0, 0xD3, 0xC6])) {
			return {
				ext: 'eps',
				mime: 'application/eps',
			};
		}

		if (this.check([0x28, 0xB5, 0x2F, 0xFD])) {
			return {
				ext: 'zst',
				mime: 'application/zstd',
			};
		}

		if (this.check([0x7F, 0x45, 0x4C, 0x46])) {
			return {
				ext: 'elf',
				mime: 'application/x-elf',
			};
		}

		if (this.check([0x21, 0x42, 0x44, 0x4E])) {
			return {
				ext: 'pst',
				mime: 'application/vnd.ms-outlook',
			};
		}

		if (this.checkString('PAR1') || this.checkString('PARE')) {
			return {
				ext: 'parquet',
				mime: 'application/vnd.apache.parquet',
			};
		}

		if (this.checkString('ttcf')) {
			return {
				ext: 'ttc',
				mime: 'font/collection',
			};
		}

		if (this.check([0xCF, 0xFA, 0xED, 0xFE])) {
			return {
				ext: 'macho',
				mime: 'application/x-mach-binary',
			};
		}

		if (this.check([0x04, 0x22, 0x4D, 0x18])) {
			return {
				ext: 'lz4',
				mime: 'application/x-lz4', // Invented by us
			};
		}

		if (this.checkString('regf')) {
			return {
				ext: 'dat',
				mime: 'application/x-ft-windows-registry-hive',
			};
		}

		// -- 5-byte signatures --

		if (this.check([0x4F, 0x54, 0x54, 0x4F, 0x00])) {
			return {
				ext: 'otf',
				mime: 'font/otf',
			};
		}

		if (this.checkString('#!AMR')) {
			return {
				ext: 'amr',
				mime: 'audio/amr',
			};
		}

		if (this.checkString('{\\rtf')) {
			return {
				ext: 'rtf',
				mime: 'application/rtf',
			};
		}

		if (this.check([0x46, 0x4C, 0x56, 0x01])) {
			return {
				ext: 'flv',
				mime: 'video/x-flv',
			};
		}

		if (this.checkString('IMPM')) {
			return {
				ext: 'it',
				mime: 'audio/x-it',
			};
		}

		if (
			this.checkString('-lh0-', {offset: 2})
			|| this.checkString('-lh1-', {offset: 2})
			|| this.checkString('-lh2-', {offset: 2})
			|| this.checkString('-lh3-', {offset: 2})
			|| this.checkString('-lh4-', {offset: 2})
			|| this.checkString('-lh5-', {offset: 2})
			|| this.checkString('-lh6-', {offset: 2})
			|| this.checkString('-lh7-', {offset: 2})
			|| this.checkString('-lzs-', {offset: 2})
			|| this.checkString('-lz4-', {offset: 2})
			|| this.checkString('-lz5-', {offset: 2})
			|| this.checkString('-lhd-', {offset: 2})
		) {
			return {
				ext: 'lzh',
				mime: 'application/x-lzh-compressed',
			};
		}

		// MPEG program stream (PS or MPEG-PS)
		if (this.check([0x00, 0x00, 0x01, 0xBA])) {
			//  MPEG-PS, MPEG-1 Part 1
			if (this.check([0x21], {offset: 4, mask: [0xF1]})) {
				return {
					ext: 'mpg', // May also be .ps, .mpeg
					mime: 'video/MP1S',
				};
			}

			// MPEG-PS, MPEG-2 Part 1
			if (this.check([0x44], {offset: 4, mask: [0xC4]})) {
				return {
					ext: 'mpg', // May also be .mpg, .m2p, .vob or .sub
					mime: 'video/MP2P',
				};
			}
		}

		if (this.checkString('ITSF')) {
			return {
				ext: 'chm',
				mime: 'application/vnd.ms-htmlhelp',
			};
		}

		if (this.check([0xCA, 0xFE, 0xBA, 0xBE])) {
			return {
				ext: 'class',
				mime: 'application/java-vm',
			};
		}

		if (this.checkString('.RMF')) {
			return {
				ext: 'rm',
				mime: 'application/vnd.rn-realmedia',
			};
		}

		// -- 5-byte signatures --

		if (this.checkString('DRACO')) {
			return {
				ext: 'drc',
				mime: 'application/vnd.google.draco', // Invented by us
			};
		}

		// -- 6-byte signatures --

		if (this.check([0xFD, 0x37, 0x7A, 0x58, 0x5A, 0x00])) {
			return {
				ext: 'xz',
				mime: 'application/x-xz',
			};
		}

		if (this.checkString('<?xml ')) {
			return {
				ext: 'xml',
				mime: 'application/xml',
			};
		}

		if (this.check([0x37, 0x7A, 0xBC, 0xAF, 0x27, 0x1C])) {
			return {
				ext: '7z',
				mime: 'application/x-7z-compressed',
			};
		}

		if (
			this.check([0x52, 0x61, 0x72, 0x21, 0x1A, 0x7])
			&& (this.buffer[6] === 0x0 || this.buffer[6] === 0x1)
		) {
			return {
				ext: 'rar',
				mime: 'application/x-rar-compressed',
			};
		}

		if (this.checkString('solid ')) {
			return {
				ext: 'stl',
				mime: 'model/stl',
			};
		}

		if (this.checkString('AC')) {
			const version = new StringType(4, 'latin1').get(this.buffer, 2);
			if (version.match('^d*') && version >= 1000 && version <= 1050) {
				return {
					ext: 'dwg',
					mime: 'image/vnd.dwg',
				};
			}
		}

		if (this.checkString('070707')) {
			return {
				ext: 'cpio',
				mime: 'application/x-cpio',
			};
		}

		// -- 7-byte signatures --

		if (this.checkString('BLENDER')) {
			return {
				ext: 'blend',
				mime: 'application/x-blender',
			};
		}

		if (this.checkString('!<arch>')) {
			await tokenizer.ignore(8);
			const string = await tokenizer.readToken(new StringType(13, 'ascii'));
			if (string === 'debian-binary') {
				return {
					ext: 'deb',
					mime: 'application/x-deb',
				};
			}

			return {
				ext: 'ar',
				mime: 'application/x-unix-archive',
			};
		}

		if (
			this.checkString('WEBVTT')
			&&	(
				// One of LF, CR, tab, space, or end of file must follow "WEBVTT" per the spec (see `fixture/fixture-vtt-*.vtt` for examples). Note that `\0` is technically the null character (there is no such thing as an EOF character). However, checking for `\0` gives us the same result as checking for the end of the stream.
				(['\n', '\r', '\t', ' ', '\0'].some(char7 => this.checkString(char7, {offset: 6}))))
		) {
			return {
				ext: 'vtt',
				mime: 'text/vtt',
			};
		}

		// -- 8-byte signatures --

		if (this.check([0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A])) {
			// APNG format (https://wiki.mozilla.org/APNG_Specification)
			// 1. Find the first IDAT (image data) chunk (49 44 41 54)
			// 2. Check if there is an "acTL" chunk before the IDAT one (61 63 54 4C)

			// Offset calculated as follows:
			// - 8 bytes: PNG signature
			// - 4 (length) + 4 (chunk type) + 13 (chunk data) + 4 (CRC): IHDR chunk

			await tokenizer.ignore(8); // ignore PNG signature

			async function readChunkHeader() {
				return {
					length: await tokenizer.readToken(INT32_BE),
					type: await tokenizer.readToken(new StringType(4, 'latin1')),
				};
			}

			do {
				const chunk = await readChunkHeader();
				if (chunk.length < 0) {
					return; // Invalid chunk length
				}

				switch (chunk.type) {
					case 'IDAT':
						return {
							ext: 'png',
							mime: 'image/png',
						};
					case 'acTL':
						return {
							ext: 'apng',
							mime: 'image/apng',
						};
					default:
						await tokenizer.ignore(chunk.length + 4); // Ignore chunk-data + CRC
				}
			} while (tokenizer.position + 8 < tokenizer.fileInfo.size);

			return {
				ext: 'png',
				mime: 'image/png',
			};
		}

		if (this.check([0x41, 0x52, 0x52, 0x4F, 0x57, 0x31, 0x00, 0x00])) {
			return {
				ext: 'arrow',
				mime: 'application/vnd.apache.arrow.file',
			};
		}

		if (this.check([0x67, 0x6C, 0x54, 0x46, 0x02, 0x00, 0x00, 0x00])) {
			return {
				ext: 'glb',
				mime: 'model/gltf-binary',
			};
		}

		// `mov` format variants
		if (
			this.check([0x66, 0x72, 0x65, 0x65], {offset: 4}) // `free`
			|| this.check([0x6D, 0x64, 0x61, 0x74], {offset: 4}) // `mdat` MJPEG
			|| this.check([0x6D, 0x6F, 0x6F, 0x76], {offset: 4}) // `moov`
			|| this.check([0x77, 0x69, 0x64, 0x65], {offset: 4}) // `wide`
		) {
			return {
				ext: 'mov',
				mime: 'video/quicktime',
			};
		}

		// -- 9-byte signatures --

		if (this.check([0x49, 0x49, 0x52, 0x4F, 0x08, 0x00, 0x00, 0x00, 0x18])) {
			return {
				ext: 'orf',
				mime: 'image/x-olympus-orf',
			};
		}

		if (this.checkString('gimp xcf ')) {
			return {
				ext: 'xcf',
				mime: 'image/x-xcf',
			};
		}

		// File Type Box (https://en.wikipedia.org/wiki/ISO_base_media_file_format)
		// It's not required to be first, but it's recommended to be. Almost all ISO base media files start with `ftyp` box.
		// `ftyp` box must contain a brand major identifier, which must consist of ISO 8859-1 printable characters.
		// Here we check for 8859-1 printable characters (for simplicity, it's a mask which also catches one non-printable character).
		if (
			this.checkString('ftyp', {offset: 4})
			&& (this.buffer[8] & 0x60) !== 0x00 // Brand major, first character ASCII?
		) {
			// They all can have MIME `video/mp4` except `application/mp4` special-case which is hard to detect.
			// For some cases, we're specific, everything else falls to `video/mp4` with `mp4` extension.
			const brandMajor = new StringType(4, 'latin1').get(this.buffer, 8).replace('\0', ' ').trim();
			switch (brandMajor) {
				case 'avif':
				case 'avis':
					return {ext: 'avif', mime: 'image/avif'};
				case 'mif1':
					return {ext: 'heic', mime: 'image/heif'};
				case 'msf1':
					return {ext: 'heic', mime: 'image/heif-sequence'};
				case 'heic':
				case 'heix':
					return {ext: 'heic', mime: 'image/heic'};
				case 'hevc':
				case 'hevx':
					return {ext: 'heic', mime: 'image/heic-sequence'};
				case 'qt':
					return {ext: 'mov', mime: 'video/quicktime'};
				case 'M4V':
				case 'M4VH':
				case 'M4VP':
					return {ext: 'm4v', mime: 'video/x-m4v'};
				case 'M4P':
					return {ext: 'm4p', mime: 'video/mp4'};
				case 'M4B':
					return {ext: 'm4b', mime: 'audio/mp4'};
				case 'M4A':
					return {ext: 'm4a', mime: 'audio/x-m4a'};
				case 'F4V':
					return {ext: 'f4v', mime: 'video/mp4'};
				case 'F4P':
					return {ext: 'f4p', mime: 'video/mp4'};
				case 'F4A':
					return {ext: 'f4a', mime: 'audio/mp4'};
				case 'F4B':
					return {ext: 'f4b', mime: 'audio/mp4'};
				case 'crx':
					return {ext: 'cr3', mime: 'image/x-canon-cr3'};
				default:
					if (brandMajor.startsWith('3g')) {
						if (brandMajor.startsWith('3g2')) {
							return {ext: '3g2', mime: 'video/3gpp2'};
						}

						return {ext: '3gp', mime: 'video/3gpp'};
					}

					return {ext: 'mp4', mime: 'video/mp4'};
			}
		}

		// -- 10-byte signatures --

		if (this.checkString('REGEDIT4\r\n')) {
			return {
				ext: 'reg',
				mime: 'application/x-ms-regedit',
			};
		}

		// -- 12-byte signatures --

		// RIFF file format which might be AVI, WAV, QCP, etc
		if (this.check([0x52, 0x49, 0x46, 0x46])) {
			if (this.checkString('WEBP', {offset: 8})) {
				return {
					ext: 'webp',
					mime: 'image/webp',
				};
			}

			if (this.check([0x41, 0x56, 0x49], {offset: 8})) {
				return {
					ext: 'avi',
					mime: 'video/vnd.avi',
				};
			}

			if (this.check([0x57, 0x41, 0x56, 0x45], {offset: 8})) {
				return {
					ext: 'wav',
					mime: 'audio/wav',
				};
			}

			// QLCM, QCP file
			if (this.check([0x51, 0x4C, 0x43, 0x4D], {offset: 8})) {
				return {
					ext: 'qcp',
					mime: 'audio/qcelp',
				};
			}
		}

		if (this.check([0x49, 0x49, 0x55, 0x00, 0x18, 0x00, 0x00, 0x00, 0x88, 0xE7, 0x74, 0xD8])) {
			return {
				ext: 'rw2',
				mime: 'image/x-panasonic-rw2',
			};
		}

		// ASF_Header_Object first 80 bytes
		if (this.check([0x30, 0x26, 0xB2, 0x75, 0x8E, 0x66, 0xCF, 0x11, 0xA6, 0xD9])) {
			async function readHeader() {
				const guid = new Uint8Array(16);
				await tokenizer.readBuffer(guid);
				return {
					id: guid,
					size: Number(await tokenizer.readToken(UINT64_LE)),
				};
			}

			await tokenizer.ignore(30);
			// Search for header should be in first 1KB of file.
			while (tokenizer.position + 24 < tokenizer.fileInfo.size) {
				const header = await readHeader();
				let payload = header.size - 24;
				if (_check(header.id, [0x91, 0x07, 0xDC, 0xB7, 0xB7, 0xA9, 0xCF, 0x11, 0x8E, 0xE6, 0x00, 0xC0, 0x0C, 0x20, 0x53, 0x65])) {
					// Sync on Stream-Properties-Object (B7DC0791-A9B7-11CF-8EE6-00C00C205365)
					const typeId = new Uint8Array(16);
					payload -= await tokenizer.readBuffer(typeId);

					if (_check(typeId, [0x40, 0x9E, 0x69, 0xF8, 0x4D, 0x5B, 0xCF, 0x11, 0xA8, 0xFD, 0x00, 0x80, 0x5F, 0x5C, 0x44, 0x2B])) {
						// Found audio:
						return {
							ext: 'asf',
							mime: 'audio/x-ms-asf',
						};
					}

					if (_check(typeId, [0xC0, 0xEF, 0x19, 0xBC, 0x4D, 0x5B, 0xCF, 0x11, 0xA8, 0xFD, 0x00, 0x80, 0x5F, 0x5C, 0x44, 0x2B])) {
						// Found video:
						return {
							ext: 'asf',
							mime: 'video/x-ms-asf',
						};
					}

					break;
				}

				await tokenizer.ignore(payload);
			}

			// Default to ASF generic extension
			return {
				ext: 'asf',
				mime: 'application/vnd.ms-asf',
			};
		}

		if (this.check([0xAB, 0x4B, 0x54, 0x58, 0x20, 0x31, 0x31, 0xBB, 0x0D, 0x0A, 0x1A, 0x0A])) {
			return {
				ext: 'ktx',
				mime: 'image/ktx',
			};
		}

		if ((this.check([0x7E, 0x10, 0x04]) || this.check([0x7E, 0x18, 0x04])) && this.check([0x30, 0x4D, 0x49, 0x45], {offset: 4})) {
			return {
				ext: 'mie',
				mime: 'application/x-mie',
			};
		}

		if (this.check([0x27, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00], {offset: 2})) {
			return {
				ext: 'shp',
				mime: 'application/x-esri-shape',
			};
		}

		if (this.check([0xFF, 0x4F, 0xFF, 0x51])) {
			return {
				ext: 'j2c',
				mime: 'image/j2c',
			};
		}

		if (this.check([0x00, 0x00, 0x00, 0x0C, 0x6A, 0x50, 0x20, 0x20, 0x0D, 0x0A, 0x87, 0x0A])) {
			// JPEG-2000 family

			await tokenizer.ignore(20);
			const type = await tokenizer.readToken(new StringType(4, 'ascii'));
			switch (type) {
				case 'jp2 ':
					return {
						ext: 'jp2',
						mime: 'image/jp2',
					};
				case 'jpx ':
					return {
						ext: 'jpx',
						mime: 'image/jpx',
					};
				case 'jpm ':
					return {
						ext: 'jpm',
						mime: 'image/jpm',
					};
				case 'mjp2':
					return {
						ext: 'mj2',
						mime: 'image/mj2',
					};
				default:
					return;
			}
		}

		if (
			this.check([0xFF, 0x0A])
			|| this.check([0x00, 0x00, 0x00, 0x0C, 0x4A, 0x58, 0x4C, 0x20, 0x0D, 0x0A, 0x87, 0x0A])
		) {
			return {
				ext: 'jxl',
				mime: 'image/jxl',
			};
		}

		if (this.check([0xFE, 0xFF])) { // UTF-16-BOM-BE
			if (this.checkString('<?xml ', {offset: 2, encoding: 'utf-16be'})) {
				return {
					ext: 'xml',
					mime: 'application/xml',
				};
			}

			return undefined; // Some unknown text based format
		}

		if (this.check([0xD0, 0xCF, 0x11, 0xE0, 0xA1, 0xB1, 0x1A, 0xE1])) {
			// Detected Microsoft Compound File Binary File (MS-CFB) Format.
			return {
				ext: 'cfb',
				mime: 'application/x-cfb',
			};
		}

		// Increase sample size from 32 to 256.
		await tokenizer.peekBuffer(this.buffer, {length: Math.min(256, tokenizer.fileInfo.size), mayBeLess: true});

		if (this.check([0x61, 0x63, 0x73, 0x70], {offset: 36})) {
			return {
				ext: 'icc',
				mime: 'application/vnd.iccprofile',
			};
		}

		// ACE: requires 14 bytes in the buffer
		if (this.checkString('**ACE', {offset: 7}) && this.checkString('**', {offset: 12})) {
			return {
				ext: 'ace',
				mime: 'application/x-ace-compressed',
			};
		}

		// -- 15-byte signatures --

		if (this.checkString('BEGIN:')) {
			if (this.checkString('VCARD', {offset: 6})) {
				return {
					ext: 'vcf',
					mime: 'text/vcard',
				};
			}

			if (this.checkString('VCALENDAR', {offset: 6})) {
				return {
					ext: 'ics',
					mime: 'text/calendar',
				};
			}
		}

		// `raf` is here just to keep all the raw image detectors together.
		if (this.checkString('FUJIFILMCCD-RAW')) {
			return {
				ext: 'raf',
				mime: 'image/x-fujifilm-raf',
			};
		}

		if (this.checkString('Extended Module:')) {
			return {
				ext: 'xm',
				mime: 'audio/x-xm',
			};
		}

		if (this.checkString('Creative Voice File')) {
			return {
				ext: 'voc',
				mime: 'audio/x-voc',
			};
		}

		if (this.check([0x04, 0x00, 0x00, 0x00]) && this.buffer.length >= 16) { // Rough & quick check Pickle/ASAR
			const jsonSize = new DataView(this.buffer.buffer).getUint32(12, true);

			if (jsonSize > 12 && this.buffer.length >= jsonSize + 16) {
				try {
					const header = new TextDecoder().decode(this.buffer.subarray(16, jsonSize + 16));
					const json = JSON.parse(header);
					// Check if Pickle is ASAR
					if (json.files) { // Final check, assuring Pickle/ASAR format
						return {
							ext: 'asar',
							mime: 'application/x-asar',
						};
					}
				} catch {}
			}
		}

		if (this.check([0x06, 0x0E, 0x2B, 0x34, 0x02, 0x05, 0x01, 0x01, 0x0D, 0x01, 0x02, 0x01, 0x01, 0x02])) {
			return {
				ext: 'mxf',
				mime: 'application/mxf',
			};
		}

		if (this.checkString('SCRM', {offset: 44})) {
			return {
				ext: 's3m',
				mime: 'audio/x-s3m',
			};
		}

		// Raw MPEG-2 transport stream (188-byte packets)
		if (this.check([0x47]) && this.check([0x47], {offset: 188})) {
			return {
				ext: 'mts',
				mime: 'video/mp2t',
			};
		}

		// Blu-ray Disc Audio-Video (BDAV) MPEG-2 transport stream has 4-byte TP_extra_header before each 188-byte packet
		if (this.check([0x47], {offset: 4}) && this.check([0x47], {offset: 196})) {
			return {
				ext: 'mts',
				mime: 'video/mp2t',
			};
		}

		if (this.check([0x42, 0x4F, 0x4F, 0x4B, 0x4D, 0x4F, 0x42, 0x49], {offset: 60})) {
			return {
				ext: 'mobi',
				mime: 'application/x-mobipocket-ebook',
			};
		}

		if (this.check([0x44, 0x49, 0x43, 0x4D], {offset: 128})) {
			return {
				ext: 'dcm',
				mime: 'application/dicom',
			};
		}

		if (this.check([0x4C, 0x00, 0x00, 0x00, 0x01, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46])) {
			return {
				ext: 'lnk',
				mime: 'application/x.ms.shortcut', // Invented by us
			};
		}

		if (this.check([0x62, 0x6F, 0x6F, 0x6B, 0x00, 0x00, 0x00, 0x00, 0x6D, 0x61, 0x72, 0x6B, 0x00, 0x00, 0x00, 0x00])) {
			return {
				ext: 'alias',
				mime: 'application/x.apple.alias', // Invented by us
			};
		}

		if (this.checkString('Kaydara FBX Binary  \u0000')) {
			return {
				ext: 'fbx',
				mime: 'application/x.autodesk.fbx', // Invented by us
			};
		}

		if (
			this.check([0x4C, 0x50], {offset: 34})
			&& (
				this.check([0x00, 0x00, 0x01], {offset: 8})
				|| this.check([0x01, 0x00, 0x02], {offset: 8})
				|| this.check([0x02, 0x00, 0x02], {offset: 8})
			)
		) {
			return {
				ext: 'eot',
				mime: 'application/vnd.ms-fontobject',
			};
		}

		if (this.check([0x06, 0x06, 0xED, 0xF5, 0xD8, 0x1D, 0x46, 0xE5, 0xBD, 0x31, 0xEF, 0xE7, 0xFE, 0x74, 0xB7, 0x1D])) {
			return {
				ext: 'indd',
				mime: 'application/x-indesign',
			};
		}

		// Increase sample size from 256 to 512
		await tokenizer.peekBuffer(this.buffer, {length: Math.min(512, tokenizer.fileInfo.size), mayBeLess: true});

		// Requires a buffer size of 512 bytes
		if ((this.checkString('ustar', {offset: 257}) && (this.checkString('\0', {offset: 262}) || this.checkString(' ', {offset: 262})))
			|| (this.check([0, 0, 0, 0, 0, 0], {offset: 257}) && tarHeaderChecksumMatches(this.buffer))) {
			return {
				ext: 'tar',
				mime: 'application/x-tar',
			};
		}

		if (this.check([0xFF, 0xFE])) { // UTF-16-BOM-LE
			const encoding = 'utf-16le';
			if (this.checkString('<?xml ', {offset: 2, encoding})) {
				return {
					ext: 'xml',
					mime: 'application/xml',
				};
			}

			if (this.check([0xFF, 0x0E], {offset: 2}) && this.checkString('SketchUp Model', {offset: 4, encoding})) {
				return {
					ext: 'skp',
					mime: 'application/vnd.sketchup.skp',
				};
			}

			if (this.checkString('Windows Registry Editor Version 5.00\r\n', {offset: 2, encoding})) {
				return {
					ext: 'reg',
					mime: 'application/x-ms-regedit',
				};
			}

			return undefined; // Some text based format
		}

		if (this.checkString('-----BEGIN PGP MESSAGE-----')) {
			return {
				ext: 'pgp',
				mime: 'application/pgp-encrypted',
			};
		}
	};
	// Detections with limited supporting data, resulting in a higher likelihood of false positives
	detectImprecise = async tokenizer => {
		this.buffer = new Uint8Array(reasonableDetectionSizeInBytes);

		// Read initial sample size of 8 bytes
		await tokenizer.peekBuffer(this.buffer, {length: Math.min(8, tokenizer.fileInfo.size), mayBeLess: true});

		if (
			this.check([0x0, 0x0, 0x1, 0xBA])
			|| this.check([0x0, 0x0, 0x1, 0xB3])
		) {
			return {
				ext: 'mpg',
				mime: 'video/mpeg',
			};
		}

		if (this.check([0x00, 0x01, 0x00, 0x00, 0x00])) {
			return {
				ext: 'ttf',
				mime: 'font/ttf',
			};
		}

		if (this.check([0x00, 0x00, 0x01, 0x00])) {
			return {
				ext: 'ico',
				mime: 'image/x-icon',
			};
		}

		if (this.check([0x00, 0x00, 0x02, 0x00])) {
			return {
				ext: 'cur',
				mime: 'image/x-icon',
			};
		}

		// Adjust buffer to `mpegOffsetTolerance`
		await tokenizer.peekBuffer(this.buffer, {length: Math.min(2 + this.options.mpegOffsetTolerance, tokenizer.fileInfo.size), mayBeLess: true});

		// Check MPEG 1 or 2 Layer 3 header, or 'layer 0' for ADTS (MPEG sync-word 0xFFE)
		if (this.buffer.length >= (2 + this.options.mpegOffsetTolerance)) {
			for (let depth = 0; depth <= this.options.mpegOffsetTolerance; ++depth) {
				const type = this.scanMpeg(depth);
				if (type) {
					return type;
				}
			}
		}
	};

	async readTiffTag(bigEndian) {
		const tagId = await this.tokenizer.readToken(bigEndian ? UINT16_BE : UINT16_LE);
		this.tokenizer.ignore(10);
		switch (tagId) {
			case 50_341:
				return {
					ext: 'arw',
					mime: 'image/x-sony-arw',
				};
			case 50_706:
				return {
					ext: 'dng',
					mime: 'image/x-adobe-dng',
				};
		}
	}

	async readTiffIFD(bigEndian) {
		const numberOfTags = await this.tokenizer.readToken(bigEndian ? UINT16_BE : UINT16_LE);
		for (let n = 0; n < numberOfTags; ++n) {
			const fileType = await this.readTiffTag(bigEndian);
			if (fileType) {
				return fileType;
			}
		}
	}

	async readTiffHeader(bigEndian) {
		const version = (bigEndian ? UINT16_BE : UINT16_LE).get(this.buffer, 2);
		const ifdOffset = (bigEndian ? UINT32_BE : UINT32_LE).get(this.buffer, 4);

		if (version === 42) {
			// TIFF file header
			if (ifdOffset >= 6) {
				if (this.checkString('CR', {offset: 8})) {
					return {
						ext: 'cr2',
						mime: 'image/x-canon-cr2',
					};
				}

				if (ifdOffset >= 8) {
					const someId1 = (bigEndian ? UINT16_BE : UINT16_LE).get(this.buffer, 8);
					const someId2 = (bigEndian ? UINT16_BE : UINT16_LE).get(this.buffer, 10);

					if (
						(someId1 === 0x1C && someId2 === 0xFE)
						|| (someId1 === 0x1F && someId2 === 0x0B)) {
						return {
							ext: 'nef',
							mime: 'image/x-nikon-nef',
						};
					}
				}
			}

			await this.tokenizer.ignore(ifdOffset);
			const fileType = await this.readTiffIFD(bigEndian);
			return fileType ?? {
				ext: 'tif',
				mime: 'image/tiff',
			};
		}

		if (version === 43) {	// Big TIFF file header
			return {
				ext: 'tif',
				mime: 'image/tiff',
			};
		}
	}

	/**
	Scan check MPEG 1 or 2 Layer 3 header, or 'layer 0' for ADTS (MPEG sync-word 0xFFE).

	@param offset - Offset to scan for sync-preamble.
	@returns {{ext: string, mime: string}}
	*/
	scanMpeg(offset) {
		if (this.check([0xFF, 0xE0], {offset, mask: [0xFF, 0xE0]})) {
			if (this.check([0x10], {offset: offset + 1, mask: [0x16]})) {
				// Check for (ADTS) MPEG-2
				if (this.check([0x08], {offset: offset + 1, mask: [0x08]})) {
					return {
						ext: 'aac',
						mime: 'audio/aac',
					};
				}

				// Must be (ADTS) MPEG-4
				return {
					ext: 'aac',
					mime: 'audio/aac',
				};
			}

			// MPEG 1 or 2 Layer 3 header
			// Check for MPEG layer 3
			if (this.check([0x02], {offset: offset + 1, mask: [0x06]})) {
				return {
					ext: 'mp3',
					mime: 'audio/mpeg',
				};
			}

			// Check for MPEG layer 2
			if (this.check([0x04], {offset: offset + 1, mask: [0x06]})) {
				return {
					ext: 'mp2',
					mime: 'audio/mpeg',
				};
			}

			// Check for MPEG layer 1
			if (this.check([0x06], {offset: offset + 1, mask: [0x06]})) {
				return {
					ext: 'mp1',
					mime: 'audio/mpeg',
				};
			}
		}
	}
};

new Set(extensions);
new Set(mimeTypes$1);

/**
Node.js specific entry point.
*/


class FileTypeParser extends FileTypeParser$1 {
	async fromStream(stream) {
		const tokenizer = await (stream instanceof ReadableStream$1 ? fromWebStream(stream, this.tokenizerOptions) : fromStream(stream, this.tokenizerOptions));
		try {
			return await super.fromTokenizer(tokenizer);
		} finally {
			await tokenizer.close();
		}
	}

	async fromFile(path) {
		const tokenizer = await fromFile(path);
		try {
			return await super.fromTokenizer(tokenizer);
		} finally {
			await tokenizer.close();
		}
	}

	async toDetectionStream(readableStream, options = {}) {
		if (!(readableStream instanceof Readable)) {
			return super.toDetectionStream(readableStream, options);
		}

		const {sampleSize = reasonableDetectionSizeInBytes} = options;

		return new Promise((resolve, reject) => {
			readableStream.on('error', reject);

			readableStream.once('readable', () => {
				(async () => {
					try {
						// Set up output stream
						const pass = new PassThrough();
						const outputStream = pipeline ? pipeline(readableStream, pass, () => {}) : readableStream.pipe(pass);

						// Read the input stream and detect the filetype
						const chunk = readableStream.read(sampleSize) ?? readableStream.read() ?? new Uint8Array(0);
						try {
							pass.fileType = await this.fromBuffer(chunk);
						} catch (error) {
							if (error instanceof EndOfStreamError) {
								pass.fileType = undefined;
							} else {
								reject(error);
							}
						}

						resolve(outputStream);
					} catch (error) {
						reject(error);
					}
				})();
			});
		});
	}
}

async function fileTypeFromFile(path, options) {
	return (new FileTypeParser(options)).fromFile(path, options);
}

class RequestUtil {
  // 适用于获取服务器下发cookies时获取，仅GET
  static async HttpsGetCookies(url) {
    const client = url.startsWith("https") ? https$1 : http;
    return new Promise((resolve, reject) => {
      const req = client.get(url, (res) => {
        const cookies = {};
        res.on("data", () => {
        });
        res.on("end", () => {
          this.handleRedirect(res, url, cookies).then(resolve).catch(reject);
        });
        if (res.headers["set-cookie"]) {
          this.extractCookies(res.headers["set-cookie"], cookies);
        }
      });
      req.on("error", (error) => {
        reject(error);
      });
    });
  }
  static async handleRedirect(res, url, cookies) {
    if (res.statusCode === 301 || res.statusCode === 302) {
      if (res.headers.location) {
        const redirectUrl = new URL(res.headers.location, url);
        const redirectCookies = await this.HttpsGetCookies(redirectUrl.href);
        return { ...cookies, ...redirectCookies };
      }
    }
    return cookies;
  }
  static extractCookies(setCookieHeaders, cookies) {
    setCookieHeaders.forEach((cookie) => {
      const parts = cookie.split(";")[0]?.split("=");
      if (parts) {
        const key = parts[0];
        const value = parts[1];
        if (key && value && key.length > 0 && value.length > 0) {
          cookies[key] = value;
        }
      }
    });
  }
  // 请求和回复都是JSON data传原始内容 自动编码json
  static async HttpGetJson(url, method = "GET", data, headers = {}, isJsonRet = true, isArgJson = true) {
    const option = new URL(url);
    const protocol = url.startsWith("https://") ? https$1 : http;
    const options = {
      hostname: option.hostname,
      port: option.port,
      path: option.pathname + option.search,
      method,
      headers
    };
    return new Promise((resolve, reject) => {
      const req = protocol.request(options, (res) => {
        let responseBody = "";
        res.on("data", (chunk) => {
          responseBody += chunk.toString();
        });
        res.on("end", () => {
          try {
            if (res.statusCode && res.statusCode >= 200 && res.statusCode < 300) {
              if (isJsonRet) {
                const responseJson = JSON.parse(responseBody);
                resolve(responseJson);
              } else {
                resolve(responseBody);
              }
            } else {
              reject(new Error(`Unexpected status code: ${res.statusCode}`));
            }
          } catch (parseError) {
            reject(new Error(parseError.message));
          }
        });
      });
      req.on("error", (error) => {
        reject(error);
      });
      if (method === "POST" || method === "PUT" || method === "PATCH") {
        if (isArgJson) {
          req.write(JSON.stringify(data));
        } else {
          req.write(data);
        }
      }
      req.end();
    });
  }
  // 请求返回都是原始内容
  static async HttpGetText(url, method = "GET", data, headers = {}) {
    return this.HttpGetJson(url, method, data, headers, false, false);
  }
}

class RkeyManager {
  serverUrl = [];
  logger;
  rkeyData = {
    group_rkey: "",
    private_rkey: "",
    expired_time: 0
  };
  urlFailures = /* @__PURE__ */ new Map();
  FAILURE_LIMIT = 4;
  ONE_DAY = 24 * 60 * 60 * 1e3;
  constructor(serverUrl, logger) {
    this.logger = logger;
    this.serverUrl = serverUrl;
  }
  async getRkey() {
    const availableUrls = this.getAvailableUrls();
    if (availableUrls.length === 0) {
      this.logger.logError("[Rkey] 所有服务均已禁用, 图片使用FallBack机制");
      throw new Error("获取rkey失败：所有服务URL均已被禁用");
    }
    if (this.isExpired()) {
      try {
        await this.refreshRkey();
      } catch (e) {
        throw new Error(`${e}`);
      }
    }
    return this.rkeyData;
  }
  getAvailableUrls() {
    return this.serverUrl.filter((url) => !this.isUrlDisabled(url));
  }
  isUrlDisabled(url) {
    const failureInfo = this.urlFailures.get(url);
    if (!failureInfo) return false;
    const now = (/* @__PURE__ */ new Date()).getTime();
    if (now - failureInfo.lastTimestamp > this.ONE_DAY) {
      failureInfo.count = 0;
      this.urlFailures.set(url, failureInfo);
      return false;
    }
    return failureInfo.count >= this.FAILURE_LIMIT;
  }
  updateUrlFailure(url) {
    const now = (/* @__PURE__ */ new Date()).getTime();
    const failureInfo = this.urlFailures.get(url) || { count: 0, lastTimestamp: 0 };
    if (now - failureInfo.lastTimestamp > this.ONE_DAY) {
      failureInfo.count = 1;
    } else {
      failureInfo.count++;
    }
    failureInfo.lastTimestamp = now;
    this.urlFailures.set(url, failureInfo);
    if (failureInfo.count >= this.FAILURE_LIMIT) {
      this.logger.logError(`[Rkey] URL ${url} 已被禁用，失败次数达到 ${this.FAILURE_LIMIT} 次`);
    }
  }
  isExpired() {
    const now = (/* @__PURE__ */ new Date()).getTime() / 1e3;
    return now > this.rkeyData.expired_time;
  }
  async refreshRkey() {
    const availableUrls = this.getAvailableUrls();
    if (availableUrls.length === 0) {
      this.logger.logError("[Rkey] 所有服务均已禁用");
      throw new Error("获取rkey失败：所有服务URL均已被禁用");
    }
    for (const url of availableUrls) {
      try {
        let temp = await RequestUtil.HttpGetJson(url, "GET");
        if ("retcode" in temp) {
          temp = temp.data;
        }
        this.rkeyData = {
          group_rkey: temp.group_rkey.slice(6),
          private_rkey: temp.private_rkey.slice(6),
          expired_time: temp.expired_time
        };
        return;
      } catch (e) {
        this.logger.logError(`[Rkey] 异常服务 ${url} 异常 / `, e);
        this.updateUrlFailure(url);
        if (url === availableUrls[availableUrls.length - 1]) {
          throw new Error(`获取rkey失败: ${e}`);
        }
      }
    }
  }
}

async function solveProblem(func, ...args) {
  return new Promise((resolve) => {
    try {
      const result = func(...args);
      resolve(result);
    } catch {
      resolve(void 0);
    }
  });
}
async function solveAsyncProblem(func, ...args) {
  return new Promise((resolve) => {
    func(...args).then((result) => {
      resolve(result);
    }).catch(() => {
      resolve(void 0);
    });
  });
}
function sleep(ms) {
  return new Promise((resolve) => setTimeout(resolve, ms));
}
function PromiseTimer(promise, ms) {
  const timeoutPromise = new Promise(
    (_resolve, reject) => setTimeout(() => reject(new Error("PromiseTimer: Operation timed out")), ms)
  );
  return Promise.race([promise, timeoutPromise]);
}
function isNull(value) {
  return value === void 0 || value === null;
}
function isNumeric(str) {
  return /^\d+$/.test(str);
}
function truncateString(obj, maxLength = 500) {
  if (obj !== null && typeof obj === "object") {
    Object.keys(obj).forEach((key) => {
      if (typeof obj[key] === "string") {
        if (obj[key].length > maxLength) {
          obj[key] = obj[key].substring(0, maxLength) + "...";
        }
      } else if (typeof obj[key] === "object") {
        truncateString(obj[key], maxLength);
      }
    });
  }
  return obj;
}
function getDefaultQQVersionConfigInfo() {
  if (os$1.platform() === "linux") {
    return {
      baseVersion: "3.2.12.28060",
      curVersion: "3.2.12.28060",
      prevVersion: "",
      onErrorVersions: [],
      buildId: "27254"
    };
  }
  if (os$1.platform() === "darwin") {
    return {
      baseVersion: "6.9.53.28060",
      curVersion: "6.9.53.28060",
      prevVersion: "",
      onErrorVersions: [],
      buildId: "28060"
    };
  }
  return {
    baseVersion: "9.9.15-28131",
    curVersion: "9.9.15-28131",
    prevVersion: "",
    onErrorVersions: [],
    buildId: "28131"
  };
}
function getQQPackageInfoPath(exePath = "", version) {
  if (process.env["NAPCAT_QQ_PACKAGE_INFO_PATH"]) {
    return process.env["NAPCAT_QQ_PACKAGE_INFO_PATH"];
  }
  let packagePath;
  if (os$1.platform() === "darwin") {
    packagePath = path$1.join(path$1.dirname(exePath), "..", "Resources", "app", "package.json");
  } else if (os$1.platform() === "linux") {
    packagePath = path$1.join(path$1.dirname(exePath), "./resources/app/package.json");
  } else {
    packagePath = path$1.join(path$1.dirname(exePath), "./versions/" + version + "/resources/app/package.json");
  }
  if (!fs__default.existsSync(packagePath)) {
    packagePath = path$1.join(path$1.dirname(exePath), "./resources/app/versions/" + version + "/package.json");
  }
  return packagePath;
}
function getQQVersionConfigPath(exePath = "") {
  if (process.env["NAPCAT_QQ_VERSION_CONFIG_PATH"]) {
    return process.env["NAPCAT_QQ_VERSION_CONFIG_PATH"];
  }
  let configVersionInfoPath;
  if (os$1.platform() === "win32") {
    configVersionInfoPath = path$1.join(path$1.dirname(exePath), "versions", "config.json");
  } else if (os$1.platform() === "darwin") {
    const userPath = os$1.homedir();
    const appDataPath = path$1.resolve(userPath, "./Library/Application Support/QQ");
    configVersionInfoPath = path$1.resolve(appDataPath, "./versions/config.json");
  } else {
    const userPath = os$1.homedir();
    const appDataPath = path$1.resolve(userPath, "./.config/QQ");
    configVersionInfoPath = path$1.resolve(appDataPath, "./versions/config.json");
  }
  if (typeof configVersionInfoPath !== "string") {
    return void 0;
  }
  if (!fs__default.existsSync(configVersionInfoPath)) {
    configVersionInfoPath = path$1.join(path$1.dirname(exePath), "./resources/app/versions/config.json");
  }
  if (!fs__default.existsSync(configVersionInfoPath)) {
    return void 0;
  }
  return configVersionInfoPath;
}
function calcQQLevel(level) {
  if (!level) return 0;
  const { crownNum, sunNum, moonNum, starNum } = level;
  return crownNum * 64 + sunNum * 16 + moonNum * 4 + starNum;
}
function stringifyWithBigInt(obj) {
  return JSON.stringify(
    obj,
    (_key, value) => typeof value === "bigint" ? value.toString() : value
  );
}
function parseAppidFromMajor(nodeMajor) {
  const hexSequence = "A4 09 00 00 00 35";
  const sequenceBytes = Buffer.from(hexSequence.replace(/ /g, ""), "hex");
  const filePath = path$1.resolve(nodeMajor);
  const fileContent = fs__default.readFileSync(filePath);
  let searchPosition = 0;
  while (true) {
    const index = fileContent.indexOf(sequenceBytes, searchPosition);
    if (index === -1) {
      break;
    }
    const start = index + sequenceBytes.length - 1;
    const end = fileContent.indexOf(0, start);
    if (end === -1) {
      break;
    }
    const content = fileContent.subarray(start, end);
    if (!content.every((byte) => byte === 0)) {
      try {
        return content.toString("utf-8");
      } catch {
        break;
      }
    }
    searchPosition = end + 1;
  }
  return void 0;
}
const baseUrl = "https://github.com/NapNeko/NapCatQQ.git/info/refs?service=git-upload-pack";
const urls$1 = [
  "https://j.1win.ggff.net/" + baseUrl,
  "https://git.yylx.win/" + baseUrl,
  "https://ghfile.geekertao.top/" + baseUrl,
  "https://gh-proxy.net/" + baseUrl,
  "https://ghm.078465.xyz/" + baseUrl,
  "https://gitproxy.127731.xyz/" + baseUrl,
  "https://jiashu.1win.eu.org/" + baseUrl,
  baseUrl
];
async function testUrl$2(url) {
  try {
    await PromiseTimer(RequestUtil.HttpGetText(url), 5e3);
    return true;
  } catch {
    return false;
  }
}
async function findAvailableUrl$2() {
  for (const url of urls$1) {
    if (await testUrl$2(url)) {
      return url;
    }
  }
  return null;
}
async function getAllTags() {
  const availableUrl = await findAvailableUrl$2();
  if (!availableUrl) {
    throw new Error("No available URL for fetching tags");
  }
  const raw = await RequestUtil.HttpGetText(availableUrl);
  return raw.split("\n").map((line) => {
    const match = line.match(/refs\/tags\/(.+)$/);
    return match ? match[1] : null;
  }).filter((tag) => tag !== null && !tag.endsWith("^{}"));
}
async function getLatestTag() {
  const tags = await getAllTags();
  tags.sort((a, b) => compareVersion(a, b));
  const latest = tags.at(-1);
  if (!latest) {
    throw new Error("No tags found");
  }
  return latest.replace(/^v/, "");
}
function compareVersion(a, b) {
  const normalize = (v) => v.replace(/^v/, "").split(".").map((n) => parseInt(n) || 0);
  const pa = normalize(a);
  const pb = normalize(b);
  const len = Math.max(pa.length, pb.length);
  for (let i = 0; i < len; i++) {
    const na = pa[i] || 0;
    const nb = pb[i] || 0;
    if (na !== nb) return na - nb;
  }
  return 0;
}

function checkFileExist(path2, timeout = 3e3) {
  return new Promise((resolve, reject) => {
    const startTime = Date.now();
    function check() {
      if (fs__default.existsSync(path2)) {
        resolve();
      } else if (Date.now() - startTime > timeout) {
        reject(new Error(`文件不存在: ${path2}`));
      } else {
        setTimeout(check, 100);
      }
    }
    check();
  });
}
async function checkFileExistV2(path2, timeout = 3e3) {
  await Promise.race([
    checkFile(path2),
    timeoutPromise(timeout, `文件不存在: ${path2}`)
  ]);
}
function timeoutPromise(timeout, errorMsg) {
  return new Promise((_resolve, reject) => {
    setTimeout(() => {
      reject(new Error(errorMsg));
    }, timeout);
  });
}
async function checkFile(path2) {
  try {
    await stat$1(path2);
  } catch (error) {
    if (error.code === "ENOENT") {
      throw new Error(`文件不存在: ${path2}`);
    } else {
      throw error;
    }
  }
}
function calculateFileMD5(filePath) {
  return new Promise((resolve, reject) => {
    const stream = fs__default.createReadStream(filePath);
    const hash = crypto__default.createHash("md5");
    stream.on("data", (data) => {
      hash.update(data);
    });
    stream.on("end", () => {
      const md5 = hash.digest("hex");
      resolve(md5);
    });
    stream.on("error", (err) => {
      reject(err);
    });
  });
}
async function tryDownload(options, useReferer = false) {
  let url;
  let headers = {
    "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/94.0.4606.71 Safari/537.36"
  };
  if (typeof options === "string") {
    url = options;
    headers["Host"] = new URL(url).hostname;
  } else {
    url = options.url;
    if (options.headers) {
      if (typeof options.headers === "string") {
        headers = JSON.parse(options.headers);
      } else {
        headers = options.headers;
      }
    }
  }
  if (useReferer && !headers["Referer"]) {
    headers["Referer"] = url;
  }
  const fetchRes = await fetch(url, { headers, redirect: "follow" }).catch((err) => {
    if (err.cause) {
      throw err.cause;
    }
    throw err;
  });
  return fetchRes;
}
async function httpDownload(options) {
  const useReferer = typeof options === "string";
  let resp = await tryDownload(options);
  if (resp.status === 403 && useReferer) {
    resp = await tryDownload(options, true);
  }
  if (!resp.ok) throw new Error(`下载文件失败: ${resp.statusText}`);
  const blob = await resp.blob();
  const buffer = await blob.arrayBuffer();
  return Buffer.from(buffer);
}
async function checkUriType(Uri) {
  const LocalFileRet = await solveProblem((uri) => {
    if (fs__default.existsSync(path$1.normalize(uri))) {
      return { Uri: path$1.normalize(uri), Type: 1 /* Local */ };
    }
    return void 0;
  }, Uri);
  if (LocalFileRet) return LocalFileRet;
  const OtherFileRet = await solveProblem((uri) => {
    if (uri.startsWith("http:") || uri.startsWith("https:")) {
      return { Uri: uri, Type: 2 /* Remote */ };
    }
    if (uri.startsWith("base64:")) {
      return { Uri: uri, Type: 3 /* Base64 */ };
    }
    if (uri.startsWith("file:")) {
      const filePath = decodeURIComponent(uri.startsWith("file:///") && process.platform === "win32" ? uri.slice(8) : uri.slice(7));
      return { Uri: filePath, Type: 1 /* Local */ };
    }
    if (uri.startsWith("data:")) {
      const data = uri.split(",")[1];
      if (data) return { Uri: data, Type: 3 /* Base64 */ };
    }
    return void 0;
  }, Uri);
  if (OtherFileRet) return OtherFileRet;
  return { Uri, Type: 0 /* Unknown */ };
}
async function uriToLocalFile(dir, uri, filename = randomUUID(), headers) {
  const { Uri: HandledUri, Type: UriType } = await checkUriType(uri);
  const filePath = path$1.join(dir, filename);
  switch (UriType) {
    case 1 /* Local */: {
      const fileExt = path$1.extname(HandledUri);
      const localFileName = path$1.basename(HandledUri, fileExt) + fileExt;
      const tempFilePath = path$1.join(dir, filename + fileExt);
      fs__default.copyFileSync(HandledUri, tempFilePath);
      return { success: true, errMsg: "", fileName: localFileName, path: tempFilePath };
    }
    case 2 /* Remote */: {
      const buffer = await httpDownload({ url: HandledUri, headers: headers ?? {} });
      fs__default.writeFileSync(filePath, buffer);
      return { success: true, errMsg: "", fileName: filename, path: filePath };
    }
    case 3 /* Base64 */: {
      const base64 = HandledUri.replace(/^base64:\/\//, "");
      const base64Buffer = Buffer.from(base64, "base64");
      fs__default.writeFileSync(filePath, base64Buffer);
      return { success: true, errMsg: "", fileName: filename, path: filePath };
    }
    default:
      return { success: false, errMsg: `识别URL失败, uri= ${uri}`, fileName: "", path: "" };
  }
}

const FileId = {
  appid: ProtoField(4, ScalarType.UINT32, true),
  ttl: ProtoField(10, ScalarType.UINT32, true)
};

class NTQQFileApi {
  context;
  core;
  rkeyManager;
  packetRkey;
  fetchRkeyFailures = 0;
  MAX_RKEY_FAILURES = 8;
  constructor(context, core) {
    this.context = context;
    this.core = core;
    this.rkeyManager = new RkeyManager(
      [
        "http://ss.xingzhige.com/music_card/rkey",
        "https://secret-service.bietiaop.com/rkeys"
      ],
      this.context.logger
    );
  }
  async fetchRkeyWithRetry() {
    if (this.fetchRkeyFailures >= this.MAX_RKEY_FAILURES) {
      throw new Error("Native.FetchRkey 已被禁用");
    }
    try {
      const ret = await this.core.apis.PacketApi.pkt.operation.FetchRkey();
      this.fetchRkeyFailures = 0;
      return ret;
    } catch (error) {
      this.fetchRkeyFailures++;
      this.context.logger.logError("FetchRkey 失败", error.message);
      throw error;
    }
  }
  async getFileUrl(chatType, peer, fileUUID, file10MMd5, timeout = 5e3) {
    if (this.core.apis.PacketApi.packetStatus) {
      try {
        if (chatType === ChatType.KCHATTYPEGROUP && fileUUID) {
          return this.core.apis.PacketApi.pkt.operation.GetGroupFileUrl(+peer, fileUUID, timeout);
        } else if (file10MMd5 && fileUUID) {
          return this.core.apis.PacketApi.pkt.operation.GetPrivateFileUrl(peer, fileUUID, file10MMd5, timeout);
        }
      } catch (error) {
        this.context.logger.logError("获取文件URL失败", error.message);
      }
    }
    throw new Error("fileUUID or file10MMd5 is undefined");
  }
  async getPttUrl(peer, fileUUID, timeout = 5e3) {
    if (this.core.apis.PacketApi.packetStatus && fileUUID) {
      const appid = new NapProtoMsg(FileId).decode(Buffer.from(fileUUID.replaceAll("-", "+").replaceAll("_", "/"), "base64")).appid;
      try {
        if (appid && appid === 1403) {
          return this.core.apis.PacketApi.pkt.operation.GetGroupPttUrl(+peer, {
            fileUuid: fileUUID,
            storeId: 1,
            uploadTime: 0,
            ttl: 0,
            subType: 0
          }, timeout);
        } else if (fileUUID) {
          return this.core.apis.PacketApi.pkt.operation.GetPttUrl(peer, {
            fileUuid: fileUUID,
            storeId: 1,
            uploadTime: 0,
            ttl: 0,
            subType: 0
          }, timeout);
        }
      } catch (error) {
        this.context.logger.logError("获取文件URL失败", error.message);
      }
    }
    throw new Error("packet cant get ptt url");
  }
  async getVideoUrlPacket(peer, fileUUID, timeout = 5e3) {
    if (this.core.apis.PacketApi.packetStatus && fileUUID) {
      const appid = new NapProtoMsg(FileId).decode(Buffer.from(fileUUID.replaceAll("-", "+").replaceAll("_", "/"), "base64")).appid;
      try {
        if (appid && appid === 1415) {
          return this.core.apis.PacketApi.pkt.operation.GetGroupVideoUrl(+peer, {
            fileUuid: fileUUID,
            storeId: 1,
            uploadTime: 0,
            ttl: 0,
            subType: 0
          }, timeout);
        } else if (fileUUID) {
          return this.core.apis.PacketApi.pkt.operation.GetVideoUrl(peer, {
            fileUuid: fileUUID,
            storeId: 1,
            uploadTime: 0,
            ttl: 0,
            subType: 0
          }, timeout);
        }
      } catch (error) {
        this.context.logger.logError("获取文件URL失败", error.message);
      }
    }
    throw new Error("packet cant get video url");
  }
  async copyFile(filePath, destPath) {
    await this.core.util.copyFile(filePath, destPath);
  }
  async getFileSize(filePath) {
    return await this.core.util.getFileSize(filePath);
  }
  async getVideoUrl(peer, msgId, elementId) {
    return (await this.context.session.getRichMediaService().getVideoPlayUrlV2(peer, msgId, elementId, 0, {
      downSourceType: 1,
      triggerType: 1
    })).urlResult.domainUrl;
  }
  async uploadFile(filePath, elementType = ElementType.PIC, elementSubType = 0) {
    const fileMd5 = await calculateFileMD5(filePath);
    const extOrEmpty = await fileTypeFromFile(filePath).then((e) => e?.ext ?? "").catch(() => "");
    const ext = extOrEmpty ? `.${extOrEmpty}` : "";
    let fileName = `${path__default.basename(filePath)}`;
    if (fileName.indexOf(".") === -1) {
      fileName += ext;
    }
    const mediaPath = this.context.session.getMsgService().getRichMediaFilePathForGuild({
      md5HexStr: fileMd5,
      fileName,
      elementType,
      elementSubType,
      thumbSize: 0,
      needCreate: true,
      downloadType: 1,
      file_uuid: ""
    });
    await this.copyFile(filePath, mediaPath);
    const fileSize = await this.getFileSize(filePath);
    return {
      md5: fileMd5,
      fileName,
      path: mediaPath,
      fileSize,
      ext
    };
  }
  async downloadFileForModelId(peer, modelId, unknown, timeout = 1e3 * 60 * 2) {
    const [, fileTransNotifyInfo] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelRichMediaService/downloadFileForModelId",
      "NodeIKernelMsgListener/onRichMediaDownloadComplete",
      [peer, [modelId], unknown],
      () => true,
      (arg) => arg?.commonFileInfo?.fileModelId === modelId,
      1,
      timeout
    );
    return fileTransNotifyInfo.filePath;
  }
  async downloadRawMsgMedia(msg) {
    const res = await Promise.all(
      msg.map(
        (m) => Promise.all(
          m.elements.filter(
            (element) => element.elementType === ElementType.PIC || element.elementType === ElementType.VIDEO || element.elementType === ElementType.PTT || element.elementType === ElementType.FILE
          ).map(
            (element) => this.downloadMedia(m.msgId, m.chatType, m.peerUid, element.elementId, "", "", 1e3 * 60 * 2, true)
          )
        )
      )
    );
    msg.forEach((m, msgIndex) => {
      const elementResults = res[msgIndex];
      let elementIndex = 0;
      m.elements.forEach((element) => {
        if (element.elementType === ElementType.PIC || element.elementType === ElementType.VIDEO || element.elementType === ElementType.PTT || element.elementType === ElementType.FILE) {
          switch (element.elementType) {
            case ElementType.PIC:
              element.picElement.sourcePath = elementResults?.[elementIndex] ?? "";
              break;
            case ElementType.VIDEO:
              element.videoElement.filePath = elementResults?.[elementIndex] ?? "";
              break;
            case ElementType.PTT:
              element.pttElement.filePath = elementResults?.[elementIndex] ?? "";
              break;
            case ElementType.FILE:
              element.fileElement.filePath = elementResults?.[elementIndex] ?? "";
              break;
          }
          elementIndex++;
        }
      });
    });
    return res.flat();
  }
  async downloadMedia(msgId, chatType, peerUid, elementId, thumbPath, sourcePath, timeout = 1e3 * 60 * 2, force = false) {
    if (sourcePath && fs__default.existsSync(sourcePath)) {
      if (force) {
        try {
          await fsProm.unlink(sourcePath);
        } catch {
        }
      } else {
        return sourcePath;
      }
    }
    const [, completeRetData] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelMsgService/downloadRichMedia",
      "NodeIKernelMsgListener/onRichMediaDownloadComplete",
      [{
        fileModelId: "0",
        downSourceType: 0,
        downloadSourceType: 0,
        triggerType: 1,
        msgId,
        chatType,
        peerUid,
        elementId,
        thumbSize: 0,
        downloadType: 1,
        filePath: thumbPath
      }],
      () => true,
      (arg) => arg.msgElementId === elementId && arg.msgId === msgId,
      1,
      timeout
    );
    return completeRetData.filePath;
  }
  async searchForFile(keys) {
    const randomResultId = 1e5 + Math.floor(Math.random() * 1e4);
    let searchId = 0;
    const [, searchResult] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelFileAssistantService/searchFile",
      "NodeIKernelFileAssistantListener/onFileSearch",
      [
        keys,
        { resultType: 2, pageLimit: 1 },
        randomResultId
      ],
      (ret) => {
        searchId = ret;
        return true;
      },
      (result) => result.searchId === searchId && result.resultId === randomResultId
    );
    return searchResult.resultItems[0];
  }
  async downloadFileById(fileId, fileSize = 1024576, estimatedTime = fileSize * 1e3 / 1024576 + 5e3) {
    const [, fileData] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelFileAssistantService/downloadFile",
      "NodeIKernelFileAssistantListener/onFileStatusChanged",
      [[fileId]],
      (ret) => ret.result === 0,
      (status) => status.fileStatus === 2 && status.fileProgress === "0",
      1,
      estimatedTime
      // estimate 1MB/s
    );
    return fileData.filePath;
  }
  async getImageUrl(element) {
    if (!element) {
      return "";
    }
    const url = element.originImageUrl ?? "";
    const md5HexStr = element.md5HexStr;
    const fileMd5 = element.md5HexStr;
    const parsedUrl = new URL(IMAGE_HTTP_HOST + url);
    const imageAppid = parsedUrl.searchParams.get("appid");
    const isNTV2 = imageAppid && ["1406", "1407"].includes(imageAppid);
    const imageFileId = parsedUrl.searchParams.get("fileid");
    if (url && isNTV2 && imageFileId) {
      const rkeyData = await this.getRkeyData();
      return this.getImageUrlFromParsedUrl(imageFileId, imageAppid, rkeyData);
    }
    return this.getImageUrlFromMd5(fileMd5, md5HexStr);
  }
  async getRkeyData() {
    const rkeyData = {
      private_rkey: "CAQSKAB6JWENi5LM_xp9vumLbuThJSaYf-yzMrbZsuq7Uz2qEc3Rbib9LP4",
      group_rkey: "CAQSKAB6JWENi5LM_xp9vumLbuThJSaYf-yzMrbZsuq7Uz2qffcqm614gds",
      online_rkey: false
    };
    try {
      if (this.core.apis.PacketApi.packetStatus) {
        const rkey_expired_private = !this.packetRkey || this.packetRkey[0] && this.packetRkey[0].time + Number(this.packetRkey[0].ttl) < Date.now() / 1e3;
        const rkey_expired_group = !this.packetRkey || this.packetRkey[0] && this.packetRkey[0].time + Number(this.packetRkey[0].ttl) < Date.now() / 1e3;
        if (rkey_expired_private || rkey_expired_group) {
          this.packetRkey = await this.fetchRkeyWithRetry();
        }
        if (this.packetRkey && this.packetRkey.length > 0) {
          rkeyData.group_rkey = this.packetRkey[1]?.rkey.slice(6) ?? "";
          rkeyData.private_rkey = this.packetRkey[0]?.rkey.slice(6) ?? "";
          rkeyData.online_rkey = true;
        }
      }
    } catch (error) {
      this.context.logger.logDebug("获取native.rkey失败", error.message);
    }
    if (!rkeyData.online_rkey) {
      try {
        const tempRkeyData = await this.rkeyManager.getRkey();
        rkeyData.group_rkey = tempRkeyData.group_rkey;
        rkeyData.private_rkey = tempRkeyData.private_rkey;
        rkeyData.online_rkey = tempRkeyData.expired_time > Date.now() / 1e3;
      } catch (error) {
        this.context.logger.logDebug("获取remote.rkey失败", error.message);
      }
    }
    return rkeyData;
  }
  getImageUrlFromParsedUrl(imageFileId, appid, rkeyData) {
    const rkey = appid === "1406" ? rkeyData.private_rkey : rkeyData.group_rkey;
    if (rkeyData.online_rkey) {
      return IMAGE_HTTP_HOST_NT + `/download?appid=${appid}&fileid=${imageFileId}&rkey=${rkey}`;
    }
    return IMAGE_HTTP_HOST + `/download?appid=${appid}&fileid=${imageFileId}&rkey=${rkey}&spec=0`;
  }
  getImageUrlFromMd5(fileMd5, md5HexStr) {
    if (fileMd5 || md5HexStr) {
      return `${IMAGE_HTTP_HOST}/gchatpic_new/0/0-0-${(fileMd5 ?? md5HexStr ?? "").toUpperCase()}/0`;
    }
    this.context.logger.logDebug("图片url获取失败", { fileMd5, md5HexStr });
    return "";
  }
}

class LimitedHashTable {
  keyToValue = /* @__PURE__ */ new Map();
  valueToKey = /* @__PURE__ */ new Map();
  maxSize;
  constructor(maxSize) {
    this.maxSize = maxSize;
  }
  resize(count) {
    this.maxSize = count;
  }
  set(key, value) {
    this.keyToValue.set(key, value);
    this.valueToKey.set(value, key);
    while (this.keyToValue.size !== this.valueToKey.size) {
      this.keyToValue.clear();
      this.valueToKey.clear();
    }
    while (this.keyToValue.size > this.maxSize || this.valueToKey.size > this.maxSize) {
      const oldestKey = this.keyToValue.keys().next().value;
      if (oldestKey !== void 0) {
        this.valueToKey.delete(this.keyToValue.get(oldestKey));
        this.keyToValue.delete(oldestKey);
      }
    }
  }
  getValue(key) {
    return this.keyToValue.get(key);
  }
  getKey(value) {
    return this.valueToKey.get(value);
  }
  deleteByValue(value) {
    const key = this.valueToKey.get(value);
    if (key !== void 0) {
      this.keyToValue.delete(key);
      this.valueToKey.delete(value);
    }
  }
  deleteByKey(key) {
    const value = this.keyToValue.get(key);
    if (value !== void 0) {
      this.keyToValue.delete(key);
      this.valueToKey.delete(value);
    }
  }
  getKeyList() {
    return Array.from(this.keyToValue.keys());
  }
  // 获取最近刚写入的几个值
  getHeads(size) {
    const keyList = this.getKeyList();
    if (keyList.length === 0) {
      return void 0;
    }
    const result = [];
    const listSize = Math.min(size, keyList.length);
    for (let i = 0; i < listSize; i++) {
      const key = keyList[listSize - i];
      if (key !== void 0) {
        result.push({ key, value: this.keyToValue.get(key) });
      }
    }
    return result;
  }
}
class MessageUniqueWrapper {
  msgDataMap;
  msgIdMap;
  constructor(maxMap = 5e3) {
    this.msgIdMap = new LimitedHashTable(maxMap);
    this.msgDataMap = new LimitedHashTable(maxMap);
  }
  getRecentMsgIds(Peer2, size) {
    const heads = this.msgIdMap.getHeads(size);
    if (!heads) {
      return [];
    }
    const data = heads.map((t) => MessageUnique.getMsgIdAndPeerByShortId(t.value));
    const ret = data.filter((t) => t?.Peer.chatType === Peer2.chatType && t?.Peer.peerUid === Peer2.peerUid);
    return ret.map((t) => t?.MsgId).filter((t) => t !== void 0);
  }
  createUniqueMsgId(peer, msgId) {
    const key = `${msgId}|${peer.chatType}|${peer.peerUid}`;
    const hash = crypto__default.createHash("md5").update(key).digest();
    if (hash[0]) {
      hash[0] &= 127;
    }
    const shortId = hash.readInt32BE(0);
    this.msgIdMap.set(msgId, shortId);
    this.msgDataMap.set(key, shortId);
    return shortId;
  }
  getMsgIdAndPeerByShortId(shortId) {
    const data = this.msgDataMap.getKey(shortId);
    if (data) {
      const [msgId, chatTypeStr, peerUid] = data.split("|");
      const peer = {
        chatType: parseInt(chatTypeStr ?? "0"),
        peerUid: peerUid ?? "",
        guildId: ""
      };
      return { MsgId: msgId ?? "0", Peer: peer };
    }
    return void 0;
  }
  getShortIdByMsgId(msgId) {
    return this.msgIdMap.getValue(msgId);
  }
  getPeerByMsgId(msgId) {
    const shortId = this.msgIdMap.getValue(msgId);
    if (!shortId) return void 0;
    return this.getMsgIdAndPeerByShortId(shortId);
  }
  resize(maxSize) {
    this.msgIdMap.resize(maxSize);
    this.msgDataMap.resize(maxSize);
  }
}
const MessageUnique = new MessageUniqueWrapper();

class NTQQFriendApi {
  context;
  core;
  constructor(context, core) {
    this.context = context;
    this.core = core;
  }
  async setBuddyRemark(uid, remark) {
    return this.context.session.getBuddyService().setBuddyRemark({ uid, remark });
  }
  async getBuddyV2SimpleInfoMap() {
    const buddyService = this.context.session.getBuddyService();
    let uids = [];
    if (this.core.context.basicInfoWrapper.requireMinNTQQBuild("41679")) {
      const buddyListV2NT = await buddyService.getBuddyListV2("0", true, BuddyListReqType.KNOMAL);
      uids = buddyListV2NT.data.flatMap((item) => item.buddyUids);
    } else {
      const buddyListV2 = await buddyService.getBuddyListV2("0", BuddyListReqType.KNOMAL);
      uids = buddyListV2.data.flatMap((item) => item.buddyUids);
    }
    return await this.core.eventWrapper.callNoListenerEvent(
      "NodeIKernelProfileService/getCoreAndBaseInfo",
      "nodeStore",
      uids
    );
  }
  async getBuddy() {
    return Array.from((await this.getBuddyV2SimpleInfoMap()).values());
  }
  async getBuddyIdMap() {
    const retMap = new LimitedHashTable(5e3);
    const data = await this.getBuddyV2SimpleInfoMap();
    data.forEach((value) => retMap.set(value.uin, value.uid));
    return retMap;
  }
  async delBuudy(uid, tempBlock = false, tempBothDel = false) {
    return this.context.session.getBuddyService().delBuddy({
      friendUid: uid,
      tempBlock,
      tempBothDel
    });
  }
  async getBuddyV2ExWithCate() {
    const buddyService = this.context.session.getBuddyService();
    let uids = [];
    let buddyListV2;
    if (this.core.context.basicInfoWrapper.requireMinNTQQBuild("41679")) {
      buddyListV2 = (await buddyService.getBuddyListV2("0", true, BuddyListReqType.KNOMAL)).data;
      uids = buddyListV2.flatMap((item) => item.buddyUids);
    } else {
      buddyListV2 = (await buddyService.getBuddyListV2("0", BuddyListReqType.KNOMAL)).data;
      uids = buddyListV2.flatMap((item) => item.buddyUids);
    }
    const data = await this.core.eventWrapper.callNoListenerEvent(
      "NodeIKernelProfileService/getCoreAndBaseInfo",
      "nodeStore",
      uids
    );
    return buddyListV2.map((category) => ({
      categoryId: category.categoryId,
      categorySortId: category.categorySortId,
      categoryName: category.categroyName,
      categoryMbCount: category.categroyMbCount,
      onlineCount: category.onlineCount,
      buddyList: category.buddyUids.map((uid) => data.get(uid)).filter((value) => !!value)
    }));
  }
  async isBuddy(uid) {
    return this.context.session.getBuddyService().isBuddy(uid);
  }
  async clearBuddyReqUnreadCnt() {
    return this.context.session.getBuddyService().clearBuddyReqUnreadCnt();
  }
  async getBuddyReq() {
    const [, ret] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelBuddyService/getBuddyReq",
      "NodeIKernelBuddyListener/onBuddyReqChange",
      []
    );
    return ret;
  }
  async handleFriendRequest(notify, accept) {
    this.context.session.getBuddyService()?.approvalFriendRequest({
      friendUid: notify.friendUid,
      reqTime: notify.reqTime,
      accept
    });
  }
  async handleDoubtFriendRequest(friendUid, str1 = "", str2 = "") {
    this.context.session.getBuddyService().approvalDoubtBuddyReq(friendUid, str1, str2);
  }
  async getDoubtFriendRequest(count) {
    const date = Date.now().toString();
    const [, ret] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelBuddyService/getDoubtBuddyReq",
      "NodeIKernelBuddyListener/onDoubtBuddyReqChange",
      [date, count, ""],
      () => true,
      (data) => data.reqId === date
    );
    const requests = Promise.all(ret.doubtList.map(async (item) => {
      return {
        flag: item.uid,
        // 注意强制String 非isNumeric 不遵守则不符合设计
        uin: await this.core.apis.UserApi.getUinByUidV2(item.uid) ?? 0,
        // 信息字段
        nick: item.nick,
        // 信息字段 这个不是nickname 可能是来源的群内的昵称
        source: item.source,
        // 信息字段
        reason: item.reason,
        // 信息字段
        msg: item.msg,
        // 信息字段
        group_code: item.groupCode,
        // 信息字段
        time: item.reqTime,
        // 信息字段
        type: "doubt"
        // 保留字段
      };
    }));
    return requests;
  }
}

class CancelableTask {
  promise;
  cancelCallback = null;
  isCanceled = false;
  cancelListeners = [];
  constructor(executor) {
    this.promise = new Promise((resolve, reject) => {
      const onCancel = (callback) => {
        this.cancelCallback = callback;
      };
      const execute = async () => {
        try {
          await executor(
            (value) => {
              if (!this.isCanceled) {
                resolve(value);
              }
            },
            (reason) => {
              if (!this.isCanceled) {
                reject(reason);
              }
            },
            onCancel
          );
        } catch (error) {
          if (!this.isCanceled) {
            reject(error);
          }
        }
      };
      execute();
    });
  }
  cancel() {
    if (this.cancelCallback) {
      this.cancelCallback();
    }
    this.isCanceled = true;
    this.cancelListeners.forEach((listener) => listener());
  }
  isTaskCanceled() {
    return this.isCanceled;
  }
  onCancel(listener) {
    this.cancelListeners.push(listener);
  }
  then(onfulfilled, onrejected) {
    return this.promise.then(onfulfilled, onrejected);
  }
  catch(onrejected) {
    return this.promise.catch(onrejected);
  }
  finally(onfinally) {
    return this.promise.finally(onfinally);
  }
  [Symbol.asyncIterator]() {
    return {
      next: () => this.promise.then((value) => ({ value, done: true }))
    };
  }
}

function createGroupDetailInfoV2Param(group_code) {
  return {
    groupCode: group_code,
    filter: {
      noCodeFingerOpenFlag: 0,
      noFingerOpenFlag: 0,
      groupName: 0,
      classExt: 0,
      classText: 0,
      fingerMemo: 0,
      richFingerMemo: 0,
      tagRecord: 0,
      groupGeoInfo: {
        ownerUid: 0,
        setTime: 0,
        cityId: 0,
        longitude: 0,
        latitude: 0,
        geoContent: 0,
        poiId: 0
      },
      groupExtAdminNum: 0,
      flag: 0,
      groupMemo: 0,
      groupAioSkinUrl: 0,
      groupBoardSkinUrl: 0,
      groupCoverSkinUrl: 0,
      groupGrade: 0,
      activeMemberNum: 0,
      certificationType: 0,
      certificationText: 0,
      groupNewGuideLines: {
        enabled: 0,
        content: 0
      },
      groupFace: 0,
      addOption: 0,
      shutUpTime: 0,
      groupTypeFlag: 0,
      appPrivilegeFlag: 0,
      appPrivilegeMask: 0,
      groupExtOnly: {
        tribeId: 0,
        moneyForAddGroup: 0
      },
      groupSecLevel: 0,
      groupSecLevelInfo: 0,
      subscriptionUin: 0,
      subscriptionUid: "",
      allowMemberInvite: 0,
      groupQuestion: 0,
      groupAnswer: 0,
      groupFlagExt3: 0,
      groupFlagExt3Mask: 0,
      groupOpenAppid: 0,
      rootId: 0,
      msgLimitFrequency: 0,
      hlGuildAppid: 0,
      hlGuildSubType: 0,
      hlGuildOrgId: 0,
      groupFlagExt4: 0,
      groupFlagExt4Mask: 0,
      groupSchoolInfo: {
        location: 0,
        grade: 0,
        school: 0
      },
      groupCardPrefix: {
        introduction: 0,
        rptPrefix: 0
      },
      allianceId: 0,
      groupFlagPro1: 0,
      groupFlagPro1Mask: 0
    },
    modifyInfo: {
      noCodeFingerOpenFlag: 0,
      noFingerOpenFlag: 0,
      groupName: "",
      classExt: 0,
      classText: "",
      fingerMemo: "",
      richFingerMemo: "",
      tagRecord: [],
      groupGeoInfo: {
        ownerUid: "",
        SetTime: 0,
        CityId: 0,
        Longitude: "",
        Latitude: "",
        GeoContent: "",
        poiId: ""
      },
      groupExtAdminNum: 0,
      flag: 0,
      groupMemo: "",
      groupAioSkinUrl: "",
      groupBoardSkinUrl: "",
      groupCoverSkinUrl: "",
      groupGrade: 0,
      activeMemberNum: 0,
      certificationType: 0,
      certificationText: "",
      groupNewGuideLines: {
        enabled: false,
        content: ""
      },
      groupFace: 0,
      addOption: 0,
      shutUpTime: 0,
      groupTypeFlag: 0,
      appPrivilegeFlag: 0,
      appPrivilegeMask: 0,
      groupExtOnly: {
        tribeId: 0,
        moneyForAddGroup: 0
      },
      groupSecLevel: 0,
      groupSecLevelInfo: 0,
      subscriptionUin: "",
      subscriptionUid: "",
      allowMemberInvite: 0,
      groupQuestion: "",
      groupAnswer: "",
      groupFlagExt3: 0,
      groupFlagExt3Mask: 0,
      groupOpenAppid: 0,
      rootId: "",
      msgLimitFrequency: 0,
      hlGuildAppid: 0,
      hlGuildSubType: 0,
      hlGuildOrgId: 0,
      groupFlagExt4: 0,
      groupFlagExt4Mask: 0,
      groupSchoolInfo: {
        location: "",
        grade: 0,
        school: ""
      },
      groupCardPrefix: {
        introduction: "",
        rptPrefix: []
      },
      allianceId: "",
      groupFlagPro1: 0,
      groupFlagPro1Mask: 0
    }
  };
}
function createGroupExtInfo(group_code) {
  return {
    groupCode: group_code,
    resultCode: 0,
    extInfo: {
      groupInfoExtSeq: 0,
      reserve: 0,
      luckyWordId: "",
      lightCharNum: 0,
      luckyWord: "",
      starId: 0,
      essentialMsgSwitch: 0,
      todoSeq: 0,
      blacklistExpireTime: 0,
      isLimitGroupRtc: 0,
      companyId: 0,
      hasGroupCustomPortrait: 0,
      bindGuildId: "",
      groupOwnerId: {
        memberUin: "",
        memberUid: "",
        memberQid: ""
      },
      essentialMsgPrivilege: 0,
      msgEventSeq: "",
      inviteRobotSwitch: 0,
      gangUpId: "",
      qqMusicMedalSwitch: 0,
      showPlayTogetherSwitch: 0,
      groupFlagPro1: "",
      groupBindGuildIds: {
        guildIds: []
      },
      viewedMsgDisappearTime: "",
      groupExtFlameData: {
        switchState: 0,
        state: 0,
        dayNums: [],
        version: 0,
        updateTime: "",
        isDisplayDayNum: false
      },
      groupBindGuildSwitch: 0,
      groupAioBindGuildId: "",
      groupExcludeGuildIds: {
        guildIds: []
      },
      fullGroupExpansionSwitch: 0,
      fullGroupExpansionSeq: "",
      inviteRobotMemberSwitch: 0,
      inviteRobotMemberExamine: 0,
      groupSquareSwitch: 0
    }
  };
}
function createGroupExtFilter() {
  return {
    groupInfoExtSeq: 0,
    reserve: 0,
    luckyWordId: 0,
    lightCharNum: 0,
    luckyWord: 0,
    starId: 0,
    essentialMsgSwitch: 0,
    todoSeq: 0,
    blacklistExpireTime: 0,
    isLimitGroupRtc: 0,
    companyId: 0,
    hasGroupCustomPortrait: 0,
    bindGuildId: 0,
    groupOwnerId: 0,
    essentialMsgPrivilege: 0,
    msgEventSeq: 0,
    inviteRobotSwitch: 0,
    gangUpId: 0,
    qqMusicMedalSwitch: 0,
    showPlayTogetherSwitch: 0,
    groupFlagPro1: 0,
    groupBindGuildIds: 0,
    viewedMsgDisappearTime: 0,
    groupExtFlameData: 0,
    groupBindGuildSwitch: 0,
    groupAioBindGuildId: 0,
    groupExcludeGuildIds: 0,
    fullGroupExpansionSwitch: 0,
    fullGroupExpansionSeq: 0,
    inviteRobotMemberSwitch: 0,
    inviteRobotMemberExamine: 0,
    groupSquareSwitch: 0
  };
}

class NTQQGroupApi {
  context;
  core;
  groupMemberCache = /* @__PURE__ */ new Map();
  essenceLRU = new LimitedHashTable(1e3);
  constructor(context, core) {
    this.context = context;
    this.core = core;
  }
  async setGroupRemark(groupCode, remark) {
    return this.context.session.getGroupService().modifyGroupRemark(groupCode, remark);
  }
  async fetchGroupDetail(groupCode) {
    const [, detailInfo] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelGroupService/getGroupDetailInfo",
      "NodeIKernelGroupListener/onGroupDetailInfoChange",
      [groupCode, GroupInfoSource.KDATACARD],
      (ret) => ret.result === 0,
      (detailInfo2) => detailInfo2.groupCode === groupCode,
      1,
      5e3
    );
    return detailInfo;
  }
  async initApi() {
    this.initCache().then().catch((e) => this.context.logger.logError(e));
  }
  async createGrayTip(groupCode, tip) {
    return this.context.session.getMsgService().addLocalJsonGrayTipMsg(
      {
        chatType: ChatType.KCHATTYPEGROUP,
        peerUid: groupCode
      },
      {
        busiId: 2201,
        jsonStr: JSON.stringify({ align: "center", items: [{ txt: tip, type: "nor" }] }),
        recentAbstract: tip,
        isServer: false
      },
      true,
      true
    );
  }
  async initCache() {
    for (const group of await this.getGroups(true)) {
      this.refreshGroupMemberCache(group.groupCode, false).then().catch((e) => this.context.logger.logError(e));
    }
  }
  async fetchGroupEssenceList(groupCode) {
    const pskey = (await this.core.apis.UserApi.getPSkey(["qun.qq.com"])).domainPskeyMap.get("qun.qq.com");
    return this.context.session.getGroupService().fetchGroupEssenceList({
      groupCode,
      pageStart: 0,
      pageLimit: 300
    }, pskey);
  }
  async getGroupShutUpMemberList(groupCode) {
    const executor = async (resolve, reject, onCancel) => {
      this.core.eventWrapper.registerListen(
        "NodeIKernelGroupListener/onShutUpMemberListChanged",
        (group_id) => group_id === groupCode,
        1,
        1e3
      ).then((data) => {
        resolve(data[1]);
      }).catch(reject);
      onCancel(() => {
        reject(new Error("Task was canceled"));
      });
    };
    const task = new CancelableTask(executor);
    this.context.session.getGroupService().getGroupShutUpMemberList(groupCode).then((e) => {
      if (e.result !== 0) {
        task.cancel();
      }
    });
    return await task.catch(() => []);
  }
  async clearGroupNotifiesUnreadCount(doubt) {
    return this.context.session.getGroupService().clearGroupNotifiesUnreadCount(doubt);
  }
  async setGroupAvatar(groupCode, filePath) {
    return this.context.session.getGroupService().setHeader(groupCode, filePath);
  }
  // 0 0 无需管理员审核
  // 0 2 需要管理员审核
  // 1 2 禁止Bot入群( 最好只传一个1 ？)
  async setGroupRobotAddOption(groupCode, robotMemberSwitch, robotMemberExamine) {
    const extInfo = createGroupExtInfo(groupCode);
    const groupExtFilter = createGroupExtFilter();
    if (robotMemberSwitch !== void 0) {
      extInfo.extInfo.inviteRobotMemberSwitch = robotMemberSwitch;
      groupExtFilter.inviteRobotMemberSwitch = 1;
    }
    if (robotMemberExamine !== void 0) {
      extInfo.extInfo.inviteRobotMemberExamine = robotMemberExamine;
      groupExtFilter.inviteRobotMemberExamine = 1;
    }
    return this.context.session.getGroupService().modifyGroupExtInfoV2(extInfo, groupExtFilter);
  }
  async setGroupAddOption(groupCode, option) {
    const param = createGroupDetailInfoV2Param(groupCode);
    param.filter.addOption = 1;
    if (option.addOption === 4 || option.addOption === 5) {
      param.filter.groupQuestion = 1;
      param.filter.groupAnswer = option.addOption === 4 ? 1 : 0;
      param.modifyInfo.groupQuestion = option.groupQuestion || "";
      param.modifyInfo.groupAnswer = option.addOption === 4 ? option.groupAnswer || "" : "";
    }
    param.modifyInfo.addOption = option.addOption;
    return this.context.session.getGroupService().modifyGroupDetailInfoV2(param, 0);
  }
  async setGroupSearch(groupCode, option) {
    const param = createGroupDetailInfoV2Param(groupCode);
    if (option.noCodeFingerOpenFlag) {
      param.filter.noCodeFingerOpenFlag = 1;
      param.modifyInfo.noCodeFingerOpenFlag = option.noCodeFingerOpenFlag;
    }
    if (option.noFingerOpenFlag) {
      param.filter.noFingerOpenFlag = 1;
      param.modifyInfo.noFingerOpenFlag = option.noFingerOpenFlag;
    }
    return this.context.session.getGroupService().modifyGroupDetailInfoV2(param, 0);
  }
  async getGroups(forced = false) {
    const [, , groupList] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelGroupService/getGroupList",
      "NodeIKernelGroupListener/onGroupListUpdate",
      [forced]
    );
    return groupList;
  }
  async getGroupExtFE0Info(groupCodes, forced = true) {
    return this.context.session.getGroupService().getGroupExt0xEF0Info(
      groupCodes,
      [],
      {
        bindGuildId: 1,
        blacklistExpireTime: 1,
        companyId: 1,
        essentialMsgPrivilege: 1,
        essentialMsgSwitch: 1,
        fullGroupExpansionSeq: 1,
        fullGroupExpansionSwitch: 1,
        gangUpId: 1,
        groupAioBindGuildId: 1,
        groupBindGuildIds: 1,
        groupBindGuildSwitch: 1,
        groupExcludeGuildIds: 1,
        groupExtFlameData: 1,
        groupFlagPro1: 1,
        groupInfoExtSeq: 1,
        groupOwnerId: 1,
        groupSquareSwitch: 1,
        hasGroupCustomPortrait: 1,
        inviteRobotMemberExamine: 1,
        inviteRobotMemberSwitch: 1,
        inviteRobotSwitch: 1,
        isLimitGroupRtc: 1,
        lightCharNum: 1,
        luckyWord: 1,
        luckyWordId: 1,
        msgEventSeq: 1,
        qqMusicMedalSwitch: 1,
        reserve: 1,
        showPlayTogetherSwitch: 1,
        starId: 1,
        todoSeq: 1,
        viewedMsgDisappearTime: 1
      },
      forced
    );
  }
  async getGroupMemberAll(groupCode, forced = false) {
    return this.context.session.getGroupService().getAllMemberList(groupCode, forced);
  }
  async refreshGroupMemberCache(groupCode, isWait = true) {
    const updateCache = async () => {
      try {
        const members = await this.getGroupMemberAll(groupCode, true);
        this.groupMemberCache.set(groupCode, members.result.infos);
      } catch (e) {
        this.context.logger.logError(`刷新群成员缓存失败, 群号: ${groupCode}, 错误: ${e}`);
      }
    };
    if (isWait) {
      await updateCache();
    } else {
      updateCache();
    }
    return this.groupMemberCache.get(groupCode);
  }
  async refreshGroupMemberCachePartial(groupCode, uid) {
    const member = await this.getGroupMemberEx(groupCode, uid, true);
    if (member) {
      this.groupMemberCache.get(groupCode)?.set(uid, member);
    }
    return member;
  }
  async getGroupMember(groupCode, memberUinOrUid) {
    const groupCodeStr = groupCode.toString();
    const memberUinOrUidStr = memberUinOrUid.toString();
    let members = this.groupMemberCache.get(groupCodeStr);
    if (!members) {
      members = await this.refreshGroupMemberCache(groupCodeStr, true);
    }
    const getMember = () => {
      if (isNumeric(memberUinOrUidStr)) {
        return Array.from(members.values()).find((member2) => member2.uin === memberUinOrUidStr);
      } else {
        return members.get(memberUinOrUidStr);
      }
    };
    let member = getMember();
    if (!member) {
      members = await this.refreshGroupMemberCache(groupCodeStr, true);
      member = getMember();
    }
    return member;
  }
  async getGroupRecommendContactArkJson(groupCode) {
    return this.context.session.getGroupService().getGroupRecommendContactArkJson(groupCode);
  }
  async creatGroupFileFolder(groupCode, folderName) {
    return this.context.session.getRichMediaService().createGroupFolder(groupCode, folderName);
  }
  async delGroupFile(groupCode, files) {
    return this.context.session.getRichMediaService().deleteGroupFile(groupCode, [102], files);
  }
  async delGroupFileFolder(groupCode, folderId) {
    return this.context.session.getRichMediaService().deleteGroupFolder(groupCode, folderId);
  }
  async transGroupFile(groupCode, fileId) {
    return this.context.session.getRichMediaService().transGroupFile(groupCode, fileId);
  }
  async addGroupEssence(groupCode, msgId) {
    const MsgData = await this.context.session.getMsgService().getMsgsIncludeSelf({
      chatType: 2,
      guildId: "",
      peerUid: groupCode
    }, msgId, 1, false);
    if (!MsgData.msgList[0]) {
      throw new Error("消息不存在");
    }
    const param = {
      groupCode,
      msgRandom: parseInt(MsgData.msgList[0].msgRandom),
      msgSeq: parseInt(MsgData.msgList[0].msgSeq)
    };
    return this.context.session.getGroupService().addGroupEssence(param);
  }
  async kickMemberV2Inner(param) {
    return this.context.session.getGroupService().kickMemberV2(param);
  }
  async deleteGroupBulletin(groupCode, noticeId) {
    const psKey = (await this.core.apis.UserApi.getPSkey(["qun.qq.com"])).domainPskeyMap.get("qun.qq.com");
    return this.context.session.getGroupService().deleteGroupBulletin(groupCode, psKey, noticeId);
  }
  async quitGroupV2(GroupCode, needDeleteLocalMsg) {
    const param = {
      groupCode: GroupCode,
      needDeleteLocalMsg
    };
    return this.context.session.getGroupService().quitGroupV2(param);
  }
  async removeGroupEssenceBySeq(groupCode, msgRandom, msgSeq) {
    const param = {
      groupCode,
      msgRandom: parseInt(msgRandom),
      msgSeq: parseInt(msgSeq)
    };
    return this.context.session.getGroupService().removeGroupEssence(param);
  }
  async removeGroupEssence(groupCode, msgId) {
    const MsgData = await this.context.session.getMsgService().getMsgsIncludeSelf({
      chatType: 2,
      guildId: "",
      peerUid: groupCode
    }, msgId, 1, false);
    if (!MsgData.msgList[0]) {
      throw new Error("消息不存在");
    }
    const param = {
      groupCode,
      msgRandom: parseInt(MsgData.msgList[0].msgRandom),
      msgSeq: parseInt(MsgData.msgList[0].msgSeq)
    };
    return this.context.session.getGroupService().removeGroupEssence(param);
  }
  async getSingleScreenNotifies(doubt, count) {
    const [, , , notifies] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelGroupService/getSingleScreenNotifies",
      "NodeIKernelGroupListener/onGroupSingleScreenNotifies",
      [
        doubt,
        "",
        count
      ]
    );
    return notifies;
  }
  async searchGroup(groupCode) {
    const [, ret] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelSearchService/searchGroup",
      "NodeIKernelSearchListener/onSearchGroupResult",
      [{
        keyWords: groupCode,
        groupNum: 25,
        exactSearch: false,
        penetrate: ""
      }],
      (ret2) => ret2.result === 0,
      (params) => !!params.groupInfos.find((g) => g.groupCode === groupCode),
      1,
      5e3
    );
    return ret.groupInfos.find((g) => g.groupCode === groupCode);
  }
  async getGroupMemberEx(groupCode, uid, forced = false, retry = 2) {
    const data = await solveAsyncProblem((eventWrapper, GroupCode, uid2, forced2 = false) => {
      return eventWrapper.callNormalEventV2(
        "NodeIKernelGroupService/getMemberInfo",
        "NodeIKernelGroupListener/onMemberInfoChange",
        [groupCode, [uid2], forced2],
        (ret) => ret.result === 0,
        (params, _, members) => params === GroupCode && members.size > 0 && members.has(uid2),
        1,
        forced2 ? 2500 : 250
      );
    }, this.core.eventWrapper, groupCode, uid, forced);
    if (data && data[3] instanceof Map && data[3].has(uid)) {
      return data[3].get(uid);
    }
    if (retry > 0) {
      const trydata = await this.getGroupMemberEx(groupCode, uid, true, retry - 1);
      if (trydata) return trydata;
    }
    return void 0;
  }
  async getGroupFileCount(groupCodes) {
    return this.context.session.getRichMediaService().batchGetGroupFileCount(groupCodes);
  }
  async getArkJsonGroupShare(groupCode) {
    const ret = await this.core.eventWrapper.callNoListenerEvent(
      "NodeIKernelGroupService/getGroupRecommendContactArkJson",
      groupCode
    );
    return ret.arkJson;
  }
  async uploadGroupBulletinPic(groupCode, imageurl) {
    const _Pskey = (await this.core.apis.UserApi.getPSkey(["qun.qq.com"])).domainPskeyMap.get("qun.qq.com");
    return this.context.session.getGroupService().uploadGroupBulletinPic(groupCode, _Pskey, imageurl);
  }
  async handleGroupRequest(doubt, notify, operateType, reason) {
    return this.context.session.getGroupService().operateSysNotify(
      doubt,
      {
        operateType,
        targetMsg: {
          seq: notify.seq,
          // 通知序列号
          type: notify.type,
          groupCode: notify.group.groupCode,
          postscript: reason ?? " "
          // 仅传空值可能导致处理失败，故默认给个空格
        }
      }
    );
  }
  async quitGroup(groupCode) {
    return this.context.session.getGroupService().quitGroup(groupCode);
  }
  async kickMember(groupCode, kickUids, refuseForever = false, kickReason = "") {
    return this.context.session.getGroupService().kickMember(groupCode, kickUids, refuseForever, kickReason);
  }
  async banMember(groupCode, memList) {
    return this.context.session.getGroupService().setMemberShutUp(groupCode, memList);
  }
  async banGroup(groupCode, shutUp) {
    return this.context.session.getGroupService().setGroupShutUp(groupCode, shutUp);
  }
  async setMemberCard(groupCode, memberUid, cardName) {
    return this.context.session.getGroupService().modifyMemberCardName(groupCode, memberUid, cardName);
  }
  async setMemberRole(groupCode, memberUid, role) {
    return this.context.session.getGroupService().modifyMemberRole(groupCode, memberUid, role);
  }
  async setGroupName(groupCode, groupName) {
    return this.context.session.getGroupService().modifyGroupName(groupCode, groupName, false);
  }
  async publishGroupBulletin(groupCode, content, picInfo = void 0, pinned = 0, confirmRequired = 0) {
    const psKey = (await this.core.apis.UserApi.getPSkey(["qun.qq.com"])).domainPskeyMap.get("qun.qq.com");
    const data = {
      text: encodeURI(content),
      picInfo,
      oldFeedsId: "",
      pinned,
      confirmRequired
    };
    return this.context.session.getGroupService().publishGroupBulletin(groupCode, psKey, data);
  }
  async getGroupRemainAtTimes(groupCode) {
    return this.context.session.getGroupService().getGroupRemainAtTimes(groupCode);
  }
  async getMemberExtInfo(groupCode, uin) {
    return this.context.session.getGroupService().getMemberExtInfo(
      {
        groupCode,
        sourceType: MemberExtSourceType.TITLETYPE,
        beginUin: "0",
        dataTime: "0",
        uinList: [uin],
        uinNum: "",
        seq: "",
        groupType: "",
        richCardNameVer: "",
        memberExtFilter: {
          memberLevelInfoUin: 1,
          memberLevelInfoPoint: 1,
          memberLevelInfoActiveDay: 1,
          memberLevelInfoLevel: 1,
          memberLevelInfoName: 1,
          levelName: 1,
          dataTime: 1,
          userShowFlag: 1,
          sysShowFlag: 1,
          timeToUpdate: 1,
          nickName: 1,
          specialTitle: 1,
          levelNameNew: 1,
          userShowFlagNew: 1,
          msgNeedField: 1,
          cmdUinFlagExt3Grocery: 1,
          memberIcon: 1,
          memberInfoSeq: 1
        }
      }
    );
  }
}

class NTQQMsgApi {
  context;
  core;
  constructor(context, core) {
    this.context = context;
    this.core = core;
  }
  async clickInlineKeyboardButton(...params) {
    return this.context.session.getMsgService().clickInlineKeyboardButton(...params);
  }
  getMsgByClientSeqAndTime(peer, replyMsgClientSeq, replyMsgTime) {
    return this.context.session.getMsgService().getMsgByClientSeqAndTime(peer, replyMsgClientSeq, replyMsgTime);
  }
  async getAioFirstViewLatestMsgs(peer, MsgCount) {
    return this.context.session.getMsgService().getAioFirstViewLatestMsgs(peer, MsgCount);
  }
  async sendShowInputStatusReq(peer, eventType) {
    return this.context.session.getMsgService().sendShowInputStatusReq(peer.chatType, eventType, peer.peerUid);
  }
  async getSourceOfReplyMsgV2(peer, clientSeq, time) {
    return this.context.session.getMsgService().getSourceOfReplyMsgV2(peer, clientSeq, time);
  }
  async getMsgEmojiLikesList(peer, msgSeq, emojiId, emojiType, count = 20) {
    return this.context.session.getMsgService().getMsgEmojiLikesList(peer, msgSeq, emojiId, emojiType, "", false, count);
  }
  async setEmojiLike(peer, msgSeq, emojiId, set = true) {
    emojiId = emojiId.toString();
    return this.context.session.getMsgService().setMsgEmojiLikes(peer, msgSeq, emojiId, emojiId.length > 3 ? "2" : "1", set);
  }
  async getMultiMsg(peer, rootMsgId, parentMsgId) {
    return this.context.session.getMsgService().getMultiMsg(peer, rootMsgId, parentMsgId);
  }
  async ForwardMsg(peer, msgIds) {
    return this.context.session.getMsgService().forwardMsg(msgIds, peer, [peer], /* @__PURE__ */ new Map());
  }
  async getMsgsByMsgId(peer, msgIds) {
    if (!peer) throw new Error("peer is not allowed");
    if (!msgIds) throw new Error("msgIds is not allowed");
    return await this.context.session.getMsgService().getMsgsByMsgId(peer, msgIds);
  }
  async getSingleMsg(peer, seq) {
    return await this.context.session.getMsgService().getSingleMsg(peer, seq);
  }
  async fetchFavEmojiList(num) {
    return this.context.session.getMsgService().fetchFavEmojiList("", num, true, true);
  }
  async queryMsgsWithFilterExWithSeq(peer, msgSeq) {
    return await this.context.session.getMsgService().queryMsgsWithFilterEx("0", "0", msgSeq, {
      chatInfo: peer,
      // searchFields: 3,
      filterMsgType: [],
      filterSendersUid: [],
      filterMsgToTime: "0",
      filterMsgFromTime: "0",
      isReverseOrder: false,
      isIncludeCurrent: true,
      pageLimit: 1
    });
  }
  async queryMsgsWithFilterExWithSeqV2(peer, msgSeq, MsgTime, SendersUid) {
    return await this.context.session.getMsgService().queryMsgsWithFilterEx("0", "0", msgSeq, {
      chatInfo: peer,
      filterMsgType: [],
      // searchFields: 3,
      filterSendersUid: SendersUid,
      filterMsgToTime: MsgTime,
      filterMsgFromTime: MsgTime,
      isReverseOrder: false,
      isIncludeCurrent: true,
      pageLimit: 1
    });
  }
  async queryMsgsWithFilterExWithSeqV3(peer, msgSeq, SendersUid) {
    return await this.context.session.getMsgService().queryMsgsWithFilterEx("0", "0", msgSeq, {
      chatInfo: peer,
      filterMsgType: [],
      filterSendersUid: SendersUid,
      filterMsgToTime: "0",
      filterMsgFromTime: "0",
      isReverseOrder: false,
      // searchFields: 3,
      isIncludeCurrent: true,
      pageLimit: 1
    });
  }
  async queryFirstMsgBySeq(peer, msgSeq) {
    return await this.context.session.getMsgService().queryMsgsWithFilterEx("0", "0", msgSeq, {
      chatInfo: peer,
      filterMsgType: [],
      filterSendersUid: [],
      filterMsgToTime: "0",
      // searchFields: 3,
      filterMsgFromTime: "0",
      isReverseOrder: true,
      isIncludeCurrent: true,
      pageLimit: 1
    });
  }
  // 客户端还在用别慌
  async getMsgsBySeqAndCount(peer, seq, count, desc, isReverseOrder) {
    return await this.context.session.getMsgService().getMsgsBySeqAndCount(peer, seq, count, desc, isReverseOrder);
  }
  async getMsgExBySeq(peer, msgSeq) {
    const DateNow = Math.floor(Date.now() / 1e3);
    const filterMsgFromTime = (DateNow - 300).toString();
    const filterMsgToTime = DateNow.toString();
    return await this.context.session.getMsgService().queryMsgsWithFilterEx("0", "0", msgSeq, {
      chatInfo: peer,
      // 此处为Peer 为关键查询参数 没有啥也没有 by mlik iowa
      filterMsgType: [],
      filterSendersUid: [],
      // searchFields: 3,
      filterMsgToTime,
      filterMsgFromTime,
      isReverseOrder: false,
      isIncludeCurrent: true,
      pageLimit: 100
    });
  }
  async queryFirstMsgBySender(peer, SendersUid) {
    return await this.context.session.getMsgService().queryMsgsWithFilterEx("0", "0", "0", {
      chatInfo: peer,
      filterMsgType: [],
      filterSendersUid: SendersUid,
      // searchFields: 3,
      filterMsgToTime: "0",
      filterMsgFromTime: "0",
      isReverseOrder: true,
      isIncludeCurrent: true,
      pageLimit: 2e4
    });
  }
  async setMsgRead(peer) {
    return this.context.session.getMsgService().setMsgRead(peer);
  }
  async getGroupFileList(GroupCode, params) {
    const item = [];
    let index = params.startIndex;
    while (true) {
      params.startIndex = index;
      const [, groupFileListResult] = await this.core.eventWrapper.callNormalEventV2(
        "NodeIKernelRichMediaService/getGroupFileList",
        "NodeIKernelMsgListener/onGroupFileInfoUpdate",
        [
          GroupCode,
          params
        ],
        () => true,
        () => true,
        // 应当通过 groupFileListResult 判断
        1,
        5e3
      );
      if (!groupFileListResult?.item?.length) break;
      item.push(...groupFileListResult.item);
      if (groupFileListResult.isEnd) break;
      if (item.length === params.fileCount) break;
      index = groupFileListResult.nextIndex;
    }
    return item;
  }
  async getMsgHistory(peer, msgId, count, isReverseOrder = false) {
    return this.context.session.getMsgService().getMsgsIncludeSelf(peer, msgId, count, isReverseOrder);
  }
  async recallMsg(peer, msgId) {
    return await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelMsgService/recallMsg",
      "NodeIKernelMsgListener/onMsgInfoListUpdate",
      [peer, [msgId]],
      () => true,
      (updatedList) => updatedList.find((m) => m.msgId === msgId && m.recallTime !== "0") !== void 0,
      1,
      1e3
    );
  }
  async PrepareTempChat(toUserUid, GroupCode, nickname) {
    return this.context.session.getMsgService().prepareTempChat({
      chatType: ChatType.KCHATTYPETEMPC2CFROMGROUP,
      peerUid: toUserUid,
      peerNickname: nickname,
      fromGroupCode: GroupCode,
      sig: "",
      selfPhone: "",
      selfUid: this.core.selfInfo.uid,
      gameSession: {
        nickname: "",
        gameAppId: "",
        selfTinyId: "",
        peerRoleId: "",
        peerOpenId: ""
      }
    });
  }
  async getTempChatInfo(chatType, peerUid) {
    return this.context.session.getMsgService().getTempChatInfo(chatType, peerUid);
  }
  async sendMsg(peer, msgElements, timeout = 1e4) {
    if (peer.chatType === ChatType.KCHATTYPETEMPC2CFROMGROUP && peer.guildId && peer.guildId !== "") {
      const member = await this.core.apis.GroupApi.getGroupMember(peer.guildId, peer.peerUid);
      if (member) {
        await this.PrepareTempChat(peer.peerUid, peer.guildId, member.nick);
      }
    }
    const msgId = await this.generateMsgUniqueId(peer.chatType);
    peer.guildId = msgId;
    const [, msgList] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelMsgService/sendMsg",
      "NodeIKernelMsgListener/onMsgInfoListUpdate",
      [
        "0",
        peer,
        msgElements,
        /* @__PURE__ */ new Map()
      ],
      (ret) => ret.result === 0,
      (msgRecords) => {
        for (const msgRecord of msgRecords) {
          if (msgRecord.guildId === msgId && msgRecord.sendStatus === SendStatusType.KSEND_STATUS_SUCCESS) {
            return true;
          }
        }
        return false;
      },
      1,
      timeout
    );
    return msgList.find((msgRecord) => msgRecord.guildId === msgId);
  }
  async generateMsgUniqueId(chatType) {
    return this.context.session.getMsgService().generateMsgUniqueId(chatType, this.context.session.getMSFService().getServerTime());
  }
  async forwardMsg(srcPeer, destPeer, msgIds) {
    return this.context.session.getMsgService().forwardMsg(msgIds, srcPeer, [destPeer], /* @__PURE__ */ new Map());
  }
  async multiForwardMsg(srcPeer, destPeer, msgIds) {
    const msgInfos = msgIds.map((id) => {
      return { msgId: id, senderShowName: this.core.selfInfo.nick };
    });
    const [, msgList] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelMsgService/multiForwardMsgWithComment",
      "NodeIKernelMsgListener/onMsgInfoListUpdate",
      [
        msgInfos,
        srcPeer,
        destPeer,
        [],
        /* @__PURE__ */ new Map()
      ],
      () => true,
      (msgRecords) => msgRecords.some(
        (msgRecord) => msgRecord.peerUid === destPeer.peerUid && msgRecord.senderUid === this.core.selfInfo.uid
      )
    );
    for (const msg of msgList) {
      const arkElement = msg.elements.find((ele) => ele.arkElement);
      if (!arkElement) {
        continue;
      }
      const forwardData = JSON.parse(arkElement.arkElement?.bytesData ?? "");
      if (forwardData.app !== "com.tencent.multimsg") {
        continue;
      }
      if (msg.peerUid === destPeer.peerUid && msg.senderUid === this.core.selfInfo.uid) {
        return msg;
      }
    }
    throw new Error("转发消息超时");
  }
  async markAllMsgAsRead() {
    return this.context.session.getMsgService().setAllC2CAndGroupMsgRead();
  }
}

class Fallback {
  handlers = [];
  checker;
  constructor(checker) {
    this.checker = checker || (async (result) => result);
  }
  add(handler) {
    this.handlers.push(handler);
    return this;
  }
  // 执行处理程序链
  async run() {
    const errors = [];
    for (const handler of this.handlers) {
      try {
        const result = await handler();
        const data = await this.checker(result);
        if (data) {
          return data;
        }
      } catch (error) {
        errors.push(error instanceof Error ? error : new Error(String(error)));
      }
    }
    throw new AggregateError(errors, "All handlers failed");
  }
}
class FallbackUtil {
  static boolchecker(value, condition) {
    if (condition) {
      return value;
    } else {
      throw new Error("Condition is false, throwing error");
    }
  }
}

class NTQQUserApi {
  context;
  core;
  constructor(context, core) {
    this.context = context;
    this.core = core;
  }
  async getCoreAndBaseInfo(uids) {
    return await this.core.eventWrapper.callNoListenerEvent(
      "NodeIKernelProfileService/getCoreAndBaseInfo",
      "nodeStore",
      uids
    );
  }
  // 默认获取自己的 type = 2 获取别人 type = 1
  async getProfileLike(uid, start, count, type = 2) {
    return this.context.session.getProfileLikeService().getBuddyProfileLike({
      friendUids: [uid],
      basic: 1,
      vote: 1,
      favorite: 0,
      userProfile: 1,
      type,
      start,
      limit: count
    });
  }
  async setLongNick(longNick) {
    return this.context.session.getProfileService().setLongNick(longNick);
  }
  async setSelfOnlineStatus(status, extStatus, batteryStatus) {
    return this.context.session.getMsgService().setStatus({
      status,
      extStatus,
      batteryStatus
    });
  }
  async setDiySelfOnlineStatus(faceId, wording, faceType) {
    return this.context.session.getMsgService().setStatus({
      status: 10,
      extStatus: 2e3,
      customStatus: { faceId, wording, faceType },
      batteryStatus: 0
    });
  }
  async getBuddyRecommendContactArkJson(uin, sencenID = "") {
    return this.context.session.getBuddyService().getBuddyRecommendContactArkJson(uin, sencenID);
  }
  async like(uid, count = 1) {
    return this.context.session.getProfileLikeService().setBuddyProfileLike({
      friendUid: uid,
      sourceId: 71,
      doLikeCount: count,
      doLikeTollCount: 0
    });
  }
  async setQQAvatar(filePath) {
    const ret = await this.context.session.getProfileService().setHeader(filePath);
    return { result: ret?.result, errMsg: ret?.errMsg };
  }
  async setGroupAvatar(gc, filePath) {
    return this.context.session.getGroupService().setHeader(gc, filePath);
  }
  async fetchUserDetailInfo(uid, mode = UserDetailSource.KDB) {
    const [, profile] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelProfileService/fetchUserDetailInfo",
      "NodeIKernelProfileListener/onUserDetailInfoChanged",
      [
        "BuddyProfileStore",
        [uid],
        mode,
        [ProfileBizType.KALL]
      ],
      () => true,
      (profile2) => profile2.uid === uid
    );
    return profile;
  }
  async getUserDetailInfo(uid, no_cache = false) {
    let profile = await solveAsyncProblem(async (uid2) => this.fetchUserDetailInfo(uid2, no_cache ? UserDetailSource.KSERVER : UserDetailSource.KDB), uid);
    if (profile && profile.uin !== "0" && profile.commonExt) {
      return {
        ...profile.simpleInfo.status,
        ...profile.simpleInfo.vasInfo,
        ...profile.commonExt,
        ...profile.simpleInfo.baseInfo,
        ...profile.simpleInfo.coreInfo,
        qqLevel: profile.commonExt?.qqLevel,
        age: profile.simpleInfo.baseInfo.age,
        pendantId: "",
        nick: profile.simpleInfo.coreInfo.nick || ""
      };
    }
    this.context.logger.logDebug("[NapCat] [Mark] getUserDetailInfo Mode1 Failed.");
    profile = await this.fetchUserDetailInfo(uid, UserDetailSource.KSERVER);
    if (profile && profile.uin === "0") {
      profile.uin = await this.core.apis.UserApi.getUidByUinV2(uid) ?? "0";
    }
    return {
      ...profile.simpleInfo.status,
      ...profile.simpleInfo.vasInfo,
      ...profile.commonExt,
      ...profile.simpleInfo.baseInfo,
      ...profile.simpleInfo.coreInfo,
      qqLevel: profile.commonExt?.qqLevel,
      age: profile.simpleInfo.baseInfo.age,
      pendantId: "",
      nick: profile.simpleInfo.coreInfo.nick || ""
    };
  }
  async modifySelfProfile(param) {
    return this.context.session.getProfileService().modifyDesktopMiniProfile(param);
  }
  async getCookies(domain) {
    const ClientKeyData = await this.forceFetchClientKey();
    const requestUrl = "https://ssl.ptlogin2.qq.com/jump?ptlang=1033&clientuin=" + this.core.selfInfo.uin + "&clientkey=" + ClientKeyData.clientKey + "&u1=https%3A%2F%2F" + domain + "%2F" + this.core.selfInfo.uin + "%2Finfocenter&keyindex=19%27";
    const data = await RequestUtil.HttpsGetCookies(requestUrl);
    if (!data["p_skey"] || data["p_skey"].length === 0) {
      try {
        const pskey = (await this.getPSkey([domain])).domainPskeyMap.get(domain);
        if (pskey) data["p_skey"] = pskey;
      } catch {
        return data;
      }
    }
    return data;
  }
  async getPSkey(domainList) {
    return await this.context.session.getTipOffService().getPskey(domainList, true);
  }
  async getRobotUinRange() {
    const robotUinRanges = await this.context.session.getRobotService().getRobotUinRange({
      justFetchMsgConfig: "1",
      type: 1,
      version: 0,
      aioKeywordVersion: 0
    });
    return robotUinRanges?.response?.robotUinRanges;
  }
  // 需要异常处理
  async getQzoneCookies() {
    const ClientKeyData = await this.forceFetchClientKey();
    const requestUrl = "https://ssl.ptlogin2.qq.com/jump?ptlang=1033&clientuin=" + this.core.selfInfo.uin + "&clientkey=" + ClientKeyData.clientKey + "&u1=https%3A%2F%2Fuser.qzone.qq.com%2F" + this.core.selfInfo.uin + "%2Finfocenter&keyindex=19%27";
    return await RequestUtil.HttpsGetCookies(requestUrl);
  }
  // 需要异常处理
  async getSKey() {
    const ClientKeyData = await this.forceFetchClientKey();
    if (ClientKeyData.result !== 0) {
      throw new Error("getClientKey Error");
    }
    const clientKey = ClientKeyData.clientKey;
    const requestUrl = "https://ssl.ptlogin2.qq.com/jump?ptlang=1033&clientuin=" + this.core.selfInfo.uin + "&clientkey=" + clientKey + "&u1=https%3A%2F%2Fh5.qzone.qq.com%2Fqqnt%2Fqzoneinpcqq%2Ffriend%3Frefresh%3D0%26clientuin%3D0%26darkMode%3D0&keyindex=19%27";
    const cookies = await RequestUtil.HttpsGetCookies(requestUrl);
    const skey = cookies["skey"];
    if (!skey) {
      throw new Error("SKey is Empty");
    }
    return skey;
  }
  async getUidByUinV2(uin) {
    if (!uin) {
      return "";
    }
    const fallback = new Fallback((uid2) => FallbackUtil.boolchecker(uid2, uid2 !== void 0 && uid2.indexOf("*") === -1 && uid2 !== "")).add(() => this.context.session.getUixConvertService().getUid([uin]).then((data) => data.uidInfo.get(uin))).add(() => this.context.session.getProfileService().getUidByUin("FriendsServiceImpl", [uin]).get(uin)).add(() => this.context.session.getGroupService().getUidByUins([uin]).then((data) => data.uids.get(uin))).add(() => this.getUserDetailInfoByUin(uin).then((data) => data.detail.uid));
    const uid = await fallback.run().catch(() => "");
    return uid ?? "";
  }
  async getUinByUidV2(uid) {
    if (!uid) {
      return "0";
    }
    const fallback = new Fallback((uin2) => FallbackUtil.boolchecker(uin2, uin2 !== void 0 && uin2 !== "0" && uin2 !== "")).add(() => this.context.session.getUixConvertService().getUin([uid]).then((data) => data.uinInfo.get(uid))).add(() => this.context.session.getProfileService().getUinByUid("FriendsServiceImpl", [uid]).get(uid)).add(() => this.context.session.getGroupService().getUinByUids([uid]).then((data) => data.uins.get(uid))).add(() => this.getUserDetailInfo(uid).then((data) => data.uin));
    const uin = await fallback.run().catch(() => "0");
    return uin ?? "0";
  }
  async getRecentContactListSnapShot(count) {
    return await this.context.session.getRecentContactService().getRecentContactListSnapShot(count);
  }
  async getRecentContactListSyncLimit(count) {
    return await this.context.session.getRecentContactService().getRecentContactListSyncLimit(count);
  }
  async getRecentContactListSync() {
    return await this.context.session.getRecentContactService().getRecentContactListSync();
  }
  async getRecentContactList() {
    return await this.context.session.getRecentContactService().getRecentContactList();
  }
  async getUserDetailInfoByUin(Uin) {
    return await this.core.eventWrapper.callNoListenerEvent(
      "NodeIKernelProfileService/getUserDetailInfoByUin",
      Uin
    );
  }
  async forceFetchClientKey() {
    return await this.context.session.getTicketService().forceFetchClientKey("");
  }
}

function qunAlbumControl({
  uin,
  group_id,
  pskey,
  pic_md5,
  img_size,
  img_name,
  sAlbumName,
  sAlbumID,
  photo_num = "1",
  video_num = "0",
  batch_num = "1"
}) {
  const timestamp = Math.floor(Date.now() / 1e3);
  return {
    control_req: [
      {
        uin,
        token: {
          type: 4,
          data: pskey,
          appid: 5
        },
        appid: "qun",
        checksum: pic_md5,
        check_type: 0,
        file_len: img_size,
        env: {
          refer: "qzone",
          deviceInfo: "h5"
        },
        model: 0,
        biz_req: {
          sPicTitle: img_name,
          sPicDesc: "",
          sAlbumName,
          sAlbumID,
          iAlbumTypeID: 0,
          iBitmap: 0,
          iUploadType: 0,
          iUpPicType: 0,
          iBatchID: timestamp,
          sPicPath: "",
          iPicWidth: 0,
          iPicHight: 0,
          iWaterType: 0,
          iDistinctUse: 0,
          iNeedFeeds: 1,
          iUploadTime: timestamp,
          mapExt: {
            appid: "qun",
            userid: group_id
          },
          stExtendInfo: {
            mapParams: {
              photo_num,
              video_num,
              batch_num
            }
          }
        },
        session: "",
        asy_upload: 0,
        cmd: "FileUpload"
      }
    ]
  };
}

function createAlbumMediaFeed(uin, albumId, lloc) {
  return {
    cell_common: {
      time: ""
    },
    cell_user_info: {
      user: {
        uin
      }
    },
    cell_media: {
      album_id: albumId,
      batch_id: "",
      media_items: [{
        image: {
          lloc
        }
      }]
    }
  };
}
function createAlbumCommentRequest(uin, content, client_key) {
  return {
    client_key,
    // 暂时只支持纯文本吧
    content: [{
      type: 0 /* KRICHMSGTYPEPLAINTEXT */,
      content,
      who: 0,
      uid: "",
      name: "",
      url: ""
    }],
    user: {
      uin
    }
  };
}
function createAlbumFeedPublish(qunId, uin, albumId, lloc, sloc) {
  return {
    cell_common: {
      time: Date.now(),
      feed_id: ""
    },
    cell_user_info: {
      user: {
        uin
      }
    },
    cell_media: {
      album_id: albumId,
      batch_id: 0,
      media_items: [{
        type: 0,
        image: {
          lloc,
          sloc: sloc || lloc
        }
      }]
    },
    cell_qun_info: {
      qun_id: qunId
    }
  };
}

class NTQQWebApi {
  context;
  core;
  constructor(context, core) {
    this.context = context;
    this.core = core;
  }
  async shareDigest(groupCode, msgSeq, msgRandom, targetGroupCode) {
    const cookieObject = await this.core.apis.UserApi.getCookies("qun.qq.com");
    const url = `https://qun.qq.com/cgi-bin/group_digest/share_digest?${new URLSearchParams({
      bkn: this.getBknFromCookie(cookieObject),
      group_code: groupCode,
      msg_seq: msgSeq,
      msg_random: msgRandom,
      target_group_code: targetGroupCode
    }).toString()}`;
    try {
      return RequestUtil.HttpGetText(url, "GET", "", { Cookie: this.cookieToString(cookieObject) });
    } catch {
      return void 0;
    }
  }
  async getGroupEssenceMsgAll(GroupCode) {
    const ret = [];
    for (let i = 0; i < 20; i++) {
      const data = await this.getGroupEssenceMsg(GroupCode, i, 50);
      if (!data) break;
      ret.push(data);
      if (data.data.is_end) break;
    }
    return ret;
  }
  async getGroupEssenceMsg(GroupCode, page_start = 0, page_limit = 50) {
    const cookieObject = await this.core.apis.UserApi.getCookies("qun.qq.com");
    const url = `https://qun.qq.com/cgi-bin/group_digest/digest_list?${new URLSearchParams({
      bkn: this.getBknFromCookie(cookieObject),
      page_start: page_start.toString(),
      page_limit: page_limit.toString(),
      group_code: GroupCode
    }).toString()}`;
    try {
      const ret = await RequestUtil.HttpGetJson(
        url,
        "GET",
        "",
        { Cookie: this.cookieToString(cookieObject) }
      );
      return ret.retcode === 0 ? ret : void 0;
    } catch {
      return void 0;
    }
  }
  async getGroupMembers(GroupCode) {
    const memberData = new Array();
    const cookieObject = await this.core.apis.UserApi.getCookies("qun.qq.com");
    const retList = [];
    const fastRet = await RequestUtil.HttpGetJson(
      `https://qun.qq.com/cgi-bin/qun_mgr/search_group_members?${new URLSearchParams({
        st: "0",
        end: "40",
        sort: "1",
        gc: GroupCode,
        bkn: this.getBknFromCookie(cookieObject)
      }).toString()}`,
      "POST",
      "",
      { Cookie: this.cookieToString(cookieObject) }
    );
    if (!fastRet?.count || fastRet?.errcode !== 0 || !fastRet?.mems) {
      return [];
    } else {
      for (const key in fastRet.mems) {
        if (fastRet.mems[key]) {
          memberData.push(fastRet.mems[key]);
        }
      }
    }
    const PageNum = Math.ceil(fastRet.count / 40);
    for (let i = 2; i <= PageNum; i++) {
      const ret = RequestUtil.HttpGetJson(
        `https://qun.qq.com/cgi-bin/qun_mgr/search_group_members?${new URLSearchParams({
          st: ((i - 1) * 40).toString(),
          end: (i * 40).toString(),
          sort: "1",
          gc: GroupCode,
          bkn: this.getBknFromCookie(cookieObject)
        }).toString()}`,
        "POST",
        "",
        { Cookie: this.cookieToString(cookieObject) }
      );
      retList.push(ret);
    }
    for (let i = 1; i <= PageNum; i++) {
      const ret = await retList[i];
      if (!ret?.count || ret?.errcode !== 0 || !ret?.mems) {
        continue;
      }
      for (const key in ret.mems) {
        if (ret.mems[key]) {
          memberData.push(ret.mems[key]);
        }
      }
    }
    return memberData;
  }
  // public  async addGroupDigest(groupCode: string, msgSeq: string) {
  //   const url = `https://qun.qq.com/cgi-bin/group_digest/cancel_digest?random=665&X-CROSS-ORIGIN=fetch&group_code=${groupCode}&msg_seq=${msgSeq}&msg_random=444021292`;
  //   const res = await this.request(url);
  //   return await res.json();
  // }
  // public async getGroupDigest(groupCode: string) {
  //   const url = `https://qun.qq.com/cgi-bin/group_digest/digest_list?random=665&X-CROSS-ORIGIN=fetch&group_code=${groupCode}&page_start=0&page_limit=20`;
  //   const res = await this.request(url);
  //   return await res.json();
  // }
  async setGroupNotice(GroupCode, Content, pinned = 0, type = 1, is_show_edit_card = 1, tip_window_type = 1, confirm_required = 1, picId = "", imgWidth = 540, imgHeight = 300) {
    const cookieObject = await this.core.apis.UserApi.getCookies("qun.qq.com");
    try {
      const settings = JSON.stringify({
        is_show_edit_card,
        tip_window_type,
        confirm_required
      });
      const externalParam = {
        pic: picId,
        imgWidth: imgWidth.toString(),
        imgHeight: imgHeight.toString()
      };
      const ret = await RequestUtil.HttpGetJson(
        `https://web.qun.qq.com/cgi-bin/announce/add_qun_notice?${new URLSearchParams({
          bkn: this.getBknFromCookie(cookieObject),
          qid: GroupCode,
          text: Content,
          pinned: pinned.toString(),
          type: type.toString(),
          settings,
          ...picId === "" ? {} : externalParam
        }).toString()}`,
        "POST",
        "",
        { Cookie: this.cookieToString(cookieObject) }
      );
      return ret;
    } catch {
      return void 0;
    }
  }
  async getGroupNotice(GroupCode) {
    const cookieObject = await this.core.apis.UserApi.getCookies("qun.qq.com");
    try {
      const ret = await RequestUtil.HttpGetJson(
        `https://web.qun.qq.com/cgi-bin/announce/get_t_list?${new URLSearchParams({
          bkn: this.getBknFromCookie(cookieObject),
          qid: GroupCode,
          ft: "23",
          ni: "1",
          n: "1",
          i: "1",
          log_read: "1",
          platform: "1",
          s: "-1"
        }).toString()}&n=20`,
        "GET",
        "",
        { Cookie: this.cookieToString(cookieObject) }
      );
      return ret?.ec === 0 ? ret : void 0;
    } catch {
      return void 0;
    }
  }
  async getDataInternal(cookieObject, groupCode, type) {
    let resJson;
    try {
      const res = await RequestUtil.HttpGetText(
        `https://qun.qq.com/interactive/honorlist?${new URLSearchParams({
          gc: groupCode,
          type: type.toString()
        }).toString()}`,
        "GET",
        "",
        { Cookie: this.cookieToString(cookieObject) }
      );
      const match = /window\.__INITIAL_STATE__=(.*?);/.exec(res);
      if (match?.[1]) {
        resJson = JSON.parse(match[1].trim());
      }
      return type === 1 ? resJson?.talkativeList : resJson?.actorList;
    } catch (e) {
      this.context.logger.logDebug("获取当前群荣耀失败", e);
      return void 0;
    }
  }
  async getHonorList(cookieObject, groupCode, type) {
    const data = await this.getDataInternal(cookieObject, groupCode, type);
    if (!data) {
      this.context.logger.logError(`获取类型 ${type} 的荣誉信息失败`);
      return [];
    }
    return data.map((item) => ({
      user_id: item?.uin,
      nickname: item?.name,
      avatar: item?.avatar,
      description: item?.desc
    }));
  }
  async getGroupHonorInfo(groupCode, getType) {
    const cookieObject = await this.core.apis.UserApi.getCookies("qun.qq.com");
    const HonorInfo = {
      group_id: Number(groupCode),
      current_talkative: {},
      talkative_list: [],
      performer_list: [],
      legend_list: [],
      emotion_list: [],
      strong_newbie_list: []
    };
    if (getType === WebHonorType.TALKATIVE || getType === WebHonorType.ALL) {
      const talkativeList = await this.getHonorList(cookieObject, groupCode, 1);
      if (talkativeList.length > 0) {
        HonorInfo.current_talkative = talkativeList[0];
        HonorInfo.talkative_list = talkativeList;
      }
    }
    if (getType === WebHonorType.PERFORMER || getType === WebHonorType.ALL) {
      HonorInfo.performer_list = await this.getHonorList(cookieObject, groupCode, 2);
    }
    if (getType === WebHonorType.LEGEND || getType === WebHonorType.ALL) {
      HonorInfo.legend_list = await this.getHonorList(cookieObject, groupCode, 3);
    }
    if (getType === WebHonorType.EMOTION || getType === WebHonorType.ALL) {
      HonorInfo.emotion_list = await this.getHonorList(cookieObject, groupCode, 6);
    }
    if (getType === WebHonorType.EMOTION || getType === WebHonorType.ALL) {
      HonorInfo.strong_newbie_list = [];
    }
    return HonorInfo;
  }
  cookieToString(cookieObject) {
    return Object.entries(cookieObject).map(([key, value]) => `${key}=${value}`).join("; ");
  }
  getBknFromCookie(cookieObject) {
    const sKey = cookieObject["skey"];
    let hash = 5381;
    for (let i = 0; i < sKey.length; i++) {
      const code = sKey.charCodeAt(i);
      hash = hash + (hash << 5) + code;
    }
    return (hash & 2147483647).toString();
  }
  getBknFromSKey(sKey) {
    let hash = 5381;
    for (let i = 0; i < sKey.length; i++) {
      const code = sKey.charCodeAt(i);
      hash = hash + (hash << 5) + code;
    }
    return (hash & 2147483647).toString();
  }
  async getAlbumListByNTQQ(gc) {
    return await this.context.session.getAlbumService().getAlbumList({
      qun_id: gc,
      attach_info: "",
      seq: 3331,
      request_time_line: {
        request_invoke_time: "0"
      }
    });
  }
  async getAlbumList(gc) {
    const skey = await this.core.apis.UserApi.getSKey() || "";
    const pskey = (await this.core.apis.UserApi.getPSkey(["qzone.qq.com"])).domainPskeyMap.get("qzone.qq.com") || "";
    const bkn = this.getBknFromSKey(skey);
    const uin = this.core.selfInfo.uin || "10001";
    const cookies = `p_uin=o${this.core.selfInfo.uin}; p_skey=${pskey}; skey=${skey}; uin=o${uin} `;
    const api = "https://h5.qzone.qq.com/proxy/domain/u.photo.qzone.qq.com/cgi-bin/upp/qun_list_album_v2?";
    const params = new URLSearchParams({
      random: "7570",
      g_tk: bkn,
      format: "json",
      inCharset: "utf-8",
      outCharset: "utf-8",
      qua: "V1_IPH_SQ_6.2.0_0_HDBM_T",
      cmd: "qunGetAlbumList",
      qunId: gc,
      qunid: gc,
      start: "0",
      num: "1000",
      uin,
      getMemberRole: "0"
    });
    const response = await RequestUtil.HttpGetJson(api + params.toString(), "GET", "", {
      Cookie: cookies
    });
    return response.data.album;
  }
  async createQunAlbumSession(gc, sAlbumID, sAlbumName, path, skey, pskey, img_md5, uin) {
    const img = readFileSync(path);
    const img_size = img.length;
    const img_name = basename(path);
    const GTK = this.getBknFromSKey(skey);
    const cookie = `p_uin=o${uin}; p_skey=${pskey}; skey=${skey}; uin=o${uin}`;
    const body = qunAlbumControl({
      uin,
      group_id: gc,
      pskey,
      pic_md5: img_md5,
      img_size,
      img_name,
      sAlbumName,
      sAlbumID
    });
    const api = `https://h5.qzone.qq.com/webapp/json/sliceUpload/FileBatchControl/${img_md5}?g_tk=${GTK}`;
    const post = await RequestUtil.HttpGetJson(api, "POST", body, {
      Cookie: cookie,
      "Content-Type": "application/json"
    });
    return post;
  }
  async uploadQunAlbumSlice(path, session, skey, pskey, uin, slice_size) {
    const img_size = statSync(path).size;
    let seq = 0;
    let offset = 0;
    const GTK = this.getBknFromSKey(skey);
    const cookie = `p_uin=o${uin}; p_skey=${pskey}; skey=${skey}; uin=o${uin}`;
    const stream = createReadStream(path, { highWaterMark: slice_size });
    for await (const chunk of stream) {
      const end = Math.min(offset + chunk.length, img_size);
      const form = new FormData();
      form.append("uin", uin);
      form.append("appid", "qun");
      form.append("session", session);
      form.append("offset", offset.toString());
      form.append("data", new Blob([chunk], { type: "application/octet-stream" }), "blob");
      form.append("checksum", "");
      form.append("check_type", "0");
      form.append("retry", "0");
      form.append("seq", seq.toString());
      form.append("end", end.toString());
      form.append("cmd", "FileUpload");
      form.append("slice_size", slice_size.toString());
      form.append("biz_req.iUploadType", "0");
      const api = `https://h5.qzone.qq.com/webapp/json/sliceUpload/FileUpload?seq=${seq}&retry=0&offset=${offset}&end=${end}&total=${img_size}&type=form&g_tk=${GTK}`;
      const response = await fetch(api, {
        method: "POST",
        headers: {
          Cookie: cookie
        },
        body: form
      });
      if (!response.ok) {
        throw new Error(`HTTP error! status: ${response.status}`);
      }
      const post = await response.json();
      if (post.ret !== 0) {
        throw new Error(`分片 ${seq} 上传失败: ${post.msg}`);
      }
      offset += chunk.length;
      seq++;
    }
    return { success: true, message: "上传完成" };
  }
  async uploadImageToQunAlbum(gc, sAlbumID, sAlbumName, path) {
    const skey = await this.core.apis.UserApi.getSKey() || "";
    const pskey = (await this.core.apis.UserApi.getPSkey(["qzone.qq.com"])).domainPskeyMap.get("qzone.qq.com") || "";
    const img_md5 = createHash("md5").update(readFileSync(path)).digest("hex");
    const uin = this.core.selfInfo.uin || "10001";
    const session = (await this.createQunAlbumSession(gc, sAlbumID, sAlbumName, path, skey, pskey, img_md5, uin)).data.session;
    if (!session) throw new Error("创建群相册会话失败");
    await this.uploadQunAlbumSlice(path, session, skey, pskey, uin, 16384);
  }
  async getAlbumMediaListByNTQQ(gc, albumId, attach_info = "") {
    return (await this.context.session.getAlbumService().getMediaList({
      qun_id: gc,
      attach_info,
      seq: 0,
      request_time_line: {
        request_invoke_time: "0"
      },
      album_id: albumId,
      lloc: "",
      batch_id: ""
    })).response;
  }
  async doAlbumMediaPlainCommentByNTQQ(qunId, albumId, lloc, content) {
    const random_seq = Math.floor(Math.random() * 9e3) + 1e3;
    const uin = this.core.selfInfo.uin || "10001";
    const client_key = Date.now() * 1e3;
    return await this.context.session.getAlbumService().doQunComment(
      random_seq,
      {
        map_info: [],
        map_bytes_info: [],
        map_user_account: []
      },
      qunId,
      2,
      createAlbumMediaFeed(uin, albumId, lloc),
      createAlbumCommentRequest(uin, content, client_key)
    );
  }
  async deleteAlbumMediaByNTQQ(qunId, albumId, lloc) {
    const random_seq = Math.floor(Math.random() * 9e3) + 1e3;
    return await this.context.session.getAlbumService().deleteMedias(
      random_seq,
      qunId,
      albumId,
      [lloc],
      []
    );
  }
  async doAlbumMediaLikeByNTQQ(qunId, albumId, lloc, id) {
    const random_seq = Math.floor(Math.random() * 9e3) + 1e3;
    const uin = this.core.selfInfo.uin || "10001";
    return await this.context.session.getAlbumService().doQunLike(
      random_seq,
      {
        map_info: [],
        map_bytes_info: [],
        map_user_account: []
      },
      {
        id,
        status: 1
      },
      createAlbumFeedPublish(qunId, uin, albumId, lloc)
    );
  }
}

class NTQQSystemApi {
  context;
  core;
  constructor(context, core) {
    this.context = context;
    this.core = core;
  }
  async hasOtherRunningQQProcess() {
    return this.core.util.hasOtherRunningQQProcess();
  }
  async ocrImage(filePath) {
    return this.context.session.getNodeMiscService().wantWinScreenOCR(filePath);
  }
  async translateEnWordToZn(words) {
    return this.context.session.getRichMediaService().translateEnWordToZn(words);
  }
  async getOnlineDev() {
    this.context.session.getMsgService().getOnLineDev();
  }
  async getArkJsonCollection() {
    return await this.core.eventWrapper.callNoListenerEvent("NodeIKernelCollectionService/collectionArkShare", "1717662698058");
  }
  async bootMiniApp(appFile, params) {
    await this.context.session.getNodeMiscService().setMiniAppVersion("2.16.4");
    return this.context.session.getNodeMiscService().startNewMiniApp(appFile, params);
  }
}

const offset$1 = {
  "9.9.22-40990-x64": {"send":"1B5699C","recv":"1D8CA9D"},
  "9.9.22-40824-x64": {"send":"1B5699C","recv":"1D8CA9D"},
  "9.9.22-40768-x64": {"send":"1B5699C","recv":"1D8CA9D"},
  "3.2.20-40768-x64": {"send":"2A1B840","recv":"2D28F20"},
  "3.2.20-40824-x64": {"send":"2A1B840","recv":"2D28F20"},
  "3.2.20-40990-x64": {"send":"2A1B840","recv":"2D28F20"},
  "3.2.20-40990-arm64": {"send":"157C0E8","recv":"1546658"},
  "3.2.20-40824-arm64": {"send":"157C0E8","recv":"1546658"},
  "3.2.20-40768-arm64": {"send":"157C0E8","recv":"1546658"},
  "9.9.23-41679-x64": {"send":"09FF0F4","recv":"1D1A039"},
  "6.9.82-40824-arm64": {"send":"05FA930","recv":"0B41B90"},
  "6.9.82-40768-arm64": {"send":"05FA930","recv":"0B41B90"},
  "6.9.82-40990-arm64": {"send":"05FA930","recv":"0B41B90"},
  "6.9.83-41679-arm64": {"send":"237D114","recv":"0957648"},
  "6.9.83-41785-arm64": {"send":"23B0BF0","recv":"095567C"},
  "9.9.23-41785-x64": {"send":"09FF0A4","recv":"1D19FF9"},
  "6.9.83-41857-arm64": {"send":"0815774","recv":"0958B3C"},
  "3.2.21-41857-x64": {"send":"5B44510","recv":"2FDB0B0"},
  "3.2.21-41857-arm64": {"send":"3D6EE6C","recv":"1479EDC"},
  "9.9.23-41857-x64": {"send":"0A01394","recv":"1D1C4F9"},
  "9.9.23-42086-x64": {"send":"0A01814","recv":"1D1C9B9"},
  "6.9.85-42086-arm64": {"send":"23B0330","recv":"0957648"},
  "3.2.21-42086-x64": {"send":"5B42CF0","recv":"2FDA6F0"},
  "9.9.23-42430-x64": {"send":"0A01A34","recv":"1D1CFF9"},
  "9.9.25-42744-x64": {"send":"0A0D104","recv":"1D3E7F9"},
  "6.9.85-42744-arm64": {"send":"23DFEF0","recv":"095FD80"},
  "9.9.25-42905-x64": {"send":"0A12E74","recv":"1D450FD"},
  "6.9.86-42905-arm64": {"send":"2342408","recv":"09639B8"},
  "3.2.22-42941-x64": {"send":"5BC1630","recv":"3011E00"},
  "3.2.22-42941-arm64": {"send":"3DC90AC","recv":"1497A70"},
  "9.9.25-42941-x64": {"send":"0A131D4","recv":"1D4547D"},
  "6.9.86-42941-arm64": {"send":"2346108","recv":"09675F0"},
  "9.9.26-44175-x64": {"send":"0A0F2EC","recv":"1D3AD4D"},
};

class Frame {
  static pack(head, body) {
    const totalLength = 9 + head.length + body.length + 1;
    const buffer = Buffer.allocUnsafe(totalLength);
    buffer[0] = 40;
    buffer.writeUInt32BE(head.length, 1);
    buffer.writeUInt32BE(body.length, 5);
    head.copy(buffer, 9);
    body.copy(buffer, 9 + head.length);
    buffer[totalLength - 1] = 41;
    return buffer;
  }
  static unpack(frame) {
    assert$1(frame[0] === 40 && frame[frame.length - 1] === 41, "Invalid frame!");
    const headLen = frame.readUInt32BE(1);
    const bodyLen = frame.readUInt32BE(5);
    return [frame.subarray(9, 9 + headLen), frame.subarray(9 + headLen, 9 + headLen + bodyLen)];
  }
}

({
  selfUin: ProtoField(2, ScalarType.UINT32),
  subCmd: ProtoField(3, ScalarType.UINT32),
  field6: ProtoField(6, ScalarType.UINT32)
});
({
  imPlat: ProtoField(1, ScalarType.UINT32),
  osVersion: ProtoField(2, ScalarType.STRING, true),
  qVersion: ProtoField(3, ScalarType.STRING, true)
});
({
  retCode: ProtoField(1, ScalarType.UINT32),
  errMsg: ProtoField(2, ScalarType.STRING),
  subCmd: ProtoField(3, ScalarType.UINT32)});
({
  fileName: ProtoField(1, ScalarType.STRING, false, true),
  deleteFile: ProtoField(2, ScalarType.STRING, false, true),
  bid: ProtoField(3, ScalarType.STRING),
  maxRoamSize: ProtoField(4, ScalarType.UINT32),
  emojiType: ProtoField(5, ScalarType.UINT32, false, true)
});
({
  state: ProtoField(1, ScalarType.INT32),
  sizeCache: ProtoField(2, ScalarType.INT32),
  unknownFields: ProtoField(3, ScalarType.BYTES),
  msgSeq: ProtoField(7, ScalarType.INT32),
  msgRand: ProtoField(8, ScalarType.INT32),
  syncCookie: ProtoField(9, ScalarType.BYTES),
  msgVia: ProtoField(10, ScalarType.INT32),
  dataStatist: ProtoField(11, ScalarType.INT32),
  multiSendSeq: ProtoField(13, ScalarType.INT32)
});
({
  result: ProtoField(1, ScalarType.INT32),
  errMsg: ProtoField(2, ScalarType.STRING, true),
  timestamp1: ProtoField(3, ScalarType.UINT32),
  field10: ProtoField(10, ScalarType.UINT32),
  groupSequence: ProtoField(11, ScalarType.UINT32, true),
  timestamp2: ProtoField(12, ScalarType.UINT32),
  privateSequence: ProtoField(14, ScalarType.UINT32)
});
({
  status: ProtoField(1, ScalarType.UINT32),
  extStatus: ProtoField(2, ScalarType.UINT32),
  batteryStatus: ProtoField(3, ScalarType.UINT32)});
({
  faceId: ProtoField(1, ScalarType.UINT32),
  text: ProtoField(2, ScalarType.STRING, true),
  field3: ProtoField(3, ScalarType.UINT32)
});
({
  message: ProtoField(2, ScalarType.STRING)
});
const HttpConn = {
  field1: ProtoField(1, ScalarType.INT32),
  field2: ProtoField(2, ScalarType.INT32),
  field3: ProtoField(3, ScalarType.INT32),
  field4: ProtoField(4, ScalarType.INT32),
  tgt: ProtoField(5, ScalarType.STRING),
  field6: ProtoField(6, ScalarType.INT32),
  serviceTypes: ProtoField(7, ScalarType.INT32, false, true),
  field9: ProtoField(9, ScalarType.INT32),
  field10: ProtoField(10, ScalarType.INT32),
  field11: ProtoField(11, ScalarType.INT32),
  ver: ProtoField(15, ScalarType.STRING)
};
const HttpConn0x6ff_501 = {
  httpConn: ProtoField(1281, () => HttpConn)
};
const HttpConn0x6ff_501Response = {
  httpConn: ProtoField(1281, () => HttpConnResponse)
};
const HttpConnResponse = {
  sigSession: ProtoField(1, ScalarType.BYTES),
  sessionKey: ProtoField(2, ScalarType.BYTES),
  serverInfos: ProtoField(3, () => ServerInfo, false, true)
};
const ServerAddr = {
  type: ProtoField(1, ScalarType.UINT32),
  ip: ProtoField(2, ScalarType.FIXED32),
  port: ProtoField(3, ScalarType.UINT32),
  area: ProtoField(4, ScalarType.UINT32)
};
const ServerInfo = {
  serviceType: ProtoField(1, ScalarType.UINT32),
  serverAddrs: ProtoField(2, () => ServerAddr, false, true)
};

const MiniAppAdaptShareInfoReq = {
  appId: ProtoField(2, ScalarType.STRING),
  body: ProtoField(4, () => MiniAppAdaptShareInfoReqBody)
};
const MiniAppAdaptShareInfoReqBody = {
  extInfo: ProtoField(1, () => ExtInfo),
  appid: ProtoField(2, ScalarType.STRING),
  title: ProtoField(3, ScalarType.STRING),
  desc: ProtoField(4, ScalarType.STRING),
  time: ProtoField(5, ScalarType.UINT64),
  scene: ProtoField(6, ScalarType.UINT32),
  templateType: ProtoField(7, ScalarType.UINT32),
  businessType: ProtoField(8, ScalarType.UINT32),
  picUrl: ProtoField(9, ScalarType.STRING),
  vidUrl: ProtoField(10, ScalarType.STRING),
  jumpUrl: ProtoField(11, ScalarType.STRING),
  iconUrl: ProtoField(12, ScalarType.STRING),
  verType: ProtoField(13, ScalarType.UINT32),
  shareType: ProtoField(14, ScalarType.UINT32),
  versionId: ProtoField(15, ScalarType.STRING),
  withShareTicket: ProtoField(16, ScalarType.UINT32),
  webURL: ProtoField(17, ScalarType.STRING),
  appidRich: ProtoField(18, ScalarType.BYTES),
  template: ProtoField(19, () => Template),
  field20: ProtoField(20, ScalarType.STRING)
};
const ExtInfo = {
  field2: ProtoField(2, ScalarType.BYTES)
};
const Template = {
  templateId: ProtoField(1, ScalarType.STRING),
  templateData: ProtoField(2, ScalarType.STRING)
};
const MiniAppAdaptShareInfoResp = {
  field2: ProtoField(2, ScalarType.UINT32),
  field3: ProtoField(3, ScalarType.STRING),
  content: ProtoField(4, () => MiniAppAdaptShareInfoRespContent)
};
const MiniAppAdaptShareInfoRespContent = {
  jsonContent: ProtoField(2, ScalarType.STRING)
};

const DataHighwayHead = {
  version: ProtoField(1, ScalarType.UINT32),
  uin: ProtoField(2, ScalarType.STRING, true),
  command: ProtoField(3, ScalarType.STRING, true),
  seq: ProtoField(4, ScalarType.UINT32, true),
  retryTimes: ProtoField(5, ScalarType.UINT32, true),
  appId: ProtoField(6, ScalarType.UINT32),
  dataFlag: ProtoField(7, ScalarType.UINT32),
  commandId: ProtoField(8, ScalarType.UINT32),
  buildVer: ProtoField(9, ScalarType.BYTES, true)
};
const FileUploadExt = {
  unknown1: ProtoField(1, ScalarType.INT32),
  unknown2: ProtoField(2, ScalarType.INT32),
  unknown3: ProtoField(3, ScalarType.INT32),
  entry: ProtoField(100, () => FileUploadEntry),
  unknown200: ProtoField(200, ScalarType.INT32)
};
const FileUploadEntry = {
  busiBuff: ProtoField(100, () => ExcitingBusiInfo),
  fileEntry: ProtoField(200, () => ExcitingFileEntry),
  clientInfo: ProtoField(300, () => ExcitingClientInfo),
  fileNameInfo: ProtoField(400, () => ExcitingFileNameInfo),
  host: ProtoField(500, () => ExcitingHostConfig)
};
const ExcitingBusiInfo = {
  busId: ProtoField(1, ScalarType.INT32),
  senderUin: ProtoField(100, ScalarType.UINT64),
  receiverUin: ProtoField(200, ScalarType.UINT64),
  groupCode: ProtoField(400, ScalarType.UINT64)
};
const ExcitingFileEntry = {
  fileSize: ProtoField(100, ScalarType.UINT64),
  md5: ProtoField(200, ScalarType.BYTES),
  checkKey: ProtoField(300, ScalarType.BYTES),
  md5S2: ProtoField(400, ScalarType.BYTES),
  fileId: ProtoField(600, ScalarType.STRING),
  uploadKey: ProtoField(700, ScalarType.BYTES)
};
const ExcitingClientInfo = {
  clientType: ProtoField(100, ScalarType.INT32),
  appId: ProtoField(200, ScalarType.STRING),
  terminalType: ProtoField(300, ScalarType.INT32),
  clientVer: ProtoField(400, ScalarType.STRING),
  unknown: ProtoField(600, ScalarType.INT32)
};
const ExcitingFileNameInfo = {
  fileName: ProtoField(100, ScalarType.STRING)
};
const ExcitingHostConfig = {
  hosts: ProtoField(200, () => ExcitingHostInfo, false, true)
};
const ExcitingHostInfo = {
  url: ProtoField(1, () => ExcitingUrlInfo),
  port: ProtoField(2, ScalarType.UINT32)
};
const ExcitingUrlInfo = {
  unknown: ProtoField(1, ScalarType.INT32),
  host: ProtoField(2, ScalarType.STRING)
};
const LoginSigHead = {
  uint32LoginSigType: ProtoField(1, ScalarType.UINT32),
  bytesLoginSig: ProtoField(2, ScalarType.BYTES),
  appId: ProtoField(3, ScalarType.UINT32)
};
const NTV2RichMediaHighwayExt = {
  fileUuid: ProtoField(1, ScalarType.STRING),
  uKey: ProtoField(2, ScalarType.STRING),
  network: ProtoField(5, () => NTHighwayNetwork),
  msgInfoBody: ProtoField(6, () => MsgInfoBody, false, true),
  blockSize: ProtoField(10, ScalarType.UINT32),
  hash: ProtoField(11, () => NTHighwayHash)
};
const NTHighwayHash = {
  fileSha1: ProtoField(1, ScalarType.BYTES, false, true)
};
const NTHighwayNetwork = {
  ipv4s: ProtoField(1, () => NTHighwayIPv4, false, true)
};
const NTHighwayIPv4 = {
  domain: ProtoField(1, () => NTHighwayDomain),
  port: ProtoField(2, ScalarType.UINT32)
};
const NTHighwayDomain = {
  isEnable: ProtoField(1, ScalarType.BOOL),
  ip: ProtoField(2, ScalarType.STRING)
};
const ReqDataHighwayHead = {
  msgBaseHead: ProtoField(1, () => DataHighwayHead, true),
  msgSegHead: ProtoField(2, () => SegHead, true),
  bytesReqExtendInfo: ProtoField(3, ScalarType.BYTES, true),
  timestamp: ProtoField(4, ScalarType.UINT64),
  msgLoginSigHead: ProtoField(5, () => LoginSigHead, true)
};
const RespDataHighwayHead = {
  msgBaseHead: ProtoField(1, () => DataHighwayHead, true),
  msgSegHead: ProtoField(2, () => SegHead, true),
  errorCode: ProtoField(3, ScalarType.UINT32),
  allowRetry: ProtoField(4, ScalarType.UINT32),
  cacheCost: ProtoField(5, ScalarType.UINT32),
  htCost: ProtoField(6, ScalarType.UINT32),
  bytesRspExtendInfo: ProtoField(7, ScalarType.BYTES, true),
  timestamp: ProtoField(8, ScalarType.UINT64),
  range: ProtoField(9, ScalarType.UINT64),
  isReset: ProtoField(10, ScalarType.UINT32)
};
const SegHead = {
  serviceId: ProtoField(1, ScalarType.UINT32, true),
  filesize: ProtoField(2, ScalarType.UINT64),
  dataOffset: ProtoField(3, ScalarType.UINT64, true),
  dataLength: ProtoField(4, ScalarType.UINT32),
  retCode: ProtoField(5, ScalarType.UINT32, true),
  serviceTicket: ProtoField(6, ScalarType.BYTES),
  flag: ProtoField(7, ScalarType.UINT32, true),
  md5: ProtoField(8, ScalarType.BYTES),
  fileMd5: ProtoField(9, ScalarType.BYTES),
  cacheAddr: ProtoField(10, ScalarType.UINT32, true),
  queryTimes: ProtoField(11, ScalarType.UINT32),
  updateCacheIp: ProtoField(12, ScalarType.UINT32),
  cachePort: ProtoField(13, ScalarType.UINT32, true)
};
({
  type: ProtoField(1, ScalarType.UINT32),
  groupUin: ProtoField(2, ScalarType.UINT32),
  field5: ProtoField(5, ScalarType.UINT32),
  field6: ProtoField(6, ScalarType.UINT32)
});
({
  field1: ProtoField(1, ScalarType.UINT32)
});

const LongMsgResult = {
  action: ProtoField(2, () => LongMsgAction, false, true)
};
const LongMsgAction = {
  actionCommand: ProtoField(1, ScalarType.STRING),
  actionData: ProtoField(2, () => LongMsgContent)
};
const LongMsgContent = {
  msgBody: ProtoField(1, () => PushMsgBody, false, true)
};
const RecvLongMsgReq = {
  info: ProtoField(1, () => RecvLongMsgInfo, true),
  settings: ProtoField(15, () => LongMsgSettings, true)
};
const RecvLongMsgInfo = {
  uid: ProtoField(1, () => LongMsgUid, true),
  resId: ProtoField(2, ScalarType.STRING, true),
  acquire: ProtoField(3, ScalarType.BOOL)
};
const LongMsgUid = {
  uid: ProtoField(2, ScalarType.STRING, true)
};
const LongMsgSettings = {
  field1: ProtoField(1, ScalarType.UINT32),
  field2: ProtoField(2, ScalarType.UINT32),
  field3: ProtoField(3, ScalarType.UINT32),
  field4: ProtoField(4, ScalarType.UINT32)
};
const RecvLongMsgResp = {
  result: ProtoField(1, () => RecvLongMsgResult),
  settings: ProtoField(15, () => LongMsgSettings)
};
const RecvLongMsgResult = {
  resId: ProtoField(3, ScalarType.STRING),
  payload: ProtoField(4, ScalarType.BYTES)
};
const SendLongMsgReq = {
  info: ProtoField(2, () => SendLongMsgInfo),
  settings: ProtoField(15, () => LongMsgSettings)
};
const SendLongMsgInfo = {
  type: ProtoField(1, ScalarType.UINT32),
  uid: ProtoField(2, () => LongMsgUid, true),
  groupUin: ProtoField(3, ScalarType.UINT32, true),
  payload: ProtoField(4, ScalarType.BYTES, true)
};
const SendLongMsgResp = {
  result: ProtoField(2, () => SendLongMsgResult),
  settings: ProtoField(15, () => LongMsgSettings)
};
const SendLongMsgResult = {
  resId: ProtoField(3, ScalarType.STRING)
};
const SsoGetGroupMsg = {
  info: ProtoField(1, () => SsoGetGroupMsgInfo),
  direction: ProtoField(2, ScalarType.BOOL)
};
const SsoGetGroupMsgInfo = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  startSequence: ProtoField(2, ScalarType.UINT32),
  endSequence: ProtoField(3, ScalarType.UINT32)
};
const SsoGetGroupMsgResponse = {
  body: ProtoField(3, () => SsoGetGroupMsgResponseBody)
};
const SsoGetGroupMsgResponseBody = {
  groupUin: ProtoField(3, ScalarType.UINT32),
  startSequence: ProtoField(4, ScalarType.UINT32),
  endSequence: ProtoField(5, ScalarType.UINT32),
  messages: ProtoField(6, () => PushMsgBody, false, true)
};
({
  friendUid: ProtoField(1, ScalarType.STRING, true),
  time: ProtoField(2, ScalarType.UINT32),
  random: ProtoField(3, ScalarType.UINT32),
  count: ProtoField(4, ScalarType.UINT32),
  direction: ProtoField(5, ScalarType.BOOL)
});
({
  friendUid: ProtoField(3, ScalarType.STRING),
  timestamp: ProtoField(5, ScalarType.UINT32),
  random: ProtoField(6, ScalarType.UINT32)});
const SsoGetC2cMsg = {
  friendUid: ProtoField(2, ScalarType.STRING, true),
  startSequence: ProtoField(3, ScalarType.UINT32),
  endSequence: ProtoField(4, ScalarType.UINT32)
};
const SsoGetC2cMsgResponse = {
  friendUid: ProtoField(4, ScalarType.STRING),
  messages: ProtoField(7, () => PushMsgBody, false, true)
};

({
  uin: ProtoField(1, ScalarType.UINT32, true),
  uid: ProtoField(2, ScalarType.STRING, true),
  field3: ProtoField(3, ScalarType.UINT32, true),
  sig: ProtoField(4, ScalarType.UINT32, true),
  receiverUin: ProtoField(5, ScalarType.UINT32, true),
  receiverUid: ProtoField(6, ScalarType.STRING, true)
});

const Attr = {
  codePage: ProtoField(1, ScalarType.INT32),
  time: ProtoField(2, ScalarType.INT32),
  random: ProtoField(3, ScalarType.INT32),
  color: ProtoField(4, ScalarType.INT32),
  size: ProtoField(5, ScalarType.INT32),
  effect: ProtoField(6, ScalarType.INT32),
  charSet: ProtoField(7, ScalarType.INT32),
  pitchAndFamily: ProtoField(8, ScalarType.INT32),
  fontName: ProtoField(9, ScalarType.STRING),
  reserveData: ProtoField(10, ScalarType.BYTES)
};
const NotOnlineFile = {
  fileType: ProtoField(1, ScalarType.INT32, true),
  sig: ProtoField(2, ScalarType.BYTES, true),
  fileUuid: ProtoField(3, ScalarType.STRING, true),
  fileMd5: ProtoField(4, ScalarType.BYTES, true),
  fileName: ProtoField(5, ScalarType.STRING, true),
  fileSize: ProtoField(6, ScalarType.INT64, true),
  note: ProtoField(7, ScalarType.BYTES, true),
  reserved: ProtoField(8, ScalarType.INT32, true),
  subcmd: ProtoField(9, ScalarType.INT32, true),
  microCloud: ProtoField(10, ScalarType.INT32, true),
  bytesFileUrls: ProtoField(11, ScalarType.BYTES, false, true),
  downloadFlag: ProtoField(12, ScalarType.INT32, true),
  dangerEvel: ProtoField(50, ScalarType.INT32, true),
  lifeTime: ProtoField(51, ScalarType.INT32, true),
  uploadTime: ProtoField(52, ScalarType.INT32, true),
  absFileType: ProtoField(53, ScalarType.INT32, true),
  clientType: ProtoField(54, ScalarType.INT32, true),
  expireTime: ProtoField(55, ScalarType.INT32, true),
  pbReserve: ProtoField(56, ScalarType.BYTES, true),
  fileHash: ProtoField(57, ScalarType.STRING, true)
};
const Ptt = {
  fileType: ProtoField(1, ScalarType.INT32),
  srcUin: ProtoField(2, ScalarType.UINT64),
  fileUuid: ProtoField(3, ScalarType.STRING),
  fileMd5: ProtoField(4, ScalarType.BYTES),
  fileName: ProtoField(5, ScalarType.STRING),
  fileSize: ProtoField(6, ScalarType.INT32),
  reserve: ProtoField(7, ScalarType.BYTES),
  fileId: ProtoField(8, ScalarType.INT32),
  serverIp: ProtoField(9, ScalarType.INT32),
  serverPort: ProtoField(10, ScalarType.INT32),
  boolValid: ProtoField(11, ScalarType.BOOL),
  signature: ProtoField(12, ScalarType.BYTES),
  shortcut: ProtoField(13, ScalarType.BYTES),
  fileKey: ProtoField(14, ScalarType.BYTES),
  magicPttIndex: ProtoField(15, ScalarType.INT32),
  voiceSwitch: ProtoField(16, ScalarType.INT32),
  pttUrl: ProtoField(17, ScalarType.BYTES),
  groupFileKey: ProtoField(18, ScalarType.STRING),
  time: ProtoField(19, ScalarType.INT32),
  downPara: ProtoField(20, ScalarType.BYTES),
  format: ProtoField(29, ScalarType.INT32),
  pbReserve: ProtoField(30, ScalarType.BYTES),
  bytesPttUrls: ProtoField(31, ScalarType.BYTES, false, true),
  downloadFlag: ProtoField(32, ScalarType.INT32)
};
const RichText = {
  attr: ProtoField(1, () => Attr, true),
  elems: ProtoField(2, () => Elem, false, true),
  notOnlineFile: ProtoField(3, () => NotOnlineFile, true),
  ptt: ProtoField(4, () => Ptt, true)
};
({
  id: ProtoField(1, ScalarType.STRING)});
({
  label: ProtoField(1, ScalarType.STRING),
  visitedLabel: ProtoField(2, ScalarType.STRING),
  style: ProtoField(3, ScalarType.INT32)
});
({
  type: ProtoField(1, ScalarType.INT32),
  unsupportTips: ProtoField(4, ScalarType.STRING),
  data: ProtoField(5, ScalarType.STRING),
  reply: ProtoField(7, ScalarType.BOOL),
  enter: ProtoField(8, ScalarType.BOOL)
});
({
  type: ProtoField(1, ScalarType.INT32),
  specifyRoleIds: ProtoField(2, ScalarType.STRING, false, true),
  specifyUserIds: ProtoField(3, ScalarType.STRING, false, true)
});
const FileExtra = {
  file: ProtoField(1, () => NotOnlineFile),
  field6: ProtoField(6, () => PrivateFileExtra)
};
const PrivateFileExtra = {
  field2: ProtoField(2, () => PrivateFileExtraField2)
};
const PrivateFileExtraField2 = {
  field1: ProtoField(1, ScalarType.UINT32),
  fileUuid: ProtoField(4, ScalarType.STRING),
  fileName: ProtoField(5, ScalarType.STRING),
  field6: ProtoField(6, ScalarType.UINT32),
  field7: ProtoField(7, ScalarType.BYTES),
  field8: ProtoField(8, ScalarType.BYTES),
  timestamp1: ProtoField(9, ScalarType.UINT32),
  fileHash: ProtoField(14, ScalarType.STRING),
  selfUid: ProtoField(15, ScalarType.STRING),
  destUid: ProtoField(16, ScalarType.STRING)
};
const GroupFileExtra = {
  field1: ProtoField(1, ScalarType.UINT32),
  fileName: ProtoField(2, ScalarType.STRING),
  display: ProtoField(3, ScalarType.STRING),
  inner: ProtoField(7, () => GroupFileExtraInner)
};
const GroupFileExtraInner = {
  info: ProtoField(2, () => GroupFileExtraInfo)
};
const GroupFileExtraInfo = {
  busId: ProtoField(1, ScalarType.UINT32),
  fileId: ProtoField(2, ScalarType.STRING),
  fileSize: ProtoField(3, ScalarType.UINT64),
  fileName: ProtoField(4, ScalarType.STRING),
  field5: ProtoField(5, ScalarType.UINT32),
  fileSha: ProtoField(6, ScalarType.BYTES),
  extInfoString: ProtoField(7, ScalarType.STRING),
  fileMd5: ProtoField(8, ScalarType.BYTES)
};
({
  origUrl: ProtoField(30, ScalarType.STRING)
});
({
  type: ProtoField(1, ScalarType.UINT32),
  field7: ProtoField(7, ScalarType.UINT32),
  field8: ProtoField(8, ScalarType.UINT32)
});

const Elem = {
  text: ProtoField(1, () => Text, true),
  face: ProtoField(2, () => Face, true),
  onlineImage: ProtoField(3, () => OnlineImage, true),
  notOnlineImage: ProtoField(4, () => NotOnlineImage, true),
  transElem: ProtoField(5, () => TransElem, true),
  marketFace: ProtoField(6, () => MarketFace, true),
  customFace: ProtoField(8, () => CustomFace, true),
  elemFlags2: ProtoField(9, () => ElemFlags2, true),
  richMsg: ProtoField(12, () => RichMsg, true),
  groupFile: ProtoField(13, () => GroupFile, true),
  extraInfo: ProtoField(16, () => ExtraInfo, true),
  videoFile: ProtoField(19, () => VideoFile, true),
  anonymousGroupMessage: ProtoField(21, () => AnonymousGroupMessage, true),
  customElem: ProtoField(31, () => CustomElem, true),
  generalFlags: ProtoField(37, () => GeneralFlags, true),
  srcMsg: ProtoField(45, () => SrcMsg, true),
  lightAppElem: ProtoField(51, () => LightAppElem, true),
  commonElem: ProtoField(53, () => CommonElem, true)
};
const Text = {
  str: ProtoField(1, ScalarType.STRING, true),
  lint: ProtoField(2, ScalarType.STRING, true),
  attr6Buf: ProtoField(3, ScalarType.BYTES, true),
  attr7Buf: ProtoField(4, ScalarType.BYTES, true),
  buf: ProtoField(11, ScalarType.BYTES, true),
  pbReserve: ProtoField(12, ScalarType.BYTES, true)
};
const Face = {
  index: ProtoField(1, ScalarType.INT32, true),
  old: ProtoField(2, ScalarType.BYTES, true),
  buf: ProtoField(11, ScalarType.BYTES, true)
};
const OnlineImage = {
  guid: ProtoField(1, ScalarType.BYTES),
  filePath: ProtoField(2, ScalarType.BYTES),
  oldVerSendFile: ProtoField(3, ScalarType.BYTES)
};
const NotOnlineImage = {
  filePath: ProtoField(1, ScalarType.STRING),
  fileLen: ProtoField(2, ScalarType.UINT32),
  downloadPath: ProtoField(3, ScalarType.STRING),
  oldVerSendFile: ProtoField(4, ScalarType.BYTES),
  imgType: ProtoField(5, ScalarType.INT32),
  previewsImage: ProtoField(6, ScalarType.BYTES),
  picMd5: ProtoField(7, ScalarType.BYTES),
  picHeight: ProtoField(8, ScalarType.UINT32),
  picWidth: ProtoField(9, ScalarType.UINT32),
  resId: ProtoField(10, ScalarType.STRING),
  flag: ProtoField(11, ScalarType.BYTES),
  thumbUrl: ProtoField(12, ScalarType.STRING),
  original: ProtoField(13, ScalarType.INT32),
  bigUrl: ProtoField(14, ScalarType.STRING),
  origUrl: ProtoField(15, ScalarType.STRING),
  bizType: ProtoField(16, ScalarType.INT32),
  result: ProtoField(17, ScalarType.INT32),
  index: ProtoField(18, ScalarType.INT32),
  opFaceBuf: ProtoField(19, ScalarType.BYTES),
  oldPicMd5: ProtoField(20, ScalarType.BOOL),
  thumbWidth: ProtoField(21, ScalarType.INT32),
  thumbHeight: ProtoField(22, ScalarType.INT32),
  fileId: ProtoField(23, ScalarType.INT32),
  showLen: ProtoField(24, ScalarType.UINT32),
  downloadLen: ProtoField(25, ScalarType.UINT32),
  x400Url: ProtoField(26, ScalarType.STRING),
  x400Width: ProtoField(27, ScalarType.INT32),
  x400Height: ProtoField(28, ScalarType.INT32),
  pbRes: ProtoField(29, () => NotOnlineImage_PbReserve)
};
const NotOnlineImage_PbReserve = {
  subType: ProtoField(1, ScalarType.INT32),
  field3: ProtoField(3, ScalarType.INT32),
  field4: ProtoField(4, ScalarType.INT32),
  summary: ProtoField(8, ScalarType.STRING),
  field10: ProtoField(10, ScalarType.INT32),
  field20: ProtoField(20, () => NotOnlineImage_PbReserve2),
  url: ProtoField(30, ScalarType.STRING),
  md5Str: ProtoField(31, ScalarType.STRING)
};
const NotOnlineImage_PbReserve2 = {
  field1: ProtoField(1, ScalarType.INT32),
  field2: ProtoField(2, ScalarType.STRING),
  field3: ProtoField(3, ScalarType.INT32),
  field4: ProtoField(4, ScalarType.INT32),
  field5: ProtoField(5, ScalarType.INT32),
  field7: ProtoField(7, ScalarType.STRING)
};
const TransElem = {
  elemType: ProtoField(1, ScalarType.INT32),
  elemValue: ProtoField(2, ScalarType.BYTES)
};
const MarketFace = {
  faceName: ProtoField(1, ScalarType.STRING),
  itemType: ProtoField(2, ScalarType.INT32),
  faceInfo: ProtoField(3, ScalarType.INT32),
  faceId: ProtoField(4, ScalarType.BYTES),
  tabId: ProtoField(5, ScalarType.INT32),
  subType: ProtoField(6, ScalarType.INT32),
  key: ProtoField(7, ScalarType.STRING),
  param: ProtoField(8, ScalarType.BYTES),
  mediaType: ProtoField(9, ScalarType.INT32),
  imageWidth: ProtoField(10, ScalarType.INT32),
  imageHeight: ProtoField(11, ScalarType.INT32),
  mobileparam: ProtoField(12, ScalarType.BYTES),
  pbReserve: ProtoField(13, () => MarketFacePbRes)
};
const MarketFacePbRes = {
  field8: ProtoField(8, ScalarType.INT32)
};
const CustomFace = {
  guid: ProtoField(1, ScalarType.BYTES),
  filePath: ProtoField(2, ScalarType.STRING),
  shortcut: ProtoField(3, ScalarType.STRING),
  buffer: ProtoField(4, ScalarType.BYTES),
  flag: ProtoField(5, ScalarType.BYTES),
  oldData: ProtoField(6, ScalarType.BYTES, true),
  fileId: ProtoField(7, ScalarType.UINT32),
  serverIp: ProtoField(8, ScalarType.INT32, true),
  serverPort: ProtoField(9, ScalarType.INT32, true),
  fileType: ProtoField(10, ScalarType.INT32),
  signature: ProtoField(11, ScalarType.BYTES),
  useful: ProtoField(12, ScalarType.INT32),
  md5: ProtoField(13, ScalarType.BYTES),
  thumbUrl: ProtoField(14, ScalarType.STRING),
  bigUrl: ProtoField(15, ScalarType.STRING),
  origUrl: ProtoField(16, ScalarType.STRING),
  bizType: ProtoField(17, ScalarType.INT32),
  repeatIndex: ProtoField(18, ScalarType.INT32),
  repeatImage: ProtoField(19, ScalarType.INT32),
  imageType: ProtoField(20, ScalarType.INT32),
  index: ProtoField(21, ScalarType.INT32),
  width: ProtoField(22, ScalarType.INT32),
  height: ProtoField(23, ScalarType.INT32),
  source: ProtoField(24, ScalarType.INT32),
  size: ProtoField(25, ScalarType.UINT32),
  origin: ProtoField(26, ScalarType.INT32),
  thumbWidth: ProtoField(27, ScalarType.INT32, true),
  thumbHeight: ProtoField(28, ScalarType.INT32, true),
  showLen: ProtoField(29, ScalarType.INT32),
  downloadLen: ProtoField(30, ScalarType.INT32),
  x400Url: ProtoField(31, ScalarType.STRING, true),
  x400Width: ProtoField(32, ScalarType.INT32),
  x400Height: ProtoField(33, ScalarType.INT32),
  pbRes: ProtoField(34, () => CustomFace_PbReserve, true)
};
const CustomFace_PbReserve = {
  subType: ProtoField(1, ScalarType.INT32),
  summary: ProtoField(9, ScalarType.STRING)
};
const ElemFlags2 = {
  colorTextId: ProtoField(1, ScalarType.UINT32),
  msgId: ProtoField(2, ScalarType.UINT64),
  whisperSessionId: ProtoField(3, ScalarType.UINT32),
  pttChangeBit: ProtoField(4, ScalarType.UINT32),
  vipStatus: ProtoField(5, ScalarType.UINT32),
  compatibleId: ProtoField(6, ScalarType.UINT32),
  insts: ProtoField(7, () => Instance, false, true),
  msgRptCnt: ProtoField(8, ScalarType.UINT32),
  srcInst: ProtoField(9, () => Instance),
  longtitude: ProtoField(10, ScalarType.UINT32),
  latitude: ProtoField(11, ScalarType.UINT32),
  customFont: ProtoField(12, ScalarType.UINT32),
  pcSupportDef: ProtoField(13, () => PcSupportDef),
  crmFlags: ProtoField(14, ScalarType.UINT32, true)
};
const PcSupportDef = {
  pcPtlBegin: ProtoField(1, ScalarType.UINT32),
  pcPtlEnd: ProtoField(2, ScalarType.UINT32),
  macPtlBegin: ProtoField(3, ScalarType.UINT32),
  macPtlEnd: ProtoField(4, ScalarType.UINT32),
  ptlsSupport: ProtoField(5, ScalarType.INT32, false, true),
  ptlsNotSupport: ProtoField(6, ScalarType.UINT32, false, true)
};
const Instance = {
  appId: ProtoField(1, ScalarType.UINT32),
  instId: ProtoField(2, ScalarType.UINT32)
};
const RichMsg = {
  template1: ProtoField(1, ScalarType.BYTES, true),
  serviceId: ProtoField(2, ScalarType.INT32, true),
  msgResId: ProtoField(3, ScalarType.BYTES, true),
  rand: ProtoField(4, ScalarType.INT32, true),
  seq: ProtoField(5, ScalarType.UINT32, true)
};
const GroupFile = {
  filename: ProtoField(1, ScalarType.BYTES),
  fileSize: ProtoField(2, ScalarType.UINT64),
  fileId: ProtoField(3, ScalarType.BYTES),
  batchId: ProtoField(4, ScalarType.BYTES),
  fileKey: ProtoField(5, ScalarType.BYTES),
  mark: ProtoField(6, ScalarType.BYTES),
  sequence: ProtoField(7, ScalarType.UINT64),
  batchItemId: ProtoField(8, ScalarType.BYTES),
  feedMsgTime: ProtoField(9, ScalarType.INT32),
  pbReserve: ProtoField(10, ScalarType.BYTES)
};
const ExtraInfo = {
  nick: ProtoField(1, ScalarType.BYTES),
  groupCard: ProtoField(2, ScalarType.BYTES),
  level: ProtoField(3, ScalarType.INT32),
  flags: ProtoField(4, ScalarType.INT32),
  groupMask: ProtoField(5, ScalarType.INT32),
  msgTailId: ProtoField(6, ScalarType.INT32),
  senderTitle: ProtoField(7, ScalarType.BYTES),
  apnsTips: ProtoField(8, ScalarType.BYTES),
  uin: ProtoField(9, ScalarType.UINT64),
  msgStateFlag: ProtoField(10, ScalarType.INT32),
  apnsSoundType: ProtoField(11, ScalarType.INT32),
  newGroupFlag: ProtoField(12, ScalarType.INT32)
};
const VideoFile = {
  fileUuid: ProtoField(1, ScalarType.STRING),
  fileMd5: ProtoField(2, ScalarType.BYTES),
  fileName: ProtoField(3, ScalarType.STRING),
  fileFormat: ProtoField(4, ScalarType.INT32),
  fileTime: ProtoField(5, ScalarType.INT32),
  fileSize: ProtoField(6, ScalarType.INT32),
  thumbWidth: ProtoField(7, ScalarType.INT32),
  thumbHeight: ProtoField(8, ScalarType.INT32),
  thumbFileMd5: ProtoField(9, ScalarType.BYTES),
  source: ProtoField(10, ScalarType.BYTES),
  thumbFileSize: ProtoField(11, ScalarType.INT32),
  busiType: ProtoField(12, ScalarType.INT32),
  fromChatType: ProtoField(13, ScalarType.INT32),
  toChatType: ProtoField(14, ScalarType.INT32),
  boolSupportProgressive: ProtoField(15, ScalarType.BOOL),
  fileWidth: ProtoField(16, ScalarType.INT32),
  fileHeight: ProtoField(17, ScalarType.INT32),
  subBusiType: ProtoField(18, ScalarType.INT32),
  videoAttr: ProtoField(19, ScalarType.INT32),
  bytesThumbFileUrls: ProtoField(20, ScalarType.BYTES, false, true),
  bytesVideoFileUrls: ProtoField(21, ScalarType.BYTES, false, true),
  thumbDownloadFlag: ProtoField(22, ScalarType.INT32),
  videoDownloadFlag: ProtoField(23, ScalarType.INT32),
  pbReserve: ProtoField(24, ScalarType.BYTES)
};
const AnonymousGroupMessage = {
  flags: ProtoField(1, ScalarType.INT32),
  anonId: ProtoField(2, ScalarType.BYTES),
  anonNick: ProtoField(3, ScalarType.BYTES),
  headPortrait: ProtoField(4, ScalarType.INT32),
  expireTime: ProtoField(5, ScalarType.INT32),
  bubbleId: ProtoField(6, ScalarType.INT32),
  rankColor: ProtoField(7, ScalarType.BYTES)
};
const CustomElem = {
  desc: ProtoField(1, ScalarType.BYTES),
  data: ProtoField(2, ScalarType.BYTES),
  enumType: ProtoField(3, ScalarType.INT32),
  ext: ProtoField(4, ScalarType.BYTES),
  sound: ProtoField(5, ScalarType.BYTES)
};
const GeneralFlags = {
  bubbleDiyTextId: ProtoField(1, ScalarType.INT32),
  groupFlagNew: ProtoField(2, ScalarType.INT32),
  uin: ProtoField(3, ScalarType.UINT64),
  rpId: ProtoField(4, ScalarType.BYTES),
  prpFold: ProtoField(5, ScalarType.INT32),
  longTextFlag: ProtoField(6, ScalarType.INT32),
  longTextResId: ProtoField(7, ScalarType.STRING, true),
  groupType: ProtoField(8, ScalarType.INT32),
  toUinFlag: ProtoField(9, ScalarType.INT32),
  glamourLevel: ProtoField(10, ScalarType.INT32),
  memberLevel: ProtoField(11, ScalarType.INT32),
  groupRankSeq: ProtoField(12, ScalarType.UINT64),
  olympicTorch: ProtoField(13, ScalarType.INT32),
  babyqGuideMsgCookie: ProtoField(14, ScalarType.BYTES),
  uin32ExpertFlag: ProtoField(15, ScalarType.INT32),
  bubbleSubId: ProtoField(16, ScalarType.INT32),
  pendantId: ProtoField(17, ScalarType.UINT64),
  rpIndex: ProtoField(18, ScalarType.BYTES),
  pbReserve: ProtoField(19, ScalarType.BYTES)
};
const SrcMsg = {
  origSeqs: ProtoField(1, ScalarType.UINT32, false, true),
  senderUin: ProtoField(2, ScalarType.UINT64),
  time: ProtoField(3, ScalarType.INT32, true),
  flag: ProtoField(4, ScalarType.INT32, true),
  elems: ProtoField(5, () => Elem, false, true),
  type: ProtoField(6, ScalarType.INT32, true),
  richMsg: ProtoField(7, ScalarType.BYTES, true),
  pbReserve: ProtoField(8, () => SrcMsgPbRes, true),
  sourceMsg: ProtoField(9, ScalarType.BYTES, true),
  toUin: ProtoField(10, ScalarType.UINT64, true),
  troopName: ProtoField(11, ScalarType.BYTES, true)
};
const SrcMsgPbRes = {
  messageId: ProtoField(3, ScalarType.UINT64),
  senderUid: ProtoField(6, ScalarType.STRING, true),
  receiverUid: ProtoField(7, ScalarType.STRING, true),
  friendSeq: ProtoField(8, ScalarType.UINT32, true)
};
const LightAppElem = {
  data: ProtoField(1, ScalarType.BYTES),
  msgResid: ProtoField(2, ScalarType.BYTES, true)
};
const CommonElem = {
  serviceType: ProtoField(1, ScalarType.INT32),
  pbElem: ProtoField(2, ScalarType.BYTES),
  businessType: ProtoField(3, ScalarType.UINT32)
};
({
  faceId: ProtoField(1, ScalarType.INT32, true)
});
const MentionExtra = {
  type: ProtoField(3, ScalarType.INT32, true),
  uin: ProtoField(4, ScalarType.UINT32, true),
  field5: ProtoField(5, ScalarType.INT32, true),
  uid: ProtoField(9, ScalarType.STRING, true)
};
const QBigFaceExtra = {
  AniStickerPackId: ProtoField(1, ScalarType.STRING, true),
  AniStickerId: ProtoField(2, ScalarType.STRING, true),
  faceId: ProtoField(3, ScalarType.INT32, true),
  sourceType: ProtoField(4, ScalarType.INT32, true),
  AniStickerType: ProtoField(5, ScalarType.INT32, true),
  resultId: ProtoField(6, ScalarType.STRING, true),
  preview: ProtoField(7, ScalarType.STRING, true),
  randomType: ProtoField(9, ScalarType.INT32, true)
};
const QSmallFaceExtra = {
  faceId: ProtoField(1, ScalarType.UINT32),
  preview: ProtoField(2, ScalarType.STRING),
  preview2: ProtoField(3, ScalarType.STRING)
};
const MarkdownData = {
  content: ProtoField(1, ScalarType.STRING)
};

({
  type: ProtoField(1, ScalarType.UINT32),
  groupUin: ProtoField(2, ScalarType.UINT32)});
({
  sequence: ProtoField(1, ScalarType.UINT32),
  random: ProtoField(2, ScalarType.UINT32),
  field3: ProtoField(3, ScalarType.UINT32)
});
({
  field1: ProtoField(1, ScalarType.UINT32)
});

const ContentHead = {
  type: ProtoField(1, ScalarType.UINT32),
  subType: ProtoField(2, ScalarType.UINT32, true),
  c2cCmd: ProtoField(3, ScalarType.UINT32, true),
  ranDom: ProtoField(4, ScalarType.UINT32, true),
  sequence: ProtoField(5, ScalarType.UINT32, true),
  timeStamp: ProtoField(6, ScalarType.UINT32, true),
  pkgNum: ProtoField(7, ScalarType.UINT64, true),
  pkgIndex: ProtoField(8, ScalarType.UINT32, true),
  divSeq: ProtoField(9, ScalarType.UINT32, true),
  autoReply: ProtoField(10, ScalarType.UINT32),
  ntMsgSeq: ProtoField(10, ScalarType.UINT32, true),
  newId: ProtoField(12, ScalarType.UINT64, true),
  forward: ProtoField(15, () => ForwardHead, true)
};
const MessageBody = {
  richText: ProtoField(1, () => RichText, true),
  msgContent: ProtoField(2, ScalarType.BYTES, true),
  msgEncryptContent: ProtoField(3, ScalarType.BYTES, true)
};
({
  clientSequence: ProtoField(4, ScalarType.UINT32, true),
  random: ProtoField(5, ScalarType.UINT32, true),
  syncCookie: ProtoField(6, ScalarType.BYTES, true),
  via: ProtoField(8, ScalarType.UINT32, true),
  dataStatist: ProtoField(9, ScalarType.UINT32, true),
  multiSendSeq: ProtoField(14, ScalarType.UINT32)
});
({
  msgFlag: ProtoField(1, ScalarType.INT32)
});
const PushMsg = {
  message: ProtoField(1, () => PushMsgBody),
  status: ProtoField(3, ScalarType.INT32, true),
  pingFlag: ProtoField(5, ScalarType.INT32, true),
  generalFlag: ProtoField(9, ScalarType.INT32, true)
};
const GroupChangeInfo = {
  operator: ProtoField(1, () => GroupChangeOperator, true)
};
const GroupChangeOperator = {
  operatorUid: ProtoField(1, ScalarType.STRING, true)
};
const GroupChange = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  flag: ProtoField(2, ScalarType.UINT32),
  memberUid: ProtoField(3, ScalarType.STRING, true),
  decreaseType: ProtoField(4, ScalarType.UINT32),
  operatorInfo: ProtoField(5, ScalarType.BYTES, true),
  increaseType: ProtoField(6, ScalarType.UINT32),
  field7: ProtoField(7, ScalarType.BYTES, true)
};
const GroupReactionDataInnerDataTarget = {
  seq: ProtoField(1, ScalarType.UINT64, true)
};
const GroupReactionDataContent = {
  code: ProtoField(1, ScalarType.STRING, true),
  count: ProtoField(3, ScalarType.UINT32, true),
  operatorUid: ProtoField(4, ScalarType.STRING, true),
  type: ProtoField(5, ScalarType.UINT32, true)
};
const GroupReactionDataInnerData = {
  groupReactionTarget: ProtoField(2, () => GroupReactionDataInnerDataTarget, true),
  groupReactionDataContent: ProtoField(3, () => GroupReactionDataContent, true)
};
const GroupReactionDataInner = {
  data: ProtoField(1, () => GroupReactionDataInnerData, true)
};
const GroupReactionData = {
  data: ProtoField(1, () => GroupReactionDataInner, true)
};
const GroupReactNotify = {
  groupUin: ProtoField(4, ScalarType.UINT64, true),
  field13: ProtoField(13, ScalarType.UINT32, true),
  groupReactionData: ProtoField(44, () => GroupReactionData, true)
};
const GroupInvite = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  field2: ProtoField(2, ScalarType.UINT32),
  field3: ProtoField(2, ScalarType.UINT32),
  field4: ProtoField(2, ScalarType.UINT32),
  invitorUid: ProtoField(5, ScalarType.STRING)
};
const PushMsgBody = {
  responseHead: ProtoField(1, () => ResponseHead),
  contentHead: ProtoField(2, () => ContentHead),
  body: ProtoField(3, () => MessageBody, true)
};
const ResponseHead = {
  fromUin: ProtoField(1, ScalarType.UINT32),
  fromUid: ProtoField(2, ScalarType.STRING, true),
  type: ProtoField(3, ScalarType.UINT32),
  sigMap: ProtoField(4, ScalarType.UINT32),
  toUin: ProtoField(5, ScalarType.UINT32),
  toUid: ProtoField(6, ScalarType.STRING, true),
  forward: ProtoField(7, () => ResponseForward, true),
  grp: ProtoField(8, () => ResponseGrp, true)
};

({
  instId: ProtoField(2, ScalarType.UINT32),
  appId: ProtoField(3, ScalarType.UINT32),
  longMessageFlag: ProtoField(4, ScalarType.UINT32),
  reserved: ProtoField(5, ScalarType.BYTES)
});
({
  fromUid: ProtoField(1, ScalarType.STRING),
  toUid: ProtoField(2, ScalarType.STRING),
  sequence: ProtoField(3, ScalarType.UINT32),
  newId: ProtoField(4, ScalarType.UINT64),
  time: ProtoField(5, ScalarType.UINT32),
  random: ProtoField(6, ScalarType.UINT32),
  pkgNum: ProtoField(7, ScalarType.UINT32),
  pkgIndex: ProtoField(8, ScalarType.UINT32),
  divSeq: ProtoField(9, ScalarType.UINT32)
});

const ForwardHead = {
  field1: ProtoField(1, ScalarType.UINT32, true),
  field2: ProtoField(2, ScalarType.UINT32, true),
  field3: ProtoField(3, ScalarType.UINT32, true),
  unknownBase64: ProtoField(5, ScalarType.STRING, true),
  avatar: ProtoField(6, ScalarType.STRING, true)
};
({
  groupCode: ProtoField(1, ScalarType.UINT32, true)
});
({
  groupUin: ProtoField(1, ScalarType.UINT32, true),
  toUin: ProtoField(2, ScalarType.UINT32, true)
});
const ResponseForward = {
  friendName: ProtoField(6, ScalarType.STRING, true)
};
const ResponseGrp = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  memberName: ProtoField(4, ScalarType.STRING),
  unknown5: ProtoField(5, ScalarType.UINT32),
  groupName: ProtoField(7, ScalarType.STRING)
};
({
  toUin: ProtoField(1, ScalarType.UINT64, true),
  ccCmd: ProtoField(2, ScalarType.UINT32, true),
  uid: ProtoField(8, ScalarType.STRING, true)
});
({
  toUin: ProtoField(1, ScalarType.UINT64),
  sig: ProtoField(2, ScalarType.BYTES)
});

const NTV2RichMediaReq = {
  ReqHead: ProtoField(1, () => MultiMediaReqHead),
  Upload: ProtoField(2, () => UploadReq),
  Download: ProtoField(3, () => DownloadReq),
  DownloadRKey: ProtoField(4, () => DownloadRKeyReq),
  Delete: ProtoField(5, () => DeleteReq),
  UploadCompleted: ProtoField(6, () => UploadCompletedReq),
  MsgInfoAuth: ProtoField(7, () => MsgInfoAuthReq),
  UploadKeyRenewal: ProtoField(8, () => UploadKeyRenewalReq),
  DownloadSafe: ProtoField(9, () => DownloadSafeReq),
  Extension: ProtoField(99, ScalarType.BYTES, true)
};
const MultiMediaReqHead = {
  Common: ProtoField(1, () => CommonHead),
  Scene: ProtoField(2, () => SceneInfo),
  Client: ProtoField(3, () => ClientMeta)
};
const CommonHead = {
  RequestId: ProtoField(1, ScalarType.UINT32),
  Command: ProtoField(2, ScalarType.UINT32)
};
const SceneInfo = {
  RequestType: ProtoField(101, ScalarType.UINT32),
  BusinessType: ProtoField(102, ScalarType.UINT32),
  SceneType: ProtoField(200, ScalarType.UINT32),
  C2C: ProtoField(201, () => C2CUserInfo, true),
  Group: ProtoField(202, () => NTGroupInfo, true)
};
const C2CUserInfo = {
  AccountType: ProtoField(1, ScalarType.UINT32),
  TargetUid: ProtoField(2, ScalarType.STRING)
};
const NTGroupInfo = {
  GroupUin: ProtoField(1, ScalarType.UINT32)
};
const ClientMeta = {
  AgentType: ProtoField(1, ScalarType.UINT32)
};
const DownloadReq = {
  Node: ProtoField(1, () => IndexNode),
  Download: ProtoField(2, () => DownloadExt)
};
const IndexNode = {
  Info: ProtoField(1, () => FileInfo),
  FileUuid: ProtoField(2, ScalarType.STRING),
  StoreId: ProtoField(3, ScalarType.UINT32),
  UploadTime: ProtoField(4, ScalarType.UINT32),
  Ttl: ProtoField(5, ScalarType.UINT32),
  SubType: ProtoField(6, ScalarType.UINT32)
};
const FileInfo = {
  FileSize: ProtoField(1, ScalarType.UINT32),
  FileHash: ProtoField(2, ScalarType.STRING),
  FileSha1: ProtoField(3, ScalarType.STRING),
  FileName: ProtoField(4, ScalarType.STRING),
  Type: ProtoField(5, () => FileType),
  Width: ProtoField(6, ScalarType.UINT32),
  Height: ProtoField(7, ScalarType.UINT32),
  Time: ProtoField(8, ScalarType.UINT32),
  Original: ProtoField(9, ScalarType.UINT32)
};
const FileType = {
  Type: ProtoField(1, ScalarType.UINT32),
  PicFormat: ProtoField(2, ScalarType.UINT32),
  VideoFormat: ProtoField(3, ScalarType.UINT32),
  VoiceFormat: ProtoField(4, ScalarType.UINT32)
};
const DownloadExt = {
  Pic: ProtoField(1, () => PicDownloadExt),
  Video: ProtoField(2, () => VideoDownloadExt),
  Ptt: ProtoField(3, () => PttDownloadExt)
};
const VideoDownloadExt = {
  BusiType: ProtoField(1, ScalarType.UINT32),
  SceneType: ProtoField(2, ScalarType.UINT32),
  SubBusiType: ProtoField(3, ScalarType.UINT32)
};
const PicDownloadExt = {};
const PttDownloadExt = {};
const DownloadRKeyReq = {
  Types: ProtoField(1, ScalarType.INT32, false, true)
};
const DeleteReq = {
  Index: ProtoField(1, () => IndexNode, false, true),
  NeedRecallMsg: ProtoField(2, ScalarType.BOOL),
  MsgSeq: ProtoField(3, ScalarType.UINT64),
  MsgRandom: ProtoField(4, ScalarType.UINT64),
  MsgTime: ProtoField(5, ScalarType.UINT64)
};
const UploadCompletedReq = {
  SrvSendMsg: ProtoField(1, ScalarType.BOOL),
  ClientRandomId: ProtoField(2, ScalarType.UINT64),
  MsgInfo: ProtoField(3, () => MsgInfo),
  ClientSeq: ProtoField(4, ScalarType.UINT32)
};
const MsgInfoAuthReq = {
  Msg: ProtoField(1, ScalarType.BYTES),
  AuthTime: ProtoField(2, ScalarType.UINT64)
};
const DownloadSafeReq = {
  Index: ProtoField(1, () => IndexNode)
};
const UploadKeyRenewalReq = {
  OldUKey: ProtoField(1, ScalarType.STRING),
  SubType: ProtoField(2, ScalarType.UINT32)
};
const MsgInfo = {
  MsgInfoBody: ProtoField(1, () => MsgInfoBody, false, true),
  ExtBizInfo: ProtoField(2, () => ExtBizInfo)
};
const MsgInfoBody = {
  Index: ProtoField(1, () => IndexNode),
  Picture: ProtoField(2, () => PictureInfo),
  Video: ProtoField(3, () => VideoInfo),
  Audio: ProtoField(4, () => AudioInfo),
  FileExist: ProtoField(5, ScalarType.BOOL),
  HashSum: ProtoField(6, ScalarType.BYTES)
};
const VideoInfo = {};
const AudioInfo = {};
const PictureInfo = {
  UrlPath: ProtoField(1, ScalarType.STRING),
  Ext: ProtoField(2, () => PicUrlExtInfo),
  Domain: ProtoField(3, ScalarType.STRING)
};
const PicUrlExtInfo = {
  OriginalParameter: ProtoField(1, ScalarType.STRING),
  BigParameter: ProtoField(2, ScalarType.STRING),
  ThumbParameter: ProtoField(3, ScalarType.STRING)
};
const VideoExtInfo = {
  VideoCodecFormat: ProtoField(1, ScalarType.UINT32)
};
const ExtBizInfo = {
  Pic: ProtoField(1, () => PicExtBizInfo),
  Video: ProtoField(2, () => VideoExtBizInfo),
  Ptt: ProtoField(3, () => PttExtBizInfo),
  BusiType: ProtoField(10, ScalarType.UINT32)
};
const PttExtBizInfo = {
  SrcUin: ProtoField(1, ScalarType.UINT64),
  PttScene: ProtoField(2, ScalarType.UINT32),
  PttType: ProtoField(3, ScalarType.UINT32),
  ChangeVoice: ProtoField(4, ScalarType.UINT32),
  Waveform: ProtoField(5, ScalarType.BYTES),
  AutoConvertText: ProtoField(6, ScalarType.UINT32),
  BytesReserve: ProtoField(11, ScalarType.BYTES),
  BytesPbReserve: ProtoField(12, ScalarType.BYTES),
  BytesGeneralFlags: ProtoField(13, ScalarType.BYTES)
};
const VideoExtBizInfo = {
  FromScene: ProtoField(1, ScalarType.UINT32),
  ToScene: ProtoField(2, ScalarType.UINT32),
  BytesPbReserve: ProtoField(3, ScalarType.BYTES)
};
const PicExtBizInfo = {
  BizType: ProtoField(1, ScalarType.UINT32),
  TextSummary: ProtoField(2, ScalarType.STRING),
  BytesPbReserveC2c: ProtoField(11, () => BytesPbReserveC2c),
  BytesPbReserveTroop: ProtoField(12, () => BytesPbReserveTroop),
  FromScene: ProtoField(1001, ScalarType.UINT32),
  ToScene: ProtoField(1002, ScalarType.UINT32),
  OldFileId: ProtoField(1003, ScalarType.UINT32)
};
const UploadReq = {
  UploadInfo: ProtoField(1, () => UploadInfo, false, true),
  TryFastUploadCompleted: ProtoField(2, ScalarType.BOOL),
  SrvSendMsg: ProtoField(3, ScalarType.BOOL),
  ClientRandomId: ProtoField(4, ScalarType.UINT64),
  CompatQMsgSceneType: ProtoField(5, ScalarType.UINT32),
  ExtBizInfo: ProtoField(6, () => ExtBizInfo),
  ClientSeq: ProtoField(7, ScalarType.UINT32),
  NoNeedCompatMsg: ProtoField(8, ScalarType.BOOL)
};
const UploadInfo = {
  FileInfo: ProtoField(1, () => FileInfo),
  SubFileType: ProtoField(2, ScalarType.UINT32)
};
const BytesPbReserveC2c = {
  subType: ProtoField(1, ScalarType.UINT32),
  field3: ProtoField(3, ScalarType.UINT32),
  field4: ProtoField(4, ScalarType.UINT32),
  field8: ProtoField(8, ScalarType.STRING),
  field10: ProtoField(10, ScalarType.UINT32),
  field12: ProtoField(12, ScalarType.STRING),
  field18: ProtoField(18, ScalarType.STRING),
  field19: ProtoField(19, ScalarType.STRING),
  field20: ProtoField(20, ScalarType.BYTES)
};
const BytesPbReserveTroop = {
  subType: ProtoField(1, ScalarType.UINT32),
  field3: ProtoField(3, ScalarType.UINT32),
  field4: ProtoField(4, ScalarType.UINT32),
  field9: ProtoField(9, ScalarType.STRING),
  field10: ProtoField(10, ScalarType.UINT32),
  field12: ProtoField(12, ScalarType.STRING),
  field18: ProtoField(18, ScalarType.STRING),
  field19: ProtoField(19, ScalarType.STRING),
  field21: ProtoField(21, ScalarType.BYTES)
};

const NTV2RichMediaResp = {
  respHead: ProtoField(1, () => MultiMediaRespHead),
  upload: ProtoField(2, () => UploadResp),
  download: ProtoField(3, () => DownloadResp),
  downloadRKey: ProtoField(4, () => DownloadRKeyResp),
  delete: ProtoField(5, () => DeleteResp),
  uploadCompleted: ProtoField(6, () => UploadCompletedResp),
  msgInfoAuth: ProtoField(7, () => MsgInfoAuthResp),
  uploadKeyRenewal: ProtoField(8, () => UploadKeyRenewalResp),
  downloadSafe: ProtoField(9, () => DownloadSafeResp),
  extension: ProtoField(99, ScalarType.BYTES, true)
};
const MultiMediaRespHead = {
  common: ProtoField(1, () => CommonHead),
  retCode: ProtoField(2, ScalarType.UINT32),
  message: ProtoField(3, ScalarType.STRING)
};
const DownloadResp = {
  rKeyParam: ProtoField(1, ScalarType.STRING),
  rKeyTtlSecond: ProtoField(2, ScalarType.UINT32),
  info: ProtoField(3, () => DownloadInfo),
  rKeyCreateTime: ProtoField(4, ScalarType.UINT32)
};
const DownloadInfo = {
  domain: ProtoField(1, ScalarType.STRING),
  urlPath: ProtoField(2, ScalarType.STRING),
  httpsPort: ProtoField(3, ScalarType.UINT32),
  ipv4s: ProtoField(4, () => IPv4, false, true),
  ipv6s: ProtoField(5, () => IPv6, false, true),
  picUrlExtInfo: ProtoField(6, () => PicUrlExtInfo),
  videoExtInfo: ProtoField(7, () => VideoExtInfo)
};
const IPv4 = {
  outIP: ProtoField(1, ScalarType.UINT32),
  outPort: ProtoField(2, ScalarType.UINT32),
  inIP: ProtoField(3, ScalarType.UINT32),
  inPort: ProtoField(4, ScalarType.UINT32),
  ipType: ProtoField(5, ScalarType.UINT32)
};
const IPv6 = {
  outIP: ProtoField(1, ScalarType.BYTES),
  outPort: ProtoField(2, ScalarType.UINT32),
  inIP: ProtoField(3, ScalarType.BYTES),
  inPort: ProtoField(4, ScalarType.UINT32),
  ipType: ProtoField(5, ScalarType.UINT32)
};
const UploadResp = {
  uKey: ProtoField(1, ScalarType.STRING, true),
  uKeyTtlSecond: ProtoField(2, ScalarType.UINT32),
  ipv4s: ProtoField(3, () => IPv4, false, true),
  ipv6s: ProtoField(4, () => IPv6, false, true),
  msgSeq: ProtoField(5, ScalarType.UINT64),
  msgInfo: ProtoField(6, () => MsgInfo),
  ext: ProtoField(7, () => RichMediaStorageTransInfo, false, true),
  compatQMsg: ProtoField(8, ScalarType.BYTES),
  subFileInfos: ProtoField(10, () => SubFileInfo, false, true)
};
const RichMediaStorageTransInfo = {
  subType: ProtoField(1, ScalarType.UINT32),
  extType: ProtoField(2, ScalarType.UINT32),
  extValue: ProtoField(3, ScalarType.BYTES)
};
const SubFileInfo = {
  subType: ProtoField(1, ScalarType.UINT32),
  uKey: ProtoField(2, ScalarType.STRING),
  uKeyTtlSecond: ProtoField(3, ScalarType.UINT32),
  ipv4s: ProtoField(4, () => IPv4, false, true),
  ipv6s: ProtoField(5, () => IPv6, false, true)
};
const DownloadSafeResp = {};
const UploadKeyRenewalResp = {
  ukey: ProtoField(1, ScalarType.STRING),
  ukeyTtlSec: ProtoField(2, ScalarType.UINT64)
};
const MsgInfoAuthResp = {
  authCode: ProtoField(1, ScalarType.UINT32),
  msg: ProtoField(2, ScalarType.BYTES),
  resultTime: ProtoField(3, ScalarType.UINT64)
};
const UploadCompletedResp = {
  msgSeq: ProtoField(1, ScalarType.UINT64)
};
const DeleteResp = {};
const DownloadRKeyResp = {
  rKeys: ProtoField(1, () => RKeyInfo, false, true)
};
const RKeyInfo = {
  rkey: ProtoField(1, ScalarType.STRING),
  rkeyTtlSec: ProtoField(2, ScalarType.UINT64),
  storeId: ProtoField(3, ScalarType.UINT32),
  rkeyCreateTime: ProtoField(4, ScalarType.UINT32, true),
  type: ProtoField(5, ScalarType.UINT32, true)
};

const OidbSvcTrpcTcp0x6D6 = {
  file: ProtoField(1, () => OidbSvcTrpcTcp0x6D6Upload, true),
  download: ProtoField(3, () => OidbSvcTrpcTcp0x6D6Download, true),
  delete: ProtoField(4, () => OidbSvcTrpcTcp0x6D6Delete, true),
  rename: ProtoField(5, () => OidbSvcTrpcTcp0x6D6Rename, true),
  move: ProtoField(6, () => OidbSvcTrpcTcp0x6D6Move, true)
};
const OidbSvcTrpcTcp0x6D6Upload = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  appId: ProtoField(2, ScalarType.UINT32),
  busId: ProtoField(3, ScalarType.UINT32),
  entrance: ProtoField(4, ScalarType.UINT32),
  targetDirectory: ProtoField(5, ScalarType.STRING),
  fileName: ProtoField(6, ScalarType.STRING),
  localDirectory: ProtoField(7, ScalarType.STRING),
  fileSize: ProtoField(8, ScalarType.UINT64),
  fileSha1: ProtoField(9, ScalarType.BYTES),
  fileSha3: ProtoField(10, ScalarType.BYTES),
  fileMd5: ProtoField(11, ScalarType.BYTES),
  field15: ProtoField(15, ScalarType.BOOL)
};
const OidbSvcTrpcTcp0x6D6Download = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  appId: ProtoField(2, ScalarType.UINT32),
  busId: ProtoField(3, ScalarType.UINT32),
  fileId: ProtoField(4, ScalarType.STRING)
};
const OidbSvcTrpcTcp0x6D6Delete = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  busId: ProtoField(3, ScalarType.UINT32),
  fileId: ProtoField(5, ScalarType.STRING)
};
const OidbSvcTrpcTcp0x6D6Rename = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  busId: ProtoField(3, ScalarType.UINT32),
  fileId: ProtoField(4, ScalarType.STRING),
  parentFolder: ProtoField(5, ScalarType.STRING),
  newFileName: ProtoField(6, ScalarType.STRING)
};
const OidbSvcTrpcTcp0x6D6Move = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  appId: ProtoField(2, ScalarType.UINT32),
  busId: ProtoField(3, ScalarType.UINT32),
  fileId: ProtoField(4, ScalarType.STRING),
  parentDirectory: ProtoField(5, ScalarType.STRING),
  targetDirectory: ProtoField(6, ScalarType.STRING)
};
const OidbSvcTrpcTcp0x6D6Response = {
  upload: ProtoField(1, () => OidbSvcTrpcTcp0x6D6_0Response),
  download: ProtoField(3, () => OidbSvcTrpcTcp0x6D6_2Response),
  delete: ProtoField(4, () => OidbSvcTrpcTcp0x6D6_3_4_5Response),
  rename: ProtoField(5, () => OidbSvcTrpcTcp0x6D6_3_4_5Response),
  move: ProtoField(6, () => OidbSvcTrpcTcp0x6D6_3_4_5Response)
};
const OidbSvcTrpcTcp0x6D6_0Response = {
  retCode: ProtoField(1, ScalarType.INT32),
  retMsg: ProtoField(2, ScalarType.STRING),
  clientWording: ProtoField(3, ScalarType.STRING),
  uploadIp: ProtoField(4, ScalarType.STRING),
  serverDns: ProtoField(5, ScalarType.STRING),
  busId: ProtoField(6, ScalarType.INT32),
  fileId: ProtoField(7, ScalarType.STRING),
  checkKey: ProtoField(8, ScalarType.BYTES),
  fileKey: ProtoField(9, ScalarType.BYTES),
  boolFileExist: ProtoField(10, ScalarType.BOOL),
  uploadIpLanV4: ProtoField(12, ScalarType.STRING, false, true),
  uploadIpLanV6: ProtoField(13, ScalarType.STRING, false, true),
  uploadPort: ProtoField(14, ScalarType.UINT32)
};
const OidbSvcTrpcTcp0x6D6_2Response = {
  retCode: ProtoField(1, ScalarType.INT32),
  retMsg: ProtoField(2, ScalarType.STRING),
  clientWording: ProtoField(3, ScalarType.STRING),
  downloadIp: ProtoField(4, ScalarType.STRING),
  downloadDns: ProtoField(5, ScalarType.STRING),
  downloadUrl: ProtoField(6, ScalarType.BYTES),
  fileSha1: ProtoField(7, ScalarType.BYTES),
  fileSha3: ProtoField(8, ScalarType.BYTES),
  fileMd5: ProtoField(9, ScalarType.BYTES),
  cookieVal: ProtoField(10, ScalarType.BYTES),
  saveFileName: ProtoField(11, ScalarType.STRING),
  previewPort: ProtoField(12, ScalarType.UINT32)
};
const OidbSvcTrpcTcp0x6D6_3_4_5Response = {
  retCode: ProtoField(1, ScalarType.INT32),
  retMsg: ProtoField(2, ScalarType.STRING),
  clientWording: ProtoField(3, ScalarType.STRING)
};

const OidbSvcTrpcTcp0X8FC_2_Body = {
  targetUid: ProtoField(1, ScalarType.STRING),
  specialTitle: ProtoField(5, ScalarType.STRING, true),
  expiredTime: ProtoField(6, ScalarType.INT32),
  uinName: ProtoField(7, ScalarType.STRING, true),
  targetName: ProtoField(8, ScalarType.STRING)
};
const OidbSvcTrpcTcp0X8FC_2 = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  body: ProtoField(3, () => OidbSvcTrpcTcp0X8FC_2_Body)
};

const OidbSvcTrpcTcp0X9067_202 = {
  ReqHead: ProtoField(1, () => MultiMediaReqHead),
  DownloadRKeyReq: ProtoField(4, () => OidbSvcTrpcTcp0X9067_202Key)
};
const OidbSvcTrpcTcp0X9067_202Key = {
  key: ProtoField(1, ScalarType.INT32, false, true)
};
const OidbSvcTrpcTcp0X9067_202_RkeyList = {
  rkey: ProtoField(1, ScalarType.STRING),
  ttl: ProtoField(2, ScalarType.UINT64),
  time: ProtoField(4, ScalarType.UINT32),
  type: ProtoField(5, ScalarType.UINT32)
};
const OidbSvcTrpcTcp0X9067_202_Data = {
  rkeyList: ProtoField(1, () => OidbSvcTrpcTcp0X9067_202_RkeyList, false, true)
};
const OidbSvcTrpcTcp0X9067_202_Rsp_Body = {
  data: ProtoField(4, () => OidbSvcTrpcTcp0X9067_202_Data)
};

const OidbSvcTrpcTcp0X929D_0 = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  chatType: ProtoField(2, ScalarType.UINT32)
};
const OidbSvcTrpcTcp0X929D_0Resp = {
  content: ProtoField(1, () => OidbSvcTrpcTcp0X929D_0RespContent, false, true)
};
const OidbSvcTrpcTcp0X929D_0RespContent = {
  category: ProtoField(1, ScalarType.STRING),
  voices: ProtoField(2, () => OidbSvcTrpcTcp0X929D_0RespContentVoice, false, true)
};
const OidbSvcTrpcTcp0X929D_0RespContentVoice = {
  voiceId: ProtoField(1, ScalarType.STRING),
  voiceDisplayName: ProtoField(2, ScalarType.STRING),
  voiceExampleUrl: ProtoField(3, ScalarType.STRING)
};
const OidbSvcTrpcTcp0X929B_0 = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  voiceId: ProtoField(2, ScalarType.STRING),
  text: ProtoField(3, ScalarType.STRING),
  chatType: ProtoField(4, ScalarType.UINT32),
  session: ProtoField(5, () => OidbSvcTrpcTcp0X929B_0_Session)
};
const OidbSvcTrpcTcp0X929B_0_Session = {
  sessionId: ProtoField(1, ScalarType.UINT32)
};
const OidbSvcTrpcTcp0X929B_0Resp = {
  statusCode: ProtoField(1, ScalarType.UINT32),
  field2: ProtoField(2, ScalarType.UINT32, true),
  field3: ProtoField(3, ScalarType.UINT32),
  msgInfo: ProtoField(4, () => MsgInfo, true)
};

const OidbSvcTrpcTcp0XE37_1200 = {
  subCommand: ProtoField(1, ScalarType.UINT32, true),
  field2: ProtoField(2, ScalarType.INT32, true),
  body: ProtoField(14, () => OidbSvcTrpcTcp0XE37_1200Body, true),
  field101: ProtoField(101, ScalarType.INT32, true),
  field102: ProtoField(102, ScalarType.INT32, true),
  field200: ProtoField(200, ScalarType.INT32, true),
  field99999: ProtoField(99999, ScalarType.BYTES, true)
};
const OidbSvcTrpcTcp0XE37_1200Body = {
  receiverUid: ProtoField(10, ScalarType.STRING, true),
  fileUuid: ProtoField(20, ScalarType.STRING, true),
  type: ProtoField(30, ScalarType.INT32, true),
  fileHash: ProtoField(60, ScalarType.STRING, true),
  t2: ProtoField(601, ScalarType.INT32, true)
};
const OidbSvcTrpcTcp0XE37_1200Response = {
  command: ProtoField(1, ScalarType.UINT32, true),
  subCommand: ProtoField(2, ScalarType.UINT32, true),
  body: ProtoField(14, () => OidbSvcTrpcTcp0XE37_1200ResponseBody, true),
  field50: ProtoField(50, ScalarType.UINT32, true)
};
const OidbSvcTrpcTcp0XE37_1200ResponseBody = {
  field10: ProtoField(10, ScalarType.UINT32, true),
  state: ProtoField(20, ScalarType.STRING, true),
  result: ProtoField(30, () => OidbSvcTrpcTcp0XE37_1200Result, true),
  metadata: ProtoField(40, () => OidbSvcTrpcTcp0XE37_800_1200Metadata, true)
};
const OidbSvcTrpcTcp0XE37_1200Result = {
  server: ProtoField(20, ScalarType.STRING, true),
  port: ProtoField(40, ScalarType.UINT32, true),
  url: ProtoField(50, ScalarType.STRING, true),
  additionalServer: ProtoField(60, ScalarType.STRING, false, true),
  ssoPort: ProtoField(80, ScalarType.UINT32, true),
  ssoUrl: ProtoField(90, ScalarType.STRING, true),
  extra: ProtoField(120, ScalarType.BYTES, true)
};
const OidbSvcTrpcTcp0XE37_800_1200Metadata = {
  uin: ProtoField(1, ScalarType.UINT32, true),
  field2: ProtoField(2, ScalarType.UINT32, true),
  field3: ProtoField(3, ScalarType.UINT32, true),
  size: ProtoField(4, ScalarType.UINT32, true),
  timestamp: ProtoField(5, ScalarType.UINT32, true),
  fileUuid: ProtoField(6, ScalarType.STRING, true),
  fileName: ProtoField(7, ScalarType.STRING, true),
  field100: ProtoField(100, ScalarType.BYTES, true),
  field101: ProtoField(101, ScalarType.BYTES, true),
  field110: ProtoField(110, ScalarType.UINT32, true),
  timestamp1: ProtoField(130, ScalarType.UINT32, true),
  fileHash: ProtoField(140, ScalarType.STRING, true),
  field141: ProtoField(141, ScalarType.BYTES, true),
  field142: ProtoField(142, ScalarType.BYTES, true)
};

const OidbSvcTrpcTcp0XE37_1700 = {
  command: ProtoField(1, ScalarType.UINT32, true),
  seq: ProtoField(2, ScalarType.INT32, true),
  upload: ProtoField(19, () => ApplyUploadReqV3, true),
  businessId: ProtoField(101, ScalarType.INT32, true),
  clientType: ProtoField(102, ScalarType.INT32, true),
  flagSupportMediaPlatform: ProtoField(200, ScalarType.INT32, true)
};
const ApplyUploadReqV3 = {
  senderUid: ProtoField(10, ScalarType.STRING, true),
  receiverUid: ProtoField(20, ScalarType.STRING, true),
  fileSize: ProtoField(30, ScalarType.UINT32, true),
  fileName: ProtoField(40, ScalarType.STRING, true),
  md510MCheckSum: ProtoField(50, ScalarType.BYTES, true),
  sha1CheckSum: ProtoField(60, ScalarType.BYTES, true),
  localPath: ProtoField(70, ScalarType.STRING, true),
  md5CheckSum: ProtoField(110, ScalarType.BYTES, true),
  sha3CheckSum: ProtoField(120, ScalarType.BYTES, true)
};

const OidbSvcTrpcTcp0XE37_800 = {
  subCommand: ProtoField(1, ScalarType.UINT32),
  field2: ProtoField(2, ScalarType.INT32),
  body: ProtoField(10, () => OidbSvcTrpcTcp0XE37_800Body, true),
  field101: ProtoField(101, ScalarType.INT32),
  field102: ProtoField(102, ScalarType.INT32),
  field200: ProtoField(200, ScalarType.INT32)
};
const OidbSvcTrpcTcp0XE37_800Body = {
  senderUid: ProtoField(10, ScalarType.STRING, true),
  receiverUid: ProtoField(20, ScalarType.STRING, true),
  fileUuid: ProtoField(30, ScalarType.STRING, true),
  fileHash: ProtoField(40, ScalarType.STRING, true)
};
const OidbSvcTrpcTcp0XE37Response = {
  command: ProtoField(1, ScalarType.UINT32),
  seq: ProtoField(2, ScalarType.INT32),
  upload: ProtoField(19, () => ApplyUploadRespV3, true),
  businessId: ProtoField(101, ScalarType.INT32),
  clientType: ProtoField(102, ScalarType.INT32),
  flagSupportMediaPlatform: ProtoField(200, ScalarType.INT32)
};
const ApplyUploadRespV3 = {
  retCode: ProtoField(10, ScalarType.INT32),
  retMsg: ProtoField(20, ScalarType.STRING, true),
  totalSpace: ProtoField(30, ScalarType.INT64),
  usedSpace: ProtoField(40, ScalarType.INT64),
  uploadedSize: ProtoField(50, ScalarType.INT64),
  uploadIp: ProtoField(60, ScalarType.STRING, true),
  uploadDomain: ProtoField(70, ScalarType.STRING, true),
  uploadPort: ProtoField(80, ScalarType.UINT32),
  uuid: ProtoField(90, ScalarType.STRING, true),
  uploadKey: ProtoField(100, ScalarType.BYTES, true),
  boolFileExist: ProtoField(110, ScalarType.BOOL),
  packSize: ProtoField(120, ScalarType.INT32),
  uploadIpList: ProtoField(130, ScalarType.STRING, false, true),
  // repeated
  uploadHttpsPort: ProtoField(140, ScalarType.INT32),
  uploadHttpsDomain: ProtoField(150, ScalarType.STRING, true),
  uploadDns: ProtoField(160, ScalarType.STRING, true),
  uploadLanip: ProtoField(170, ScalarType.STRING, true),
  fileAddon: ProtoField(200, ScalarType.STRING, true),
  mediaPlatformUploadKey: ProtoField(220, ScalarType.BYTES, true)
};
({
  command: ProtoField(1, ScalarType.UINT32, true),
  subCommand: ProtoField(2, ScalarType.UINT32, true),
  field50: ProtoField(50, ScalarType.UINT32, true)
});
({
  field10: ProtoField(10, ScalarType.UINT32, true)});

const OidbSvcTrpcTcp0XEB7_Body = {
  uin: ProtoField(1, ScalarType.STRING),
  groupUin: ProtoField(2, ScalarType.STRING),
  version: ProtoField(3, ScalarType.STRING)
};
const OidbSvcTrpcTcp0XEB7 = {
  body: ProtoField(2, () => OidbSvcTrpcTcp0XEB7_Body)
};

const OidbSvcTrpcTcp0XED3_1 = {
  uin: ProtoField(1, ScalarType.UINT32),
  groupUin: ProtoField(2, ScalarType.UINT32),
  friendUin: ProtoField(5, ScalarType.UINT32),
  ext: ProtoField(6, ScalarType.UINT32, true)
};

const OidbSvcTrpcTcp0XFE1_2 = {
  uin: ProtoField(1, ScalarType.UINT32),
  key: ProtoField(3, () => OidbSvcTrpcTcp0XFE1_2Key, false, true)
};
const OidbSvcTrpcTcp0XFE1_2Key = {
  key: ProtoField(1, ScalarType.UINT32)
};
const OidbSvcTrpcTcp0XFE1_2RSP_Status = {
  key: ProtoField(1, ScalarType.UINT32),
  value: ProtoField(2, ScalarType.UINT64)
};
const OidbSvcTrpcTcp0XFE1_2RSP_Data = {
  status: ProtoField(2, () => OidbSvcTrpcTcp0XFE1_2RSP_Status)
};
const OidbSvcTrpcTcp0XFE1_2RSP = {
  data: ProtoField(1, () => OidbSvcTrpcTcp0XFE1_2RSP_Data)
};

const OidbSvcTrpcTcpBase = {
  command: ProtoField(1, ScalarType.UINT32),
  subCommand: ProtoField(2, ScalarType.UINT32),
  errorCode: ProtoField(3, ScalarType.UINT32),
  body: ProtoField(4, ScalarType.BYTES),
  errorMsg: ProtoField(5, ScalarType.STRING, true),
  isReserved: ProtoField(12, ScalarType.UINT32)
};
({
  body: ProtoField(4, ScalarType.BYTES)
});

const OidbSvcTrpcTcp0xE07_0 = {
  version: ProtoField(1, ScalarType.UINT32),
  client: ProtoField(2, ScalarType.UINT32),
  entrance: ProtoField(3, ScalarType.UINT32),
  ocrReqBody: ProtoField(10, () => OcrReqBody, true)
};
const OcrReqBody = {
  imageUrl: ProtoField(1, ScalarType.STRING),
  languageType: ProtoField(2, ScalarType.UINT32),
  scene: ProtoField(3, ScalarType.UINT32),
  originMd5: ProtoField(10, ScalarType.STRING),
  afterCompressMd5: ProtoField(11, ScalarType.STRING),
  afterCompressFileSize: ProtoField(12, ScalarType.STRING),
  afterCompressWeight: ProtoField(13, ScalarType.STRING),
  afterCompressHeight: ProtoField(14, ScalarType.STRING),
  isCut: ProtoField(15, ScalarType.BOOL)
};
const OidbSvcTrpcTcp0xE07_0_Response = {
  retCode: ProtoField(1, ScalarType.INT32),
  errMsg: ProtoField(2, ScalarType.STRING),
  wording: ProtoField(3, ScalarType.STRING),
  ocrRspBody: ProtoField(10, () => OcrRspBody)
};
const OcrRspBody = {
  textDetections: ProtoField(1, () => TextDetection, false, true),
  language: ProtoField(2, ScalarType.STRING),
  requestId: ProtoField(3, ScalarType.STRING),
  ocrLanguageList: ProtoField(101, ScalarType.STRING, false, true),
  dstTranslateLanguageList: ProtoField(102, ScalarType.STRING, false, true),
  languageList: ProtoField(103, () => Language, false, true),
  afterCompressWeight: ProtoField(111, ScalarType.UINT32),
  afterCompressHeight: ProtoField(112, ScalarType.UINT32)
};
const TextDetection = {
  detectedText: ProtoField(1, ScalarType.STRING),
  confidence: ProtoField(2, ScalarType.UINT32),
  polygon: ProtoField(3, () => Polygon),
  advancedInfo: ProtoField(4, ScalarType.STRING)
};
const Polygon = {
  coordinates: ProtoField(1, () => Coordinate, false, true)
};
const Coordinate = {
  x: ProtoField(1, ScalarType.INT32),
  y: ProtoField(2, ScalarType.INT32)
};
const Language = {
  languageCode: ProtoField(1, ScalarType.STRING),
  languageDesc: ProtoField(2, ScalarType.STRING)
};

const OidbSvcTrpcTcp0XF90_1 = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  msgSeq: ProtoField(2, ScalarType.UINT64)
};

class IHighwayUploader {
  trans;
  logger;
  constructor(trans, logger) {
    this.trans = trans;
    this.logger = logger;
  }
  // TODO: 没用到的加密方法先注释掉
  // private encryptTransExt (key: Uint8Array) {
  //   if (!this.trans.encrypt) return;
  //   this.trans.ext = tea.encrypt(Buffer.from(this.trans.ext), Buffer.from(key));
  // }
  timeout() {
    return new Promise((_resolve, reject) => {
      setTimeout(
        () => {
          reject(new Error(`[Highway] timeout after ${this.trans.timeout}s`));
        },
        (this.trans.timeout ?? Infinity) * 1e3
      );
    });
  }
  buildPicUpHead(offset, bodyLength, bodyMd5) {
    return new NapProtoMsg(ReqDataHighwayHead).encode({
      msgBaseHead: {
        version: 1,
        uin: this.trans.uin,
        command: "PicUp.DataUp",
        seq: 0,
        retryTimes: 0,
        appId: 1600001604,
        dataFlag: 16,
        commandId: this.trans.cmd
      },
      msgSegHead: {
        serviceId: 0,
        filesize: BigInt(this.trans.size),
        dataOffset: BigInt(offset),
        dataLength: bodyLength,
        serviceTicket: this.trans.ticket,
        md5: bodyMd5,
        fileMd5: this.trans.sum,
        cacheAddr: 0,
        cachePort: 0
      },
      bytesReqExtendInfo: this.trans.ext,
      timestamp: BigInt(0),
      msgLoginSigHead: {
        uint32LoginSigType: 8,
        appId: 1600001604
      }
    });
  }
}

class HighwayTcpUploaderTransform extends stream__default.Transform {
  uploader;
  offset;
  constructor(uploader) {
    super();
    this.uploader = uploader;
    this.offset = 0;
  }
  _transform(data, _, callback) {
    let chunkOffset = 0;
    while (chunkOffset < data.length) {
      const chunkSize = Math.min(BlockSize, data.length - chunkOffset);
      const chunk = data.subarray(chunkOffset, chunkOffset + chunkSize);
      const chunkMd5 = crypto__default$1.createHash("md5").update(chunk).digest();
      const head = this.uploader.buildPicUpHead(this.offset, chunk.length, chunkMd5);
      chunkOffset += chunk.length;
      this.offset += chunk.length;
      this.push(Frame.pack(Buffer.from(head), chunk));
    }
    callback(null);
  }
}
class HighwayTcpUploader extends IHighwayUploader {
  async upload() {
    const controller = new AbortController();
    const { signal } = controller;
    const upload = new Promise((resolve, reject) => {
      const highwayTransForm = new HighwayTcpUploaderTransform(this);
      const socket = net__default.connect(this.trans.port, this.trans.server, () => {
        this.trans.data.pipe(highwayTransForm).pipe(socket, { end: false });
      });
      const handleRspHeader = (header) => {
        const rsp = new NapProtoMsg(RespDataHighwayHead).decode(header);
        if (rsp.errorCode !== 0) {
          socket.end();
          reject(new Error(`[Highway] tcpUpload failed (code=${rsp.errorCode})`));
        }
        const percent = ((Number(rsp.msgSegHead?.dataOffset) + Number(rsp.msgSegHead?.dataLength)) / Number(rsp.msgSegHead?.filesize)).toFixed(2);
        this.logger.debug(`[Highway] tcpUpload ${rsp.errorCode} | ${percent} | ${Buffer.from(header).toString("hex")}`);
        if (Number(rsp.msgSegHead?.dataOffset) + Number(rsp.msgSegHead?.dataLength) >= Number(rsp.msgSegHead?.filesize)) {
          this.logger.debug("[Highway] tcpUpload finished.");
          socket.end();
          resolve();
        }
      };
      socket.on("data", (chunk) => {
        if (signal.aborted) {
          socket.end();
          reject(new Error("Upload aborted due to timeout"));
        }
        const [head] = Frame.unpack(chunk);
        handleRspHeader(head);
      });
      socket.on("close", () => {
        this.logger.debug("[Highway] tcpUpload socket closed.");
        resolve();
      });
      socket.on("error", (err) => {
        socket.end();
        reject(new Error(`[Highway] tcpUpload socket.on error: ${err}`));
      });
      this.trans.data.on("error", (err) => {
        socket.end();
        reject(new Error(`[Highway] tcpUpload readable error: ${err}`));
      });
    });
    const timeout = this.timeout().catch((err) => {
      controller.abort();
      throw new Error(err.message);
    });
    await Promise.race([upload, timeout]);
  }
}

class HighwayHttpUploader extends IHighwayUploader {
  async upload() {
    const controller = new AbortController();
    const { signal } = controller;
    const upload = (async () => {
      let offset = 0;
      for await (const chunk of this.trans.data) {
        if (signal.aborted) {
          throw new Error("Upload aborted due to timeout");
        }
        const block = chunk;
        try {
          await this.uploadBlock(block, offset);
        } catch (err) {
          throw new Error(`[Highway] httpUpload Error uploading block at offset ${offset}: ${err}`);
        }
        offset += block.length;
      }
    })();
    const timeout = this.timeout().catch((err) => {
      controller.abort();
      throw new Error(err.message);
    });
    await Promise.race([upload, timeout]);
  }
  async uploadBlock(block, offset) {
    const chunkMD5 = crypto__default$1.createHash("md5").update(block).digest();
    const payload = this.buildPicUpHead(offset, block.length, chunkMD5);
    const frame = Frame.pack(Buffer.from(payload), block);
    const resp = await this.httpPostHighwayContent(frame, `http://${this.trans.server}:${this.trans.port}/cgi-bin/httpconn?htcmd=0x6FF0087&uin=${this.trans.uin}`);
    const [head, body] = Frame.unpack(resp);
    const headData = new NapProtoMsg(RespDataHighwayHead).decode(head);
    this.logger.debug(`[Highway] httpUploadBlock: ${headData.errorCode} | ${headData.msgSegHead?.retCode} | ${headData.bytesRspExtendInfo} | ${head.toString("hex")} | ${body.toString("hex")}`);
    if (headData.errorCode !== 0) throw new Error(`[Highway] httpUploadBlock failed (code=${headData.errorCode})`);
  }
  async httpPostHighwayContent(frame, serverURL) {
    return new Promise((resolve, reject) => {
      try {
        const options = {
          method: "POST",
          headers: {
            Connection: "keep-alive",
            "Accept-Encoding": "identity",
            "User-Agent": "Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.2)",
            "Content-Length": frame.length.toString()
          }
        };
        const req = http.request(serverURL, options, (res) => {
          const data = [];
          res.on("data", (chunk) => {
            data.push(chunk);
          });
          res.on("end", () => {
            resolve(Buffer.concat(data));
          });
        });
        req.write(frame);
        req.on("error", (error) => {
          reject(error);
        });
      } catch (error) {
        reject(new Error(error.message));
      }
    });
  }
}

class PacketHighwayClient {
  sig;
  server = "htdata3.qq.com";
  port = 80;
  logger;
  constructor(sig, logger, _server = "htdata3.qq.com", _port = 80) {
    this.sig = sig;
    this.logger = logger;
  }
  changeServer(server, port) {
    this.server = server;
    this.port = port;
  }
  buildDataUpTrans(cmd, data, fileSize, md5, extendInfo, timeout = 1200) {
    return {
      uin: this.sig.uin,
      cmd,
      command: "PicUp.DataUp",
      data,
      sum: md5,
      size: fileSize,
      ticket: this.sig.sigSession,
      ext: extendInfo,
      encrypt: false,
      timeout,
      server: this.server,
      port: this.port
    };
  }
  async upload(cmd, data, fileSize, md5, extendInfo) {
    const trans = this.buildDataUpTrans(cmd, data, fileSize, md5, extendInfo);
    try {
      const tcpUploader = new HighwayTcpUploader(trans, this.logger);
      await tcpUploader.upload();
    } catch (e) {
      this.logger.error(`[Highway] upload failed: ${e}, fallback to http upload`);
      try {
        const httpUploader = new HighwayHttpUploader(trans, this.logger);
        await httpUploader.upload();
      } catch (e2) {
        this.logger.error(`[Highway] http upload failed: ${e2}`);
        throw e2;
      }
    }
  }
}

class ForwardMsgBuilder {
  static build(resId, msg, source, news, summary, prompt) {
    const id = crypto$1.randomUUID();
    const isGroupMsg = msg.some((m) => m.isGroupMsg);
    if (!source) {
      source = msg.length === 0 ? "聊天记录" : isGroupMsg ? "群聊的聊天记录" : msg.map((m) => m.senderName).filter((v, i, a) => a.indexOf(v) === i).slice(0, 4).join("和") + "的聊天记录";
    }
    if (!news) {
      news = msg.length === 0 ? [{
        text: "Nya~ This message is send from NapCat.Packet!"
      }] : msg.map((m) => ({
        text: `${m.senderName}: ${m.msg?.map((msg2) => msg2.preview).join("")}`
      }));
    }
    if (!summary) {
      summary = `查看${msg.length}条转发消息`;
    }
    if (!prompt) {
      prompt = "[聊天记录]";
    }
    return {
      app: "com.tencent.multimsg",
      config: {
        autosize: 1,
        forward: 1,
        round: 1,
        type: "normal",
        width: 300
      },
      desc: prompt,
      extra: {
        filename: id,
        tsum: msg.length
      },
      meta: {
        detail: {
          news,
          resid: resId,
          source,
          summary,
          uniseq: id
        }
      },
      prompt,
      ver: "0.0.0.5",
      view: "contact"
    };
  }
  static fromResId(resId) {
    return this.build(resId, []);
  }
  static fromPacketMsg(resId, packetMsg, source, news, summary, prompt) {
    return this.build(resId, packetMsg.map((msg) => ({
      senderName: msg.senderName,
      isGroupMsg: msg.groupId !== void 0,
      msg: msg.msg.map((m) => ({
        preview: m.valid ? m.toPreview() : "[该消息类型暂不支持查看]"
      }))
    })), source, news, summary, prompt);
  }
}

class IPacketMsgElement {
  constructor(_rawElement) {
  }
  get valid() {
    return true;
  }
  buildContent() {
    return void 0;
  }
  buildElement() {
    return [];
  }
  static parseElement;
  toPreview() {
    return "[暂不支持该消息类型喵~]";
  }
}
class PacketMsgTextElement extends IPacketMsgElement {
  text;
  constructor(element) {
    super(element);
    this.text = element.textElement.content;
  }
  buildElement() {
    return [{
      text: {
        str: this.text
      }
    }];
  }
  static parseElement = (elem) => {
    if (elem.text?.str && (elem.text?.attr6Buf === void 0 || elem.text?.attr6Buf?.length === 0)) {
      return [{
        textElement: {
          content: elem.text?.str,
          atType: NTMsgAtType.ATTYPEUNKNOWN,
          atUid: "",
          atTinyId: "",
          atNtUid: ""
        },
        elementType: ElementType.UNKNOWN,
        elementId: ""
      }, null];
    }
    return void 0;
  };
  toPreview() {
    return this.text;
  }
}
class PacketMsgAtElement extends PacketMsgTextElement {
  targetUid;
  atAll;
  constructor(element) {
    super(element);
    this.targetUid = element.textElement.atNtUid;
    this.atAll = element.textElement.atType === NTMsgAtType.ATTYPEALL;
  }
  buildElement() {
    return [{
      text: {
        str: this.text,
        pbReserve: new NapProtoMsg(MentionExtra).encode(
          {
            type: this.atAll ? 1 : 2,
            uin: 0,
            field5: 0,
            uid: this.targetUid
          }
        )
      }
    }];
  }
  static parseElement = (elem) => {
    if (elem.text?.str && (elem.text?.attr6Buf?.length ?? 100) >= 11) {
      return [{
        textElement: {
          content: elem.text?.str,
          atType: NTMsgAtType.ATTYPEONE,
          atUid: String(Buffer.from(elem.text.attr6Buf).readUInt32BE(7)),
          // FIXME: hack
          atTinyId: "",
          atNtUid: ""
        },
        elementType: ElementType.UNKNOWN,
        elementId: ""
      }, null];
    }
    return void 0;
  };
}
class PacketMsgReplyElement extends IPacketMsgElement {
  time;
  targetMessageId;
  targetMessageSeq;
  targetMessageClientSeq;
  targetUin;
  targetUid;
  targetElems;
  targetSourceMsg;
  targetPeer;
  constructor(element) {
    super(element);
    this.time = +(element.replyElement.replyMsgTime ?? Math.floor(Date.now() / 1e3));
    this.targetMessageId = BigInt(element.replyElement.replayMsgId ?? 0);
    this.targetMessageSeq = +(element.replyElement.replayMsgSeq ?? 0);
    this.targetMessageClientSeq = +(element.replyElement.replyMsgClientSeq ?? 0);
    this.targetUin = +(element.replyElement.senderUin ?? 0);
    this.targetUid = element.replyElement.senderUidStr ?? "";
    this.targetPeer = element.replyElement._replyMsgPeer;
  }
  get isGroupReply() {
    return this.targetMessageClientSeq === 0;
  }
  buildElement() {
    return [{
      srcMsg: {
        origSeqs: [this.isGroupReply ? this.targetMessageSeq : this.targetMessageClientSeq],
        senderUin: BigInt(this.targetUin),
        time: this.time,
        elems: this.targetElems ?? [],
        sourceMsg: new NapProtoMsg(PushMsgBody).encode(this.targetSourceMsg ?? {}),
        toUin: BigInt(0)
      }
    }];
  }
  static parseElement = (elem) => {
    if (elem.srcMsg && elem.srcMsg.pbReserve) {
      const reserve = elem.srcMsg.pbReserve;
      return [{
        replyElement: {
          replayMsgSeq: String(reserve.friendSeq ?? elem.srcMsg?.origSeqs?.[0] ?? 0),
          replayMsgId: String(reserve.messageId ?? 0),
          senderUin: String(elem?.srcMsg ?? 0)
        },
        elementType: ElementType.UNKNOWN,
        elementId: ""
      }, null];
    }
    return void 0;
  };
  toPreview() {
    return "[回复消息]";
  }
}
class PacketMsgFaceElement extends IPacketMsgElement {
  faceId;
  isLargeFace;
  resultId;
  constructor(element) {
    super(element);
    this.faceId = element.faceElement.faceIndex;
    this.resultId = element.faceElement.resultId;
    this.isLargeFace = element.faceElement.faceType === FaceType.AniSticke;
  }
  buildElement() {
    if (this.isLargeFace) {
      return [{
        commonElem: {
          serviceType: 37,
          pbElem: new NapProtoMsg(QBigFaceExtra).encode({
            aniStickerPackId: "1",
            aniStickerId: "8",
            faceId: this.faceId,
            sourceType: 1,
            resultId: this.resultId,
            preview: "",
            randomType: 1
          }),
          businessType: 1
        }
      }];
    } else if (this.faceId < 260) {
      return [{
        face: {
          index: this.faceId
        }
      }];
    } else {
      return [{
        commonElem: {
          serviceType: 33,
          pbElem: new NapProtoMsg(QSmallFaceExtra).encode({
            faceId: this.faceId,
            preview: "",
            preview2: ""
          }),
          businessType: 1
        }
      }];
    }
  }
  static parseElement = (elem) => {
    if (elem.face?.index) {
      return [{
        faceElement: {
          faceIndex: elem.face.index,
          faceType: FaceType.Normal
        },
        elementType: ElementType.UNKNOWN,
        elementId: ""
      }, null];
    }
    if (elem?.commonElem?.serviceType === 37 && elem?.commonElem?.pbElem) {
      const qface = new NapProtoMsg(QBigFaceExtra).decode(elem?.commonElem?.pbElem);
      if (qface?.faceId) {
        return [{
          faceElement: {
            faceIndex: qface.faceId,
            faceType: FaceType.Normal
          },
          elementType: ElementType.UNKNOWN,
          elementId: ""
        }, null];
      }
    }
    if (elem?.commonElem?.serviceType === 33 && elem?.commonElem?.pbElem) {
      const qface = new NapProtoMsg(QSmallFaceExtra).decode(elem?.commonElem?.pbElem);
      if (qface?.faceId) {
        return [{
          faceElement: {
            faceIndex: qface.faceId,
            faceType: FaceType.Normal
          },
          elementType: ElementType.UNKNOWN,
          elementId: ""
        }, null];
      }
    }
    return void 0;
  };
  toPreview() {
    return "[表情]";
  }
}
class PacketMsgMarkFaceElement extends IPacketMsgElement {
  emojiName;
  emojiId;
  emojiPackageId;
  emojiKey;
  constructor(element) {
    super(element);
    this.emojiName = element.marketFaceElement.faceName;
    this.emojiId = element.marketFaceElement.emojiId;
    this.emojiPackageId = element.marketFaceElement.emojiPackageId;
    this.emojiKey = element.marketFaceElement.key;
  }
  buildElement() {
    return [{
      marketFace: {
        faceName: this.emojiName,
        itemType: 6,
        faceInfo: 1,
        faceId: Buffer.from(this.emojiId, "hex"),
        tabId: this.emojiPackageId,
        subType: 3,
        key: this.emojiKey,
        imageWidth: 300,
        imageHeight: 300,
        pbReserve: {
          field8: 1
        }
      }
    }];
  }
  toPreview() {
    return `${this.emojiName}`;
  }
}
class PacketMsgPicElement extends IPacketMsgElement {
  path;
  name;
  size;
  md5;
  width;
  height;
  picType;
  picSubType;
  summary;
  sha1 = null;
  msgInfo = null;
  groupPicExt = null;
  c2cPicExt = null;
  constructor(element) {
    super(element);
    this.path = element.picElement.sourcePath;
    this.name = element.picElement.fileName;
    this.size = +element.picElement.fileSize;
    this.md5 = element.picElement.md5HexStr ?? "";
    this.width = element.picElement.picWidth;
    this.height = element.picElement.picHeight;
    this.picType = element.picElement.picType;
    this.picSubType = element.picElement.picSubType ?? 0;
    this.summary = element.picElement.summary === "" ? element.picElement.picSubType === 0 ? "[图片]" : "[动画表情]" : element.picElement.summary;
  }
  get valid() {
    return !!this.msgInfo;
  }
  buildElement() {
    if (!this.msgInfo) return [];
    return [{
      commonElem: {
        serviceType: 48,
        pbElem: new NapProtoMsg(MsgInfo).encode(this.msgInfo),
        businessType: 10
      }
    }];
  }
  static parseElement = (elem) => {
    if (elem?.commonElem?.serviceType === 48 || [10, 20].includes(elem?.commonElem?.businessType ?? 0)) {
      const extra = new NapProtoMsg(MsgInfo).decode(elem.commonElem.pbElem);
      const msgInfoBody = extra.msgInfoBody[0];
      const index = msgInfoBody?.index;
      return [{
        picElement: {
          fileSize: index?.info.fileSize ?? 0,
          picWidth: index?.info?.width ?? 0,
          picHeight: index?.info?.height ?? 0,
          fileName: index?.info?.fileHash ?? "",
          sourcePath: "",
          original: false,
          picType: PicType.NEWPIC_APNG,
          fileUuid: "",
          fileSubId: "",
          thumbFileSize: 0,
          summary: "[图片]",
          thumbPath: /* @__PURE__ */ new Map()
        },
        elementType: ElementType.UNKNOWN,
        elementId: ""
      }, elem];
    }
    if (elem?.notOnlineImage) {
      const img = elem?.notOnlineImage;
      const preImg = {
        picElement: {
          fileSize: img.fileLen ?? 0,
          picWidth: img.picWidth ?? 0,
          picHeight: img.picHeight ?? 0,
          fileName: Buffer.from(img.picMd5).toString("hex") ?? "",
          sourcePath: "",
          original: false,
          picType: PicType.NEWPIC_APNG,
          fileUuid: "",
          fileSubId: "",
          thumbFileSize: 0,
          summary: "[图片]",
          thumbPath: /* @__PURE__ */ new Map()
        },
        elementType: ElementType.UNKNOWN,
        elementId: ""
      };
      if (img.origUrl?.includes("&fileid=")) {
        preImg.picElement.originImageUrl = `https://multimedia.nt.qq.com.cn${img.origUrl}`;
      } else {
        preImg.picElement.originImageUrl = `https://gchat.qpic.cn${img.origUrl}`;
      }
      return [preImg, elem];
    }
    return void 0;
  };
  toPreview() {
    return this.summary;
  }
}
class PacketMsgVideoElement extends IPacketMsgElement {
  fileSize;
  filePath;
  thumbSize;
  thumbPath;
  fileMd5;
  fileSha1;
  thumbMd5;
  thumbSha1;
  thumbWidth;
  thumbHeight;
  msgInfo = null;
  constructor(element) {
    super(element);
    this.fileSize = element.videoElement.fileSize;
    this.filePath = element.videoElement.filePath;
    this.thumbSize = element.videoElement.thumbSize;
    this.thumbPath = element.videoElement.thumbPath?.get(0);
    this.fileMd5 = element.videoElement.videoMd5;
    this.thumbMd5 = element.videoElement.thumbMd5;
    this.thumbWidth = element.videoElement.thumbWidth;
    this.thumbHeight = element.videoElement.thumbHeight;
  }
  get valid() {
    return !!this.msgInfo;
  }
  buildElement() {
    if (!this.msgInfo) return [];
    return [{
      commonElem: {
        serviceType: 48,
        pbElem: new NapProtoMsg(MsgInfo).encode(this.msgInfo),
        businessType: 21
      }
    }];
  }
  toPreview() {
    return "[视频]";
  }
}
class PacketMsgPttElement extends IPacketMsgElement {
  filePath;
  fileSize;
  fileMd5;
  fileSha1;
  fileDuration;
  msgInfo = null;
  constructor(element) {
    super(element);
    this.filePath = element.pttElement.filePath;
    this.fileSize = +element.pttElement.fileSize;
    this.fileMd5 = element.pttElement.md5HexStr;
    this.fileDuration = Math.round(element.pttElement.duration);
  }
  get valid() {
    return false;
  }
  buildElement() {
    return [];
  }
  toPreview() {
    return "[语音]";
  }
}
class PacketMsgFileElement extends IPacketMsgElement {
  fileName;
  filePath;
  fileSize;
  fileSha1;
  fileMd5;
  fileUuid;
  fileHash;
  isGroupFile;
  _private_send_uid;
  _private_recv_uid;
  _e37_800_rsp;
  constructor(element) {
    super(element);
    this.fileName = element.fileElement.fileName;
    this.filePath = element.fileElement.filePath;
    this.fileSize = +element.fileElement.fileSize;
  }
  get valid() {
    return this.isGroupFile || Boolean(this._e37_800_rsp);
  }
  buildContent() {
    if (this.isGroupFile || !this._e37_800_rsp) return void 0;
    return new NapProtoMsg(FileExtra).encode({
      file: {
        fileType: 0,
        fileUuid: this.fileUuid,
        fileMd5: this.fileMd5,
        fileName: this.fileName,
        fileSize: BigInt(this.fileSize),
        subcmd: 1,
        dangerEvel: 0,
        expireTime: Math.floor(Date.now() / 1e3) + 7 * 24 * 60 * 60,
        fileHash: this.fileHash
      },
      field6: {
        field2: {
          field1: this._e37_800_rsp?.body?.field30?.field110,
          fileUuid: this.fileUuid,
          fileName: this.fileName,
          field6: this._e37_800_rsp?.body?.field30?.field3,
          field7: this._e37_800_rsp?.body?.field30?.field101,
          field8: this._e37_800_rsp?.body?.field30?.field100,
          timestamp1: this._e37_800_rsp?.body?.field30?.timestamp1,
          fileHash: this.fileHash,
          selfUid: this._private_send_uid,
          destUid: this._private_recv_uid
        }
      }
    });
  }
  buildElement() {
    if (!this.isGroupFile) return [];
    const lb = Buffer.alloc(2);
    const transElemVal = new NapProtoMsg(GroupFileExtra).encode({
      field1: 6,
      fileName: this.fileName,
      inner: {
        info: {
          busId: 102,
          fileId: this.fileUuid,
          fileSize: BigInt(this.fileSize),
          fileName: this.fileName,
          fileSha: this.fileSha1,
          extInfoString: "",
          fileMd5: this.fileMd5
        }
      }
    });
    lb.writeUInt16BE(transElemVal.length);
    return [{
      transElem: {
        elemType: 24,
        elemValue: Buffer.concat([Buffer.from([1]), lb, transElemVal])
        // TLV
      }
    }];
  }
  toPreview() {
    return `[文件]${this.fileName}`;
  }
}
class PacketMsgLightAppElement extends IPacketMsgElement {
  payload;
  constructor(element) {
    super(element);
    this.payload = element.arkElement.bytesData;
  }
  buildElement() {
    return [{
      lightAppElem: {
        data: Buffer.concat([
          Buffer.from([1]),
          zlib.deflateSync(Buffer.from(this.payload, "utf-8"))
        ])
      }
    }];
  }
  toPreview() {
    return "[卡片消息]";
  }
}
class PacketMsgMarkDownElement extends IPacketMsgElement {
  content;
  constructor(element) {
    super(element);
    this.content = element.markdownElement.content;
  }
  buildElement() {
    return [{
      commonElem: {
        serviceType: 45,
        pbElem: new NapProtoMsg(MarkdownData).encode({
          content: this.content
        }),
        businessType: 1
      }
    }];
  }
  toPreview() {
    return `[Markdown消息 ${this.content}]`;
  }
}
class PacketMultiMsgElement extends IPacketMsgElement {
  resid;
  message;
  constructor(rawElement, message) {
    super(rawElement);
    this.resid = rawElement.multiForwardMsgElement.resId;
    this.message = message ?? [];
  }
  buildElement() {
    return [{
      lightAppElem: {
        data: Buffer.concat([
          Buffer.from([1]),
          zlib.deflateSync(Buffer.from(JSON.stringify(ForwardMsgBuilder.fromPacketMsg(this.resid, this.message)), "utf-8"))
        ])
      }
    }];
  }
  toPreview() {
    return "[聊天记录]";
  }
}

class PacketMsgBuilder {
  static failBackText = new PacketMsgTextElement(
    {
      textElement: { content: "[该消息类型暂不支持查看]" }
    }
  );
  buildFakeMsg(selfUid, element) {
    return element.map((node) => {
      const avatar = `https://q.qlogo.cn/headimg_dl?dst_uin=${node.senderUin}&spec=0&img_type=jpg`;
      const msgContent = node.msg.reduceRight((acc, msg) => {
        return acc ?? msg.buildContent();
      }, void 0);
      const msgElement = node.msg.flatMap((msg) => msg.buildElement() ?? []);
      if (!msgContent && !msgElement.length) {
        msgElement.push(PacketMsgBuilder.failBackText.buildElement());
      }
      return {
        responseHead: {
          fromUin: node.senderUin,
          type: 0,
          sigMap: 0,
          toUin: 0,
          fromUid: "",
          forward: node.groupId ? void 0 : {
            friendName: node.senderName
          },
          toUid: node.groupId ? void 0 : selfUid,
          grp: node.groupId ? {
            groupUin: node.groupId,
            memberName: node.senderName,
            unknown5: 2
          } : void 0
        },
        contentHead: {
          type: node.groupId ? 82 : 9,
          subType: node.groupId ? void 0 : 4,
          divSeq: node.groupId ? void 0 : 4,
          autoReply: 0,
          sequence: crypto$2.randomBytes(4).readUInt32LE(0),
          timeStamp: +node.time.toString().substring(0, 10),
          forward: {
            field1: 0,
            field2: 0,
            field3: node.groupId ? 1 : 2,
            unknownBase64: avatar,
            avatar
          }
        },
        body: {
          richText: {
            elems: msgElement
          },
          msgContent
        }
      };
    });
  }
}

const PacketBufBuilder = (str) => {
  return Buffer.from(str);
};
class PacketTransformer {
  msgBuilder;
  constructor() {
    this.msgBuilder = new PacketMsgBuilder();
  }
}

class FetchSessionKey extends PacketTransformer {
  build() {
    const req = new NapProtoMsg(HttpConn0x6ff_501).encode({
      httpConn: {
        field1: 0,
        field2: 0,
        field3: 16,
        field4: 1,
        field6: 3,
        serviceTypes: [1, 5, 10, 21],
        // tgt: "",  // TODO: do we really need tgt? seems not
        field9: 2,
        field10: 9,
        field11: 8,
        ver: "1.0.1"
      }
    });
    return {
      cmd: "HttpConn.0x6ff_501",
      data: PacketBufBuilder(req)
    };
  }
  parse(data) {
    return new NapProtoMsg(HttpConn0x6ff_501Response).decode(data);
  }
}
const FetchSessionKey$1 = new FetchSessionKey();

const int32ip2str = (ip) => {
  ip = ip & 4294967295;
  return [ip & 255, (ip & 65280) >> 8, (ip & 16711680) >> 16, (ip & 4278190080) >> 24 & 255].join(".");
};
const oidbIpv4s2HighwayIpv4s = (ipv4s) => {
  return ipv4s.map((ip) => {
    return {
      domain: {
        isEnable: true,
        ip: int32ip2str(ip.outIP ?? 0)
      },
      port: ip.outPort
    };
  });
};

class Sha1Stream {
  Sha1BlockSize = 64;
  Sha1DigestSize = 20;
  _padding = Buffer.concat([Buffer.from([128]), Buffer.alloc(63)]);
  _state = new Uint32Array(5);
  _count = new Uint32Array(2);
  _buffer = Buffer.allocUnsafe(this.Sha1BlockSize);
  _w = new Uint32Array(80);
  constructor() {
    this.reset();
  }
  reset() {
    this._state[0] = 1732584193;
    this._state[1] = 4023233417;
    this._state[2] = 2562383102;
    this._state[3] = 271733878;
    this._state[4] = 3285377520;
    this._count[0] = 0;
    this._count[1] = 0;
    this._buffer.fill(0);
  }
  rotateLeft(v, o) {
    return (v << o | v >>> 32 - o) >>> 0;
  }
  transform(chunk, offset) {
    const w = this._w;
    const view = new DataView(chunk.buffer, chunk.byteOffset + offset, 64);
    for (let i = 0; i < 16; i++) {
      w[i] = view.getUint32(i * 4, false);
    }
    for (let i = 16; i < 80; i++) {
      w[i] = this.rotateLeft(w[i - 3] ^ w[i - 8] ^ w[i - 14] ^ w[i - 16], 1) >>> 0;
    }
    let a = this._state[0];
    let b = this._state[1];
    let c = this._state[2];
    let d = this._state[3];
    let e = this._state[4];
    for (let i = 0; i < 80; i++) {
      let temp;
      if (i < 20) {
        temp = (b & c | ~b & d) + 1518500249;
      } else if (i < 40) {
        temp = (b ^ c ^ d) + 1859775393;
      } else if (i < 60) {
        temp = (b & c | b & d | c & d) + 2400959708;
      } else {
        temp = (b ^ c ^ d) + 3395469782;
      }
      temp += this.rotateLeft(a, 5) + e + w[i] >>> 0;
      e = d;
      d = c;
      c = this.rotateLeft(b, 30) >>> 0;
      b = a;
      a = temp;
    }
    this._state[0] = this._state[0] + a >>> 0;
    this._state[1] = this._state[1] + b >>> 0;
    this._state[2] = this._state[2] + c >>> 0;
    this._state[3] = this._state[3] + d >>> 0;
    this._state[4] = this._state[4] + e >>> 0;
  }
  update(data, len) {
    let index = (this._count[0] >>> 3 & 63) >>> 0;
    const dataLen = len ?? data.length;
    this._count[0] = this._count[0] + (dataLen << 3) >>> 0;
    if (this._count[0] < dataLen << 3) this._count[1] = this._count[1] + 1 >>> 0;
    this._count[1] = this._count[1] + (dataLen >>> 29) >>> 0;
    const partLen = this.Sha1BlockSize - index >>> 0;
    let i = 0;
    if (dataLen >= partLen) {
      data.copy(this._buffer, index, 0, partLen);
      this.transform(this._buffer, 0);
      for (i = partLen; i + this.Sha1BlockSize <= dataLen; i = i + this.Sha1BlockSize >>> 0) {
        this.transform(data, i);
      }
      index = 0;
    }
    data.copy(this._buffer, index, i, dataLen);
  }
  hash(bigEndian = true) {
    const digest = Buffer.allocUnsafe(this.Sha1DigestSize);
    if (bigEndian) {
      for (let i = 0; i < 5; i++) digest.writeUInt32BE(this._state[i], i * 4);
    } else {
      for (let i = 0; i < 5; i++) digest.writeUInt32LE(this._state[i], i * 4);
    }
    return digest;
  }
  final() {
    const digest = Buffer.allocUnsafe(this.Sha1DigestSize);
    const bits = Buffer.allocUnsafe(8);
    bits.writeUInt32BE(this._count[1], 0);
    bits.writeUInt32BE(this._count[0], 4);
    const index = (this._count[0] >>> 3 & 63) >>> 0;
    const padLen = (index < 56 ? 56 - index : 120 - index) >>> 0;
    this.update(this._padding, padLen);
    this.update(bits);
    for (let i = 0; i < 5; i++) {
      digest.writeUInt32BE(this._state[i], i * 4);
    }
    return digest;
  }
}

class CalculateStreamBytesTransform extends stream$3.Transform {
  blockSize = 1024 * 1024;
  sha1;
  buffer;
  bytesRead;
  byteArrayList;
  constructor() {
    super();
    this.sha1 = new Sha1Stream();
    this.buffer = Buffer.alloc(0);
    this.bytesRead = 0;
    this.byteArrayList = [];
  }
  _transform(chunk, _, callback) {
    try {
      this.buffer = Buffer.concat([this.buffer, chunk]);
      let offset = 0;
      while (this.buffer.length - offset >= this.sha1.Sha1BlockSize) {
        const block = this.buffer.subarray(offset, offset + this.sha1.Sha1BlockSize);
        this.sha1.update(block);
        offset += this.sha1.Sha1BlockSize;
        this.bytesRead += this.sha1.Sha1BlockSize;
        if (this.bytesRead % this.blockSize === 0) {
          const digest = this.sha1.hash(false);
          this.byteArrayList.push(Buffer.from(digest));
        }
      }
      this.buffer = this.buffer.subarray(offset);
      callback(null);
    } catch (err) {
      callback(err);
    }
  }
  _flush(callback) {
    try {
      if (this.buffer.length > 0) this.sha1.update(this.buffer);
      const finalDigest = this.sha1.final();
      this.byteArrayList.push(Buffer.from(finalDigest));
      for (const digest of this.byteArrayList) {
        this.push(digest);
      }
      callback(null);
    } catch (err) {
      callback(err);
    }
  }
}

function sha1Stream(readable) {
  return new Promise((resolve, reject) => {
    readable.on("error", reject);
    readable.pipe(crypto$2.createHash("sha1").on("error", reject).on("data", resolve));
  });
}
function md5Stream(readable) {
  return new Promise((resolve, reject) => {
    readable.on("error", reject);
    readable.pipe(crypto$2.createHash("md5").on("error", reject).on("data", resolve));
  });
}
function calculateSha1(filePath) {
  const readable = fs.createReadStream(filePath);
  return sha1Stream(readable);
}
function computeMd5AndLengthWithLimit(filePath, limit) {
  const readStream = fs.createReadStream(filePath, limit ? { start: 0, end: limit - 1 } : {});
  return md5Stream(readStream);
}
function calculateSha1StreamBytes(filePath) {
  return new Promise((resolve, reject) => {
    const readable = fs.createReadStream(filePath);
    const calculateStreamBytes = new CalculateStreamBytesTransform();
    const byteArrayList = [];
    calculateStreamBytes.on("data", (chunk) => {
      byteArrayList.push(chunk);
    });
    calculateStreamBytes.on("end", () => {
      resolve(byteArrayList);
    });
    calculateStreamBytes.on("error", (err) => {
      reject(err);
    });
    readable.pipe(calculateStreamBytes);
  });
}

class OidbBase extends PacketTransformer {
  build(cmd, subCmd, body, isUid = true, _isLafter = false) {
    const data = new NapProtoMsg(OidbSvcTrpcTcpBase).encode({
      command: cmd,
      subCommand: subCmd,
      body,
      isReserved: isUid ? 1 : 0
    });
    return {
      cmd: `OidbSvcTrpcTcp.0x${cmd.toString(16).toUpperCase()}_${subCmd}`,
      data: PacketBufBuilder(data)
    };
  }
  parse(data) {
    const res = new NapProtoMsg(OidbSvcTrpcTcpBase).decode(data);
    if (res.errorCode !== 0) {
      throw new Error(`OidbSvcTrpcTcpBase parse error: ${res.errorMsg} (code=${res.errorCode})`);
    }
    return res;
  }
}
const OidbBase$1 = new OidbBase();

class UploadGroupImage extends PacketTransformer {
  build(groupUin, img) {
    const data = new NapProtoMsg(NTV2RichMediaReq).encode(
      {
        reqHead: {
          common: {
            requestId: 1,
            command: 100
          },
          scene: {
            requestType: 2,
            businessType: 1,
            sceneType: 2,
            group: {
              groupUin
            }
          },
          client: {
            agentType: 2
          }
        },
        upload: {
          uploadInfo: [
            {
              fileInfo: {
                fileSize: +img.size,
                fileHash: img.md5,
                fileSha1: img.sha1,
                fileName: img.name,
                type: {
                  type: 1,
                  picFormat: img.picType,
                  // TODO: extend NapCat imgType /cc @MliKiowa
                  videoFormat: 0,
                  voiceFormat: 0
                },
                width: img.width,
                height: img.height,
                time: 0,
                original: 1
              },
              subFileType: 0
            }
          ],
          tryFastUploadCompleted: true,
          srvSendMsg: false,
          clientRandomId: crypto__default$1.randomBytes(8).readBigUInt64BE() & BigInt("0x7FFFFFFFFFFFFFFF"),
          compatQMsgSceneType: 2,
          extBizInfo: {
            pic: {
              bizType: img.picSubType,
              bytesPbReserveTroop: {
                subType: img.picSubType
              },
              textSummary: img.summary
            },
            video: {
              bytesPbReserve: Buffer.alloc(0)
            },
            ptt: {
              bytesPbReserve: Buffer.alloc(0),
              bytesReserve: Buffer.alloc(0),
              bytesGeneralFlags: Buffer.alloc(0)
            }
          },
          clientSeq: 0,
          noNeedCompatMsg: false
        }
      }
    );
    return OidbBase$1.build(4548, 100, data, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const UploadGroupImage$1 = new UploadGroupImage();

class FetchAiVoiceList extends PacketTransformer {
  build(groupUin, chatType) {
    const data = new NapProtoMsg(OidbSvcTrpcTcp0X929D_0).encode({
      groupUin,
      chatType
    });
    return OidbBase$1.build(37533, 0, data);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(OidbSvcTrpcTcp0X929D_0Resp).decode(oidbBody);
  }
}
const FetchAiVoiceList_default = new FetchAiVoiceList();

class GetAiVoice extends PacketTransformer {
  build(groupUin, voiceId, text, sessionId, chatType) {
    const data = new NapProtoMsg(OidbSvcTrpcTcp0X929B_0).encode({
      groupUin,
      voiceId,
      text,
      chatType,
      session: {
        sessionId
      }
    });
    return OidbBase$1.build(37531, 0, data);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(OidbSvcTrpcTcp0X929B_0Resp).decode(oidbBody);
  }
}
const GetAiVoice_default = new GetAiVoice();

class GetMiniAppAdaptShareInfo extends PacketTransformer {
  build(req) {
    const data = new NapProtoMsg(MiniAppAdaptShareInfoReq).encode({
      appId: req.sdkId,
      body: {
        extInfo: {
          field2: Buffer.alloc(0)
        },
        appid: req.appId,
        title: req.title,
        desc: req.desc,
        time: BigInt(Date.now()),
        scene: req.scene,
        templateType: req.templateType,
        businessType: req.businessType,
        picUrl: req.picUrl,
        vidUrl: "",
        jumpUrl: req.jumpUrl,
        iconUrl: req.iconUrl,
        verType: req.verType,
        shareType: req.shareType,
        versionId: req.versionId,
        withShareTicket: req.withShareTicket,
        webURL: req.webUrl ?? "",
        appidRich: Buffer.alloc(0),
        template: {
          templateId: "",
          templateData: ""
        },
        field20: ""
      }
    });
    return {
      cmd: "LightAppSvc.mini_app_share.AdaptShareInfo",
      data: PacketBufBuilder(data)
    };
  }
  parse(data) {
    return new NapProtoMsg(MiniAppAdaptShareInfoResp).decode(data);
  }
}
const GetMiniAppAdaptShareInfo_default = new GetMiniAppAdaptShareInfo();

class GroupSign extends PacketTransformer {
  build(uin, groupCode) {
    const body = new NapProtoMsg(OidbSvcTrpcTcp0XEB7).encode(
      {
        body: {
          uin: String(uin),
          groupUin: String(groupCode),
          version: "9.0.90"
        }
      }
    );
    return OidbBase$1.build(3767, 1, body, false, false);
  }
  parse(data) {
    return OidbBase$1.parse(data);
  }
}
const GroupSign_default = new GroupSign();

class GetStrangerInfo extends PacketTransformer {
  build(uin) {
    const body = new NapProtoMsg(OidbSvcTrpcTcp0XFE1_2).encode({
      uin,
      key: [{ key: 27372 }]
    });
    return OidbBase$1.build(4065, 2, body);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(OidbSvcTrpcTcp0XFE1_2RSP).decode(oidbBody);
  }
}
const GetStrangerInfo_default = new GetStrangerInfo();

let SendPoke$1 = class SendPoke extends PacketTransformer {
  build(is_group, peer, target) {
    const payload = {
      uin: target,
      ext: 0,
      ...is_group ? { groupUin: peer } : { friendUin: peer }
    };
    const data = new NapProtoMsg(OidbSvcTrpcTcp0XED3_1).encode(payload);
    return OidbBase$1.build(3795, 1, data);
  }
  parse(data) {
    return OidbBase$1.parse(data);
  }
};
const SendPoke_default = new SendPoke$1();

let SetSpecialTitle$1 = class SetSpecialTitle extends PacketTransformer {
  build(groupCode, uid, title) {
    const oidb_0x8FC_2 = new NapProtoMsg(OidbSvcTrpcTcp0X8FC_2).encode({
      groupUin: +groupCode,
      body: {
        targetUid: uid,
        specialTitle: title,
        expiredTime: -1,
        uinName: title
      }
    });
    return OidbBase$1.build(2300, 2, oidb_0x8FC_2, false, false);
  }
  parse(data) {
    return OidbBase$1.parse(data);
  }
};
const SetSpecialTitle_default = new SetSpecialTitle$1();

class ImageOCR extends PacketTransformer {
  build(url) {
    const body = new NapProtoMsg(OidbSvcTrpcTcp0xE07_0).encode(
      {
        version: 1,
        client: 0,
        entrance: 1,
        ocrReqBody: {
          imageUrl: url,
          originMd5: "",
          afterCompressMd5: "",
          afterCompressFileSize: "",
          afterCompressWeight: "",
          afterCompressHeight: "",
          isCut: false
        }
      }
    );
    return OidbBase$1.build(3767, 1, body, false, false);
  }
  parse(data) {
    const base = OidbBase$1.parse(data);
    return new NapProtoMsg(OidbSvcTrpcTcp0xE07_0_Response).decode(base.body);
  }
}
const ImageOCR_default = new ImageOCR();

let MoveGroupFile$1 = class MoveGroupFile extends PacketTransformer {
  build(groupUin, fileUUID, currentParentDirectory, targetParentDirectory) {
    const body = new NapProtoMsg(OidbSvcTrpcTcp0x6D6).encode({
      move: {
        groupUin,
        appId: 5,
        busId: 102,
        fileId: fileUUID,
        parentDirectory: currentParentDirectory,
        targetDirectory: targetParentDirectory
      }
    });
    return OidbBase$1.build(1750, 5, body, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    const res = new NapProtoMsg(OidbSvcTrpcTcp0x6D6Response).decode(oidbBody);
    if (res.move.retCode !== 0) {
      throw new Error(`sendGroupFileMoveReq error: ${res.move.clientWording} (code=${res.move.retCode})`);
    }
    return res;
  }
};
const MoveGroupFile_default = new MoveGroupFile$1();

let RenameGroupFile$1 = class RenameGroupFile extends PacketTransformer {
  build(groupUin, fileUUID, currentParentDirectory, newName) {
    const body = new NapProtoMsg(OidbSvcTrpcTcp0x6D6).encode({
      rename: {
        groupUin,
        busId: 102,
        fileId: fileUUID,
        parentFolder: currentParentDirectory,
        newFileName: newName
      }
    });
    return OidbBase$1.build(1750, 4, body, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    const res = new NapProtoMsg(OidbSvcTrpcTcp0x6D6Response).decode(oidbBody);
    if (res.rename.retCode !== 0) {
      throw new Error(`sendGroupFileRenameReq error: ${res.rename.clientWording} (code=${res.rename.retCode})`);
    }
    return res;
  }
};
const RenameGroupFile_default = new RenameGroupFile$1();

let SetGroupTodo$1 = class SetGroupTodo extends PacketTransformer {
  build(peer, msgSeq) {
    const data = new NapProtoMsg(OidbSvcTrpcTcp0XF90_1).encode({
      groupUin: peer,
      msgSeq: BigInt(msgSeq)
    });
    return OidbBase$1.build(3984, 1, data);
  }
  parse(data) {
    return OidbBase$1.parse(data);
  }
};
const SetGroupTodo_default = new SetGroupTodo$1();

class DownloadGroupFile extends PacketTransformer {
  build(groupUin, fileUUID) {
    const body = new NapProtoMsg(OidbSvcTrpcTcp0x6D6).encode({
      download: {
        groupUin,
        appId: 7,
        busId: 102,
        fileId: fileUUID
      }
    });
    return OidbBase$1.build(1750, 2, body, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    const res = new NapProtoMsg(OidbSvcTrpcTcp0x6D6Response).decode(oidbBody);
    if (res.download.retCode !== 0) {
      throw new Error(`sendGroupFileDownloadReq error: ${res.download.clientWording} (code=${res.download.retCode})`);
    }
    return res;
  }
}
const DownloadGroupFile_default = new DownloadGroupFile();

class DownloadGroupPtt extends PacketTransformer {
  build(groupUin, node) {
    const body = new NapProtoMsg(NTV2RichMediaReq).encode({
      reqHead: {
        common: {
          requestId: 4,
          command: 200
        },
        scene: {
          requestType: 1,
          businessType: 3,
          sceneType: 2,
          group: {
            groupUin
          }
        },
        client: {
          agentType: 2
        }
      },
      download: {
        node,
        download: {
          video: {
            busiType: 0,
            sceneType: 0
          }
        }
      }
    });
    return OidbBase$1.build(4718, 200, body, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const DownloadGroupPtt_default = new DownloadGroupPtt();

class DownloadOfflineFile extends PacketTransformer {
  build(fileUUID, fileHash, senderUid, receiverUid) {
    const body = new NapProtoMsg(OidbSvcTrpcTcp0XE37_800).encode({
      subCommand: 800,
      field2: 0,
      body: {
        senderUid,
        receiverUid,
        fileUuid: fileUUID,
        fileHash
      },
      field101: 3,
      field102: 1,
      field200: 1
    });
    return OidbBase$1.build(3639, 800, body, false, false);
  }
  // TODO:check
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(OidbSvcTrpcTcp0XE37Response).decode(oidbBody);
  }
}
const DownloadOfflineFile_default = new DownloadOfflineFile();

class DownloadPrivateFile extends PacketTransformer {
  build(selfUid, fileUUID, fileHash) {
    const body = new NapProtoMsg(OidbSvcTrpcTcp0XE37_1200).encode({
      subCommand: 1200,
      field2: 1,
      body: {
        receiverUid: selfUid,
        fileUuid: fileUUID,
        type: 2,
        fileHash,
        t2: 0
      },
      field101: 3,
      field102: 103,
      field200: 1,
      field99999: Buffer.from([192, 133, 44, 1])
    });
    return OidbBase$1.build(3639, 1200, body, false, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(OidbSvcTrpcTcp0XE37_1200Response).decode(oidbBody);
  }
}
const DownloadPrivateFile_default = new DownloadPrivateFile();

class UploadGroupFile extends PacketTransformer {
  build(groupUin, file) {
    const body = new NapProtoMsg(OidbSvcTrpcTcp0x6D6).encode({
      file: {
        groupUin,
        appId: 4,
        busId: 102,
        entrance: 6,
        targetDirectory: "/",
        // TODO:
        fileName: file.fileName,
        localDirectory: `/${file.fileName}`,
        fileSize: BigInt(file.fileSize),
        fileMd5: file.fileMd5,
        fileSha1: file.fileSha1,
        fileSha3: Buffer.alloc(0),
        field15: true
      }
    });
    return OidbBase$1.build(1750, 0, body, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(OidbSvcTrpcTcp0x6D6Response).decode(oidbBody);
  }
}
const UploadGroupFile_default = new UploadGroupFile();

class UploadGroupPtt extends PacketTransformer {
  build(groupUin, ptt) {
    const data = new NapProtoMsg(NTV2RichMediaReq).encode({
      reqHead: {
        common: {
          requestId: 1,
          command: 100
        },
        scene: {
          requestType: 2,
          businessType: 3,
          sceneType: 2,
          group: {
            groupUin
          }
        },
        client: {
          agentType: 2
        }
      },
      upload: {
        uploadInfo: [
          {
            fileInfo: {
              fileSize: ptt.fileSize,
              fileHash: ptt.fileMd5,
              fileSha1: ptt.fileSha1,
              fileName: `${ptt.fileMd5}.amr`,
              type: {
                type: 3,
                picFormat: 0,
                videoFormat: 0,
                voiceFormat: 1
              },
              height: 0,
              width: 0,
              time: ptt.fileDuration,
              original: 0
            },
            subFileType: 0
          }
        ],
        tryFastUploadCompleted: true,
        srvSendMsg: false,
        clientRandomId: crypto__default$1.randomBytes(8).readBigUInt64BE() & BigInt("0x7FFFFFFFFFFFFFFF"),
        compatQMsgSceneType: 2,
        extBizInfo: {
          pic: {
            textSummary: "Nya~"
          },
          video: {
            bytesPbReserve: Buffer.alloc(0)
          },
          ptt: {
            bytesPbReserve: Buffer.alloc(0),
            bytesReserve: Buffer.from([8, 0, 56, 0]),
            bytesGeneralFlags: Buffer.from([154, 1, 7, 170, 3, 4, 8, 8, 18, 0])
          }
        },
        clientSeq: 0,
        noNeedCompatMsg: false
      }
    });
    return OidbBase$1.build(4718, 100, data, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const instance$1 = new UploadGroupPtt();

class UploadGroupVideo extends PacketTransformer {
  build(groupUin, video) {
    if (!video.fileSize || !video.thumbSize) throw new Error("video.fileSize or video.thumbSize is empty");
    const data = new NapProtoMsg(NTV2RichMediaReq).encode({
      reqHead: {
        common: {
          requestId: 3,
          command: 100
        },
        scene: {
          requestType: 2,
          businessType: 2,
          sceneType: 2,
          group: {
            groupUin
          }
        },
        client: {
          agentType: 2
        }
      },
      upload: {
        uploadInfo: [
          {
            fileInfo: {
              fileSize: +video.fileSize,
              fileHash: video.fileMd5,
              fileSha1: video.fileSha1,
              fileName: "nya.mp4",
              type: {
                type: 2,
                picFormat: 0,
                videoFormat: 0,
                voiceFormat: 0
              },
              height: 0,
              width: 0,
              time: 0,
              original: 0
            },
            subFileType: 0
          },
          {
            fileInfo: {
              fileSize: +video.thumbSize,
              fileHash: video.thumbMd5,
              fileSha1: video.thumbSha1,
              fileName: "nya.jpg",
              type: {
                type: 1,
                picFormat: 0,
                videoFormat: 0,
                voiceFormat: 0
              },
              height: video.thumbHeight,
              width: video.thumbWidth,
              time: 0,
              original: 0
            },
            subFileType: 100
          }
        ],
        tryFastUploadCompleted: true,
        srvSendMsg: false,
        clientRandomId: crypto__default$1.randomBytes(8).readBigUInt64BE() & BigInt("0x7FFFFFFFFFFFFFFF"),
        compatQMsgSceneType: 2,
        extBizInfo: {
          pic: {
            bizType: 0,
            textSummary: "Nya~"
          },
          video: {
            bytesPbReserve: Buffer.from([128, 1, 0])
          },
          ptt: {
            bytesPbReserve: Buffer.alloc(0),
            bytesReserve: Buffer.alloc(0),
            bytesGeneralFlags: Buffer.alloc(0)
          }
        },
        clientSeq: 0,
        noNeedCompatMsg: false
      }
    });
    return OidbBase$1.build(4586, 100, data, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const UploadGroupVideo_default = new UploadGroupVideo();

class UploadPrivateFile extends PacketTransformer {
  async build(selfUid, peerUid, file) {
    const body = new NapProtoMsg(OidbSvcTrpcTcp0XE37_1700).encode({
      command: 1700,
      seq: 0,
      upload: {
        senderUid: selfUid,
        receiverUid: peerUid,
        fileSize: file.fileSize,
        fileName: file.fileName,
        md510MCheckSum: await computeMd5AndLengthWithLimit(file.filePath, 10 * 1024 * 1024),
        sha1CheckSum: file.fileSha1,
        localPath: "/",
        md5CheckSum: file.fileMd5,
        sha3CheckSum: Buffer.alloc(0)
      },
      businessId: 3,
      clientType: 1,
      flagSupportMediaPlatform: 1
    });
    return OidbBase$1.build(3639, 1700, body, false, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(OidbSvcTrpcTcp0XE37Response).decode(oidbBody);
  }
}
const UploadPrivateFile_default = new UploadPrivateFile();

class UploadPrivateImage extends PacketTransformer {
  build(peerUin, img) {
    const data = new NapProtoMsg(NTV2RichMediaReq).encode(
      {
        reqHead: {
          common: {
            requestId: 1,
            command: 100
          },
          scene: {
            requestType: 2,
            businessType: 1,
            sceneType: 1,
            c2C: {
              accountType: 2,
              targetUid: peerUin
            }
          },
          client: {
            agentType: 2
          }
        },
        upload: {
          uploadInfo: [
            {
              fileInfo: {
                fileSize: +img.size,
                fileHash: img.md5,
                fileSha1: img.sha1,
                fileName: img.name,
                type: {
                  type: 1,
                  picFormat: img.picType,
                  // TODO: extend NapCat imgType /cc @MliKiowa
                  videoFormat: 0,
                  voiceFormat: 0
                },
                width: img.width,
                height: img.height,
                time: 0,
                original: 1
              },
              subFileType: 0
            }
          ],
          tryFastUploadCompleted: true,
          srvSendMsg: false,
          clientRandomId: crypto__default$1.randomBytes(8).readBigUInt64BE() & BigInt("0x7FFFFFFFFFFFFFFF"),
          compatQMsgSceneType: 1,
          extBizInfo: {
            pic: {
              bizType: img.picSubType,
              bytesPbReserveC2C: {
                subType: img.picSubType
              },
              textSummary: img.summary
            },
            video: {
              bytesPbReserve: Buffer.alloc(0)
            },
            ptt: {
              bytesPbReserve: Buffer.alloc(0),
              bytesReserve: Buffer.alloc(0),
              bytesGeneralFlags: Buffer.alloc(0)
            }
          },
          clientSeq: 0,
          noNeedCompatMsg: false
        }
      }
    );
    return OidbBase$1.build(4549, 100, data, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const UploadPrivateImage_default = new UploadPrivateImage();

class UploadPrivatePtt extends PacketTransformer {
  build(peerUin, ptt) {
    const data = new NapProtoMsg(NTV2RichMediaReq).encode({
      reqHead: {
        common: {
          requestId: 4,
          command: 100
        },
        scene: {
          requestType: 2,
          businessType: 3,
          sceneType: 1,
          c2C: {
            accountType: 2,
            targetUid: peerUin
          }
        },
        client: {
          agentType: 2
        }
      },
      upload: {
        uploadInfo: [
          {
            fileInfo: {
              fileSize: ptt.fileSize,
              fileHash: ptt.fileMd5,
              fileSha1: ptt.fileSha1,
              fileName: `${ptt.fileMd5}.amr`,
              type: {
                type: 3,
                picFormat: 0,
                videoFormat: 0,
                voiceFormat: 1
              },
              height: 0,
              width: 0,
              time: ptt.fileDuration,
              original: 0
            },
            subFileType: 0
          }
        ],
        tryFastUploadCompleted: true,
        srvSendMsg: false,
        clientRandomId: crypto__default$1.randomBytes(8).readBigUInt64BE() & BigInt("0x7FFFFFFFFFFFFFFF"),
        compatQMsgSceneType: 1,
        extBizInfo: {
          pic: {
            textSummary: "Nya~"
          },
          ptt: {
            bytesReserve: Buffer.from([8, 0, 56, 0]),
            bytesGeneralFlags: Buffer.from([154, 1, 11, 170, 3, 8, 8, 4, 18, 4, 0, 0, 0, 0])
          }
        },
        clientSeq: 0,
        noNeedCompatMsg: false
      }
    });
    return OidbBase$1.build(4717, 100, data, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const UploadPrivatePtt_default = new UploadPrivatePtt();

class UploadPrivateVideo extends PacketTransformer {
  build(peerUin, video) {
    if (!video.fileSize || !video.thumbSize) throw new Error("video.fileSize or video.thumbSize is empty");
    const data = new NapProtoMsg(NTV2RichMediaReq).encode({
      reqHead: {
        common: {
          requestId: 3,
          command: 100
        },
        scene: {
          requestType: 2,
          businessType: 2,
          sceneType: 1,
          c2C: {
            accountType: 2,
            targetUid: peerUin
          }
        },
        client: {
          agentType: 2
        }
      },
      upload: {
        uploadInfo: [
          {
            fileInfo: {
              fileSize: +video.fileSize,
              fileHash: video.fileMd5,
              fileSha1: video.fileSha1,
              fileName: "nya.mp4",
              type: {
                type: 2,
                picFormat: 0,
                videoFormat: 0,
                voiceFormat: 0
              },
              height: 0,
              width: 0,
              time: 0,
              original: 0
            },
            subFileType: 0
          },
          {
            fileInfo: {
              fileSize: +video.thumbSize,
              fileHash: video.thumbMd5,
              fileSha1: video.thumbSha1,
              fileName: "nya.jpg",
              type: {
                type: 1,
                picFormat: 0,
                videoFormat: 0,
                voiceFormat: 0
              },
              height: video.thumbHeight,
              width: video.thumbWidth,
              time: 0,
              original: 0
            },
            subFileType: 100
          }
        ],
        tryFastUploadCompleted: true,
        srvSendMsg: false,
        clientRandomId: crypto__default$1.randomBytes(8).readBigUInt64BE() & BigInt("0x7FFFFFFFFFFFFFFF"),
        compatQMsgSceneType: 2,
        extBizInfo: {
          pic: {
            bizType: 0,
            textSummary: "Nya~"
          },
          video: {
            bytesPbReserve: Buffer.from([128, 1, 0])
          },
          ptt: {
            bytesPbReserve: Buffer.alloc(0),
            bytesReserve: Buffer.alloc(0),
            bytesGeneralFlags: Buffer.alloc(0)
          }
        },
        clientSeq: 0,
        noNeedCompatMsg: false
      }
    });
    return OidbBase$1.build(4585, 100, data, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const UploadPrivateVideo_default = new UploadPrivateVideo();

class DownloadImage extends PacketTransformer {
  build(selfUid, node) {
    const body = new NapProtoMsg(NTV2RichMediaReq).encode({
      reqHead: {
        common: {
          requestId: 1,
          command: 200
        },
        scene: {
          requestType: 2,
          businessType: 1,
          sceneType: 1,
          c2C: {
            accountType: 2,
            targetUid: selfUid
          }
        },
        client: {
          agentType: 2
        }
      },
      download: {
        node,
        download: {
          video: {
            busiType: 0,
            sceneType: 0
          }
        }
      }
    });
    return OidbBase$1.build(4549, 200, body, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const DownloadImage_default = new DownloadImage();

class DownloadGroupImage extends PacketTransformer {
  build(group_uin, node) {
    const body = new NapProtoMsg(NTV2RichMediaReq).encode({
      reqHead: {
        common: {
          requestId: 1,
          command: 200
        },
        scene: {
          requestType: 2,
          businessType: 1,
          sceneType: 2,
          group: {
            groupUin: group_uin
          }
        },
        client: {
          agentType: 2
        }
      },
      download: {
        node,
        download: {
          video: {
            busiType: 0,
            sceneType: 0
          }
        }
      }
    });
    return OidbBase$1.build(4548, 200, body, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const DownloadGroupImage_default = new DownloadGroupImage();

class DownloadVideo extends PacketTransformer {
  build(selfUid, node) {
    const body = new NapProtoMsg(NTV2RichMediaReq).encode({
      reqHead: {
        common: {
          requestId: 1,
          command: 200
        },
        scene: {
          requestType: 2,
          businessType: 2,
          sceneType: 1,
          c2C: {
            accountType: 2,
            targetUid: selfUid
          }
        },
        client: {
          agentType: 2
        }
      },
      download: {
        node,
        download: {
          video: {
            busiType: 0,
            sceneType: 0
          }
        }
      }
    });
    return OidbBase$1.build(4585, 200, body, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const DownloadVideo_default = new DownloadVideo();

class DownloadGroupVideo extends PacketTransformer {
  build(groupUin, node) {
    const body = new NapProtoMsg(NTV2RichMediaReq).encode({
      reqHead: {
        common: {
          requestId: 1,
          command: 200
        },
        scene: {
          requestType: 2,
          businessType: 2,
          sceneType: 2,
          group: {
            groupUin
          }
        },
        client: {
          agentType: 2
        }
      },
      download: {
        node,
        download: {
          video: {
            busiType: 0,
            sceneType: 0
          }
        }
      }
    });
    return OidbBase$1.build(4586, 200, body, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const DownloadGroupVideo_default = new DownloadGroupVideo();

class DownloadPtt extends PacketTransformer {
  build(selfUid, node) {
    const body = new NapProtoMsg(NTV2RichMediaReq).encode({
      reqHead: {
        common: {
          requestId: 1,
          command: 200
        },
        scene: {
          requestType: 1,
          businessType: 3,
          sceneType: 1,
          c2C: {
            accountType: 2,
            targetUid: selfUid
          }
        },
        client: {
          agentType: 2
        }
      },
      download: {
        node,
        download: {
          video: {
            busiType: 0,
            sceneType: 0
          }
        }
      }
    });
    return OidbBase$1.build(4717, 200, body, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const DownloadPtt_default = new DownloadPtt();

class UploadForwardMsg extends PacketTransformer {
  build(selfUid, msg, groupUin = 0) {
    const msgBody = this.msgBuilder.buildFakeMsg(selfUid, msg);
    const longMsgResultData = new NapProtoMsg(LongMsgResult).encode(
      {
        action: [{
          actionCommand: "MultiMsg",
          actionData: {
            msgBody
          }
        }]
      }
    );
    const payload = zlib__default.gzipSync(Buffer.from(longMsgResultData));
    const req = new NapProtoMsg(SendLongMsgReq).encode(
      {
        info: {
          type: groupUin === 0 ? 1 : 3,
          uid: {
            uid: groupUin === 0 ? selfUid : groupUin.toString()
          },
          groupUin,
          payload
        },
        settings: {
          field1: 4,
          field2: 1,
          field3: 7,
          field4: 0
        }
      }
    );
    return {
      cmd: "trpc.group.long_msg_interface.MsgService.SsoSendLongMsg",
      data: PacketBufBuilder(req)
    };
  }
  parse(data) {
    return new NapProtoMsg(SendLongMsgResp).decode(data);
  }
}
const UploadForwardMsg_default = new UploadForwardMsg();

class FetchGroupMessage extends PacketTransformer {
  build(groupUin, startSeq, endSeq) {
    const req = new NapProtoMsg(SsoGetGroupMsg).encode({
      info: {
        groupUin,
        startSequence: startSeq,
        endSequence: endSeq
      },
      direction: true
    });
    return {
      cmd: "trpc.msg.register_proxy.RegisterProxy.SsoGetGroupMsg",
      data: PacketBufBuilder(req)
    };
  }
  parse(data) {
    return new NapProtoMsg(SsoGetGroupMsgResponse).decode(data);
  }
}
const FetchGroupMessage_default = new FetchGroupMessage();

class FetchC2CMessage extends PacketTransformer {
  build(targetUid, startSeq, endSeq) {
    const req = new NapProtoMsg(SsoGetC2cMsg).encode({
      friendUid: targetUid,
      startSequence: startSeq,
      endSequence: endSeq
    });
    return {
      cmd: "trpc.msg.register_proxy.RegisterProxy.SsoGetC2cMsg",
      data: PacketBufBuilder(req)
    };
  }
  parse(data) {
    return new NapProtoMsg(SsoGetC2cMsgResponse).decode(data);
  }
}
const FetchC2CMessage_default = new FetchC2CMessage();

class DownloadForwardMsg extends PacketTransformer {
  build(uid, resId) {
    const req = new NapProtoMsg(RecvLongMsgReq).encode({
      info: {
        uid: {
          uid
        },
        resId,
        acquire: true
      },
      settings: {
        field1: 2,
        field2: 0,
        field3: 0,
        field4: 0
      }
    });
    return {
      cmd: "trpc.group.long_msg_interface.MsgService.SsoRecvLongMsg",
      data: PacketBufBuilder(req)
    };
  }
  parse(data) {
    return new NapProtoMsg(RecvLongMsgResp).decode(data);
  }
}
const DownloadForwardMsg_default = new DownloadForwardMsg();

class FetchRkey extends PacketTransformer {
  build() {
    const data = new NapProtoMsg(OidbSvcTrpcTcp0X9067_202).encode({
      reqHead: {
        common: {
          requestId: 1,
          command: 202
        },
        scene: {
          requestType: 2,
          businessType: 1,
          sceneType: 0
        },
        client: {
          agentType: 2
        }
      },
      downloadRKeyReq: {
        key: [10, 20, 2]
      }
    });
    return OidbBase$1.build(36967, 202, data);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(OidbSvcTrpcTcp0X9067_202_Rsp_Body).decode(oidbBody);
  }
}
const FetchRkey_default = new FetchRkey();

function getAddonPath(binaryPath) {
  const platformName = platform();
  const archName = arch();
  const addonFileName = process.platform + "." + process.arch;
  const addonPath = path$1.join(binaryPath, "./native/ffmpeg/", `ffmpegAddon.${addonFileName}.node`);
  if (!existsSync(addonPath)) {
    throw new Error(`Unsupported platform: ${platformName} ${archName} - Addon not found at ${addonPath}`);
  }
  return addonPath;
}
class FFmpegAddonAdapter {
  name = "FFmpegAddon";
  addon = null;
  binaryPath;
  constructor(binaryPath) {
    this.binaryPath = binaryPath;
  }
  /**
     * 检查 Addon 是否可用
     */
  async isAvailable() {
    try {
      const temp_addon = { exports: {} };
      dlopen(temp_addon, getAddonPath(this.binaryPath));
      this.addon = temp_addon.exports;
      return this.addon !== null;
    } catch (error) {
      console.log("[FFmpegAddonAdapter] Failed to load addon:", error);
      return false;
    }
  }
  ensureAddon() {
    if (!this.addon) {
      throw new Error("FFmpeg Addon is not available");
    }
    return this.addon;
  }
  /**
     * 获取视频信息
     */
  async getVideoInfo(videoPath) {
    const addon = this.ensureAddon();
    const info = await addon.getVideoInfo(videoPath);
    const format = info.format.includes(",") ? info.format.split(",")[0] ?? info.format : info.format;
    console.log("[FFmpegAddonAdapter] Detected format:", format);
    return {
      width: info.width,
      height: info.height,
      duration: info.duration,
      format,
      thumbnail: info.image
    };
  }
  /**
     * 获取时长
     */
  async getDuration(filePath) {
    const addon = this.ensureAddon();
    return addon.getDuration(filePath);
  }
  /**
     * 转换为 PCM
     */
  async convertToPCM(filePath, pcmPath) {
    const addon = this.ensureAddon();
    const result = await addon.decodeAudioToPCM(filePath, pcmPath, 24e3);
    return result;
  }
  /**
     * 转换文件
     */
  async convertFile(inputFile, outputFile, format) {
    const addon = this.ensureAddon();
    console.log("[FFmpegAddonAdapter] Converting file:", inputFile, "to", outputFile, "as", format);
    await addon.decodeAudioToFmt(inputFile, outputFile, format);
  }
  /**
     * 提取缩略图
     */
  async extractThumbnail(videoPath, thumbnailPath) {
    const addon = this.ensureAddon();
    const info = await addon.getVideoInfo(videoPath);
    await writeFile(thumbnailPath, info.image);
  }
}

function matchMagic(buffer, magic, offset = 0) {
  if (buffer.length < offset + magic.length) {
    return false;
  }
  for (let i = 0; i < magic.length; i++) {
    if (buffer[offset + i] !== magic[i]) {
      return false;
    }
  }
  return true;
}
class PngParser {
  type = "png" /* PNG */;
  // PNG 魔术头：89 50 4E 47 0D 0A 1A 0A
  PNG_SIGNATURE = [137, 80, 78, 71, 13, 10, 26, 10];
  canParse(buffer) {
    return matchMagic(buffer, this.PNG_SIGNATURE);
  }
  async parseSize(stream) {
    return new Promise((resolve, reject) => {
      stream.once("error", reject);
      stream.once("readable", () => {
        const buf = stream.read(24);
        if (!buf || buf.length < 24) {
          return resolve(void 0);
        }
        if (this.canParse(buf)) {
          const width = buf.readUInt32BE(16);
          const height = buf.readUInt32BE(20);
          resolve({ width, height });
        } else {
          resolve(void 0);
        }
      });
    });
  }
}
class JpegParser {
  type = "jpeg" /* JPEG */;
  // JPEG 魔术头：FF D8
  JPEG_SIGNATURE = [255, 216];
  // JPEG标记常量
  SOF_MARKERS = {
    SOF0: 192,
    // 基线DCT
    SOF1: 193,
    // 扩展顺序DCT
    SOF2: 194,
    // 渐进式DCT
    SOF3: 195
    // 无损
  };
  // 非SOF标记
  NON_SOF_MARKERS = [
    196,
    // DHT
    200,
    // JPEG扩展
    204
    // DAC
  ];
  canParse(buffer) {
    return matchMagic(buffer, this.JPEG_SIGNATURE);
  }
  isSOFMarker(marker) {
    return marker === this.SOF_MARKERS.SOF0 || marker === this.SOF_MARKERS.SOF1 || marker === this.SOF_MARKERS.SOF2 || marker === this.SOF_MARKERS.SOF3;
  }
  isNonSOFMarker(marker) {
    return this.NON_SOF_MARKERS.includes(marker);
  }
  async parseSize(stream) {
    return new Promise((resolve, reject) => {
      const BUFFER_SIZE = 1024;
      let buffer = Buffer.alloc(0);
      let offset = 0;
      let found = false;
      stream.on("error", (err) => {
        stream.destroy();
        reject(err);
      });
      stream.on("data", (chunk) => {
        const chunkBuffer = Buffer.isBuffer(chunk) ? chunk : Buffer.from(chunk);
        buffer = Buffer.concat([buffer.subarray(offset), chunkBuffer]);
        offset = 0;
        const bufferSize = buffer.length;
        const MIN_REQUIRED_BYTES = 10;
        while (offset < bufferSize - MIN_REQUIRED_BYTES) {
          if (buffer[offset] === 255 && buffer[offset + 1] >= 192 && buffer[offset + 1] <= 207) {
            const marker = buffer[offset + 1];
            if (!marker) {
              break;
            }
            if (this.isNonSOFMarker(marker)) {
              offset += 2;
              continue;
            }
            if (this.isSOFMarker(marker)) {
              if (offset + 9 < bufferSize) {
                const height = buffer.readUInt16BE(offset + 5);
                const width = buffer.readUInt16BE(offset + 7);
                found = true;
                stream.destroy();
                resolve({ width, height });
                return;
              } else {
                break;
              }
            }
          }
          offset++;
        }
        if (offset > BUFFER_SIZE) {
          const KEEP_BYTES = 20;
          if (offset > KEEP_BYTES) {
            buffer = buffer.subarray(offset - KEEP_BYTES);
            offset = KEEP_BYTES;
          }
        }
      });
      stream.on("end", () => {
        if (!found) {
          resolve(void 0);
        }
      });
    });
  }
}
class BmpParser {
  type = "bmp" /* BMP */;
  // BMP 魔术头：42 4D (BM)
  BMP_SIGNATURE = [66, 77];
  canParse(buffer) {
    return matchMagic(buffer, this.BMP_SIGNATURE);
  }
  async parseSize(stream) {
    return new Promise((resolve, reject) => {
      stream.once("error", reject);
      stream.once("readable", () => {
        const buf = stream.read(26);
        if (!buf || buf.length < 26) {
          return resolve(void 0);
        }
        if (this.canParse(buf)) {
          const width = buf.readUInt32LE(18);
          const height = buf.readUInt32LE(22);
          resolve({ width, height });
        } else {
          resolve(void 0);
        }
      });
    });
  }
}
class GifParser {
  type = "gif" /* GIF */;
  // GIF87a 魔术头：47 49 46 38 37 61
  GIF87A_SIGNATURE = [71, 73, 70, 56, 55, 97];
  // GIF89a 魔术头：47 49 46 38 39 61
  GIF89A_SIGNATURE = [71, 73, 70, 56, 57, 97];
  canParse(buffer) {
    return matchMagic(buffer, this.GIF87A_SIGNATURE) || matchMagic(buffer, this.GIF89A_SIGNATURE);
  }
  async parseSize(stream) {
    return new Promise((resolve, reject) => {
      stream.once("error", reject);
      stream.once("readable", () => {
        const buf = stream.read(10);
        if (!buf || buf.length < 10) {
          return resolve(void 0);
        }
        if (this.canParse(buf)) {
          const width = buf.readUInt16LE(6);
          const height = buf.readUInt16LE(8);
          resolve({ width, height });
        } else {
          resolve(void 0);
        }
      });
    });
  }
}
class WebpParser {
  type = "webp" /* WEBP */;
  // WEBP RIFF 头：52 49 46 46 (RIFF)
  RIFF_SIGNATURE = [82, 73, 70, 70];
  // WEBP 魔术头：57 45 42 50 (WEBP)
  WEBP_SIGNATURE = [87, 69, 66, 80];
  // WEBP 块头
  CHUNK_VP8 = [86, 80, 56, 32];
  // "VP8 "
  CHUNK_VP8L = [86, 80, 56, 76];
  // "VP8L"
  CHUNK_VP8X = [86, 80, 56, 88];
  // "VP8X"
  canParse(buffer) {
    return buffer.length >= 12 && matchMagic(buffer, this.RIFF_SIGNATURE, 0) && matchMagic(buffer, this.WEBP_SIGNATURE, 8);
  }
  isChunkType(buffer, offset, chunkType) {
    return buffer.length >= offset + 4 && matchMagic(buffer, chunkType, offset);
  }
  async parseSize(stream) {
    return new Promise((resolve, reject) => {
      const MAX_HEADER_SIZE = 32;
      let totalBytes = 0;
      let buffer = Buffer.alloc(0);
      stream.on("error", reject);
      stream.on("data", (chunk) => {
        const chunkBuffer = Buffer.isBuffer(chunk) ? chunk : Buffer.from(chunk);
        buffer = Buffer.concat([buffer, chunkBuffer]);
        totalBytes += chunk.length;
        if (totalBytes >= MAX_HEADER_SIZE) {
          stream.destroy();
          if (!this.canParse(buffer)) {
            return resolve(void 0);
          }
          if (this.isChunkType(buffer, 12, this.CHUNK_VP8)) {
            const width = buffer.readUInt16LE(26) & 16383;
            const height = buffer.readUInt16LE(28) & 16383;
            return resolve({ width, height });
          } else if (this.isChunkType(buffer, 12, this.CHUNK_VP8L)) {
            const bits = buffer.readUInt32LE(21);
            const width = 1 + (bits & 16383);
            const height = 1 + (bits >> 14 & 16383);
            return resolve({ width, height });
          } else if (this.isChunkType(buffer, 12, this.CHUNK_VP8X)) {
            if (!buffer[24] || !buffer[25] || !buffer[26] || !buffer[27] || !buffer[28] || !buffer[29]) {
              return resolve(void 0);
            }
            const width = 1 + ((buffer[24] | buffer[25] << 8 | buffer[26] << 16) & 16777215);
            const height = 1 + ((buffer[27] | buffer[28] << 8 | buffer[29] << 16) & 16777215);
            return resolve({ width, height });
          } else {
            return resolve(void 0);
          }
        }
      });
      stream.on("end", () => {
        if (totalBytes < MAX_HEADER_SIZE) {
          resolve(void 0);
        }
      });
    });
  }
}
const parsers = [
  new PngParser(),
  new JpegParser(),
  new BmpParser(),
  new GifParser(),
  new WebpParser()
];
async function detectImageType(filePath) {
  return new Promise((resolve, reject) => {
    const stream = fs.createReadStream(filePath, {
      highWaterMark: 64,
      // 优化读取buffer大小
      start: 0,
      end: 63
    });
    let buffer = null;
    stream.once("error", (err) => {
      stream.destroy();
      reject(err);
    });
    stream.once("readable", () => {
      buffer = stream.read(64);
      stream.destroy();
      if (!buffer) {
        return resolve("unknown" /* UNKNOWN */);
      }
      for (const parser of parsers) {
        if (parser.canParse(buffer)) {
          return resolve(parser.type);
        }
      }
      resolve("unknown" /* UNKNOWN */);
    });
    stream.once("end", () => {
      if (!buffer) {
        resolve("unknown" /* UNKNOWN */);
      }
    });
  });
}
async function imageSizeFromFile(filePath) {
  try {
    const type = await detectImageType(filePath);
    const parser = parsers.find((p) => p.type === type);
    if (!parser) {
      return void 0;
    }
    const stream = fs.createReadStream(filePath);
    try {
      return await parser.parseSize(stream);
    } catch (err) {
      console.error(`解析图片尺寸出错: ${err}`);
      return void 0;
    } finally {
      if (!stream.destroyed) {
        stream.destroy();
      }
    }
  } catch (err) {
    console.error(`检测图片类型出错: ${err}`);
    return void 0;
  }
}
async function imageSizeFallBack(filePath, fallback = {
  width: 1024,
  height: 1024
}) {
  return await imageSizeFromFile(filePath) ?? fallback;
}

var compressing$1 = {};

var zip = {};

var utils$2 = {};

var mkdirp;
var hasRequiredMkdirp;

function requireMkdirp () {
	if (hasRequiredMkdirp) return mkdirp;
	hasRequiredMkdirp = 1;
	var path = path__default;
	var fs = fs__default;
	var _0777 = parseInt('0777', 8);

	mkdirp = mkdirP.mkdirp = mkdirP.mkdirP = mkdirP;

	function mkdirP (p, opts, f, made) {
	    if (typeof opts === 'function') {
	        f = opts;
	        opts = {};
	    }
	    else if (!opts || typeof opts !== 'object') {
	        opts = { mode: opts };
	    }
	    
	    var mode = opts.mode;
	    var xfs = opts.fs || fs;
	    
	    if (mode === undefined) {
	        mode = _0777;
	    }
	    if (!made) made = null;
	    
	    var cb = f || /* istanbul ignore next */ function () {};
	    p = path.resolve(p);
	    
	    xfs.mkdir(p, mode, function (er) {
	        if (!er) {
	            made = made || p;
	            return cb(null, made);
	        }
	        switch (er.code) {
	            case 'ENOENT':
	                /* istanbul ignore if */
	                if (path.dirname(p) === p) return cb(er);
	                mkdirP(path.dirname(p), opts, function (er, made) {
	                    /* istanbul ignore if */
	                    if (er) cb(er, made);
	                    else mkdirP(p, opts, cb, made);
	                });
	                break;

	            // In the case of any other error, just see if there's a dir
	            // there already.  If so, then hooray!  If not, then something
	            // is borked.
	            default:
	                xfs.stat(p, function (er2, stat) {
	                    // if the stat fails, then that's super weird.
	                    // let the original error be the failure reason.
	                    if (er2 || !stat.isDirectory()) cb(er, made);
	                    else cb(null, made);
	                });
	                break;
	        }
	    });
	}

	mkdirP.sync = function sync (p, opts, made) {
	    if (!opts || typeof opts !== 'object') {
	        opts = { mode: opts };
	    }
	    
	    var mode = opts.mode;
	    var xfs = opts.fs || fs;
	    
	    if (mode === undefined) {
	        mode = _0777;
	    }
	    if (!made) made = null;

	    p = path.resolve(p);

	    try {
	        xfs.mkdirSync(p, mode);
	        made = made || p;
	    }
	    catch (err0) {
	        switch (err0.code) {
	            case 'ENOENT' :
	                made = sync(path.dirname(p), opts, made);
	                sync(p, opts, made);
	                break;

	            // In the case of any other error, just see if there's a dir
	            // there already.  If so, then hooray!  If not, then something
	            // is borked.
	            default:
	                var stat;
	                try {
	                    stat = xfs.statSync(p);
	                }
	                catch (err1) /* istanbul ignore next */ {
	                    throw err0;
	                }
	                /* istanbul ignore if */
	                if (!stat.isDirectory()) throw err0;
	                break;
	        }
	    }

	    return made;
	};
	return mkdirp;
}

var once$1 = {exports: {}};

var wrappy_1;
var hasRequiredWrappy;

function requireWrappy () {
	if (hasRequiredWrappy) return wrappy_1;
	hasRequiredWrappy = 1;
	// Returns a wrapper function that returns a wrapped callback
	// The wrapper function should do some stuff, and return a
	// presumably different callback function.
	// This makes sure that own properties are retained, so that
	// decorations and such are not lost along the way.
	wrappy_1 = wrappy;
	function wrappy (fn, cb) {
	  if (fn && cb) return wrappy(fn)(cb)

	  if (typeof fn !== 'function')
	    throw new TypeError('need wrapper function')

	  Object.keys(fn).forEach(function (k) {
	    wrapper[k] = fn[k];
	  });

	  return wrapper

	  function wrapper() {
	    var args = new Array(arguments.length);
	    for (var i = 0; i < args.length; i++) {
	      args[i] = arguments[i];
	    }
	    var ret = fn.apply(this, args);
	    var cb = args[args.length-1];
	    if (typeof ret === 'function' && ret !== cb) {
	      Object.keys(cb).forEach(function (k) {
	        ret[k] = cb[k];
	      });
	    }
	    return ret
	  }
	}
	return wrappy_1;
}

var hasRequiredOnce$1;

function requireOnce$1 () {
	if (hasRequiredOnce$1) return once$1.exports;
	hasRequiredOnce$1 = 1;
	var wrappy = requireWrappy();
	once$1.exports = wrappy(once);
	once$1.exports.strict = wrappy(onceStrict);

	once.proto = once(function () {
	  Object.defineProperty(Function.prototype, 'once', {
	    value: function () {
	      return once(this)
	    },
	    configurable: true
	  });

	  Object.defineProperty(Function.prototype, 'onceStrict', {
	    value: function () {
	      return onceStrict(this)
	    },
	    configurable: true
	  });
	});

	function once (fn) {
	  var f = function () {
	    if (f.called) return f.value
	    f.called = true;
	    return f.value = fn.apply(this, arguments)
	  };
	  f.called = false;
	  return f
	}

	function onceStrict (fn) {
	  var f = function () {
	    if (f.called)
	      throw new Error(f.onceError)
	    f.called = true;
	    return f.value = fn.apply(this, arguments)
	  };
	  var name = fn.name || 'Function wrapped with `once`';
	  f.onceError = name + " shouldn't be called more than once";
	  f.called = false;
	  return f
	}
	return once$1.exports;
}

var endOfStream$1;
var hasRequiredEndOfStream$1;

function requireEndOfStream$1 () {
	if (hasRequiredEndOfStream$1) return endOfStream$1;
	hasRequiredEndOfStream$1 = 1;
	var once = requireOnce$1();

	var noop = function() {};

	var qnt = commonjsGlobal.Bare ? queueMicrotask : process.nextTick.bind(process);

	var isRequest = function(stream) {
		return stream.setHeader && typeof stream.abort === 'function';
	};

	var isChildProcess = function(stream) {
		return stream.stdio && Array.isArray(stream.stdio) && stream.stdio.length === 3
	};

	var eos = function(stream, opts, callback) {
		if (typeof opts === 'function') return eos(stream, null, opts);
		if (!opts) opts = {};

		callback = once(callback || noop);

		var ws = stream._writableState;
		var rs = stream._readableState;
		var readable = opts.readable || (opts.readable !== false && stream.readable);
		var writable = opts.writable || (opts.writable !== false && stream.writable);
		var cancelled = false;

		var onlegacyfinish = function() {
			if (!stream.writable) onfinish();
		};

		var onfinish = function() {
			writable = false;
			if (!readable) callback.call(stream);
		};

		var onend = function() {
			readable = false;
			if (!writable) callback.call(stream);
		};

		var onexit = function(exitCode) {
			callback.call(stream, exitCode ? new Error('exited with error code: ' + exitCode) : null);
		};

		var onerror = function(err) {
			callback.call(stream, err);
		};

		var onclose = function() {
			qnt(onclosenexttick);
		};

		var onclosenexttick = function() {
			if (cancelled) return;
			if (readable && !(rs && (rs.ended && !rs.destroyed))) return callback.call(stream, new Error('premature close'));
			if (writable && !(ws && (ws.ended && !ws.destroyed))) return callback.call(stream, new Error('premature close'));
		};

		var onrequest = function() {
			stream.req.on('finish', onfinish);
		};

		if (isRequest(stream)) {
			stream.on('complete', onfinish);
			stream.on('abort', onclose);
			if (stream.req) onrequest();
			else stream.on('request', onrequest);
		} else if (writable && !ws) { // legacy streams
			stream.on('end', onlegacyfinish);
			stream.on('close', onlegacyfinish);
		}

		if (isChildProcess(stream)) stream.on('exit', onexit);

		stream.on('end', onend);
		stream.on('finish', onfinish);
		if (opts.error !== false) stream.on('error', onerror);
		stream.on('close', onclose);

		return function() {
			cancelled = true;
			stream.removeListener('complete', onfinish);
			stream.removeListener('abort', onclose);
			stream.removeListener('request', onrequest);
			if (stream.req) stream.req.removeListener('finish', onfinish);
			stream.removeListener('end', onlegacyfinish);
			stream.removeListener('close', onlegacyfinish);
			stream.removeListener('finish', onfinish);
			stream.removeListener('exit', onexit);
			stream.removeListener('end', onend);
			stream.removeListener('error', onerror);
			stream.removeListener('close', onclose);
		};
	};

	endOfStream$1 = eos;
	return endOfStream$1;
}

var pump_1;
var hasRequiredPump;

function requirePump () {
	if (hasRequiredPump) return pump_1;
	hasRequiredPump = 1;
	var once = requireOnce$1();
	var eos = requireEndOfStream$1();
	var fs;

	try {
	  fs = require('fs'); // we only need fs to get the ReadStream and WriteStream prototypes
	} catch (e) {}

	var noop = function () {};
	var ancient = typeof process === 'undefined' ? false : /^v?\.0/.test(process.version);

	var isFn = function (fn) {
	  return typeof fn === 'function'
	};

	var isFS = function (stream) {
	  if (!ancient) return false // newer node version do not need to care about fs is a special way
	  if (!fs) return false // browser
	  return (stream instanceof (fs.ReadStream || noop) || stream instanceof (fs.WriteStream || noop)) && isFn(stream.close)
	};

	var isRequest = function (stream) {
	  return stream.setHeader && isFn(stream.abort)
	};

	var destroyer = function (stream, reading, writing, callback) {
	  callback = once(callback);

	  var closed = false;
	  stream.on('close', function () {
	    closed = true;
	  });

	  eos(stream, {readable: reading, writable: writing}, function (err) {
	    if (err) return callback(err)
	    closed = true;
	    callback();
	  });

	  var destroyed = false;
	  return function (err) {
	    if (closed) return
	    if (destroyed) return
	    destroyed = true;

	    if (isFS(stream)) return stream.close(noop) // use close for fs streams to avoid fd leaks
	    if (isRequest(stream)) return stream.abort() // request.destroy just do .end - .abort is what we want

	    if (isFn(stream.destroy)) return stream.destroy()

	    callback(err || new Error('stream was destroyed'));
	  }
	};

	var call = function (fn) {
	  fn();
	};

	var pipe = function (from, to) {
	  return from.pipe(to)
	};

	var pump = function () {
	  var streams = Array.prototype.slice.call(arguments);
	  var callback = isFn(streams[streams.length - 1] || noop) && streams.pop() || noop;

	  if (Array.isArray(streams[0])) streams = streams[0];
	  if (streams.length < 2) throw new Error('pump requires two streams per minimum')

	  var error;
	  var destroys = streams.map(function (stream, i) {
	    var reading = i < streams.length - 1;
	    var writing = i > 0;
	    return destroyer(stream, reading, writing, function (err) {
	      if (!error) error = err;
	      if (err) destroys.forEach(call);
	      if (reading) return
	      destroys.forEach(call);
	      callback(error);
	    })
	  });

	  return streams.reduce(pipe)
	};

	pump_1 = pump;
	return pump_1;
}

var hasRequiredUtils$2;

function requireUtils$2 () {
	if (hasRequiredUtils$2) return utils$2;
	hasRequiredUtils$2 = 1;

	const fs = fs__default;
	const path = path__default;
	const mkdirp = requireMkdirp();
	const pump = requirePump();

	// file/fileBuffer/stream
	utils$2.sourceType = source => {
	  if (!source) return undefined;

	  if (source instanceof Buffer) return 'buffer';
	  if (typeof source._read === 'function' || typeof source._transform === 'function') return 'stream';
	  if (typeof source !== 'string') {
	    const err = new Error('Type is not supported, must be a file path, file buffer, or a readable stream');
	    err.name = 'IlligalSourceError';
	    throw err;
	  }

	  return 'file';
	};

	function destType(dest) {
	  if (typeof dest._write === 'function' || typeof dest._transform === 'function') return 'stream';
	  if (typeof dest !== 'string') {
	    const err = new Error('Type is not supported, must be a file path, or a writable stream');
	    err.name = 'IlligalDestinationError';
	    throw err;
	  }
	  return 'path';
	}

	utils$2.destType = destType;

	const illigalEntryError = new Error('Type is not supported, must be a file path, directory path, file buffer, or a readable stream');
	illigalEntryError.name = 'IlligalEntryError';

	// fileOrDir/fileBuffer/stream
	utils$2.entryType = entry => {
	  if (!entry) return;

	  if (entry instanceof Buffer) return 'buffer';
	  if (typeof entry._read === 'function' || typeof entry._transform === 'function') return 'stream';
	  if (typeof entry !== 'string') throw illigalEntryError;

	  return 'fileOrDir';
	};


	utils$2.clone = obj => {
	  const newObj = {};
	  for (const i in obj) {
	    newObj[i] = obj[i];
	  }
	  return newObj;
	};

	utils$2.makeFileProcessFn = StreamClass => {
	  return (source, dest, opts) => {
	    opts = opts || {};
	    opts.source = source;
	    const destStream = destType(dest) === 'path' ? fs.createWriteStream(dest) : dest;
	    const compressStream = new StreamClass(opts);
	    return safePipe([ compressStream, destStream ]);
	  };
	};

	utils$2.makeCompressDirFn = StreamClass => {
	  return (dir, dest, opts) => {
	    const destStream = destType(dest) === 'path' ? fs.createWriteStream(dest) : dest;
	    const compressStream = new StreamClass();
	    compressStream.addEntry(dir, opts);
	    return safePipe([ compressStream, destStream ]);
	  };
	};

	utils$2.makeUncompressFn = StreamClass => {
	  return (source, destDir, opts) => {
	    opts = opts || {};
	    opts.source = source;
	    if (!source) { // !source 和 sourceType中返回undeined对应
	      const error = new Error('Type is not supported, must be a file path, file buffer, or a readable stream');
	      error.name = 'IlligalSourceError';
	      throw error;
	    }
	    if (destType(destDir) !== 'path') {
	      const error = new Error('uncompress destination must be a directory');
	      error.name = 'IlligalDestError';
	      throw error;
	    }

	    return new Promise((resolve, reject) => {
	      mkdirp(destDir, err => {
	        if (err) return reject(err);

	        let entryCount = 0;
	        let successCount = 0;
	        let isFinish = false;
	        function done() {
	          // resolve when both stream finish and file write finish
	          if (isFinish && entryCount === successCount) resolve();
	        }

	        new StreamClass(opts)
	          .on('finish', () => {
	            isFinish = true;
	            done();
	          })
	          .on('error', reject)
	          .on('entry', (header, stream, next) => {
	            stream.on('end', next);
	            const destFilePath = path.join(destDir, header.name);

	            if (header.type === 'file') {
	              const dir = path.dirname(destFilePath);
	              mkdirp(dir, err => {
	                if (err) return reject(err);

	                entryCount++;
	                pump(stream, fs.createWriteStream(destFilePath, { mode: opts.mode || header.mode }), err => {
	                  if (err) return reject(err);
	                  successCount++;
	                  done();
	                });
	              });
	            } else if (header.type === 'symlink') {
	              const dir = path.dirname(destFilePath);
	              const target = path.resolve(dir, header.linkname);
	              entryCount++;

	              mkdirp(dir, err => {
	                if (err) return reject(err);

	                const relativeTarget = path.relative(dir, target);
	                fs.symlink(relativeTarget, destFilePath, err => {
	                  if (err) return reject(err);
	                  successCount++;
	                  stream.resume();
	                });
	              });
	            } else { // directory
	              mkdirp(destFilePath, err => {
	                if (err) return reject(err);
	                stream.resume();
	              });
	            }
	          });
	      });
	    });
	  };
	};

	utils$2.streamToBuffer = stream => {
	  return new Promise((resolve, reject) => {
	    const chunks = [];
	    stream
	      .on('readable', () => {
	        let chunk;
	        while ((chunk = stream.read())) chunks.push(chunk);
	      })
	      .on('end', () => resolve(Buffer.concat(chunks)))
	      .on('error', err => reject(err));
	  });
	};

	function safePipe(streams) {
	  return new Promise((resolve, reject) => {
	    pump(streams[0], streams[1], err => {
	      if (err) return reject(err);
	      resolve();
	    });
	  });
	}

	utils$2.safePipe = safePipe;

	function normalizePath(fileName) {
	  fileName = path.normalize(fileName);
	  // https://nodejs.org/api/path.html#path_path_normalize_path
	  if (process.platform === 'win32') fileName = fileName.replace(/\\+/g, '/');
	  return fileName;
	}

	function stripFileName(strip, fileName, type) {
	  // before
	  // node/package.json
	  // node/lib/index.js
	  //
	  // when strip 1
	  // package.json
	  // lib/index.js
	  //
	  // when strip 2
	  // package.json
	  // index.js
	  if (Buffer.isBuffer(fileName)) fileName = fileName.toString();

	  // use / instead of \\
	  if (fileName.indexOf('\\') !== -1) fileName = fileName.replace(/\\+/g, '/');

	  // fix absolute path
	  // /foo => foo
	  if (fileName[0] === '/') fileName = fileName.replace(/^\/+/, '');

	  // fix case
	  // ./foo/bar => foo/bar
	  if (fileName) {
	    fileName = normalizePath(fileName);
	  }

	  let s = fileName.split('/');

	  // fix relative path
	  // foo/../bar/../../asdf/
	  //  => asdf/
	  if (s.indexOf('..') !== -1) {
	    // replace '../' on ../../foo/bar
	    fileName = fileName.replace(/(\.\.\/)+/, '');
	    if (type === 'directory' && fileName && fileName[fileName.length - 1] !== '/') {
	      fileName += '/';
	    }
	    s = fileName.split('/');
	  }

	  strip = Math.min(strip, s.length - 1);
	  return s.slice(strip).join('/') || '/';
	}

	utils$2.stripFileName = stripFileName;
	return utils$2;
}

var yazl = {};

var bufferCrc32;
var hasRequiredBufferCrc32;

function requireBufferCrc32 () {
	if (hasRequiredBufferCrc32) return bufferCrc32;
	hasRequiredBufferCrc32 = 1;
	var Buffer = require$$0$4.Buffer;

	var CRC_TABLE = [
	  0x00000000, 0x77073096, 0xee0e612c, 0x990951ba, 0x076dc419,
	  0x706af48f, 0xe963a535, 0x9e6495a3, 0x0edb8832, 0x79dcb8a4,
	  0xe0d5e91e, 0x97d2d988, 0x09b64c2b, 0x7eb17cbd, 0xe7b82d07,
	  0x90bf1d91, 0x1db71064, 0x6ab020f2, 0xf3b97148, 0x84be41de,
	  0x1adad47d, 0x6ddde4eb, 0xf4d4b551, 0x83d385c7, 0x136c9856,
	  0x646ba8c0, 0xfd62f97a, 0x8a65c9ec, 0x14015c4f, 0x63066cd9,
	  0xfa0f3d63, 0x8d080df5, 0x3b6e20c8, 0x4c69105e, 0xd56041e4,
	  0xa2677172, 0x3c03e4d1, 0x4b04d447, 0xd20d85fd, 0xa50ab56b,
	  0x35b5a8fa, 0x42b2986c, 0xdbbbc9d6, 0xacbcf940, 0x32d86ce3,
	  0x45df5c75, 0xdcd60dcf, 0xabd13d59, 0x26d930ac, 0x51de003a,
	  0xc8d75180, 0xbfd06116, 0x21b4f4b5, 0x56b3c423, 0xcfba9599,
	  0xb8bda50f, 0x2802b89e, 0x5f058808, 0xc60cd9b2, 0xb10be924,
	  0x2f6f7c87, 0x58684c11, 0xc1611dab, 0xb6662d3d, 0x76dc4190,
	  0x01db7106, 0x98d220bc, 0xefd5102a, 0x71b18589, 0x06b6b51f,
	  0x9fbfe4a5, 0xe8b8d433, 0x7807c9a2, 0x0f00f934, 0x9609a88e,
	  0xe10e9818, 0x7f6a0dbb, 0x086d3d2d, 0x91646c97, 0xe6635c01,
	  0x6b6b51f4, 0x1c6c6162, 0x856530d8, 0xf262004e, 0x6c0695ed,
	  0x1b01a57b, 0x8208f4c1, 0xf50fc457, 0x65b0d9c6, 0x12b7e950,
	  0x8bbeb8ea, 0xfcb9887c, 0x62dd1ddf, 0x15da2d49, 0x8cd37cf3,
	  0xfbd44c65, 0x4db26158, 0x3ab551ce, 0xa3bc0074, 0xd4bb30e2,
	  0x4adfa541, 0x3dd895d7, 0xa4d1c46d, 0xd3d6f4fb, 0x4369e96a,
	  0x346ed9fc, 0xad678846, 0xda60b8d0, 0x44042d73, 0x33031de5,
	  0xaa0a4c5f, 0xdd0d7cc9, 0x5005713c, 0x270241aa, 0xbe0b1010,
	  0xc90c2086, 0x5768b525, 0x206f85b3, 0xb966d409, 0xce61e49f,
	  0x5edef90e, 0x29d9c998, 0xb0d09822, 0xc7d7a8b4, 0x59b33d17,
	  0x2eb40d81, 0xb7bd5c3b, 0xc0ba6cad, 0xedb88320, 0x9abfb3b6,
	  0x03b6e20c, 0x74b1d29a, 0xead54739, 0x9dd277af, 0x04db2615,
	  0x73dc1683, 0xe3630b12, 0x94643b84, 0x0d6d6a3e, 0x7a6a5aa8,
	  0xe40ecf0b, 0x9309ff9d, 0x0a00ae27, 0x7d079eb1, 0xf00f9344,
	  0x8708a3d2, 0x1e01f268, 0x6906c2fe, 0xf762575d, 0x806567cb,
	  0x196c3671, 0x6e6b06e7, 0xfed41b76, 0x89d32be0, 0x10da7a5a,
	  0x67dd4acc, 0xf9b9df6f, 0x8ebeeff9, 0x17b7be43, 0x60b08ed5,
	  0xd6d6a3e8, 0xa1d1937e, 0x38d8c2c4, 0x4fdff252, 0xd1bb67f1,
	  0xa6bc5767, 0x3fb506dd, 0x48b2364b, 0xd80d2bda, 0xaf0a1b4c,
	  0x36034af6, 0x41047a60, 0xdf60efc3, 0xa867df55, 0x316e8eef,
	  0x4669be79, 0xcb61b38c, 0xbc66831a, 0x256fd2a0, 0x5268e236,
	  0xcc0c7795, 0xbb0b4703, 0x220216b9, 0x5505262f, 0xc5ba3bbe,
	  0xb2bd0b28, 0x2bb45a92, 0x5cb36a04, 0xc2d7ffa7, 0xb5d0cf31,
	  0x2cd99e8b, 0x5bdeae1d, 0x9b64c2b0, 0xec63f226, 0x756aa39c,
	  0x026d930a, 0x9c0906a9, 0xeb0e363f, 0x72076785, 0x05005713,
	  0x95bf4a82, 0xe2b87a14, 0x7bb12bae, 0x0cb61b38, 0x92d28e9b,
	  0xe5d5be0d, 0x7cdcefb7, 0x0bdbdf21, 0x86d3d2d4, 0xf1d4e242,
	  0x68ddb3f8, 0x1fda836e, 0x81be16cd, 0xf6b9265b, 0x6fb077e1,
	  0x18b74777, 0x88085ae6, 0xff0f6a70, 0x66063bca, 0x11010b5c,
	  0x8f659eff, 0xf862ae69, 0x616bffd3, 0x166ccf45, 0xa00ae278,
	  0xd70dd2ee, 0x4e048354, 0x3903b3c2, 0xa7672661, 0xd06016f7,
	  0x4969474d, 0x3e6e77db, 0xaed16a4a, 0xd9d65adc, 0x40df0b66,
	  0x37d83bf0, 0xa9bcae53, 0xdebb9ec5, 0x47b2cf7f, 0x30b5ffe9,
	  0xbdbdf21c, 0xcabac28a, 0x53b39330, 0x24b4a3a6, 0xbad03605,
	  0xcdd70693, 0x54de5729, 0x23d967bf, 0xb3667a2e, 0xc4614ab8,
	  0x5d681b02, 0x2a6f2b94, 0xb40bbe37, 0xc30c8ea1, 0x5a05df1b,
	  0x2d02ef8d
	];

	if (typeof Int32Array !== 'undefined') {
	  CRC_TABLE = new Int32Array(CRC_TABLE);
	}

	function ensureBuffer(input) {
	  if (Buffer.isBuffer(input)) {
	    return input;
	  }

	  var hasNewBufferAPI =
	      typeof Buffer.alloc === "function" &&
	      typeof Buffer.from === "function";

	  if (typeof input === "number") {
	    return hasNewBufferAPI ? Buffer.alloc(input) : new Buffer(input);
	  }
	  else if (typeof input === "string") {
	    return hasNewBufferAPI ? Buffer.from(input) : new Buffer(input);
	  }
	  else {
	    throw new Error("input must be buffer, number, or string, received " +
	                    typeof input);
	  }
	}

	function bufferizeInt(num) {
	  var tmp = ensureBuffer(4);
	  tmp.writeInt32BE(num, 0);
	  return tmp;
	}

	function _crc32(buf, previous) {
	  buf = ensureBuffer(buf);
	  if (Buffer.isBuffer(previous)) {
	    previous = previous.readUInt32BE(0);
	  }
	  var crc = ~~previous ^ -1;
	  for (var n = 0; n < buf.length; n++) {
	    crc = CRC_TABLE[(crc ^ buf[n]) & 0xff] ^ (crc >>> 8);
	  }
	  return (crc ^ -1);
	}

	function crc32() {
	  return bufferizeInt(_crc32.apply(null, arguments));
	}
	crc32.signed = function () {
	  return _crc32.apply(null, arguments);
	};
	crc32.unsigned = function () {
	  return _crc32.apply(null, arguments) >>> 0;
	};

	bufferCrc32 = crc32;
	return bufferCrc32;
}

var hasRequiredYazl;

function requireYazl () {
	if (hasRequiredYazl) return yazl;
	hasRequiredYazl = 1;
	var fs = fs__default;
	var Transform = require$$1$1.Transform;
	var PassThrough = require$$1$1.PassThrough;
	var zlib = require$$1$2;
	var util = require$$0$6;
	var EventEmitter = require$$0$5.EventEmitter;
	var crc32 = requireBufferCrc32();

	yazl.ZipFile = ZipFile;
	yazl.dateToDosDateTime = dateToDosDateTime;

	util.inherits(ZipFile, EventEmitter);
	function ZipFile() {
	  this.outputStream = new PassThrough();
	  this.entries = [];
	  this.outputStreamCursor = 0;
	  this.ended = false; // .end() sets this
	  this.allDone = false; // set when we've written the last bytes
	  this.forceZip64Eocd = false; // configurable in .end()
	}

	ZipFile.prototype.addFile = function(realPath, metadataPath, options) {
	  var self = this;
	  metadataPath = validateMetadataPath(metadataPath, false);
	  if (options == null) options = {};

	  var entry = new Entry(metadataPath, false, options);
	  self.entries.push(entry);
	  fs.stat(realPath, function(err, stats) {
	    if (err) return self.emit("error", err);
	    if (!stats.isFile()) return self.emit("error", new Error("not a file: " + realPath));
	    entry.uncompressedSize = stats.size;
	    if (options.mtime == null) entry.setLastModDate(stats.mtime);
	    if (options.mode == null) entry.setFileAttributesMode(stats.mode);
	    entry.setFileDataPumpFunction(function() {
	      var readStream = fs.createReadStream(realPath);
	      entry.state = Entry.FILE_DATA_IN_PROGRESS;
	      readStream.on("error", function(err) {
	        self.emit("error", err);
	      });
	      pumpFileDataReadStream(self, entry, readStream);
	    });
	    pumpEntries(self);
	  });
	};

	ZipFile.prototype.addReadStream = function(readStream, metadataPath, options) {
	  var self = this;
	  metadataPath = validateMetadataPath(metadataPath, false);
	  if (options == null) options = {};
	  var entry = new Entry(metadataPath, false, options);
	  self.entries.push(entry);
	  entry.setFileDataPumpFunction(function() {
	    entry.state = Entry.FILE_DATA_IN_PROGRESS;
	    pumpFileDataReadStream(self, entry, readStream);
	  });
	  pumpEntries(self);
	};

	ZipFile.prototype.addBuffer = function(buffer, metadataPath, options) {
	  var self = this;
	  metadataPath = validateMetadataPath(metadataPath, false);
	  if (buffer.length > 0x3fffffff) throw new Error("buffer too large: " + buffer.length + " > " + 0x3fffffff);
	  if (options == null) options = {};
	  if (options.size != null) throw new Error("options.size not allowed");
	  var entry = new Entry(metadataPath, false, options);
	  entry.uncompressedSize = buffer.length;
	  entry.crc32 = crc32.unsigned(buffer);
	  entry.crcAndFileSizeKnown = true;
	  self.entries.push(entry);
	  if (!entry.compress) {
	    setCompressedBuffer(buffer);
	  } else {
	    zlib.deflateRaw(buffer, function(err, compressedBuffer) {
	      setCompressedBuffer(compressedBuffer);
	    });
	  }
	  function setCompressedBuffer(compressedBuffer) {
	    entry.compressedSize = compressedBuffer.length;
	    entry.setFileDataPumpFunction(function() {
	      writeToOutputStream(self, compressedBuffer);
	      writeToOutputStream(self, entry.getDataDescriptor());
	      entry.state = Entry.FILE_DATA_DONE;

	      // don't call pumpEntries() recursively.
	      // (also, don't call process.nextTick recursively.)
	      setImmediate(function() {
	        pumpEntries(self);
	      });
	    });
	    pumpEntries(self);
	  }
	};

	ZipFile.prototype.addEmptyDirectory = function(metadataPath, options) {
	  var self = this;
	  metadataPath = validateMetadataPath(metadataPath, true);
	  if (options == null) options = {};
	  if (options.size != null) throw new Error("options.size not allowed");
	  if (options.compress != null) throw new Error("options.compress not allowed");
	  var entry = new Entry(metadataPath, true, options);
	  self.entries.push(entry);
	  entry.setFileDataPumpFunction(function() {
	    writeToOutputStream(self, entry.getDataDescriptor());
	    entry.state = Entry.FILE_DATA_DONE;
	    pumpEntries(self);
	  });
	  pumpEntries(self);
	};

	var eocdrSignatureBuffer = bufferFrom([0x50, 0x4b, 0x05, 0x06]);

	ZipFile.prototype.end = function(options, finalSizeCallback) {
	  if (typeof options === "function") {
	    finalSizeCallback = options;
	    options = null;
	  }
	  if (options == null) options = {};
	  if (this.ended) return;
	  this.ended = true;
	  this.finalSizeCallback = finalSizeCallback;
	  this.forceZip64Eocd = !!options.forceZip64Format;
	  if (options.comment) {
	    if (typeof options.comment === "string") {
	      this.comment = encodeCp437(options.comment);
	    } else {
	      // It should be a Buffer
	      this.comment = options.comment;
	    }
	    if (this.comment.length > 0xffff) throw new Error("comment is too large");
	    // gotta check for this, because the zipfile format is actually ambiguous.
	    if (bufferIncludes(this.comment, eocdrSignatureBuffer)) throw new Error("comment contains end of central directory record signature");
	  } else {
	    // no comment.
	    this.comment = EMPTY_BUFFER;
	  }
	  pumpEntries(this);
	};

	function writeToOutputStream(self, buffer) {
	  self.outputStream.write(buffer);
	  self.outputStreamCursor += buffer.length;
	}

	function pumpFileDataReadStream(self, entry, readStream) {
	  var crc32Watcher = new Crc32Watcher();
	  var uncompressedSizeCounter = new ByteCounter();
	  var compressor = entry.compress ? new zlib.DeflateRaw() : new PassThrough();
	  var compressedSizeCounter = new ByteCounter();
	  readStream.pipe(crc32Watcher)
	            .pipe(uncompressedSizeCounter)
	            .pipe(compressor)
	            .pipe(compressedSizeCounter)
	            .pipe(self.outputStream, {end: false});
	  compressedSizeCounter.on("end", function() {
	    entry.crc32 = crc32Watcher.crc32;
	    if (entry.uncompressedSize == null) {
	      entry.uncompressedSize = uncompressedSizeCounter.byteCount;
	    } else {
	      if (entry.uncompressedSize !== uncompressedSizeCounter.byteCount) return self.emit("error", new Error("file data stream has unexpected number of bytes"));
	    }
	    entry.compressedSize = compressedSizeCounter.byteCount;
	    self.outputStreamCursor += entry.compressedSize;
	    writeToOutputStream(self, entry.getDataDescriptor());
	    entry.state = Entry.FILE_DATA_DONE;
	    pumpEntries(self);
	  });
	}

	function pumpEntries(self) {
	  if (self.allDone) return;
	  // first check if finalSize is finally known
	  if (self.ended && self.finalSizeCallback != null) {
	    var finalSize = calculateFinalSize(self);
	    if (finalSize != null) {
	      // we have an answer
	      self.finalSizeCallback(finalSize);
	      self.finalSizeCallback = null;
	    }
	  }

	  // pump entries
	  var entry = getFirstNotDoneEntry();
	  function getFirstNotDoneEntry() {
	    for (var i = 0; i < self.entries.length; i++) {
	      var entry = self.entries[i];
	      if (entry.state < Entry.FILE_DATA_DONE) return entry;
	    }
	    return null;
	  }
	  if (entry != null) {
	    // this entry is not done yet
	    if (entry.state < Entry.READY_TO_PUMP_FILE_DATA) return; // input file not open yet
	    if (entry.state === Entry.FILE_DATA_IN_PROGRESS) return; // we'll get there
	    // start with local file header
	    entry.relativeOffsetOfLocalHeader = self.outputStreamCursor;
	    var localFileHeader = entry.getLocalFileHeader();
	    writeToOutputStream(self, localFileHeader);
	    entry.doFileDataPump();
	  } else {
	    // all cought up on writing entries
	    if (self.ended) {
	      // head for the exit
	      self.offsetOfStartOfCentralDirectory = self.outputStreamCursor;
	      self.entries.forEach(function(entry) {
	        var centralDirectoryRecord = entry.getCentralDirectoryRecord();
	        writeToOutputStream(self, centralDirectoryRecord);
	      });
	      writeToOutputStream(self, getEndOfCentralDirectoryRecord(self));
	      self.outputStream.end();
	      self.allDone = true;
	    }
	  }
	}

	function calculateFinalSize(self) {
	  var pretendOutputCursor = 0;
	  var centralDirectorySize = 0;
	  for (var i = 0; i < self.entries.length; i++) {
	    var entry = self.entries[i];
	    // compression is too hard to predict
	    if (entry.compress) return -1;
	    if (entry.state >= Entry.READY_TO_PUMP_FILE_DATA) {
	      // if addReadStream was called without providing the size, we can't predict the final size
	      if (entry.uncompressedSize == null) return -1;
	    } else {
	      // if we're still waiting for fs.stat, we might learn the size someday
	      if (entry.uncompressedSize == null) return null;
	    }
	    // we know this for sure, and this is important to know if we need ZIP64 format.
	    entry.relativeOffsetOfLocalHeader = pretendOutputCursor;
	    var useZip64Format = entry.useZip64Format();

	    pretendOutputCursor += LOCAL_FILE_HEADER_FIXED_SIZE + entry.utf8FileName.length;
	    pretendOutputCursor += entry.uncompressedSize;
	    if (!entry.crcAndFileSizeKnown) {
	      // use a data descriptor
	      if (useZip64Format) {
	        pretendOutputCursor += ZIP64_DATA_DESCRIPTOR_SIZE;
	      } else {
	        pretendOutputCursor += DATA_DESCRIPTOR_SIZE;
	      }
	    }

	    centralDirectorySize += CENTRAL_DIRECTORY_RECORD_FIXED_SIZE + entry.utf8FileName.length + entry.fileComment.length;
	    if (useZip64Format) {
	      centralDirectorySize += ZIP64_EXTENDED_INFORMATION_EXTRA_FIELD_SIZE;
	    }
	  }

	  var endOfCentralDirectorySize = 0;
	  if (self.forceZip64Eocd ||
	      self.entries.length >= 0xffff ||
	      centralDirectorySize >= 0xffff ||
	      pretendOutputCursor >= 0xffffffff) {
	    // use zip64 end of central directory stuff
	    endOfCentralDirectorySize += ZIP64_END_OF_CENTRAL_DIRECTORY_RECORD_SIZE + ZIP64_END_OF_CENTRAL_DIRECTORY_LOCATOR_SIZE;
	  }
	  endOfCentralDirectorySize += END_OF_CENTRAL_DIRECTORY_RECORD_SIZE + self.comment.length;
	  return pretendOutputCursor + centralDirectorySize + endOfCentralDirectorySize;
	}

	var ZIP64_END_OF_CENTRAL_DIRECTORY_RECORD_SIZE = 56;
	var ZIP64_END_OF_CENTRAL_DIRECTORY_LOCATOR_SIZE = 20;
	var END_OF_CENTRAL_DIRECTORY_RECORD_SIZE = 22;
	function getEndOfCentralDirectoryRecord(self, actuallyJustTellMeHowLongItWouldBe) {
	  var needZip64Format = false;
	  var normalEntriesLength = self.entries.length;
	  if (self.forceZip64Eocd || self.entries.length >= 0xffff) {
	    normalEntriesLength = 0xffff;
	    needZip64Format = true;
	  }
	  var sizeOfCentralDirectory = self.outputStreamCursor - self.offsetOfStartOfCentralDirectory;
	  var normalSizeOfCentralDirectory = sizeOfCentralDirectory;
	  if (self.forceZip64Eocd || sizeOfCentralDirectory >= 0xffffffff) {
	    normalSizeOfCentralDirectory = 0xffffffff;
	    needZip64Format = true;
	  }
	  var normalOffsetOfStartOfCentralDirectory = self.offsetOfStartOfCentralDirectory;
	  if (self.forceZip64Eocd || self.offsetOfStartOfCentralDirectory >= 0xffffffff) {
	    normalOffsetOfStartOfCentralDirectory = 0xffffffff;
	    needZip64Format = true;
	  }

	  var eocdrBuffer = bufferAlloc(END_OF_CENTRAL_DIRECTORY_RECORD_SIZE + self.comment.length);
	  // end of central dir signature                       4 bytes  (0x06054b50)
	  eocdrBuffer.writeUInt32LE(0x06054b50, 0);
	  // number of this disk                                2 bytes
	  eocdrBuffer.writeUInt16LE(0, 4);
	  // number of the disk with the start of the central directory  2 bytes
	  eocdrBuffer.writeUInt16LE(0, 6);
	  // total number of entries in the central directory on this disk  2 bytes
	  eocdrBuffer.writeUInt16LE(normalEntriesLength, 8);
	  // total number of entries in the central directory   2 bytes
	  eocdrBuffer.writeUInt16LE(normalEntriesLength, 10);
	  // size of the central directory                      4 bytes
	  eocdrBuffer.writeUInt32LE(normalSizeOfCentralDirectory, 12);
	  // offset of start of central directory with respect to the starting disk number  4 bytes
	  eocdrBuffer.writeUInt32LE(normalOffsetOfStartOfCentralDirectory, 16);
	  // .ZIP file comment length                           2 bytes
	  eocdrBuffer.writeUInt16LE(self.comment.length, 20);
	  // .ZIP file comment                                  (variable size)
	  self.comment.copy(eocdrBuffer, 22);

	  if (!needZip64Format) return eocdrBuffer;

	  // ZIP64 format
	  // ZIP64 End of Central Directory Record
	  var zip64EocdrBuffer = bufferAlloc(ZIP64_END_OF_CENTRAL_DIRECTORY_RECORD_SIZE);
	  // zip64 end of central dir signature                                             4 bytes  (0x06064b50)
	  zip64EocdrBuffer.writeUInt32LE(0x06064b50, 0);
	  // size of zip64 end of central directory record                                  8 bytes
	  writeUInt64LE(zip64EocdrBuffer, ZIP64_END_OF_CENTRAL_DIRECTORY_RECORD_SIZE - 12, 4);
	  // version made by                                                                2 bytes
	  zip64EocdrBuffer.writeUInt16LE(VERSION_MADE_BY, 12);
	  // version needed to extract                                                      2 bytes
	  zip64EocdrBuffer.writeUInt16LE(VERSION_NEEDED_TO_EXTRACT_ZIP64, 14);
	  // number of this disk                                                            4 bytes
	  zip64EocdrBuffer.writeUInt32LE(0, 16);
	  // number of the disk with the start of the central directory                     4 bytes
	  zip64EocdrBuffer.writeUInt32LE(0, 20);
	  // total number of entries in the central directory on this disk                  8 bytes
	  writeUInt64LE(zip64EocdrBuffer, self.entries.length, 24);
	  // total number of entries in the central directory                               8 bytes
	  writeUInt64LE(zip64EocdrBuffer, self.entries.length, 32);
	  // size of the central directory                                                  8 bytes
	  writeUInt64LE(zip64EocdrBuffer, sizeOfCentralDirectory, 40);
	  // offset of start of central directory with respect to the starting disk number  8 bytes
	  writeUInt64LE(zip64EocdrBuffer, self.offsetOfStartOfCentralDirectory, 48);
	  // zip64 extensible data sector                                                   (variable size)
	  // nothing in the zip64 extensible data sector


	  // ZIP64 End of Central Directory Locator
	  var zip64EocdlBuffer = bufferAlloc(ZIP64_END_OF_CENTRAL_DIRECTORY_LOCATOR_SIZE);
	  // zip64 end of central dir locator signature                               4 bytes  (0x07064b50)
	  zip64EocdlBuffer.writeUInt32LE(0x07064b50, 0);
	  // number of the disk with the start of the zip64 end of central directory  4 bytes
	  zip64EocdlBuffer.writeUInt32LE(0, 4);
	  // relative offset of the zip64 end of central directory record             8 bytes
	  writeUInt64LE(zip64EocdlBuffer, self.outputStreamCursor, 8);
	  // total number of disks                                                    4 bytes
	  zip64EocdlBuffer.writeUInt32LE(1, 16);


	  return Buffer.concat([
	    zip64EocdrBuffer,
	    zip64EocdlBuffer,
	    eocdrBuffer,
	  ]);
	}

	function validateMetadataPath(metadataPath, isDirectory) {
	  if (metadataPath === "") throw new Error("empty metadataPath");
	  metadataPath = metadataPath.replace(/\\/g, "/");
	  if (/^[a-zA-Z]:/.test(metadataPath) || /^\//.test(metadataPath)) throw new Error("absolute path: " + metadataPath);
	  if (metadataPath.split("/").indexOf("..") !== -1) throw new Error("invalid relative path: " + metadataPath);
	  var looksLikeDirectory = /\/$/.test(metadataPath);
	  if (isDirectory) {
	    // append a trailing '/' if necessary.
	    if (!looksLikeDirectory) metadataPath += "/";
	  } else {
	    if (looksLikeDirectory) throw new Error("file path cannot end with '/': " + metadataPath);
	  }
	  return metadataPath;
	}

	var EMPTY_BUFFER = bufferAlloc(0);

	// this class is not part of the public API
	function Entry(metadataPath, isDirectory, options) {
	  this.utf8FileName = bufferFrom(metadataPath);
	  if (this.utf8FileName.length > 0xffff) throw new Error("utf8 file name too long. " + utf8FileName.length + " > " + 0xffff);
	  this.isDirectory = isDirectory;
	  this.state = Entry.WAITING_FOR_METADATA;
	  this.setLastModDate(options.mtime != null ? options.mtime : new Date());
	  if (options.mode != null) {
	    this.setFileAttributesMode(options.mode);
	  } else {
	    this.setFileAttributesMode(isDirectory ? 0o40775 : 0o100664);
	  }
	  if (isDirectory) {
	    this.crcAndFileSizeKnown = true;
	    this.crc32 = 0;
	    this.uncompressedSize = 0;
	    this.compressedSize = 0;
	  } else {
	    // unknown so far
	    this.crcAndFileSizeKnown = false;
	    this.crc32 = null;
	    this.uncompressedSize = null;
	    this.compressedSize = null;
	    if (options.size != null) this.uncompressedSize = options.size;
	  }
	  if (isDirectory) {
	    this.compress = false;
	  } else {
	    this.compress = true; // default
	    if (options.compress != null) this.compress = !!options.compress;
	  }
	  this.forceZip64Format = !!options.forceZip64Format;
	  if (options.fileComment) {
	    if (typeof options.fileComment === "string") {
	      this.fileComment = bufferFrom(options.fileComment, "utf-8");
	    } else {
	      // It should be a Buffer
	      this.fileComment = options.fileComment;
	    }
	    if (this.fileComment.length > 0xffff) throw new Error("fileComment is too large");
	  } else {
	    // no comment.
	    this.fileComment = EMPTY_BUFFER;
	  }
	}
	Entry.WAITING_FOR_METADATA = 0;
	Entry.READY_TO_PUMP_FILE_DATA = 1;
	Entry.FILE_DATA_IN_PROGRESS = 2;
	Entry.FILE_DATA_DONE = 3;
	Entry.prototype.setLastModDate = function(date) {
	  var dosDateTime = dateToDosDateTime(date);
	  this.lastModFileTime = dosDateTime.time;
	  this.lastModFileDate = dosDateTime.date;
	};
	Entry.prototype.setFileAttributesMode = function(mode) {
	  if ((mode & 0xffff) !== mode) throw new Error("invalid mode. expected: 0 <= " + mode + " <= " + 0xffff);
	  // http://unix.stackexchange.com/questions/14705/the-zip-formats-external-file-attribute/14727#14727
	  this.externalFileAttributes = (mode << 16) >>> 0;
	};
	// doFileDataPump() should not call pumpEntries() directly. see issue #9.
	Entry.prototype.setFileDataPumpFunction = function(doFileDataPump) {
	  this.doFileDataPump = doFileDataPump;
	  this.state = Entry.READY_TO_PUMP_FILE_DATA;
	};
	Entry.prototype.useZip64Format = function() {
	  return (
	    (this.forceZip64Format) ||
	    (this.uncompressedSize != null && this.uncompressedSize > 0xfffffffe) ||
	    (this.compressedSize != null && this.compressedSize > 0xfffffffe) ||
	    (this.relativeOffsetOfLocalHeader != null && this.relativeOffsetOfLocalHeader > 0xfffffffe)
	  );
	};
	var LOCAL_FILE_HEADER_FIXED_SIZE = 30;
	var VERSION_NEEDED_TO_EXTRACT_UTF8 = 20;
	var VERSION_NEEDED_TO_EXTRACT_ZIP64 = 45;
	// 3 = unix. 63 = spec version 6.3
	var VERSION_MADE_BY = (3 << 8) | 63;
	var FILE_NAME_IS_UTF8 = 1 << 11;
	var UNKNOWN_CRC32_AND_FILE_SIZES = 1 << 3;
	Entry.prototype.getLocalFileHeader = function() {
	  var crc32 = 0;
	  var compressedSize = 0;
	  var uncompressedSize = 0;
	  if (this.crcAndFileSizeKnown) {
	    crc32 = this.crc32;
	    compressedSize = this.compressedSize;
	    uncompressedSize = this.uncompressedSize;
	  }

	  var fixedSizeStuff = bufferAlloc(LOCAL_FILE_HEADER_FIXED_SIZE);
	  var generalPurposeBitFlag = FILE_NAME_IS_UTF8;
	  if (!this.crcAndFileSizeKnown) generalPurposeBitFlag |= UNKNOWN_CRC32_AND_FILE_SIZES;

	  // local file header signature     4 bytes  (0x04034b50)
	  fixedSizeStuff.writeUInt32LE(0x04034b50, 0);
	  // version needed to extract       2 bytes
	  fixedSizeStuff.writeUInt16LE(VERSION_NEEDED_TO_EXTRACT_UTF8, 4);
	  // general purpose bit flag        2 bytes
	  fixedSizeStuff.writeUInt16LE(generalPurposeBitFlag, 6);
	  // compression method              2 bytes
	  fixedSizeStuff.writeUInt16LE(this.getCompressionMethod(), 8);
	  // last mod file time              2 bytes
	  fixedSizeStuff.writeUInt16LE(this.lastModFileTime, 10);
	  // last mod file date              2 bytes
	  fixedSizeStuff.writeUInt16LE(this.lastModFileDate, 12);
	  // crc-32                          4 bytes
	  fixedSizeStuff.writeUInt32LE(crc32, 14);
	  // compressed size                 4 bytes
	  fixedSizeStuff.writeUInt32LE(compressedSize, 18);
	  // uncompressed size               4 bytes
	  fixedSizeStuff.writeUInt32LE(uncompressedSize, 22);
	  // file name length                2 bytes
	  fixedSizeStuff.writeUInt16LE(this.utf8FileName.length, 26);
	  // extra field length              2 bytes
	  fixedSizeStuff.writeUInt16LE(0, 28);
	  return Buffer.concat([
	    fixedSizeStuff,
	    // file name (variable size)
	    this.utf8FileName,
	    // extra field (variable size)
	    // no extra fields
	  ]);
	};
	var DATA_DESCRIPTOR_SIZE = 16;
	var ZIP64_DATA_DESCRIPTOR_SIZE = 24;
	Entry.prototype.getDataDescriptor = function() {
	  if (this.crcAndFileSizeKnown) {
	    // the Mac Archive Utility requires this not be present unless we set general purpose bit 3
	    return EMPTY_BUFFER;
	  }
	  if (!this.useZip64Format()) {
	    var buffer = bufferAlloc(DATA_DESCRIPTOR_SIZE);
	    // optional signature (required according to Archive Utility)
	    buffer.writeUInt32LE(0x08074b50, 0);
	    // crc-32                          4 bytes
	    buffer.writeUInt32LE(this.crc32, 4);
	    // compressed size                 4 bytes
	    buffer.writeUInt32LE(this.compressedSize, 8);
	    // uncompressed size               4 bytes
	    buffer.writeUInt32LE(this.uncompressedSize, 12);
	    return buffer;
	  } else {
	    // ZIP64 format
	    var buffer = bufferAlloc(ZIP64_DATA_DESCRIPTOR_SIZE);
	    // optional signature (unknown if anyone cares about this)
	    buffer.writeUInt32LE(0x08074b50, 0);
	    // crc-32                          4 bytes
	    buffer.writeUInt32LE(this.crc32, 4);
	    // compressed size                 8 bytes
	    writeUInt64LE(buffer, this.compressedSize, 8);
	    // uncompressed size               8 bytes
	    writeUInt64LE(buffer, this.uncompressedSize, 16);
	    return buffer;
	  }
	};
	var CENTRAL_DIRECTORY_RECORD_FIXED_SIZE = 46;
	var ZIP64_EXTENDED_INFORMATION_EXTRA_FIELD_SIZE = 28;
	Entry.prototype.getCentralDirectoryRecord = function() {
	  var fixedSizeStuff = bufferAlloc(CENTRAL_DIRECTORY_RECORD_FIXED_SIZE);
	  var generalPurposeBitFlag = FILE_NAME_IS_UTF8;
	  if (!this.crcAndFileSizeKnown) generalPurposeBitFlag |= UNKNOWN_CRC32_AND_FILE_SIZES;

	  var normalCompressedSize = this.compressedSize;
	  var normalUncompressedSize = this.uncompressedSize;
	  var normalRelativeOffsetOfLocalHeader = this.relativeOffsetOfLocalHeader;
	  var versionNeededToExtract;
	  var zeiefBuffer;
	  if (this.useZip64Format()) {
	    normalCompressedSize = 0xffffffff;
	    normalUncompressedSize = 0xffffffff;
	    normalRelativeOffsetOfLocalHeader = 0xffffffff;
	    versionNeededToExtract = VERSION_NEEDED_TO_EXTRACT_ZIP64;

	    // ZIP64 extended information extra field
	    zeiefBuffer = bufferAlloc(ZIP64_EXTENDED_INFORMATION_EXTRA_FIELD_SIZE);
	    // 0x0001                  2 bytes    Tag for this "extra" block type
	    zeiefBuffer.writeUInt16LE(0x0001, 0);
	    // Size                    2 bytes    Size of this "extra" block
	    zeiefBuffer.writeUInt16LE(ZIP64_EXTENDED_INFORMATION_EXTRA_FIELD_SIZE - 4, 2);
	    // Original Size           8 bytes    Original uncompressed file size
	    writeUInt64LE(zeiefBuffer, this.uncompressedSize, 4);
	    // Compressed Size         8 bytes    Size of compressed data
	    writeUInt64LE(zeiefBuffer, this.compressedSize, 12);
	    // Relative Header Offset  8 bytes    Offset of local header record
	    writeUInt64LE(zeiefBuffer, this.relativeOffsetOfLocalHeader, 20);
	    // Disk Start Number       4 bytes    Number of the disk on which this file starts
	    // (omit)
	  } else {
	    versionNeededToExtract = VERSION_NEEDED_TO_EXTRACT_UTF8;
	    zeiefBuffer = EMPTY_BUFFER;
	  }

	  // central file header signature   4 bytes  (0x02014b50)
	  fixedSizeStuff.writeUInt32LE(0x02014b50, 0);
	  // version made by                 2 bytes
	  fixedSizeStuff.writeUInt16LE(VERSION_MADE_BY, 4);
	  // version needed to extract       2 bytes
	  fixedSizeStuff.writeUInt16LE(versionNeededToExtract, 6);
	  // general purpose bit flag        2 bytes
	  fixedSizeStuff.writeUInt16LE(generalPurposeBitFlag, 8);
	  // compression method              2 bytes
	  fixedSizeStuff.writeUInt16LE(this.getCompressionMethod(), 10);
	  // last mod file time              2 bytes
	  fixedSizeStuff.writeUInt16LE(this.lastModFileTime, 12);
	  // last mod file date              2 bytes
	  fixedSizeStuff.writeUInt16LE(this.lastModFileDate, 14);
	  // crc-32                          4 bytes
	  fixedSizeStuff.writeUInt32LE(this.crc32, 16);
	  // compressed size                 4 bytes
	  fixedSizeStuff.writeUInt32LE(normalCompressedSize, 20);
	  // uncompressed size               4 bytes
	  fixedSizeStuff.writeUInt32LE(normalUncompressedSize, 24);
	  // file name length                2 bytes
	  fixedSizeStuff.writeUInt16LE(this.utf8FileName.length, 28);
	  // extra field length              2 bytes
	  fixedSizeStuff.writeUInt16LE(zeiefBuffer.length, 30);
	  // file comment length             2 bytes
	  fixedSizeStuff.writeUInt16LE(this.fileComment.length, 32);
	  // disk number start               2 bytes
	  fixedSizeStuff.writeUInt16LE(0, 34);
	  // internal file attributes        2 bytes
	  fixedSizeStuff.writeUInt16LE(0, 36);
	  // external file attributes        4 bytes
	  fixedSizeStuff.writeUInt32LE(this.externalFileAttributes, 38);
	  // relative offset of local header 4 bytes
	  fixedSizeStuff.writeUInt32LE(normalRelativeOffsetOfLocalHeader, 42);

	  return Buffer.concat([
	    fixedSizeStuff,
	    // file name (variable size)
	    this.utf8FileName,
	    // extra field (variable size)
	    zeiefBuffer,
	    // file comment (variable size)
	    this.fileComment,
	  ]);
	};
	Entry.prototype.getCompressionMethod = function() {
	  var NO_COMPRESSION = 0;
	  var DEFLATE_COMPRESSION = 8;
	  return this.compress ? DEFLATE_COMPRESSION : NO_COMPRESSION;
	};

	function dateToDosDateTime(jsDate) {
	  var date = 0;
	  date |= jsDate.getDate() & 0x1f; // 1-31
	  date |= ((jsDate.getMonth() + 1) & 0xf) << 5; // 0-11, 1-12
	  date |= ((jsDate.getFullYear() - 1980) & 0x7f) << 9; // 0-128, 1980-2108

	  var time = 0;
	  time |= Math.floor(jsDate.getSeconds() / 2); // 0-59, 0-29 (lose odd numbers)
	  time |= (jsDate.getMinutes() & 0x3f) << 5; // 0-59
	  time |= (jsDate.getHours() & 0x1f) << 11; // 0-23

	  return {date: date, time: time};
	}

	function writeUInt64LE(buffer, n, offset) {
	  // can't use bitshift here, because JavaScript only allows bitshifting on 32-bit integers.
	  var high = Math.floor(n / 0x100000000);
	  var low = n % 0x100000000;
	  buffer.writeUInt32LE(low, offset);
	  buffer.writeUInt32LE(high, offset + 4);
	}

	util.inherits(ByteCounter, Transform);
	function ByteCounter(options) {
	  Transform.call(this, options);
	  this.byteCount = 0;
	}
	ByteCounter.prototype._transform = function(chunk, encoding, cb) {
	  this.byteCount += chunk.length;
	  cb(null, chunk);
	};

	util.inherits(Crc32Watcher, Transform);
	function Crc32Watcher(options) {
	  Transform.call(this, options);
	  this.crc32 = 0;
	}
	Crc32Watcher.prototype._transform = function(chunk, encoding, cb) {
	  this.crc32 = crc32.unsigned(chunk, this.crc32);
	  cb(null, chunk);
	};

	var cp437 = '\u0000☺☻♥♦♣♠•◘○◙♂♀♪♫☼►◄↕‼¶§▬↨↑↓→←∟↔▲▼ !"#$%&\'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~⌂ÇüéâäàåçêëèïîìÄÅÉæÆôöòûùÿÖÜ¢£¥₧ƒáíóúñÑªº¿⌐¬½¼¡«»░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀αßΓπΣσµτΦΘΩδ∞φε∩≡±≥≤⌠⌡÷≈°∙·√ⁿ²■ ';
	if (cp437.length !== 256) throw new Error("assertion failure");
	var reverseCp437 = null;

	function encodeCp437(string) {
	  if (/^[\x20-\x7e]*$/.test(string)) {
	    // CP437, ASCII, and UTF-8 overlap in this range.
	    return bufferFrom(string, "utf-8");
	  }

	  // This is the slow path.
	  if (reverseCp437 == null) {
	    // cache this once
	    reverseCp437 = {};
	    for (var i = 0; i < cp437.length; i++) {
	      reverseCp437[cp437[i]] = i;
	    }
	  }

	  var result = bufferAlloc(string.length);
	  for (var i = 0; i < string.length; i++) {
	    var b = reverseCp437[string[i]];
	    if (b == null) throw new Error("character not encodable in CP437: " + JSON.stringify(string[i]));
	    result[i] = b;
	  }

	  return result;
	}

	function bufferAlloc(size) {
	  bufferAlloc = modern;
	  try {
	    return bufferAlloc(size);
	  } catch (e) {
	    bufferAlloc = legacy;
	    return bufferAlloc(size);
	  }
	  function modern(size) {
	    return Buffer.allocUnsafe(size);
	  }
	  function legacy(size) {
	    return new Buffer(size);
	  }
	}
	function bufferFrom(something, encoding) {
	  bufferFrom = modern;
	  try {
	    return bufferFrom(something, encoding);
	  } catch (e) {
	    bufferFrom = legacy;
	    return bufferFrom(something, encoding);
	  }
	  function modern(something, encoding) {
	    return Buffer.from(something, encoding);
	  }
	  function legacy(something, encoding) {
	    return new Buffer(something, encoding);
	  }
	}
	function bufferIncludes(buffer, content) {
	  bufferIncludes = modern;
	  try {
	    return bufferIncludes(buffer, content);
	  } catch (e) {
	    bufferIncludes = legacy;
	    return bufferIncludes(buffer, content);
	  }
	  function modern(buffer, content) {
	    return buffer.includes(content);
	  }
	  function legacy(buffer, content) {
	    for (var i = 0; i <= buffer.length - content.length; i++) {
	      for (var j = 0;; j++) {
	        if (j === content.length) return true;
	        if (buffer[i + j] !== content[j]) break;
	      }
	    }
	    return false;
	  }
	}
	return yazl;
}

var tarStream = {};

var processNextickArgs = {exports: {}};

var hasRequiredProcessNextickArgs;

function requireProcessNextickArgs () {
	if (hasRequiredProcessNextickArgs) return processNextickArgs.exports;
	hasRequiredProcessNextickArgs = 1;

	if (typeof process === 'undefined' ||
	    !process.version ||
	    process.version.indexOf('v0.') === 0 ||
	    process.version.indexOf('v1.') === 0 && process.version.indexOf('v1.8.') !== 0) {
	  processNextickArgs.exports = { nextTick: nextTick };
	} else {
	  processNextickArgs.exports = process;
	}

	function nextTick(fn, arg1, arg2, arg3) {
	  if (typeof fn !== 'function') {
	    throw new TypeError('"callback" argument must be a function');
	  }
	  var len = arguments.length;
	  var args, i;
	  switch (len) {
	  case 0:
	  case 1:
	    return process.nextTick(fn);
	  case 2:
	    return process.nextTick(function afterTickOne() {
	      fn.call(null, arg1);
	    });
	  case 3:
	    return process.nextTick(function afterTickTwo() {
	      fn.call(null, arg1, arg2);
	    });
	  case 4:
	    return process.nextTick(function afterTickThree() {
	      fn.call(null, arg1, arg2, arg3);
	    });
	  default:
	    args = new Array(len - 1);
	    i = 0;
	    while (i < args.length) {
	      args[i++] = arguments[i];
	    }
	    return process.nextTick(function afterTick() {
	      fn.apply(null, args);
	    });
	  }
	}
	return processNextickArgs.exports;
}

var util$3 = {};

var hasRequiredUtil$2;

function requireUtil$2 () {
	if (hasRequiredUtil$2) return util$3;
	hasRequiredUtil$2 = 1;
	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	// NOTE: These type checking functions intentionally don't use `instanceof`
	// because it is fragile and can be easily faked with `Object.create()`.

	function isArray(arg) {
	  if (Array.isArray) {
	    return Array.isArray(arg);
	  }
	  return objectToString(arg) === '[object Array]';
	}
	util$3.isArray = isArray;

	function isBoolean(arg) {
	  return typeof arg === 'boolean';
	}
	util$3.isBoolean = isBoolean;

	function isNull(arg) {
	  return arg === null;
	}
	util$3.isNull = isNull;

	function isNullOrUndefined(arg) {
	  return arg == null;
	}
	util$3.isNullOrUndefined = isNullOrUndefined;

	function isNumber(arg) {
	  return typeof arg === 'number';
	}
	util$3.isNumber = isNumber;

	function isString(arg) {
	  return typeof arg === 'string';
	}
	util$3.isString = isString;

	function isSymbol(arg) {
	  return typeof arg === 'symbol';
	}
	util$3.isSymbol = isSymbol;

	function isUndefined(arg) {
	  return arg === void 0;
	}
	util$3.isUndefined = isUndefined;

	function isRegExp(re) {
	  return objectToString(re) === '[object RegExp]';
	}
	util$3.isRegExp = isRegExp;

	function isObject(arg) {
	  return typeof arg === 'object' && arg !== null;
	}
	util$3.isObject = isObject;

	function isDate(d) {
	  return objectToString(d) === '[object Date]';
	}
	util$3.isDate = isDate;

	function isError(e) {
	  return (objectToString(e) === '[object Error]' || e instanceof Error);
	}
	util$3.isError = isError;

	function isFunction(arg) {
	  return typeof arg === 'function';
	}
	util$3.isFunction = isFunction;

	function isPrimitive(arg) {
	  return arg === null ||
	         typeof arg === 'boolean' ||
	         typeof arg === 'number' ||
	         typeof arg === 'string' ||
	         typeof arg === 'symbol' ||  // ES6 symbol
	         typeof arg === 'undefined';
	}
	util$3.isPrimitive = isPrimitive;

	util$3.isBuffer = require$$0$4.Buffer.isBuffer;

	function objectToString(o) {
	  return Object.prototype.toString.call(o);
	}
	return util$3;
}

var inherits_browser = {exports: {}};

var hasRequiredInherits_browser;

function requireInherits_browser () {
	if (hasRequiredInherits_browser) return inherits_browser.exports;
	hasRequiredInherits_browser = 1;
	if (typeof Object.create === 'function') {
	  // implementation from standard node.js 'util' module
	  inherits_browser.exports = function inherits(ctor, superCtor) {
	    if (superCtor) {
	      ctor.super_ = superCtor;
	      ctor.prototype = Object.create(superCtor.prototype, {
	        constructor: {
	          value: ctor,
	          enumerable: false,
	          writable: true,
	          configurable: true
	        }
	      });
	    }
	  };
	} else {
	  // old school shim for old browsers
	  inherits_browser.exports = function inherits(ctor, superCtor) {
	    if (superCtor) {
	      ctor.super_ = superCtor;
	      var TempCtor = function () {};
	      TempCtor.prototype = superCtor.prototype;
	      ctor.prototype = new TempCtor();
	      ctor.prototype.constructor = ctor;
	    }
	  };
	}
	return inherits_browser.exports;
}

var isarray$1;
var hasRequiredIsarray$1;

function requireIsarray$1 () {
	if (hasRequiredIsarray$1) return isarray$1;
	hasRequiredIsarray$1 = 1;
	var toString = {}.toString;

	isarray$1 = Array.isArray || function (arr) {
	  return toString.call(arr) == '[object Array]';
	};
	return isarray$1;
}

var streamBrowser$1;
var hasRequiredStreamBrowser$1;

function requireStreamBrowser$1 () {
	if (hasRequiredStreamBrowser$1) return streamBrowser$1;
	hasRequiredStreamBrowser$1 = 1;
	streamBrowser$1 = require$$0$5.EventEmitter;
	return streamBrowser$1;
}

var safeBuffer$1 = {exports: {}};

/* eslint-disable node/no-deprecated-api */

var hasRequiredSafeBuffer$1;

function requireSafeBuffer$1 () {
	if (hasRequiredSafeBuffer$1) return safeBuffer$1.exports;
	hasRequiredSafeBuffer$1 = 1;
	(function (module, exports$1) {
		var buffer = require$$0$4;
		var Buffer = buffer.Buffer;

		// alternative to using Object.keys for old browsers
		function copyProps (src, dst) {
		  for (var key in src) {
		    dst[key] = src[key];
		  }
		}
		if (Buffer.from && Buffer.alloc && Buffer.allocUnsafe && Buffer.allocUnsafeSlow) {
		  module.exports = buffer;
		} else {
		  // Copy properties from require('buffer')
		  copyProps(buffer, exports$1);
		  exports$1.Buffer = SafeBuffer;
		}

		function SafeBuffer (arg, encodingOrOffset, length) {
		  return Buffer(arg, encodingOrOffset, length)
		}

		// Copy static methods from Buffer
		copyProps(Buffer, SafeBuffer);

		SafeBuffer.from = function (arg, encodingOrOffset, length) {
		  if (typeof arg === 'number') {
		    throw new TypeError('Argument must not be a number')
		  }
		  return Buffer(arg, encodingOrOffset, length)
		};

		SafeBuffer.alloc = function (size, fill, encoding) {
		  if (typeof size !== 'number') {
		    throw new TypeError('Argument must be a number')
		  }
		  var buf = Buffer(size);
		  if (fill !== undefined) {
		    if (typeof encoding === 'string') {
		      buf.fill(fill, encoding);
		    } else {
		      buf.fill(fill);
		    }
		  } else {
		    buf.fill(0);
		  }
		  return buf
		};

		SafeBuffer.allocUnsafe = function (size) {
		  if (typeof size !== 'number') {
		    throw new TypeError('Argument must be a number')
		  }
		  return Buffer(size)
		};

		SafeBuffer.allocUnsafeSlow = function (size) {
		  if (typeof size !== 'number') {
		    throw new TypeError('Argument must be a number')
		  }
		  return buffer.SlowBuffer(size)
		}; 
	} (safeBuffer$1, safeBuffer$1.exports));
	return safeBuffer$1.exports;
}

var BufferList = {exports: {}};

var hasRequiredBufferList;

function requireBufferList () {
	if (hasRequiredBufferList) return BufferList.exports;
	hasRequiredBufferList = 1;
	(function (module) {

		function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

		var Buffer = requireSafeBuffer$1().Buffer;
		var util = require$$0$6;

		function copyBuffer(src, target, offset) {
		  src.copy(target, offset);
		}

		module.exports = function () {
		  function BufferList() {
		    _classCallCheck(this, BufferList);

		    this.head = null;
		    this.tail = null;
		    this.length = 0;
		  }

		  BufferList.prototype.push = function push(v) {
		    var entry = { data: v, next: null };
		    if (this.length > 0) this.tail.next = entry;else this.head = entry;
		    this.tail = entry;
		    ++this.length;
		  };

		  BufferList.prototype.unshift = function unshift(v) {
		    var entry = { data: v, next: this.head };
		    if (this.length === 0) this.tail = entry;
		    this.head = entry;
		    ++this.length;
		  };

		  BufferList.prototype.shift = function shift() {
		    if (this.length === 0) return;
		    var ret = this.head.data;
		    if (this.length === 1) this.head = this.tail = null;else this.head = this.head.next;
		    --this.length;
		    return ret;
		  };

		  BufferList.prototype.clear = function clear() {
		    this.head = this.tail = null;
		    this.length = 0;
		  };

		  BufferList.prototype.join = function join(s) {
		    if (this.length === 0) return '';
		    var p = this.head;
		    var ret = '' + p.data;
		    while (p = p.next) {
		      ret += s + p.data;
		    }return ret;
		  };

		  BufferList.prototype.concat = function concat(n) {
		    if (this.length === 0) return Buffer.alloc(0);
		    var ret = Buffer.allocUnsafe(n >>> 0);
		    var p = this.head;
		    var i = 0;
		    while (p) {
		      copyBuffer(p.data, ret, i);
		      i += p.data.length;
		      p = p.next;
		    }
		    return ret;
		  };

		  return BufferList;
		}();

		if (util && util.inspect && util.inspect.custom) {
		  module.exports.prototype[util.inspect.custom] = function () {
		    var obj = util.inspect({ length: this.length });
		    return this.constructor.name + ' ' + obj;
		  };
		} 
	} (BufferList));
	return BufferList.exports;
}

var destroy_1$1;
var hasRequiredDestroy$1;

function requireDestroy$1 () {
	if (hasRequiredDestroy$1) return destroy_1$1;
	hasRequiredDestroy$1 = 1;

	/*<replacement>*/

	var pna = requireProcessNextickArgs();
	/*</replacement>*/

	// undocumented cb() API, needed for core, not for public API
	function destroy(err, cb) {
	  var _this = this;

	  var readableDestroyed = this._readableState && this._readableState.destroyed;
	  var writableDestroyed = this._writableState && this._writableState.destroyed;

	  if (readableDestroyed || writableDestroyed) {
	    if (cb) {
	      cb(err);
	    } else if (err) {
	      if (!this._writableState) {
	        pna.nextTick(emitErrorNT, this, err);
	      } else if (!this._writableState.errorEmitted) {
	        this._writableState.errorEmitted = true;
	        pna.nextTick(emitErrorNT, this, err);
	      }
	    }

	    return this;
	  }

	  // we set destroyed to true before firing error callbacks in order
	  // to make it re-entrance safe in case destroy() is called within callbacks

	  if (this._readableState) {
	    this._readableState.destroyed = true;
	  }

	  // if this is a duplex stream mark the writable part as destroyed as well
	  if (this._writableState) {
	    this._writableState.destroyed = true;
	  }

	  this._destroy(err || null, function (err) {
	    if (!cb && err) {
	      if (!_this._writableState) {
	        pna.nextTick(emitErrorNT, _this, err);
	      } else if (!_this._writableState.errorEmitted) {
	        _this._writableState.errorEmitted = true;
	        pna.nextTick(emitErrorNT, _this, err);
	      }
	    } else if (cb) {
	      cb(err);
	    }
	  });

	  return this;
	}

	function undestroy() {
	  if (this._readableState) {
	    this._readableState.destroyed = false;
	    this._readableState.reading = false;
	    this._readableState.ended = false;
	    this._readableState.endEmitted = false;
	  }

	  if (this._writableState) {
	    this._writableState.destroyed = false;
	    this._writableState.ended = false;
	    this._writableState.ending = false;
	    this._writableState.finalCalled = false;
	    this._writableState.prefinished = false;
	    this._writableState.finished = false;
	    this._writableState.errorEmitted = false;
	  }
	}

	function emitErrorNT(self, err) {
	  self.emit('error', err);
	}

	destroy_1$1 = {
	  destroy: destroy,
	  undestroy: undestroy
	};
	return destroy_1$1;
}

var string_decoder$1 = {};

var hasRequiredString_decoder$1;

function requireString_decoder$1 () {
	if (hasRequiredString_decoder$1) return string_decoder$1;
	hasRequiredString_decoder$1 = 1;

	/*<replacement>*/

	var Buffer = requireSafeBuffer$1().Buffer;
	/*</replacement>*/

	var isEncoding = Buffer.isEncoding || function (encoding) {
	  encoding = '' + encoding;
	  switch (encoding && encoding.toLowerCase()) {
	    case 'hex':case 'utf8':case 'utf-8':case 'ascii':case 'binary':case 'base64':case 'ucs2':case 'ucs-2':case 'utf16le':case 'utf-16le':case 'raw':
	      return true;
	    default:
	      return false;
	  }
	};

	function _normalizeEncoding(enc) {
	  if (!enc) return 'utf8';
	  var retried;
	  while (true) {
	    switch (enc) {
	      case 'utf8':
	      case 'utf-8':
	        return 'utf8';
	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return 'utf16le';
	      case 'latin1':
	      case 'binary':
	        return 'latin1';
	      case 'base64':
	      case 'ascii':
	      case 'hex':
	        return enc;
	      default:
	        if (retried) return; // undefined
	        enc = ('' + enc).toLowerCase();
	        retried = true;
	    }
	  }
	}
	// Do not cache `Buffer.isEncoding` when checking encoding names as some
	// modules monkey-patch it to support additional encodings
	function normalizeEncoding(enc) {
	  var nenc = _normalizeEncoding(enc);
	  if (typeof nenc !== 'string' && (Buffer.isEncoding === isEncoding || !isEncoding(enc))) throw new Error('Unknown encoding: ' + enc);
	  return nenc || enc;
	}

	// StringDecoder provides an interface for efficiently splitting a series of
	// buffers into a series of JS strings without breaking apart multi-byte
	// characters.
	string_decoder$1.StringDecoder = StringDecoder;
	function StringDecoder(encoding) {
	  this.encoding = normalizeEncoding(encoding);
	  var nb;
	  switch (this.encoding) {
	    case 'utf16le':
	      this.text = utf16Text;
	      this.end = utf16End;
	      nb = 4;
	      break;
	    case 'utf8':
	      this.fillLast = utf8FillLast;
	      nb = 4;
	      break;
	    case 'base64':
	      this.text = base64Text;
	      this.end = base64End;
	      nb = 3;
	      break;
	    default:
	      this.write = simpleWrite;
	      this.end = simpleEnd;
	      return;
	  }
	  this.lastNeed = 0;
	  this.lastTotal = 0;
	  this.lastChar = Buffer.allocUnsafe(nb);
	}

	StringDecoder.prototype.write = function (buf) {
	  if (buf.length === 0) return '';
	  var r;
	  var i;
	  if (this.lastNeed) {
	    r = this.fillLast(buf);
	    if (r === undefined) return '';
	    i = this.lastNeed;
	    this.lastNeed = 0;
	  } else {
	    i = 0;
	  }
	  if (i < buf.length) return r ? r + this.text(buf, i) : this.text(buf, i);
	  return r || '';
	};

	StringDecoder.prototype.end = utf8End;

	// Returns only complete characters in a Buffer
	StringDecoder.prototype.text = utf8Text;

	// Attempts to complete a partial non-UTF-8 character using bytes from a Buffer
	StringDecoder.prototype.fillLast = function (buf) {
	  if (this.lastNeed <= buf.length) {
	    buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, this.lastNeed);
	    return this.lastChar.toString(this.encoding, 0, this.lastTotal);
	  }
	  buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, buf.length);
	  this.lastNeed -= buf.length;
	};

	// Checks the type of a UTF-8 byte, whether it's ASCII, a leading byte, or a
	// continuation byte. If an invalid byte is detected, -2 is returned.
	function utf8CheckByte(byte) {
	  if (byte <= 0x7F) return 0;else if (byte >> 5 === 0x06) return 2;else if (byte >> 4 === 0x0E) return 3;else if (byte >> 3 === 0x1E) return 4;
	  return byte >> 6 === 0x02 ? -1 : -2;
	}

	// Checks at most 3 bytes at the end of a Buffer in order to detect an
	// incomplete multi-byte UTF-8 character. The total number of bytes (2, 3, or 4)
	// needed to complete the UTF-8 character (if applicable) are returned.
	function utf8CheckIncomplete(self, buf, i) {
	  var j = buf.length - 1;
	  if (j < i) return 0;
	  var nb = utf8CheckByte(buf[j]);
	  if (nb >= 0) {
	    if (nb > 0) self.lastNeed = nb - 1;
	    return nb;
	  }
	  if (--j < i || nb === -2) return 0;
	  nb = utf8CheckByte(buf[j]);
	  if (nb >= 0) {
	    if (nb > 0) self.lastNeed = nb - 2;
	    return nb;
	  }
	  if (--j < i || nb === -2) return 0;
	  nb = utf8CheckByte(buf[j]);
	  if (nb >= 0) {
	    if (nb > 0) {
	      if (nb === 2) nb = 0;else self.lastNeed = nb - 3;
	    }
	    return nb;
	  }
	  return 0;
	}

	// Validates as many continuation bytes for a multi-byte UTF-8 character as
	// needed or are available. If we see a non-continuation byte where we expect
	// one, we "replace" the validated continuation bytes we've seen so far with
	// a single UTF-8 replacement character ('\ufffd'), to match v8's UTF-8 decoding
	// behavior. The continuation byte check is included three times in the case
	// where all of the continuation bytes for a character exist in the same buffer.
	// It is also done this way as a slight performance increase instead of using a
	// loop.
	function utf8CheckExtraBytes(self, buf, p) {
	  if ((buf[0] & 0xC0) !== 0x80) {
	    self.lastNeed = 0;
	    return '\ufffd';
	  }
	  if (self.lastNeed > 1 && buf.length > 1) {
	    if ((buf[1] & 0xC0) !== 0x80) {
	      self.lastNeed = 1;
	      return '\ufffd';
	    }
	    if (self.lastNeed > 2 && buf.length > 2) {
	      if ((buf[2] & 0xC0) !== 0x80) {
	        self.lastNeed = 2;
	        return '\ufffd';
	      }
	    }
	  }
	}

	// Attempts to complete a multi-byte UTF-8 character using bytes from a Buffer.
	function utf8FillLast(buf) {
	  var p = this.lastTotal - this.lastNeed;
	  var r = utf8CheckExtraBytes(this, buf);
	  if (r !== undefined) return r;
	  if (this.lastNeed <= buf.length) {
	    buf.copy(this.lastChar, p, 0, this.lastNeed);
	    return this.lastChar.toString(this.encoding, 0, this.lastTotal);
	  }
	  buf.copy(this.lastChar, p, 0, buf.length);
	  this.lastNeed -= buf.length;
	}

	// Returns all complete UTF-8 characters in a Buffer. If the Buffer ended on a
	// partial character, the character's bytes are buffered until the required
	// number of bytes are available.
	function utf8Text(buf, i) {
	  var total = utf8CheckIncomplete(this, buf, i);
	  if (!this.lastNeed) return buf.toString('utf8', i);
	  this.lastTotal = total;
	  var end = buf.length - (total - this.lastNeed);
	  buf.copy(this.lastChar, 0, end);
	  return buf.toString('utf8', i, end);
	}

	// For UTF-8, a replacement character is added when ending on a partial
	// character.
	function utf8End(buf) {
	  var r = buf && buf.length ? this.write(buf) : '';
	  if (this.lastNeed) return r + '\ufffd';
	  return r;
	}

	// UTF-16LE typically needs two bytes per character, but even if we have an even
	// number of bytes available, we need to check if we end on a leading/high
	// surrogate. In that case, we need to wait for the next two bytes in order to
	// decode the last character properly.
	function utf16Text(buf, i) {
	  if ((buf.length - i) % 2 === 0) {
	    var r = buf.toString('utf16le', i);
	    if (r) {
	      var c = r.charCodeAt(r.length - 1);
	      if (c >= 0xD800 && c <= 0xDBFF) {
	        this.lastNeed = 2;
	        this.lastTotal = 4;
	        this.lastChar[0] = buf[buf.length - 2];
	        this.lastChar[1] = buf[buf.length - 1];
	        return r.slice(0, -1);
	      }
	    }
	    return r;
	  }
	  this.lastNeed = 1;
	  this.lastTotal = 2;
	  this.lastChar[0] = buf[buf.length - 1];
	  return buf.toString('utf16le', i, buf.length - 1);
	}

	// For UTF-16LE we do not explicitly append special replacement characters if we
	// end on a partial character, we simply let v8 handle that.
	function utf16End(buf) {
	  var r = buf && buf.length ? this.write(buf) : '';
	  if (this.lastNeed) {
	    var end = this.lastTotal - this.lastNeed;
	    return r + this.lastChar.toString('utf16le', 0, end);
	  }
	  return r;
	}

	function base64Text(buf, i) {
	  var n = (buf.length - i) % 3;
	  if (n === 0) return buf.toString('base64', i);
	  this.lastNeed = 3 - n;
	  this.lastTotal = 3;
	  if (n === 1) {
	    this.lastChar[0] = buf[buf.length - 1];
	  } else {
	    this.lastChar[0] = buf[buf.length - 2];
	    this.lastChar[1] = buf[buf.length - 1];
	  }
	  return buf.toString('base64', i, buf.length - n);
	}

	function base64End(buf) {
	  var r = buf && buf.length ? this.write(buf) : '';
	  if (this.lastNeed) return r + this.lastChar.toString('base64', 0, 3 - this.lastNeed);
	  return r;
	}

	// Pass bytes on through for single-byte encodings (e.g. ascii, latin1, hex)
	function simpleWrite(buf) {
	  return buf.toString(this.encoding);
	}

	function simpleEnd(buf) {
	  return buf && buf.length ? this.write(buf) : '';
	}
	return string_decoder$1;
}

var _stream_readable$1;
var hasRequired_stream_readable$1;

function require_stream_readable$1 () {
	if (hasRequired_stream_readable$1) return _stream_readable$1;
	hasRequired_stream_readable$1 = 1;

	/*<replacement>*/

	var pna = requireProcessNextickArgs();
	/*</replacement>*/

	_stream_readable$1 = Readable;

	/*<replacement>*/
	var isArray = requireIsarray$1();
	/*</replacement>*/

	/*<replacement>*/
	var Duplex;
	/*</replacement>*/

	Readable.ReadableState = ReadableState;

	/*<replacement>*/
	require$$0$5.EventEmitter;

	var EElistenerCount = function (emitter, type) {
	  return emitter.listeners(type).length;
	};
	/*</replacement>*/

	/*<replacement>*/
	var Stream = requireStreamBrowser$1();
	/*</replacement>*/

	/*<replacement>*/

	var Buffer = requireSafeBuffer$1().Buffer;
	var OurUint8Array = (typeof commonjsGlobal !== 'undefined' ? commonjsGlobal : typeof window !== 'undefined' ? window : typeof self !== 'undefined' ? self : {}).Uint8Array || function () {};
	function _uint8ArrayToBuffer(chunk) {
	  return Buffer.from(chunk);
	}
	function _isUint8Array(obj) {
	  return Buffer.isBuffer(obj) || obj instanceof OurUint8Array;
	}

	/*</replacement>*/

	/*<replacement>*/
	var util = Object.create(requireUtil$2());
	util.inherits = requireInherits_browser();
	/*</replacement>*/

	/*<replacement>*/
	var debugUtil = require$$0$6;
	var debug = void 0;
	if (debugUtil && debugUtil.debuglog) {
	  debug = debugUtil.debuglog('stream');
	} else {
	  debug = function () {};
	}
	/*</replacement>*/

	var BufferList = requireBufferList();
	var destroyImpl = requireDestroy$1();
	var StringDecoder;

	util.inherits(Readable, Stream);

	var kProxyEvents = ['error', 'close', 'destroy', 'pause', 'resume'];

	function prependListener(emitter, event, fn) {
	  // Sadly this is not cacheable as some libraries bundle their own
	  // event emitter implementation with them.
	  if (typeof emitter.prependListener === 'function') return emitter.prependListener(event, fn);

	  // This is a hack to make sure that our error handler is attached before any
	  // userland ones.  NEVER DO THIS. This is here only because this code needs
	  // to continue to work with older versions of Node.js that do not include
	  // the prependListener() method. The goal is to eventually remove this hack.
	  if (!emitter._events || !emitter._events[event]) emitter.on(event, fn);else if (isArray(emitter._events[event])) emitter._events[event].unshift(fn);else emitter._events[event] = [fn, emitter._events[event]];
	}

	function ReadableState(options, stream) {
	  Duplex = Duplex || require_stream_duplex$1();

	  options = options || {};

	  // Duplex streams are both readable and writable, but share
	  // the same options object.
	  // However, some cases require setting options to different
	  // values for the readable and the writable sides of the duplex stream.
	  // These options can be provided separately as readableXXX and writableXXX.
	  var isDuplex = stream instanceof Duplex;

	  // object stream flag. Used to make read(n) ignore n and to
	  // make all the buffer merging and length checks go away
	  this.objectMode = !!options.objectMode;

	  if (isDuplex) this.objectMode = this.objectMode || !!options.readableObjectMode;

	  // the point at which it stops calling _read() to fill the buffer
	  // Note: 0 is a valid value, means "don't call _read preemptively ever"
	  var hwm = options.highWaterMark;
	  var readableHwm = options.readableHighWaterMark;
	  var defaultHwm = this.objectMode ? 16 : 16 * 1024;

	  if (hwm || hwm === 0) this.highWaterMark = hwm;else if (isDuplex && (readableHwm || readableHwm === 0)) this.highWaterMark = readableHwm;else this.highWaterMark = defaultHwm;

	  // cast to ints.
	  this.highWaterMark = Math.floor(this.highWaterMark);

	  // A linked list is used to store data chunks instead of an array because the
	  // linked list can remove elements from the beginning faster than
	  // array.shift()
	  this.buffer = new BufferList();
	  this.length = 0;
	  this.pipes = null;
	  this.pipesCount = 0;
	  this.flowing = null;
	  this.ended = false;
	  this.endEmitted = false;
	  this.reading = false;

	  // a flag to be able to tell if the event 'readable'/'data' is emitted
	  // immediately, or on a later tick.  We set this to true at first, because
	  // any actions that shouldn't happen until "later" should generally also
	  // not happen before the first read call.
	  this.sync = true;

	  // whenever we return null, then we set a flag to say
	  // that we're awaiting a 'readable' event emission.
	  this.needReadable = false;
	  this.emittedReadable = false;
	  this.readableListening = false;
	  this.resumeScheduled = false;

	  // has it been destroyed
	  this.destroyed = false;

	  // Crypto is kind of old and crusty.  Historically, its default string
	  // encoding is 'binary' so we have to make this configurable.
	  // Everything else in the universe uses 'utf8', though.
	  this.defaultEncoding = options.defaultEncoding || 'utf8';

	  // the number of writers that are awaiting a drain event in .pipe()s
	  this.awaitDrain = 0;

	  // if true, a maybeReadMore has been scheduled
	  this.readingMore = false;

	  this.decoder = null;
	  this.encoding = null;
	  if (options.encoding) {
	    if (!StringDecoder) StringDecoder = requireString_decoder$1().StringDecoder;
	    this.decoder = new StringDecoder(options.encoding);
	    this.encoding = options.encoding;
	  }
	}

	function Readable(options) {
	  Duplex = Duplex || require_stream_duplex$1();

	  if (!(this instanceof Readable)) return new Readable(options);

	  this._readableState = new ReadableState(options, this);

	  // legacy
	  this.readable = true;

	  if (options) {
	    if (typeof options.read === 'function') this._read = options.read;

	    if (typeof options.destroy === 'function') this._destroy = options.destroy;
	  }

	  Stream.call(this);
	}

	Object.defineProperty(Readable.prototype, 'destroyed', {
	  get: function () {
	    if (this._readableState === undefined) {
	      return false;
	    }
	    return this._readableState.destroyed;
	  },
	  set: function (value) {
	    // we ignore the value if the stream
	    // has not been initialized yet
	    if (!this._readableState) {
	      return;
	    }

	    // backward compatibility, the user is explicitly
	    // managing destroyed
	    this._readableState.destroyed = value;
	  }
	});

	Readable.prototype.destroy = destroyImpl.destroy;
	Readable.prototype._undestroy = destroyImpl.undestroy;
	Readable.prototype._destroy = function (err, cb) {
	  this.push(null);
	  cb(err);
	};

	// Manually shove something into the read() buffer.
	// This returns true if the highWaterMark has not been hit yet,
	// similar to how Writable.write() returns true if you should
	// write() some more.
	Readable.prototype.push = function (chunk, encoding) {
	  var state = this._readableState;
	  var skipChunkCheck;

	  if (!state.objectMode) {
	    if (typeof chunk === 'string') {
	      encoding = encoding || state.defaultEncoding;
	      if (encoding !== state.encoding) {
	        chunk = Buffer.from(chunk, encoding);
	        encoding = '';
	      }
	      skipChunkCheck = true;
	    }
	  } else {
	    skipChunkCheck = true;
	  }

	  return readableAddChunk(this, chunk, encoding, false, skipChunkCheck);
	};

	// Unshift should *always* be something directly out of read()
	Readable.prototype.unshift = function (chunk) {
	  return readableAddChunk(this, chunk, null, true, false);
	};

	function readableAddChunk(stream, chunk, encoding, addToFront, skipChunkCheck) {
	  var state = stream._readableState;
	  if (chunk === null) {
	    state.reading = false;
	    onEofChunk(stream, state);
	  } else {
	    var er;
	    if (!skipChunkCheck) er = chunkInvalid(state, chunk);
	    if (er) {
	      stream.emit('error', er);
	    } else if (state.objectMode || chunk && chunk.length > 0) {
	      if (typeof chunk !== 'string' && !state.objectMode && Object.getPrototypeOf(chunk) !== Buffer.prototype) {
	        chunk = _uint8ArrayToBuffer(chunk);
	      }

	      if (addToFront) {
	        if (state.endEmitted) stream.emit('error', new Error('stream.unshift() after end event'));else addChunk(stream, state, chunk, true);
	      } else if (state.ended) {
	        stream.emit('error', new Error('stream.push() after EOF'));
	      } else {
	        state.reading = false;
	        if (state.decoder && !encoding) {
	          chunk = state.decoder.write(chunk);
	          if (state.objectMode || chunk.length !== 0) addChunk(stream, state, chunk, false);else maybeReadMore(stream, state);
	        } else {
	          addChunk(stream, state, chunk, false);
	        }
	      }
	    } else if (!addToFront) {
	      state.reading = false;
	    }
	  }

	  return needMoreData(state);
	}

	function addChunk(stream, state, chunk, addToFront) {
	  if (state.flowing && state.length === 0 && !state.sync) {
	    stream.emit('data', chunk);
	    stream.read(0);
	  } else {
	    // update the buffer info.
	    state.length += state.objectMode ? 1 : chunk.length;
	    if (addToFront) state.buffer.unshift(chunk);else state.buffer.push(chunk);

	    if (state.needReadable) emitReadable(stream);
	  }
	  maybeReadMore(stream, state);
	}

	function chunkInvalid(state, chunk) {
	  var er;
	  if (!_isUint8Array(chunk) && typeof chunk !== 'string' && chunk !== undefined && !state.objectMode) {
	    er = new TypeError('Invalid non-string/buffer chunk');
	  }
	  return er;
	}

	// if it's past the high water mark, we can push in some more.
	// Also, if we have no data yet, we can stand some
	// more bytes.  This is to work around cases where hwm=0,
	// such as the repl.  Also, if the push() triggered a
	// readable event, and the user called read(largeNumber) such that
	// needReadable was set, then we ought to push more, so that another
	// 'readable' event will be triggered.
	function needMoreData(state) {
	  return !state.ended && (state.needReadable || state.length < state.highWaterMark || state.length === 0);
	}

	Readable.prototype.isPaused = function () {
	  return this._readableState.flowing === false;
	};

	// backwards compatibility.
	Readable.prototype.setEncoding = function (enc) {
	  if (!StringDecoder) StringDecoder = requireString_decoder$1().StringDecoder;
	  this._readableState.decoder = new StringDecoder(enc);
	  this._readableState.encoding = enc;
	  return this;
	};

	// Don't raise the hwm > 8MB
	var MAX_HWM = 0x800000;
	function computeNewHighWaterMark(n) {
	  if (n >= MAX_HWM) {
	    n = MAX_HWM;
	  } else {
	    // Get the next highest power of 2 to prevent increasing hwm excessively in
	    // tiny amounts
	    n--;
	    n |= n >>> 1;
	    n |= n >>> 2;
	    n |= n >>> 4;
	    n |= n >>> 8;
	    n |= n >>> 16;
	    n++;
	  }
	  return n;
	}

	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function howMuchToRead(n, state) {
	  if (n <= 0 || state.length === 0 && state.ended) return 0;
	  if (state.objectMode) return 1;
	  if (n !== n) {
	    // Only flow one buffer at a time
	    if (state.flowing && state.length) return state.buffer.head.data.length;else return state.length;
	  }
	  // If we're asking for more than the current hwm, then raise the hwm.
	  if (n > state.highWaterMark) state.highWaterMark = computeNewHighWaterMark(n);
	  if (n <= state.length) return n;
	  // Don't have enough
	  if (!state.ended) {
	    state.needReadable = true;
	    return 0;
	  }
	  return state.length;
	}

	// you can override either this method, or the async _read(n) below.
	Readable.prototype.read = function (n) {
	  debug('read', n);
	  n = parseInt(n, 10);
	  var state = this._readableState;
	  var nOrig = n;

	  if (n !== 0) state.emittedReadable = false;

	  // if we're doing read(0) to trigger a readable event, but we
	  // already have a bunch of data in the buffer, then just trigger
	  // the 'readable' event and move on.
	  if (n === 0 && state.needReadable && (state.length >= state.highWaterMark || state.ended)) {
	    debug('read: emitReadable', state.length, state.ended);
	    if (state.length === 0 && state.ended) endReadable(this);else emitReadable(this);
	    return null;
	  }

	  n = howMuchToRead(n, state);

	  // if we've ended, and we're now clear, then finish it up.
	  if (n === 0 && state.ended) {
	    if (state.length === 0) endReadable(this);
	    return null;
	  }

	  // All the actual chunk generation logic needs to be
	  // *below* the call to _read.  The reason is that in certain
	  // synthetic stream cases, such as passthrough streams, _read
	  // may be a completely synchronous operation which may change
	  // the state of the read buffer, providing enough data when
	  // before there was *not* enough.
	  //
	  // So, the steps are:
	  // 1. Figure out what the state of things will be after we do
	  // a read from the buffer.
	  //
	  // 2. If that resulting state will trigger a _read, then call _read.
	  // Note that this may be asynchronous, or synchronous.  Yes, it is
	  // deeply ugly to write APIs this way, but that still doesn't mean
	  // that the Readable class should behave improperly, as streams are
	  // designed to be sync/async agnostic.
	  // Take note if the _read call is sync or async (ie, if the read call
	  // has returned yet), so that we know whether or not it's safe to emit
	  // 'readable' etc.
	  //
	  // 3. Actually pull the requested chunks out of the buffer and return.

	  // if we need a readable event, then we need to do some reading.
	  var doRead = state.needReadable;
	  debug('need readable', doRead);

	  // if we currently have less than the highWaterMark, then also read some
	  if (state.length === 0 || state.length - n < state.highWaterMark) {
	    doRead = true;
	    debug('length less than watermark', doRead);
	  }

	  // however, if we've ended, then there's no point, and if we're already
	  // reading, then it's unnecessary.
	  if (state.ended || state.reading) {
	    doRead = false;
	    debug('reading or ended', doRead);
	  } else if (doRead) {
	    debug('do read');
	    state.reading = true;
	    state.sync = true;
	    // if the length is currently zero, then we *need* a readable event.
	    if (state.length === 0) state.needReadable = true;
	    // call internal read method
	    this._read(state.highWaterMark);
	    state.sync = false;
	    // If _read pushed data synchronously, then `reading` will be false,
	    // and we need to re-evaluate how much data we can return to the user.
	    if (!state.reading) n = howMuchToRead(nOrig, state);
	  }

	  var ret;
	  if (n > 0) ret = fromList(n, state);else ret = null;

	  if (ret === null) {
	    state.needReadable = true;
	    n = 0;
	  } else {
	    state.length -= n;
	  }

	  if (state.length === 0) {
	    // If we have nothing in the buffer, then we want to know
	    // as soon as we *do* get something into the buffer.
	    if (!state.ended) state.needReadable = true;

	    // If we tried to read() past the EOF, then emit end on the next tick.
	    if (nOrig !== n && state.ended) endReadable(this);
	  }

	  if (ret !== null) this.emit('data', ret);

	  return ret;
	};

	function onEofChunk(stream, state) {
	  if (state.ended) return;
	  if (state.decoder) {
	    var chunk = state.decoder.end();
	    if (chunk && chunk.length) {
	      state.buffer.push(chunk);
	      state.length += state.objectMode ? 1 : chunk.length;
	    }
	  }
	  state.ended = true;

	  // emit 'readable' now to make sure it gets picked up.
	  emitReadable(stream);
	}

	// Don't emit readable right away in sync mode, because this can trigger
	// another read() call => stack overflow.  This way, it might trigger
	// a nextTick recursion warning, but that's not so bad.
	function emitReadable(stream) {
	  var state = stream._readableState;
	  state.needReadable = false;
	  if (!state.emittedReadable) {
	    debug('emitReadable', state.flowing);
	    state.emittedReadable = true;
	    if (state.sync) pna.nextTick(emitReadable_, stream);else emitReadable_(stream);
	  }
	}

	function emitReadable_(stream) {
	  debug('emit readable');
	  stream.emit('readable');
	  flow(stream);
	}

	// at this point, the user has presumably seen the 'readable' event,
	// and called read() to consume some data.  that may have triggered
	// in turn another _read(n) call, in which case reading = true if
	// it's in progress.
	// However, if we're not ended, or reading, and the length < hwm,
	// then go ahead and try to read some more preemptively.
	function maybeReadMore(stream, state) {
	  if (!state.readingMore) {
	    state.readingMore = true;
	    pna.nextTick(maybeReadMore_, stream, state);
	  }
	}

	function maybeReadMore_(stream, state) {
	  var len = state.length;
	  while (!state.reading && !state.flowing && !state.ended && state.length < state.highWaterMark) {
	    debug('maybeReadMore read 0');
	    stream.read(0);
	    if (len === state.length)
	      // didn't get any data, stop spinning.
	      break;else len = state.length;
	  }
	  state.readingMore = false;
	}

	// abstract method.  to be overridden in specific implementation classes.
	// call cb(er, data) where data is <= n in length.
	// for virtual (non-string, non-buffer) streams, "length" is somewhat
	// arbitrary, and perhaps not very meaningful.
	Readable.prototype._read = function (n) {
	  this.emit('error', new Error('_read() is not implemented'));
	};

	Readable.prototype.pipe = function (dest, pipeOpts) {
	  var src = this;
	  var state = this._readableState;

	  switch (state.pipesCount) {
	    case 0:
	      state.pipes = dest;
	      break;
	    case 1:
	      state.pipes = [state.pipes, dest];
	      break;
	    default:
	      state.pipes.push(dest);
	      break;
	  }
	  state.pipesCount += 1;
	  debug('pipe count=%d opts=%j', state.pipesCount, pipeOpts);

	  var doEnd = (!pipeOpts || pipeOpts.end !== false) && dest !== process.stdout && dest !== process.stderr;

	  var endFn = doEnd ? onend : unpipe;
	  if (state.endEmitted) pna.nextTick(endFn);else src.once('end', endFn);

	  dest.on('unpipe', onunpipe);
	  function onunpipe(readable, unpipeInfo) {
	    debug('onunpipe');
	    if (readable === src) {
	      if (unpipeInfo && unpipeInfo.hasUnpiped === false) {
	        unpipeInfo.hasUnpiped = true;
	        cleanup();
	      }
	    }
	  }

	  function onend() {
	    debug('onend');
	    dest.end();
	  }

	  // when the dest drains, it reduces the awaitDrain counter
	  // on the source.  This would be more elegant with a .once()
	  // handler in flow(), but adding and removing repeatedly is
	  // too slow.
	  var ondrain = pipeOnDrain(src);
	  dest.on('drain', ondrain);

	  var cleanedUp = false;
	  function cleanup() {
	    debug('cleanup');
	    // cleanup event handlers once the pipe is broken
	    dest.removeListener('close', onclose);
	    dest.removeListener('finish', onfinish);
	    dest.removeListener('drain', ondrain);
	    dest.removeListener('error', onerror);
	    dest.removeListener('unpipe', onunpipe);
	    src.removeListener('end', onend);
	    src.removeListener('end', unpipe);
	    src.removeListener('data', ondata);

	    cleanedUp = true;

	    // if the reader is waiting for a drain event from this
	    // specific writer, then it would cause it to never start
	    // flowing again.
	    // So, if this is awaiting a drain, then we just call it now.
	    // If we don't know, then assume that we are waiting for one.
	    if (state.awaitDrain && (!dest._writableState || dest._writableState.needDrain)) ondrain();
	  }

	  // If the user pushes more data while we're writing to dest then we'll end up
	  // in ondata again. However, we only want to increase awaitDrain once because
	  // dest will only emit one 'drain' event for the multiple writes.
	  // => Introduce a guard on increasing awaitDrain.
	  var increasedAwaitDrain = false;
	  src.on('data', ondata);
	  function ondata(chunk) {
	    debug('ondata');
	    increasedAwaitDrain = false;
	    var ret = dest.write(chunk);
	    if (false === ret && !increasedAwaitDrain) {
	      // If the user unpiped during `dest.write()`, it is possible
	      // to get stuck in a permanently paused state if that write
	      // also returned false.
	      // => Check whether `dest` is still a piping destination.
	      if ((state.pipesCount === 1 && state.pipes === dest || state.pipesCount > 1 && indexOf(state.pipes, dest) !== -1) && !cleanedUp) {
	        debug('false write response, pause', state.awaitDrain);
	        state.awaitDrain++;
	        increasedAwaitDrain = true;
	      }
	      src.pause();
	    }
	  }

	  // if the dest has an error, then stop piping into it.
	  // however, don't suppress the throwing behavior for this.
	  function onerror(er) {
	    debug('onerror', er);
	    unpipe();
	    dest.removeListener('error', onerror);
	    if (EElistenerCount(dest, 'error') === 0) dest.emit('error', er);
	  }

	  // Make sure our error handler is attached before userland ones.
	  prependListener(dest, 'error', onerror);

	  // Both close and finish should trigger unpipe, but only once.
	  function onclose() {
	    dest.removeListener('finish', onfinish);
	    unpipe();
	  }
	  dest.once('close', onclose);
	  function onfinish() {
	    debug('onfinish');
	    dest.removeListener('close', onclose);
	    unpipe();
	  }
	  dest.once('finish', onfinish);

	  function unpipe() {
	    debug('unpipe');
	    src.unpipe(dest);
	  }

	  // tell the dest that it's being piped to
	  dest.emit('pipe', src);

	  // start the flow if it hasn't been started already.
	  if (!state.flowing) {
	    debug('pipe resume');
	    src.resume();
	  }

	  return dest;
	};

	function pipeOnDrain(src) {
	  return function () {
	    var state = src._readableState;
	    debug('pipeOnDrain', state.awaitDrain);
	    if (state.awaitDrain) state.awaitDrain--;
	    if (state.awaitDrain === 0 && EElistenerCount(src, 'data')) {
	      state.flowing = true;
	      flow(src);
	    }
	  };
	}

	Readable.prototype.unpipe = function (dest) {
	  var state = this._readableState;
	  var unpipeInfo = { hasUnpiped: false };

	  // if we're not piping anywhere, then do nothing.
	  if (state.pipesCount === 0) return this;

	  // just one destination.  most common case.
	  if (state.pipesCount === 1) {
	    // passed in one, but it's not the right one.
	    if (dest && dest !== state.pipes) return this;

	    if (!dest) dest = state.pipes;

	    // got a match.
	    state.pipes = null;
	    state.pipesCount = 0;
	    state.flowing = false;
	    if (dest) dest.emit('unpipe', this, unpipeInfo);
	    return this;
	  }

	  // slow case. multiple pipe destinations.

	  if (!dest) {
	    // remove all.
	    var dests = state.pipes;
	    var len = state.pipesCount;
	    state.pipes = null;
	    state.pipesCount = 0;
	    state.flowing = false;

	    for (var i = 0; i < len; i++) {
	      dests[i].emit('unpipe', this, { hasUnpiped: false });
	    }return this;
	  }

	  // try to find the right one.
	  var index = indexOf(state.pipes, dest);
	  if (index === -1) return this;

	  state.pipes.splice(index, 1);
	  state.pipesCount -= 1;
	  if (state.pipesCount === 1) state.pipes = state.pipes[0];

	  dest.emit('unpipe', this, unpipeInfo);

	  return this;
	};

	// set up data events if they are asked for
	// Ensure readable listeners eventually get something
	Readable.prototype.on = function (ev, fn) {
	  var res = Stream.prototype.on.call(this, ev, fn);

	  if (ev === 'data') {
	    // Start flowing on next tick if stream isn't explicitly paused
	    if (this._readableState.flowing !== false) this.resume();
	  } else if (ev === 'readable') {
	    var state = this._readableState;
	    if (!state.endEmitted && !state.readableListening) {
	      state.readableListening = state.needReadable = true;
	      state.emittedReadable = false;
	      if (!state.reading) {
	        pna.nextTick(nReadingNextTick, this);
	      } else if (state.length) {
	        emitReadable(this);
	      }
	    }
	  }

	  return res;
	};
	Readable.prototype.addListener = Readable.prototype.on;

	function nReadingNextTick(self) {
	  debug('readable nexttick read 0');
	  self.read(0);
	}

	// pause() and resume() are remnants of the legacy readable stream API
	// If the user uses them, then switch into old mode.
	Readable.prototype.resume = function () {
	  var state = this._readableState;
	  if (!state.flowing) {
	    debug('resume');
	    state.flowing = true;
	    resume(this, state);
	  }
	  return this;
	};

	function resume(stream, state) {
	  if (!state.resumeScheduled) {
	    state.resumeScheduled = true;
	    pna.nextTick(resume_, stream, state);
	  }
	}

	function resume_(stream, state) {
	  if (!state.reading) {
	    debug('resume read 0');
	    stream.read(0);
	  }

	  state.resumeScheduled = false;
	  state.awaitDrain = 0;
	  stream.emit('resume');
	  flow(stream);
	  if (state.flowing && !state.reading) stream.read(0);
	}

	Readable.prototype.pause = function () {
	  debug('call pause flowing=%j', this._readableState.flowing);
	  if (false !== this._readableState.flowing) {
	    debug('pause');
	    this._readableState.flowing = false;
	    this.emit('pause');
	  }
	  return this;
	};

	function flow(stream) {
	  var state = stream._readableState;
	  debug('flow', state.flowing);
	  while (state.flowing && stream.read() !== null) {}
	}

	// wrap an old-style stream as the async data source.
	// This is *not* part of the readable stream interface.
	// It is an ugly unfortunate mess of history.
	Readable.prototype.wrap = function (stream) {
	  var _this = this;

	  var state = this._readableState;
	  var paused = false;

	  stream.on('end', function () {
	    debug('wrapped end');
	    if (state.decoder && !state.ended) {
	      var chunk = state.decoder.end();
	      if (chunk && chunk.length) _this.push(chunk);
	    }

	    _this.push(null);
	  });

	  stream.on('data', function (chunk) {
	    debug('wrapped data');
	    if (state.decoder) chunk = state.decoder.write(chunk);

	    // don't skip over falsy values in objectMode
	    if (state.objectMode && (chunk === null || chunk === undefined)) return;else if (!state.objectMode && (!chunk || !chunk.length)) return;

	    var ret = _this.push(chunk);
	    if (!ret) {
	      paused = true;
	      stream.pause();
	    }
	  });

	  // proxy all the other methods.
	  // important when wrapping filters and duplexes.
	  for (var i in stream) {
	    if (this[i] === undefined && typeof stream[i] === 'function') {
	      this[i] = function (method) {
	        return function () {
	          return stream[method].apply(stream, arguments);
	        };
	      }(i);
	    }
	  }

	  // proxy certain important events.
	  for (var n = 0; n < kProxyEvents.length; n++) {
	    stream.on(kProxyEvents[n], this.emit.bind(this, kProxyEvents[n]));
	  }

	  // when we try to consume some more bytes, simply unpause the
	  // underlying stream.
	  this._read = function (n) {
	    debug('wrapped _read', n);
	    if (paused) {
	      paused = false;
	      stream.resume();
	    }
	  };

	  return this;
	};

	Object.defineProperty(Readable.prototype, 'readableHighWaterMark', {
	  // making it explicit this property is not enumerable
	  // because otherwise some prototype manipulation in
	  // userland will fail
	  enumerable: false,
	  get: function () {
	    return this._readableState.highWaterMark;
	  }
	});

	// exposed for testing purposes only.
	Readable._fromList = fromList;

	// Pluck off n bytes from an array of buffers.
	// Length is the combined lengths of all the buffers in the list.
	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function fromList(n, state) {
	  // nothing buffered
	  if (state.length === 0) return null;

	  var ret;
	  if (state.objectMode) ret = state.buffer.shift();else if (!n || n >= state.length) {
	    // read it all, truncate the list
	    if (state.decoder) ret = state.buffer.join('');else if (state.buffer.length === 1) ret = state.buffer.head.data;else ret = state.buffer.concat(state.length);
	    state.buffer.clear();
	  } else {
	    // read part of list
	    ret = fromListPartial(n, state.buffer, state.decoder);
	  }

	  return ret;
	}

	// Extracts only enough buffered data to satisfy the amount requested.
	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function fromListPartial(n, list, hasStrings) {
	  var ret;
	  if (n < list.head.data.length) {
	    // slice is the same for buffers and strings
	    ret = list.head.data.slice(0, n);
	    list.head.data = list.head.data.slice(n);
	  } else if (n === list.head.data.length) {
	    // first chunk is a perfect match
	    ret = list.shift();
	  } else {
	    // result spans more than one buffer
	    ret = hasStrings ? copyFromBufferString(n, list) : copyFromBuffer(n, list);
	  }
	  return ret;
	}

	// Copies a specified amount of characters from the list of buffered data
	// chunks.
	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function copyFromBufferString(n, list) {
	  var p = list.head;
	  var c = 1;
	  var ret = p.data;
	  n -= ret.length;
	  while (p = p.next) {
	    var str = p.data;
	    var nb = n > str.length ? str.length : n;
	    if (nb === str.length) ret += str;else ret += str.slice(0, n);
	    n -= nb;
	    if (n === 0) {
	      if (nb === str.length) {
	        ++c;
	        if (p.next) list.head = p.next;else list.head = list.tail = null;
	      } else {
	        list.head = p;
	        p.data = str.slice(nb);
	      }
	      break;
	    }
	    ++c;
	  }
	  list.length -= c;
	  return ret;
	}

	// Copies a specified amount of bytes from the list of buffered data chunks.
	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function copyFromBuffer(n, list) {
	  var ret = Buffer.allocUnsafe(n);
	  var p = list.head;
	  var c = 1;
	  p.data.copy(ret);
	  n -= p.data.length;
	  while (p = p.next) {
	    var buf = p.data;
	    var nb = n > buf.length ? buf.length : n;
	    buf.copy(ret, ret.length - n, 0, nb);
	    n -= nb;
	    if (n === 0) {
	      if (nb === buf.length) {
	        ++c;
	        if (p.next) list.head = p.next;else list.head = list.tail = null;
	      } else {
	        list.head = p;
	        p.data = buf.slice(nb);
	      }
	      break;
	    }
	    ++c;
	  }
	  list.length -= c;
	  return ret;
	}

	function endReadable(stream) {
	  var state = stream._readableState;

	  // If we get here before consuming all the bytes, then that is a
	  // bug in node.  Should never happen.
	  if (state.length > 0) throw new Error('"endReadable()" called on non-empty stream');

	  if (!state.endEmitted) {
	    state.ended = true;
	    pna.nextTick(endReadableNT, state, stream);
	  }
	}

	function endReadableNT(state, stream) {
	  // Check that we didn't get one last unshift.
	  if (!state.endEmitted && state.length === 0) {
	    state.endEmitted = true;
	    stream.readable = false;
	    stream.emit('end');
	  }
	}

	function indexOf(xs, x) {
	  for (var i = 0, l = xs.length; i < l; i++) {
	    if (xs[i] === x) return i;
	  }
	  return -1;
	}
	return _stream_readable$1;
}

var browser$4;
var hasRequiredBrowser$4;

function requireBrowser$4 () {
	if (hasRequiredBrowser$4) return browser$4;
	hasRequiredBrowser$4 = 1;
	/**
	 * Module exports.
	 */

	browser$4 = deprecate;

	/**
	 * Mark that a method should not be used.
	 * Returns a modified function which warns once by default.
	 *
	 * If `localStorage.noDeprecation = true` is set, then it is a no-op.
	 *
	 * If `localStorage.throwDeprecation = true` is set, then deprecated functions
	 * will throw an Error when invoked.
	 *
	 * If `localStorage.traceDeprecation = true` is set, then deprecated functions
	 * will invoke `console.trace()` instead of `console.error()`.
	 *
	 * @param {Function} fn - the function to deprecate
	 * @param {String} msg - the string to print to the console when `fn` is invoked
	 * @returns {Function} a new "deprecated" version of `fn`
	 * @api public
	 */

	function deprecate (fn, msg) {
	  if (config('noDeprecation')) {
	    return fn;
	  }

	  var warned = false;
	  function deprecated() {
	    if (!warned) {
	      if (config('throwDeprecation')) {
	        throw new Error(msg);
	      } else if (config('traceDeprecation')) {
	        console.trace(msg);
	      } else {
	        console.warn(msg);
	      }
	      warned = true;
	    }
	    return fn.apply(this, arguments);
	  }

	  return deprecated;
	}

	/**
	 * Checks `localStorage` for boolean values for the given `name`.
	 *
	 * @param {String} name
	 * @returns {Boolean}
	 * @api private
	 */

	function config (name) {
	  // accessing global.localStorage can trigger a DOMException in sandboxed iframes
	  try {
	    if (!commonjsGlobal.localStorage) return false;
	  } catch (_) {
	    return false;
	  }
	  var val = commonjsGlobal.localStorage[name];
	  if (null == val) return false;
	  return String(val).toLowerCase() === 'true';
	}
	return browser$4;
}

var _stream_writable$1;
var hasRequired_stream_writable$1;

function require_stream_writable$1 () {
	if (hasRequired_stream_writable$1) return _stream_writable$1;
	hasRequired_stream_writable$1 = 1;

	/*<replacement>*/

	var pna = requireProcessNextickArgs();
	/*</replacement>*/

	_stream_writable$1 = Writable;

	// It seems a linked list but it is not
	// there will be only 2 of these for each stream
	function CorkedRequest(state) {
	  var _this = this;

	  this.next = null;
	  this.entry = null;
	  this.finish = function () {
	    onCorkedFinish(_this, state);
	  };
	}
	/* </replacement> */

	/*<replacement>*/
	var asyncWrite = !process.browser && ['v0.10', 'v0.9.'].indexOf(process.version.slice(0, 5)) > -1 ? setImmediate : pna.nextTick;
	/*</replacement>*/

	/*<replacement>*/
	var Duplex;
	/*</replacement>*/

	Writable.WritableState = WritableState;

	/*<replacement>*/
	var util = Object.create(requireUtil$2());
	util.inherits = requireInherits_browser();
	/*</replacement>*/

	/*<replacement>*/
	var internalUtil = {
	  deprecate: requireBrowser$4()
	};
	/*</replacement>*/

	/*<replacement>*/
	var Stream = requireStreamBrowser$1();
	/*</replacement>*/

	/*<replacement>*/

	var Buffer = requireSafeBuffer$1().Buffer;
	var OurUint8Array = (typeof commonjsGlobal !== 'undefined' ? commonjsGlobal : typeof window !== 'undefined' ? window : typeof self !== 'undefined' ? self : {}).Uint8Array || function () {};
	function _uint8ArrayToBuffer(chunk) {
	  return Buffer.from(chunk);
	}
	function _isUint8Array(obj) {
	  return Buffer.isBuffer(obj) || obj instanceof OurUint8Array;
	}

	/*</replacement>*/

	var destroyImpl = requireDestroy$1();

	util.inherits(Writable, Stream);

	function nop() {}

	function WritableState(options, stream) {
	  Duplex = Duplex || require_stream_duplex$1();

	  options = options || {};

	  // Duplex streams are both readable and writable, but share
	  // the same options object.
	  // However, some cases require setting options to different
	  // values for the readable and the writable sides of the duplex stream.
	  // These options can be provided separately as readableXXX and writableXXX.
	  var isDuplex = stream instanceof Duplex;

	  // object stream flag to indicate whether or not this stream
	  // contains buffers or objects.
	  this.objectMode = !!options.objectMode;

	  if (isDuplex) this.objectMode = this.objectMode || !!options.writableObjectMode;

	  // the point at which write() starts returning false
	  // Note: 0 is a valid value, means that we always return false if
	  // the entire buffer is not flushed immediately on write()
	  var hwm = options.highWaterMark;
	  var writableHwm = options.writableHighWaterMark;
	  var defaultHwm = this.objectMode ? 16 : 16 * 1024;

	  if (hwm || hwm === 0) this.highWaterMark = hwm;else if (isDuplex && (writableHwm || writableHwm === 0)) this.highWaterMark = writableHwm;else this.highWaterMark = defaultHwm;

	  // cast to ints.
	  this.highWaterMark = Math.floor(this.highWaterMark);

	  // if _final has been called
	  this.finalCalled = false;

	  // drain event flag.
	  this.needDrain = false;
	  // at the start of calling end()
	  this.ending = false;
	  // when end() has been called, and returned
	  this.ended = false;
	  // when 'finish' is emitted
	  this.finished = false;

	  // has it been destroyed
	  this.destroyed = false;

	  // should we decode strings into buffers before passing to _write?
	  // this is here so that some node-core streams can optimize string
	  // handling at a lower level.
	  var noDecode = options.decodeStrings === false;
	  this.decodeStrings = !noDecode;

	  // Crypto is kind of old and crusty.  Historically, its default string
	  // encoding is 'binary' so we have to make this configurable.
	  // Everything else in the universe uses 'utf8', though.
	  this.defaultEncoding = options.defaultEncoding || 'utf8';

	  // not an actual buffer we keep track of, but a measurement
	  // of how much we're waiting to get pushed to some underlying
	  // socket or file.
	  this.length = 0;

	  // a flag to see when we're in the middle of a write.
	  this.writing = false;

	  // when true all writes will be buffered until .uncork() call
	  this.corked = 0;

	  // a flag to be able to tell if the onwrite cb is called immediately,
	  // or on a later tick.  We set this to true at first, because any
	  // actions that shouldn't happen until "later" should generally also
	  // not happen before the first write call.
	  this.sync = true;

	  // a flag to know if we're processing previously buffered items, which
	  // may call the _write() callback in the same tick, so that we don't
	  // end up in an overlapped onwrite situation.
	  this.bufferProcessing = false;

	  // the callback that's passed to _write(chunk,cb)
	  this.onwrite = function (er) {
	    onwrite(stream, er);
	  };

	  // the callback that the user supplies to write(chunk,encoding,cb)
	  this.writecb = null;

	  // the amount that is being written when _write is called.
	  this.writelen = 0;

	  this.bufferedRequest = null;
	  this.lastBufferedRequest = null;

	  // number of pending user-supplied write callbacks
	  // this must be 0 before 'finish' can be emitted
	  this.pendingcb = 0;

	  // emit prefinish if the only thing we're waiting for is _write cbs
	  // This is relevant for synchronous Transform streams
	  this.prefinished = false;

	  // True if the error was already emitted and should not be thrown again
	  this.errorEmitted = false;

	  // count buffered requests
	  this.bufferedRequestCount = 0;

	  // allocate the first CorkedRequest, there is always
	  // one allocated and free to use, and we maintain at most two
	  this.corkedRequestsFree = new CorkedRequest(this);
	}

	WritableState.prototype.getBuffer = function getBuffer() {
	  var current = this.bufferedRequest;
	  var out = [];
	  while (current) {
	    out.push(current);
	    current = current.next;
	  }
	  return out;
	};

	(function () {
	  try {
	    Object.defineProperty(WritableState.prototype, 'buffer', {
	      get: internalUtil.deprecate(function () {
	        return this.getBuffer();
	      }, '_writableState.buffer is deprecated. Use _writableState.getBuffer ' + 'instead.', 'DEP0003')
	    });
	  } catch (_) {}
	})();

	// Test _writableState for inheritance to account for Duplex streams,
	// whose prototype chain only points to Readable.
	var realHasInstance;
	if (typeof Symbol === 'function' && Symbol.hasInstance && typeof Function.prototype[Symbol.hasInstance] === 'function') {
	  realHasInstance = Function.prototype[Symbol.hasInstance];
	  Object.defineProperty(Writable, Symbol.hasInstance, {
	    value: function (object) {
	      if (realHasInstance.call(this, object)) return true;
	      if (this !== Writable) return false;

	      return object && object._writableState instanceof WritableState;
	    }
	  });
	} else {
	  realHasInstance = function (object) {
	    return object instanceof this;
	  };
	}

	function Writable(options) {
	  Duplex = Duplex || require_stream_duplex$1();

	  // Writable ctor is applied to Duplexes, too.
	  // `realHasInstance` is necessary because using plain `instanceof`
	  // would return false, as no `_writableState` property is attached.

	  // Trying to use the custom `instanceof` for Writable here will also break the
	  // Node.js LazyTransform implementation, which has a non-trivial getter for
	  // `_writableState` that would lead to infinite recursion.
	  if (!realHasInstance.call(Writable, this) && !(this instanceof Duplex)) {
	    return new Writable(options);
	  }

	  this._writableState = new WritableState(options, this);

	  // legacy.
	  this.writable = true;

	  if (options) {
	    if (typeof options.write === 'function') this._write = options.write;

	    if (typeof options.writev === 'function') this._writev = options.writev;

	    if (typeof options.destroy === 'function') this._destroy = options.destroy;

	    if (typeof options.final === 'function') this._final = options.final;
	  }

	  Stream.call(this);
	}

	// Otherwise people can pipe Writable streams, which is just wrong.
	Writable.prototype.pipe = function () {
	  this.emit('error', new Error('Cannot pipe, not readable'));
	};

	function writeAfterEnd(stream, cb) {
	  var er = new Error('write after end');
	  // TODO: defer error events consistently everywhere, not just the cb
	  stream.emit('error', er);
	  pna.nextTick(cb, er);
	}

	// Checks that a user-supplied chunk is valid, especially for the particular
	// mode the stream is in. Currently this means that `null` is never accepted
	// and undefined/non-string values are only allowed in object mode.
	function validChunk(stream, state, chunk, cb) {
	  var valid = true;
	  var er = false;

	  if (chunk === null) {
	    er = new TypeError('May not write null values to stream');
	  } else if (typeof chunk !== 'string' && chunk !== undefined && !state.objectMode) {
	    er = new TypeError('Invalid non-string/buffer chunk');
	  }
	  if (er) {
	    stream.emit('error', er);
	    pna.nextTick(cb, er);
	    valid = false;
	  }
	  return valid;
	}

	Writable.prototype.write = function (chunk, encoding, cb) {
	  var state = this._writableState;
	  var ret = false;
	  var isBuf = !state.objectMode && _isUint8Array(chunk);

	  if (isBuf && !Buffer.isBuffer(chunk)) {
	    chunk = _uint8ArrayToBuffer(chunk);
	  }

	  if (typeof encoding === 'function') {
	    cb = encoding;
	    encoding = null;
	  }

	  if (isBuf) encoding = 'buffer';else if (!encoding) encoding = state.defaultEncoding;

	  if (typeof cb !== 'function') cb = nop;

	  if (state.ended) writeAfterEnd(this, cb);else if (isBuf || validChunk(this, state, chunk, cb)) {
	    state.pendingcb++;
	    ret = writeOrBuffer(this, state, isBuf, chunk, encoding, cb);
	  }

	  return ret;
	};

	Writable.prototype.cork = function () {
	  var state = this._writableState;

	  state.corked++;
	};

	Writable.prototype.uncork = function () {
	  var state = this._writableState;

	  if (state.corked) {
	    state.corked--;

	    if (!state.writing && !state.corked && !state.bufferProcessing && state.bufferedRequest) clearBuffer(this, state);
	  }
	};

	Writable.prototype.setDefaultEncoding = function setDefaultEncoding(encoding) {
	  // node::ParseEncoding() requires lower case.
	  if (typeof encoding === 'string') encoding = encoding.toLowerCase();
	  if (!(['hex', 'utf8', 'utf-8', 'ascii', 'binary', 'base64', 'ucs2', 'ucs-2', 'utf16le', 'utf-16le', 'raw'].indexOf((encoding + '').toLowerCase()) > -1)) throw new TypeError('Unknown encoding: ' + encoding);
	  this._writableState.defaultEncoding = encoding;
	  return this;
	};

	function decodeChunk(state, chunk, encoding) {
	  if (!state.objectMode && state.decodeStrings !== false && typeof chunk === 'string') {
	    chunk = Buffer.from(chunk, encoding);
	  }
	  return chunk;
	}

	Object.defineProperty(Writable.prototype, 'writableHighWaterMark', {
	  // making it explicit this property is not enumerable
	  // because otherwise some prototype manipulation in
	  // userland will fail
	  enumerable: false,
	  get: function () {
	    return this._writableState.highWaterMark;
	  }
	});

	// if we're already writing something, then just put this
	// in the queue, and wait our turn.  Otherwise, call _write
	// If we return false, then we need a drain event, so set that flag.
	function writeOrBuffer(stream, state, isBuf, chunk, encoding, cb) {
	  if (!isBuf) {
	    var newChunk = decodeChunk(state, chunk, encoding);
	    if (chunk !== newChunk) {
	      isBuf = true;
	      encoding = 'buffer';
	      chunk = newChunk;
	    }
	  }
	  var len = state.objectMode ? 1 : chunk.length;

	  state.length += len;

	  var ret = state.length < state.highWaterMark;
	  // we must ensure that previous needDrain will not be reset to false.
	  if (!ret) state.needDrain = true;

	  if (state.writing || state.corked) {
	    var last = state.lastBufferedRequest;
	    state.lastBufferedRequest = {
	      chunk: chunk,
	      encoding: encoding,
	      isBuf: isBuf,
	      callback: cb,
	      next: null
	    };
	    if (last) {
	      last.next = state.lastBufferedRequest;
	    } else {
	      state.bufferedRequest = state.lastBufferedRequest;
	    }
	    state.bufferedRequestCount += 1;
	  } else {
	    doWrite(stream, state, false, len, chunk, encoding, cb);
	  }

	  return ret;
	}

	function doWrite(stream, state, writev, len, chunk, encoding, cb) {
	  state.writelen = len;
	  state.writecb = cb;
	  state.writing = true;
	  state.sync = true;
	  if (writev) stream._writev(chunk, state.onwrite);else stream._write(chunk, encoding, state.onwrite);
	  state.sync = false;
	}

	function onwriteError(stream, state, sync, er, cb) {
	  --state.pendingcb;

	  if (sync) {
	    // defer the callback if we are being called synchronously
	    // to avoid piling up things on the stack
	    pna.nextTick(cb, er);
	    // this can emit finish, and it will always happen
	    // after error
	    pna.nextTick(finishMaybe, stream, state);
	    stream._writableState.errorEmitted = true;
	    stream.emit('error', er);
	  } else {
	    // the caller expect this to happen before if
	    // it is async
	    cb(er);
	    stream._writableState.errorEmitted = true;
	    stream.emit('error', er);
	    // this can emit finish, but finish must
	    // always follow error
	    finishMaybe(stream, state);
	  }
	}

	function onwriteStateUpdate(state) {
	  state.writing = false;
	  state.writecb = null;
	  state.length -= state.writelen;
	  state.writelen = 0;
	}

	function onwrite(stream, er) {
	  var state = stream._writableState;
	  var sync = state.sync;
	  var cb = state.writecb;

	  onwriteStateUpdate(state);

	  if (er) onwriteError(stream, state, sync, er, cb);else {
	    // Check if we're actually ready to finish, but don't emit yet
	    var finished = needFinish(state);

	    if (!finished && !state.corked && !state.bufferProcessing && state.bufferedRequest) {
	      clearBuffer(stream, state);
	    }

	    if (sync) {
	      /*<replacement>*/
	      asyncWrite(afterWrite, stream, state, finished, cb);
	      /*</replacement>*/
	    } else {
	      afterWrite(stream, state, finished, cb);
	    }
	  }
	}

	function afterWrite(stream, state, finished, cb) {
	  if (!finished) onwriteDrain(stream, state);
	  state.pendingcb--;
	  cb();
	  finishMaybe(stream, state);
	}

	// Must force callback to be called on nextTick, so that we don't
	// emit 'drain' before the write() consumer gets the 'false' return
	// value, and has a chance to attach a 'drain' listener.
	function onwriteDrain(stream, state) {
	  if (state.length === 0 && state.needDrain) {
	    state.needDrain = false;
	    stream.emit('drain');
	  }
	}

	// if there's something in the buffer waiting, then process it
	function clearBuffer(stream, state) {
	  state.bufferProcessing = true;
	  var entry = state.bufferedRequest;

	  if (stream._writev && entry && entry.next) {
	    // Fast case, write everything using _writev()
	    var l = state.bufferedRequestCount;
	    var buffer = new Array(l);
	    var holder = state.corkedRequestsFree;
	    holder.entry = entry;

	    var count = 0;
	    var allBuffers = true;
	    while (entry) {
	      buffer[count] = entry;
	      if (!entry.isBuf) allBuffers = false;
	      entry = entry.next;
	      count += 1;
	    }
	    buffer.allBuffers = allBuffers;

	    doWrite(stream, state, true, state.length, buffer, '', holder.finish);

	    // doWrite is almost always async, defer these to save a bit of time
	    // as the hot path ends with doWrite
	    state.pendingcb++;
	    state.lastBufferedRequest = null;
	    if (holder.next) {
	      state.corkedRequestsFree = holder.next;
	      holder.next = null;
	    } else {
	      state.corkedRequestsFree = new CorkedRequest(state);
	    }
	    state.bufferedRequestCount = 0;
	  } else {
	    // Slow case, write chunks one-by-one
	    while (entry) {
	      var chunk = entry.chunk;
	      var encoding = entry.encoding;
	      var cb = entry.callback;
	      var len = state.objectMode ? 1 : chunk.length;

	      doWrite(stream, state, false, len, chunk, encoding, cb);
	      entry = entry.next;
	      state.bufferedRequestCount--;
	      // if we didn't call the onwrite immediately, then
	      // it means that we need to wait until it does.
	      // also, that means that the chunk and cb are currently
	      // being processed, so move the buffer counter past them.
	      if (state.writing) {
	        break;
	      }
	    }

	    if (entry === null) state.lastBufferedRequest = null;
	  }

	  state.bufferedRequest = entry;
	  state.bufferProcessing = false;
	}

	Writable.prototype._write = function (chunk, encoding, cb) {
	  cb(new Error('_write() is not implemented'));
	};

	Writable.prototype._writev = null;

	Writable.prototype.end = function (chunk, encoding, cb) {
	  var state = this._writableState;

	  if (typeof chunk === 'function') {
	    cb = chunk;
	    chunk = null;
	    encoding = null;
	  } else if (typeof encoding === 'function') {
	    cb = encoding;
	    encoding = null;
	  }

	  if (chunk !== null && chunk !== undefined) this.write(chunk, encoding);

	  // .end() fully uncorks
	  if (state.corked) {
	    state.corked = 1;
	    this.uncork();
	  }

	  // ignore unnecessary end() calls.
	  if (!state.ending) endWritable(this, state, cb);
	};

	function needFinish(state) {
	  return state.ending && state.length === 0 && state.bufferedRequest === null && !state.finished && !state.writing;
	}
	function callFinal(stream, state) {
	  stream._final(function (err) {
	    state.pendingcb--;
	    if (err) {
	      stream.emit('error', err);
	    }
	    state.prefinished = true;
	    stream.emit('prefinish');
	    finishMaybe(stream, state);
	  });
	}
	function prefinish(stream, state) {
	  if (!state.prefinished && !state.finalCalled) {
	    if (typeof stream._final === 'function') {
	      state.pendingcb++;
	      state.finalCalled = true;
	      pna.nextTick(callFinal, stream, state);
	    } else {
	      state.prefinished = true;
	      stream.emit('prefinish');
	    }
	  }
	}

	function finishMaybe(stream, state) {
	  var need = needFinish(state);
	  if (need) {
	    prefinish(stream, state);
	    if (state.pendingcb === 0) {
	      state.finished = true;
	      stream.emit('finish');
	    }
	  }
	  return need;
	}

	function endWritable(stream, state, cb) {
	  state.ending = true;
	  finishMaybe(stream, state);
	  if (cb) {
	    if (state.finished) pna.nextTick(cb);else stream.once('finish', cb);
	  }
	  state.ended = true;
	  stream.writable = false;
	}

	function onCorkedFinish(corkReq, state, err) {
	  var entry = corkReq.entry;
	  corkReq.entry = null;
	  while (entry) {
	    var cb = entry.callback;
	    state.pendingcb--;
	    cb(err);
	    entry = entry.next;
	  }

	  // reuse the free corkReq.
	  state.corkedRequestsFree.next = corkReq;
	}

	Object.defineProperty(Writable.prototype, 'destroyed', {
	  get: function () {
	    if (this._writableState === undefined) {
	      return false;
	    }
	    return this._writableState.destroyed;
	  },
	  set: function (value) {
	    // we ignore the value if the stream
	    // has not been initialized yet
	    if (!this._writableState) {
	      return;
	    }

	    // backward compatibility, the user is explicitly
	    // managing destroyed
	    this._writableState.destroyed = value;
	  }
	});

	Writable.prototype.destroy = destroyImpl.destroy;
	Writable.prototype._undestroy = destroyImpl.undestroy;
	Writable.prototype._destroy = function (err, cb) {
	  this.end();
	  cb(err);
	};
	return _stream_writable$1;
}

var _stream_duplex$1;
var hasRequired_stream_duplex$1;

function require_stream_duplex$1 () {
	if (hasRequired_stream_duplex$1) return _stream_duplex$1;
	hasRequired_stream_duplex$1 = 1;

	/*<replacement>*/

	var pna = requireProcessNextickArgs();
	/*</replacement>*/

	/*<replacement>*/
	var objectKeys = Object.keys || function (obj) {
	  var keys = [];
	  for (var key in obj) {
	    keys.push(key);
	  }return keys;
	};
	/*</replacement>*/

	_stream_duplex$1 = Duplex;

	/*<replacement>*/
	var util = Object.create(requireUtil$2());
	util.inherits = requireInherits_browser();
	/*</replacement>*/

	var Readable = require_stream_readable$1();
	var Writable = require_stream_writable$1();

	util.inherits(Duplex, Readable);

	{
	  // avoid scope creep, the keys array can then be collected
	  var keys = objectKeys(Writable.prototype);
	  for (var v = 0; v < keys.length; v++) {
	    var method = keys[v];
	    if (!Duplex.prototype[method]) Duplex.prototype[method] = Writable.prototype[method];
	  }
	}

	function Duplex(options) {
	  if (!(this instanceof Duplex)) return new Duplex(options);

	  Readable.call(this, options);
	  Writable.call(this, options);

	  if (options && options.readable === false) this.readable = false;

	  if (options && options.writable === false) this.writable = false;

	  this.allowHalfOpen = true;
	  if (options && options.allowHalfOpen === false) this.allowHalfOpen = false;

	  this.once('end', onend);
	}

	Object.defineProperty(Duplex.prototype, 'writableHighWaterMark', {
	  // making it explicit this property is not enumerable
	  // because otherwise some prototype manipulation in
	  // userland will fail
	  enumerable: false,
	  get: function () {
	    return this._writableState.highWaterMark;
	  }
	});

	// the no-half-open enforcer
	function onend() {
	  // if we allow half-open state, or if the writable side ended,
	  // then we're ok.
	  if (this.allowHalfOpen || this._writableState.ended) return;

	  // no more data can be written.
	  // But allow more writes to happen in this tick.
	  pna.nextTick(onEndNT, this);
	}

	function onEndNT(self) {
	  self.end();
	}

	Object.defineProperty(Duplex.prototype, 'destroyed', {
	  get: function () {
	    if (this._readableState === undefined || this._writableState === undefined) {
	      return false;
	    }
	    return this._readableState.destroyed && this._writableState.destroyed;
	  },
	  set: function (value) {
	    // we ignore the value if the stream
	    // has not been initialized yet
	    if (this._readableState === undefined || this._writableState === undefined) {
	      return;
	    }

	    // backward compatibility, the user is explicitly
	    // managing destroyed
	    this._readableState.destroyed = value;
	    this._writableState.destroyed = value;
	  }
	});

	Duplex.prototype._destroy = function (err, cb) {
	  this.push(null);
	  this.end();

	  pna.nextTick(cb, err);
	};
	return _stream_duplex$1;
}

var duplexBrowser;
var hasRequiredDuplexBrowser;

function requireDuplexBrowser () {
	if (hasRequiredDuplexBrowser) return duplexBrowser;
	hasRequiredDuplexBrowser = 1;
	duplexBrowser = require_stream_duplex$1();
	return duplexBrowser;
}

var safeBuffer = {exports: {}};

/*! safe-buffer. MIT License. Feross Aboukhadijeh <https://feross.org/opensource> */

var hasRequiredSafeBuffer;

function requireSafeBuffer () {
	if (hasRequiredSafeBuffer) return safeBuffer.exports;
	hasRequiredSafeBuffer = 1;
	(function (module, exports$1) {
		/* eslint-disable node/no-deprecated-api */
		var buffer = require$$0$4;
		var Buffer = buffer.Buffer;

		// alternative to using Object.keys for old browsers
		function copyProps (src, dst) {
		  for (var key in src) {
		    dst[key] = src[key];
		  }
		}
		if (Buffer.from && Buffer.alloc && Buffer.allocUnsafe && Buffer.allocUnsafeSlow) {
		  module.exports = buffer;
		} else {
		  // Copy properties from require('buffer')
		  copyProps(buffer, exports$1);
		  exports$1.Buffer = SafeBuffer;
		}

		function SafeBuffer (arg, encodingOrOffset, length) {
		  return Buffer(arg, encodingOrOffset, length)
		}

		SafeBuffer.prototype = Object.create(Buffer.prototype);

		// Copy static methods from Buffer
		copyProps(Buffer, SafeBuffer);

		SafeBuffer.from = function (arg, encodingOrOffset, length) {
		  if (typeof arg === 'number') {
		    throw new TypeError('Argument must not be a number')
		  }
		  return Buffer(arg, encodingOrOffset, length)
		};

		SafeBuffer.alloc = function (size, fill, encoding) {
		  if (typeof size !== 'number') {
		    throw new TypeError('Argument must be a number')
		  }
		  var buf = Buffer(size);
		  if (fill !== undefined) {
		    if (typeof encoding === 'string') {
		      buf.fill(fill, encoding);
		    } else {
		      buf.fill(fill);
		    }
		  } else {
		    buf.fill(0);
		  }
		  return buf
		};

		SafeBuffer.allocUnsafe = function (size) {
		  if (typeof size !== 'number') {
		    throw new TypeError('Argument must be a number')
		  }
		  return Buffer(size)
		};

		SafeBuffer.allocUnsafeSlow = function (size) {
		  if (typeof size !== 'number') {
		    throw new TypeError('Argument must be a number')
		  }
		  return buffer.SlowBuffer(size)
		}; 
	} (safeBuffer, safeBuffer.exports));
	return safeBuffer.exports;
}

var bl;
var hasRequiredBl;

function requireBl () {
	if (hasRequiredBl) return bl;
	hasRequiredBl = 1;
	var DuplexStream = requireDuplexBrowser()
	  , util         = require$$0$6
	  , Buffer       = requireSafeBuffer().Buffer;


	function BufferList (callback) {
	  if (!(this instanceof BufferList))
	    return new BufferList(callback)

	  this._bufs  = [];
	  this.length = 0;

	  if (typeof callback == 'function') {
	    this._callback = callback;

	    var piper = function piper (err) {
	      if (this._callback) {
	        this._callback(err);
	        this._callback = null;
	      }
	    }.bind(this);

	    this.on('pipe', function onPipe (src) {
	      src.on('error', piper);
	    });
	    this.on('unpipe', function onUnpipe (src) {
	      src.removeListener('error', piper);
	    });
	  } else {
	    this.append(callback);
	  }

	  DuplexStream.call(this);
	}


	util.inherits(BufferList, DuplexStream);


	BufferList.prototype._offset = function _offset (offset) {
	  var tot = 0, i = 0, _t;
	  if (offset === 0) return [ 0, 0 ]
	  for (; i < this._bufs.length; i++) {
	    _t = tot + this._bufs[i].length;
	    if (offset < _t || i == this._bufs.length - 1)
	      return [ i, offset - tot ]
	    tot = _t;
	  }
	};


	BufferList.prototype.append = function append (buf) {
	  var i = 0;

	  if (Buffer.isBuffer(buf)) {
	    this._appendBuffer(buf);
	  } else if (Array.isArray(buf)) {
	    for (; i < buf.length; i++)
	      this.append(buf[i]);
	  } else if (buf instanceof BufferList) {
	    // unwrap argument into individual BufferLists
	    for (; i < buf._bufs.length; i++)
	      this.append(buf._bufs[i]);
	  } else if (buf != null) {
	    // coerce number arguments to strings, since Buffer(number) does
	    // uninitialized memory allocation
	    if (typeof buf == 'number')
	      buf = buf.toString();

	    this._appendBuffer(Buffer.from(buf));
	  }

	  return this
	};


	BufferList.prototype._appendBuffer = function appendBuffer (buf) {
	  this._bufs.push(buf);
	  this.length += buf.length;
	};


	BufferList.prototype._write = function _write (buf, encoding, callback) {
	  this._appendBuffer(buf);

	  if (typeof callback == 'function')
	    callback();
	};


	BufferList.prototype._read = function _read (size) {
	  if (!this.length)
	    return this.push(null)

	  size = Math.min(size, this.length);
	  this.push(this.slice(0, size));
	  this.consume(size);
	};


	BufferList.prototype.end = function end (chunk) {
	  DuplexStream.prototype.end.call(this, chunk);

	  if (this._callback) {
	    this._callback(null, this.slice());
	    this._callback = null;
	  }
	};


	BufferList.prototype.get = function get (index) {
	  return this.slice(index, index + 1)[0]
	};


	BufferList.prototype.slice = function slice (start, end) {
	  if (typeof start == 'number' && start < 0)
	    start += this.length;
	  if (typeof end == 'number' && end < 0)
	    end += this.length;
	  return this.copy(null, 0, start, end)
	};


	BufferList.prototype.copy = function copy (dst, dstStart, srcStart, srcEnd) {
	  if (typeof srcStart != 'number' || srcStart < 0)
	    srcStart = 0;
	  if (typeof srcEnd != 'number' || srcEnd > this.length)
	    srcEnd = this.length;
	  if (srcStart >= this.length)
	    return dst || Buffer.alloc(0)
	  if (srcEnd <= 0)
	    return dst || Buffer.alloc(0)

	  var copy   = !!dst
	    , off    = this._offset(srcStart)
	    , len    = srcEnd - srcStart
	    , bytes  = len
	    , bufoff = (copy && dstStart) || 0
	    , start  = off[1]
	    , l
	    , i;

	  // copy/slice everything
	  if (srcStart === 0 && srcEnd == this.length) {
	    if (!copy) { // slice, but full concat if multiple buffers
	      return this._bufs.length === 1
	        ? this._bufs[0]
	        : Buffer.concat(this._bufs, this.length)
	    }

	    // copy, need to copy individual buffers
	    for (i = 0; i < this._bufs.length; i++) {
	      this._bufs[i].copy(dst, bufoff);
	      bufoff += this._bufs[i].length;
	    }

	    return dst
	  }

	  // easy, cheap case where it's a subset of one of the buffers
	  if (bytes <= this._bufs[off[0]].length - start) {
	    return copy
	      ? this._bufs[off[0]].copy(dst, dstStart, start, start + bytes)
	      : this._bufs[off[0]].slice(start, start + bytes)
	  }

	  if (!copy) // a slice, we need something to copy in to
	    dst = Buffer.allocUnsafe(len);

	  for (i = off[0]; i < this._bufs.length; i++) {
	    l = this._bufs[i].length - start;

	    if (bytes > l) {
	      this._bufs[i].copy(dst, bufoff, start);
	      bufoff += l;
	    } else {
	      this._bufs[i].copy(dst, bufoff, start, start + bytes);
	      bufoff += l;
	      break
	    }

	    bytes -= l;

	    if (start)
	      start = 0;
	  }

	  // safeguard so that we don't return uninitialized memory
	  if (dst.length > bufoff) return dst.slice(0, bufoff)

	  return dst
	};

	BufferList.prototype.shallowSlice = function shallowSlice (start, end) {
	  start = start || 0;
	  end = end || this.length;

	  if (start < 0)
	    start += this.length;
	  if (end < 0)
	    end += this.length;

	  var startOffset = this._offset(start)
	    , endOffset = this._offset(end)
	    , buffers = this._bufs.slice(startOffset[0], endOffset[0] + 1);

	  if (endOffset[1] == 0)
	    buffers.pop();
	  else
	    buffers[buffers.length-1] = buffers[buffers.length-1].slice(0, endOffset[1]);

	  if (startOffset[1] != 0)
	    buffers[0] = buffers[0].slice(startOffset[1]);

	  return new BufferList(buffers)
	};

	BufferList.prototype.toString = function toString (encoding, start, end) {
	  return this.slice(start, end).toString(encoding)
	};

	BufferList.prototype.consume = function consume (bytes) {
	  // first, normalize the argument, in accordance with how Buffer does it
	  bytes = Math.trunc(bytes);
	  // do nothing if not a positive number
	  if (Number.isNaN(bytes) || bytes <= 0) return this

	  while (this._bufs.length) {
	    if (bytes >= this._bufs[0].length) {
	      bytes -= this._bufs[0].length;
	      this.length -= this._bufs[0].length;
	      this._bufs.shift();
	    } else {
	      this._bufs[0] = this._bufs[0].slice(bytes);
	      this.length -= bytes;
	      break
	    }
	  }
	  return this
	};


	BufferList.prototype.duplicate = function duplicate () {
	  var i = 0
	    , copy = new BufferList();

	  for (; i < this._bufs.length; i++)
	    copy.append(this._bufs[i]);

	  return copy
	};


	BufferList.prototype.destroy = function destroy () {
	  this._bufs.length = 0;
	  this.length = 0;
	  this.push(null);
	}


	;(function () {
	  var methods = {
	      'readDoubleBE' : 8
	    , 'readDoubleLE' : 8
	    , 'readFloatBE'  : 4
	    , 'readFloatLE'  : 4
	    , 'readInt32BE'  : 4
	    , 'readInt32LE'  : 4
	    , 'readUInt32BE' : 4
	    , 'readUInt32LE' : 4
	    , 'readInt16BE'  : 2
	    , 'readInt16LE'  : 2
	    , 'readUInt16BE' : 2
	    , 'readUInt16LE' : 2
	    , 'readInt8'     : 1
	    , 'readUInt8'    : 1
	  };

	  for (var m in methods) {
	    (function (m) {
	      BufferList.prototype[m] = function (offset) {
	        return this.slice(offset, offset + methods[m])[m](0)
	      };
	    }(m));
	  }
	}());


	bl = BufferList;
	return bl;
}

var immutable;
var hasRequiredImmutable;

function requireImmutable () {
	if (hasRequiredImmutable) return immutable;
	hasRequiredImmutable = 1;
	immutable = extend;

	var hasOwnProperty = Object.prototype.hasOwnProperty;

	function extend() {
	    var target = {};

	    for (var i = 0; i < arguments.length; i++) {
	        var source = arguments[i];

	        for (var key in source) {
	            if (hasOwnProperty.call(source, key)) {
	                target[key] = source[key];
	            }
	        }
	    }

	    return target
	}
	return immutable;
}

var headers = {};

var isarray;
var hasRequiredIsarray;

function requireIsarray () {
	if (hasRequiredIsarray) return isarray;
	hasRequiredIsarray = 1;
	var toString = {}.toString;

	isarray = Array.isArray || function (arr) {
	  return toString.call(arr) == '[object Array]';
	};
	return isarray;
}

var type$2;
var hasRequiredType;

function requireType () {
	if (hasRequiredType) return type$2;
	hasRequiredType = 1;

	/** @type {import('./type')} */
	type$2 = TypeError;
	return type$2;
}

var esObjectAtoms;
var hasRequiredEsObjectAtoms;

function requireEsObjectAtoms () {
	if (hasRequiredEsObjectAtoms) return esObjectAtoms;
	hasRequiredEsObjectAtoms = 1;

	/** @type {import('.')} */
	esObjectAtoms = Object;
	return esObjectAtoms;
}

var esErrors;
var hasRequiredEsErrors;

function requireEsErrors () {
	if (hasRequiredEsErrors) return esErrors;
	hasRequiredEsErrors = 1;

	/** @type {import('.')} */
	esErrors = Error;
	return esErrors;
}

var _eval;
var hasRequired_eval;

function require_eval () {
	if (hasRequired_eval) return _eval;
	hasRequired_eval = 1;

	/** @type {import('./eval')} */
	_eval = EvalError;
	return _eval;
}

var range;
var hasRequiredRange;

function requireRange () {
	if (hasRequiredRange) return range;
	hasRequiredRange = 1;

	/** @type {import('./range')} */
	range = RangeError;
	return range;
}

var ref$1;
var hasRequiredRef$1;

function requireRef$1 () {
	if (hasRequiredRef$1) return ref$1;
	hasRequiredRef$1 = 1;

	/** @type {import('./ref')} */
	ref$1 = ReferenceError;
	return ref$1;
}

var syntax;
var hasRequiredSyntax;

function requireSyntax () {
	if (hasRequiredSyntax) return syntax;
	hasRequiredSyntax = 1;

	/** @type {import('./syntax')} */
	syntax = SyntaxError;
	return syntax;
}

var uri$1;
var hasRequiredUri$1;

function requireUri$1 () {
	if (hasRequiredUri$1) return uri$1;
	hasRequiredUri$1 = 1;

	/** @type {import('./uri')} */
	uri$1 = URIError;
	return uri$1;
}

var abs;
var hasRequiredAbs;

function requireAbs () {
	if (hasRequiredAbs) return abs;
	hasRequiredAbs = 1;

	/** @type {import('./abs')} */
	abs = Math.abs;
	return abs;
}

var floor;
var hasRequiredFloor;

function requireFloor () {
	if (hasRequiredFloor) return floor;
	hasRequiredFloor = 1;

	/** @type {import('./floor')} */
	floor = Math.floor;
	return floor;
}

var max;
var hasRequiredMax;

function requireMax () {
	if (hasRequiredMax) return max;
	hasRequiredMax = 1;

	/** @type {import('./max')} */
	max = Math.max;
	return max;
}

var min;
var hasRequiredMin;

function requireMin () {
	if (hasRequiredMin) return min;
	hasRequiredMin = 1;

	/** @type {import('./min')} */
	min = Math.min;
	return min;
}

var pow;
var hasRequiredPow;

function requirePow () {
	if (hasRequiredPow) return pow;
	hasRequiredPow = 1;

	/** @type {import('./pow')} */
	pow = Math.pow;
	return pow;
}

var round;
var hasRequiredRound;

function requireRound () {
	if (hasRequiredRound) return round;
	hasRequiredRound = 1;

	/** @type {import('./round')} */
	round = Math.round;
	return round;
}

var _isNaN;
var hasRequired_isNaN;

function require_isNaN () {
	if (hasRequired_isNaN) return _isNaN;
	hasRequired_isNaN = 1;

	/** @type {import('./isNaN')} */
	_isNaN = Number.isNaN || function isNaN(a) {
		return a !== a;
	};
	return _isNaN;
}

var sign$1;
var hasRequiredSign;

function requireSign () {
	if (hasRequiredSign) return sign$1;
	hasRequiredSign = 1;

	var $isNaN = /*@__PURE__*/ require_isNaN();

	/** @type {import('./sign')} */
	sign$1 = function sign(number) {
		if ($isNaN(number) || number === 0) {
			return number;
		}
		return number < 0 ? -1 : 1;
	};
	return sign$1;
}

var gOPD;
var hasRequiredGOPD;

function requireGOPD () {
	if (hasRequiredGOPD) return gOPD;
	hasRequiredGOPD = 1;

	/** @type {import('./gOPD')} */
	gOPD = Object.getOwnPropertyDescriptor;
	return gOPD;
}

var gopd;
var hasRequiredGopd;

function requireGopd () {
	if (hasRequiredGopd) return gopd;
	hasRequiredGopd = 1;

	/** @type {import('.')} */
	var $gOPD = /*@__PURE__*/ requireGOPD();

	if ($gOPD) {
		try {
			$gOPD([], 'length');
		} catch (e) {
			// IE 8 has a broken gOPD
			$gOPD = null;
		}
	}

	gopd = $gOPD;
	return gopd;
}

var esDefineProperty;
var hasRequiredEsDefineProperty;

function requireEsDefineProperty () {
	if (hasRequiredEsDefineProperty) return esDefineProperty;
	hasRequiredEsDefineProperty = 1;

	/** @type {import('.')} */
	var $defineProperty = Object.defineProperty || false;
	if ($defineProperty) {
		try {
			$defineProperty({}, 'a', { value: 1 });
		} catch (e) {
			// IE 8 has a broken defineProperty
			$defineProperty = false;
		}
	}

	esDefineProperty = $defineProperty;
	return esDefineProperty;
}

var shams$1;
var hasRequiredShams$1;

function requireShams$1 () {
	if (hasRequiredShams$1) return shams$1;
	hasRequiredShams$1 = 1;

	/** @type {import('./shams')} */
	/* eslint complexity: [2, 18], max-statements: [2, 33] */
	shams$1 = function hasSymbols() {
		if (typeof Symbol !== 'function' || typeof Object.getOwnPropertySymbols !== 'function') { return false; }
		if (typeof Symbol.iterator === 'symbol') { return true; }

		/** @type {{ [k in symbol]?: unknown }} */
		var obj = {};
		var sym = Symbol('test');
		var symObj = Object(sym);
		if (typeof sym === 'string') { return false; }

		if (Object.prototype.toString.call(sym) !== '[object Symbol]') { return false; }
		if (Object.prototype.toString.call(symObj) !== '[object Symbol]') { return false; }

		// temp disabled per https://github.com/ljharb/object.assign/issues/17
		// if (sym instanceof Symbol) { return false; }
		// temp disabled per https://github.com/WebReflection/get-own-property-symbols/issues/4
		// if (!(symObj instanceof Symbol)) { return false; }

		// if (typeof Symbol.prototype.toString !== 'function') { return false; }
		// if (String(sym) !== Symbol.prototype.toString.call(sym)) { return false; }

		var symVal = 42;
		obj[sym] = symVal;
		for (var _ in obj) { return false; } // eslint-disable-line no-restricted-syntax, no-unreachable-loop
		if (typeof Object.keys === 'function' && Object.keys(obj).length !== 0) { return false; }

		if (typeof Object.getOwnPropertyNames === 'function' && Object.getOwnPropertyNames(obj).length !== 0) { return false; }

		var syms = Object.getOwnPropertySymbols(obj);
		if (syms.length !== 1 || syms[0] !== sym) { return false; }

		if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) { return false; }

		if (typeof Object.getOwnPropertyDescriptor === 'function') {
			// eslint-disable-next-line no-extra-parens
			var descriptor = /** @type {PropertyDescriptor} */ (Object.getOwnPropertyDescriptor(obj, sym));
			if (descriptor.value !== symVal || descriptor.enumerable !== true) { return false; }
		}

		return true;
	};
	return shams$1;
}

var hasSymbols;
var hasRequiredHasSymbols;

function requireHasSymbols () {
	if (hasRequiredHasSymbols) return hasSymbols;
	hasRequiredHasSymbols = 1;

	var origSymbol = typeof Symbol !== 'undefined' && Symbol;
	var hasSymbolSham = requireShams$1();

	/** @type {import('.')} */
	hasSymbols = function hasNativeSymbols() {
		if (typeof origSymbol !== 'function') { return false; }
		if (typeof Symbol !== 'function') { return false; }
		if (typeof origSymbol('foo') !== 'symbol') { return false; }
		if (typeof Symbol('bar') !== 'symbol') { return false; }

		return hasSymbolSham();
	};
	return hasSymbols;
}

var Reflect_getPrototypeOf;
var hasRequiredReflect_getPrototypeOf;

function requireReflect_getPrototypeOf () {
	if (hasRequiredReflect_getPrototypeOf) return Reflect_getPrototypeOf;
	hasRequiredReflect_getPrototypeOf = 1;

	/** @type {import('./Reflect.getPrototypeOf')} */
	Reflect_getPrototypeOf = (typeof Reflect !== 'undefined' && Reflect.getPrototypeOf) || null;
	return Reflect_getPrototypeOf;
}

var Object_getPrototypeOf;
var hasRequiredObject_getPrototypeOf;

function requireObject_getPrototypeOf () {
	if (hasRequiredObject_getPrototypeOf) return Object_getPrototypeOf;
	hasRequiredObject_getPrototypeOf = 1;

	var $Object = /*@__PURE__*/ requireEsObjectAtoms();

	/** @type {import('./Object.getPrototypeOf')} */
	Object_getPrototypeOf = $Object.getPrototypeOf || null;
	return Object_getPrototypeOf;
}

var implementation;
var hasRequiredImplementation;

function requireImplementation () {
	if (hasRequiredImplementation) return implementation;
	hasRequiredImplementation = 1;

	/* eslint no-invalid-this: 1 */

	var ERROR_MESSAGE = 'Function.prototype.bind called on incompatible ';
	var toStr = Object.prototype.toString;
	var max = Math.max;
	var funcType = '[object Function]';

	var concatty = function concatty(a, b) {
	    var arr = [];

	    for (var i = 0; i < a.length; i += 1) {
	        arr[i] = a[i];
	    }
	    for (var j = 0; j < b.length; j += 1) {
	        arr[j + a.length] = b[j];
	    }

	    return arr;
	};

	var slicy = function slicy(arrLike, offset) {
	    var arr = [];
	    for (var i = offset, j = 0; i < arrLike.length; i += 1, j += 1) {
	        arr[j] = arrLike[i];
	    }
	    return arr;
	};

	var joiny = function (arr, joiner) {
	    var str = '';
	    for (var i = 0; i < arr.length; i += 1) {
	        str += arr[i];
	        if (i + 1 < arr.length) {
	            str += joiner;
	        }
	    }
	    return str;
	};

	implementation = function bind(that) {
	    var target = this;
	    if (typeof target !== 'function' || toStr.apply(target) !== funcType) {
	        throw new TypeError(ERROR_MESSAGE + target);
	    }
	    var args = slicy(arguments, 1);

	    var bound;
	    var binder = function () {
	        if (this instanceof bound) {
	            var result = target.apply(
	                this,
	                concatty(args, arguments)
	            );
	            if (Object(result) === result) {
	                return result;
	            }
	            return this;
	        }
	        return target.apply(
	            that,
	            concatty(args, arguments)
	        );

	    };

	    var boundLength = max(0, target.length - args.length);
	    var boundArgs = [];
	    for (var i = 0; i < boundLength; i++) {
	        boundArgs[i] = '$' + i;
	    }

	    bound = Function('binder', 'return function (' + joiny(boundArgs, ',') + '){ return binder.apply(this,arguments); }')(binder);

	    if (target.prototype) {
	        var Empty = function Empty() {};
	        Empty.prototype = target.prototype;
	        bound.prototype = new Empty();
	        Empty.prototype = null;
	    }

	    return bound;
	};
	return implementation;
}

var functionBind;
var hasRequiredFunctionBind;

function requireFunctionBind () {
	if (hasRequiredFunctionBind) return functionBind;
	hasRequiredFunctionBind = 1;

	var implementation = requireImplementation();

	functionBind = Function.prototype.bind || implementation;
	return functionBind;
}

var functionCall;
var hasRequiredFunctionCall;

function requireFunctionCall () {
	if (hasRequiredFunctionCall) return functionCall;
	hasRequiredFunctionCall = 1;

	/** @type {import('./functionCall')} */
	functionCall = Function.prototype.call;
	return functionCall;
}

var functionApply;
var hasRequiredFunctionApply;

function requireFunctionApply () {
	if (hasRequiredFunctionApply) return functionApply;
	hasRequiredFunctionApply = 1;

	/** @type {import('./functionApply')} */
	functionApply = Function.prototype.apply;
	return functionApply;
}

var reflectApply;
var hasRequiredReflectApply;

function requireReflectApply () {
	if (hasRequiredReflectApply) return reflectApply;
	hasRequiredReflectApply = 1;

	/** @type {import('./reflectApply')} */
	reflectApply = typeof Reflect !== 'undefined' && Reflect && Reflect.apply;
	return reflectApply;
}

var actualApply;
var hasRequiredActualApply;

function requireActualApply () {
	if (hasRequiredActualApply) return actualApply;
	hasRequiredActualApply = 1;

	var bind = requireFunctionBind();

	var $apply = requireFunctionApply();
	var $call = requireFunctionCall();
	var $reflectApply = requireReflectApply();

	/** @type {import('./actualApply')} */
	actualApply = $reflectApply || bind.call($call, $apply);
	return actualApply;
}

var callBindApplyHelpers;
var hasRequiredCallBindApplyHelpers;

function requireCallBindApplyHelpers () {
	if (hasRequiredCallBindApplyHelpers) return callBindApplyHelpers;
	hasRequiredCallBindApplyHelpers = 1;

	var bind = requireFunctionBind();
	var $TypeError = /*@__PURE__*/ requireType();

	var $call = requireFunctionCall();
	var $actualApply = requireActualApply();

	/** @type {(args: [Function, thisArg?: unknown, ...args: unknown[]]) => Function} TODO FIXME, find a way to use import('.') */
	callBindApplyHelpers = function callBindBasic(args) {
		if (args.length < 1 || typeof args[0] !== 'function') {
			throw new $TypeError('a function is required');
		}
		return $actualApply(bind, $call, args);
	};
	return callBindApplyHelpers;
}

var get;
var hasRequiredGet;

function requireGet () {
	if (hasRequiredGet) return get;
	hasRequiredGet = 1;

	var callBind = requireCallBindApplyHelpers();
	var gOPD = /*@__PURE__*/ requireGopd();

	var hasProtoAccessor;
	try {
		// eslint-disable-next-line no-extra-parens, no-proto
		hasProtoAccessor = /** @type {{ __proto__?: typeof Array.prototype }} */ ([]).__proto__ === Array.prototype;
	} catch (e) {
		if (!e || typeof e !== 'object' || !('code' in e) || e.code !== 'ERR_PROTO_ACCESS') {
			throw e;
		}
	}

	// eslint-disable-next-line no-extra-parens
	var desc = !!hasProtoAccessor && gOPD && gOPD(Object.prototype, /** @type {keyof typeof Object.prototype} */ ('__proto__'));

	var $Object = Object;
	var $getPrototypeOf = $Object.getPrototypeOf;

	/** @type {import('./get')} */
	get = desc && typeof desc.get === 'function'
		? callBind([desc.get])
		: typeof $getPrototypeOf === 'function'
			? /** @type {import('./get')} */ function getDunder(value) {
				// eslint-disable-next-line eqeqeq
				return $getPrototypeOf(value == null ? value : $Object(value));
			}
			: false;
	return get;
}

var getProto;
var hasRequiredGetProto;

function requireGetProto () {
	if (hasRequiredGetProto) return getProto;
	hasRequiredGetProto = 1;

	var reflectGetProto = requireReflect_getPrototypeOf();
	var originalGetProto = requireObject_getPrototypeOf();

	var getDunderProto = /*@__PURE__*/ requireGet();

	/** @type {import('.')} */
	getProto = reflectGetProto
		? function getProto(O) {
			// @ts-expect-error TS can't narrow inside a closure, for some reason
			return reflectGetProto(O);
		}
		: originalGetProto
			? function getProto(O) {
				if (!O || (typeof O !== 'object' && typeof O !== 'function')) {
					throw new TypeError('getProto: not an object');
				}
				// @ts-expect-error TS can't narrow inside a closure, for some reason
				return originalGetProto(O);
			}
			: getDunderProto
				? function getProto(O) {
					// @ts-expect-error TS can't narrow inside a closure, for some reason
					return getDunderProto(O);
				}
				: null;
	return getProto;
}

var hasown;
var hasRequiredHasown;

function requireHasown () {
	if (hasRequiredHasown) return hasown;
	hasRequiredHasown = 1;

	var call = Function.prototype.call;
	var $hasOwn = Object.prototype.hasOwnProperty;
	var bind = requireFunctionBind();

	/** @type {import('.')} */
	hasown = bind.call(call, $hasOwn);
	return hasown;
}

var getIntrinsic;
var hasRequiredGetIntrinsic;

function requireGetIntrinsic () {
	if (hasRequiredGetIntrinsic) return getIntrinsic;
	hasRequiredGetIntrinsic = 1;

	var undefined$1;

	var $Object = /*@__PURE__*/ requireEsObjectAtoms();

	var $Error = /*@__PURE__*/ requireEsErrors();
	var $EvalError = /*@__PURE__*/ require_eval();
	var $RangeError = /*@__PURE__*/ requireRange();
	var $ReferenceError = /*@__PURE__*/ requireRef$1();
	var $SyntaxError = /*@__PURE__*/ requireSyntax();
	var $TypeError = /*@__PURE__*/ requireType();
	var $URIError = /*@__PURE__*/ requireUri$1();

	var abs = /*@__PURE__*/ requireAbs();
	var floor = /*@__PURE__*/ requireFloor();
	var max = /*@__PURE__*/ requireMax();
	var min = /*@__PURE__*/ requireMin();
	var pow = /*@__PURE__*/ requirePow();
	var round = /*@__PURE__*/ requireRound();
	var sign = /*@__PURE__*/ requireSign();

	var $Function = Function;

	// eslint-disable-next-line consistent-return
	var getEvalledConstructor = function (expressionSyntax) {
		try {
			return $Function('"use strict"; return (' + expressionSyntax + ').constructor;')();
		} catch (e) {}
	};

	var $gOPD = /*@__PURE__*/ requireGopd();
	var $defineProperty = /*@__PURE__*/ requireEsDefineProperty();

	var throwTypeError = function () {
		throw new $TypeError();
	};
	var ThrowTypeError = $gOPD
		? (function () {
			try {
				// eslint-disable-next-line no-unused-expressions, no-caller, no-restricted-properties
				arguments.callee; // IE 8 does not throw here
				return throwTypeError;
			} catch (calleeThrows) {
				try {
					// IE 8 throws on Object.getOwnPropertyDescriptor(arguments, '')
					return $gOPD(arguments, 'callee').get;
				} catch (gOPDthrows) {
					return throwTypeError;
				}
			}
		}())
		: throwTypeError;

	var hasSymbols = requireHasSymbols()();

	var getProto = requireGetProto();
	var $ObjectGPO = requireObject_getPrototypeOf();
	var $ReflectGPO = requireReflect_getPrototypeOf();

	var $apply = requireFunctionApply();
	var $call = requireFunctionCall();

	var needsEval = {};

	var TypedArray = typeof Uint8Array === 'undefined' || !getProto ? undefined$1 : getProto(Uint8Array);

	var INTRINSICS = {
		__proto__: null,
		'%AggregateError%': typeof AggregateError === 'undefined' ? undefined$1 : AggregateError,
		'%Array%': Array,
		'%ArrayBuffer%': typeof ArrayBuffer === 'undefined' ? undefined$1 : ArrayBuffer,
		'%ArrayIteratorPrototype%': hasSymbols && getProto ? getProto([][Symbol.iterator]()) : undefined$1,
		'%AsyncFromSyncIteratorPrototype%': undefined$1,
		'%AsyncFunction%': needsEval,
		'%AsyncGenerator%': needsEval,
		'%AsyncGeneratorFunction%': needsEval,
		'%AsyncIteratorPrototype%': needsEval,
		'%Atomics%': typeof Atomics === 'undefined' ? undefined$1 : Atomics,
		'%BigInt%': typeof BigInt === 'undefined' ? undefined$1 : BigInt,
		'%BigInt64Array%': typeof BigInt64Array === 'undefined' ? undefined$1 : BigInt64Array,
		'%BigUint64Array%': typeof BigUint64Array === 'undefined' ? undefined$1 : BigUint64Array,
		'%Boolean%': Boolean,
		'%DataView%': typeof DataView === 'undefined' ? undefined$1 : DataView,
		'%Date%': Date,
		'%decodeURI%': decodeURI,
		'%decodeURIComponent%': decodeURIComponent,
		'%encodeURI%': encodeURI,
		'%encodeURIComponent%': encodeURIComponent,
		'%Error%': $Error,
		'%eval%': eval, // eslint-disable-line no-eval
		'%EvalError%': $EvalError,
		'%Float16Array%': typeof Float16Array === 'undefined' ? undefined$1 : Float16Array,
		'%Float32Array%': typeof Float32Array === 'undefined' ? undefined$1 : Float32Array,
		'%Float64Array%': typeof Float64Array === 'undefined' ? undefined$1 : Float64Array,
		'%FinalizationRegistry%': typeof FinalizationRegistry === 'undefined' ? undefined$1 : FinalizationRegistry,
		'%Function%': $Function,
		'%GeneratorFunction%': needsEval,
		'%Int8Array%': typeof Int8Array === 'undefined' ? undefined$1 : Int8Array,
		'%Int16Array%': typeof Int16Array === 'undefined' ? undefined$1 : Int16Array,
		'%Int32Array%': typeof Int32Array === 'undefined' ? undefined$1 : Int32Array,
		'%isFinite%': isFinite,
		'%isNaN%': isNaN,
		'%IteratorPrototype%': hasSymbols && getProto ? getProto(getProto([][Symbol.iterator]())) : undefined$1,
		'%JSON%': typeof JSON === 'object' ? JSON : undefined$1,
		'%Map%': typeof Map === 'undefined' ? undefined$1 : Map,
		'%MapIteratorPrototype%': typeof Map === 'undefined' || !hasSymbols || !getProto ? undefined$1 : getProto(new Map()[Symbol.iterator]()),
		'%Math%': Math,
		'%Number%': Number,
		'%Object%': $Object,
		'%Object.getOwnPropertyDescriptor%': $gOPD,
		'%parseFloat%': parseFloat,
		'%parseInt%': parseInt,
		'%Promise%': typeof Promise === 'undefined' ? undefined$1 : Promise,
		'%Proxy%': typeof Proxy === 'undefined' ? undefined$1 : Proxy,
		'%RangeError%': $RangeError,
		'%ReferenceError%': $ReferenceError,
		'%Reflect%': typeof Reflect === 'undefined' ? undefined$1 : Reflect,
		'%RegExp%': RegExp,
		'%Set%': typeof Set === 'undefined' ? undefined$1 : Set,
		'%SetIteratorPrototype%': typeof Set === 'undefined' || !hasSymbols || !getProto ? undefined$1 : getProto(new Set()[Symbol.iterator]()),
		'%SharedArrayBuffer%': typeof SharedArrayBuffer === 'undefined' ? undefined$1 : SharedArrayBuffer,
		'%String%': String,
		'%StringIteratorPrototype%': hasSymbols && getProto ? getProto(''[Symbol.iterator]()) : undefined$1,
		'%Symbol%': hasSymbols ? Symbol : undefined$1,
		'%SyntaxError%': $SyntaxError,
		'%ThrowTypeError%': ThrowTypeError,
		'%TypedArray%': TypedArray,
		'%TypeError%': $TypeError,
		'%Uint8Array%': typeof Uint8Array === 'undefined' ? undefined$1 : Uint8Array,
		'%Uint8ClampedArray%': typeof Uint8ClampedArray === 'undefined' ? undefined$1 : Uint8ClampedArray,
		'%Uint16Array%': typeof Uint16Array === 'undefined' ? undefined$1 : Uint16Array,
		'%Uint32Array%': typeof Uint32Array === 'undefined' ? undefined$1 : Uint32Array,
		'%URIError%': $URIError,
		'%WeakMap%': typeof WeakMap === 'undefined' ? undefined$1 : WeakMap,
		'%WeakRef%': typeof WeakRef === 'undefined' ? undefined$1 : WeakRef,
		'%WeakSet%': typeof WeakSet === 'undefined' ? undefined$1 : WeakSet,

		'%Function.prototype.call%': $call,
		'%Function.prototype.apply%': $apply,
		'%Object.defineProperty%': $defineProperty,
		'%Object.getPrototypeOf%': $ObjectGPO,
		'%Math.abs%': abs,
		'%Math.floor%': floor,
		'%Math.max%': max,
		'%Math.min%': min,
		'%Math.pow%': pow,
		'%Math.round%': round,
		'%Math.sign%': sign,
		'%Reflect.getPrototypeOf%': $ReflectGPO
	};

	if (getProto) {
		try {
			null.error; // eslint-disable-line no-unused-expressions
		} catch (e) {
			// https://github.com/tc39/proposal-shadowrealm/pull/384#issuecomment-1364264229
			var errorProto = getProto(getProto(e));
			INTRINSICS['%Error.prototype%'] = errorProto;
		}
	}

	var doEval = function doEval(name) {
		var value;
		if (name === '%AsyncFunction%') {
			value = getEvalledConstructor('async function () {}');
		} else if (name === '%GeneratorFunction%') {
			value = getEvalledConstructor('function* () {}');
		} else if (name === '%AsyncGeneratorFunction%') {
			value = getEvalledConstructor('async function* () {}');
		} else if (name === '%AsyncGenerator%') {
			var fn = doEval('%AsyncGeneratorFunction%');
			if (fn) {
				value = fn.prototype;
			}
		} else if (name === '%AsyncIteratorPrototype%') {
			var gen = doEval('%AsyncGenerator%');
			if (gen && getProto) {
				value = getProto(gen.prototype);
			}
		}

		INTRINSICS[name] = value;

		return value;
	};

	var LEGACY_ALIASES = {
		__proto__: null,
		'%ArrayBufferPrototype%': ['ArrayBuffer', 'prototype'],
		'%ArrayPrototype%': ['Array', 'prototype'],
		'%ArrayProto_entries%': ['Array', 'prototype', 'entries'],
		'%ArrayProto_forEach%': ['Array', 'prototype', 'forEach'],
		'%ArrayProto_keys%': ['Array', 'prototype', 'keys'],
		'%ArrayProto_values%': ['Array', 'prototype', 'values'],
		'%AsyncFunctionPrototype%': ['AsyncFunction', 'prototype'],
		'%AsyncGenerator%': ['AsyncGeneratorFunction', 'prototype'],
		'%AsyncGeneratorPrototype%': ['AsyncGeneratorFunction', 'prototype', 'prototype'],
		'%BooleanPrototype%': ['Boolean', 'prototype'],
		'%DataViewPrototype%': ['DataView', 'prototype'],
		'%DatePrototype%': ['Date', 'prototype'],
		'%ErrorPrototype%': ['Error', 'prototype'],
		'%EvalErrorPrototype%': ['EvalError', 'prototype'],
		'%Float32ArrayPrototype%': ['Float32Array', 'prototype'],
		'%Float64ArrayPrototype%': ['Float64Array', 'prototype'],
		'%FunctionPrototype%': ['Function', 'prototype'],
		'%Generator%': ['GeneratorFunction', 'prototype'],
		'%GeneratorPrototype%': ['GeneratorFunction', 'prototype', 'prototype'],
		'%Int8ArrayPrototype%': ['Int8Array', 'prototype'],
		'%Int16ArrayPrototype%': ['Int16Array', 'prototype'],
		'%Int32ArrayPrototype%': ['Int32Array', 'prototype'],
		'%JSONParse%': ['JSON', 'parse'],
		'%JSONStringify%': ['JSON', 'stringify'],
		'%MapPrototype%': ['Map', 'prototype'],
		'%NumberPrototype%': ['Number', 'prototype'],
		'%ObjectPrototype%': ['Object', 'prototype'],
		'%ObjProto_toString%': ['Object', 'prototype', 'toString'],
		'%ObjProto_valueOf%': ['Object', 'prototype', 'valueOf'],
		'%PromisePrototype%': ['Promise', 'prototype'],
		'%PromiseProto_then%': ['Promise', 'prototype', 'then'],
		'%Promise_all%': ['Promise', 'all'],
		'%Promise_reject%': ['Promise', 'reject'],
		'%Promise_resolve%': ['Promise', 'resolve'],
		'%RangeErrorPrototype%': ['RangeError', 'prototype'],
		'%ReferenceErrorPrototype%': ['ReferenceError', 'prototype'],
		'%RegExpPrototype%': ['RegExp', 'prototype'],
		'%SetPrototype%': ['Set', 'prototype'],
		'%SharedArrayBufferPrototype%': ['SharedArrayBuffer', 'prototype'],
		'%StringPrototype%': ['String', 'prototype'],
		'%SymbolPrototype%': ['Symbol', 'prototype'],
		'%SyntaxErrorPrototype%': ['SyntaxError', 'prototype'],
		'%TypedArrayPrototype%': ['TypedArray', 'prototype'],
		'%TypeErrorPrototype%': ['TypeError', 'prototype'],
		'%Uint8ArrayPrototype%': ['Uint8Array', 'prototype'],
		'%Uint8ClampedArrayPrototype%': ['Uint8ClampedArray', 'prototype'],
		'%Uint16ArrayPrototype%': ['Uint16Array', 'prototype'],
		'%Uint32ArrayPrototype%': ['Uint32Array', 'prototype'],
		'%URIErrorPrototype%': ['URIError', 'prototype'],
		'%WeakMapPrototype%': ['WeakMap', 'prototype'],
		'%WeakSetPrototype%': ['WeakSet', 'prototype']
	};

	var bind = requireFunctionBind();
	var hasOwn = /*@__PURE__*/ requireHasown();
	var $concat = bind.call($call, Array.prototype.concat);
	var $spliceApply = bind.call($apply, Array.prototype.splice);
	var $replace = bind.call($call, String.prototype.replace);
	var $strSlice = bind.call($call, String.prototype.slice);
	var $exec = bind.call($call, RegExp.prototype.exec);

	/* adapted from https://github.com/lodash/lodash/blob/4.17.15/dist/lodash.js#L6735-L6744 */
	var rePropName = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
	var reEscapeChar = /\\(\\)?/g; /** Used to match backslashes in property paths. */
	var stringToPath = function stringToPath(string) {
		var first = $strSlice(string, 0, 1);
		var last = $strSlice(string, -1);
		if (first === '%' && last !== '%') {
			throw new $SyntaxError('invalid intrinsic syntax, expected closing `%`');
		} else if (last === '%' && first !== '%') {
			throw new $SyntaxError('invalid intrinsic syntax, expected opening `%`');
		}
		var result = [];
		$replace(string, rePropName, function (match, number, quote, subString) {
			result[result.length] = quote ? $replace(subString, reEscapeChar, '$1') : number || match;
		});
		return result;
	};
	/* end adaptation */

	var getBaseIntrinsic = function getBaseIntrinsic(name, allowMissing) {
		var intrinsicName = name;
		var alias;
		if (hasOwn(LEGACY_ALIASES, intrinsicName)) {
			alias = LEGACY_ALIASES[intrinsicName];
			intrinsicName = '%' + alias[0] + '%';
		}

		if (hasOwn(INTRINSICS, intrinsicName)) {
			var value = INTRINSICS[intrinsicName];
			if (value === needsEval) {
				value = doEval(intrinsicName);
			}
			if (typeof value === 'undefined' && !allowMissing) {
				throw new $TypeError('intrinsic ' + name + ' exists, but is not available. Please file an issue!');
			}

			return {
				alias: alias,
				name: intrinsicName,
				value: value
			};
		}

		throw new $SyntaxError('intrinsic ' + name + ' does not exist!');
	};

	getIntrinsic = function GetIntrinsic(name, allowMissing) {
		if (typeof name !== 'string' || name.length === 0) {
			throw new $TypeError('intrinsic name must be a non-empty string');
		}
		if (arguments.length > 1 && typeof allowMissing !== 'boolean') {
			throw new $TypeError('"allowMissing" argument must be a boolean');
		}

		if ($exec(/^%?[^%]*%?$/, name) === null) {
			throw new $SyntaxError('`%` may not be present anywhere but at the beginning and end of the intrinsic name');
		}
		var parts = stringToPath(name);
		var intrinsicBaseName = parts.length > 0 ? parts[0] : '';

		var intrinsic = getBaseIntrinsic('%' + intrinsicBaseName + '%', allowMissing);
		var intrinsicRealName = intrinsic.name;
		var value = intrinsic.value;
		var skipFurtherCaching = false;

		var alias = intrinsic.alias;
		if (alias) {
			intrinsicBaseName = alias[0];
			$spliceApply(parts, $concat([0, 1], alias));
		}

		for (var i = 1, isOwn = true; i < parts.length; i += 1) {
			var part = parts[i];
			var first = $strSlice(part, 0, 1);
			var last = $strSlice(part, -1);
			if (
				(
					(first === '"' || first === "'" || first === '`')
					|| (last === '"' || last === "'" || last === '`')
				)
				&& first !== last
			) {
				throw new $SyntaxError('property names with quotes must have matching quotes');
			}
			if (part === 'constructor' || !isOwn) {
				skipFurtherCaching = true;
			}

			intrinsicBaseName += '.' + part;
			intrinsicRealName = '%' + intrinsicBaseName + '%';

			if (hasOwn(INTRINSICS, intrinsicRealName)) {
				value = INTRINSICS[intrinsicRealName];
			} else if (value != null) {
				if (!(part in value)) {
					if (!allowMissing) {
						throw new $TypeError('base intrinsic for ' + name + ' exists, but the property is not available.');
					}
					return void undefined$1;
				}
				if ($gOPD && (i + 1) >= parts.length) {
					var desc = $gOPD(value, part);
					isOwn = !!desc;

					// By convention, when a data property is converted to an accessor
					// property to emulate a data property that does not suffer from
					// the override mistake, that accessor's getter is marked with
					// an `originalValue` property. Here, when we detect this, we
					// uphold the illusion by pretending to see that original data
					// property, i.e., returning the value rather than the getter
					// itself.
					if (isOwn && 'get' in desc && !('originalValue' in desc.get)) {
						value = desc.get;
					} else {
						value = value[part];
					}
				} else {
					isOwn = hasOwn(value, part);
					value = value[part];
				}

				if (isOwn && !skipFurtherCaching) {
					INTRINSICS[intrinsicRealName] = value;
				}
			}
		}
		return value;
	};
	return getIntrinsic;
}

var callBound;
var hasRequiredCallBound;

function requireCallBound () {
	if (hasRequiredCallBound) return callBound;
	hasRequiredCallBound = 1;

	var GetIntrinsic = /*@__PURE__*/ requireGetIntrinsic();

	var callBindBasic = requireCallBindApplyHelpers();

	/** @type {(thisArg: string, searchString: string, position?: number) => number} */
	var $indexOf = callBindBasic([GetIntrinsic('%String.prototype.indexOf%')]);

	/** @type {import('.')} */
	callBound = function callBoundIntrinsic(name, allowMissing) {
		/* eslint no-extra-parens: 0 */

		var intrinsic = /** @type {(this: unknown, ...args: unknown[]) => unknown} */ (GetIntrinsic(name, !!allowMissing));
		if (typeof intrinsic === 'function' && $indexOf(name, '.prototype.') > -1) {
			return callBindBasic(/** @type {const} */ ([intrinsic]));
		}
		return intrinsic;
	};
	return callBound;
}

var isCallable;
var hasRequiredIsCallable;

function requireIsCallable () {
	if (hasRequiredIsCallable) return isCallable;
	hasRequiredIsCallable = 1;

	var fnToStr = Function.prototype.toString;
	var reflectApply = typeof Reflect === 'object' && Reflect !== null && Reflect.apply;
	var badArrayLike;
	var isCallableMarker;
	if (typeof reflectApply === 'function' && typeof Object.defineProperty === 'function') {
		try {
			badArrayLike = Object.defineProperty({}, 'length', {
				get: function () {
					throw isCallableMarker;
				}
			});
			isCallableMarker = {};
			// eslint-disable-next-line no-throw-literal
			reflectApply(function () { throw 42; }, null, badArrayLike);
		} catch (_) {
			if (_ !== isCallableMarker) {
				reflectApply = null;
			}
		}
	} else {
		reflectApply = null;
	}

	var constructorRegex = /^\s*class\b/;
	var isES6ClassFn = function isES6ClassFunction(value) {
		try {
			var fnStr = fnToStr.call(value);
			return constructorRegex.test(fnStr);
		} catch (e) {
			return false; // not a function
		}
	};

	var tryFunctionObject = function tryFunctionToStr(value) {
		try {
			if (isES6ClassFn(value)) { return false; }
			fnToStr.call(value);
			return true;
		} catch (e) {
			return false;
		}
	};
	var toStr = Object.prototype.toString;
	var objectClass = '[object Object]';
	var fnClass = '[object Function]';
	var genClass = '[object GeneratorFunction]';
	var ddaClass = '[object HTMLAllCollection]'; // IE 11
	var ddaClass2 = '[object HTML document.all class]';
	var ddaClass3 = '[object HTMLCollection]'; // IE 9-10
	var hasToStringTag = typeof Symbol === 'function' && !!Symbol.toStringTag; // better: use `has-tostringtag`

	var isIE68 = !(0 in [,]); // eslint-disable-line no-sparse-arrays, comma-spacing

	var isDDA = function isDocumentDotAll() { return false; };
	if (typeof document === 'object') {
		// Firefox 3 canonicalizes DDA to undefined when it's not accessed directly
		var all = document.all;
		if (toStr.call(all) === toStr.call(document.all)) {
			isDDA = function isDocumentDotAll(value) {
				/* globals document: false */
				// in IE 6-8, typeof document.all is "object" and it's truthy
				if ((isIE68 || !value) && (typeof value === 'undefined' || typeof value === 'object')) {
					try {
						var str = toStr.call(value);
						return (
							str === ddaClass
							|| str === ddaClass2
							|| str === ddaClass3 // opera 12.16
							|| str === objectClass // IE 6-8
						) && value('') == null; // eslint-disable-line eqeqeq
					} catch (e) { /**/ }
				}
				return false;
			};
		}
	}

	isCallable = reflectApply
		? function isCallable(value) {
			if (isDDA(value)) { return true; }
			if (!value) { return false; }
			if (typeof value !== 'function' && typeof value !== 'object') { return false; }
			try {
				reflectApply(value, null, badArrayLike);
			} catch (e) {
				if (e !== isCallableMarker) { return false; }
			}
			return !isES6ClassFn(value) && tryFunctionObject(value);
		}
		: function isCallable(value) {
			if (isDDA(value)) { return true; }
			if (!value) { return false; }
			if (typeof value !== 'function' && typeof value !== 'object') { return false; }
			if (hasToStringTag) { return tryFunctionObject(value); }
			if (isES6ClassFn(value)) { return false; }
			var strClass = toStr.call(value);
			if (strClass !== fnClass && strClass !== genClass && !(/^\[object HTML/).test(strClass)) { return false; }
			return tryFunctionObject(value);
		};
	return isCallable;
}

var forEach$1;
var hasRequiredForEach$1;

function requireForEach$1 () {
	if (hasRequiredForEach$1) return forEach$1;
	hasRequiredForEach$1 = 1;

	var isCallable = requireIsCallable();

	var toStr = Object.prototype.toString;
	var hasOwnProperty = Object.prototype.hasOwnProperty;

	/** @type {<This, A extends readonly unknown[]>(arr: A, iterator: (this: This | void, value: A[number], index: number, arr: A) => void, receiver: This | undefined) => void} */
	var forEachArray = function forEachArray(array, iterator, receiver) {
	    for (var i = 0, len = array.length; i < len; i++) {
	        if (hasOwnProperty.call(array, i)) {
	            if (receiver == null) {
	                iterator(array[i], i, array);
	            } else {
	                iterator.call(receiver, array[i], i, array);
	            }
	        }
	    }
	};

	/** @type {<This, S extends string>(string: S, iterator: (this: This | void, value: S[number], index: number, string: S) => void, receiver: This | undefined) => void} */
	var forEachString = function forEachString(string, iterator, receiver) {
	    for (var i = 0, len = string.length; i < len; i++) {
	        // no such thing as a sparse string.
	        if (receiver == null) {
	            iterator(string.charAt(i), i, string);
	        } else {
	            iterator.call(receiver, string.charAt(i), i, string);
	        }
	    }
	};

	/** @type {<This, O>(obj: O, iterator: (this: This | void, value: O[keyof O], index: keyof O, obj: O) => void, receiver: This | undefined) => void} */
	var forEachObject = function forEachObject(object, iterator, receiver) {
	    for (var k in object) {
	        if (hasOwnProperty.call(object, k)) {
	            if (receiver == null) {
	                iterator(object[k], k, object);
	            } else {
	                iterator.call(receiver, object[k], k, object);
	            }
	        }
	    }
	};

	/** @type {(x: unknown) => x is readonly unknown[]} */
	function isArray(x) {
	    return toStr.call(x) === '[object Array]';
	}

	/** @type {import('.')._internal} */
	forEach$1 = function forEach(list, iterator, thisArg) {
	    if (!isCallable(iterator)) {
	        throw new TypeError('iterator must be a function');
	    }

	    var receiver;
	    if (arguments.length >= 3) {
	        receiver = thisArg;
	    }

	    if (isArray(list)) {
	        forEachArray(list, iterator, receiver);
	    } else if (typeof list === 'string') {
	        forEachString(list, iterator, receiver);
	    } else {
	        forEachObject(list, iterator, receiver);
	    }
	};
	return forEach$1;
}

var possibleTypedArrayNames;
var hasRequiredPossibleTypedArrayNames;

function requirePossibleTypedArrayNames () {
	if (hasRequiredPossibleTypedArrayNames) return possibleTypedArrayNames;
	hasRequiredPossibleTypedArrayNames = 1;

	/** @type {import('.')} */
	possibleTypedArrayNames = [
		'Float16Array',
		'Float32Array',
		'Float64Array',
		'Int8Array',
		'Int16Array',
		'Int32Array',
		'Uint8Array',
		'Uint8ClampedArray',
		'Uint16Array',
		'Uint32Array',
		'BigInt64Array',
		'BigUint64Array'
	];
	return possibleTypedArrayNames;
}

var availableTypedArrays;
var hasRequiredAvailableTypedArrays;

function requireAvailableTypedArrays () {
	if (hasRequiredAvailableTypedArrays) return availableTypedArrays;
	hasRequiredAvailableTypedArrays = 1;

	var possibleNames = /*@__PURE__*/ requirePossibleTypedArrayNames();

	var g = typeof globalThis === 'undefined' ? commonjsGlobal : globalThis;

	/** @type {import('.')} */
	availableTypedArrays = function availableTypedArrays() {
		var /** @type {ReturnType<typeof availableTypedArrays>} */ out = [];
		for (var i = 0; i < possibleNames.length; i++) {
			if (typeof g[possibleNames[i]] === 'function') {
				// @ts-expect-error
				out[out.length] = possibleNames[i];
			}
		}
		return out;
	};
	return availableTypedArrays;
}

var callBind = {exports: {}};

var defineDataProperty;
var hasRequiredDefineDataProperty;

function requireDefineDataProperty () {
	if (hasRequiredDefineDataProperty) return defineDataProperty;
	hasRequiredDefineDataProperty = 1;

	var $defineProperty = /*@__PURE__*/ requireEsDefineProperty();

	var $SyntaxError = /*@__PURE__*/ requireSyntax();
	var $TypeError = /*@__PURE__*/ requireType();

	var gopd = /*@__PURE__*/ requireGopd();

	/** @type {import('.')} */
	defineDataProperty = function defineDataProperty(
		obj,
		property,
		value
	) {
		if (!obj || (typeof obj !== 'object' && typeof obj !== 'function')) {
			throw new $TypeError('`obj` must be an object or a function`');
		}
		if (typeof property !== 'string' && typeof property !== 'symbol') {
			throw new $TypeError('`property` must be a string or a symbol`');
		}
		if (arguments.length > 3 && typeof arguments[3] !== 'boolean' && arguments[3] !== null) {
			throw new $TypeError('`nonEnumerable`, if provided, must be a boolean or null');
		}
		if (arguments.length > 4 && typeof arguments[4] !== 'boolean' && arguments[4] !== null) {
			throw new $TypeError('`nonWritable`, if provided, must be a boolean or null');
		}
		if (arguments.length > 5 && typeof arguments[5] !== 'boolean' && arguments[5] !== null) {
			throw new $TypeError('`nonConfigurable`, if provided, must be a boolean or null');
		}
		if (arguments.length > 6 && typeof arguments[6] !== 'boolean') {
			throw new $TypeError('`loose`, if provided, must be a boolean');
		}

		var nonEnumerable = arguments.length > 3 ? arguments[3] : null;
		var nonWritable = arguments.length > 4 ? arguments[4] : null;
		var nonConfigurable = arguments.length > 5 ? arguments[5] : null;
		var loose = arguments.length > 6 ? arguments[6] : false;

		/* @type {false | TypedPropertyDescriptor<unknown>} */
		var desc = !!gopd && gopd(obj, property);

		if ($defineProperty) {
			$defineProperty(obj, property, {
				configurable: nonConfigurable === null && desc ? desc.configurable : !nonConfigurable,
				enumerable: nonEnumerable === null && desc ? desc.enumerable : !nonEnumerable,
				value: value,
				writable: nonWritable === null && desc ? desc.writable : !nonWritable
			});
		} else if (loose || (!nonEnumerable && !nonWritable && !nonConfigurable)) {
			// must fall back to [[Set]], and was not explicitly asked to make non-enumerable, non-writable, or non-configurable
			obj[property] = value; // eslint-disable-line no-param-reassign
		} else {
			throw new $SyntaxError('This environment does not support defining a property as non-configurable, non-writable, or non-enumerable.');
		}
	};
	return defineDataProperty;
}

var hasPropertyDescriptors_1;
var hasRequiredHasPropertyDescriptors;

function requireHasPropertyDescriptors () {
	if (hasRequiredHasPropertyDescriptors) return hasPropertyDescriptors_1;
	hasRequiredHasPropertyDescriptors = 1;

	var $defineProperty = /*@__PURE__*/ requireEsDefineProperty();

	var hasPropertyDescriptors = function hasPropertyDescriptors() {
		return !!$defineProperty;
	};

	hasPropertyDescriptors.hasArrayLengthDefineBug = function hasArrayLengthDefineBug() {
		// node v0.6 has a bug where array lengths can be Set but not Defined
		if (!$defineProperty) {
			return null;
		}
		try {
			return $defineProperty([], 'length', { value: 1 }).length !== 1;
		} catch (e) {
			// In Firefox 4-22, defining length on an array throws an exception.
			return true;
		}
	};

	hasPropertyDescriptors_1 = hasPropertyDescriptors;
	return hasPropertyDescriptors_1;
}

var setFunctionLength;
var hasRequiredSetFunctionLength;

function requireSetFunctionLength () {
	if (hasRequiredSetFunctionLength) return setFunctionLength;
	hasRequiredSetFunctionLength = 1;

	var GetIntrinsic = /*@__PURE__*/ requireGetIntrinsic();
	var define = /*@__PURE__*/ requireDefineDataProperty();
	var hasDescriptors = /*@__PURE__*/ requireHasPropertyDescriptors()();
	var gOPD = /*@__PURE__*/ requireGopd();

	var $TypeError = /*@__PURE__*/ requireType();
	var $floor = GetIntrinsic('%Math.floor%');

	/** @type {import('.')} */
	setFunctionLength = function setFunctionLength(fn, length) {
		if (typeof fn !== 'function') {
			throw new $TypeError('`fn` is not a function');
		}
		if (typeof length !== 'number' || length < 0 || length > 0xFFFFFFFF || $floor(length) !== length) {
			throw new $TypeError('`length` must be a positive 32-bit integer');
		}

		var loose = arguments.length > 2 && !!arguments[2];

		var functionLengthIsConfigurable = true;
		var functionLengthIsWritable = true;
		if ('length' in fn && gOPD) {
			var desc = gOPD(fn, 'length');
			if (desc && !desc.configurable) {
				functionLengthIsConfigurable = false;
			}
			if (desc && !desc.writable) {
				functionLengthIsWritable = false;
			}
		}

		if (functionLengthIsConfigurable || functionLengthIsWritable || !loose) {
			if (hasDescriptors) {
				define(/** @type {Parameters<define>[0]} */ (fn), 'length', length, true, true);
			} else {
				define(/** @type {Parameters<define>[0]} */ (fn), 'length', length);
			}
		}
		return fn;
	};
	return setFunctionLength;
}

var applyBind;
var hasRequiredApplyBind;

function requireApplyBind () {
	if (hasRequiredApplyBind) return applyBind;
	hasRequiredApplyBind = 1;

	var bind = requireFunctionBind();
	var $apply = requireFunctionApply();
	var actualApply = requireActualApply();

	/** @type {import('./applyBind')} */
	applyBind = function applyBind() {
		return actualApply(bind, $apply, arguments);
	};
	return applyBind;
}

var hasRequiredCallBind;

function requireCallBind () {
	if (hasRequiredCallBind) return callBind.exports;
	hasRequiredCallBind = 1;
	(function (module) {

		var setFunctionLength = /*@__PURE__*/ requireSetFunctionLength();

		var $defineProperty = /*@__PURE__*/ requireEsDefineProperty();

		var callBindBasic = requireCallBindApplyHelpers();
		var applyBind = requireApplyBind();

		module.exports = function callBind(originalFunction) {
			var func = callBindBasic(arguments);
			var adjustedLength = originalFunction.length - (arguments.length - 1);
			return setFunctionLength(
				func,
				1 + (adjustedLength > 0 ? adjustedLength : 0),
				true
			);
		};

		if ($defineProperty) {
			$defineProperty(module.exports, 'apply', { value: applyBind });
		} else {
			module.exports.apply = applyBind;
		} 
	} (callBind));
	return callBind.exports;
}

var shams;
var hasRequiredShams;

function requireShams () {
	if (hasRequiredShams) return shams;
	hasRequiredShams = 1;

	var hasSymbols = requireShams$1();

	/** @type {import('.')} */
	shams = function hasToStringTagShams() {
		return hasSymbols() && !!Symbol.toStringTag;
	};
	return shams;
}

var whichTypedArray;
var hasRequiredWhichTypedArray;

function requireWhichTypedArray () {
	if (hasRequiredWhichTypedArray) return whichTypedArray;
	hasRequiredWhichTypedArray = 1;

	var forEach = requireForEach$1();
	var availableTypedArrays = /*@__PURE__*/ requireAvailableTypedArrays();
	var callBind = requireCallBind();
	var callBound = /*@__PURE__*/ requireCallBound();
	var gOPD = /*@__PURE__*/ requireGopd();
	var getProto = requireGetProto();

	var $toString = callBound('Object.prototype.toString');
	var hasToStringTag = requireShams()();

	var g = typeof globalThis === 'undefined' ? commonjsGlobal : globalThis;
	var typedArrays = availableTypedArrays();

	var $slice = callBound('String.prototype.slice');

	/** @type {<T = unknown>(array: readonly T[], value: unknown) => number} */
	var $indexOf = callBound('Array.prototype.indexOf', true) || function indexOf(array, value) {
		for (var i = 0; i < array.length; i += 1) {
			if (array[i] === value) {
				return i;
			}
		}
		return -1;
	};

	/** @typedef {import('./types').Getter} Getter */
	/** @type {import('./types').Cache} */
	var cache = { __proto__: null };
	if (hasToStringTag && gOPD && getProto) {
		forEach(typedArrays, function (typedArray) {
			var arr = new g[typedArray]();
			if (Symbol.toStringTag in arr && getProto) {
				var proto = getProto(arr);
				// @ts-expect-error TS won't narrow inside a closure
				var descriptor = gOPD(proto, Symbol.toStringTag);
				if (!descriptor && proto) {
					var superProto = getProto(proto);
					// @ts-expect-error TS won't narrow inside a closure
					descriptor = gOPD(superProto, Symbol.toStringTag);
				}
				// @ts-expect-error TODO: fix
				cache['$' + typedArray] = callBind(descriptor.get);
			}
		});
	} else {
		forEach(typedArrays, function (typedArray) {
			var arr = new g[typedArray]();
			var fn = arr.slice || arr.set;
			if (fn) {
				cache[
					/** @type {`$${import('.').TypedArrayName}`} */ ('$' + typedArray)
				] = /** @type {import('./types').BoundSlice | import('./types').BoundSet} */ (
					// @ts-expect-error TODO FIXME
					callBind(fn)
				);
			}
		});
	}

	/** @type {(value: object) => false | import('.').TypedArrayName} */
	var tryTypedArrays = function tryAllTypedArrays(value) {
		/** @type {ReturnType<typeof tryAllTypedArrays>} */ var found = false;
		forEach(
			/** @type {Record<`\$${import('.').TypedArrayName}`, Getter>} */ (cache),
			/** @type {(getter: Getter, name: `\$${import('.').TypedArrayName}`) => void} */
			function (getter, typedArray) {
				if (!found) {
					try {
						// @ts-expect-error a throw is fine here
						if ('$' + getter(value) === typedArray) {
							found = /** @type {import('.').TypedArrayName} */ ($slice(typedArray, 1));
						}
					} catch (e) { /**/ }
				}
			}
		);
		return found;
	};

	/** @type {(value: object) => false | import('.').TypedArrayName} */
	var trySlices = function tryAllSlices(value) {
		/** @type {ReturnType<typeof tryAllSlices>} */ var found = false;
		forEach(
			/** @type {Record<`\$${import('.').TypedArrayName}`, Getter>} */(cache),
			/** @type {(getter: Getter, name: `\$${import('.').TypedArrayName}`) => void} */ function (getter, name) {
				if (!found) {
					try {
						// @ts-expect-error a throw is fine here
						getter(value);
						found = /** @type {import('.').TypedArrayName} */ ($slice(name, 1));
					} catch (e) { /**/ }
				}
			}
		);
		return found;
	};

	/** @type {import('.')} */
	whichTypedArray = function whichTypedArray(value) {
		if (!value || typeof value !== 'object') { return false; }
		if (!hasToStringTag) {
			/** @type {string} */
			var tag = $slice($toString(value), 8, -1);
			if ($indexOf(typedArrays, tag) > -1) {
				return tag;
			}
			if (tag !== 'Object') {
				return false;
			}
			// node < 0.6 hits here on real Typed Arrays
			return trySlices(value);
		}
		if (!gOPD) { return null; } // unknown engine
		return tryTypedArrays(value);
	};
	return whichTypedArray;
}

var isTypedArray;
var hasRequiredIsTypedArray;

function requireIsTypedArray () {
	if (hasRequiredIsTypedArray) return isTypedArray;
	hasRequiredIsTypedArray = 1;

	var whichTypedArray = /*@__PURE__*/ requireWhichTypedArray();

	/** @type {import('.')} */
	isTypedArray = function isTypedArray(value) {
		return !!whichTypedArray(value);
	};
	return isTypedArray;
}

var typedArrayBuffer;
var hasRequiredTypedArrayBuffer;

function requireTypedArrayBuffer () {
	if (hasRequiredTypedArrayBuffer) return typedArrayBuffer;
	hasRequiredTypedArrayBuffer = 1;

	var $TypeError = /*@__PURE__*/ requireType();

	var callBound = /*@__PURE__*/ requireCallBound();

	/** @type {undefined | ((thisArg: import('.').TypedArray) => Buffer<ArrayBufferLike>)} */
	var $typedArrayBuffer = callBound('TypedArray.prototype.buffer', true);

	var isTypedArray = /*@__PURE__*/ requireIsTypedArray();

	/** @type {import('.')} */
	// node <= 0.10, < 0.11.4 has a nonconfigurable own property instead of a prototype getter
	typedArrayBuffer = $typedArrayBuffer || function typedArrayBuffer(x) {
		if (!isTypedArray(x)) {
			throw new $TypeError('Not a Typed Array');
		}
		return x.buffer;
	};
	return typedArrayBuffer;
}

var toBuffer$1;
var hasRequiredToBuffer;

function requireToBuffer () {
	if (hasRequiredToBuffer) return toBuffer$1;
	hasRequiredToBuffer = 1;

	var Buffer = requireSafeBuffer().Buffer;
	var isArray = requireIsarray();
	var typedArrayBuffer = /*@__PURE__*/ requireTypedArrayBuffer();

	var isView = ArrayBuffer.isView || function isView(obj) {
		try {
			typedArrayBuffer(obj);
			return true;
		} catch (e) {
			return false;
		}
	};

	var useUint8Array = typeof Uint8Array !== 'undefined';
	var useArrayBuffer = typeof ArrayBuffer !== 'undefined'
		&& typeof Uint8Array !== 'undefined';
	var useFromArrayBuffer = useArrayBuffer && (Buffer.prototype instanceof Uint8Array || Buffer.TYPED_ARRAY_SUPPORT);

	toBuffer$1 = function toBuffer(data, encoding) {
		if (Buffer.isBuffer(data)) {
			if (data.constructor && !('isBuffer' in data)) {
				// probably a SlowBuffer
				return Buffer.from(data);
			}
			return data;
		}

		if (typeof data === 'string') {
			return Buffer.from(data, encoding);
		}

		/*
		 * Wrap any TypedArray instances and DataViews
		 * Makes sense only on engines with full TypedArray support -- let Buffer detect that
		 */
		if (useArrayBuffer && isView(data)) {
			// Bug in Node.js <6.3.1, which treats this as out-of-bounds
			if (data.byteLength === 0) {
				return Buffer.alloc(0);
			}

			// When Buffer is based on Uint8Array, we can just construct it from ArrayBuffer
			if (useFromArrayBuffer) {
				var res = Buffer.from(data.buffer, data.byteOffset, data.byteLength);
				/*
				 * Recheck result size, as offset/length doesn't work on Node.js <5.10
				 * We just go to Uint8Array case if this fails
				 */
				if (res.byteLength === data.byteLength) {
					return res;
				}
			}

			// Convert to Uint8Array bytes and then to Buffer
			var uint8 = data instanceof Uint8Array ? data : new Uint8Array(data.buffer, data.byteOffset, data.byteLength);
			var result = Buffer.from(uint8);

			/*
			 * Let's recheck that conversion succeeded
			 * We have .length but not .byteLength when useFromArrayBuffer is false
			 */
			if (result.length === data.byteLength) {
				return result;
			}
		}

		/*
		 * Uint8Array in engines where Buffer.from might not work with ArrayBuffer, just copy over
		 * Doesn't make sense with other TypedArray instances
		 */
		if (useUint8Array && data instanceof Uint8Array) {
			return Buffer.from(data);
		}

		var isArr = isArray(data);
		if (isArr) {
			for (var i = 0; i < data.length; i += 1) {
				var x = data[i];
				if (
					typeof x !== 'number'
					|| x < 0
					|| x > 255
					|| ~~x !== x // NaN and integer check
				) {
					throw new RangeError('Array items must be numbers in the range 0-255.');
				}
			}
		}

		/*
		 * Old Buffer polyfill on an engine that doesn't have TypedArray support
		 * Also, this is from a different Buffer polyfill implementation then we have, as instanceof check failed
		 * Convert to our current Buffer implementation
		 */
		if (
			isArr || (
				Buffer.isBuffer(data)
				&& data.constructor
				&& typeof data.constructor.isBuffer === 'function'
				&& data.constructor.isBuffer(data)
			)
		) {
			return Buffer.from(data);
		}

		throw new TypeError('The "data" argument must be a string, an Array, a Buffer, a Uint8Array, or a DataView.');
	};
	return toBuffer$1;
}

/* Node.js 6.4.0 and up has full support */

var bufferFill;
var hasRequiredBufferFill;

function requireBufferFill () {
	if (hasRequiredBufferFill) return bufferFill;
	hasRequiredBufferFill = 1;
	var hasFullSupport = (function () {
	  try {
	    if (!Buffer.isEncoding('latin1')) {
	      return false
	    }

	    var buf = Buffer.alloc ? Buffer.alloc(4) : new Buffer(4);

	    buf.fill('ab', 'ucs2');

	    return (buf.toString('hex') === '61006200')
	  } catch (_) {
	    return false
	  }
	}());

	function isSingleByte (val) {
	  return (val.length === 1 && val.charCodeAt(0) < 256)
	}

	function fillWithNumber (buffer, val, start, end) {
	  if (start < 0 || end > buffer.length) {
	    throw new RangeError('Out of range index')
	  }

	  start = start >>> 0;
	  end = end === undefined ? buffer.length : end >>> 0;

	  if (end > start) {
	    buffer.fill(val, start, end);
	  }

	  return buffer
	}

	function fillWithBuffer (buffer, val, start, end) {
	  if (start < 0 || end > buffer.length) {
	    throw new RangeError('Out of range index')
	  }

	  if (end <= start) {
	    return buffer
	  }

	  start = start >>> 0;
	  end = end === undefined ? buffer.length : end >>> 0;

	  var pos = start;
	  var len = val.length;
	  while (pos <= (end - len)) {
	    val.copy(buffer, pos);
	    pos += len;
	  }

	  if (pos !== end) {
	    val.copy(buffer, pos, 0, end - pos);
	  }

	  return buffer
	}

	function fill (buffer, val, start, end, encoding) {
	  if (hasFullSupport) {
	    return buffer.fill(val, start, end, encoding)
	  }

	  if (typeof val === 'number') {
	    return fillWithNumber(buffer, val, start, end)
	  }

	  if (typeof val === 'string') {
	    if (typeof start === 'string') {
	      encoding = start;
	      start = 0;
	      end = buffer.length;
	    } else if (typeof end === 'string') {
	      encoding = end;
	      end = buffer.length;
	    }

	    if (encoding !== undefined && typeof encoding !== 'string') {
	      throw new TypeError('encoding must be a string')
	    }

	    if (encoding === 'latin1') {
	      encoding = 'binary';
	    }

	    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
	      throw new TypeError('Unknown encoding: ' + encoding)
	    }

	    if (val === '') {
	      return fillWithNumber(buffer, 0, start, end)
	    }

	    if (isSingleByte(val)) {
	      return fillWithNumber(buffer, val.charCodeAt(0), start, end)
	    }

	    val = new Buffer(val, encoding);
	  }

	  if (Buffer.isBuffer(val)) {
	    return fillWithBuffer(buffer, val, start, end)
	  }

	  // Other values (e.g. undefined, boolean, object) results in zero-fill
	  return fillWithNumber(buffer, 0, start, end)
	}

	bufferFill = fill;
	return bufferFill;
}

var bufferAllocUnsafe;
var hasRequiredBufferAllocUnsafe;

function requireBufferAllocUnsafe () {
	if (hasRequiredBufferAllocUnsafe) return bufferAllocUnsafe;
	hasRequiredBufferAllocUnsafe = 1;
	function allocUnsafe (size) {
	  if (typeof size !== 'number') {
	    throw new TypeError('"size" argument must be a number')
	  }

	  if (size < 0) {
	    throw new RangeError('"size" argument must not be negative')
	  }

	  if (Buffer.allocUnsafe) {
	    return Buffer.allocUnsafe(size)
	  } else {
	    return new Buffer(size)
	  }
	}

	bufferAllocUnsafe = allocUnsafe;
	return bufferAllocUnsafe;
}

var bufferAlloc;
var hasRequiredBufferAlloc;

function requireBufferAlloc () {
	if (hasRequiredBufferAlloc) return bufferAlloc;
	hasRequiredBufferAlloc = 1;
	var bufferFill = requireBufferFill();
	var allocUnsafe = requireBufferAllocUnsafe();

	bufferAlloc = function alloc (size, fill, encoding) {
	  if (typeof size !== 'number') {
	    throw new TypeError('"size" argument must be a number')
	  }

	  if (size < 0) {
	    throw new RangeError('"size" argument must not be negative')
	  }

	  if (Buffer.alloc) {
	    return Buffer.alloc(size, fill, encoding)
	  }

	  var buffer = allocUnsafe(size);

	  if (size === 0) {
	    return buffer
	  }

	  if (fill === undefined) {
	    return bufferFill(buffer, 0)
	  }

	  if (typeof encoding !== 'string') {
	    encoding = undefined;
	  }

	  return bufferFill(buffer, fill, encoding)
	};
	return bufferAlloc;
}

var hasRequiredHeaders;

function requireHeaders () {
	if (hasRequiredHeaders) return headers;
	hasRequiredHeaders = 1;
	var toBuffer = /*@__PURE__*/ requireToBuffer();
	var alloc = requireBufferAlloc();

	var ZEROS = '0000000000000000000';
	var SEVENS = '7777777777777777777';
	var ZERO_OFFSET = '0'.charCodeAt(0);
	var USTAR = 'ustar\x0000';
	var MASK = parseInt('7777', 8);

	var clamp = function (index, len, defaultValue) {
	  if (typeof index !== 'number') return defaultValue
	  index = ~~index; // Coerce to integer.
	  if (index >= len) return len
	  if (index >= 0) return index
	  index += len;
	  if (index >= 0) return index
	  return 0
	};

	var toType = function (flag) {
	  switch (flag) {
	    case 0:
	      return 'file'
	    case 1:
	      return 'link'
	    case 2:
	      return 'symlink'
	    case 3:
	      return 'character-device'
	    case 4:
	      return 'block-device'
	    case 5:
	      return 'directory'
	    case 6:
	      return 'fifo'
	    case 7:
	      return 'contiguous-file'
	    case 72:
	      return 'pax-header'
	    case 55:
	      return 'pax-global-header'
	    case 27:
	      return 'gnu-long-link-path'
	    case 28:
	    case 30:
	      return 'gnu-long-path'
	  }

	  return null
	};

	var toTypeflag = function (flag) {
	  switch (flag) {
	    case 'file':
	      return 0
	    case 'link':
	      return 1
	    case 'symlink':
	      return 2
	    case 'character-device':
	      return 3
	    case 'block-device':
	      return 4
	    case 'directory':
	      return 5
	    case 'fifo':
	      return 6
	    case 'contiguous-file':
	      return 7
	    case 'pax-header':
	      return 72
	  }

	  return 0
	};

	var indexOf = function (block, num, offset, end) {
	  for (; offset < end; offset++) {
	    if (block[offset] === num) return offset
	  }
	  return end
	};

	var cksum = function (block) {
	  var sum = 8 * 32;
	  for (var i = 0; i < 148; i++) sum += block[i];
	  for (var j = 156; j < 512; j++) sum += block[j];
	  return sum
	};

	var encodeOct = function (val, n) {
	  val = val.toString(8);
	  if (val.length > n) return SEVENS.slice(0, n) + ' '
	  else return ZEROS.slice(0, n - val.length) + val + ' '
	};

	/* Copied from the node-tar repo and modified to meet
	 * tar-stream coding standard.
	 *
	 * Source: https://github.com/npm/node-tar/blob/51b6627a1f357d2eb433e7378e5f05e83b7aa6cd/lib/header.js#L349
	 */
	function parse256 (buf) {
	  // first byte MUST be either 80 or FF
	  // 80 for positive, FF for 2's comp
	  var positive;
	  if (buf[0] === 0x80) positive = true;
	  else if (buf[0] === 0xFF) positive = false;
	  else return null
	  var tuple = [];
	  for (var i = buf.length - 1; i > 0; i--) {
	    var byte = buf[i];
	    if (positive) tuple.push(byte);
	    else tuple.push(0xFF - byte);
	  }

	  var sum = 0;
	  var l = tuple.length;
	  for (i = 0; i < l; i++) {
	    sum += tuple[i] * Math.pow(256, i);
	  }

	  return positive ? sum : -1 * sum
	}

	var decodeOct = function (val, offset, length) {
	  val = val.slice(offset, offset + length);
	  offset = 0;

	  // If prefixed with 0x80 then parse as a base-256 integer
	  if (val[offset] & 0x80) {
	    return parse256(val)
	  } else {
	    // Older versions of tar can prefix with spaces
	    while (offset < val.length && val[offset] === 32) offset++;
	    var end = clamp(indexOf(val, 32, offset, val.length), val.length, val.length);
	    while (offset < end && val[offset] === 0) offset++;
	    if (end === offset) return 0
	    return parseInt(val.slice(offset, end).toString(), 8)
	  }
	};

	var decodeStr = function (val, offset, length, encoding) {
	  return val.slice(offset, indexOf(val, 0, offset, offset + length)).toString(encoding)
	};

	var addLength = function (str) {
	  var len = Buffer.byteLength(str);
	  var digits = Math.floor(Math.log(len) / Math.log(10)) + 1;
	  if (len + digits >= Math.pow(10, digits)) digits++;

	  return (len + digits) + str
	};

	headers.decodeLongPath = function (buf, encoding) {
	  return decodeStr(buf, 0, buf.length, encoding)
	};

	headers.encodePax = function (opts) { // TODO: encode more stuff in pax
	  var result = '';
	  if (opts.name) result += addLength(' path=' + opts.name + '\n');
	  if (opts.linkname) result += addLength(' linkpath=' + opts.linkname + '\n');
	  var pax = opts.pax;
	  if (pax) {
	    for (var key in pax) {
	      result += addLength(' ' + key + '=' + pax[key] + '\n');
	    }
	  }
	  return toBuffer(result)
	};

	headers.decodePax = function (buf) {
	  var result = {};

	  while (buf.length) {
	    var i = 0;
	    while (i < buf.length && buf[i] !== 32) i++;
	    var len = parseInt(buf.slice(0, i).toString(), 10);
	    if (!len) return result

	    var b = buf.slice(i + 1, len - 1).toString();
	    var keyIndex = b.indexOf('=');
	    if (keyIndex === -1) return result
	    result[b.slice(0, keyIndex)] = b.slice(keyIndex + 1);

	    buf = buf.slice(len);
	  }

	  return result
	};

	headers.encode = function (opts) {
	  var buf = alloc(512);
	  var name = opts.name;
	  var prefix = '';

	  if (opts.typeflag === 5 && name[name.length - 1] !== '/') name += '/';
	  if (Buffer.byteLength(name) !== name.length) return null // utf-8

	  while (Buffer.byteLength(name) > 100) {
	    var i = name.indexOf('/');
	    if (i === -1) return null
	    prefix += prefix ? '/' + name.slice(0, i) : name.slice(0, i);
	    name = name.slice(i + 1);
	  }

	  if (Buffer.byteLength(name) > 100 || Buffer.byteLength(prefix) > 155) return null
	  if (opts.linkname && Buffer.byteLength(opts.linkname) > 100) return null

	  buf.write(name);
	  buf.write(encodeOct(opts.mode & MASK, 6), 100);
	  buf.write(encodeOct(opts.uid, 6), 108);
	  buf.write(encodeOct(opts.gid, 6), 116);
	  buf.write(encodeOct(opts.size, 11), 124);
	  buf.write(encodeOct((opts.mtime.getTime() / 1000) | 0, 11), 136);

	  buf[156] = ZERO_OFFSET + toTypeflag(opts.type);

	  if (opts.linkname) buf.write(opts.linkname, 157);

	  buf.write(USTAR, 257);
	  if (opts.uname) buf.write(opts.uname, 265);
	  if (opts.gname) buf.write(opts.gname, 297);
	  buf.write(encodeOct(opts.devmajor || 0, 6), 329);
	  buf.write(encodeOct(opts.devminor || 0, 6), 337);

	  if (prefix) buf.write(prefix, 345);

	  buf.write(encodeOct(cksum(buf), 6), 148);

	  return buf
	};

	headers.decode = function (buf, filenameEncoding) {
	  var typeflag = buf[156] === 0 ? 0 : buf[156] - ZERO_OFFSET;

	  var name = decodeStr(buf, 0, 100, filenameEncoding);
	  var mode = decodeOct(buf, 100, 8);
	  var uid = decodeOct(buf, 108, 8);
	  var gid = decodeOct(buf, 116, 8);
	  var size = decodeOct(buf, 124, 12);
	  var mtime = decodeOct(buf, 136, 12);
	  var type = toType(typeflag);
	  var linkname = buf[157] === 0 ? null : decodeStr(buf, 157, 100, filenameEncoding);
	  var uname = decodeStr(buf, 265, 32);
	  var gname = decodeStr(buf, 297, 32);
	  var devmajor = decodeOct(buf, 329, 8);
	  var devminor = decodeOct(buf, 337, 8);

	  if (buf[345]) name = decodeStr(buf, 345, 155, filenameEncoding) + '/' + name;

	  // to support old tar versions that use trailing / to indicate dirs
	  if (typeflag === 0 && name && name[name.length - 1] === '/') typeflag = 5;

	  var c = cksum(buf);

	  // checksum is still initial value if header was null.
	  if (c === 8 * 32) return null

	  // valid checksum
	  if (c !== decodeOct(buf, 148, 8)) throw new Error('Invalid tar header. Maybe the tar is corrupted or it needs to be gunzipped?')

	  return {
	    name: name,
	    mode: mode,
	    uid: uid,
	    gid: gid,
	    size: size,
	    mtime: new Date(1000 * mtime),
	    type: type,
	    linkname: linkname,
	    uname: uname,
	    gname: gname,
	    devmajor: devmajor,
	    devminor: devminor
	  }
	};
	return headers;
}

var readableBrowser$1 = {exports: {}};

var _stream_transform$1;
var hasRequired_stream_transform$1;

function require_stream_transform$1 () {
	if (hasRequired_stream_transform$1) return _stream_transform$1;
	hasRequired_stream_transform$1 = 1;

	_stream_transform$1 = Transform;

	var Duplex = require_stream_duplex$1();

	/*<replacement>*/
	var util = Object.create(requireUtil$2());
	util.inherits = requireInherits_browser();
	/*</replacement>*/

	util.inherits(Transform, Duplex);

	function afterTransform(er, data) {
	  var ts = this._transformState;
	  ts.transforming = false;

	  var cb = ts.writecb;

	  if (!cb) {
	    return this.emit('error', new Error('write callback called multiple times'));
	  }

	  ts.writechunk = null;
	  ts.writecb = null;

	  if (data != null) // single equals check for both `null` and `undefined`
	    this.push(data);

	  cb(er);

	  var rs = this._readableState;
	  rs.reading = false;
	  if (rs.needReadable || rs.length < rs.highWaterMark) {
	    this._read(rs.highWaterMark);
	  }
	}

	function Transform(options) {
	  if (!(this instanceof Transform)) return new Transform(options);

	  Duplex.call(this, options);

	  this._transformState = {
	    afterTransform: afterTransform.bind(this),
	    needTransform: false,
	    transforming: false,
	    writecb: null,
	    writechunk: null,
	    writeencoding: null
	  };

	  // start out asking for a readable event once data is transformed.
	  this._readableState.needReadable = true;

	  // we have implemented the _read method, and done the other things
	  // that Readable wants before the first _read call, so unset the
	  // sync guard flag.
	  this._readableState.sync = false;

	  if (options) {
	    if (typeof options.transform === 'function') this._transform = options.transform;

	    if (typeof options.flush === 'function') this._flush = options.flush;
	  }

	  // When the writable side finishes, then flush out anything remaining.
	  this.on('prefinish', prefinish);
	}

	function prefinish() {
	  var _this = this;

	  if (typeof this._flush === 'function') {
	    this._flush(function (er, data) {
	      done(_this, er, data);
	    });
	  } else {
	    done(this, null, null);
	  }
	}

	Transform.prototype.push = function (chunk, encoding) {
	  this._transformState.needTransform = false;
	  return Duplex.prototype.push.call(this, chunk, encoding);
	};

	// This is the part where you do stuff!
	// override this function in implementation classes.
	// 'chunk' is an input chunk.
	//
	// Call `push(newChunk)` to pass along transformed output
	// to the readable side.  You may call 'push' zero or more times.
	//
	// Call `cb(err)` when you are done with this chunk.  If you pass
	// an error, then that'll put the hurt on the whole operation.  If you
	// never call cb(), then you'll never get another chunk.
	Transform.prototype._transform = function (chunk, encoding, cb) {
	  throw new Error('_transform() is not implemented');
	};

	Transform.prototype._write = function (chunk, encoding, cb) {
	  var ts = this._transformState;
	  ts.writecb = cb;
	  ts.writechunk = chunk;
	  ts.writeencoding = encoding;
	  if (!ts.transforming) {
	    var rs = this._readableState;
	    if (ts.needTransform || rs.needReadable || rs.length < rs.highWaterMark) this._read(rs.highWaterMark);
	  }
	};

	// Doesn't matter what the args are here.
	// _transform does all the work.
	// That we got here means that the readable side wants more data.
	Transform.prototype._read = function (n) {
	  var ts = this._transformState;

	  if (ts.writechunk !== null && ts.writecb && !ts.transforming) {
	    ts.transforming = true;
	    this._transform(ts.writechunk, ts.writeencoding, ts.afterTransform);
	  } else {
	    // mark that we need a transform, so that any data that comes in
	    // will get processed, now that we've asked for it.
	    ts.needTransform = true;
	  }
	};

	Transform.prototype._destroy = function (err, cb) {
	  var _this2 = this;

	  Duplex.prototype._destroy.call(this, err, function (err2) {
	    cb(err2);
	    _this2.emit('close');
	  });
	};

	function done(stream, er, data) {
	  if (er) return stream.emit('error', er);

	  if (data != null) // single equals check for both `null` and `undefined`
	    stream.push(data);

	  // if there's nothing in the write buffer, then that means
	  // that nothing more will ever be provided
	  if (stream._writableState.length) throw new Error('Calling transform done when ws.length != 0');

	  if (stream._transformState.transforming) throw new Error('Calling transform done when still transforming');

	  return stream.push(null);
	}
	return _stream_transform$1;
}

var _stream_passthrough$1;
var hasRequired_stream_passthrough$1;

function require_stream_passthrough$1 () {
	if (hasRequired_stream_passthrough$1) return _stream_passthrough$1;
	hasRequired_stream_passthrough$1 = 1;

	_stream_passthrough$1 = PassThrough;

	var Transform = require_stream_transform$1();

	/*<replacement>*/
	var util = Object.create(requireUtil$2());
	util.inherits = requireInherits_browser();
	/*</replacement>*/

	util.inherits(PassThrough, Transform);

	function PassThrough(options) {
	  if (!(this instanceof PassThrough)) return new PassThrough(options);

	  Transform.call(this, options);
	}

	PassThrough.prototype._transform = function (chunk, encoding, cb) {
	  cb(null, chunk);
	};
	return _stream_passthrough$1;
}

var hasRequiredReadableBrowser$1;

function requireReadableBrowser$1 () {
	if (hasRequiredReadableBrowser$1) return readableBrowser$1.exports;
	hasRequiredReadableBrowser$1 = 1;
	(function (module, exports$1) {
		exports$1 = module.exports = require_stream_readable$1();
		exports$1.Stream = exports$1;
		exports$1.Readable = exports$1;
		exports$1.Writable = require_stream_writable$1();
		exports$1.Duplex = require_stream_duplex$1();
		exports$1.Transform = require_stream_transform$1();
		exports$1.PassThrough = require_stream_passthrough$1(); 
	} (readableBrowser$1, readableBrowser$1.exports));
	return readableBrowser$1.exports;
}

var extract;
var hasRequiredExtract;

function requireExtract () {
	if (hasRequiredExtract) return extract;
	hasRequiredExtract = 1;
	var util = require$$0$6;
	var bl = requireBl();
	var xtend = requireImmutable();
	var headers = requireHeaders();

	var Writable = requireReadableBrowser$1().Writable;
	var PassThrough = requireReadableBrowser$1().PassThrough;

	var noop = function () {};

	var overflow = function (size) {
	  size &= 511;
	  return size && 512 - size
	};

	var emptyStream = function (self, offset) {
	  var s = new Source(self, offset);
	  s.end();
	  return s
	};

	var mixinPax = function (header, pax) {
	  if (pax.path) header.name = pax.path;
	  if (pax.linkpath) header.linkname = pax.linkpath;
	  if (pax.size) header.size = parseInt(pax.size, 10);
	  header.pax = pax;
	  return header
	};

	var Source = function (self, offset) {
	  this._parent = self;
	  this.offset = offset;
	  PassThrough.call(this);
	};

	util.inherits(Source, PassThrough);

	Source.prototype.destroy = function (err) {
	  this._parent.destroy(err);
	};

	var Extract = function (opts) {
	  if (!(this instanceof Extract)) return new Extract(opts)
	  Writable.call(this, opts);

	  opts = opts || {};

	  this._offset = 0;
	  this._buffer = bl();
	  this._missing = 0;
	  this._partial = false;
	  this._onparse = noop;
	  this._header = null;
	  this._stream = null;
	  this._overflow = null;
	  this._cb = null;
	  this._locked = false;
	  this._destroyed = false;
	  this._pax = null;
	  this._paxGlobal = null;
	  this._gnuLongPath = null;
	  this._gnuLongLinkPath = null;

	  var self = this;
	  var b = self._buffer;

	  var oncontinue = function () {
	    self._continue();
	  };

	  var onunlock = function (err) {
	    self._locked = false;
	    if (err) return self.destroy(err)
	    if (!self._stream) oncontinue();
	  };

	  var onstreamend = function () {
	    self._stream = null;
	    var drain = overflow(self._header.size);
	    if (drain) self._parse(drain, ondrain);
	    else self._parse(512, onheader);
	    if (!self._locked) oncontinue();
	  };

	  var ondrain = function () {
	    self._buffer.consume(overflow(self._header.size));
	    self._parse(512, onheader);
	    oncontinue();
	  };

	  var onpaxglobalheader = function () {
	    var size = self._header.size;
	    self._paxGlobal = headers.decodePax(b.slice(0, size));
	    b.consume(size);
	    onstreamend();
	  };

	  var onpaxheader = function () {
	    var size = self._header.size;
	    self._pax = headers.decodePax(b.slice(0, size));
	    if (self._paxGlobal) self._pax = xtend(self._paxGlobal, self._pax);
	    b.consume(size);
	    onstreamend();
	  };

	  var ongnulongpath = function () {
	    var size = self._header.size;
	    this._gnuLongPath = headers.decodeLongPath(b.slice(0, size), opts.filenameEncoding);
	    b.consume(size);
	    onstreamend();
	  };

	  var ongnulonglinkpath = function () {
	    var size = self._header.size;
	    this._gnuLongLinkPath = headers.decodeLongPath(b.slice(0, size), opts.filenameEncoding);
	    b.consume(size);
	    onstreamend();
	  };

	  var onheader = function () {
	    var offset = self._offset;
	    var header;
	    try {
	      header = self._header = headers.decode(b.slice(0, 512), opts.filenameEncoding);
	    } catch (err) {
	      self.emit('error', err);
	    }
	    b.consume(512);

	    if (!header) {
	      self._parse(512, onheader);
	      oncontinue();
	      return
	    }
	    if (header.type === 'gnu-long-path') {
	      self._parse(header.size, ongnulongpath);
	      oncontinue();
	      return
	    }
	    if (header.type === 'gnu-long-link-path') {
	      self._parse(header.size, ongnulonglinkpath);
	      oncontinue();
	      return
	    }
	    if (header.type === 'pax-global-header') {
	      self._parse(header.size, onpaxglobalheader);
	      oncontinue();
	      return
	    }
	    if (header.type === 'pax-header') {
	      self._parse(header.size, onpaxheader);
	      oncontinue();
	      return
	    }

	    if (self._gnuLongPath) {
	      header.name = self._gnuLongPath;
	      self._gnuLongPath = null;
	    }

	    if (self._gnuLongLinkPath) {
	      header.linkname = self._gnuLongLinkPath;
	      self._gnuLongLinkPath = null;
	    }

	    if (self._pax) {
	      self._header = header = mixinPax(header, self._pax);
	      self._pax = null;
	    }

	    self._locked = true;

	    if (!header.size || header.type === 'directory') {
	      self._parse(512, onheader);
	      self.emit('entry', header, emptyStream(self, offset), onunlock);
	      return
	    }

	    self._stream = new Source(self, offset);

	    self.emit('entry', header, self._stream, onunlock);
	    self._parse(header.size, onstreamend);
	    oncontinue();
	  };

	  this._onheader = onheader;
	  this._parse(512, onheader);
	};

	util.inherits(Extract, Writable);

	Extract.prototype.destroy = function (err) {
	  if (this._destroyed) return
	  this._destroyed = true;

	  if (err) this.emit('error', err);
	  this.emit('close');
	  if (this._stream) this._stream.emit('close');
	};

	Extract.prototype._parse = function (size, onparse) {
	  if (this._destroyed) return
	  this._offset += size;
	  this._missing = size;
	  if (onparse === this._onheader) this._partial = false;
	  this._onparse = onparse;
	};

	Extract.prototype._continue = function () {
	  if (this._destroyed) return
	  var cb = this._cb;
	  this._cb = noop;
	  if (this._overflow) this._write(this._overflow, undefined, cb);
	  else cb();
	};

	Extract.prototype._write = function (data, enc, cb) {
	  if (this._destroyed) return

	  var s = this._stream;
	  var b = this._buffer;
	  var missing = this._missing;
	  if (data.length) this._partial = true;

	  // we do not reach end-of-chunk now. just forward it

	  if (data.length < missing) {
	    this._missing -= data.length;
	    this._overflow = null;
	    if (s) return s.write(data, cb)
	    b.append(data);
	    return cb()
	  }

	  // end-of-chunk. the parser should call cb.

	  this._cb = cb;
	  this._missing = 0;

	  var overflow = null;
	  if (data.length > missing) {
	    overflow = data.slice(missing);
	    data = data.slice(0, missing);
	  }

	  if (s) s.end(data);
	  else b.append(data);

	  this._overflow = overflow;
	  this._onparse();
	};

	Extract.prototype._final = function (cb) {
	  if (this._partial) return this.destroy(new Error('Unexpected end of data'))
	  cb();
	};

	extract = Extract;
	return extract;
}

var browser$3;
var hasRequiredBrowser$3;

function requireBrowser$3 () {
	if (hasRequiredBrowser$3) return browser$3;
	hasRequiredBrowser$3 = 1;
	browser$3 = require$$0$7;
	return browser$3;
}

var pack;
var hasRequiredPack;

function requirePack () {
	if (hasRequiredPack) return pack;
	hasRequiredPack = 1;
	var constants = requireBrowser$3();
	var eos = requireEndOfStream$1();
	var util = require$$0$6;
	var alloc = requireBufferAlloc();
	var toBuffer = /*@__PURE__*/ requireToBuffer();

	var Readable = requireReadableBrowser$1().Readable;
	var Writable = requireReadableBrowser$1().Writable;
	var StringDecoder = require$$1$3.StringDecoder;

	var headers = requireHeaders();

	var DMODE = parseInt('755', 8);
	var FMODE = parseInt('644', 8);

	var END_OF_TAR = alloc(1024);

	var noop = function () {};

	var overflow = function (self, size) {
	  size &= 511;
	  if (size) self.push(END_OF_TAR.slice(0, 512 - size));
	};

	function modeToType (mode) {
	  switch (mode & constants.S_IFMT) {
	    case constants.S_IFBLK: return 'block-device'
	    case constants.S_IFCHR: return 'character-device'
	    case constants.S_IFDIR: return 'directory'
	    case constants.S_IFIFO: return 'fifo'
	    case constants.S_IFLNK: return 'symlink'
	  }

	  return 'file'
	}

	var Sink = function (to) {
	  Writable.call(this);
	  this.written = 0;
	  this._to = to;
	  this._destroyed = false;
	};

	util.inherits(Sink, Writable);

	Sink.prototype._write = function (data, enc, cb) {
	  this.written += data.length;
	  if (this._to.push(data)) return cb()
	  this._to._drain = cb;
	};

	Sink.prototype.destroy = function () {
	  if (this._destroyed) return
	  this._destroyed = true;
	  this.emit('close');
	};

	var LinkSink = function () {
	  Writable.call(this);
	  this.linkname = '';
	  this._decoder = new StringDecoder('utf-8');
	  this._destroyed = false;
	};

	util.inherits(LinkSink, Writable);

	LinkSink.prototype._write = function (data, enc, cb) {
	  this.linkname += this._decoder.write(data);
	  cb();
	};

	LinkSink.prototype.destroy = function () {
	  if (this._destroyed) return
	  this._destroyed = true;
	  this.emit('close');
	};

	var Void = function () {
	  Writable.call(this);
	  this._destroyed = false;
	};

	util.inherits(Void, Writable);

	Void.prototype._write = function (data, enc, cb) {
	  cb(new Error('No body allowed for this entry'));
	};

	Void.prototype.destroy = function () {
	  if (this._destroyed) return
	  this._destroyed = true;
	  this.emit('close');
	};

	var Pack = function (opts) {
	  if (!(this instanceof Pack)) return new Pack(opts)
	  Readable.call(this, opts);

	  this._drain = noop;
	  this._finalized = false;
	  this._finalizing = false;
	  this._destroyed = false;
	  this._stream = null;
	};

	util.inherits(Pack, Readable);

	Pack.prototype.entry = function (header, buffer, callback) {
	  if (this._stream) throw new Error('already piping an entry')
	  if (this._finalized || this._destroyed) return

	  if (typeof buffer === 'function') {
	    callback = buffer;
	    buffer = null;
	  }

	  if (!callback) callback = noop;

	  var self = this;

	  if (!header.size || header.type === 'symlink') header.size = 0;
	  if (!header.type) header.type = modeToType(header.mode);
	  if (!header.mode) header.mode = header.type === 'directory' ? DMODE : FMODE;
	  if (!header.uid) header.uid = 0;
	  if (!header.gid) header.gid = 0;
	  if (!header.mtime) header.mtime = new Date();

	  if (typeof buffer === 'string') buffer = toBuffer(buffer);
	  if (Buffer.isBuffer(buffer)) {
	    header.size = buffer.length;
	    this._encode(header);
	    this.push(buffer);
	    overflow(self, header.size);
	    process.nextTick(callback);
	    return new Void()
	  }

	  if (header.type === 'symlink' && !header.linkname) {
	    var linkSink = new LinkSink();
	    eos(linkSink, function (err) {
	      if (err) { // stream was closed
	        self.destroy();
	        return callback(err)
	      }

	      header.linkname = linkSink.linkname;
	      self._encode(header);
	      callback();
	    });

	    return linkSink
	  }

	  this._encode(header);

	  if (header.type !== 'file' && header.type !== 'contiguous-file') {
	    process.nextTick(callback);
	    return new Void()
	  }

	  var sink = new Sink(this);

	  this._stream = sink;

	  eos(sink, function (err) {
	    self._stream = null;

	    if (err) { // stream was closed
	      self.destroy();
	      return callback(err)
	    }

	    if (sink.written !== header.size) { // corrupting tar
	      self.destroy();
	      return callback(new Error('size mismatch'))
	    }

	    overflow(self, header.size);
	    if (self._finalizing) self.finalize();
	    callback();
	  });

	  return sink
	};

	Pack.prototype.finalize = function () {
	  if (this._stream) {
	    this._finalizing = true;
	    return
	  }

	  if (this._finalized) return
	  this._finalized = true;
	  this.push(END_OF_TAR);
	  this.push(null);
	};

	Pack.prototype.destroy = function (err) {
	  if (this._destroyed) return
	  this._destroyed = true;

	  if (err) this.emit('error', err);
	  this.emit('close');
	  if (this._stream && this._stream.destroy) this._stream.destroy();
	};

	Pack.prototype._encode = function (header) {
	  if (!header.pax) {
	    var buf = headers.encode(header);
	    if (buf) {
	      this.push(buf);
	      return
	    }
	  }
	  this._encodePax(header);
	};

	Pack.prototype._encodePax = function (header) {
	  var paxHeader = headers.encodePax({
	    name: header.name,
	    linkname: header.linkname,
	    pax: header.pax
	  });

	  var newHeader = {
	    name: 'PaxHeader',
	    mode: header.mode,
	    uid: header.uid,
	    gid: header.gid,
	    size: paxHeader.length,
	    mtime: header.mtime,
	    type: 'pax-header',
	    linkname: header.linkname && 'PaxHeader',
	    uname: header.uname,
	    gname: header.gname,
	    devmajor: header.devmajor,
	    devminor: header.devminor
	  };

	  this.push(headers.encode(newHeader));
	  this.push(paxHeader);
	  overflow(this, paxHeader.length);

	  newHeader.size = header.size;
	  newHeader.type = header.type;
	  this.push(headers.encode(newHeader));
	};

	Pack.prototype._read = function (n) {
	  var drain = this._drain;
	  this._drain = noop;
	  drain();
	};

	pack = Pack;
	return pack;
}

var hasRequiredTarStream;

function requireTarStream () {
	if (hasRequiredTarStream) return tarStream;
	hasRequiredTarStream = 1;
	tarStream.extract = requireExtract();
	tarStream.pack = requirePack();
	return tarStream;
}

var base_stream;
var hasRequiredBase_stream;

function requireBase_stream () {
	if (hasRequiredBase_stream) return base_stream;
	hasRequiredBase_stream = 1;

	const stream = require$$1$1;

	class BaseStream extends stream.Readable {
	  addEntry(/* entry, opts */) {
	    throw new Error('.addEntry not implemented in sub class!');
	  }

	  _read() {}

	  emit(event, data) {
	    if (event === 'error') {
	      const error = data;
	      if (error.name === 'Error') {
	        error.name = this.constructor.name + 'Error';
	      }
	    }
	    super.emit(event, data);
	  }
	}

	base_stream = BaseStream;
	return base_stream;
}

var stream_1;
var hasRequiredStream$3;

function requireStream$3 () {
	if (hasRequiredStream$3) return stream_1;
	hasRequiredStream$3 = 1;

	const fs = fs__default;
	const path = path__default;
	const stream = require$$1$1;
	const tar = requireTarStream();
	const utils = requireUtils$2();
	const BaseStream = requireBase_stream();

	class TarStream extends BaseStream {
	  constructor(opts) {
	    super(opts);

	    this._waitingEntries = [];
	    this._processing = false;
	    this._init(opts);
	  }

	  _init() {
	    const pack = this._pack = tar.pack();
	    pack.on('end', () => this.push(null));
	    pack.on('data', chunk => this.push(chunk));
	    pack.on('error', err => this.emit('error', err));
	  }

	  addEntry(entry, opts) {
	    if (this._processing) {
	      return this._waitingEntries.push([ entry, opts ]);
	    }

	    opts = opts || {};
	    this._processing = true;

	    const entryType = utils.entryType(entry);
	    if (!entryType) return; // TODO

	    if (entryType === 'fileOrDir') {
	      this._addFileOrDirEntry(entry, opts);
	    } else if (entryType === 'buffer') {
	      this._addBufferEntry(entry, opts);
	    } else { // stream
	      this._addStreamEntry(entry, opts);
	    }

	  }

	  _addFileOrDirEntry(entry, opts) {
	    fs.stat(entry, (err, stat) => {
	      if (err) return this.emit('error', err);
	      if (stat.isDirectory()) return this._addDirEntry(entry, opts);
	      if (stat.isFile()) return this._addFileEntry(entry, opts);

	      const illigalEntryError = new Error('Type is not supported, must be a file path, directory path, file buffer, or a readable stream');
	      illigalEntryError.name = 'IlligalEntryError';
	      this.emit('error', illigalEntryError);
	    });
	  }

	  _addFileEntry(entry, opts) {
	    // stat file to get file size
	    fs.stat(entry, (err, stat) => {
	      if (err) return this.emit('error', err);
	      const entryStream = this._pack.entry({ name: opts.relativePath || path.basename(entry), size: stat.size, mode: stat.mode & 0o777 }, this._onEntryFinish.bind(this));
	      const stream = fs.createReadStream(entry, opts.fs);
	      stream.on('error', err => this.emit('error', err));
	      stream.pipe(entryStream);
	    });
	  }

	  _addDirEntry(entry, opts) {
	    fs.readdir(entry, (err, files) => {
	      if (err) return this.emit('error', err);

	      const relativePath = opts.relativePath || '';
	      files.forEach(fileOrDir => {
	        const newOpts = utils.clone(opts);
	        if (opts.ignoreBase) {
	          newOpts.relativePath = path.posix.join(relativePath, fileOrDir);
	        } else {
	          newOpts.relativePath = path.posix.join(relativePath, path.basename(entry), fileOrDir);
	        }
	        newOpts.ignoreBase = true;
	        this.addEntry(path.posix.join(entry, fileOrDir), newOpts);
	      });
	      this._onEntryFinish();
	    });
	  }

	  _addBufferEntry(entry, opts) {
	    if (!opts.relativePath) return this.emit('error', 'opts.relativePath is required if entry is a buffer');
	    this._pack.entry({ name: opts.relativePath }, entry, this._onEntryFinish.bind(this));
	  }

	  _addStreamEntry(entry, opts) {
	    entry.on('error', err => this.emit('error', err));

	    if (!opts.relativePath) return this.emit('error', new Error('opts.relativePath is required'));

	    if (opts.size) {
	      const entryStream = this._pack.entry({ name: opts.relativePath, size: opts.size }, this._onEntryFinish.bind(this));
	      entry.pipe(entryStream);
	    } else {
	      if (!opts.suppressSizeWarning) {
	        console.warn('You should specify the size of streamming data by opts.size to prevent all streaming data from loading into memory. If you are sure about memory cost, pass opts.suppressSizeWarning: true to suppress this warning');
	      }
	      const buf = [];
	      const collectStream = new stream.Writable({
	        write(chunk, _, callback) {
	          buf.push(chunk);
	          callback();
	        },
	      });
	      collectStream.on('error', err => this.emit('error', err));
	      collectStream.on('finish', () => {
	        this._pack.entry({ name: opts.relativePath }, Buffer.concat(buf), this._onEntryFinish.bind(this));
	      });
	      entry.pipe(collectStream);
	    }
	  }

	  _read() {}

	  _onEntryFinish(err) {
	    if (err) return this.emit('error', err);

	    this._processing = false;
	    const waitingEntry = this._waitingEntries.shift();
	    if (waitingEntry) {
	      this.addEntry.apply(this, waitingEntry);
	    } else {
	      this._finalize();
	    }
	  }

	  _finalize() {
	    this._pack.finalize();
	  }
	}

	stream_1 = TarStream;
	return stream_1;
}

var stream$2;
var hasRequiredStream$2;

function requireStream$2 () {
	if (hasRequiredStream$2) return stream$2;
	hasRequiredStream$2 = 1;

	const path = path__default;
	const yazl = requireYazl();
	const TarStream = requireStream$3();

	class ZipStream extends TarStream {
	  _init() {
	    const zipfile = this._zipfile = new yazl.ZipFile();
	    const stream = zipfile.outputStream;
	    stream.on('end', () => this.push(null));
	    stream.on('data', chunk => this.push(chunk));
	    stream.on('error', err => this.emit('error', err));
	  }

	  _addFileEntry(entry, opts) {
	    this._zipfile.addFile(entry, opts.relativePath || path.basename(entry), opts);
	    this._onEntryFinish();
	  }

	  _addBufferEntry(entry, opts) {
	    if (!opts.relativePath) return this.emit('error', new Error('opts.relativePath is required if entry is a buffer'));
	    this._zipfile.addBuffer(entry, opts.relativePath, opts);
	    this._onEntryFinish();
	  }

	  _addStreamEntry(entry, opts) {
	    if (!opts.relativePath) return this.emit('error', new Error('opts.relativePath is required if entry is a stream'));

	    entry.on('error', err => this.emit('error', err));
	    this._zipfile.addReadStream(entry, opts.relativePath, opts);
	    this._onEntryFinish();
	  }

	  _finalize() {
	    this._zipfile.end();
	  }
	}

	stream$2 = ZipStream;
	return stream$2;
}

var getReady = {exports: {}};

var hasRequiredGetReady;

function requireGetReady () {
	if (hasRequiredGetReady) return getReady.exports;
	hasRequiredGetReady = 1;

	function ready(flagOrFunction) {
	  this._ready = !!this._ready;
	  this._readyCallbacks = this._readyCallbacks || [];

	  if (arguments.length === 0) {
	    // return a promise
	    // support `this.ready().then(onready);` and `yield this.ready()`;
	    return new Promise(function (resolve) {
	      if (this._ready) {
	        return resolve();
	      }
	      this._readyCallbacks.push(resolve);
	    }.bind(this));
	  } else if (typeof flagOrFunction === 'function') {
	    this._readyCallbacks.push(flagOrFunction);
	  } else {
	    this._ready = !!flagOrFunction;
	  }

	  if (this._ready) {
	    this._readyCallbacks.splice(0, Infinity).forEach(function(callback) {
	      process.nextTick(callback);
	    });
	  }
	}

	function mixin(object) {
	  object.ready = ready;
	}

	getReady.exports = mixin;
	getReady.exports.mixin = mixin;
	return getReady.exports;
}

var file_stream$3;
var hasRequiredFile_stream$3;

function requireFile_stream$3 () {
	if (hasRequiredFile_stream$3) return file_stream$3;
	hasRequiredFile_stream$3 = 1;

	const path = path__default;
	const yazl = requireYazl();
	const assert = require$$2$2;
	const stream = require$$1$1;
	const utils = requireUtils$2();
	const ready = requireGetReady();

	class ZipFileStream extends stream.Transform {
	  constructor(opts) {
	    super(opts);

	    const sourceType = utils.sourceType(opts.source);

	    const zipfile = new yazl.ZipFile();
	    const zipStream = zipfile.outputStream;
	    zipStream.on('data', data => this.push(data));
	    zipStream.on('end', () => this.ready(true));
	    zipfile.on('error', err => this.emit('error', err));

	    if (sourceType !== 'file') {
	      assert(opts.relativePath, 'opts.relativePath is required when compressing a buffer, or a stream');
	    }

	    if (sourceType) {
	      this.end();
	    }

	    if (sourceType === 'file') {
	      zipfile.addFile(opts.source, opts.relativePath || path.basename(opts.source), opts.yazl);
	    } else if (sourceType === 'buffer') {
	      zipfile.addBuffer(opts.source, opts.relativePath, opts.yazl);
	    } else if (sourceType === 'stream') {
	      zipfile.addReadStream(opts.source, opts.relativePath, opts.yazl);
	    } else { // undefined
	      const passThrough = this._passThrough = new stream.PassThrough();
	      this.on('finish', () => passThrough.end());
	      zipfile.addReadStream(passThrough, opts.relativePath, opts.yazl);
	    }
	    zipfile.end(opts.yazl);
	  }

	  _transform(chunk, encoding, callback) {
	    if (this._passThrough) {
	      this._passThrough.write(chunk, encoding, callback);
	    }
	  }

	  _flush(callback) {
	    this.ready(callback);
	  }
	}

	ready.mixin(ZipFileStream.prototype);
	file_stream$3 = ZipFileStream;
	return file_stream$3;
}

var yauzl = {};

var fdSlicer2 = {};

var pend;
var hasRequiredPend;

function requirePend () {
	if (hasRequiredPend) return pend;
	hasRequiredPend = 1;
	pend = Pend;

	function Pend() {
	  this.pending = 0;
	  this.max = Infinity;
	  this.listeners = [];
	  this.waiting = [];
	  this.error = null;
	}

	Pend.prototype.go = function(fn) {
	  if (this.pending < this.max) {
	    pendGo(this, fn);
	  } else {
	    this.waiting.push(fn);
	  }
	};

	Pend.prototype.wait = function(cb) {
	  if (this.pending === 0) {
	    cb(this.error);
	  } else {
	    this.listeners.push(cb);
	  }
	};

	Pend.prototype.hold = function() {
	  return pendHold(this);
	};

	function pendHold(self) {
	  self.pending += 1;
	  var called = false;
	  return onCb;
	  function onCb(err) {
	    if (called) throw new Error("callback called twice");
	    called = true;
	    self.error = self.error || err;
	    self.pending -= 1;
	    if (self.waiting.length > 0 && self.pending < self.max) {
	      pendGo(self, self.waiting.shift());
	    } else if (self.pending === 0) {
	      var listeners = self.listeners;
	      self.listeners = [];
	      listeners.forEach(cbListener);
	    }
	  }
	  function cbListener(listener) {
	    listener(self.error);
	  }
	}

	function pendGo(self, fn) {
	  fn(pendHold(self));
	}
	return pend;
}

var hasRequiredFdSlicer2;

function requireFdSlicer2 () {
	if (hasRequiredFdSlicer2) return fdSlicer2;
	hasRequiredFdSlicer2 = 1;
	const fs = fs__default;
	const { Readable, Writable, PassThrough } = require$$1$1;
	const Pend = requirePend();
	const { EventEmitter } = require$$0$5;

	class FdSlicer extends EventEmitter {
	  constructor(fd, options = {}) {
	    super();

	    this.fd = fd;
	    this.pend = new Pend();
	    this.pend.max = 1;
	    this.refCount = 0;
	    this.autoClose = !!options.autoClose;
	  }

	  read(buffer, offset, length, position, callback) {
	    this.pend.go(cb => {
	      fs.read(this.fd, buffer, offset, length, position, (err, bytesRead, buffer) => {
	        cb();
	        callback(err, bytesRead, buffer);
	      });
	    });
	  }

	  write(buffer, offset, length, position, callback) {
	    this.pend.go(cb => {
	      fs.write(this.fd, buffer, offset, length, position, (err, written, buffer) => {
	        cb();
	        callback(err, written, buffer);
	      });
	    });
	  }

	  createReadStream(options) {
	    return new ReadStream(this, options);
	  }

	  createWriteStream(options) {
	    return new WriteStream(this, options);
	  }

	  ref() {
	    this.refCount += 1;
	  }

	  unref() {
	    this.refCount -= 1;

	    if (this.refCount > 0) return;
	    if (this.refCount < 0) throw new Error("invalid unref");

	    if (this.autoClose) {
	      fs.close(this.fd, err => {
	        if (err) {
	          this.emit('error', err);
	        } else {
	          this.emit('close');
	        }
	      });
	    }
	  }
	}

	class ReadStream extends Readable {
	  constructor(context, options = {}) {
	    super(options);

	    this.context = context;
	    this.context.ref();

	    this.start = options.start || 0;
	    this.endOffset = options.end;
	    this.pos = this.start;
	    this.destroyed = false;
	  }

	  _read(n) {
	    if (this.destroyed) return;

	    let toRead = Math.min(this._readableState.highWaterMark, n);
	    if (this.endOffset != null) {
	      toRead = Math.min(toRead, this.endOffset - this.pos);
	    }
	    if (toRead <= 0) {
	      this.destroyed = true;
	      this.push(null);
	      this.context.unref();
	      return;
	    }
	    this.context.pend.go(cb => {
	      if (this.destroyed) return cb();
	      const buffer = Buffer.alloc(toRead);
	      fs.read(this.context.fd, buffer, 0, toRead, this.pos, (err, bytesRead) => {
	        if (err) {
	          this.destroy(err);
	        } else if (bytesRead === 0) {
	          this.destroyed = true;
	          this.push(null);
	          this.context.unref();
	        } else {
	          this.pos += bytesRead;
	          this.push(buffer.slice(0, bytesRead));
	        }
	        cb();
	      });
	    });
	  }

	  destroy(err) {
	    if (this.destroyed) return;
	    err = err || new Error("stream destroyed");
	    this.destroyed = true;
	    this.emit('error', err);
	    this.context.unref();
	  }
	}

	class WriteStream extends Writable {
	  constructor(context, options = {}) {
	    super(options);

	    this.context = context;
	    this.context.ref();

	    this.start = options.start || 0;
	    this.endOffset = (options.end == null) ? Infinity : +options.end;
	    this.bytesWritten = 0;
	    this.pos = this.start;
	    this.destroyed = false;

	    this.on('finish', this.destroy.bind(this));
	  }

	  _write(buffer, _encoding, callback) {
	    if (this.destroyed) return;

	    if (this.pos + buffer.length > this.endOffset) {
	      const err = new Error("maximum file length exceeded");
	      err.code = 'ETOOBIG';
	      this.destroy();
	      callback(err);
	      return;
	    }
	    this.context.pend.go(cb => {
	      if (this.destroyed) return cb();
	      fs.write(this.context.fd, buffer, 0, buffer.length, this.pos, (err, bytes) => {
	        if (err) {
	          this.destroy();
	          cb();
	          callback(err);
	        } else {
	          this.bytesWritten += bytes;
	          this.pos += bytes;
	          this.emit('progress');
	          cb();
	          callback();
	        }
	      });
	    });
	  }

	  destroy() {
	    if (this.destroyed) return;
	    this.destroyed = true;
	    this.context.unref();
	  }
	}

	const { MAX_SAFE_INTEGER } = Number;

	class BufferSlicer extends EventEmitter {
	  constructor(buffer, options) {
	    super();

	    options = options || {};
	    this.refCount = 0;
	    this.buffer = buffer;
	    this.maxChunkSize = options.maxChunkSize || MAX_SAFE_INTEGER;
	  }

	  read(buffer, offset, length, position, callback) {
	    const end = position + length;
	    const delta = end - this.buffer.length;
	    const written = (delta > 0) ? delta : length;
	    this.buffer.copy(buffer, offset, position, end);
	    setImmediate(() => {
	      callback(null, written);
	    });
	  }

	  write(buffer, offset, length, position, callback) {
	    buffer.copy(this.buffer, position, offset, offset + length);
	    setImmediate(() => {
	      callback(null, length, buffer);
	    });
	  }

	  createReadStream(options = {}) {
	    const readStream = new PassThrough(options);
	    readStream.destroyed = false;
	    readStream.start = options.start || 0;
	    readStream.endOffset = options.end;
	    // by the time this function returns, we'll be done.
	    readStream.pos = readStream.endOffset || this.buffer.length;

	    // respect the maxChunkSize option to slice up the chunk into smaller pieces.
	    const entireSlice = this.buffer.slice(readStream.start, readStream.pos);
	    let offset = 0;
	    while (true) {
	      const nextOffset = offset + this.maxChunkSize;
	      if (nextOffset >= entireSlice.length) {
	        // last chunk
	        if (offset < entireSlice.length) {
	          readStream.write(entireSlice.slice(offset, entireSlice.length));
	        }
	        break;
	      }
	      readStream.write(entireSlice.slice(offset, nextOffset));
	      offset = nextOffset;
	    }

	    readStream.end();
	    readStream.destroy = () => {
	      readStream.destroyed = true;
	    };
	    return readStream;
	  }

	  createWriteStream(options) {
	    const bufferSlicer = this;
	    options = options || {};
	    const writeStream = new Writable(options);
	    writeStream.start = options.start || 0;
	    writeStream.endOffset = (options.end == null) ? this.buffer.length : +options.end;
	    writeStream.bytesWritten = 0;
	    writeStream.pos = writeStream.start;
	    writeStream.destroyed = false;
	    writeStream._write = (buffer, encoding, callback) => {
	      if (writeStream.destroyed) return;

	      const end = writeStream.pos + buffer.length;
	      if (end > writeStream.endOffset) {
	        const err = new Error("maximum file length exceeded");
	        err.code = 'ETOOBIG';
	        writeStream.destroyed = true;
	        callback(err);
	        return;
	      }
	      buffer.copy(bufferSlicer.buffer, writeStream.pos, 0, buffer.length);

	      writeStream.bytesWritten += buffer.length;
	      writeStream.pos = end;
	      writeStream.emit('progress');
	      callback();
	    };
	    writeStream.destroy = () => {
	      writeStream.destroyed = true;
	    };
	    return writeStream;
	  }

	  ref() {
	    this.refCount += 1;
	  }

	  unref() {
	    this.refCount -= 1;

	    if (this.refCount < 0) {
	      throw new Error("invalid unref");
	    }
	  }
	}

	function createFromBuffer(buffer, options) {
	  return new BufferSlicer(buffer, options);
	}

	function createFromFd(fd, options) {
	  return new FdSlicer(fd, options);
	}

	fdSlicer2.createFromBuffer = createFromBuffer;
	fdSlicer2.createFromFd = createFromFd;
	fdSlicer2.BufferSlicer = BufferSlicer;
	fdSlicer2.FdSlicer = FdSlicer;
	return fdSlicer2;
}

var hasRequiredYauzl;

function requireYauzl () {
	if (hasRequiredYauzl) return yauzl;
	hasRequiredYauzl = 1;
	var fs = fs__default;
	var zlib = require$$1$2;
	var fd_slicer = requireFdSlicer2();
	var crc32 = requireBufferCrc32();
	var util = require$$0$6;
	var EventEmitter = require$$0$5.EventEmitter;
	var Transform = require$$1$1.Transform;
	var PassThrough = require$$1$1.PassThrough;
	var Writable = require$$1$1.Writable;

	yauzl.open = open;
	yauzl.fromFd = fromFd;
	yauzl.fromBuffer = fromBuffer;
	yauzl.fromRandomAccessReader = fromRandomAccessReader;
	yauzl.dosDateTimeToDate = dosDateTimeToDate;
	yauzl.validateFileName = validateFileName;
	yauzl.ZipFile = ZipFile;
	yauzl.Entry = Entry;
	yauzl.RandomAccessReader = RandomAccessReader;

	function open(path, options, callback) {
	  if (typeof options === "function") {
	    callback = options;
	    options = null;
	  }
	  if (options == null) options = {};
	  if (options.autoClose == null) options.autoClose = true;
	  if (options.lazyEntries == null) options.lazyEntries = false;
	  if (options.decodeStrings == null) options.decodeStrings = true;
	  if (options.validateEntrySizes == null) options.validateEntrySizes = true;
	  if (options.strictFileNames == null) options.strictFileNames = false;
	  if (callback == null) callback = defaultCallback;
	  fs.open(path, "r", function(err, fd) {
	    if (err) return callback(err);
	    fromFd(fd, options, function(err, zipfile) {
	      if (err) fs.close(fd, defaultCallback);
	      callback(err, zipfile);
	    });
	  });
	}

	function fromFd(fd, options, callback) {
	  if (typeof options === "function") {
	    callback = options;
	    options = null;
	  }
	  if (options == null) options = {};
	  if (options.autoClose == null) options.autoClose = false;
	  if (options.lazyEntries == null) options.lazyEntries = false;
	  if (options.decodeStrings == null) options.decodeStrings = true;
	  if (options.validateEntrySizes == null) options.validateEntrySizes = true;
	  if (options.strictFileNames == null) options.strictFileNames = false;
	  if (callback == null) callback = defaultCallback;
	  fs.fstat(fd, function(err, stats) {
	    if (err) return callback(err);
	    var reader = fd_slicer.createFromFd(fd, {autoClose: true});
	    fromRandomAccessReader(reader, stats.size, options, callback);
	  });
	}

	function fromBuffer(buffer, options, callback) {
	  if (typeof options === "function") {
	    callback = options;
	    options = null;
	  }
	  if (options == null) options = {};
	  options.autoClose = false;
	  if (options.lazyEntries == null) options.lazyEntries = false;
	  if (options.decodeStrings == null) options.decodeStrings = true;
	  if (options.validateEntrySizes == null) options.validateEntrySizes = true;
	  if (options.strictFileNames == null) options.strictFileNames = false;
	  // limit the max chunk size. see https://github.com/thejoshwolfe/yauzl/issues/87
	  var reader = fd_slicer.createFromBuffer(buffer, {maxChunkSize: 0x10000});
	  fromRandomAccessReader(reader, buffer.length, options, callback);
	}

	function fromRandomAccessReader(reader, totalSize, options, callback) {
	  if (typeof options === "function") {
	    callback = options;
	    options = null;
	  }
	  if (options == null) options = {};
	  if (options.autoClose == null) options.autoClose = true;
	  if (options.lazyEntries == null) options.lazyEntries = false;
	  if (options.decodeStrings == null) options.decodeStrings = true;
	  var decodeStrings = !!options.decodeStrings;
	  if (options.validateEntrySizes == null) options.validateEntrySizes = true;
	  if (options.strictFileNames == null) options.strictFileNames = false;
	  if (callback == null) callback = defaultCallback;
	  if (typeof totalSize !== "number") throw new Error("expected totalSize parameter to be a number");
	  if (totalSize > Number.MAX_SAFE_INTEGER) {
	    throw new Error("zip file too large. only file sizes up to 2^52 are supported due to JavaScript's Number type being an IEEE 754 double.");
	  }

	  // the matching unref() call is in zipfile.close()
	  reader.ref();

	  // eocdr means End of Central Directory Record.
	  // search backwards for the eocdr signature.
	  // the last field of the eocdr is a variable-length comment.
	  // the comment size is encoded in a 2-byte field in the eocdr, which we can't find without trudging backwards through the comment to find it.
	  // as a consequence of this design decision, it's possible to have ambiguous zip file metadata if a coherent eocdr was in the comment.
	  // we search backwards for a eocdr signature, and hope that whoever made the zip file was smart enough to forbid the eocdr signature in the comment.
	  var eocdrWithoutCommentSize = 22;
	  var maxCommentSize = 0xffff; // 2-byte size
	  var bufferSize = Math.min(eocdrWithoutCommentSize + maxCommentSize, totalSize);
	  var buffer = newBuffer(bufferSize);
	  var bufferReadStart = totalSize - buffer.length;
	  readAndAssertNoEof(reader, buffer, 0, bufferSize, bufferReadStart, function(err) {
	    if (err) return callback(err);
	    for (var i = bufferSize - eocdrWithoutCommentSize; i >= 0; i -= 1) {
	      if (buffer.readUInt32LE(i) !== 0x06054b50) continue;
	      // found eocdr
	      var eocdrBuffer = buffer.slice(i);

	      // 0 - End of central directory signature = 0x06054b50
	      // 4 - Number of this disk
	      var diskNumber = eocdrBuffer.readUInt16LE(4);
	      if (diskNumber !== 0) {
	        return callback(new Error("multi-disk zip files are not supported: found disk number: " + diskNumber));
	      }
	      // 6 - Disk where central directory starts
	      // 8 - Number of central directory records on this disk
	      // 10 - Total number of central directory records
	      var entryCount = eocdrBuffer.readUInt16LE(10);
	      // 12 - Size of central directory (bytes)
	      // 16 - Offset of start of central directory, relative to start of archive
	      var centralDirectoryOffset = eocdrBuffer.readUInt32LE(16);
	      // 20 - Comment length
	      var commentLength = eocdrBuffer.readUInt16LE(20);
	      var expectedCommentLength = eocdrBuffer.length - eocdrWithoutCommentSize;
	      if (commentLength !== expectedCommentLength) {
	        return callback(new Error("invalid comment length. expected: " + expectedCommentLength + ". found: " + commentLength));
	      }
	      // 22 - Comment
	      // the encoding is always cp437.
	      var comment = decodeStrings ? decodeBuffer(eocdrBuffer, 22, eocdrBuffer.length, false)
	                                  : eocdrBuffer.slice(22);

	      if (!(entryCount === 0xffff || centralDirectoryOffset === 0xffffffff)) {
	        return callback(null, new ZipFile(reader, centralDirectoryOffset, totalSize, entryCount, comment, options.autoClose, options.lazyEntries, decodeStrings, options.validateEntrySizes, options.strictFileNames));
	      }

	      // ZIP64 format

	      // ZIP64 Zip64 end of central directory locator
	      var zip64EocdlBuffer = newBuffer(20);
	      var zip64EocdlOffset = bufferReadStart + i - zip64EocdlBuffer.length;
	      readAndAssertNoEof(reader, zip64EocdlBuffer, 0, zip64EocdlBuffer.length, zip64EocdlOffset, function(err) {
	        if (err) return callback(err);

	        // 0 - zip64 end of central dir locator signature = 0x07064b50
	        if (zip64EocdlBuffer.readUInt32LE(0) !== 0x07064b50) {
	          return callback(new Error("invalid zip64 end of central directory locator signature"));
	        }
	        // 4 - number of the disk with the start of the zip64 end of central directory
	        // 8 - relative offset of the zip64 end of central directory record
	        var zip64EocdrOffset = readUInt64LE(zip64EocdlBuffer, 8);
	        // 16 - total number of disks

	        // ZIP64 end of central directory record
	        var zip64EocdrBuffer = newBuffer(56);
	        readAndAssertNoEof(reader, zip64EocdrBuffer, 0, zip64EocdrBuffer.length, zip64EocdrOffset, function(err) {
	          if (err) return callback(err);

	          // 0 - zip64 end of central dir signature                           4 bytes  (0x06064b50)
	          if (zip64EocdrBuffer.readUInt32LE(0) !== 0x06064b50) {
	            return callback(new Error("invalid zip64 end of central directory record signature"));
	          }
	          // 4 - size of zip64 end of central directory record                8 bytes
	          // 12 - version made by                                             2 bytes
	          // 14 - version needed to extract                                   2 bytes
	          // 16 - number of this disk                                         4 bytes
	          // 20 - number of the disk with the start of the central directory  4 bytes
	          // 24 - total number of entries in the central directory on this disk         8 bytes
	          // 32 - total number of entries in the central directory            8 bytes
	          entryCount = readUInt64LE(zip64EocdrBuffer, 32);
	          // 40 - size of the central directory                               8 bytes
	          // 48 - offset of start of central directory with respect to the starting disk number     8 bytes
	          centralDirectoryOffset = readUInt64LE(zip64EocdrBuffer, 48);
	          // 56 - zip64 extensible data sector                                (variable size)
	          return callback(null, new ZipFile(reader, centralDirectoryOffset, totalSize, entryCount, comment, options.autoClose, options.lazyEntries, decodeStrings, options.validateEntrySizes, options.strictFileNames));
	        });
	      });
	      return;
	    }
	    callback(new Error("end of central directory record signature not found"));
	  });
	}

	util.inherits(ZipFile, EventEmitter);
	function ZipFile(reader, centralDirectoryOffset, fileSize, entryCount, comment, autoClose, lazyEntries, decodeStrings, validateEntrySizes, strictFileNames) {
	  var self = this;
	  EventEmitter.call(self);
	  self.reader = reader;
	  // forward close events
	  self.reader.on("error", function(err) {
	    // error closing the fd
	    emitError(self, err);
	  });
	  self.reader.once("close", function() {
	    self.emit("close");
	  });
	  self.readEntryCursor = centralDirectoryOffset;
	  self.fileSize = fileSize;
	  self.entryCount = entryCount;
	  self.comment = comment;
	  self.entriesRead = 0;
	  self.autoClose = !!autoClose;
	  self.lazyEntries = !!lazyEntries;
	  self.decodeStrings = !!decodeStrings;
	  self.validateEntrySizes = !!validateEntrySizes;
	  self.strictFileNames = !!strictFileNames;
	  self.isOpen = true;
	  self.emittedError = false;

	  if (!self.lazyEntries) self._readEntry();
	}
	ZipFile.prototype.close = function() {
	  if (!this.isOpen) return;
	  this.isOpen = false;
	  this.reader.unref();
	};

	function emitErrorAndAutoClose(self, err) {
	  if (self.autoClose) self.close();
	  emitError(self, err);
	}
	function emitError(self, err) {
	  if (self.emittedError) return;
	  self.emittedError = true;
	  self.emit("error", err);
	}

	ZipFile.prototype.readEntry = function() {
	  if (!this.lazyEntries) throw new Error("readEntry() called without lazyEntries:true");
	  this._readEntry();
	};
	ZipFile.prototype._readEntry = function() {
	  var self = this;
	  if (self.entryCount === self.entriesRead) {
	    // done with metadata
	    setImmediate(function() {
	      if (self.autoClose) self.close();
	      if (self.emittedError) return;
	      self.emit("end");
	    });
	    return;
	  }
	  if (self.emittedError) return;
	  var buffer = newBuffer(46);
	  readAndAssertNoEof(self.reader, buffer, 0, buffer.length, self.readEntryCursor, function(err) {
	    if (err) return emitErrorAndAutoClose(self, err);
	    if (self.emittedError) return;
	    var entry = new Entry();
	    // 0 - Central directory file header signature
	    var signature = buffer.readUInt32LE(0);
	    if (signature !== 0x02014b50) return emitErrorAndAutoClose(self, new Error("invalid central directory file header signature: 0x" + signature.toString(16)));
	    // 4 - Version made by
	    entry.versionMadeBy = buffer.readUInt16LE(4);
	    // 6 - Version needed to extract (minimum)
	    entry.versionNeededToExtract = buffer.readUInt16LE(6);
	    // 8 - General purpose bit flag
	    entry.generalPurposeBitFlag = buffer.readUInt16LE(8);
	    // 10 - Compression method
	    entry.compressionMethod = buffer.readUInt16LE(10);
	    // 12 - File last modification time
	    entry.lastModFileTime = buffer.readUInt16LE(12);
	    // 14 - File last modification date
	    entry.lastModFileDate = buffer.readUInt16LE(14);
	    // 16 - CRC-32
	    entry.crc32 = buffer.readUInt32LE(16);
	    // 20 - Compressed size
	    entry.compressedSize = buffer.readUInt32LE(20);
	    // 24 - Uncompressed size
	    entry.uncompressedSize = buffer.readUInt32LE(24);
	    // 28 - File name length (n)
	    entry.fileNameLength = buffer.readUInt16LE(28);
	    // 30 - Extra field length (m)
	    entry.extraFieldLength = buffer.readUInt16LE(30);
	    // 32 - File comment length (k)
	    entry.fileCommentLength = buffer.readUInt16LE(32);
	    // 34 - Disk number where file starts
	    // 36 - Internal file attributes
	    entry.internalFileAttributes = buffer.readUInt16LE(36);
	    // 38 - External file attributes
	    entry.externalFileAttributes = buffer.readUInt32LE(38);
	    // 42 - Relative offset of local file header
	    entry.relativeOffsetOfLocalHeader = buffer.readUInt32LE(42);

	    if (entry.generalPurposeBitFlag & 0x40) return emitErrorAndAutoClose(self, new Error("strong encryption is not supported"));

	    self.readEntryCursor += 46;

	    buffer = newBuffer(entry.fileNameLength + entry.extraFieldLength + entry.fileCommentLength);
	    readAndAssertNoEof(self.reader, buffer, 0, buffer.length, self.readEntryCursor, function(err) {
	      if (err) return emitErrorAndAutoClose(self, err);
	      if (self.emittedError) return;
	      // 46 - File name
	      var isUtf8 = (entry.generalPurposeBitFlag & 0x800) !== 0;
	      entry.fileName = self.decodeStrings ? decodeBuffer(buffer, 0, entry.fileNameLength, isUtf8)
	                                          : buffer.slice(0, entry.fileNameLength);

	      // 46+n - Extra field
	      var fileCommentStart = entry.fileNameLength + entry.extraFieldLength;
	      var extraFieldBuffer = buffer.slice(entry.fileNameLength, fileCommentStart);
	      entry.extraFields = [];
	      var i = 0;
	      while (i < extraFieldBuffer.length - 3) {
	        var headerId = extraFieldBuffer.readUInt16LE(i + 0);
	        var dataSize = extraFieldBuffer.readUInt16LE(i + 2);
	        var dataStart = i + 4;
	        var dataEnd = dataStart + dataSize;
	        if (dataEnd > extraFieldBuffer.length) return emitErrorAndAutoClose(self, new Error("extra field length exceeds extra field buffer size"));
	        var dataBuffer = newBuffer(dataSize);
	        extraFieldBuffer.copy(dataBuffer, 0, dataStart, dataEnd);
	        entry.extraFields.push({
	          id: headerId,
	          data: dataBuffer,
	        });
	        i = dataEnd;
	      }

	      // 46+n+m - File comment
	      entry.fileComment = self.decodeStrings ? decodeBuffer(buffer, fileCommentStart, fileCommentStart + entry.fileCommentLength, isUtf8)
	                                             : buffer.slice(fileCommentStart, fileCommentStart + entry.fileCommentLength);
	      // compatibility hack for https://github.com/thejoshwolfe/yauzl/issues/47
	      entry.comment = entry.fileComment;

	      self.readEntryCursor += buffer.length;
	      self.entriesRead += 1;

	      if (entry.uncompressedSize            === 0xffffffff ||
	          entry.compressedSize              === 0xffffffff ||
	          entry.relativeOffsetOfLocalHeader === 0xffffffff) {
	        // ZIP64 format
	        // find the Zip64 Extended Information Extra Field
	        var zip64EiefBuffer = null;
	        for (var i = 0; i < entry.extraFields.length; i++) {
	          var extraField = entry.extraFields[i];
	          if (extraField.id === 0x0001) {
	            zip64EiefBuffer = extraField.data;
	            break;
	          }
	        }
	        if (zip64EiefBuffer == null) {
	          return emitErrorAndAutoClose(self, new Error("expected zip64 extended information extra field"));
	        }
	        var index = 0;
	        // 0 - Original Size          8 bytes
	        if (entry.uncompressedSize === 0xffffffff) {
	          if (index + 8 > zip64EiefBuffer.length) {
	            return emitErrorAndAutoClose(self, new Error("zip64 extended information extra field does not include uncompressed size"));
	          }
	          entry.uncompressedSize = readUInt64LE(zip64EiefBuffer, index);
	          index += 8;
	        }
	        // 8 - Compressed Size        8 bytes
	        if (entry.compressedSize === 0xffffffff) {
	          if (index + 8 > zip64EiefBuffer.length) {
	            return emitErrorAndAutoClose(self, new Error("zip64 extended information extra field does not include compressed size"));
	          }
	          entry.compressedSize = readUInt64LE(zip64EiefBuffer, index);
	          index += 8;
	        }
	        // 16 - Relative Header Offset 8 bytes
	        if (entry.relativeOffsetOfLocalHeader === 0xffffffff) {
	          if (index + 8 > zip64EiefBuffer.length) {
	            return emitErrorAndAutoClose(self, new Error("zip64 extended information extra field does not include relative header offset"));
	          }
	          entry.relativeOffsetOfLocalHeader = readUInt64LE(zip64EiefBuffer, index);
	          index += 8;
	        }
	        // 24 - Disk Start Number      4 bytes
	      }

	      // check for Info-ZIP Unicode Path Extra Field (0x7075)
	      // see https://github.com/thejoshwolfe/yauzl/issues/33
	      if (self.decodeStrings) {
	        for (var i = 0; i < entry.extraFields.length; i++) {
	          var extraField = entry.extraFields[i];
	          if (extraField.id === 0x7075) {
	            if (extraField.data.length < 6) {
	              // too short to be meaningful
	              continue;
	            }
	            // Version       1 byte      version of this extra field, currently 1
	            if (extraField.data.readUInt8(0) !== 1) {
	              // > Changes may not be backward compatible so this extra
	              // > field should not be used if the version is not recognized.
	              continue;
	            }
	            // NameCRC32     4 bytes     File Name Field CRC32 Checksum
	            var oldNameCrc32 = extraField.data.readUInt32LE(1);
	            if (crc32.unsigned(buffer.slice(0, entry.fileNameLength)) !== oldNameCrc32) {
	              // > If the CRC check fails, this UTF-8 Path Extra Field should be
	              // > ignored and the File Name field in the header should be used instead.
	              continue;
	            }
	            // UnicodeName   Variable    UTF-8 version of the entry File Name
	            entry.fileName = decodeBuffer(extraField.data, 5, extraField.data.length, true);
	            break;
	          }
	        }
	      }

	      // validate file size
	      if (self.validateEntrySizes && entry.compressionMethod === 0) {
	        var expectedCompressedSize = entry.uncompressedSize;
	        if (entry.isEncrypted()) {
	          // traditional encryption prefixes the file data with a header
	          expectedCompressedSize += 12;
	        }
	        if (entry.compressedSize !== expectedCompressedSize) {
	          var msg = "compressed/uncompressed size mismatch for stored file: " + entry.compressedSize + " != " + entry.uncompressedSize;
	          return emitErrorAndAutoClose(self, new Error(msg));
	        }
	      }

	      if (self.decodeStrings) {
	        if (!self.strictFileNames) {
	          // allow backslash
	          entry.fileName = entry.fileName.replace(/\\/g, "/");
	        }
	        var errorMessage = validateFileName(entry.fileName, self.validateFileNameOptions);
	        if (errorMessage != null) return emitErrorAndAutoClose(self, new Error(errorMessage));
	      }
	      self.emit("entry", entry);

	      if (!self.lazyEntries) self._readEntry();
	    });
	  });
	};

	ZipFile.prototype.openReadStream = function(entry, options, callback) {
	  var self = this;
	  // parameter validation
	  var relativeStart = 0;
	  var relativeEnd = entry.compressedSize;
	  if (callback == null) {
	    callback = options;
	    options = {};
	  } else {
	    // validate options that the caller has no excuse to get wrong
	    if (options.decrypt != null) {
	      if (!entry.isEncrypted()) {
	        throw new Error("options.decrypt can only be specified for encrypted entries");
	      }
	      if (options.decrypt !== false) throw new Error("invalid options.decrypt value: " + options.decrypt);
	      if (entry.isCompressed()) {
	        if (options.decompress !== false) throw new Error("entry is encrypted and compressed, and options.decompress !== false");
	      }
	    }
	    if (options.decompress != null) {
	      if (!entry.isCompressed()) {
	        throw new Error("options.decompress can only be specified for compressed entries");
	      }
	      if (!(options.decompress === false || options.decompress === true)) {
	        throw new Error("invalid options.decompress value: " + options.decompress);
	      }
	    }
	    if (options.start != null || options.end != null) {
	      if (entry.isCompressed() && options.decompress !== false) {
	        throw new Error("start/end range not allowed for compressed entry without options.decompress === false");
	      }
	      if (entry.isEncrypted() && options.decrypt !== false) {
	        throw new Error("start/end range not allowed for encrypted entry without options.decrypt === false");
	      }
	    }
	    if (options.start != null) {
	      relativeStart = options.start;
	      if (relativeStart < 0) throw new Error("options.start < 0");
	      if (relativeStart > entry.compressedSize) throw new Error("options.start > entry.compressedSize");
	    }
	    if (options.end != null) {
	      relativeEnd = options.end;
	      if (relativeEnd < 0) throw new Error("options.end < 0");
	      if (relativeEnd > entry.compressedSize) throw new Error("options.end > entry.compressedSize");
	      if (relativeEnd < relativeStart) throw new Error("options.end < options.start");
	    }
	  }
	  // any further errors can either be caused by the zipfile,
	  // or were introduced in a minor version of yauzl,
	  // so should be passed to the client rather than thrown.
	  if (!self.isOpen) return callback(new Error("closed"));
	  if (entry.isEncrypted()) {
	    if (options.decrypt !== false) return callback(new Error("entry is encrypted, and options.decrypt !== false"));
	  }
	  // make sure we don't lose the fd before we open the actual read stream
	  self.reader.ref();
	  var buffer = newBuffer(30);
	  readAndAssertNoEof(self.reader, buffer, 0, buffer.length, entry.relativeOffsetOfLocalHeader, function(err) {
	    try {
	      if (err) return callback(err);
	      // 0 - Local file header signature = 0x04034b50
	      var signature = buffer.readUInt32LE(0);
	      if (signature !== 0x04034b50) {
	        return callback(new Error("invalid local file header signature: 0x" + signature.toString(16)));
	      }
	      // all this should be redundant
	      // 4 - Version needed to extract (minimum)
	      // 6 - General purpose bit flag
	      // 8 - Compression method
	      // 10 - File last modification time
	      // 12 - File last modification date
	      // 14 - CRC-32
	      // 18 - Compressed size
	      // 22 - Uncompressed size
	      // 26 - File name length (n)
	      var fileNameLength = buffer.readUInt16LE(26);
	      // 28 - Extra field length (m)
	      var extraFieldLength = buffer.readUInt16LE(28);
	      // 30 - File name
	      // 30+n - Extra field
	      var localFileHeaderEnd = entry.relativeOffsetOfLocalHeader + buffer.length + fileNameLength + extraFieldLength;
	      var decompress;
	      if (entry.compressionMethod === 0) {
	        // 0 - The file is stored (no compression)
	        decompress = false;
	      } else if (entry.compressionMethod === 8) {
	        // 8 - The file is Deflated
	        decompress = options.decompress != null ? options.decompress : true;
	      } else {
	        return callback(new Error("unsupported compression method: " + entry.compressionMethod));
	      }
	      var fileDataStart = localFileHeaderEnd;
	      var fileDataEnd = fileDataStart + entry.compressedSize;
	      if (entry.compressedSize !== 0) {
	        // bounds check now, because the read streams will probably not complain loud enough.
	        // since we're dealing with an unsigned offset plus an unsigned size,
	        // we only have 1 thing to check for.
	        if (fileDataEnd > self.fileSize) {
	          return callback(new Error("file data overflows file bounds: " +
	              fileDataStart + " + " + entry.compressedSize + " > " + self.fileSize));
	        }
	      }
	      var readStream = self.reader.createReadStream({
	        start: fileDataStart + relativeStart,
	        end: fileDataStart + relativeEnd,
	      });
	      var endpointStream = readStream;
	      if (decompress) {
	        var destroyed = false;
	        var inflateFilter = zlib.createInflateRaw();
	        readStream.on("error", function(err) {
	          // setImmediate here because errors can be emitted during the first call to pipe()
	          setImmediate(function() {
	            if (!destroyed) inflateFilter.emit("error", err);
	          });
	        });
	        readStream.pipe(inflateFilter);

	        if (self.validateEntrySizes) {
	          endpointStream = new AssertByteCountStream(entry.uncompressedSize);
	          inflateFilter.on("error", function(err) {
	            // forward zlib errors to the client-visible stream
	            setImmediate(function() {
	              if (!destroyed) endpointStream.emit("error", err);
	            });
	          });
	          inflateFilter.pipe(endpointStream);
	        } else {
	          // the zlib filter is the client-visible stream
	          endpointStream = inflateFilter;
	        }
	        // this is part of yauzl's API, so implement this function on the client-visible stream
	        endpointStream.destroy = function() {
	          destroyed = true;
	          if (inflateFilter !== endpointStream) inflateFilter.unpipe(endpointStream);
	          readStream.unpipe(inflateFilter);
	          // TODO: the inflateFilter may cause a memory leak. see Issue #27.
	          readStream.destroy();
	        };
	      }
	      callback(null, endpointStream);
	    } finally {
	      self.reader.unref();
	    }
	  });
	};

	function Entry() {
	}
	Entry.prototype.getLastModDate = function() {
	  return dosDateTimeToDate(this.lastModFileDate, this.lastModFileTime);
	};
	Entry.prototype.isEncrypted = function() {
	  return (this.generalPurposeBitFlag & 0x1) !== 0;
	};
	Entry.prototype.isCompressed = function() {
	  return this.compressionMethod === 8;
	};

	function dosDateTimeToDate(date, time) {
	  var day = date & 0x1f; // 1-31
	  var month = (date >> 5 & 0xf) - 1; // 1-12, 0-11
	  var year = (date >> 9 & 0x7f) + 1980; // 0-128, 1980-2108

	  var millisecond = 0;
	  var second = (time & 0x1f) * 2; // 0-29, 0-58 (even numbers)
	  var minute = time >> 5 & 0x3f; // 0-59
	  var hour = time >> 11 & 0x1f; // 0-23

	  return new Date(year, month, day, hour, minute, second, millisecond);
	}

	function validateFileName(fileName) {
	  if (fileName.indexOf("\\") !== -1) {
	    return "invalid characters in fileName: " + fileName;
	  }
	  if (/^[a-zA-Z]:/.test(fileName) || /^\//.test(fileName)) {
	    return "absolute path: " + fileName;
	  }
	  if (fileName.split("/").indexOf("..") !== -1) {
	    return "invalid relative path: " + fileName;
	  }
	  // all good
	  return null;
	}

	function readAndAssertNoEof(reader, buffer, offset, length, position, callback) {
	  if (length === 0) {
	    // fs.read will throw an out-of-bounds error if you try to read 0 bytes from a 0 byte file
	    return setImmediate(function() { callback(null, newBuffer(0)); });
	  }
	  reader.read(buffer, offset, length, position, function(err, bytesRead) {
	    if (err) return callback(err);
	    if (bytesRead < length) {
	      return callback(new Error("unexpected EOF"));
	    }
	    callback();
	  });
	}

	util.inherits(AssertByteCountStream, Transform);
	function AssertByteCountStream(byteCount) {
	  Transform.call(this);
	  this.actualByteCount = 0;
	  this.expectedByteCount = byteCount;
	}
	AssertByteCountStream.prototype._transform = function(chunk, encoding, cb) {
	  this.actualByteCount += chunk.length;
	  if (this.actualByteCount > this.expectedByteCount) {
	    var msg = "too many bytes in the stream. expected " + this.expectedByteCount + ". got at least " + this.actualByteCount;
	    return cb(new Error(msg));
	  }
	  cb(null, chunk);
	};
	AssertByteCountStream.prototype._flush = function(cb) {
	  if (this.actualByteCount < this.expectedByteCount) {
	    var msg = "not enough bytes in the stream. expected " + this.expectedByteCount + ". got only " + this.actualByteCount;
	    return cb(new Error(msg));
	  }
	  cb();
	};

	util.inherits(RandomAccessReader, EventEmitter);
	function RandomAccessReader() {
	  EventEmitter.call(this);
	  this.refCount = 0;
	}
	RandomAccessReader.prototype.ref = function() {
	  this.refCount += 1;
	};
	RandomAccessReader.prototype.unref = function() {
	  var self = this;
	  self.refCount -= 1;

	  if (self.refCount > 0) return;
	  if (self.refCount < 0) throw new Error("invalid unref");

	  self.close(onCloseDone);

	  function onCloseDone(err) {
	    if (err) return self.emit('error', err);
	    self.emit('close');
	  }
	};
	RandomAccessReader.prototype.createReadStream = function(options) {
	  var start = options.start;
	  var end = options.end;
	  if (start === end) {
	    var emptyStream = new PassThrough();
	    setImmediate(function() {
	      emptyStream.end();
	    });
	    return emptyStream;
	  }
	  var stream = this._readStreamForRange(start, end);

	  var destroyed = false;
	  var refUnrefFilter = new RefUnrefFilter(this);
	  stream.on("error", function(err) {
	    setImmediate(function() {
	      if (!destroyed) refUnrefFilter.emit("error", err);
	    });
	  });
	  refUnrefFilter.destroy = function() {
	    stream.unpipe(refUnrefFilter);
	    refUnrefFilter.unref();
	    stream.destroy();
	  };

	  var byteCounter = new AssertByteCountStream(end - start);
	  refUnrefFilter.on("error", function(err) {
	    setImmediate(function() {
	      if (!destroyed) byteCounter.emit("error", err);
	    });
	  });
	  byteCounter.destroy = function() {
	    destroyed = true;
	    refUnrefFilter.unpipe(byteCounter);
	    refUnrefFilter.destroy();
	  };

	  return stream.pipe(refUnrefFilter).pipe(byteCounter);
	};
	RandomAccessReader.prototype._readStreamForRange = function(start, end) {
	  throw new Error("not implemented");
	};
	RandomAccessReader.prototype.read = function(buffer, offset, length, position, callback) {
	  var readStream = this.createReadStream({start: position, end: position + length});
	  var writeStream = new Writable();
	  var written = 0;
	  writeStream._write = function(chunk, encoding, cb) {
	    chunk.copy(buffer, offset + written, 0, chunk.length);
	    written += chunk.length;
	    cb();
	  };
	  writeStream.on("finish", callback);
	  readStream.on("error", function(error) {
	    callback(error);
	  });
	  readStream.pipe(writeStream);
	};
	RandomAccessReader.prototype.close = function(callback) {
	  setImmediate(callback);
	};

	util.inherits(RefUnrefFilter, PassThrough);
	function RefUnrefFilter(context) {
	  PassThrough.call(this);
	  this.context = context;
	  this.context.ref();
	  this.unreffedYet = false;
	}
	RefUnrefFilter.prototype._flush = function(cb) {
	  this.unref();
	  cb();
	};
	RefUnrefFilter.prototype.unref = function(cb) {
	  if (this.unreffedYet) return;
	  this.unreffedYet = true;
	  this.context.unref();
	};

	var cp437 = '\u0000☺☻♥♦♣♠•◘○◙♂♀♪♫☼►◄↕‼¶§▬↨↑↓→←∟↔▲▼ !"#$%&\'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~⌂ÇüéâäàåçêëèïîìÄÅÉæÆôöòûùÿÖÜ¢£¥₧ƒáíóúñÑªº¿⌐¬½¼¡«»░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀αßΓπΣσµτΦΘΩδ∞φε∩≡±≥≤⌠⌡÷≈°∙·√ⁿ²■ ';
	function decodeBuffer(buffer, start, end, isUtf8) {
	  if (isUtf8) {
	    return buffer.toString("utf8", start, end);
	  } else {
	    var result = "";
	    for (var i = start; i < end; i++) {
	      result += cp437[buffer[i]];
	    }
	    return result;
	  }
	}

	function readUInt64LE(buffer, offset) {
	  // there is no native function for this, because we can't actually store 64-bit integers precisely.
	  // after 53 bits, JavaScript's Number type (IEEE 754 double) can't store individual integers anymore.
	  // but since 53 bits is a whole lot more than 32 bits, we do our best anyway.
	  var lower32 = buffer.readUInt32LE(offset);
	  var upper32 = buffer.readUInt32LE(offset + 4);
	  // we can't use bitshifting here, because JavaScript bitshifting only works on 32-bit integers.
	  return upper32 * 0x100000000 + lower32;
	  // as long as we're bounds checking the result of this function against the total file size,
	  // we'll catch any overflow errors, because we already made sure the total file size was within reason.
	}

	// Node 10 deprecated new Buffer().
	var newBuffer;
	if (typeof Buffer.allocUnsafe === "function") {
	  newBuffer = function(len) {
	    return Buffer.allocUnsafe(len);
	  };
	} else {
	  newBuffer = function(len) {
	    return new Buffer(len);
	  };
	}

	function defaultCallback(err) {
	  if (err) throw err;
	}
	return yauzl;
}

var base_write_stream;
var hasRequiredBase_write_stream;

function requireBase_write_stream () {
	if (hasRequiredBase_write_stream) return base_write_stream;
	hasRequiredBase_write_stream = 1;

	const stream = require$$1$1;

	class UncompressBaseStream extends stream.Writable {
	  emit(event, data) {
	    if (event === 'error') {
	      const error = data;
	      if (error.name === 'Error') {
	        error.name = this.constructor.name + 'Error';
	      }
	    }
	    super.emit.apply(this, arguments);
	  }
	}

	base_write_stream = UncompressBaseStream;
	return base_write_stream;
}

var lib$4 = {exports: {}};

/* eslint-disable node/no-deprecated-api */

var safer_1;
var hasRequiredSafer;

function requireSafer () {
	if (hasRequiredSafer) return safer_1;
	hasRequiredSafer = 1;

	var buffer = require$$0$4;
	var Buffer = buffer.Buffer;

	var safer = {};

	var key;

	for (key in buffer) {
	  if (!buffer.hasOwnProperty(key)) continue
	  if (key === 'SlowBuffer' || key === 'Buffer') continue
	  safer[key] = buffer[key];
	}

	var Safer = safer.Buffer = {};
	for (key in Buffer) {
	  if (!Buffer.hasOwnProperty(key)) continue
	  if (key === 'allocUnsafe' || key === 'allocUnsafeSlow') continue
	  Safer[key] = Buffer[key];
	}

	safer.Buffer.prototype = Buffer.prototype;

	if (!Safer.from || Safer.from === Uint8Array.from) {
	  Safer.from = function (value, encodingOrOffset, length) {
	    if (typeof value === 'number') {
	      throw new TypeError('The "value" argument must not be of type number. Received type ' + typeof value)
	    }
	    if (value && typeof value.length === 'undefined') {
	      throw new TypeError('The first argument must be one of type string, Buffer, ArrayBuffer, Array, or Array-like Object. Received type ' + typeof value)
	    }
	    return Buffer(value, encodingOrOffset, length)
	  };
	}

	if (!Safer.alloc) {
	  Safer.alloc = function (size, fill, encoding) {
	    if (typeof size !== 'number') {
	      throw new TypeError('The "size" argument must be of type number. Received type ' + typeof size)
	    }
	    if (size < 0 || size >= 2 * (1 << 30)) {
	      throw new RangeError('The value "' + size + '" is invalid for option "size"')
	    }
	    var buf = Buffer(size);
	    if (!fill || fill.length === 0) {
	      buf.fill(0);
	    } else if (typeof encoding === 'string') {
	      buf.fill(fill, encoding);
	    } else {
	      buf.fill(fill);
	    }
	    return buf
	  };
	}

	if (!safer.kStringMaxLength) {
	  try {
	    safer.kStringMaxLength = process.binding('buffer').kStringMaxLength;
	  } catch (e) {
	    // we can't determine kStringMaxLength in environments where process.binding
	    // is unsupported, so let's not set it
	  }
	}

	if (!safer.constants) {
	  safer.constants = {
	    MAX_LENGTH: safer.kMaxLength
	  };
	  if (safer.kStringMaxLength) {
	    safer.constants.MAX_STRING_LENGTH = safer.kStringMaxLength;
	  }
	}

	safer_1 = safer;
	return safer_1;
}

var bomHandling = {};

var hasRequiredBomHandling;

function requireBomHandling () {
	if (hasRequiredBomHandling) return bomHandling;
	hasRequiredBomHandling = 1;

	var BOMChar = '\uFEFF';

	bomHandling.PrependBOM = PrependBOMWrapper;
	function PrependBOMWrapper(encoder, options) {
	    this.encoder = encoder;
	    this.addBOM = true;
	}

	PrependBOMWrapper.prototype.write = function(str) {
	    if (this.addBOM) {
	        str = BOMChar + str;
	        this.addBOM = false;
	    }

	    return this.encoder.write(str);
	};

	PrependBOMWrapper.prototype.end = function() {
	    return this.encoder.end();
	};


	//------------------------------------------------------------------------------

	bomHandling.StripBOM = StripBOMWrapper;
	function StripBOMWrapper(decoder, options) {
	    this.decoder = decoder;
	    this.pass = false;
	    this.options = options || {};
	}

	StripBOMWrapper.prototype.write = function(buf) {
	    var res = this.decoder.write(buf);
	    if (this.pass || !res)
	        return res;

	    if (res[0] === BOMChar) {
	        res = res.slice(1);
	        if (typeof this.options.stripBOM === 'function')
	            this.options.stripBOM();
	    }

	    this.pass = true;
	    return res;
	};

	StripBOMWrapper.prototype.end = function() {
	    return this.decoder.end();
	};
	return bomHandling;
}

var encodings = {};

var internal;
var hasRequiredInternal;

function requireInternal () {
	if (hasRequiredInternal) return internal;
	hasRequiredInternal = 1;
	var Buffer = requireSafer().Buffer;

	// Export Node.js internal encodings.

	internal = {
	    // Encodings
	    utf8:   { type: "_internal", bomAware: true},
	    cesu8:  { type: "_internal", bomAware: true},
	    unicode11utf8: "utf8",

	    ucs2:   { type: "_internal", bomAware: true},
	    utf16le: "ucs2",

	    binary: { type: "_internal" },
	    base64: { type: "_internal" },
	    hex:    { type: "_internal" },

	    // Codec.
	    _internal: InternalCodec,
	};

	//------------------------------------------------------------------------------

	function InternalCodec(codecOptions, iconv) {
	    this.enc = codecOptions.encodingName;
	    this.bomAware = codecOptions.bomAware;

	    if (this.enc === "base64")
	        this.encoder = InternalEncoderBase64;
	    else if (this.enc === "cesu8") {
	        this.enc = "utf8"; // Use utf8 for decoding.
	        this.encoder = InternalEncoderCesu8;

	        // Add decoder for versions of Node not supporting CESU-8
	        if (Buffer.from('eda0bdedb2a9', 'hex').toString() !== '💩') {
	            this.decoder = InternalDecoderCesu8;
	            this.defaultCharUnicode = iconv.defaultCharUnicode;
	        }
	    }
	}

	InternalCodec.prototype.encoder = InternalEncoder;
	InternalCodec.prototype.decoder = InternalDecoder;

	//------------------------------------------------------------------------------

	// We use node.js internal decoder. Its signature is the same as ours.
	var StringDecoder = require$$1$3.StringDecoder;

	if (!StringDecoder.prototype.end) // Node v0.8 doesn't have this method.
	    StringDecoder.prototype.end = function() {};


	function InternalDecoder(options, codec) {
	    StringDecoder.call(this, codec.enc);
	}

	InternalDecoder.prototype = StringDecoder.prototype;


	//------------------------------------------------------------------------------
	// Encoder is mostly trivial

	function InternalEncoder(options, codec) {
	    this.enc = codec.enc;
	}

	InternalEncoder.prototype.write = function(str) {
	    return Buffer.from(str, this.enc);
	};

	InternalEncoder.prototype.end = function() {
	};


	//------------------------------------------------------------------------------
	// Except base64 encoder, which must keep its state.

	function InternalEncoderBase64(options, codec) {
	    this.prevStr = '';
	}

	InternalEncoderBase64.prototype.write = function(str) {
	    str = this.prevStr + str;
	    var completeQuads = str.length - (str.length % 4);
	    this.prevStr = str.slice(completeQuads);
	    str = str.slice(0, completeQuads);

	    return Buffer.from(str, "base64");
	};

	InternalEncoderBase64.prototype.end = function() {
	    return Buffer.from(this.prevStr, "base64");
	};


	//------------------------------------------------------------------------------
	// CESU-8 encoder is also special.

	function InternalEncoderCesu8(options, codec) {
	}

	InternalEncoderCesu8.prototype.write = function(str) {
	    var buf = Buffer.alloc(str.length * 3), bufIdx = 0;
	    for (var i = 0; i < str.length; i++) {
	        var charCode = str.charCodeAt(i);
	        // Naive implementation, but it works because CESU-8 is especially easy
	        // to convert from UTF-16 (which all JS strings are encoded in).
	        if (charCode < 0x80)
	            buf[bufIdx++] = charCode;
	        else if (charCode < 0x800) {
	            buf[bufIdx++] = 0xC0 + (charCode >>> 6);
	            buf[bufIdx++] = 0x80 + (charCode & 0x3f);
	        }
	        else { // charCode will always be < 0x10000 in javascript.
	            buf[bufIdx++] = 0xE0 + (charCode >>> 12);
	            buf[bufIdx++] = 0x80 + ((charCode >>> 6) & 0x3f);
	            buf[bufIdx++] = 0x80 + (charCode & 0x3f);
	        }
	    }
	    return buf.slice(0, bufIdx);
	};

	InternalEncoderCesu8.prototype.end = function() {
	};

	//------------------------------------------------------------------------------
	// CESU-8 decoder is not implemented in Node v4.0+

	function InternalDecoderCesu8(options, codec) {
	    this.acc = 0;
	    this.contBytes = 0;
	    this.accBytes = 0;
	    this.defaultCharUnicode = codec.defaultCharUnicode;
	}

	InternalDecoderCesu8.prototype.write = function(buf) {
	    var acc = this.acc, contBytes = this.contBytes, accBytes = this.accBytes, 
	        res = '';
	    for (var i = 0; i < buf.length; i++) {
	        var curByte = buf[i];
	        if ((curByte & 0xC0) !== 0x80) { // Leading byte
	            if (contBytes > 0) { // Previous code is invalid
	                res += this.defaultCharUnicode;
	                contBytes = 0;
	            }

	            if (curByte < 0x80) { // Single-byte code
	                res += String.fromCharCode(curByte);
	            } else if (curByte < 0xE0) { // Two-byte code
	                acc = curByte & 0x1F;
	                contBytes = 1; accBytes = 1;
	            } else if (curByte < 0xF0) { // Three-byte code
	                acc = curByte & 0x0F;
	                contBytes = 2; accBytes = 1;
	            } else { // Four or more are not supported for CESU-8.
	                res += this.defaultCharUnicode;
	            }
	        } else { // Continuation byte
	            if (contBytes > 0) { // We're waiting for it.
	                acc = (acc << 6) | (curByte & 0x3f);
	                contBytes--; accBytes++;
	                if (contBytes === 0) {
	                    // Check for overlong encoding, but support Modified UTF-8 (encoding NULL as C0 80)
	                    if (accBytes === 2 && acc < 0x80 && acc > 0)
	                        res += this.defaultCharUnicode;
	                    else if (accBytes === 3 && acc < 0x800)
	                        res += this.defaultCharUnicode;
	                    else
	                        // Actually add character.
	                        res += String.fromCharCode(acc);
	                }
	            } else { // Unexpected continuation byte
	                res += this.defaultCharUnicode;
	            }
	        }
	    }
	    this.acc = acc; this.contBytes = contBytes; this.accBytes = accBytes;
	    return res;
	};

	InternalDecoderCesu8.prototype.end = function() {
	    var res = 0;
	    if (this.contBytes > 0)
	        res += this.defaultCharUnicode;
	    return res;
	};
	return internal;
}

var utf32 = {};

var hasRequiredUtf32;

function requireUtf32 () {
	if (hasRequiredUtf32) return utf32;
	hasRequiredUtf32 = 1;

	var Buffer = requireSafer().Buffer;

	// == UTF32-LE/BE codec. ==========================================================

	utf32._utf32 = Utf32Codec;

	function Utf32Codec(codecOptions, iconv) {
	    this.iconv = iconv;
	    this.bomAware = true;
	    this.isLE = codecOptions.isLE;
	}

	utf32.utf32le = { type: '_utf32', isLE: true };
	utf32.utf32be = { type: '_utf32', isLE: false };

	// Aliases
	utf32.ucs4le = 'utf32le';
	utf32.ucs4be = 'utf32be';

	Utf32Codec.prototype.encoder = Utf32Encoder;
	Utf32Codec.prototype.decoder = Utf32Decoder;

	// -- Encoding

	function Utf32Encoder(options, codec) {
	    this.isLE = codec.isLE;
	    this.highSurrogate = 0;
	}

	Utf32Encoder.prototype.write = function(str) {
	    var src = Buffer.from(str, 'ucs2');
	    var dst = Buffer.alloc(src.length * 2);
	    var write32 = this.isLE ? dst.writeUInt32LE : dst.writeUInt32BE;
	    var offset = 0;

	    for (var i = 0; i < src.length; i += 2) {
	        var code = src.readUInt16LE(i);
	        var isHighSurrogate = (0xD800 <= code && code < 0xDC00);
	        var isLowSurrogate = (0xDC00 <= code && code < 0xE000);

	        if (this.highSurrogate) {
	            if (isHighSurrogate || !isLowSurrogate) {
	                // There shouldn't be two high surrogates in a row, nor a high surrogate which isn't followed by a low
	                // surrogate. If this happens, keep the pending high surrogate as a stand-alone semi-invalid character
	                // (technically wrong, but expected by some applications, like Windows file names).
	                write32.call(dst, this.highSurrogate, offset);
	                offset += 4;
	            }
	            else {
	                // Create 32-bit value from high and low surrogates;
	                var codepoint = (((this.highSurrogate - 0xD800) << 10) | (code - 0xDC00)) + 0x10000;

	                write32.call(dst, codepoint, offset);
	                offset += 4;
	                this.highSurrogate = 0;

	                continue;
	            }
	        }

	        if (isHighSurrogate)
	            this.highSurrogate = code;
	        else {
	            // Even if the current character is a low surrogate, with no previous high surrogate, we'll
	            // encode it as a semi-invalid stand-alone character for the same reasons expressed above for
	            // unpaired high surrogates.
	            write32.call(dst, code, offset);
	            offset += 4;
	            this.highSurrogate = 0;
	        }
	    }

	    if (offset < dst.length)
	        dst = dst.slice(0, offset);

	    return dst;
	};

	Utf32Encoder.prototype.end = function() {
	    // Treat any leftover high surrogate as a semi-valid independent character.
	    if (!this.highSurrogate)
	        return;

	    var buf = Buffer.alloc(4);

	    if (this.isLE)
	        buf.writeUInt32LE(this.highSurrogate, 0);
	    else
	        buf.writeUInt32BE(this.highSurrogate, 0);

	    this.highSurrogate = 0;

	    return buf;
	};

	// -- Decoding

	function Utf32Decoder(options, codec) {
	    this.isLE = codec.isLE;
	    this.badChar = codec.iconv.defaultCharUnicode.charCodeAt(0);
	    this.overflow = null;
	}

	Utf32Decoder.prototype.write = function(src) {
	    if (src.length === 0)
	        return '';

	    if (this.overflow)
	        src = Buffer.concat([this.overflow, src]);

	    var goodLength = src.length - src.length % 4;

	    if (src.length !== goodLength) {
	        this.overflow = src.slice(goodLength);
	        src = src.slice(0, goodLength);
	    }
	    else
	        this.overflow = null;

	    var dst = Buffer.alloc(goodLength);
	    var offset = 0;

	    for (var i = 0; i < goodLength; i += 4) {
	        var codepoint = this.isLE ? src.readUInt32LE(i) : src.readUInt32BE(i);

	        if (codepoint < 0x10000) {
	            // Simple 16-bit character
	            dst.writeUInt16LE(codepoint, offset);
	            offset += 2;
	        }
	        else {
	            if (codepoint > 0x10FFFF) {
	                // Not a valid Unicode codepoint
	                dst.writeUInt16LE(this.badChar, offset);
	                offset += 2;
	            }
	            else {
	                // Create high and low surrogates.
	                codepoint -= 0x10000;
	                var high = 0xD800 | (codepoint >> 10);
	                var low = 0xDC00 + (codepoint & 0x3FF);
	                dst.writeUInt16LE(high, offset);
	                offset += 2;
	                dst.writeUInt16LE(low, offset);
	                offset += 2;
	            }
	        }
	    }

	    return dst.slice(0, offset).toString('ucs2');
	};

	Utf32Decoder.prototype.end = function() {
	    this.overflow = null;
	};

	// == UTF-32 Auto codec =============================================================
	// Decoder chooses automatically from UTF-32LE and UTF-32BE using BOM and space-based heuristic.
	// Defaults to UTF-32LE. http://en.wikipedia.org/wiki/UTF-32
	// Encoder/decoder default can be changed: iconv.decode(buf, 'utf32', {defaultEncoding: 'utf-32be'});

	// Encoder prepends BOM (which can be overridden with (addBOM: false}).

	utf32.utf32 = Utf32AutoCodec;
	utf32.ucs4 = Utf32AutoCodec;

	function Utf32AutoCodec(options, iconv) {
	    this.iconv = iconv;
	}

	Utf32AutoCodec.prototype.encoder = Utf32AutoEncoder;
	Utf32AutoCodec.prototype.decoder = Utf32AutoDecoder;

	// -- Encoding

	function Utf32AutoEncoder(options, codec) {
	    options = options || {};

	    if (options.addBOM === undefined)
	        options.addBOM = true;

	    this.encoder = codec.iconv.getEncoder(options.defaultEncoding || 'utf-32le', options);
	}

	Utf32AutoEncoder.prototype.write = function(str) {
	    return this.encoder.write(str);
	};

	Utf32AutoEncoder.prototype.end = function() {
	    return this.encoder.end();
	};

	// -- Decoding

	function Utf32AutoDecoder(options, codec) {
	    this.decoder = null;
	    this.initialBytes = [];
	    this.initialBytesLen = 0;
	    this.options = options || {};
	    this.iconv = codec.iconv;
	}

	Utf32AutoDecoder.prototype.write = function(buf) {
	    if (!this.decoder) {
	        // Codec is not chosen yet. Accumulate initial bytes.
	        this.initialBytes.push(buf);
	        this.initialBytesLen += buf.length;

	        if (this.initialBytesLen < 32) // We need more bytes to use space heuristic (see below)
	            return '';

	        // We have enough bytes -> detect endianness.
	        var buf2 = Buffer.concat(this.initialBytes),
	            encoding = detectEncoding(buf2, this.options.defaultEncoding);
	        this.decoder = this.iconv.getDecoder(encoding, this.options);
	        this.initialBytes.length = this.initialBytesLen = 0;
	    }

	    return this.decoder.write(buf);
	};

	Utf32AutoDecoder.prototype.end = function() {
	    if (!this.decoder) {
	        var buf = Buffer.concat(this.initialBytes),
	            encoding = detectEncoding(buf, this.options.defaultEncoding);
	        this.decoder = this.iconv.getDecoder(encoding, this.options);

	        var res = this.decoder.write(buf),
	            trail = this.decoder.end();

	        return trail ? (res + trail) : res;
	    }

	    return this.decoder.end();
	};

	function detectEncoding(buf, defaultEncoding) {
	    var enc = defaultEncoding || 'utf-32le';

	    if (buf.length >= 4) {
	        // Check BOM.
	        if (buf.readUInt32BE(0) === 0xFEFF) // UTF-32LE BOM
	            enc = 'utf-32be';
	        else if (buf.readUInt32LE(0) === 0xFEFF) // UTF-32LE BOM
	            enc = 'utf-32le';
	        else {
	            // No BOM found. Try to deduce encoding from initial content.
	            // Using the wrong endian-ism for UTF-32 will very often result in codepoints that are beyond
	            // the valid Unicode limit of 0x10FFFF. That will be used as the primary determinant.
	            //
	            // Further, we can suppose the content is mostly plain ASCII chars (U+00**).
	            // So, we count ASCII as if it was LE or BE, and decide from that.
	            var invalidLE = 0, invalidBE = 0;
	            var asciiCharsLE = 0, asciiCharsBE = 0, // Counts of chars in both positions
	                _len = Math.min(buf.length - (buf.length % 4), 128); // Len is always even.

	            for (var i = 0; i < _len; i += 4) {
	                var b0 = buf[i], b1  = buf[i + 1], b2 = buf[i + 2], b3 = buf[i + 3];

	                if (b0 !== 0 || b1 > 0x10) ++invalidBE;
	                if (b3 !== 0 || b2 > 0x10) ++invalidLE;

	                if (b0 === 0 && b1 === 0 && b2 === 0 && b3 !== 0) asciiCharsBE++;
	                if (b0 !== 0 && b1 === 0 && b2 === 0 && b3 === 0) asciiCharsLE++;
	            }

	            if (invalidBE < invalidLE)
	                enc = 'utf-32be';
	            else if (invalidLE < invalidBE)
	                enc = 'utf-32le';
	            if (asciiCharsBE > asciiCharsLE)
	                enc = 'utf-32be';
	            else if (asciiCharsBE < asciiCharsLE)
	                enc = 'utf-32le';
	        }
	    }

	    return enc;
	}
	return utf32;
}

var utf16 = {};

var hasRequiredUtf16;

function requireUtf16 () {
	if (hasRequiredUtf16) return utf16;
	hasRequiredUtf16 = 1;
	var Buffer = requireSafer().Buffer;

	// Note: UTF16-LE (or UCS2) codec is Node.js native. See encodings/internal.js

	// == UTF16-BE codec. ==========================================================

	utf16.utf16be = Utf16BECodec;
	function Utf16BECodec() {
	}

	Utf16BECodec.prototype.encoder = Utf16BEEncoder;
	Utf16BECodec.prototype.decoder = Utf16BEDecoder;
	Utf16BECodec.prototype.bomAware = true;


	// -- Encoding

	function Utf16BEEncoder() {
	}

	Utf16BEEncoder.prototype.write = function(str) {
	    var buf = Buffer.from(str, 'ucs2');
	    for (var i = 0; i < buf.length; i += 2) {
	        var tmp = buf[i]; buf[i] = buf[i+1]; buf[i+1] = tmp;
	    }
	    return buf;
	};

	Utf16BEEncoder.prototype.end = function() {
	};


	// -- Decoding

	function Utf16BEDecoder() {
	    this.overflowByte = -1;
	}

	Utf16BEDecoder.prototype.write = function(buf) {
	    if (buf.length == 0)
	        return '';

	    var buf2 = Buffer.alloc(buf.length + 1),
	        i = 0, j = 0;

	    if (this.overflowByte !== -1) {
	        buf2[0] = buf[0];
	        buf2[1] = this.overflowByte;
	        i = 1; j = 2;
	    }

	    for (; i < buf.length-1; i += 2, j+= 2) {
	        buf2[j] = buf[i+1];
	        buf2[j+1] = buf[i];
	    }

	    this.overflowByte = (i == buf.length-1) ? buf[buf.length-1] : -1;

	    return buf2.slice(0, j).toString('ucs2');
	};

	Utf16BEDecoder.prototype.end = function() {
	};


	// == UTF-16 codec =============================================================
	// Decoder chooses automatically from UTF-16LE and UTF-16BE using BOM and space-based heuristic.
	// Defaults to UTF-16LE, as it's prevalent and default in Node.
	// http://en.wikipedia.org/wiki/UTF-16 and http://encoding.spec.whatwg.org/#utf-16le
	// Decoder default can be changed: iconv.decode(buf, 'utf16', {defaultEncoding: 'utf-16be'});

	// Encoder uses UTF-16LE and prepends BOM (which can be overridden with addBOM: false).

	utf16.utf16 = Utf16Codec;
	function Utf16Codec(codecOptions, iconv) {
	    this.iconv = iconv;
	}

	Utf16Codec.prototype.encoder = Utf16Encoder;
	Utf16Codec.prototype.decoder = Utf16Decoder;


	// -- Encoding (pass-through)

	function Utf16Encoder(options, codec) {
	    options = options || {};
	    if (options.addBOM === undefined)
	        options.addBOM = true;
	    this.encoder = codec.iconv.getEncoder('utf-16le', options);
	}

	Utf16Encoder.prototype.write = function(str) {
	    return this.encoder.write(str);
	};

	Utf16Encoder.prototype.end = function() {
	    return this.encoder.end();
	};


	// -- Decoding

	function Utf16Decoder(options, codec) {
	    this.decoder = null;
	    this.initialBytes = [];
	    this.initialBytesLen = 0;

	    this.options = options || {};
	    this.iconv = codec.iconv;
	}

	Utf16Decoder.prototype.write = function(buf) {
	    if (!this.decoder) {
	        // Codec is not chosen yet. Accumulate initial bytes.
	        this.initialBytes.push(buf);
	        this.initialBytesLen += buf.length;
	        
	        if (this.initialBytesLen < 16) // We need more bytes to use space heuristic (see below)
	            return '';

	        // We have enough bytes -> detect endianness.
	        var buf = Buffer.concat(this.initialBytes),
	            encoding = detectEncoding(buf, this.options.defaultEncoding);
	        this.decoder = this.iconv.getDecoder(encoding, this.options);
	        this.initialBytes.length = this.initialBytesLen = 0;
	    }

	    return this.decoder.write(buf);
	};

	Utf16Decoder.prototype.end = function() {
	    if (!this.decoder) {
	        var buf = Buffer.concat(this.initialBytes),
	            encoding = detectEncoding(buf, this.options.defaultEncoding);
	        this.decoder = this.iconv.getDecoder(encoding, this.options);

	        var res = this.decoder.write(buf),
	            trail = this.decoder.end();

	        return trail ? (res + trail) : res;
	    }
	    return this.decoder.end();
	};

	function detectEncoding(buf, defaultEncoding) {
	    var enc = defaultEncoding || 'utf-16le';

	    if (buf.length >= 2) {
	        // Check BOM.
	        if (buf[0] == 0xFE && buf[1] == 0xFF) // UTF-16BE BOM
	            enc = 'utf-16be';
	        else if (buf[0] == 0xFF && buf[1] == 0xFE) // UTF-16LE BOM
	            enc = 'utf-16le';
	        else {
	            // No BOM found. Try to deduce encoding from initial content.
	            // Most of the time, the content has ASCII chars (U+00**), but the opposite (U+**00) is uncommon.
	            // So, we count ASCII as if it was LE or BE, and decide from that.
	            var asciiCharsLE = 0, asciiCharsBE = 0, // Counts of chars in both positions
	                _len = Math.min(buf.length - (buf.length % 2), 64); // Len is always even.

	            for (var i = 0; i < _len; i += 2) {
	                if (buf[i] === 0 && buf[i+1] !== 0) asciiCharsBE++;
	                if (buf[i] !== 0 && buf[i+1] === 0) asciiCharsLE++;
	            }

	            if (asciiCharsBE > asciiCharsLE)
	                enc = 'utf-16be';
	            else if (asciiCharsBE < asciiCharsLE)
	                enc = 'utf-16le';
	        }
	    }

	    return enc;
	}
	return utf16;
}

var utf7 = {};

var hasRequiredUtf7;

function requireUtf7 () {
	if (hasRequiredUtf7) return utf7;
	hasRequiredUtf7 = 1;
	var Buffer = requireSafer().Buffer;

	// UTF-7 codec, according to https://tools.ietf.org/html/rfc2152
	// See also below a UTF-7-IMAP codec, according to http://tools.ietf.org/html/rfc3501#section-5.1.3

	utf7.utf7 = Utf7Codec;
	utf7.unicode11utf7 = 'utf7'; // Alias UNICODE-1-1-UTF-7
	function Utf7Codec(codecOptions, iconv) {
	    this.iconv = iconv;
	}
	Utf7Codec.prototype.encoder = Utf7Encoder;
	Utf7Codec.prototype.decoder = Utf7Decoder;
	Utf7Codec.prototype.bomAware = true;


	// -- Encoding

	var nonDirectChars = /[^A-Za-z0-9'\(\),-\.\/:\? \n\r\t]+/g;

	function Utf7Encoder(options, codec) {
	    this.iconv = codec.iconv;
	}

	Utf7Encoder.prototype.write = function(str) {
	    // Naive implementation.
	    // Non-direct chars are encoded as "+<base64>-"; single "+" char is encoded as "+-".
	    return Buffer.from(str.replace(nonDirectChars, function(chunk) {
	        return "+" + (chunk === '+' ? '' : 
	            this.iconv.encode(chunk, 'utf16-be').toString('base64').replace(/=+$/, '')) 
	            + "-";
	    }.bind(this)));
	};

	Utf7Encoder.prototype.end = function() {
	};


	// -- Decoding

	function Utf7Decoder(options, codec) {
	    this.iconv = codec.iconv;
	    this.inBase64 = false;
	    this.base64Accum = '';
	}

	var base64Regex = /[A-Za-z0-9\/+]/;
	var base64Chars = [];
	for (var i = 0; i < 256; i++)
	    base64Chars[i] = base64Regex.test(String.fromCharCode(i));

	var plusChar = '+'.charCodeAt(0), 
	    minusChar = '-'.charCodeAt(0),
	    andChar = '&'.charCodeAt(0);

	Utf7Decoder.prototype.write = function(buf) {
	    var res = "", lastI = 0,
	        inBase64 = this.inBase64,
	        base64Accum = this.base64Accum;

	    // The decoder is more involved as we must handle chunks in stream.

	    for (var i = 0; i < buf.length; i++) {
	        if (!inBase64) { // We're in direct mode.
	            // Write direct chars until '+'
	            if (buf[i] == plusChar) {
	                res += this.iconv.decode(buf.slice(lastI, i), "ascii"); // Write direct chars.
	                lastI = i+1;
	                inBase64 = true;
	            }
	        } else { // We decode base64.
	            if (!base64Chars[buf[i]]) { // Base64 ended.
	                if (i == lastI && buf[i] == minusChar) {// "+-" -> "+"
	                    res += "+";
	                } else {
	                    var b64str = base64Accum + buf.slice(lastI, i).toString();
	                    res += this.iconv.decode(Buffer.from(b64str, 'base64'), "utf16-be");
	                }

	                if (buf[i] != minusChar) // Minus is absorbed after base64.
	                    i--;

	                lastI = i+1;
	                inBase64 = false;
	                base64Accum = '';
	            }
	        }
	    }

	    if (!inBase64) {
	        res += this.iconv.decode(buf.slice(lastI), "ascii"); // Write direct chars.
	    } else {
	        var b64str = base64Accum + buf.slice(lastI).toString();

	        var canBeDecoded = b64str.length - (b64str.length % 8); // Minimal chunk: 2 quads -> 2x3 bytes -> 3 chars.
	        base64Accum = b64str.slice(canBeDecoded); // The rest will be decoded in future.
	        b64str = b64str.slice(0, canBeDecoded);

	        res += this.iconv.decode(Buffer.from(b64str, 'base64'), "utf16-be");
	    }

	    this.inBase64 = inBase64;
	    this.base64Accum = base64Accum;

	    return res;
	};

	Utf7Decoder.prototype.end = function() {
	    var res = "";
	    if (this.inBase64 && this.base64Accum.length > 0)
	        res = this.iconv.decode(Buffer.from(this.base64Accum, 'base64'), "utf16-be");

	    this.inBase64 = false;
	    this.base64Accum = '';
	    return res;
	};


	// UTF-7-IMAP codec.
	// RFC3501 Sec. 5.1.3 Modified UTF-7 (http://tools.ietf.org/html/rfc3501#section-5.1.3)
	// Differences:
	//  * Base64 part is started by "&" instead of "+"
	//  * Direct characters are 0x20-0x7E, except "&" (0x26)
	//  * In Base64, "," is used instead of "/"
	//  * Base64 must not be used to represent direct characters.
	//  * No implicit shift back from Base64 (should always end with '-')
	//  * String must end in non-shifted position.
	//  * "-&" while in base64 is not allowed.


	utf7.utf7imap = Utf7IMAPCodec;
	function Utf7IMAPCodec(codecOptions, iconv) {
	    this.iconv = iconv;
	}
	Utf7IMAPCodec.prototype.encoder = Utf7IMAPEncoder;
	Utf7IMAPCodec.prototype.decoder = Utf7IMAPDecoder;
	Utf7IMAPCodec.prototype.bomAware = true;


	// -- Encoding

	function Utf7IMAPEncoder(options, codec) {
	    this.iconv = codec.iconv;
	    this.inBase64 = false;
	    this.base64Accum = Buffer.alloc(6);
	    this.base64AccumIdx = 0;
	}

	Utf7IMAPEncoder.prototype.write = function(str) {
	    var inBase64 = this.inBase64,
	        base64Accum = this.base64Accum,
	        base64AccumIdx = this.base64AccumIdx,
	        buf = Buffer.alloc(str.length*5 + 10), bufIdx = 0;

	    for (var i = 0; i < str.length; i++) {
	        var uChar = str.charCodeAt(i);
	        if (0x20 <= uChar && uChar <= 0x7E) { // Direct character or '&'.
	            if (inBase64) {
	                if (base64AccumIdx > 0) {
	                    bufIdx += buf.write(base64Accum.slice(0, base64AccumIdx).toString('base64').replace(/\//g, ',').replace(/=+$/, ''), bufIdx);
	                    base64AccumIdx = 0;
	                }

	                buf[bufIdx++] = minusChar; // Write '-', then go to direct mode.
	                inBase64 = false;
	            }

	            if (!inBase64) {
	                buf[bufIdx++] = uChar; // Write direct character

	                if (uChar === andChar)  // Ampersand -> '&-'
	                    buf[bufIdx++] = minusChar;
	            }

	        } else { // Non-direct character
	            if (!inBase64) {
	                buf[bufIdx++] = andChar; // Write '&', then go to base64 mode.
	                inBase64 = true;
	            }
	            if (inBase64) {
	                base64Accum[base64AccumIdx++] = uChar >> 8;
	                base64Accum[base64AccumIdx++] = uChar & 0xFF;

	                if (base64AccumIdx == base64Accum.length) {
	                    bufIdx += buf.write(base64Accum.toString('base64').replace(/\//g, ','), bufIdx);
	                    base64AccumIdx = 0;
	                }
	            }
	        }
	    }

	    this.inBase64 = inBase64;
	    this.base64AccumIdx = base64AccumIdx;

	    return buf.slice(0, bufIdx);
	};

	Utf7IMAPEncoder.prototype.end = function() {
	    var buf = Buffer.alloc(10), bufIdx = 0;
	    if (this.inBase64) {
	        if (this.base64AccumIdx > 0) {
	            bufIdx += buf.write(this.base64Accum.slice(0, this.base64AccumIdx).toString('base64').replace(/\//g, ',').replace(/=+$/, ''), bufIdx);
	            this.base64AccumIdx = 0;
	        }

	        buf[bufIdx++] = minusChar; // Write '-', then go to direct mode.
	        this.inBase64 = false;
	    }

	    return buf.slice(0, bufIdx);
	};


	// -- Decoding

	function Utf7IMAPDecoder(options, codec) {
	    this.iconv = codec.iconv;
	    this.inBase64 = false;
	    this.base64Accum = '';
	}

	var base64IMAPChars = base64Chars.slice();
	base64IMAPChars[','.charCodeAt(0)] = true;

	Utf7IMAPDecoder.prototype.write = function(buf) {
	    var res = "", lastI = 0,
	        inBase64 = this.inBase64,
	        base64Accum = this.base64Accum;

	    // The decoder is more involved as we must handle chunks in stream.
	    // It is forgiving, closer to standard UTF-7 (for example, '-' is optional at the end).

	    for (var i = 0; i < buf.length; i++) {
	        if (!inBase64) { // We're in direct mode.
	            // Write direct chars until '&'
	            if (buf[i] == andChar) {
	                res += this.iconv.decode(buf.slice(lastI, i), "ascii"); // Write direct chars.
	                lastI = i+1;
	                inBase64 = true;
	            }
	        } else { // We decode base64.
	            if (!base64IMAPChars[buf[i]]) { // Base64 ended.
	                if (i == lastI && buf[i] == minusChar) { // "&-" -> "&"
	                    res += "&";
	                } else {
	                    var b64str = base64Accum + buf.slice(lastI, i).toString().replace(/,/g, '/');
	                    res += this.iconv.decode(Buffer.from(b64str, 'base64'), "utf16-be");
	                }

	                if (buf[i] != minusChar) // Minus may be absorbed after base64.
	                    i--;

	                lastI = i+1;
	                inBase64 = false;
	                base64Accum = '';
	            }
	        }
	    }

	    if (!inBase64) {
	        res += this.iconv.decode(buf.slice(lastI), "ascii"); // Write direct chars.
	    } else {
	        var b64str = base64Accum + buf.slice(lastI).toString().replace(/,/g, '/');

	        var canBeDecoded = b64str.length - (b64str.length % 8); // Minimal chunk: 2 quads -> 2x3 bytes -> 3 chars.
	        base64Accum = b64str.slice(canBeDecoded); // The rest will be decoded in future.
	        b64str = b64str.slice(0, canBeDecoded);

	        res += this.iconv.decode(Buffer.from(b64str, 'base64'), "utf16-be");
	    }

	    this.inBase64 = inBase64;
	    this.base64Accum = base64Accum;

	    return res;
	};

	Utf7IMAPDecoder.prototype.end = function() {
	    var res = "";
	    if (this.inBase64 && this.base64Accum.length > 0)
	        res = this.iconv.decode(Buffer.from(this.base64Accum, 'base64'), "utf16-be");

	    this.inBase64 = false;
	    this.base64Accum = '';
	    return res;
	};
	return utf7;
}

var sbcsCodec = {};

var hasRequiredSbcsCodec;

function requireSbcsCodec () {
	if (hasRequiredSbcsCodec) return sbcsCodec;
	hasRequiredSbcsCodec = 1;
	var Buffer = requireSafer().Buffer;

	// Single-byte codec. Needs a 'chars' string parameter that contains 256 or 128 chars that
	// correspond to encoded bytes (if 128 - then lower half is ASCII). 

	sbcsCodec._sbcs = SBCSCodec;
	function SBCSCodec(codecOptions, iconv) {
	    if (!codecOptions)
	        throw new Error("SBCS codec is called without the data.")
	    
	    // Prepare char buffer for decoding.
	    if (!codecOptions.chars || (codecOptions.chars.length !== 128 && codecOptions.chars.length !== 256))
	        throw new Error("Encoding '"+codecOptions.type+"' has incorrect 'chars' (must be of len 128 or 256)");
	    
	    if (codecOptions.chars.length === 128) {
	        var asciiString = "";
	        for (var i = 0; i < 128; i++)
	            asciiString += String.fromCharCode(i);
	        codecOptions.chars = asciiString + codecOptions.chars;
	    }

	    this.decodeBuf = Buffer.from(codecOptions.chars, 'ucs2');
	    
	    // Encoding buffer.
	    var encodeBuf = Buffer.alloc(65536, iconv.defaultCharSingleByte.charCodeAt(0));

	    for (var i = 0; i < codecOptions.chars.length; i++)
	        encodeBuf[codecOptions.chars.charCodeAt(i)] = i;

	    this.encodeBuf = encodeBuf;
	}

	SBCSCodec.prototype.encoder = SBCSEncoder;
	SBCSCodec.prototype.decoder = SBCSDecoder;


	function SBCSEncoder(options, codec) {
	    this.encodeBuf = codec.encodeBuf;
	}

	SBCSEncoder.prototype.write = function(str) {
	    var buf = Buffer.alloc(str.length);
	    for (var i = 0; i < str.length; i++)
	        buf[i] = this.encodeBuf[str.charCodeAt(i)];
	    
	    return buf;
	};

	SBCSEncoder.prototype.end = function() {
	};


	function SBCSDecoder(options, codec) {
	    this.decodeBuf = codec.decodeBuf;
	}

	SBCSDecoder.prototype.write = function(buf) {
	    // Strings are immutable in JS -> we use ucs2 buffer to speed up computations.
	    var decodeBuf = this.decodeBuf;
	    var newBuf = Buffer.alloc(buf.length*2);
	    var idx1 = 0, idx2 = 0;
	    for (var i = 0; i < buf.length; i++) {
	        idx1 = buf[i]*2; idx2 = i*2;
	        newBuf[idx2] = decodeBuf[idx1];
	        newBuf[idx2+1] = decodeBuf[idx1+1];
	    }
	    return newBuf.toString('ucs2');
	};

	SBCSDecoder.prototype.end = function() {
	};
	return sbcsCodec;
}

var sbcsData;
var hasRequiredSbcsData;

function requireSbcsData () {
	if (hasRequiredSbcsData) return sbcsData;
	hasRequiredSbcsData = 1;

	// Manually added data to be used by sbcs codec in addition to generated one.

	sbcsData = {
	    // Not supported by iconv, not sure why.
	    "10029": "maccenteuro",
	    "maccenteuro": {
	        "type": "_sbcs",
	        "chars": "ÄĀāÉĄÖÜáąČäčĆćéŹźĎíďĒēĖóėôöõúĚěü†°Ę£§•¶ß®©™ę¨≠ģĮįĪ≤≥īĶ∂∑łĻļĽľĹĺŅņŃ¬√ńŇ∆«»… ňŐÕőŌ–—“”‘’÷◊ōŔŕŘ‹›řŖŗŠ‚„šŚśÁŤťÍŽžŪÓÔūŮÚůŰűŲųÝýķŻŁżĢˇ"
	    },

	    "808": "cp808",
	    "ibm808": "cp808",
	    "cp808": {
	        "type": "_sbcs",
	        "chars": "АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмноп░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀рстуфхцчшщъыьэюяЁёЄєЇїЎў°∙·√№€■ "
	    },

	    "mik": {
	        "type": "_sbcs",
	        "chars": "АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя└┴┬├─┼╣║╚╔╩╦╠═╬┐░▒▓│┤№§╗╝┘┌█▄▌▐▀αßΓπΣσµτΦΘΩδ∞φε∩≡±≥≤⌠⌡÷≈°∙·√ⁿ²■ "
	    },

	    "cp720": {
	        "type": "_sbcs",
	        "chars": "\x80\x81éâ\x84à\x86çêëèïî\x8d\x8e\x8f\x90\u0651\u0652ô¤ـûùءآأؤ£إئابةتثجحخدذرزسشص«»░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀ضطظعغفµقكلمنهوىي≡\u064b\u064c\u064d\u064e\u064f\u0650≈°∙·√ⁿ²■\u00a0"
	    },

	    // Aliases of generated encodings.
	    "ascii8bit": "ascii",
	    "usascii": "ascii",
	    "ansix34": "ascii",
	    "ansix341968": "ascii",
	    "ansix341986": "ascii",
	    "csascii": "ascii",
	    "cp367": "ascii",
	    "ibm367": "ascii",
	    "isoir6": "ascii",
	    "iso646us": "ascii",
	    "iso646irv": "ascii",
	    "us": "ascii",

	    "latin1": "iso88591",
	    "latin2": "iso88592",
	    "latin3": "iso88593",
	    "latin4": "iso88594",
	    "latin5": "iso88599",
	    "latin6": "iso885910",
	    "latin7": "iso885913",
	    "latin8": "iso885914",
	    "latin9": "iso885915",
	    "latin10": "iso885916",

	    "csisolatin1": "iso88591",
	    "csisolatin2": "iso88592",
	    "csisolatin3": "iso88593",
	    "csisolatin4": "iso88594",
	    "csisolatincyrillic": "iso88595",
	    "csisolatinarabic": "iso88596",
	    "csisolatingreek" : "iso88597",
	    "csisolatinhebrew": "iso88598",
	    "csisolatin5": "iso88599",
	    "csisolatin6": "iso885910",

	    "l1": "iso88591",
	    "l2": "iso88592",
	    "l3": "iso88593",
	    "l4": "iso88594",
	    "l5": "iso88599",
	    "l6": "iso885910",
	    "l7": "iso885913",
	    "l8": "iso885914",
	    "l9": "iso885915",
	    "l10": "iso885916",

	    "isoir14": "iso646jp",
	    "isoir57": "iso646cn",
	    "isoir100": "iso88591",
	    "isoir101": "iso88592",
	    "isoir109": "iso88593",
	    "isoir110": "iso88594",
	    "isoir144": "iso88595",
	    "isoir127": "iso88596",
	    "isoir126": "iso88597",
	    "isoir138": "iso88598",
	    "isoir148": "iso88599",
	    "isoir157": "iso885910",
	    "isoir166": "tis620",
	    "isoir179": "iso885913",
	    "isoir199": "iso885914",
	    "isoir203": "iso885915",
	    "isoir226": "iso885916",

	    "cp819": "iso88591",
	    "ibm819": "iso88591",

	    "cyrillic": "iso88595",

	    "arabic": "iso88596",
	    "arabic8": "iso88596",
	    "ecma114": "iso88596",
	    "asmo708": "iso88596",

	    "greek" : "iso88597",
	    "greek8" : "iso88597",
	    "ecma118" : "iso88597",
	    "elot928" : "iso88597",

	    "hebrew": "iso88598",
	    "hebrew8": "iso88598",

	    "turkish": "iso88599",
	    "turkish8": "iso88599",

	    "thai": "iso885911",
	    "thai8": "iso885911",

	    "celtic": "iso885914",
	    "celtic8": "iso885914",
	    "isoceltic": "iso885914",

	    "tis6200": "tis620",
	    "tis62025291": "tis620",
	    "tis62025330": "tis620",

	    "10000": "macroman",
	    "10006": "macgreek",
	    "10007": "maccyrillic",
	    "10079": "maciceland",
	    "10081": "macturkish",

	    "cspc8codepage437": "cp437",
	    "cspc775baltic": "cp775",
	    "cspc850multilingual": "cp850",
	    "cspcp852": "cp852",
	    "cspc862latinhebrew": "cp862",
	    "cpgr": "cp869",

	    "msee": "cp1250",
	    "mscyrl": "cp1251",
	    "msansi": "cp1252",
	    "msgreek": "cp1253",
	    "msturk": "cp1254",
	    "mshebr": "cp1255",
	    "msarab": "cp1256",
	    "winbaltrim": "cp1257",

	    "cp20866": "koi8r",
	    "20866": "koi8r",
	    "ibm878": "koi8r",
	    "cskoi8r": "koi8r",

	    "cp21866": "koi8u",
	    "21866": "koi8u",
	    "ibm1168": "koi8u",

	    "strk10482002": "rk1048",

	    "tcvn5712": "tcvn",
	    "tcvn57121": "tcvn",

	    "gb198880": "iso646cn",
	    "cn": "iso646cn",

	    "csiso14jisc6220ro": "iso646jp",
	    "jisc62201969ro": "iso646jp",
	    "jp": "iso646jp",

	    "cshproman8": "hproman8",
	    "r8": "hproman8",
	    "roman8": "hproman8",
	    "xroman8": "hproman8",
	    "ibm1051": "hproman8",

	    "mac": "macintosh",
	    "csmacintosh": "macintosh",
	};
	return sbcsData;
}

var sbcsDataGenerated;
var hasRequiredSbcsDataGenerated;

function requireSbcsDataGenerated () {
	if (hasRequiredSbcsDataGenerated) return sbcsDataGenerated;
	hasRequiredSbcsDataGenerated = 1;

	// Generated data for sbcs codec. Don't edit manually. Regenerate using generation/gen-sbcs.js script.
	sbcsDataGenerated = {
	  "437": "cp437",
	  "737": "cp737",
	  "775": "cp775",
	  "850": "cp850",
	  "852": "cp852",
	  "855": "cp855",
	  "856": "cp856",
	  "857": "cp857",
	  "858": "cp858",
	  "860": "cp860",
	  "861": "cp861",
	  "862": "cp862",
	  "863": "cp863",
	  "864": "cp864",
	  "865": "cp865",
	  "866": "cp866",
	  "869": "cp869",
	  "874": "windows874",
	  "922": "cp922",
	  "1046": "cp1046",
	  "1124": "cp1124",
	  "1125": "cp1125",
	  "1129": "cp1129",
	  "1133": "cp1133",
	  "1161": "cp1161",
	  "1162": "cp1162",
	  "1163": "cp1163",
	  "1250": "windows1250",
	  "1251": "windows1251",
	  "1252": "windows1252",
	  "1253": "windows1253",
	  "1254": "windows1254",
	  "1255": "windows1255",
	  "1256": "windows1256",
	  "1257": "windows1257",
	  "1258": "windows1258",
	  "28591": "iso88591",
	  "28592": "iso88592",
	  "28593": "iso88593",
	  "28594": "iso88594",
	  "28595": "iso88595",
	  "28596": "iso88596",
	  "28597": "iso88597",
	  "28598": "iso88598",
	  "28599": "iso88599",
	  "28600": "iso885910",
	  "28601": "iso885911",
	  "28603": "iso885913",
	  "28604": "iso885914",
	  "28605": "iso885915",
	  "28606": "iso885916",
	  "windows874": {
	    "type": "_sbcs",
	    "chars": "€����…�����������‘’“”•–—�������� กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพฟภมยรฤลฦวศษสหฬอฮฯะัาำิีึืฺุู����฿เแโใไๅๆ็่้๊๋์ํ๎๏๐๑๒๓๔๕๖๗๘๙๚๛����"
	  },
	  "win874": "windows874",
	  "cp874": "windows874",
	  "windows1250": {
	    "type": "_sbcs",
	    "chars": "€�‚�„…†‡�‰Š‹ŚŤŽŹ�‘’“”•–—�™š›śťžź ˇ˘Ł¤Ą¦§¨©Ş«¬­®Ż°±˛ł´µ¶·¸ąş»Ľ˝ľżŔÁÂĂÄĹĆÇČÉĘËĚÍÎĎĐŃŇÓÔŐÖ×ŘŮÚŰÜÝŢßŕáâăäĺćçčéęëěíîďđńňóôőö÷řůúűüýţ˙"
	  },
	  "win1250": "windows1250",
	  "cp1250": "windows1250",
	  "windows1251": {
	    "type": "_sbcs",
	    "chars": "ЂЃ‚ѓ„…†‡€‰Љ‹ЊЌЋЏђ‘’“”•–—�™љ›њќћџ ЎўЈ¤Ґ¦§Ё©Є«¬­®Ї°±Ііґµ¶·ё№є»јЅѕїАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя"
	  },
	  "win1251": "windows1251",
	  "cp1251": "windows1251",
	  "windows1252": {
	    "type": "_sbcs",
	    "chars": "€�‚ƒ„…†‡ˆ‰Š‹Œ�Ž��‘’“”•–—˜™š›œ�žŸ ¡¢£¤¥¦§¨©ª«¬­®¯°±²³´µ¶·¸¹º»¼½¾¿ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖ×ØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõö÷øùúûüýþÿ"
	  },
	  "win1252": "windows1252",
	  "cp1252": "windows1252",
	  "windows1253": {
	    "type": "_sbcs",
	    "chars": "€�‚ƒ„…†‡�‰�‹�����‘’“”•–—�™�›���� ΅Ά£¤¥¦§¨©�«¬­®―°±²³΄µ¶·ΈΉΊ»Ό½ΎΏΐΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡ�ΣΤΥΦΧΨΩΪΫάέήίΰαβγδεζηθικλμνξοπρςστυφχψωϊϋόύώ�"
	  },
	  "win1253": "windows1253",
	  "cp1253": "windows1253",
	  "windows1254": {
	    "type": "_sbcs",
	    "chars": "€�‚ƒ„…†‡ˆ‰Š‹Œ����‘’“”•–—˜™š›œ��Ÿ ¡¢£¤¥¦§¨©ª«¬­®¯°±²³´µ¶·¸¹º»¼½¾¿ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏĞÑÒÓÔÕÖ×ØÙÚÛÜİŞßàáâãäåæçèéêëìíîïğñòóôõö÷øùúûüışÿ"
	  },
	  "win1254": "windows1254",
	  "cp1254": "windows1254",
	  "windows1255": {
	    "type": "_sbcs",
	    "chars": "€�‚ƒ„…†‡ˆ‰�‹�����‘’“”•–—˜™�›���� ¡¢£₪¥¦§¨©×«¬­®¯°±²³´µ¶·¸¹÷»¼½¾¿ְֱֲֳִֵֶַָֹֺֻּֽ־ֿ׀ׁׂ׃װױײ׳״�������אבגדהוזחטיךכלםמןנסעףפץצקרשת��‎‏�"
	  },
	  "win1255": "windows1255",
	  "cp1255": "windows1255",
	  "windows1256": {
	    "type": "_sbcs",
	    "chars": "€پ‚ƒ„…†‡ˆ‰ٹ‹Œچژڈگ‘’“”•–—ک™ڑ›œ‌‍ں ،¢£¤¥¦§¨©ھ«¬­®¯°±²³´µ¶·¸¹؛»¼½¾؟ہءآأؤإئابةتثجحخدذرزسشصض×طظعغـفقكàلâمنهوçèéêëىيîïًٌٍَôُِ÷ّùْûü‎‏ے"
	  },
	  "win1256": "windows1256",
	  "cp1256": "windows1256",
	  "windows1257": {
	    "type": "_sbcs",
	    "chars": "€�‚�„…†‡�‰�‹�¨ˇ¸�‘’“”•–—�™�›�¯˛� �¢£¤�¦§Ø©Ŗ«¬­®Æ°±²³´µ¶·ø¹ŗ»¼½¾æĄĮĀĆÄÅĘĒČÉŹĖĢĶĪĻŠŃŅÓŌÕÖ×ŲŁŚŪÜŻŽßąįāćäåęēčéźėģķīļšńņóōõö÷ųłśūüżž˙"
	  },
	  "win1257": "windows1257",
	  "cp1257": "windows1257",
	  "windows1258": {
	    "type": "_sbcs",
	    "chars": "€�‚ƒ„…†‡ˆ‰�‹Œ����‘’“”•–—˜™�›œ��Ÿ ¡¢£¤¥¦§¨©ª«¬­®¯°±²³´µ¶·¸¹º»¼½¾¿ÀÁÂĂÄÅÆÇÈÉÊË̀ÍÎÏĐÑ̉ÓÔƠÖ×ØÙÚÛÜỮßàáâăäåæçèéêë́íîïđṇ̃óôơö÷øùúûüư₫ÿ"
	  },
	  "win1258": "windows1258",
	  "cp1258": "windows1258",
	  "iso88591": {
	    "type": "_sbcs",
	    "chars": " ¡¢£¤¥¦§¨©ª«¬­®¯°±²³´µ¶·¸¹º»¼½¾¿ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖ×ØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõö÷øùúûüýþÿ"
	  },
	  "cp28591": "iso88591",
	  "iso88592": {
	    "type": "_sbcs",
	    "chars": " Ą˘Ł¤ĽŚ§¨ŠŞŤŹ­ŽŻ°ą˛ł´ľśˇ¸šşťź˝žżŔÁÂĂÄĹĆÇČÉĘËĚÍÎĎĐŃŇÓÔŐÖ×ŘŮÚŰÜÝŢßŕáâăäĺćçčéęëěíîďđńňóôőö÷řůúűüýţ˙"
	  },
	  "cp28592": "iso88592",
	  "iso88593": {
	    "type": "_sbcs",
	    "chars": " Ħ˘£¤�Ĥ§¨İŞĞĴ­�Ż°ħ²³´µĥ·¸ışğĵ½�żÀÁÂ�ÄĊĈÇÈÉÊËÌÍÎÏ�ÑÒÓÔĠÖ×ĜÙÚÛÜŬŜßàáâ�äċĉçèéêëìíîï�ñòóôġö÷ĝùúûüŭŝ˙"
	  },
	  "cp28593": "iso88593",
	  "iso88594": {
	    "type": "_sbcs",
	    "chars": " ĄĸŖ¤ĨĻ§¨ŠĒĢŦ­Ž¯°ą˛ŗ´ĩļˇ¸šēģŧŊžŋĀÁÂÃÄÅÆĮČÉĘËĖÍÎĪĐŅŌĶÔÕÖ×ØŲÚÛÜŨŪßāáâãäåæįčéęëėíîīđņōķôõö÷øųúûüũū˙"
	  },
	  "cp28594": "iso88594",
	  "iso88595": {
	    "type": "_sbcs",
	    "chars": " ЁЂЃЄЅІЇЈЉЊЋЌ­ЎЏАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя№ёђѓєѕіїјљњћќ§ўџ"
	  },
	  "cp28595": "iso88595",
	  "iso88596": {
	    "type": "_sbcs",
	    "chars": " ���¤�������،­�������������؛���؟�ءآأؤإئابةتثجحخدذرزسشصضطظعغ�����ـفقكلمنهوىيًٌٍَُِّْ�������������"
	  },
	  "cp28596": "iso88596",
	  "iso88597": {
	    "type": "_sbcs",
	    "chars": " ‘’£€₯¦§¨©ͺ«¬­�―°±²³΄΅Ά·ΈΉΊ»Ό½ΎΏΐΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡ�ΣΤΥΦΧΨΩΪΫάέήίΰαβγδεζηθικλμνξοπρςστυφχψωϊϋόύώ�"
	  },
	  "cp28597": "iso88597",
	  "iso88598": {
	    "type": "_sbcs",
	    "chars": " �¢£¤¥¦§¨©×«¬­®¯°±²³´µ¶·¸¹÷»¼½¾��������������������������������‗אבגדהוזחטיךכלםמןנסעףפץצקרשת��‎‏�"
	  },
	  "cp28598": "iso88598",
	  "iso88599": {
	    "type": "_sbcs",
	    "chars": " ¡¢£¤¥¦§¨©ª«¬­®¯°±²³´µ¶·¸¹º»¼½¾¿ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏĞÑÒÓÔÕÖ×ØÙÚÛÜİŞßàáâãäåæçèéêëìíîïğñòóôõö÷øùúûüışÿ"
	  },
	  "cp28599": "iso88599",
	  "iso885910": {
	    "type": "_sbcs",
	    "chars": " ĄĒĢĪĨĶ§ĻĐŠŦŽ­ŪŊ°ąēģīĩķ·ļđšŧž―ūŋĀÁÂÃÄÅÆĮČÉĘËĖÍÎÏÐŅŌÓÔÕÖŨØŲÚÛÜÝÞßāáâãäåæįčéęëėíîïðņōóôõöũøųúûüýþĸ"
	  },
	  "cp28600": "iso885910",
	  "iso885911": {
	    "type": "_sbcs",
	    "chars": " กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพฟภมยรฤลฦวศษสหฬอฮฯะัาำิีึืฺุู����฿เแโใไๅๆ็่้๊๋์ํ๎๏๐๑๒๓๔๕๖๗๘๙๚๛����"
	  },
	  "cp28601": "iso885911",
	  "iso885913": {
	    "type": "_sbcs",
	    "chars": " ”¢£¤„¦§Ø©Ŗ«¬­®Æ°±²³“µ¶·ø¹ŗ»¼½¾æĄĮĀĆÄÅĘĒČÉŹĖĢĶĪĻŠŃŅÓŌÕÖ×ŲŁŚŪÜŻŽßąįāćäåęēčéźėģķīļšńņóōõö÷ųłśūüżž’"
	  },
	  "cp28603": "iso885913",
	  "iso885914": {
	    "type": "_sbcs",
	    "chars": " Ḃḃ£ĊċḊ§Ẁ©ẂḋỲ­®ŸḞḟĠġṀṁ¶ṖẁṗẃṠỳẄẅṡÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏŴÑÒÓÔÕÖṪØÙÚÛÜÝŶßàáâãäåæçèéêëìíîïŵñòóôõöṫøùúûüýŷÿ"
	  },
	  "cp28604": "iso885914",
	  "iso885915": {
	    "type": "_sbcs",
	    "chars": " ¡¢£€¥Š§š©ª«¬­®¯°±²³Žµ¶·ž¹º»ŒœŸ¿ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖ×ØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõö÷øùúûüýþÿ"
	  },
	  "cp28605": "iso885915",
	  "iso885916": {
	    "type": "_sbcs",
	    "chars": " ĄąŁ€„Š§š©Ș«Ź­źŻ°±ČłŽ”¶·žčș»ŒœŸżÀÁÂĂÄĆÆÇÈÉÊËÌÍÎÏĐŃÒÓÔŐÖŚŰÙÚÛÜĘȚßàáâăäćæçèéêëìíîïđńòóôőöśűùúûüęțÿ"
	  },
	  "cp28606": "iso885916",
	  "cp437": {
	    "type": "_sbcs",
	    "chars": "ÇüéâäàåçêëèïîìÄÅÉæÆôöòûùÿÖÜ¢£¥₧ƒáíóúñÑªº¿⌐¬½¼¡«»░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀αßΓπΣσµτΦΘΩδ∞φε∩≡±≥≤⌠⌡÷≈°∙·√ⁿ²■ "
	  },
	  "ibm437": "cp437",
	  "csibm437": "cp437",
	  "cp737": {
	    "type": "_sbcs",
	    "chars": "ΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩαβγδεζηθικλμνξοπρσςτυφχψ░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀ωάέήϊίόύϋώΆΈΉΊΌΎΏ±≥≤ΪΫ÷≈°∙·√ⁿ²■ "
	  },
	  "ibm737": "cp737",
	  "csibm737": "cp737",
	  "cp775": {
	    "type": "_sbcs",
	    "chars": "ĆüéāäģåćłēŖŗīŹÄÅÉæÆōöĢ¢ŚśÖÜø£Ø×¤ĀĪóŻżź”¦©®¬½¼Ł«»░▒▓│┤ĄČĘĖ╣║╗╝ĮŠ┐└┴┬├─┼ŲŪ╚╔╩╦╠═╬Žąčęėįšųūž┘┌█▄▌▐▀ÓßŌŃõÕµńĶķĻļņĒŅ’­±“¾¶§÷„°∙·¹³²■ "
	  },
	  "ibm775": "cp775",
	  "csibm775": "cp775",
	  "cp850": {
	    "type": "_sbcs",
	    "chars": "ÇüéâäàåçêëèïîìÄÅÉæÆôöòûùÿÖÜø£Ø×ƒáíóúñÑªº¿®¬½¼¡«»░▒▓│┤ÁÂÀ©╣║╗╝¢¥┐└┴┬├─┼ãÃ╚╔╩╦╠═╬¤ðÐÊËÈıÍÎÏ┘┌█▄¦Ì▀ÓßÔÒõÕµþÞÚÛÙýÝ¯´­±‗¾¶§÷¸°¨·¹³²■ "
	  },
	  "ibm850": "cp850",
	  "csibm850": "cp850",
	  "cp852": {
	    "type": "_sbcs",
	    "chars": "ÇüéâäůćçłëŐőîŹÄĆÉĹĺôöĽľŚśÖÜŤťŁ×čáíóúĄąŽžĘę¬źČş«»░▒▓│┤ÁÂĚŞ╣║╗╝Żż┐└┴┬├─┼Ăă╚╔╩╦╠═╬¤đĐĎËďŇÍÎě┘┌█▄ŢŮ▀ÓßÔŃńňŠšŔÚŕŰýÝţ´­˝˛ˇ˘§÷¸°¨˙űŘř■ "
	  },
	  "ibm852": "cp852",
	  "csibm852": "cp852",
	  "cp855": {
	    "type": "_sbcs",
	    "chars": "ђЂѓЃёЁєЄѕЅіІїЇјЈљЉњЊћЋќЌўЎџЏюЮъЪаАбБцЦдДеЕфФгГ«»░▒▓│┤хХиИ╣║╗╝йЙ┐└┴┬├─┼кК╚╔╩╦╠═╬¤лЛмМнНоОп┘┌█▄Пя▀ЯрРсСтТуУжЖвВьЬ№­ыЫзЗшШэЭщЩчЧ§■ "
	  },
	  "ibm855": "cp855",
	  "csibm855": "cp855",
	  "cp856": {
	    "type": "_sbcs",
	    "chars": "אבגדהוזחטיךכלםמןנסעףפץצקרשת�£�×����������®¬½¼�«»░▒▓│┤���©╣║╗╝¢¥┐└┴┬├─┼��╚╔╩╦╠═╬¤���������┘┌█▄¦�▀������µ�������¯´­±‗¾¶§÷¸°¨·¹³²■ "
	  },
	  "ibm856": "cp856",
	  "csibm856": "cp856",
	  "cp857": {
	    "type": "_sbcs",
	    "chars": "ÇüéâäàåçêëèïîıÄÅÉæÆôöòûùİÖÜø£ØŞşáíóúñÑĞğ¿®¬½¼¡«»░▒▓│┤ÁÂÀ©╣║╗╝¢¥┐└┴┬├─┼ãÃ╚╔╩╦╠═╬¤ºªÊËÈ�ÍÎÏ┘┌█▄¦Ì▀ÓßÔÒõÕµ�×ÚÛÙìÿ¯´­±�¾¶§÷¸°¨·¹³²■ "
	  },
	  "ibm857": "cp857",
	  "csibm857": "cp857",
	  "cp858": {
	    "type": "_sbcs",
	    "chars": "ÇüéâäàåçêëèïîìÄÅÉæÆôöòûùÿÖÜø£Ø×ƒáíóúñÑªº¿®¬½¼¡«»░▒▓│┤ÁÂÀ©╣║╗╝¢¥┐└┴┬├─┼ãÃ╚╔╩╦╠═╬¤ðÐÊËÈ€ÍÎÏ┘┌█▄¦Ì▀ÓßÔÒõÕµþÞÚÛÙýÝ¯´­±‗¾¶§÷¸°¨·¹³²■ "
	  },
	  "ibm858": "cp858",
	  "csibm858": "cp858",
	  "cp860": {
	    "type": "_sbcs",
	    "chars": "ÇüéâãàÁçêÊèÍÔìÃÂÉÀÈôõòÚùÌÕÜ¢£Ù₧ÓáíóúñÑªº¿Ò¬½¼¡«»░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀αßΓπΣσµτΦΘΩδ∞φε∩≡±≥≤⌠⌡÷≈°∙·√ⁿ²■ "
	  },
	  "ibm860": "cp860",
	  "csibm860": "cp860",
	  "cp861": {
	    "type": "_sbcs",
	    "chars": "ÇüéâäàåçêëèÐðÞÄÅÉæÆôöþûÝýÖÜø£Ø₧ƒáíóúÁÍÓÚ¿⌐¬½¼¡«»░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀αßΓπΣσµτΦΘΩδ∞φε∩≡±≥≤⌠⌡÷≈°∙·√ⁿ²■ "
	  },
	  "ibm861": "cp861",
	  "csibm861": "cp861",
	  "cp862": {
	    "type": "_sbcs",
	    "chars": "אבגדהוזחטיךכלםמןנסעףפץצקרשת¢£¥₧ƒáíóúñÑªº¿⌐¬½¼¡«»░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀αßΓπΣσµτΦΘΩδ∞φε∩≡±≥≤⌠⌡÷≈°∙·√ⁿ²■ "
	  },
	  "ibm862": "cp862",
	  "csibm862": "cp862",
	  "cp863": {
	    "type": "_sbcs",
	    "chars": "ÇüéâÂà¶çêëèïî‗À§ÉÈÊôËÏûù¤ÔÜ¢£ÙÛƒ¦´óú¨¸³¯Î⌐¬½¼¾«»░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀αßΓπΣσµτΦΘΩδ∞φε∩≡±≥≤⌠⌡÷≈°∙·√ⁿ²■ "
	  },
	  "ibm863": "cp863",
	  "csibm863": "cp863",
	  "cp864": {
	    "type": "_sbcs",
	    "chars": "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$٪&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~°·∙√▒─│┼┤┬├┴┐┌└┘β∞φ±½¼≈«»ﻷﻸ��ﻻﻼ� ­ﺂ£¤ﺄ��ﺎﺏﺕﺙ،ﺝﺡﺥ٠١٢٣٤٥٦٧٨٩ﻑ؛ﺱﺵﺹ؟¢ﺀﺁﺃﺅﻊﺋﺍﺑﺓﺗﺛﺟﺣﺧﺩﺫﺭﺯﺳﺷﺻﺿﻁﻅﻋﻏ¦¬÷×ﻉـﻓﻗﻛﻟﻣﻧﻫﻭﻯﻳﺽﻌﻎﻍﻡﹽّﻥﻩﻬﻰﻲﻐﻕﻵﻶﻝﻙﻱ■�"
	  },
	  "ibm864": "cp864",
	  "csibm864": "cp864",
	  "cp865": {
	    "type": "_sbcs",
	    "chars": "ÇüéâäàåçêëèïîìÄÅÉæÆôöòûùÿÖÜø£Ø₧ƒáíóúñÑªº¿⌐¬½¼¡«¤░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀αßΓπΣσµτΦΘΩδ∞φε∩≡±≥≤⌠⌡÷≈°∙·√ⁿ²■ "
	  },
	  "ibm865": "cp865",
	  "csibm865": "cp865",
	  "cp866": {
	    "type": "_sbcs",
	    "chars": "АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмноп░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀рстуфхцчшщъыьэюяЁёЄєЇїЎў°∙·√№¤■ "
	  },
	  "ibm866": "cp866",
	  "csibm866": "cp866",
	  "cp869": {
	    "type": "_sbcs",
	    "chars": "������Ά�·¬¦‘’Έ―ΉΊΪΌ��ΎΫ©Ώ²³ά£έήίϊΐόύΑΒΓΔΕΖΗ½ΘΙ«»░▒▓│┤ΚΛΜΝ╣║╗╝ΞΟ┐└┴┬├─┼ΠΡ╚╔╩╦╠═╬ΣΤΥΦΧΨΩαβγ┘┌█▄δε▀ζηθικλμνξοπρσςτ΄­±υφχ§ψ΅°¨ωϋΰώ■ "
	  },
	  "ibm869": "cp869",
	  "csibm869": "cp869",
	  "cp922": {
	    "type": "_sbcs",
	    "chars": " ¡¢£¤¥¦§¨©ª«¬­®‾°±²³´µ¶·¸¹º»¼½¾¿ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏŠÑÒÓÔÕÖ×ØÙÚÛÜÝŽßàáâãäåæçèéêëìíîïšñòóôõö÷øùúûüýžÿ"
	  },
	  "ibm922": "cp922",
	  "csibm922": "cp922",
	  "cp1046": {
	    "type": "_sbcs",
	    "chars": "ﺈ×÷ﹱ■│─┐┌└┘ﹹﹻﹽﹿﹷﺊﻰﻳﻲﻎﻏﻐﻶﻸﻺﻼ ¤ﺋﺑﺗﺛﺟﺣ،­ﺧﺳ٠١٢٣٤٥٦٧٨٩ﺷ؛ﺻﺿﻊ؟ﻋءآأؤإئابةتثجحخدذرزسشصضطﻇعغﻌﺂﺄﺎﻓـفقكلمنهوىيًٌٍَُِّْﻗﻛﻟﻵﻷﻹﻻﻣﻧﻬﻩ�"
	  },
	  "ibm1046": "cp1046",
	  "csibm1046": "cp1046",
	  "cp1124": {
	    "type": "_sbcs",
	    "chars": " ЁЂҐЄЅІЇЈЉЊЋЌ­ЎЏАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя№ёђґєѕіїјљњћќ§ўџ"
	  },
	  "ibm1124": "cp1124",
	  "csibm1124": "cp1124",
	  "cp1125": {
	    "type": "_sbcs",
	    "chars": "АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмноп░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀рстуфхцчшщъыьэюяЁёҐґЄєІіЇї·√№¤■ "
	  },
	  "ibm1125": "cp1125",
	  "csibm1125": "cp1125",
	  "cp1129": {
	    "type": "_sbcs",
	    "chars": " ¡¢£¤¥¦§œ©ª«¬­®¯°±²³Ÿµ¶·Œ¹º»¼½¾¿ÀÁÂĂÄÅÆÇÈÉÊË̀ÍÎÏĐÑ̉ÓÔƠÖ×ØÙÚÛÜỮßàáâăäåæçèéêë́íîïđṇ̃óôơö÷øùúûüư₫ÿ"
	  },
	  "ibm1129": "cp1129",
	  "csibm1129": "cp1129",
	  "cp1133": {
	    "type": "_sbcs",
	    "chars": " ກຂຄງຈສຊຍດຕຖທນບປຜຝພຟມຢຣລວຫອຮ���ຯະາຳິີຶືຸູຼັົຽ���ເແໂໃໄ່້໊໋໌ໍໆ�ໜໝ₭����������������໐໑໒໓໔໕໖໗໘໙��¢¬¦�"
	  },
	  "ibm1133": "cp1133",
	  "csibm1133": "cp1133",
	  "cp1161": {
	    "type": "_sbcs",
	    "chars": "��������������������������������่กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพฟภมยรฤลฦวศษสหฬอฮฯะัาำิีึืฺุู้๊๋€฿เแโใไๅๆ็่้๊๋์ํ๎๏๐๑๒๓๔๕๖๗๘๙๚๛¢¬¦ "
	  },
	  "ibm1161": "cp1161",
	  "csibm1161": "cp1161",
	  "cp1162": {
	    "type": "_sbcs",
	    "chars": "€…‘’“”•–— กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพฟภมยรฤลฦวศษสหฬอฮฯะัาำิีึืฺุู����฿เแโใไๅๆ็่้๊๋์ํ๎๏๐๑๒๓๔๕๖๗๘๙๚๛����"
	  },
	  "ibm1162": "cp1162",
	  "csibm1162": "cp1162",
	  "cp1163": {
	    "type": "_sbcs",
	    "chars": " ¡¢£€¥¦§œ©ª«¬­®¯°±²³Ÿµ¶·Œ¹º»¼½¾¿ÀÁÂĂÄÅÆÇÈÉÊË̀ÍÎÏĐÑ̉ÓÔƠÖ×ØÙÚÛÜỮßàáâăäåæçèéêë́íîïđṇ̃óôơö÷øùúûüư₫ÿ"
	  },
	  "ibm1163": "cp1163",
	  "csibm1163": "cp1163",
	  "maccroatian": {
	    "type": "_sbcs",
	    "chars": "ÄÅÇÉÑÖÜáàâäãåçéèêëíìîïñóòôöõúùûü†°¢£§•¶ß®Š™´¨≠ŽØ∞±≤≥∆µ∂∑∏š∫ªºΩžø¿¡¬√ƒ≈Ć«Č… ÀÃÕŒœĐ—“”‘’÷◊�©⁄¤‹›Æ»–·‚„‰ÂćÁčÈÍÎÏÌÓÔđÒÚÛÙıˆ˜¯πË˚¸Êæˇ"
	  },
	  "maccyrillic": {
	    "type": "_sbcs",
	    "chars": "АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯ†°¢£§•¶І®©™Ђђ≠Ѓѓ∞±≤≥іµ∂ЈЄєЇїЉљЊњјЅ¬√ƒ≈∆«»… ЋћЌќѕ–—“”‘’÷„ЎўЏџ№Ёёяабвгдежзийклмнопрстуфхцчшщъыьэю¤"
	  },
	  "macgreek": {
	    "type": "_sbcs",
	    "chars": "Ä¹²É³ÖÜ΅àâä΄¨çéèêë£™îï•½‰ôö¦­ùûü†ΓΔΘΛΞΠß®©ΣΪ§≠°·Α±≤≥¥ΒΕΖΗΙΚΜΦΫΨΩάΝ¬ΟΡ≈Τ«»… ΥΧΆΈœ–―“”‘’÷ΉΊΌΎέήίόΏύαβψδεφγηιξκλμνοπώρστθωςχυζϊϋΐΰ�"
	  },
	  "maciceland": {
	    "type": "_sbcs",
	    "chars": "ÄÅÇÉÑÖÜáàâäãåçéèêëíìîïñóòôöõúùûüÝ°¢£§•¶ß®©™´¨≠ÆØ∞±≤≥¥µ∂∑∏π∫ªºΩæø¿¡¬√ƒ≈∆«»… ÀÃÕŒœ–—“”‘’÷◊ÿŸ⁄¤ÐðÞþý·‚„‰ÂÊÁËÈÍÎÏÌÓÔ�ÒÚÛÙıˆ˜¯˘˙˚¸˝˛ˇ"
	  },
	  "macroman": {
	    "type": "_sbcs",
	    "chars": "ÄÅÇÉÑÖÜáàâäãåçéèêëíìîïñóòôöõúùûü†°¢£§•¶ß®©™´¨≠ÆØ∞±≤≥¥µ∂∑∏π∫ªºΩæø¿¡¬√ƒ≈∆«»… ÀÃÕŒœ–—“”‘’÷◊ÿŸ⁄¤‹›ﬁﬂ‡·‚„‰ÂÊÁËÈÍÎÏÌÓÔ�ÒÚÛÙıˆ˜¯˘˙˚¸˝˛ˇ"
	  },
	  "macromania": {
	    "type": "_sbcs",
	    "chars": "ÄÅÇÉÑÖÜáàâäãåçéèêëíìîïñóòôöõúùûü†°¢£§•¶ß®©™´¨≠ĂŞ∞±≤≥¥µ∂∑∏π∫ªºΩăş¿¡¬√ƒ≈∆«»… ÀÃÕŒœ–—“”‘’÷◊ÿŸ⁄¤‹›Ţţ‡·‚„‰ÂÊÁËÈÍÎÏÌÓÔ�ÒÚÛÙıˆ˜¯˘˙˚¸˝˛ˇ"
	  },
	  "macthai": {
	    "type": "_sbcs",
	    "chars": "«»…“”�•‘’� กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพฟภมยรฤลฦวศษสหฬอฮฯะัาำิีึืฺุู﻿​–—฿เแโใไๅๆ็่้๊๋์ํ™๏๐๑๒๓๔๕๖๗๘๙®©����"
	  },
	  "macturkish": {
	    "type": "_sbcs",
	    "chars": "ÄÅÇÉÑÖÜáàâäãåçéèêëíìîïñóòôöõúùûü†°¢£§•¶ß®©™´¨≠ÆØ∞±≤≥¥µ∂∑∏π∫ªºΩæø¿¡¬√ƒ≈∆«»… ÀÃÕŒœ–—“”‘’÷◊ÿŸĞğİıŞş‡·‚„‰ÂÊÁËÈÍÎÏÌÓÔ�ÒÚÛÙ�ˆ˜¯˘˙˚¸˝˛ˇ"
	  },
	  "macukraine": {
	    "type": "_sbcs",
	    "chars": "АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯ†°Ґ£§•¶І®©™Ђђ≠Ѓѓ∞±≤≥іµґЈЄєЇїЉљЊњјЅ¬√ƒ≈∆«»… ЋћЌќѕ–—“”‘’÷„ЎўЏџ№Ёёяабвгдежзийклмнопрстуфхцчшщъыьэю¤"
	  },
	  "koi8r": {
	    "type": "_sbcs",
	    "chars": "─│┌┐└┘├┤┬┴┼▀▄█▌▐░▒▓⌠■∙√≈≤≥ ⌡°²·÷═║╒ё╓╔╕╖╗╘╙╚╛╜╝╞╟╠╡Ё╢╣╤╥╦╧╨╩╪╫╬©юабцдефгхийклмнопярстужвьызшэщчъЮАБЦДЕФГХИЙКЛМНОПЯРСТУЖВЬЫЗШЭЩЧЪ"
	  },
	  "koi8u": {
	    "type": "_sbcs",
	    "chars": "─│┌┐└┘├┤┬┴┼▀▄█▌▐░▒▓⌠■∙√≈≤≥ ⌡°²·÷═║╒ёє╔ії╗╘╙╚╛ґ╝╞╟╠╡ЁЄ╣ІЇ╦╧╨╩╪Ґ╬©юабцдефгхийклмнопярстужвьызшэщчъЮАБЦДЕФГХИЙКЛМНОПЯРСТУЖВЬЫЗШЭЩЧЪ"
	  },
	  "koi8ru": {
	    "type": "_sbcs",
	    "chars": "─│┌┐└┘├┤┬┴┼▀▄█▌▐░▒▓⌠■∙√≈≤≥ ⌡°²·÷═║╒ёє╔ії╗╘╙╚╛ґў╞╟╠╡ЁЄ╣ІЇ╦╧╨╩╪ҐЎ©юабцдефгхийклмнопярстужвьызшэщчъЮАБЦДЕФГХИЙКЛМНОПЯРСТУЖВЬЫЗШЭЩЧЪ"
	  },
	  "koi8t": {
	    "type": "_sbcs",
	    "chars": "қғ‚Ғ„…†‡�‰ҳ‹ҲҷҶ�Қ‘’“”•–—�™�›�����ӯӮё¤ӣ¦§���«¬­®�°±²Ё�Ӣ¶·�№�»���©юабцдефгхийклмнопярстужвьызшэщчъЮАБЦДЕФГХИЙКЛМНОПЯРСТУЖВЬЫЗШЭЩЧЪ"
	  },
	  "armscii8": {
	    "type": "_sbcs",
	    "chars": " �և։)(»«—.՝,-֊…՜՛՞ԱաԲբԳգԴդԵեԶզԷէԸըԹթԺժԻիԼլԽխԾծԿկՀհՁձՂղՃճՄմՅյՆնՇշՈոՉչՊպՋջՌռՍսՎվՏտՐրՑցՒւՓփՔքՕօՖֆ՚�"
	  },
	  "rk1048": {
	    "type": "_sbcs",
	    "chars": "ЂЃ‚ѓ„…†‡€‰Љ‹ЊҚҺЏђ‘’“”•–—�™љ›њқһџ ҰұӘ¤Ө¦§Ё©Ғ«¬­®Ү°±Ііөµ¶·ё№ғ»әҢңүАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя"
	  },
	  "tcvn": {
	    "type": "_sbcs",
	    "chars": "\u0000ÚỤ\u0003ỪỬỮ\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010ỨỰỲỶỸÝỴ\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ÀẢÃÁẠẶẬÈẺẼÉẸỆÌỈĨÍỊÒỎÕÓỌỘỜỞỠỚỢÙỦŨ ĂÂÊÔƠƯĐăâêôơưđẶ̀̀̉̃́àảãáạẲằẳẵắẴẮẦẨẪẤỀặầẩẫấậèỂẻẽéẹềểễếệìỉỄẾỒĩíịòỔỏõóọồổỗốộờởỡớợùỖủũúụừửữứựỳỷỹýỵỐ"
	  },
	  "georgianacademy": {
	    "type": "_sbcs",
	    "chars": "‚ƒ„…†‡ˆ‰Š‹Œ‘’“”•–—˜™š›œŸ ¡¢£¤¥¦§¨©ª«¬­®¯°±²³´µ¶·¸¹º»¼½¾¿აბგდევზთიკლმნოპჟრსტუფქღყშჩცძწჭხჯჰჱჲჳჴჵჶçèéêëìíîïðñòóôõö÷øùúûüýþÿ"
	  },
	  "georgianps": {
	    "type": "_sbcs",
	    "chars": "‚ƒ„…†‡ˆ‰Š‹Œ‘’“”•–—˜™š›œŸ ¡¢£¤¥¦§¨©ª«¬­®¯°±²³´µ¶·¸¹º»¼½¾¿აბგდევზჱთიკლმნჲოპჟრსტჳუფქღყშჩცძწჭხჴჯჰჵæçèéêëìíîïðñòóôõö÷øùúûüýþÿ"
	  },
	  "pt154": {
	    "type": "_sbcs",
	    "chars": "ҖҒӮғ„…ҶҮҲүҠӢҢҚҺҸҗ‘’“”•–—ҳҷҡӣңқһҹ ЎўЈӨҘҰ§Ё©Ә«¬ӯ®Ҝ°ұІіҙө¶·ё№ә»јҪҫҝАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя"
	  },
	  "viscii": {
	    "type": "_sbcs",
	    "chars": "\u0000\u0001Ẳ\u0003\u0004ẴẪ\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013Ỷ\u0015\u0016\u0017\u0018Ỹ\u001a\u001b\u001c\u001dỴ\u001f !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ẠẮẰẶẤẦẨẬẼẸẾỀỂỄỆỐỒỔỖỘỢỚỜỞỊỎỌỈỦŨỤỲÕắằặấầẩậẽẹếềểễệốồổỗỠƠộờởịỰỨỪỬơớƯÀÁÂÃẢĂẳẵÈÉÊẺÌÍĨỳĐứÒÓÔạỷừửÙÚỹỵÝỡưàáâãảăữẫèéêẻìíĩỉđựòóôõỏọụùúũủýợỮ"
	  },
	  "iso646cn": {
	    "type": "_sbcs",
	    "chars": "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#¥%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}‾��������������������������������������������������������������������������������������������������������������������������������"
	  },
	  "iso646jp": {
	    "type": "_sbcs",
	    "chars": "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[¥]^_`abcdefghijklmnopqrstuvwxyz{|}‾��������������������������������������������������������������������������������������������������������������������������������"
	  },
	  "hproman8": {
	    "type": "_sbcs",
	    "chars": " ÀÂÈÊËÎÏ´ˋˆ¨˜ÙÛ₤¯Ýý°ÇçÑñ¡¿¤£¥§ƒ¢âêôûáéóúàèòùäëöüÅîØÆåíøæÄìÖÜÉïßÔÁÃãÐðÍÌÓÒÕõŠšÚŸÿÞþ·µ¶¾—¼½ªº«■»±�"
	  },
	  "macintosh": {
	    "type": "_sbcs",
	    "chars": "ÄÅÇÉÑÖÜáàâäãåçéèêëíìîïñóòôöõúùûü†°¢£§•¶ß®©™´¨≠ÆØ∞±≤≥¥µ∂∑∏π∫ªºΩæø¿¡¬√ƒ≈∆«»… ÀÃÕŒœ–—“”‘’÷◊ÿŸ⁄¤‹›ﬁﬂ‡·‚„‰ÂÊÁËÈÍÎÏÌÓÔ�ÒÚÛÙıˆ˜¯˘˙˚¸˝˛ˇ"
	  },
	  "ascii": {
	    "type": "_sbcs",
	    "chars": "��������������������������������������������������������������������������������������������������������������������������������"
	  },
	  "tis620": {
	    "type": "_sbcs",
	    "chars": "���������������������������������กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพฟภมยรฤลฦวศษสหฬอฮฯะัาำิีึืฺุู����฿เแโใไๅๆ็่้๊๋์ํ๎๏๐๑๒๓๔๕๖๗๘๙๚๛����"
	  }
	};
	return sbcsDataGenerated;
}

var dbcsCodec = {};

var hasRequiredDbcsCodec;

function requireDbcsCodec () {
	if (hasRequiredDbcsCodec) return dbcsCodec;
	hasRequiredDbcsCodec = 1;
	var Buffer = requireSafer().Buffer;

	// Multibyte codec. In this scheme, a character is represented by 1 or more bytes.
	// Our codec supports UTF-16 surrogates, extensions for GB18030 and unicode sequences.
	// To save memory and loading time, we read table files only when requested.

	dbcsCodec._dbcs = DBCSCodec;

	var UNASSIGNED = -1,
	    GB18030_CODE = -2,
	    SEQ_START  = -10,
	    NODE_START = -1e3,
	    UNASSIGNED_NODE = new Array(0x100),
	    DEF_CHAR = -1;

	for (var i = 0; i < 0x100; i++)
	    UNASSIGNED_NODE[i] = UNASSIGNED;


	// Class DBCSCodec reads and initializes mapping tables.
	function DBCSCodec(codecOptions, iconv) {
	    this.encodingName = codecOptions.encodingName;
	    if (!codecOptions)
	        throw new Error("DBCS codec is called without the data.")
	    if (!codecOptions.table)
	        throw new Error("Encoding '" + this.encodingName + "' has no data.");

	    // Load tables.
	    var mappingTable = codecOptions.table();


	    // Decode tables: MBCS -> Unicode.

	    // decodeTables is a trie, encoded as an array of arrays of integers. Internal arrays are trie nodes and all have len = 256.
	    // Trie root is decodeTables[0].
	    // Values: >=  0 -> unicode character code. can be > 0xFFFF
	    //         == UNASSIGNED -> unknown/unassigned sequence.
	    //         == GB18030_CODE -> this is the end of a GB18030 4-byte sequence.
	    //         <= NODE_START -> index of the next node in our trie to process next byte.
	    //         <= SEQ_START  -> index of the start of a character code sequence, in decodeTableSeq.
	    this.decodeTables = [];
	    this.decodeTables[0] = UNASSIGNED_NODE.slice(0); // Create root node.

	    // Sometimes a MBCS char corresponds to a sequence of unicode chars. We store them as arrays of integers here. 
	    this.decodeTableSeq = [];

	    // Actual mapping tables consist of chunks. Use them to fill up decode tables.
	    for (var i = 0; i < mappingTable.length; i++)
	        this._addDecodeChunk(mappingTable[i]);

	    this.defaultCharUnicode = iconv.defaultCharUnicode;

	    
	    // Encode tables: Unicode -> DBCS.

	    // `encodeTable` is array mapping from unicode char to encoded char. All its values are integers for performance.
	    // Because it can be sparse, it is represented as array of buckets by 256 chars each. Bucket can be null.
	    // Values: >=  0 -> it is a normal char. Write the value (if <=256 then 1 byte, if <=65536 then 2 bytes, etc.).
	    //         == UNASSIGNED -> no conversion found. Output a default char.
	    //         <= SEQ_START  -> it's an index in encodeTableSeq, see below. The character starts a sequence.
	    this.encodeTable = [];
	    
	    // `encodeTableSeq` is used when a sequence of unicode characters is encoded as a single code. We use a tree of
	    // objects where keys correspond to characters in sequence and leafs are the encoded dbcs values. A special DEF_CHAR key
	    // means end of sequence (needed when one sequence is a strict subsequence of another).
	    // Objects are kept separately from encodeTable to increase performance.
	    this.encodeTableSeq = [];

	    // Some chars can be decoded, but need not be encoded.
	    var skipEncodeChars = {};
	    if (codecOptions.encodeSkipVals)
	        for (var i = 0; i < codecOptions.encodeSkipVals.length; i++) {
	            var val = codecOptions.encodeSkipVals[i];
	            if (typeof val === 'number')
	                skipEncodeChars[val] = true;
	            else
	                for (var j = val.from; j <= val.to; j++)
	                    skipEncodeChars[j] = true;
	        }
	        
	    // Use decode trie to recursively fill out encode tables.
	    this._fillEncodeTable(0, 0, skipEncodeChars);

	    // Add more encoding pairs when needed.
	    if (codecOptions.encodeAdd) {
	        for (var uChar in codecOptions.encodeAdd)
	            if (Object.prototype.hasOwnProperty.call(codecOptions.encodeAdd, uChar))
	                this._setEncodeChar(uChar.charCodeAt(0), codecOptions.encodeAdd[uChar]);
	    }

	    this.defCharSB  = this.encodeTable[0][iconv.defaultCharSingleByte.charCodeAt(0)];
	    if (this.defCharSB === UNASSIGNED) this.defCharSB = this.encodeTable[0]['?'];
	    if (this.defCharSB === UNASSIGNED) this.defCharSB = "?".charCodeAt(0);


	    // Load & create GB18030 tables when needed.
	    if (typeof codecOptions.gb18030 === 'function') {
	        this.gb18030 = codecOptions.gb18030(); // Load GB18030 ranges.

	        // Add GB18030 decode tables.
	        var thirdByteNodeIdx = this.decodeTables.length;
	        var thirdByteNode = this.decodeTables[thirdByteNodeIdx] = UNASSIGNED_NODE.slice(0);

	        var fourthByteNodeIdx = this.decodeTables.length;
	        var fourthByteNode = this.decodeTables[fourthByteNodeIdx] = UNASSIGNED_NODE.slice(0);

	        for (var i = 0x81; i <= 0xFE; i++) {
	            var secondByteNodeIdx = NODE_START - this.decodeTables[0][i];
	            var secondByteNode = this.decodeTables[secondByteNodeIdx];
	            for (var j = 0x30; j <= 0x39; j++)
	                secondByteNode[j] = NODE_START - thirdByteNodeIdx;
	        }
	        for (var i = 0x81; i <= 0xFE; i++)
	            thirdByteNode[i] = NODE_START - fourthByteNodeIdx;
	        for (var i = 0x30; i <= 0x39; i++)
	            fourthByteNode[i] = GB18030_CODE;
	    }        
	}

	DBCSCodec.prototype.encoder = DBCSEncoder;
	DBCSCodec.prototype.decoder = DBCSDecoder;

	// Decoder helpers
	DBCSCodec.prototype._getDecodeTrieNode = function(addr) {
	    var bytes = [];
	    for (; addr > 0; addr >>= 8)
	        bytes.push(addr & 0xFF);
	    if (bytes.length == 0)
	        bytes.push(0);

	    var node = this.decodeTables[0];
	    for (var i = bytes.length-1; i > 0; i--) { // Traverse nodes deeper into the trie.
	        var val = node[bytes[i]];

	        if (val == UNASSIGNED) { // Create new node.
	            node[bytes[i]] = NODE_START - this.decodeTables.length;
	            this.decodeTables.push(node = UNASSIGNED_NODE.slice(0));
	        }
	        else if (val <= NODE_START) { // Existing node.
	            node = this.decodeTables[NODE_START - val];
	        }
	        else
	            throw new Error("Overwrite byte in " + this.encodingName + ", addr: " + addr.toString(16));
	    }
	    return node;
	};


	DBCSCodec.prototype._addDecodeChunk = function(chunk) {
	    // First element of chunk is the hex mbcs code where we start.
	    var curAddr = parseInt(chunk[0], 16);

	    // Choose the decoding node where we'll write our chars.
	    var writeTable = this._getDecodeTrieNode(curAddr);
	    curAddr = curAddr & 0xFF;

	    // Write all other elements of the chunk to the table.
	    for (var k = 1; k < chunk.length; k++) {
	        var part = chunk[k];
	        if (typeof part === "string") { // String, write as-is.
	            for (var l = 0; l < part.length;) {
	                var code = part.charCodeAt(l++);
	                if (0xD800 <= code && code < 0xDC00) { // Decode surrogate
	                    var codeTrail = part.charCodeAt(l++);
	                    if (0xDC00 <= codeTrail && codeTrail < 0xE000)
	                        writeTable[curAddr++] = 0x10000 + (code - 0xD800) * 0x400 + (codeTrail - 0xDC00);
	                    else
	                        throw new Error("Incorrect surrogate pair in "  + this.encodingName + " at chunk " + chunk[0]);
	                }
	                else if (0x0FF0 < code && code <= 0x0FFF) { // Character sequence (our own encoding used)
	                    var len = 0xFFF - code + 2;
	                    var seq = [];
	                    for (var m = 0; m < len; m++)
	                        seq.push(part.charCodeAt(l++)); // Simple variation: don't support surrogates or subsequences in seq.

	                    writeTable[curAddr++] = SEQ_START - this.decodeTableSeq.length;
	                    this.decodeTableSeq.push(seq);
	                }
	                else
	                    writeTable[curAddr++] = code; // Basic char
	            }
	        } 
	        else if (typeof part === "number") { // Integer, meaning increasing sequence starting with prev character.
	            var charCode = writeTable[curAddr - 1] + 1;
	            for (var l = 0; l < part; l++)
	                writeTable[curAddr++] = charCode++;
	        }
	        else
	            throw new Error("Incorrect type '" + typeof part + "' given in "  + this.encodingName + " at chunk " + chunk[0]);
	    }
	    if (curAddr > 0xFF)
	        throw new Error("Incorrect chunk in "  + this.encodingName + " at addr " + chunk[0] + ": too long" + curAddr);
	};

	// Encoder helpers
	DBCSCodec.prototype._getEncodeBucket = function(uCode) {
	    var high = uCode >> 8; // This could be > 0xFF because of astral characters.
	    if (this.encodeTable[high] === undefined)
	        this.encodeTable[high] = UNASSIGNED_NODE.slice(0); // Create bucket on demand.
	    return this.encodeTable[high];
	};

	DBCSCodec.prototype._setEncodeChar = function(uCode, dbcsCode) {
	    var bucket = this._getEncodeBucket(uCode);
	    var low = uCode & 0xFF;
	    if (bucket[low] <= SEQ_START)
	        this.encodeTableSeq[SEQ_START-bucket[low]][DEF_CHAR] = dbcsCode; // There's already a sequence, set a single-char subsequence of it.
	    else if (bucket[low] == UNASSIGNED)
	        bucket[low] = dbcsCode;
	};

	DBCSCodec.prototype._setEncodeSequence = function(seq, dbcsCode) {
	    
	    // Get the root of character tree according to first character of the sequence.
	    var uCode = seq[0];
	    var bucket = this._getEncodeBucket(uCode);
	    var low = uCode & 0xFF;

	    var node;
	    if (bucket[low] <= SEQ_START) {
	        // There's already a sequence with  - use it.
	        node = this.encodeTableSeq[SEQ_START-bucket[low]];
	    }
	    else {
	        // There was no sequence object - allocate a new one.
	        node = {};
	        if (bucket[low] !== UNASSIGNED) node[DEF_CHAR] = bucket[low]; // If a char was set before - make it a single-char subsequence.
	        bucket[low] = SEQ_START - this.encodeTableSeq.length;
	        this.encodeTableSeq.push(node);
	    }

	    // Traverse the character tree, allocating new nodes as needed.
	    for (var j = 1; j < seq.length-1; j++) {
	        var oldVal = node[uCode];
	        if (typeof oldVal === 'object')
	            node = oldVal;
	        else {
	            node = node[uCode] = {};
	            if (oldVal !== undefined)
	                node[DEF_CHAR] = oldVal;
	        }
	    }

	    // Set the leaf to given dbcsCode.
	    uCode = seq[seq.length-1];
	    node[uCode] = dbcsCode;
	};

	DBCSCodec.prototype._fillEncodeTable = function(nodeIdx, prefix, skipEncodeChars) {
	    var node = this.decodeTables[nodeIdx];
	    for (var i = 0; i < 0x100; i++) {
	        var uCode = node[i];
	        var mbCode = prefix + i;
	        if (skipEncodeChars[mbCode])
	            continue;

	        if (uCode >= 0)
	            this._setEncodeChar(uCode, mbCode);
	        else if (uCode <= NODE_START)
	            this._fillEncodeTable(NODE_START - uCode, mbCode << 8, skipEncodeChars);
	        else if (uCode <= SEQ_START)
	            this._setEncodeSequence(this.decodeTableSeq[SEQ_START - uCode], mbCode);
	    }
	};



	// == Encoder ==================================================================

	function DBCSEncoder(options, codec) {
	    // Encoder state
	    this.leadSurrogate = -1;
	    this.seqObj = undefined;
	    
	    // Static data
	    this.encodeTable = codec.encodeTable;
	    this.encodeTableSeq = codec.encodeTableSeq;
	    this.defaultCharSingleByte = codec.defCharSB;
	    this.gb18030 = codec.gb18030;
	}

	DBCSEncoder.prototype.write = function(str) {
	    var newBuf = Buffer.alloc(str.length * (this.gb18030 ? 4 : 3)),
	        leadSurrogate = this.leadSurrogate,
	        seqObj = this.seqObj, nextChar = -1,
	        i = 0, j = 0;

	    while (true) {
	        // 0. Get next character.
	        if (nextChar === -1) {
	            if (i == str.length) break;
	            var uCode = str.charCodeAt(i++);
	        }
	        else {
	            var uCode = nextChar;
	            nextChar = -1;    
	        }

	        // 1. Handle surrogates.
	        if (0xD800 <= uCode && uCode < 0xE000) { // Char is one of surrogates.
	            if (uCode < 0xDC00) { // We've got lead surrogate.
	                if (leadSurrogate === -1) {
	                    leadSurrogate = uCode;
	                    continue;
	                } else {
	                    leadSurrogate = uCode;
	                    // Double lead surrogate found.
	                    uCode = UNASSIGNED;
	                }
	            } else { // We've got trail surrogate.
	                if (leadSurrogate !== -1) {
	                    uCode = 0x10000 + (leadSurrogate - 0xD800) * 0x400 + (uCode - 0xDC00);
	                    leadSurrogate = -1;
	                } else {
	                    // Incomplete surrogate pair - only trail surrogate found.
	                    uCode = UNASSIGNED;
	                }
	                
	            }
	        }
	        else if (leadSurrogate !== -1) {
	            // Incomplete surrogate pair - only lead surrogate found.
	            nextChar = uCode; uCode = UNASSIGNED; // Write an error, then current char.
	            leadSurrogate = -1;
	        }

	        // 2. Convert uCode character.
	        var dbcsCode = UNASSIGNED;
	        if (seqObj !== undefined && uCode != UNASSIGNED) { // We are in the middle of the sequence
	            var resCode = seqObj[uCode];
	            if (typeof resCode === 'object') { // Sequence continues.
	                seqObj = resCode;
	                continue;

	            } else if (typeof resCode == 'number') { // Sequence finished. Write it.
	                dbcsCode = resCode;

	            } else if (resCode == undefined) { // Current character is not part of the sequence.

	                // Try default character for this sequence
	                resCode = seqObj[DEF_CHAR];
	                if (resCode !== undefined) {
	                    dbcsCode = resCode; // Found. Write it.
	                    nextChar = uCode; // Current character will be written too in the next iteration.

	                }
	            }
	            seqObj = undefined;
	        }
	        else if (uCode >= 0) {  // Regular character
	            var subtable = this.encodeTable[uCode >> 8];
	            if (subtable !== undefined)
	                dbcsCode = subtable[uCode & 0xFF];
	            
	            if (dbcsCode <= SEQ_START) { // Sequence start
	                seqObj = this.encodeTableSeq[SEQ_START-dbcsCode];
	                continue;
	            }

	            if (dbcsCode == UNASSIGNED && this.gb18030) {
	                // Use GB18030 algorithm to find character(s) to write.
	                var idx = findIdx(this.gb18030.uChars, uCode);
	                if (idx != -1) {
	                    var dbcsCode = this.gb18030.gbChars[idx] + (uCode - this.gb18030.uChars[idx]);
	                    newBuf[j++] = 0x81 + Math.floor(dbcsCode / 12600); dbcsCode = dbcsCode % 12600;
	                    newBuf[j++] = 0x30 + Math.floor(dbcsCode / 1260); dbcsCode = dbcsCode % 1260;
	                    newBuf[j++] = 0x81 + Math.floor(dbcsCode / 10); dbcsCode = dbcsCode % 10;
	                    newBuf[j++] = 0x30 + dbcsCode;
	                    continue;
	                }
	            }
	        }

	        // 3. Write dbcsCode character.
	        if (dbcsCode === UNASSIGNED)
	            dbcsCode = this.defaultCharSingleByte;
	        
	        if (dbcsCode < 0x100) {
	            newBuf[j++] = dbcsCode;
	        }
	        else if (dbcsCode < 0x10000) {
	            newBuf[j++] = dbcsCode >> 8;   // high byte
	            newBuf[j++] = dbcsCode & 0xFF; // low byte
	        }
	        else {
	            newBuf[j++] = dbcsCode >> 16;
	            newBuf[j++] = (dbcsCode >> 8) & 0xFF;
	            newBuf[j++] = dbcsCode & 0xFF;
	        }
	    }

	    this.seqObj = seqObj;
	    this.leadSurrogate = leadSurrogate;
	    return newBuf.slice(0, j);
	};

	DBCSEncoder.prototype.end = function() {
	    if (this.leadSurrogate === -1 && this.seqObj === undefined)
	        return; // All clean. Most often case.

	    var newBuf = Buffer.alloc(10), j = 0;

	    if (this.seqObj) { // We're in the sequence.
	        var dbcsCode = this.seqObj[DEF_CHAR];
	        if (dbcsCode !== undefined) { // Write beginning of the sequence.
	            if (dbcsCode < 0x100) {
	                newBuf[j++] = dbcsCode;
	            }
	            else {
	                newBuf[j++] = dbcsCode >> 8;   // high byte
	                newBuf[j++] = dbcsCode & 0xFF; // low byte
	            }
	        }
	        this.seqObj = undefined;
	    }

	    if (this.leadSurrogate !== -1) {
	        // Incomplete surrogate pair - only lead surrogate found.
	        newBuf[j++] = this.defaultCharSingleByte;
	        this.leadSurrogate = -1;
	    }
	    
	    return newBuf.slice(0, j);
	};

	// Export for testing
	DBCSEncoder.prototype.findIdx = findIdx;


	// == Decoder ==================================================================

	function DBCSDecoder(options, codec) {
	    // Decoder state
	    this.nodeIdx = 0;
	    this.prevBuf = Buffer.alloc(0);

	    // Static data
	    this.decodeTables = codec.decodeTables;
	    this.decodeTableSeq = codec.decodeTableSeq;
	    this.defaultCharUnicode = codec.defaultCharUnicode;
	    this.gb18030 = codec.gb18030;
	}

	DBCSDecoder.prototype.write = function(buf) {
	    var newBuf = Buffer.alloc(buf.length*2),
	        nodeIdx = this.nodeIdx, 
	        prevBuf = this.prevBuf, prevBufOffset = this.prevBuf.length,
	        seqStart = -this.prevBuf.length, // idx of the start of current parsed sequence.
	        uCode;

	    if (prevBufOffset > 0) // Make prev buf overlap a little to make it easier to slice later.
	        prevBuf = Buffer.concat([prevBuf, buf.slice(0, 10)]);
	    
	    for (var i = 0, j = 0; i < buf.length; i++) {
	        var curByte = (i >= 0) ? buf[i] : prevBuf[i + prevBufOffset];

	        // Lookup in current trie node.
	        var uCode = this.decodeTables[nodeIdx][curByte];

	        if (uCode >= 0) ;
	        else if (uCode === UNASSIGNED) { // Unknown char.
	            // TODO: Callback with seq.
	            //var curSeq = (seqStart >= 0) ? buf.slice(seqStart, i+1) : prevBuf.slice(seqStart + prevBufOffset, i+1 + prevBufOffset);
	            i = seqStart; // Try to parse again, after skipping first byte of the sequence ('i' will be incremented by 'for' cycle).
	            uCode = this.defaultCharUnicode.charCodeAt(0);
	        }
	        else if (uCode === GB18030_CODE) {
	            var curSeq = (seqStart >= 0) ? buf.slice(seqStar