# Examples

This section contains step-by-step examples with code and explanations in interactive Jupyter notebook format.

## Available Scenarios

Each scenario is available as both:
- **Jupyter Notebook** (`.ipynb`) - Interactive, runnable examples
- **Markdown** (`.md`) - Documentation format

### Markdown Documentation

 - [Scenario 1: Basic Usage](./scenario_1_basic_usage.md)
 - [Scenario 2: Intelligent Memory](./scenario_2_intelligent_memory.md)
 - [Scenario 3: Multi-Agent](./scenario_3_multi_agent.md)
 - [Scenario 4: Async Operations](./scenario_4_async_operations.md)
 - [Scenario 5: Custom Integration](./scenario_5_custom_integration.md)
 - [Scenario 6: Sub Stores](./scenario_6_sub_stores.md)
 - [Scenario 7: Multimodal Capability](./scenario_7_multimodal.md)
 - [Scenario 8: Ebbinghaus Forgetting Curve](./scenario_8_ebbinghaus_forgetting_curve.md)
 - [Scenario 9: User Profile Management](./scenario_9_user_memory.md)

## Quick Start

### Using Jupyter Notebooks

1. **Install Jupyter**:
   ```bash
   pip install jupyter notebook
   ```

2. **Launch Jupyter Notebook**:
   ```bash
   jupyter notebook
   ```

3. **Open a scenario notebook**:
   - Start with `scenario_1_basic_usage.ipynb` if you're new to powermem
   - Run each cell sequentially using Shift+Enter
   - Modify code and experiment!

### Using Python Scripts

You can also run the examples as Python scripts by copying code from the markdown files.

## Notebook Features

Each notebook includes:
- **Step-by-step instructions** - Clear explanations for each step
- **Runnable code cells** - Execute code directly in the notebook
- **Markdown documentation** - Explanations and context
- **Extension exercises** - Practice exercises to try on your own

## Recommended Learning Path

1. **Start with Scenario 1** - Learn basic memory operations
2. **Explore Scenario 2** - Understand intelligent memory features
3. **Try Scenario 3** - Work with multi-agent scenarios
4. **Check Scenario 4** - Learn async operations
5. **Scenario 5** - Custom integrations for advanced users
6. **Scenario 6** - Sub stores for memory partitioning and optimization
7. **Scenario 7** - Multimodal capability for image and multimedia processing
8. **Scenario 8** - Ebbinghaus forgetting curve for time-based memory decay and retention optimization
9. **Scenario 9** - User profile management for automatic user profile extraction and integration with memory search

## Requirements

- Python 3.10+
- powermem installed (`pip install powermem`)
- Jupyter Notebook (for interactive notebooks)
- LLM provider configured (for intelligent features in Scenario 2+)
