/// <reference types="node" />
/**
 *  Encode data to packet buffer
 * @param type Packet Type
 * @param id Packet ID
 * @param body Packet body (payload)
 * @param encoding Body encoding
 * @returns Encoded packet buffer
 */
export declare const encode: (type: number, id: number, body: string, encoding?: EncodingOptions) => Buffer;
/**
 * Decodes packet buffer to data
 * @param buf Buffer to decode
 * @param encoding Body encoding
 * @returns Decoded packet object
 */
export declare const decode: (buf: Buffer, encoding?: EncodingOptions) => DecodedPacket;
interface DecodedPacket {
    size: number;
    id: number;
    type: number;
    body: string;
}
export declare type EncodingOptions = 'ascii' | 'utf8';
export {};
