# Windows Package Manager Release Roadmap

## Overview

This document outlines our aspirational roadmap to deliver next release of Windows Package Manager. We anticipate substantial feedback from the community, and as such, this plan is subject to change.

## Milestones

The Windows Package Manager project is engineered and delivered as described below.

### Activities

#### Dev Work

* Fixes / Features for Windows Package Manager
* Fixes / Features for future Windows Releases

#### Quality & Stability

* Bug Fixes
* Performance & Stability
* Globalization, Localization, Internationalization, Accessibility
* Tests

#### Release

* Available from to Windows Insiders through the [Microsoft Store](https://apps.microsoft.com/detail/9nblggh4nns1) & [GitHub Releases](https://github.com/microsoft/winget-cli/releases)
* Release Notes & Announcement Blog published
* Engineering System Maintenance
* Community Engagement
* [Docs](https://docs.microsoft.com/windows/package-manager/)
* Future Milestone Planning

### Releases

Releases will be available here on GitHub first. We will release to the App Installer for Insiders as frequently as the releases have met our quality bars.

## GitHub Milestones

We use [GitHub Projects](https://github.com/orgs/microsoft/projects/137) to broadly organize what we intend to work on.  Issues will be added to milestones when we're reasonably confident they will land in the next milestone. Dates in [GitHub milestones](https://github.com/microsoft/winget-cli/milestones) are only used for sequencing and do not represent a commitment.

| Milestone                                                                                                     | Description                                     | Status             |
| ------------------------------------------------------------------------------------------------------------- | ----------------------------------------------- | ------------------ |
| [v1.7-Client](https://github.com/microsoft/winget-cli/milestone/42)                                           | Work Targeted for v1.7                          | :white_check_mark: |
| [v1.8-Client](https://github.com/microsoft/winget-cli/milestone/43)                                           | Work Targeted for v1.8                          | :white_check_mark: |
| [v1.9-Client](https://github.com/microsoft/winget-cli/milestone/44)                                           | Work Targeted for v1.9                          | :white_check_mark: |
| [v1.10-Client](https://github.com/microsoft/winget-cli/milestone/45)                                          | Work Targeted for v1.10                         | :white_check_mark: |
| [v1.11-Client](https://github.com/microsoft/winget-cli/milestone/46)                                          | Work Targeted for v1.11                         | :construction:     |
| [v.Next-Client](https://github.com/microsoft/winget-cli/milestone/41)                                         | Triage for the next Milestone                   | :rocket:           |
| [Backlog-Client](https://github.com/microsoft/winget-cli/issues?q=is%3Aissue%20state%3Aopen%20no%3Amilestone) | Work not yet assigned to a milestone or release | N/A                |

## Issue Triage & Prioritization

Incoming issues/asks/etc. are triaged several times a week, labelled appropriately, and assigned to a milestone in priority order:

* P0 (serious crashes, data loss, etc.) issues are scheduled to be dealt with ASAP.
* P1/2 issues/features/asks assigned to the current or future milestone.
* Issues/features/asks not on our list of the features of next release is assigned to the [Windows Package Manager Backlog](https://github.com/microsoft/winget-cli/milestone/2) for subsequent triage, prioritization & scheduling.

#### Feature Priorities will be influenced by community feedback on issues.

