/*
 * Decompiled with CFR 0.152.
 */
package cn.tealc.wwt.export;

import cn.tealc.wutheringwavestool.model.CardInfo;
import cn.tealc.wutheringwavestool.util.FileIO;
import cn.tealc.wwt.export.ExcelReader;
import cn.tealc.wwt.export.ExcelWriter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelMapper {
    private static final Logger LOG = LoggerFactory.getLogger(ExcelMapper.class);

    public boolean toExcel(String playerId, File dir) {
        LinkedHashMap<String, List<CardInfo>> map = new LinkedHashMap();
        File poolJson = new File(String.format("data/%s/pool.json", playerId));
        if (poolJson.exists()) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                map = (Map)mapper.readValue(poolJson, (TypeReference)new TypeReference<Map<String, List<CardInfo>>>(this){});
                ExcelWriter writer = new ExcelWriter();
                writer.saveToExcel(playerId, map, dir);
                return true;
            }
            catch (IOException e) {
                LOG.error("\u5361\u6c60\u5bfc\u51fa\u4e3aExcel\u9519\u8bef{}", (Object)e.getMessage(), (Object)e);
            }
        } else {
            LOG.debug("\u4e0d\u5b58\u5728Json: {}", (Object)poolJson.getAbsolutePath());
        }
        return false;
    }

    public String readExcel(File excelFile) {
        ExcelReader reader = new ExcelReader();
        Pair<String, Map<String, List<CardInfo>>> pair = reader.readExcel(excelFile);
        if (pair == null) {
            return null;
        }
        this.savePoolData((String)pair.getKey(), (Map)pair.getValue());
        return (String)pair.getKey();
    }

    private void savePoolData(String playerId, Map<String, List<CardInfo>> data) {
        File parentDir;
        File dataDir;
        ObjectMapper mapper = new ObjectMapper();
        File poolJson = new File(String.format("data/%s/pool.json", playerId));
        if (poolJson.exists()) {
            long time = poolJson.lastModified();
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            long todayStart = calendar.getTimeInMillis();
            if (time < todayStart) {
                LOG.info("\u6587\u4ef6\u7684\u6700\u540e\u4fee\u6539\u65f6\u95f4\u4e0d\u662f\u4eca\u5929,\u8fdb\u884c\u5907\u4efd");
                FileIO.rename((File)poolJson, (String)"pool.json.bak", (boolean)true);
            } else {
                LOG.info("\u6587\u4ef6\u7684\u6700\u540e\u4fee\u6539\u65f6\u95f4\u662f\u4eca\u5929,\u8df3\u8fc7\u5907\u4efd");
            }
        }
        if (!(dataDir = (parentDir = poolJson.getParentFile()).getParentFile()).exists()) {
            dataDir.mkdirs();
        }
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        try {
            mapper.writerWithDefaultPrettyPrinter().writeValue(poolJson, data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

