/**
 * @file
 * @brief Test of ffs() function.
 *
 * @date 15.03.20
 * @author Byeonggon Lee
 */

#include <strings.h>
#include <embox/test.h>

EMBOX_TEST_SUITE("test suit for ffs()");

TEST_CASE("return value test from (+-)0 ~ (+-)255 to ((+-)0 << 24) ~ ((+-)255 << 24)") {
	int retvals[256] = {0, 1, 2, 1, 3, 1, 2, 1, 4, 1, 2, 1, 3, 1, 2, 1, 5, 1, 2,
		1, 3, 1, 2, 1, 4, 1, 2, 1, 3, 1, 2, 1, 6, 1, 2, 1, 3, 1, 2, 1, 4, 1,
		2, 1, 3, 1, 2, 1, 5, 1, 2, 1, 3, 1, 2, 1, 4, 1, 2, 1, 3, 1, 2, 1, 7,
		1, 2, 1, 3, 1, 2, 1, 4, 1, 2, 1, 3, 1, 2, 1, 5, 1, 2, 1, 3, 1, 2, 1,
		4, 1, 2, 1, 3, 1, 2, 1, 6, 1, 2, 1, 3, 1, 2, 1, 4, 1, 2, 1, 3, 1, 2,
		1, 5, 1, 2, 1, 3, 1, 2, 1, 4, 1, 2, 1, 3, 1, 2, 1, 8, 1, 2, 1, 3, 1,
		2, 1, 4, 1, 2, 1, 3, 1, 2, 1, 5, 1, 2, 1, 3, 1, 2, 1, 4, 1, 2, 1, 3,
		1, 2, 1, 6, 1, 2, 1, 3, 1, 2, 1, 4, 1, 2, 1, 3, 1, 2, 1, 5, 1, 2, 1,
		3, 1, 2, 1, 4, 1, 2, 1, 3, 1, 2, 1, 7, 1, 2, 1, 3, 1, 2, 1, 4, 1, 2,
		1, 3, 1, 2, 1, 5, 1, 2, 1, 3, 1, 2, 1, 4, 1, 2, 1, 3, 1, 2, 1, 6, 1,
		2, 1, 3, 1, 2, 1, 4, 1, 2, 1, 3, 1, 2, 1, 5, 1, 2, 1, 3, 1, 2, 1, 4,
		1, 2, 1, 3, 1, 2, 1};

	int signs[] = {1, -1};

	for (int si = 0; si < sizeof(signs) / sizeof(int); ++si) {
		for (int sh = 0; sh < 32; sh += 8) {
			for (int i = 1; i < sizeof(retvals) / sizeof(int); ++i) {
				test_assert_equal(retvals[i] + sh, ffs((i * signs[si]) << sh));
			}
		}
	}

	test_assert_equal(retvals[0], ffs(0));
}
