// SPDX-FileCopyrightText: 2024 Cesanta Software Limited
// SPDX-License-Identifier: GPL-2.0-only or commercial
// Generated by Mongoose Wizard, https://mongoose.ws/wizard/

// Include your device-specific headers, and edit functions below

#include <stdbool.h>
#include <string.h>

#include <lib/leddrv.h>
#include <util/math.h>

#include "mongoose_glue.h"

void glue_init(void) {
	struct leds leds;

	memset(&leds, 0, sizeof(struct leds));
	glue_set_leds(&leds);
}

void glue_get_leds(struct leds *data) {
	bool states[LEDDRV_LED_N];

	leddrv_get_states(states);
	memset(data, 0, sizeof(struct leds));
	memcpy(data, states, min(sizeof(struct leds), sizeof(states)));
}

void glue_set_leds(struct leds *data) {
	bool states[LEDDRV_LED_N];

	memset(states, 0, sizeof(states));
	memcpy(states, data, min(sizeof(struct leds), sizeof(states)));
	leddrv_set_states(states);
}
