/**
 * @file
 * @brief
 *
 * @author  Anton Kozlov
 * @date    30.10.2014
 */

#include <bsp/stm32cube_hal.h>

extern void stm32_sysclock_init(void);

void SystemClock_Config(void) {
	
	__HAL_RCC_PWR_CLK_ENABLE();

	/* The voltage scaling allows optimizing the power consumption when the device is
     clocked below the maximum system frequency, to update the voltage scaling value
     regarding system frequency refer to product datasheet.  */
	__HAL_PWR_VOLTAGESCALING_CONFIG(PWR_REGULATOR_VOLTAGE_SCALE1);

	stm32_sysclock_init();

	/* STM32F405x/407x/415x/417x Revision Z devices: prefetch is supported  */
	__HAL_FLASH_PREFETCH_BUFFER_ENABLE();

}
