# 特性文档由代码自动生成，中文文档不再维护，请查看[英文文档](./README.md)

# 连字和特性

这是一个所有连字和特性的清单和解释

查看同目录下的 `.fea` 文件 和 [OpenType Feature 语法规范](https://adobe-type-tools.github.io/afdko/OpenTypeFeatureFileSpecification.html) 获取更多信息。

## 使用

### VSCode

在 VSCode settings json 文件中设置

```jsonc
{
  // 设置字体
  "editor.fontFamily": "Maple Mono NF CN, Menlo, Consolas, Maple UI, PingFang, 'Microsoft YaHei', monospace",
  // 启用连字
  "editor.fontLigatures": "'calt'",
  // 或者开启 OpenType 特性
  "editor.fontLigatures": "'calt', 'cv01', 'ss01', 'zero'",
}
```

### IDEA / Pycharm / WebStorm / GoLand / CLion

1. 打开设置
2. 点击 "编辑器"
3. 点击 "字体"
4. 在字体下拉框中选择 Maple Mono NF CN
5. 点击 "启用连字"

不支持 OpenType 特性，你需要自行构建以强制开启特性。

## 连字

开启连字，指启用 `calt` 特性:

```
{{
}}
{{--
--}}
{|
|}
[|
|]
//
///
/*
/**
++
+++
.?
..
...
..<
<!--
<-
<#--
<>
<:
<:<
>:>
<=>
<->
<|||
<||
<|
<|>
||>
|>
-|
-->
->
>=
<=
<==
!!
!=
!==
=!=
=>
==
=:=
:=:
:=
:>
:<
::
;;
;;;
:?
:?>
::=
||-
||=
|-
|=
||
--
---
<--
??
???
?:
?.
&&
__
=/=
<-<
<=<
<==>
==>
>=>
<-|
<=|
|=>
<~
~~
<~>
<~~
-~
~~>
~>
~-
~@
<+>
<+
+>
<*>
<*
*>
</>
</
/>
<<
<<<
>>
>>>
#{
#[
#(
#?
#_
#__
#:
#=
#_(
]#
0x12
[TRACE]
[DEBUG]
[INFO]
[WARN]
[ERROR]
[FATAL]
[TODO]
todo))
[FIXME]
fixme))
########
<!---->
\\ \/ \"
```

### 注意

- `>>` / `>>>` 十分智能，但是和上下文强关联，因此在一些 IDE 中可能会无法生效（[解释](https://github.com/subframe7536/maple-font/discussions/275)）。开启 `ss07` 强制开启

## 特性

### 字符变体 (cvXX)

- zero: `0` 中间带点
- cv01: `@ $ & % Q => ->` 去除间隙
- cv02: `a` 顶部带有横杠，对斜体 `a` 无影响
- cv03: `i` 去除底部横杠
- cv04: `l` 底部带有横杠, 和 consolas 一样, 在斜体中将被 `cv35` 覆盖

#### 斜体独占
- cv31: 斜体 `a` 顶部带有横杠
- cv32: 斜体 `f` 去除底部尾巴，和常规体一样
- cv33: 斜体 `i j` 带有底部横杠和水平的顶部横杠，和常规体一样
- cv34: 斜体 `k` 去除中间的圆圈，和常规体一样
- cv35: 斜体 `l` 去除中间的尾巴，和常规体一样
- cv36: 斜体 `x` 去除顶部和底部的尾巴，和常规体一样
- cv37: 斜体 `y` 中间笔直的交叉，和常规体一样

#### 中文独占

- cv96: 全宽的 `“`(前双引号), `”`(后双引号), `‘`(前单引号), `’`(后单引号)
- cv97: 全宽的 `…`(省略号)
- cv98: 全宽的 `—`(破折号)
- cv99: 繁体的标点（居中）

### 样式集 (ssXX)

- ss01: 分离的等号连字 (`==`, `===`, `!=`, `!==`, `=/=`)
- ss02: 分离的比较连字 (`<=`, `>=`)
- ss03: 启用任意的纯文本标签 (在标签中支持使用任意大小写字母)
- ss04: 分离的多下划线连字 (`__`, `#__`)
- ss05: 在转义字符中显示正常粗细的转义符号 (`\\`, `\"`, `\,` ...)
- ss06: 去除斜体的连笔 (`al`, `ul`, `il` ...)
- ss07: 放宽启用多个大于号连字的条件 (`>>` or `>>>`)
- ss08: 启用双箭头和反向箭头连字 (`>>=`, `-<<`, `->>`, `>-` ...)
