/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.quickshulker.util;

import com.google.common.collect.Sets;
import java.util.Set;
import net.fabricmc.fabric.mixin.screen.ScreenAccessor;
import net.kyrptonaught.quickshulker.QuickShulkerMod;
import net.kyrptonaught.quickshulker.api.Util;
import net.kyrptonaught.quickshulker.mixin.HandledScreenInvoker;
import net.kyrptonaught.shulkerutils.ShulkerUtils;
import net.minecraft.class_11909;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_465;

public class MouseDraggedHandler {
    private static DragMode dragMode;
    private static final Set<class_1735> DRAGGED_SLOTS;

    public static boolean canInsertIntoContainer(class_1657 player, class_1799 hostStack, class_1799 insertStack) {
        class_1263 inv = Util.getQuickItemInventory(player, hostStack);
        if (inv == null) {
            return false;
        }
        for (int i = inv.method_5439() - 1; i >= 0; --i) {
            class_1799 pickStack = inv.method_5438(i);
            if (!pickStack.method_7960() && (!class_1799.method_31577((class_1799)pickStack, (class_1799)insertStack) || pickStack.method_7947() >= pickStack.method_7914())) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainerEmpty(class_1657 player, class_1799 hostStack) {
        class_1263 inv = Util.getQuickItemInventory(player, hostStack);
        if (inv != null) {
            return inv.method_5442();
        }
        return true;
    }

    public static boolean beforeMouseClick(class_465<?> screen, class_11909 click) {
        if (!QuickShulkerMod.getConfig().supportsMouseDragged) {
            return false;
        }
        class_1735 slot = ((HandledScreenInvoker)screen).QS$getSlotAt(click.comp_4798(), click.comp_4799());
        if (slot != null && click.method_74245() == 1) {
            class_310 client = ((ScreenAccessor)screen).getClient();
            class_1799 itemStack = screen.method_17577().method_34255();
            class_1263 inv = Util.getQuickItemInventory((class_1657)client.field_1724, itemStack);
            if (inv == null) {
                return false;
            }
            dragMode = slot.method_7681() ? DragMode.BUNDLE : DragMode.UNBUNDLE;
            DRAGGED_SLOTS.clear();
            return true;
        }
        return false;
    }

    public static boolean beforeMouseDragged(class_465<?> screen, class_11909 click) {
        if (!QuickShulkerMod.getConfig().supportsMouseDragged) {
            return false;
        }
        boolean result = false;
        if (dragMode != null) {
            class_310 client = ((ScreenAccessor)screen).getClient();
            class_1703 handler = screen.method_17577();
            class_1799 itemStack = handler.method_34255();
            if (click.method_74245() != 1) {
                dragMode = null;
                DRAGGED_SLOTS.clear();
                return false;
            }
            class_1735 slot = ((HandledScreenInvoker)screen).QS$getSlotAt(click.comp_4798(), click.comp_4799());
            if (slot != null && (handler.method_7615(slot) || slot.method_7674((class_1657)client.field_1724))) {
                if (dragMode == DragMode.BUNDLE) {
                    if (slot.method_7681() && MouseDraggedHandler.canInsertIntoContainer((class_1657)client.field_1724, itemStack, slot.method_7677()) && !ShulkerUtils.isShulkerItem(slot.method_7677()) && !DRAGGED_SLOTS.contains(slot)) {
                        DRAGGED_SLOTS.add(slot);
                        ((HandledScreenInvoker)screen).QS$onMouseClick(slot, slot.field_7874, click.method_74245(), class_1713.field_7790);
                        result = true;
                    }
                } else if (!(slot.method_7681() || MouseDraggedHandler.isContainerEmpty((class_1657)client.field_1724, itemStack) || DRAGGED_SLOTS.contains(slot))) {
                    DRAGGED_SLOTS.add(slot);
                    ((HandledScreenInvoker)screen).QS$onMouseClick(slot, slot.field_7874, click.method_74245(), class_1713.field_7790);
                    result = true;
                }
            }
        }
        return result;
    }

    public static boolean beforeMouseReleased(class_465<?> screen, class_11909 click) {
        if (!QuickShulkerMod.getConfig().supportsMouseDragged) {
            return false;
        }
        if (dragMode != null) {
            dragMode = null;
            if (click.method_74245() == 1 && !DRAGGED_SLOTS.isEmpty()) {
                DRAGGED_SLOTS.clear();
                return true;
            }
        }
        return false;
    }

    public static void beforeDrawForeground(class_465<?> screen, class_332 context, int mouseX, int mouseY) {
        class_1703 handler = screen.method_17577();
        for (class_1735 slot : handler.field_7761) {
            if (!DRAGGED_SLOTS.contains(slot)) continue;
            context.method_25294(slot.field_7873, slot.field_7872, slot.field_7873 + 16, slot.field_7872 + 16, -2130706433);
        }
    }

    static {
        DRAGGED_SLOTS = Sets.newHashSet();
    }

    private static enum DragMode {
        BUNDLE,
        UNBUNDLE;

    }
}

